#!/usr/bin/env perl

use strict;
use warnings;
use v5.30;

use PDK::Device::H3c;
use PDK::Device::Cisco;
use PDK::Concern::Netdisco::H3c;
use PDK::Concern::Netdisco::Cisco;
use Data::Dumper;
use Data::Printer;

my $config = <<H3C;
<SZX9-MG-SW01>display lldp neighbor-information list | include GE
Chassis ID : * -- -- Nearest nontpmr bridge neighbor
             # -- -- Nearest customer bridge neighbor
             Default -- -- Nearest bridge neighbor
Local Interface Chassis ID      Port ID                    System Name
GE1/0/3         60da-83b3-1aba  GigabitEthernet1/0/47      SZX9-MG-SW03
GE1/0/4         60da-83b3-469a  GigabitEthernet1/0/47      SZX9-MG-SW04
GE1/0/5         60da-83b3-19fa  GigabitEthernet1/0/47      SZX9-MG-SW05
GE1/0/6         60da-83b3-283a  GigabitEthernet1/0/47      SZX9-MG-SW06
GE1/0/7         0c3a-fa73-ad18  GigabitEthernet1/0/47      SZX9-MG-SW07
GE1/0/9         60da-83b3-205a  GigabitEthernet1/0/47      SZX9-MG-SW09
GE1/0/10        60da-83b3-145a  GigabitEthernet1/0/47      SZX9-MG-SW02
GE1/0/17        10b3-d6cb-8d20  mgmt0                      SZX9-BDR01.transsion.com
GE1/0/18        a478-068e-d488  mgmt0                      SZX9-SPN01.transsion.com
GE1/0/47        60da-83ae-44e0  GigabitEthernet2/0/47      SZX9-23F-PSW01
GE1/0/48        3c51-0e39-85d7  Ethernet1/48               SZX9-LEF03
XGE1/0/49       28e4-24bc-f000  Ten-GigabitEthernet1/2/0/2 SZX9-CSW01
XGE1/0/51       60da-83b2-bbda  Ten-GigabitEthernet2/0/51  SZX9-MG-SW01
XGE1/0/52       60da-83b2-bbda  Ten-GigabitEthernet2/0/52  SZX9-MG-SW01
GE2/0/3         60da-83b3-1aba  GigabitEthernet1/0/48      SZX9-MG-SW03
GE2/0/4         60da-83b3-469a  GigabitEthernet1/0/48      SZX9-MG-SW04
GE2/0/5         60da-83b3-19fa  GigabitEthernet1/0/48      SZX9-MG-SW05
GE2/0/6         60da-83b3-283a  GigabitEthernet1/0/48      SZX9-MG-SW06
GE2/0/7         0c3a-fa73-ad18  GigabitEthernet1/0/48      SZX9-MG-SW07
GE2/0/9         60da-83b3-205a  GigabitEthernet1/0/48      SZX9-MG-SW09
GE2/0/10        60da-83b3-145a  GigabitEthernet1/0/48      SZX9-MG-SW02
GE2/0/17        ecc0-18ef-8300  mgmt0                      SZX9-BDR02
XGE2/0/49       28e4-24bc-f000  Ten-GigabitEthernet2/2/0/2 SZX9-CSW01
XGE2/0/51       60da-83b2-bbda  Ten-GigabitEthernet1/0/51  SZX9-MG-SW01
XGE2/0/52       60da-83b2-bbda  Ten-GigabitEthernet1/0/52  SZX9-MG-SW01
H3C

my @config = split(/\n/, $config);
say Dumper @config;

my $d = PDK::Device::H3c->new(host => 'fake');
my $nd = PDK::Concern::Netdisco::H3c->new(device => $d, debug => 1);
say Dumper $nd->gen_iface_desc(\@config);
