/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.ttt.salt.Configuration;
import org.ttt.salt.TBXFile;
import org.ttt.salt.gui.TBXAbstractAction;
import org.ttt.salt.gui.TBXResults;

public class ActionOpen
extends TBXAbstractAction
implements FilenameFilter {
    public static final String RCSID = "$Id: ActionOpen.java 123 2010-06-23 01:51:03Z lanhel $";
    private static final String DIRECTORY = "ActionOpen_Directory";
    private Formatter formatter;
    private Handler handler;
    private Level level;
    private boolean checkXmlLang = true;
    private ByteArrayOutputStream logbuffer;

    public ActionOpen() {
        super("ActionOpen");
        try {
            this.logbuffer = new ByteArrayOutputStream();
            this.formatter = new LogFormatter();
            this.handler = new StreamHandler(this.logbuffer, this.formatter);
            this.handler.setLevel(Level.FINEST);
            this.handler.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            err.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ActionOpen")) {
            FileDialog d = new FileDialog(JOptionPane.getRootFrame(), this.getResourceBundle().getString("ActionOpenFileDialogTitle"), 0);
            Preferences pref = Preferences.userNodeForPackage(this.getClass());
            d.setDirectory(pref.get(DIRECTORY, System.getProperty("user.home")));
            d.setFilenameFilter(this);
            d.setVisible(true);
            pref.put(DIRECTORY, d.getDirectory());
            if (d.getFile() == null) return;
            File file = new File(d.getDirectory(), d.getFile());
            Object[] args = new Object[]{file};
            if (!file.exists()) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(this.getResourceBundle().getString("PathMissing"), args), this.getResourceBundle().getString("PathMissingTitle"), 0);
                return;
            }
            if (!file.isFile()) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(this.getResourceBundle().getString("PathNotNormalFile"), args), this.getResourceBundle().getString("PathNotNormalFileTitle"), 0);
                return;
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(this.getResourceBundle().getString("PathSecurityViolation"), args), this.getResourceBundle().getString("PathSecurityViolationTitle"), 0);
                return;
            }
            this.logbuffer.reset();
            Logger.getLogger("org.ttt.salt").addHandler(this.handler);
            Logger.getLogger("org.ttt.salt").setLevel(this.level);
            Logger.getLogger("org.ttt.salt.dom.tbx").setLevel(this.level);
            Logger.getLogger("org.ttt.salt.dom.xcs").setLevel(this.level);
            TBXFile dv = null;
            try {
                Configuration config = new Configuration();
                config.setCheckLang(this.checkXmlLang);
                dv = new TBXFile(file.toURI().toURL(), config);
                dv.parseAndValidate();
                if (!dv.isValid()) return;
                JOptionPane.showMessageDialog(null, MessageFormat.format(this.getResourceBundle().getString("FileValid"), args), this.getResourceBundle().getString("FileValidTitle"), 1);
                return;
            }
            catch (IOException err) {
                String msg = MessageFormat.format(this.getResourceBundle().getString("IOException"), err.getLocalizedMessage(), file);
                JOptionPane.showMessageDialog(null, msg, this.getResourceBundle().getString("IOExceptionTitle"), 0);
                return;
            }
            catch (Throwable err) {
                String msg = MessageFormat.format(this.getResourceBundle().getString("UnknownError"), err.getLocalizedMessage(), file);
                JOptionPane.showMessageDialog(null, msg, this.getResourceBundle().getString("UnknownErrorTitle"), 0);
                System.err.format("Unknown error for file %s%n", file);
                err.printStackTrace();
                return;
            }
            finally {
                try {
                    this.handler.flush();
                    String log = this.logbuffer.toString("UTF-8");
                    Logger.getLogger("org.ttt.salt").removeHandler(this.handler);
                    new TBXResults(file, dv, log);
                }
                catch (UnsupportedEncodingException err) {
                    err.printStackTrace();
                }
            }
        }
        if (e.getActionCommand().equals("NoLangCheckChanged")) {
            JCheckBox check = (JCheckBox)e.getSource();
            this.checkXmlLang = !check.isSelected();
            return;
        }
        if (!e.getActionCommand().equals("comboBoxChanged")) return;
        try {
            JComboBox cbox = (JComboBox)e.getSource();
            String selstr = (String)cbox.getSelectedItem();
            this.level = Level.parse(selstr);
            return;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return;
        }
        catch (IllegalArgumentException err) {
            err.printStackTrace();
        }
    }

    public boolean accept(File dir, String name) {
        return name.matches(".+?\\.((xml)|(XML)|(tbx)|(TBX))");
    }

    private class LogFormatter
    extends Formatter {
        private StringBuilder builder = new StringBuilder();

        private LogFormatter() {
        }

        public String format(LogRecord record) {
            String fmt;
            String errmsg = "";
            if (record.getThrown() != null) {
                fmt = "#%3$2d  %4$s---[%1$s#%2$s] %5$s%n\tException: %6$s%n";
                errmsg = record.getThrown().getLocalizedMessage();
            } else {
                fmt = record.getLevel().intValue() > Level.FINE.intValue() ? "#%3$2d  %4$s---%5$s%n" : "#%3$2d  %4$s---[%1$s#%2$s] %5$s%n";
            }
            return String.format(fmt, record.getSourceClassName(), record.getSourceMethodName(), record.getSequenceNumber(), record.getLevel().getLocalizedName(), this.formatMessage(record), errmsg);
        }
    }
}

