/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.ttt.salt.Configuration;
import org.ttt.salt.InvalidLanguageException;
import org.ttt.salt.InvalidLevelsException;
import org.ttt.salt.InvalidPickListException;
import org.ttt.salt.InvalidSpecificationException;
import org.ttt.salt.UnknownSpecificationException;
import org.ttt.salt.XCSValidationException;
import org.ttt.salt.dom.xcs.XCSElement;
import org.ttt.salt.dom.xcs.XCSParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCSDocument
extends DocumentImpl
implements Document {
    public static final String RCSID = "$Id: XCSDocument.java 147 2012-06-02 14:37:43Z lanhel $";
    private static final Logger LOGGER = Logger.getLogger("org.ttt.salt");
    public static final String PREFIX = "org.ttt.salt.dom.xcs.Element_";
    private static final Set<String> XCS_TAGS = new HashSet<String>();
    private static final Set<String> XCS_PARENTS = new HashSet<String>();
    private static final Set<String> LEVELS_CHECK = new HashSet<String>();
    private final Date created = new Date();
    private Configuration config;
    private SortedMap<String, String> languages;
    private final Map<Key, Element> specNodes = new HashMap<Key, Element>();
    private final Map<Key, Set<String>> levels = new HashMap<Key, Set<String>>();
    private final Map<String, SortedSet<String>> typeSets = new HashMap<String, SortedSet<String>>();

    public XCSDocument() {
    }

    public XCSDocument(String xcsURI, EntityResolver resolver, Configuration c) throws IOException, ParserConfigurationException, SAXException {
        this.config = c;
        try {
            LOGGER.info("Parsing XCS file: " + xcsURI);
            InputSource source = resolver.resolveEntity(xcsURI, xcsURI);
            XCSParser parser = new XCSParser(resolver);
            parser.parse(this, source);
            this.languages = this.buildLangMap();
            LOGGER.info("Success");
        }
        catch (SAXParseException err) {
            LOGGER.severe(String.format("SAXParseException on XCS URI: XCSName %s", xcsURI));
            LOGGER.log(Level.FINE, "SAXParseException on XCS URI in org.ttt.salt.XCSDocument", err);
            String msg = String.format("The XCS file '%s' is invalid. It failed XML validation.", xcsURI);
            throw new SAXParseException(msg, err.getPublicId(), err.getSystemId(), err.getLineNumber(), err.getColumnNumber(), err);
        }
        catch (SAXException err) {
            LOGGER.severe(String.format("SAXException on XCS URI: XCSName %s", xcsURI));
            LOGGER.log(Level.FINE, "SAXException on XCS URI in org.ttt.salt.XCSDocument", err);
            throw err;
        }
    }

    public XCSElement createXCSElement(String tagName, Locator loc) throws SAXParseException {
        if (this.errorChecking && !XCSDocument.isXMLName(tagName, true)) {
            super.createElement(tagName);
        }
        XCSElement ret = null;
        try {
            try {
                Class<?> clazz = Class.forName(PREFIX + tagName, true, this.getClass().getClassLoader());
                Constructor<?> cstrct = clazz.getConstructor(XCSDocument.class, String.class, Locator.class);
                ret = (XCSElement)cstrct.newInstance(this, tagName, loc);
            }
            catch (ClassNotFoundException err) {
                if (!XCSParser.KNOWN_MISSING.contains(tagName)) {
                    Logger.getLogger("org.ttt.salt.dom.xcs").log(Level.INFO, "Unknown XCS Element: {0}", tagName);
                }
                ret = new XCSElement(this, tagName, loc);
            }
            if (tagName.equals("TBXXCS")) {
                this.docElement = ret;
            }
        }
        catch (NoSuchMethodException err) {
            Logger.getLogger("org.ttt.salt.dom.xcs").log(Level.SEVERE, "Invalid XCS Class: {0}", tagName);
            throw new SAXParseException("Invalid XCS Class", loc, err);
        }
        catch (InstantiationException err) {
            Logger.getLogger("org.ttt.salt.dom.xcs").log(Level.SEVERE, "XCS class not concrete: {0}", tagName);
            throw new SAXParseException("XCS class not concrete", loc, err);
        }
        catch (IllegalAccessException err) {
            Logger.getLogger("org.ttt.salt.dom.xcs").log(Level.SEVERE, "XCS constructor not accessible on {0}", tagName);
            throw new SAXParseException("XCS constructor not accessible", loc, err);
        }
        catch (InvocationTargetException err) {
            Logger.getLogger("org.ttt.salt.dom.xcs").log(Level.SEVERE, "XCS element {0} creation error", tagName);
            throw new SAXParseException("XCS element creation error", loc, err);
        }
        return ret;
    }

    @Override
    public Element createElement(String tagName) {
        try {
            return this.createXCSElement(tagName, null);
        }
        catch (SAXParseException err) {
            throw new IllegalStateException(String.format("Error creating XCSElement: %s", tagName), err);
        }
    }

    public String getXCSName() {
        Element root = this.getDocumentElement();
        return root.getAttribute("name");
    }

    public String getXCSVersion() {
        Element root = this.getDocumentElement();
        return root.getAttribute("version");
    }

    public String getXCSLang() {
        Element root = this.getDocumentElement();
        return root.getAttribute("lang");
    }

    public String getXCSTitle() {
        String ret = "";
        Element root = this.getDocumentElement();
        Element header = (Element)root.getElementsByTagName("header").item(0);
        Element title = (Element)header.getElementsByTagName("title").item(0);
        for (Node node = title.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            ret = ((Text)node).getWholeText();
            break;
        }
        return ret;
    }

    public SortedMap<String, String> getLanguages() {
        return this.languages;
    }

    public SortedSet<String> getSpecTypes(String tag, String parenttag) {
        SortedSet<String> ret = this.typeSets.get(tag);
        if (ret == null) {
            ret = new TreeSet<String>();
            Element datcat = this.getNamedElement(this.getDocumentElement(), "datCatSet", 0);
            NodeList nl = datcat.getElementsByTagName(tag + "Spec");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem = (Element)nl.item(i);
                ret.add(elem.getAttribute("name"));
            }
            this.typeSets.put(tag, ret);
        }
        return ret;
    }

    public static boolean isXcsTag(String tag) {
        return XCS_TAGS.contains(tag);
    }

    public boolean hasSpec(Key key) {
        return this.specNodes.containsKey(key) || this.getSpec(key) != null;
    }

    public Element getSpec(Key key) {
        Element ret = this.specNodes.get(key);
        if (ret == null) {
            Element datcat = this.getNamedElement(this.getDocumentElement(), "datCatSet", 0);
            NodeList nl = datcat.getElementsByTagName(key.getSpecName());
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem = (Element)nl.item(i);
                String name = elem.getAttribute("name");
                if (!name.equals(key.getType())) continue;
                this.specNodes.put(key, elem);
                ret = elem;
                break;
            }
        }
        return ret;
    }

    public void validateXCSElement(Element elem) throws XCSValidationException {
        String name = elem.getTagName();
        if (!XCSDocument.isXcsTag(name)) {
            throw new IllegalArgumentException("Element is not a XCS element: " + name);
        }
        String parent = elem.getParentNode().getNodeName();
        Key key = new Key(name, elem.getAttribute("type"));
        if (!this.hasSpec(key)) {
            throw new UnknownSpecificationException(elem);
        }
        this.doesElementMatchSpec(elem, key);
        this.isElementAtProperLevel(elem, key);
    }

    public void validateTermEntry(Element elem) throws XCSValidationException {
        if (!elem.getTagName().equals("termEntry")) {
            throw new IllegalArgumentException("Element is not a termEntry: " + elem.getTagName());
        }
        this.validateTermEntry0(elem);
    }

    private void validateTermEntry0(Element elem) throws XCSValidationException {
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String lang;
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            String name = e.getTagName();
            if (XCSDocument.isXcsTag(name)) {
                this.validateXCSElement(e);
            } else {
                this.validateTermEntry0(e);
            }
            if (!this.config.getCheckLang() || !(elem.hasAttribute("xml:lang") ? !this.languages.containsKey(lang = elem.getAttribute("xml:lang")) : elem.hasAttribute("lang") && !this.languages.containsKey(lang = elem.getAttribute("lang")))) continue;
            throw new InvalidLanguageException(elem);
        }
    }

    private void doesElementMatchSpec(Element elem, Key key) throws XCSValidationException {
        try {
            if (!XCS_PARENTS.contains(elem.getNodeName())) {
                String name = "check_" + this.getDataType(key);
                Class[] parm = new Class[]{Class.forName("org.w3c.dom.Element")};
                Method meth = this.getClass().getDeclaredMethod(name, parm);
                Object[] args = new Object[]{elem};
                meth.invoke((Object)this, args);
            }
        }
        catch (NoSuchMethodException err) {
            throw new IllegalStateException("Unknown data type: " + key.getType() + " in tag <" + key.getTag() + ">");
        }
        catch (InvocationTargetException err) {
            Throwable t = err.getTargetException();
            if (t instanceof XCSValidationException) {
                throw (XCSValidationException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw new UnsupportedOperationException("Unknown Exception: " + t.getClass().getName() + ").");
            }
        }
        catch (Throwable err) {
            throw new UnsupportedOperationException("Caught " + err.getClass().getName());
        }
    }

    public String getPosition(Key key) {
        Element spec = this.getSpec(key);
        return spec.getAttribute("datcatId");
    }

    public String getDataType(Key key) {
        Element contents = this.getContents(key);
        String ret = contents.getAttribute("datatype");
        if ("".equals(ret)) {
            ret = "basicText";
        }
        return ret;
    }

    public String getTargetType(Key key) {
        Element contents = this.getContents(key);
        return contents.getAttribute("targetType");
    }

    public Set<String> getPicklist(Key key) {
        HashSet<String> ret = new HashSet<String>();
        Element contents = this.getContents(key);
        if (!contents.getAttribute("datatype").equals("picklist")) {
            throw new IllegalStateException("datatype != picklist");
        }
        String val = contents.getTextContent();
        StringTokenizer tok = new StringTokenizer(val);
        while (tok.hasMoreElements()) {
            ret.add(tok.nextToken());
        }
        return ret;
    }

    public boolean isForTermComp(Key key) {
        throw new UnsupportedOperationException();
    }

    public String getComment(Key key) {
        throw new UnsupportedOperationException();
    }

    public Element getContents(Key key) {
        Element spec = this.getSpec(key);
        NodeList nl = spec.getElementsByTagName("contents");
        return (Element)nl.item(0);
    }

    private void isElementAtProperLevel(Element elem, Key key) throws XCSValidationException {
        if (LEVELS_CHECK.contains(key.getTag())) {
            Set<String> lvls = this.getLevels(key);
            if (lvls == null) {
                throw new IllegalStateException("Invalid XCS key for levels");
            }
            Element pp = elem;
            while (!pp.getTagName().equals("body")) {
                String tag = pp.getTagName();
                if (tag.equals("ntig") || tag.equals("tig")) {
                    if (lvls.contains("term")) break;
                    throw new InvalidLevelsException(elem);
                }
                if (tag.equals("langSet")) {
                    if (lvls.contains("langSet")) break;
                    throw new InvalidLevelsException(elem);
                }
                if (tag.equals("termEntry")) {
                    if (lvls.contains("termEntry")) break;
                    throw new InvalidLevelsException(elem);
                }
                pp = (Element)pp.getParentNode();
            }
        }
    }

    private Set<String> getLevels(Key key) {
        String tag = key.getTag();
        if (!this.levels.containsKey(key)) {
            Element spec = this.getSpec(key);
            StringBuffer buf = new StringBuffer();
            NodeList nodes = spec.getElementsByTagName("levels");
            Element lvlselem = (Element)nodes.item(0);
            String levelstr = lvlselem.getTextContent();
            String[] lvls = levelstr.split("\\s+");
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < lvls.length; ++i) {
                set.add(lvls[i]);
            }
            if (set.isEmpty()) {
                set.add("termEntry");
                set.add("langSet");
                set.add("term");
            }
            this.levels.put(key, Collections.unmodifiableSet(set));
        }
        return this.levels.get(key);
    }

    private SortedMap<String, String> buildLangMap() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        Element langs = this.getNamedElement(this.getDocumentElement(), "languages", 0);
        if (langs != null) {
            NodeList langInfos = langs.getElementsByTagName("langInfo");
            for (int i = 0; i < langInfos.getLength(); ++i) {
                Element langInfo = (Element)langInfos.item(i);
                Element langCodeElem = this.getNamedElement(langInfo, "langCode", 0);
                Text langCode = this.getTextNode(langCodeElem, 0);
                Element langNameElem = this.getNamedElement(langInfo, "langName", 0);
                Text langName = this.getTextNode(langNameElem, 0);
                ret.put(langCode.getData(), langName.getData());
            }
        }
        return Collections.unmodifiableSortedMap(ret);
    }

    private Element getNamedElement(Element elem, String name, int index) {
        Element ret = null;
        NodeList nl = elem.getElementsByTagName(name);
        if (nl.getLength() > index && nl.item(index) instanceof Element) {
            ret = (Element)nl.item(index);
        }
        return ret;
    }

    private Text getTextNode(Element elem, int index) {
        Node node;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) {
                --index;
            }
            if (index < 0) break;
        }
        return (Text)node;
    }

    private void check_geoList(Element elem) throws XCSValidationException {
        throw new UnsupportedOperationException("geoList");
    }

    private void check_picklist(Element elem) throws XCSValidationException {
        String pick;
        Key key = new Key(elem.getTagName(), elem.getAttribute("type"));
        Set<String> picklist = this.getPicklist(key);
        if (!picklist.contains(pick = elem.getTextContent())) {
            throw new InvalidPickListException(elem, pick);
        }
    }

    private void check_plainText(Element elem) throws XCSValidationException {
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) continue;
            throw new InvalidSpecificationException(elem);
        }
    }

    private void check_basicText(Element elem) throws XCSValidationException {
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String name;
            if (node.getNodeType() == 3 || node.getNodeType() != 1 || (name = node.getNodeName()).equals("hi")) continue;
            throw new InvalidSpecificationException(elem);
        }
    }

    private void check_noteText(Element elem) throws XCSValidationException {
        boolean ret = true;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean valid;
            if (node.getNodeType() == 3 || node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            boolean bl = valid = name.equals("hi") || name.equals("foreign") || name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("ut");
            if (valid) continue;
            throw new InvalidSpecificationException(elem);
        }
    }

    private void check_elements(Element elem) throws XCSValidationException {
        throw new UnsupportedOperationException("elements");
    }

    static {
        XCS_TAGS.add("admin");
        XCS_TAGS.add("adminNote");
        XCS_TAGS.add("descrip");
        XCS_TAGS.add("descripNote");
        XCS_TAGS.add("ref");
        XCS_TAGS.add("termCompList");
        XCS_TAGS.add("termNote");
        XCS_TAGS.add("transac");
        XCS_TAGS.add("transacNote");
        XCS_TAGS.add("xfef");
        XCS_TAGS.add("refObjectList");
        XCS_TAGS.add("item");
        XCS_TAGS.add("itemSet");
        XCS_PARENTS.add("termCompList");
        LEVELS_CHECK.add("descrip");
    }

    public static class Key
    implements Comparable {
        private String tag;
        private String type;
        private String value;

        public Key(String tg, String tp) {
            this.tag = tg;
            this.type = tp;
            this.value = this.tag + "%" + this.type;
        }

        public String getSpecName() {
            return this.tag + "Spec";
        }

        public String getTag() {
            return this.tag;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            boolean ret;
            boolean bl = ret = this == obj;
            if (!ret && obj instanceof Key) {
                Key o = (Key)obj;
                ret = this.value.equals(o.value);
            }
            return ret;
        }

        public int compareTo(Object obj) {
            throw new UnsupportedOperationException();
        }
    }
}

