#!/usr/bin/env perl

use 5.008;

use strict;
use warnings;

use Test::More;
use Test2::API qw/intercept/;

use Test::Approximate;

my $ev = intercept { is_approx 1,2 };

my $sif = $ev->squash_info->flatten;
is scalar @$sif, 1, "one event generated";
ok $sif->[0]->{causes_failure}, "and it was a fail";
ok exists $sif->[0]->{diag}, "there are diagnostics";
is scalar @{$sif->[0]->{diag}}, 2, "two of them";

my $this = quotemeta $0;
like $sif->[0]->{diag}->[0], qr{$this}, "fail message refers to correct file";

done_testing;
