# Win-Loss Matrix

Condorcet Pairwise Methods require a Win-Loss Matrix. This object takes an RCV BallotSet with an optional Active list and returns the Matrix as an Object. The Ojbect is capable of Scoring itself, Calculating a Smith Set, and identifying Condorcet Winners and Losers.

# SYNOPSIS

```
my $Matrix =
  Vote::Count::Matrix->new(
    'BallotSet' => $myVoteCount->BallotSet() );
  my $Scores = $Matrix->ScoreMatrix();
  my %DominantSet = $Matrix->SmithSet()->%*;
  my $CondorcetWinner = $Matrix->CondorcetWinner();
```

## new

Parameters:

### BallotSet (required)

A Ballot Set reference as generated by ReadBallots, which can be retrieved from a Vote::Count object via the ->BallotSet() method.

### BallotSetType (future use)

Defaults to rcv. Currently rcv is the only type supported. In the future the Matrix may be able to deal directly with Range Ballots.

### Active (optional)

A hash reference with active choices as the keys. The default value is all of the choices defined in the BallotSet.

### Logging (optional)

Has the logging methods of Vote::Count::Log.

# Methods

## MatrixTable

Returns a MarkDown formatted table with the wins losses and ties for each Active Choice as text.

## PairingVotesTable

Returns a MarkDown formatted table with the votes for all of the pairings.

## GetPairResult ( $A, $B )

Returns the results of the pairing of two choices as a hashref.

```
  {
   'FUDGESWIRL' =>  6,
   'loser'      =>  "STRAWBERRY",
   'margin'     =>  2,
   'STRAWBERRY' =>  4,
   'tie'        =>  0,
   'winner'     =>  "FUDGESWIRL"
  }
```

## GetPairWinner ( $A, $B )

Returns the winner of the pairing of two choices. If there is no Winner it returns a false value (empty string).

## ScoreMatrix

Returns a HashRef of the choices and their Matrix Scores. The scoring is 1 for each win, 0 for losses and ties. In the event a choice has ties but no wins their score will be .001. Where N is the number of choices, a Condorcet Winner will have a score of N-1, a Condorcet Loser will have a score of 0. Since a choice with at least one tie but no wins is not defeated by all other choices they are not a Condorcet Loser, and thus those cases are scored with a near to zero value instead of 0. Methods that wish to treat no wins but tie case as a Condorcet Loser may test for a score less than 1.

## ScoreTable

Returns the ScoreMatrix as a markdown compatible table.

## LeastWins

Returns an array of the choice or choices with the fewest wins.

## CondorcetLoser

Eliminates all Condorcet Losers from the Matrix Object's Active list. Returns a hashref. Takes an optional true false argument (default is false) to include choices that have tied but not won in the elimination.

```
  {
    verbose => 'verbose message',
    terse   => 'terse message',
    eliminated => [ eliminated choices ],
    eliminations => number of eliminated choices,
  };
```

## CondorcetWinner

Returns either the Condorcet Winner or an empty string if there is none.

## SmithSet

Finds the innermost Smith Set (Dominant Set). [ assistance in finding proof of the algorithm used would be appreciated so it could be correctly referenced in this documentation ]. A Dominant Set is a set which defeats all choices outside of that set. The inner Smith Set is the smallest possible Dominant Set.

Returns a hashref with the keys as the choices of the Smith Set.

## ResetActive

Reset Active list to the choices list of the BallotSet.

## GreatestLoss

Returns the greatest loss for a choice `$MyMatrix->GreatestLoss( $A )`.

## RankGreatestLoss

Returns a RankCount object of the Greatest Loss for each choice.

