package CGIx::Core::Request;

=head2 query_params

Return a value set by the GET method or 0 on failure.

    if ($c->query_params('name')) { $c->stash(name => $c->query_params('name'); }
    else { $c->stash(name => 'Anonymous'); }

=cut

sub query_params {
    my ($self, $key) = @_;

    if (exists $self->{query_params}->{$key}) {
        return $self->{query_params}->{$key};
    }
    else { return 0; }
}

sub body_params {
    my ($self, $key) = @_;

    if (exists $self->{body_params}->{$key}) {
        return $self->{body_params}->{$key};
    }
    else { return 0; }
}

1;
