package Task::MetaSyntactic;
{
  $Task::MetaSyntactic::VERSION = '1.027';
}

use strict;

'whack_eth';



=pod

=head1 NAME

Task::MetaSyntactic - All Acme::MetaSyntactic themes at once

=head1 VERSION

version 1.027

=head1 SYNOPSIS

    cpan Task::MetaSyntactic

    cpanp -i Task::MetaSyntactic

    cpanm Task::MetaSyntactic

=head1 DESCRIPTION

L<Acme::MetaSyntactic> is a module designed to fill all your metasyntactic
needs. There was a weekly update with new themes on CPAN between January
15, 2005 and November 6, 2006.

Since version 0.99, the weekly uploads of the module have stopped,
while I took some rest. I've also been looking for a better way to distribute
the core modules and the themes themselves.

However, some users of L<Acme::MetaSyntactic> desperately needed new
themes to be added, and grew tired of waiting for me. So, in a JFDI way,
they started to upload their own themes on CPAN.

On May 7, 2012, after a hiatus of five and a half years,
L<Acme::MetaSyntactic> is back, in a shiny version 1.000.
The main C<Acme-MetaSyntactic> distribution contains the core modules
and a single theme, while all "historical" themes now live in the
C<Acme-MetaSyntactic-Themes> distribution.

The L<Test::MetaSyntactic> module included in the main distribution
aims at simplifying the test and distribution of new themes by
individual authors.

This L<Task> (formerly a Bundle) installs all the official and not-so-official
L<Acme::MetaSyntactic> themes, in a single command (see the L<SYNOPSIS>).

=head1 CONTENTS

Acme::MetaSyntactic - Themed metasyntactic variables names

Acme::MetaSyntactic::Themes - The original Acme::MetaSyntactic themes

Acme::MetaSyntactic::Themes::Abigail - More themes by Abigail (ABIGAIL)

Acme::MetaSyntactic::buzzwords - Pointy-haired boss lingo (JQUELIN)

Acme::MetaSyntactic::daleks - EXTERMINATE! EXTERMINATE! EXTERMINATE! (SAPER)

Acme::MetaSyntactic::dune - For he is the Kwisatz Haderach! (MCARTMELL)

Acme::MetaSyntactic::errno - The Errno theme (BOOK)

Acme::MetaSyntactic::legobatman - LEGO Batman theme (BINGOS)

Acme::MetaSyntactic::legoharrypotter - LEGO Harry Potter theme (BINGOS)

Acme::MetaSyntactic::legoindianajones - LEGO Indiana Jones theme (BINGOS)

Acme::MetaSyntactic::legolotr - LEGO Lord of the Rings theme (BINGOS)

Acme::MetaSyntactic::legopiratesofthecaribbean - LEGO Pirates of the Caribbean theme (BINGOS)

Acme::MetaSyntactic::morning_musume - The Mumusu theme (ELBEHO)

Acme::MetaSyntactic::nethack - The largest time waster in the world of *nix (ELLIOTJS)

Acme::MetaSyntactic::soviet - NATO codenames for Soviet-designed equipment (JFORGET)

Acme::MetaSyntactic::vim - The vim theme (ELLIOTJS)

Acme::MetaSyntactic::xkcdcommon1949 - xkcd common wordlist for Acme::MetaSyntactic (MARKF)

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-MetaSyntactic or by email to
bug-task-metasyntactic@rt.cpan.org.

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Philippe Bruhat (BooK) <book@cpan.org>

=head1 COPYRIGHT

Copyright 2005-2013 Philippe Bruhat (BooK), All Rights Reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut


__END__

# ABSTRACT: All Acme::MetaSyntactic themes at once

