package Acme::MetaSyntactic::oulipo;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::oulipo - The Oulipo theme

=head1 DESCRIPTION

This theme contains the initials of the members of the French literary
group Oulipo, created by Raymond Queneau (RQ) and Franois Le Lionnais
(FLL) in 1960. These initials are commonly used in place of a member's
full name.

See the official Oulipo web site at L<http://www.oulipo.net/>.

=head1 CONTRIBUTOR

Philippe "BooK" Bruhat (co-creator of the first Oulipo web site, back
in 1995).

Introduced in Acme-MetaSyntactic version 0.28, published on June 27, 2005.

Updated with the new Oulipo members since 2007, and
received its own version number for Acme-MetaSyntactic-Themes version 1.000,
published on May 7, 2012.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
NA  MA  MB  VB  JB  CB  AB  PB  IC  FC  BC  RC
SC  MD  JD  LE  FF  PF  AFG MG  JJ  AL  FLL HLT
JL  DLB HM  MM  IM  OP  GP  RQ  JQ  PR  JR  OS
AMS
