package Acme::MetaSyntactic::haddock;
use strict;
use Acme::MetaSyntactic::Locale;
our @ISA = qw( Acme::MetaSyntactic::Locale );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::haddock - Tintin's Captain Haddock fierce expressions

=head1 DESCRIPTION

Captain Haddock's expressions from the comic-book I<Tintin et Milou>,
by Herg.

The French list comes from L<http://www.bdenvrac.com/doc/tinsultes.html>.

The English list was compiled 
from L<http://members.fortunecity.com/tintinsnowy/characters/abuses.html>
and L<http://www.tintinologist.org/guides/lists/curses.html>.

The Dutch list was extracted from
L<http://www.xs4all.nl/~janhee/haddock.html> by Jan Pieter Cornet.

Tintin was translated in many languages, please send my your lists.

=head1 CONTRIBUTORS

Jrme Fenal provided the original idea and the French and English lists.
Jan Pieter Cornet provided the Dutch list.

Introduced in Acme-MetaSyntactic version 0.16, published on April 4, 2005.

Updated with the Dutch list in version 0.59, published on January 30, 2006. 

Received its own version number for Acme-MetaSyntactic-Themes version 1.000,
published on May 7, 2012.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::Locale>.

=cut

__DATA__
# default
fr
# names fr
Accapareur Amiral_de_bateau_lavoir Amphitryon Anacoluthe
Analphabete Analphabete_diplome Anthropophage Anthropopitheque Apache
Apprenti_dictateur_a_la_noix_de_coco Arlequin Astronaute_d_eau_douce
Athlete_complet Autocrate Autodidacte Azteque Babouin Bachi_bouzouk
Bande_de_Ku_Klux_Klans Bandit Barbare Bayadere_de_carnaval Bibendum
Boit_sans_soif Bougre_de_creme_d_emplatre_a_la_graisse_de_herisson
Bougre_de_faux_jetons_a_la_sauce_tartare Bougre_de_jets_d_eau_ambulants
Bougre_de_malappris Bougre_de_sauvage Brontosaure Brute
Bulldozer_a_reaction Canaille Canaque Cannibale Cannibale_emplume
Casse_pieds Catachrese Cataplasme Cercopitheque Chauffard Chenapan
Cholera Chouette_mal_empaillee Cloporte Coleoptere Coloquinte Coquin
Cornemuse Cornichon Cornichon_diplome Corsaire Coupe_jarret Cow_boy
Creme_d_emplatre Cretin_de_l_Himalaya Cretin_des_Alpes Cretin_des_Balcans
Cromagnon Cyanure Cyclone Cyclotron Cyrano_a_quatre_pattes Demon
Diablesse Diplodocus Doryphore Dynamiteur Ecornifleur Ecraseur Ectoplasme
Ectoplasme_a_roulettes Egoiste Emplatre Emplatre_a_la_creme_de_herisson
Empoisonneur Energumene Enrage Epouvantail Esclavagiste Escogriffe Escroc
Espece_de_bayadere_de_carnaval Espece_de_projectile_guide Espece_de_zouave
Fatma_de_prisunic Faux_jeton Flibustier Flibustier_de_carnaval Forban
Freres_de_la_cote Froussard Galopin Gangster Garde_cote_a_la_mie_de_pain
Gargarisme Garnement Gibier_de_potence Gredin Grenouille
Gros_plein_de_soupe Grotesque_polichinelle Gyroscope Heretique Hors_la_loi
Hurluberlu Hydrocarbure Iconoclaste Invertebre Ivrogne Jet_d_eau_ambulant
Jocrisse Judas Jus_de_reglisse Khroumirs Lache Lascar Logarithme
Loup_garou_a_la_graisse_de_renoncule_de_mille_tonnerres_de_Brest Macaque
Macrocephale Malappris Malotru Mamelouk Marchand_de_tapis_ou_de_guano
Marin_d_eau_douce Megacycle Megalomane Mercanti Mercenaire Merinos
Merinos_mal_peigne Mille_marmottes Mille_millions_de_mille_sabords
Mille_sabords Mille_tonnerres Miserable Mitrailleur_a_bavette Mouchard
Moujiks Moule_a_gaufre Moussaillon Mufle Mussolini_de_carnaval
Naufrageur Negrier Noix_de_coco Nyctalope Olibrius Ophicleide
Ornithorynque Orycterope Ostrogoth Ours_mal_leche Pacte_a_quatre
Pantoufle Papou Papou_des_Carpathes Paranoiaque Parasite Patagon
Patapouf Patate Peaux_rouges Peronnelle Perroquet_bavard Phenomene
Phlebotome Phylloxera Pignouf Pirate_d_eau_douce Pirate_du_ciel Polygraphe
Porc_epic_mal_embouche Poussiere Profiteur Projectile_guide Protozoaire
Pyromane Pyrophore Que_le_grand_cric_me_croque Rapace Rat Ravachol
Renegat Rhizopode Rocambole Sacripant Sajou Saltimbanque Sapajou
Sapristi Satrape Sauvage Sauvage_d_aerolithe Scelerat Schizophrene
Scolopendre Scorpion Serpent Simili_Martien_a_la_graisse_de_cabestan
Sinapisme Soulographe Tchouck_tchouck_nougat Technocrate Terroriste
Tete_de_lard Tete_de_mule Tigresse Tonnerre_de_Brest Topinambour
Tortionnaire Trafiquant_de_chair_humaine Traine_potence Traitre
Troglodyte Trompe_la_mort Vampire Vandale Va_nu_pieds Vaurien
Vegetarien Vercingetorix_de_carnaval Ver_de_terre Vermicelle
Vermine Vieille_perruche_bavarde Vieux_cachalot Vipere Visigoth
Vivisectionniste Voleur Voleur_d_enfants Zapoteque Zebre Zigomar Zouave
Zouave_interplanetaire Zoulou
# names en
Aardvark Abecedarians Abominable_Snowman Aborigine
Addle_pated_lumps_of_anthracite Anachronisms Anacoluthon
Anacoluthons Anamorphic_aardvark Anthracite Anthropithecus
Anthropophagus Artichoke Artichokes Autocrats Aztecs Baboon Baboons
Baby_snatchers Bagpipers Bald_headed_budgerigar Balkan_beetle
Bandit Bandits Bashi_bazouk Bashi_bazouks Beast Beastly_things
Beasts Belemnite Billions_of_Bilious_Blue_Blistering_Barnacles
Billions_of_billious_barbecued_blue_blistering_barnacles
Billions_of_Blue_Blistering_Barnacles Blackamoor Black_beetles
Blackbird Blackguard Blackguards Black_marketeers Black_Marketers
Blistereing_blundering_birdbrain Blistering_Barnacles Bloodsuckers
Blue_blistering_barnacles Blue_Blistering_Bell_Bottomed_Balderdash
Blunderbuss Bodysnatcher Body_snatcher Bollard Bone_idle_builder
Bootlegger Borgia Bottled_bilge_water Bougainvillea Brat Breathalyser
Brigand Brigands Brontosaurus Brutes Bucaneers Buccaneer Bully
Butcher Butchers Cachinnating_cockatoo Cannibal Cannibals
Carpathian_caterpillar Carpet_seller Carpetsellers Caterpillars
Centipede Cercopithecus Cheat Clever_dick Cockleshell Coconuts
Coelacanth Coelcanth Coleoptera Colocynths Corsair Cowards Crabapples
Crab_apples Crackpot_contraption Cro_Magnon Crooks Cry_babies
ctatorial_duck_billed_diplodocus Cushion_footed_quadrupeds Cyclone
Cyclotron Diplodocus Dipsomaniac Dizzards Dogs Doryphore Doryphores
Duck_billed_platypus Dunderheaded_coconuts Dunder_headed_Ethelreds
Dynamiter Ectoplasm Ectoplasmic_by_product Ectoplasms Egoists
Fancy_dress_Facist Fancy_dress_Fatima Fancy_dress_freebooters Fatfaces
Fat_faces Filibuster Filibusters Flaming_Jack_in_a_box Fourlegged_Cyrano
Fraud Freshwater_spaceman Freshwater_swabs Fuzzy_wuzzy Gallows_fodder
Gang_of_Theives Gang_of_thieves Gangsters Gherkin Gibbering_anthropoids
Gibbering_ghost Gobbledgook Gobbledygook Gogglers Goosecaps Guano_gatherer
Gyroscope Harlequin Heretic Highwayman Hi_jackers Hooligans Hydrocarbon
Iconoclast Iconoclasts Infernal_mileage_merchants Interplanetary_goat
Interplanetary_pirate Invertebrate Jackanapes Jack_pudding Jellied_eel
Jellyfish Kleptomaniacs Ku_Klux_Klan Lily_livered_landlubbers Liquorice
Loathsome_brute Lubberscum Lubbery_scum Macrocephalic_baboon Mameluke
Meddlesome_cabin_boy Megalomaniac Miserable_blundering_barbecued_blister
Miserable_earthworms Miserable_earth_worms Miserable_miser
Miserable_molecule_of_mildew Misguided_missles Mister_Mule Monopolizers
Monster Morons Moth_eaten_marmot Moujik Moujiks Mountebanks
Mserable_blundering_barbequed_blister Mule Musical_morons Nanny_goat
Nincompoop Nitwits Nitwitted_ninepins Nitwitted_nine_pins Numbskulls
Nyctalop Nyctalops Odd_toed_ungulate Olympic_Athlete Ophicleides
Orangoutang Ostrogoth Pachyrhizus Paranoiac Parasites Patagonian
Patagonians Pestilential_pachyderm Pestilential_Pachyderm Phylloxera
Picaroon Pickled_herrings Pig_headed Pirates Pithecanthropic_montebanks
Pithecanthropuses Pockmark Pockmarks Politican Politician
Poltroons Polygraphs Polynesian Poor_loon Prattling_porpoise
Prize_purple_jellyfishes Profiteer Profiteers Psychopath
Purple_profiteering_jellyfish Pyrographers Raggle_taggle_ruminants
Rapscallion Rats Rhizopods Roadhogs Road_hogs Rubberneck Ruffian
San_Theolodite Saucy_tramp Savages Scoffing_braggart Scorpion Sea_gherkins
Sea_lice Shipwreckers Slavertrader Slave_trader Slubberdegullions
Snake Sparrows Spitfire Squawking_popinjay Steamroller Stoolpigeon
Sub_tropical_sea_louse Subtropical_sea_louse Swine Sycophant Tapiocans
Technocrat Ten_thousand_thundering_typhoons Terrapin Terrapins Terrorists
Thundering_misguided_missile Thundering_typhoons Tin_hatted_tyrants Toads
Toffee_noses Torturers Traitors Tramps Tribe_of_savages Troglodytes
Turncoats Twister Two_timing_Tartar_Twisters Two_timing_troglodyte
Two_timing_Troglodytes Vagabonds Vampires Vandal Vegetarian Vermicellis
Villain Viper Visigoths Vivisectionists Vulture Weevils Whippersnapper
Whipper_Snapper Wildcat Woodlice Wreckers Zapotecs
# names nl
Aapmens Aapmensen Aardappelluis Aardappelluizen Aardvarken Aardworm Achterkleinzoon_van_een_geplukte_gier Afvallige Alle_donderende_donders Alle_donders Alle_duivels Anakoloet Anakoloeth Analphabeet Analphabeten Anarchist Apache Apekop Apenbakkes Appenijns_kropmens Arme_kleine Armzalige Asperges Augurk Augurken Autodidacten Autokraten
Baanduivels Baardaap_van_Molensloot Baliekluivers Ballenhoofden Bandiet Bandieten Bangerik Basji_Boezoek Basji_boezoeks Bavianen Bedrieger Beeldenstormer Beeldenstormers Beeldstormers Beest Bende_augurken Bende_bultezels Bende_dwazen Bende_guanoschachelaars Bende_kwajongens Bende_lafbekken Bende_menseneters Bende_oplichters Bende_pluimezels Bende_verwoestende_woestelingen Bende_vogelverschrikkers Bende_wildemannen Bende_woestelingen Bepluimde_kannibaal Beulen Beulshonden Beulskop Bibelootje Bij_alle_haartjes_de_snor_van_Plekszy_Gladz Bij_de_baard_van_de_profeet Bij_de_grote_Kraak_van_Terra_Nova Bij_de_ringen_van_Saturnus Bij_de_scepter_van_Ottokar Bij_de_snor_van_Plekszy_Gladz Bij_de_snorren_van_Plekszy_Gladz Bij_Sint_Wladimir Blaaskaak Blauwe_duivel Bliksem hel_donder_en_vagevuur Bliksemse_slinger Blikslagers Bloeddorstige_en_kwaadaardige_tirannen Bloedzuiger Bloedzuigers Boef Boerenkinkel Boerenkinkels Boeven Bommen_en_granaten Boodschapper_van_de_Duivel Borstelfabriek Bosjesnegers Broekventje Brutale_harken Brutale_rekels Brutale_vlegel Bruten Bruut Bulldozers
Calamiteit Caramba Cataclysme Catastrofe Coloradokevers Cyanide Cyclotron
De_duivel_hale_ze De_duivel_moge_ze_halen De_grote_kraakvis_mag_mij_kraken De_kraakvis_mag_mij_kraken Dekselse_kwajongen Delikate_beestje Deugniet Diavolo Die_twee_sukkels Dief Dier Dieven Dievenbende Dios_de_mi_vida Diplodokus Domme_gans Domoor Donder_en_bliksem Donder_en_hagel Donder_en_vuur Donder_hel_en_hagel Donder_bliksem_en_weerlicht Donder_duivel_en_bliksem Donderbomse_knuppelfenomenen Donderduivel_en_bomgranaten Donderduivels_land Donderduivelse_inboorling Donders Donders_nog_aan_toe Donderse_grapjas Doodrijder Doodrijders Doortrapte_leugenaar Driedubbel_doorgehaald_uilskuiken Driedubbel_overgehaalde_en_omgekeerde_ezel Driedubbel_overgehaalde_pakezel Driedubbeldoorgehaalde_schurk Driedubbele_eend Driedubbele_kwibus Driedubbele_overgehaalde_kaffer Driedubbelovergehaalde_ezel Drinkebroers Droge_visjes_eters Drogelever Drommels Drommels_jongen Drommelse_donderse_Kanaken Drommelse_hechtpleister Drommelse_Himalayaanse_kropdragers_uit_de_Apppenijnen Drommelse_infanteristen Drommelse_kerel Drommelse_rondwandelende_fonteinen Dronkaard Dronkelap Dronkelappen Dropwater Druifluizen Druiloor Duinbewoners Duivekaters Duivels Duivelse_Bobbie Duivelse_boominfanteristen Duivelse_Migoe Duizend_atoombommen_en_raketgranaten Duizend_bomgranaten Duizend_bommen Duizend_bommen_en_granaten Duizend_granaatbommen_en_bomgranaten Duizend_granaten Duizend_miljard_bommen Duizend_miljard_laserstralen Duizend_miljard_straallasers Duizend_miljoen_bliksembommen_en_dondergranaten Duizend_miljoen_bommen_en_granaten Duizend_miljoen_laserstralen Duizend_miljoen_miljard_bommen_en_laserstralen Duizend_milliard_donderbomgranaten Duizend_milliard_raketbommen_en_honderd_millioen_donderbussen Duizend_millioen_bommen_en_granaten Duizend_millioen_duizend_milliard_bommen_en_granaten Duizend_millioen_granaatbommen_en_bomgranaten Duizend_millioen_hagel_blikseme_en_donderbommen Duizend_zoetwatervissen Duizendmijard_bommen_en_granaten Duizendmiljard_bommen Duizendmiljard_bommen_en_granaten Duizendpoot Duo_druiloren Duvelse_kurk
Ectoplasma Ectoplasma_s Eerloze_dienaar_van_Beelzebub Egoisten Elledeling Ellendelaren Ellendelingen Ellendig_gedierte Ellendige Ellendige_aardwormen Ellendige_handelaar_in_oudheden Ellendige_heiligschenner Ellendige_kleine_aardworm Ellendige_kleine_adder Ellendige_spreekhoorn Enorme_sufferd Ersatz_kamelen Ersatzmatrozen Ezel Ezels Ezelskop Ezelsoor Ezelsveulen Fenomeen_van_een_Zonnebloem Firma_Lef_en_Co
Galgenaas Galgengebroed Gangsters Gebakken_sprinkhanen Gediplomeerde_komkommers Gehoornde_slangen Gekielhaalde_zeeschuimer Gemene_broers_Wolff Gemene_slang Gespuis Gifmengers Giftige_sirene Glibberige_adder Goddelozen Goeie_genade Goudgevooisde_monster Grapjassen Grappenmaker Groot wat_naief_kind Grootvizier Grote_Bazar Grote_genade Grote_Moefti Grote_Mogol Grote_Schat
Hagel_en_donder Hagel vuur_en_weerlicht Halve_maan_rovers Hamsteraars Handlanger_van_Satan Hangsnorren Hansworst Hapschaar Harlekijn_van_een_Zonnebloem Heidenen Heikneuters Hel_en_duivel Hemel mijn_juwelen Hi_iii_i mijn_halssnoer Holbewoners Hond Hondejong Honderd_duizend_bliksembommen_en_dondergranaten Honderd_duizend_bommen_en_granaten Honderd_duizend_miljoen_bommen_en_granaten Honderd_miljard_bliksembommen Honderd_miljard_bommen Honderd_miljoen_bommen granaten_en_houwitsers Honderdduizend_bliksembommen_en_dondergranaten Honderdduizend_bommen_en_granaten Honderdduizend_miljard_bliksembommen Honderdduizend_miljoen_bommen_en_granaten Honderdduizendmiljoen_bommen_en_granaten Honderdmiljard_bliksembommen Hondsvodden Hondsvot Hoopje_stof Hottentot Hottentotten Huichelaar Huichelaars Huilebalken Huisjesmelkers Huurlingen
Idiote_Allan Idioten Imitatie_carnavals_Mussolini In_egelvet_gebraden_gehaktballen Internationale_schurk Invertebraat
Jandorie Joris_Goedbloed Judas Judokus
Kale_kakkerlakken Kale_kerkuil Kamelen Kanaak Kanalje Kannibaal Kaper Kapers Kapitein_Drankorgel Keffertje Kidnapper Kilometervreter Kilometervreters Kinkels Kippen_zonder_kop Klein_brutaal_ventje Klein_gespuis Kleine_boef Kleine_duivel Kleine_ellendeling Kleine_elllendeling Kleine_feeks Kleine_pestkop Kleine_schoelje Kleine_snotaap Kleine_vlegel Kleine_wijsneus Kleine_wilde Kleinzoon_van_kale_jakhals Knecht_van_Satan Knikkerhoofden Knolraapgezichten Kokosnoot Kolokwint Koppensnellers Kornuit Kropdragers Krulparasieten Kwajongen Kwakzalver Kwast Kwelgeest Kwibus Kwijlwortels
Laaghartige_Tapioca Lafaards Lafbekken Lamlendige_zuiplappen Lammetjes Landloper Langstaarten Lauwwaterdrinker Lelijk_beest Lelijk_dier Lelijk_ongedierte Lelijke_apekoppen Lelijke_baliekluivers Lelijke_Basji_Boezoeks Lelijke_deugniet Lelijke_kwajongen Lelijke_oude_klapekster Lieve_vriend Loeder_van_een_kruk Loerakken Lolbroek Lompe_griezel Lomperd Lomperik Lomperikken Lorejassen
Maatje Makako_s Maloot Mameloek Mamelukken Maniak Maskerade_Inca_s Maskeradevrijbuiters Massa_smerige_beesten Mau_Mauer Megacycle Melkmuil Mensaap Menseneter Menseneters Miereneter Misbaksel Mislukte_acrobaat Mislukte_handelaar_in_tweedehands_vogelmest Mislukte_infanteristen Misselijke_kerel Monster Monsters Moordenaars Mormel Mormelhond Mormels Mossels Muilezels Nachtuilen Nietsnutten Niksnut Nogaspekulanten Nogavreter
Oerwoudgebroed Olieboer Onafscheidelijke_padvinder Onbeschofte_driedubbele_kaffers Ondier Ongekamde_merinoschapen Ongelikte_beer Ongelovige_honden Ongeluk Ongelukige Ongelukkige Ongelukseiland Ongeluksmens Ongeluksscheepsjongen Ongeluksvogel Onnozele Onnozele_Zonnebloem Ontdekkingsreiziger Onze_twee_dikkoppen Oorwurm Opgeblazen_blaaskaak Opgeblazen_doedelzakken Opgevulde_tomaten Ordinaire_prutser Oud_prul Oude_drinkebroer Ouwe_baardaap Ouwe_drinkebroer Ouwe_dronkelap Ouwe_grapjas Ouwe_kameraad Ouwe_knotwilg Ouwe_piraat Ouwe_rover Ouwe_uil Ouwe_vrijbuiter Ouwe_walnoot Ouwe_zeebonk Ouwe_zeekomkommer Ouwe_zeeolifant Ouwe_zeeschuimer Overgehaalde_jandoedel Overjarige_marmot
Parasieten Patagonier Patagoniers Pekelharing Pekelharingen Phenomeen Pierlala Pietje_de_dood Pietlutten Piraat Piraten Planetenzwerver Plant Platvoeters Pleister_op_een_houten_been Potdikkema Potdikkie Potdorie Potjandorie Potverdikkeme Potverkaatje Potverpillepap Potverpollepap Praatjesmaker Praatzieke_papegaai Prehistorische_Zapoteken Prrraatzieke_kaketoe Pyromaan
Raketpiraat Rakker Rampzalige Rare_kwasten Rare_kwistenbiebel Ratelslangen Rattenkruid Razende_bende Razende_woesteling Revolutionairen_van_het_jaar_nul Rode_duivel Rolaap Rolapen Rolstoelterroristen Rommelende_Donder Ronde_tafel_conferentiehouder Roodhuiden Rotbeest Rotraket
Saboteur Sakkerloot Santa_Madre_de_Dios Sapperdekriek Sapperloot Sapperstie Sapristie Schaamteloze_kerel Schapenhoeder_van_de_Balkan Schavuit Scheepsjongen Scheepsjongetje Scheepskelderaars Scheepsmaatje Scheikundig_product Schele_kaalkop Schele_komkommers Schelm Schijheilige_mispel Schimmen Schobbejakken Schoften Schooiers Schoorsteenvegersragebollen Schorpioenen Schurftige_hond Schurk Schurken Siamese_tweeling Sjacheraars Slaafse_inboorlingen Slaapwandelaar Slangebijter Slavenhandelaar Slavenhandelaars Slingerapen Sluikhandelaar Smerig_dier Smerig_onding Smerig_touw Smerig_vuil_donders_beest Smerig donderduivels_land Smerige_bedelaar Smerige_beesten Smerige_hond Smerige_muskieten Smerige_sluipmoordenaar Smerige_Tapioca Smerige_Yeti Sneeuwman_met__je_droge_lever Sneeuwvreter Snerthond Snoeshaan Snoeshanen Snotaap Snotneus Snuiters Sokkenlopers Soort_koorknaapje Spion Spiritisten Spitsboeven Sprinkhaan Stekelvarken Stel_harken Stel_samenzweerders_uit_de_komische_opera Stelletje_Basji_Boezoeks Stelletje_dronkaards Stelletje_druilorige_zoeaven Stelletje_grote_lafaards Stelletje_hongerlijders Stelletje_Ku_Klux_Klans Stelletje_lomperds Stelletje_pierewaaiers Stelletje_piraten Stelletje_schurken Stelletje_vetkevers Sterreneter Stijfkop Stinkende_hyena Stom_stuk_analfabeet Stom_stuk_ornithorhynchus Stomme_idioot Stomme_Kanaken Stommeling Stommelingen Stoute_jongen Strandschuimers Strotgrondel Studiehoofdjes Stuk_Beethoven Stuk_brontosaurus_uit_de_prehistorie Stuk_ectoplasma Stuk_gediplomeerd_analphabeet Stuk_idioot Stuk_imbeciel Stuk_kannibaal Stuk_koolwaterstofextract Stuk_metafoor Stuk_mislukte_athleet Stuk_straalbulldozer Stuk_vliegenier_van_niemendal Stukje_kiekeboe_van_de_poppekast Stumperdje Sufferd Sufferds Suikerbeestje Sukkelaar Sukkels Sukkeltje
Tapijtenventer Tienduizend_miljard_bliksembommen Toneelgeneraal_uit_de_Pampa Tornado Trekpleister Troep_Messerschmidts Trompetneuzen Tsjoek_tsjoeks_van_de_karpaten Turkse_mutsen Twee_overgehaalde_kromstevens Typische_oude_zeerot
Uilskuiken Uilskuikens Uitgedroogde_mummies
Valse_noten Valsspeler Vampier Varkenskoppen Vastenavondzeeschuimer Vat_mosterdpap Vat_zonder_bodem Vegetarier Veldraaild Vent Verachtelijke_Tapioca Verdikkie Verdorie Verdraaid Verdraaid_lelijke_beesten Verdraaide_Basji_Boezoek Verdraaide_grapjas Verdraaide_Syldaven Verduivelde_klapsigaretten Verhip Verlopen_bladluis Vermaledijde_centrale Vermicelli_eters Vermolmd_scheepskanon Vernielers Verraad Verrader Verraders Verroeste_kaapstander Vervelende_kwibussen Vervelende_snotaap Vervloekt_vrachtschip Vervloekte_donderduivelse_tralies Vervloekte_kletskous Vervloekte_slinger Verwaand_dier Verwenste_raket Verwoestende_woestelingen Vetgemeste_vogelverschrikker Vierpootaugurk Vierpotige_Cyrano Vieze_beesten Vlegels Vlerk Vlerken Vliegende_doodskist Vliegende_sigaar Vliegenvanger Voetzoeker Vogel Vogelverschrikker Volksverhuizer Voor_den_drommel Vreemde_hond Vrijbuiter Vrijbuiters Vuige_wrattenzwijn Vuile_hond Vuile_wormsteek Vuurbollen
Wafelijzer Wafelijzers Wandelende_cycloon Wandelende_reklame_voor_kachelglans Wandelende_seinpaal Waterdrinkers Waterdrrrinker Wegduivel Wegpiraat Wel_alle_mensen Wel_verdraaid Whiskyvaten Wildemannen Woesteling Woestelingen Woestijnvossen Wortelpotigen Wraak Wrede_bruut
Zandhazen Zandvlooien Zeekomkommers Zeekreeft Zeerover Zeerovers Zeeschuimer Zeeschuimers Zeeslang Zeurpiet Zigeuners Zoeloeland Zoeloes Zoetwater_Papoea Zoetwateradmiraal_met_zijn_bende_scheepsjongens Zoetwaterkaper Zoetwatermatroos Zoetwatermatrozen Zoetwaterpiraten Zonderlinge_kwasten Zonen_van_Tapioca Zooloog Zoon_van_een_schurftige_hond Zoon_van_het_Hemelse_Rijk Zuiplappen Zwaarmoedige_muizen
