 /*
 * # Semantic UI
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,r){"use strict";e.fn.progress=function(t){var a,o=e(this),s=o.selector||"",c=("ontouchstart"in n.documentElement,(new Date).getTime()),i=[],l=arguments[0],u="string"==typeof l,g=[].slice.call(arguments,1);return o.each(function(){var n,o=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),p=o.className,m=o.metadata,v=o.namespace,d=o.selector,b=o.error,f="module-"+v,h=e(this),x=e(this).find(d.bar),y=e(this).find(d.progress),w=e(this).find(d.label),C=this,A=h.data(f);n={initialize:function(){n.debug("Initializing progress",o),n.read.metadata(),n.set.initials(),n.instantiate()},instantiate:function(){n.verbose("Storing instance of progress",n),A=n,h.data(f,n)},destroy:function(){n.verbose("Destroying previous dropdown for",h),h.removeData(f),A=r},reset:function(){n.set.percent(0)},complete:function(){(n.percent===r||n.percent<100)&&n.set.percent(100)},read:{metadata:function(){h.data(m.percent)&&(n.verbose("Current percent value set from metadata"),n.percent=h.data(m.percent)),h.data(m.total)&&(n.verbose("Total value set from metadata"),n.total=h.data(m.total)),h.data(m.value)&&(n.verbose("Current value set from metadata"),n.value=h.data(m.value))},currentValue:function(){return n.value!==r?n.value:!1}},increment:function(e){var t,r,a,o=n.total||!1;o?(r=n.value||0,e=e||1,a=r+e,t=n.total,n.debug("Incrementing value by",e,r,t),a>t&&(n.debug("Value cannot increment above total",t),a=t),n.set.progress(a)):(r=n.percent||0,e=e||n.get.randomValue(),a=r+e,t=100,n.debug("Incrementing percentage by",e,r),a>t&&(n.debug("Value cannot increment above 100 percent"),a=t),n.set.progress(a))},decrement:function(e){var t,r,a=n.total||!1,o=0;a?(t=n.value||0,e=e||1,r=t-e,n.debug("Decrementing value by",e,t)):(t=n.percent||0,e=e||n.get.randomValue(),r=t-e,n.debug("Decrementing percentage by",e,t)),o>r&&(n.debug("Value cannot decrement below 0"),r=0),n.set.progress(r)},get:{text:function(e){var t=n.value||0,r=n.total||0,a=n.percent||0;return e=e||"",e=e.replace("{value}",t).replace("{total}",r).replace("{percent}",a),n.debug("Adding variables to progress bar text",e),e},randomValue:function(){return n.debug("Generating random increment percentage"),Math.floor(Math.random()*o.random.max+o.random.min)},percent:function(){return n.percent||0},value:function(){return n.value||!1},total:function(){return n.total||!1}},is:{success:function(){return h.hasClass(p.success)},warning:function(){return h.hasClass(p.warning)},error:function(){return h.hasClass(p.error)}},remove:{active:function(){n.verbose("Removing active state"),h.removeClass(p.active)},success:function(){n.verbose("Removing success state"),h.removeClass(p.success)},warning:function(){n.verbose("Removing warning state"),h.removeClass(p.warning)},error:function(){n.verbose("Removing error state"),h.removeClass(p.error)}},set:{barWidth:function(e){e>100&&n.error(b.tooHigh,e),x.css("width",e+"%")},initials:function(){o.value&&(n.verbose("Current value set in settings",o.value),n.value=o.value),o.total&&(n.verbose("Current total set in settings",o.total),n.total=o.total),o.percent&&(n.verbose("Current percent set in settings",o.percent),n.percent=o.percent),n.percent?n.set.percent(n.percent):n.value&&n.set.progress(n.value)},percent:function(t){t="string"==typeof t?+t.replace("%",""):t,t>0&&1>t&&(n.verbose("Module percentage passed as decimal, converting"),t=100*t),t=Math.round(0===o.precision?t:10*t*o.precision/(10*o.precision)),n.percent=t,n.total&&(n.value=Math.round(t/100*n.total)),n.set.barWidth(t),n.set.barLabel(),100===t?!o.autoSuccess||n.is.warning()||n.is.error()?n.remove.active():(n.set.success(),n.debug("Automatically triggering success at 100%")):n.set.active(),e.proxy(o.onChange,C)(t,n.value,n.total)},label:function(e){e=e||"",e&&(e=n.get.text(e),n.debug("Setting label to text",e),w.text(e))},barLabel:function(e){e!==r?y.text(n.get.text(e)):"ratio"==o.label&&n.total?(n.debug("Adding ratio to bar label"),y.text(n.get.text(o.text.ratio))):"percent"==o.label&&(n.debug("Adding percentage to bar label"),y.text(n.get.text(o.text.percent)))},active:function(t){t=t||o.text.active,n.debug("Setting active state"),o.showActivity&&h.addClass(p.active),n.remove.warning(),n.remove.error(),n.remove.success(),t&&n.set.label(t),e.proxy(o.onActive,C)(n.value,n.total)},success:function(t){t=t||o.text.success,n.debug("Setting success state"),h.addClass(p.success),n.remove.active(),n.remove.warning(),n.remove.error(),n.complete(),t&&n.set.label(t),e.proxy(o.onSuccess,C)(n.total)},warning:function(t){t=t||o.text.warning,n.debug("Setting warning state"),h.addClass(p.warning),n.remove.active(),n.remove.success(),n.remove.error(),n.complete(),t&&n.set.label(t),e.proxy(o.onWarning,C)(n.value,n.total)},error:function(t){t=t||o.text.error,n.debug("Setting error state"),h.addClass(p.error),n.remove.active(),n.remove.success(),n.remove.warning(),n.complete(),t&&n.set.label(t),e.proxy(o.onError,C)(n.value,n.total)},total:function(e){n.total=e},progress:function(e){var t,r="string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e;r||n.error(b.nonNumeric),n.total?(n.value=r,t=r/n.total*100,n.debug("Calculating percent complete from total",t),n.set.percent(t)):(t=r,n.debug("Setting value to exact percentage value",t),n.set.percent(t))}},setting:function(t,a){if(n.debug("Changing setting",t,a),e.isPlainObject(t))e.extend(!0,o,t);else{if(a===r)return o[t];o[t]=a}},internal:function(t,a){if(e.isPlainObject(t))e.extend(!0,n,t);else{if(a===r)return n[t];n[t]=a}},debug:function(){o.debug&&(o.performance?n.performance.log(arguments):(n.debug=Function.prototype.bind.call(console.info,console,o.name+":"),n.debug.apply(console,arguments)))},verbose:function(){o.verbose&&o.debug&&(o.performance?n.performance.log(arguments):(n.verbose=Function.prototype.bind.call(console.info,console,o.name+":"),n.verbose.apply(console,arguments)))},error:function(){n.error=Function.prototype.bind.call(console.error,console,o.name+":"),n.error.apply(console,arguments)},performance:{log:function(e){var t,r,a;o.performance&&(t=(new Date).getTime(),a=c||t,r=t-a,c=t,i.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:C,"Execution Time":r})),clearTimeout(n.performance.timer),n.performance.timer=setTimeout(n.performance.display,100)},display:function(){var t=o.name+":",a=0;c=!1,clearTimeout(n.performance.timer),e.each(i,function(e,t){a+=t["Execution Time"]}),t+=" "+a+"ms",s&&(t+=" '"+s+"'"),(console.group!==r||console.table!==r)&&i.length>0&&(console.groupCollapsed(t),console.table?console.table(i):e.each(i,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),i=[]}},invoke:function(t,o,s){var c,i,l,u=A;return o=o||g,s=C||s,"string"==typeof t&&u!==r&&(t=t.split(/[\. ]/),c=t.length-1,e.each(t,function(a,o){var s=a!=c?o+t[a+1].charAt(0).toUpperCase()+t[a+1].slice(1):t;if(e.isPlainObject(u[s])&&a!=c)u=u[s];else{if(u[s]!==r)return i=u[s],!1;if(!e.isPlainObject(u[o])||a==c)return u[o]!==r?(i=u[o],!1):(n.error(b.method,t),!1);u=u[o]}})),e.isFunction(i)?l=i.apply(s,o):i!==r&&(l=i),e.isArray(a)?a.push(l):a!==r?a=[a,l]:l!==r&&(a=l),i}},u?(A===r&&n.initialize(),n.invoke(l)):(A!==r&&n.destroy(),n.initialize())}),a!==r?a:this},e.fn.progress.settings={name:"Progress",namespace:"progress",debug:!1,verbose:!0,performance:!0,random:{min:2,max:5},autoSuccess:!0,showActivity:!0,label:"percent",precision:1,percent:!1,total:!1,value:!1,onChange:function(){},onSuccess:function(){},onActive:function(){},onError:function(){},onWarning:function(){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);