#Въведение

<div class="ui hidden">
  Ако четете тази страница извън /help/bg/*, връзките в нея няма да работят!
  If you read this page out of /help/bg/* the links in it will not work!
</div>
Адо[^adobg] е набор от библиотеки за разработка на уеб-проекти, базиран 
на [Mojolicious](http://mojolicio.us/), написан на езика за програмиране Perl.

Разработката започна през ноември 2013. Адо е пренаписан предишен проект 
([MYDLjE](https://github.com/kberov/MYDLjE)), базиран на Mojolicious 1.9x.
MYDLjE беше твърде монолитен. Не беше възможно да се започне ново приложение 
с минимум възможности, които да се включват и изключват при необходимост.
Адо е много по-модулен и гъвкав от MYDLjE и названието му не е съкращение :).  


##Какво е Адо?
Предназначението на Адо е същото като на MYDLjE - бързо да се направи леко приложение
 и/или сайт, базиран на Mojolicious с възможност да поема голямо натоварване, с 
 висока производителност и да се разраства лесно. Всяка Адо-система започва като малко приложение, което може да се превърне в ERP, CMS, CRM или всичко накуп,
 като само се добавят плъгини при необходимост, докато организацията, която го ползва,
расте.

##Вградени възможности
Адо е типично Mojo-приложение. То идва с конфигурационен файл и модел[^mvcbg] - Mojolicious::Plugin::DSC. В изданието е включена SQLite база данни. Файлът е etc/ado.sqlite. Всички плъгини мога да се изключват и включват.

Адо има следните характеристики и функционалности:

1. Конфигурационен файл, съдържащ повечето важни настройки като controller_class, именувани пространства за уеб-пътища (routes) и команди, сесии, предварително зададени уеб-пътища и други...
1. Плъгините за Адо работят по същия начин като тези на Mojolicious и споделят същата 
основа чрез Ado::Plugin. Те обаче имат едно малко допълнително свойство. Могат да 
ползват свой собствен конфигурационен файл - 
`$ENV{MOJO_HOME}/etc/plugins/plugin_name.conf`. Приложения, специфични за различни 
бизнеси, базирани на Адо се разработват като набори от Адо-плъгини.
Следните плъгини са включени по подразбиране:
  1. Всички Mojolicious-плъгини които са включени по подразбиране.
  2. Mojolicious::Plugin::Charset – UTF-8.
  3. Mojolicious::Plugin::DSC – плъгин който интегрира DBIx::Simple::Class в приложението. DBIx::Simple::Class е много лек клас за обектно-релационно програмиране. Той премахва нуждата програмистът да пише SQL, но оставя възможността
  да се пишат сложни SQL-заявки когато е необходимо. Има планове да се добави поддръжката на асинхронни заявки, които няма да изискват промяна в начина на програмиране.
  4. Ado::Plugin::Auth е плъгин за автентикация на потребители в системата.
  Потребителите могат да влизат използвайки локалните си име и парола или (TODO!)
   Facebook, Google, Twitter и други доставчици на такива услуги.
  Има направена форма за вход в системата, която може да се ползва директно или да
  се ползва като пример за разработка на специфична форма за дадено приложение.
  5. Ado::Plugin::MarkdownRenderer – чете и показва файлове в markdown-формат.
  С него може да се направи личен блог или вътрешно-фирмен wiki-сайт.
1. Следните библиотеки за изграждане на потребителски интерфейс се разпространяват с дистрибуцията:
  1. Semantic UI – CSS и JS- библиотека за разработка на изгледи готови за мобилни устройства. С използването му HTML-кодът ни е по-чист отколкото ако бяхме ползвали друга подобна библиотека. 
  2. PageDown е вариант на Showdown от Attacklab, който се ползва на сайта Stack Overflow и други сайтове от групата Stack Exchange.
1. Адо добавя следните нови команди:
  1. Ado::Command::adduser позволява добавяне на потребители към приложението през терминал. Също така командата позволява добавяне на съществуващи потребители към групи. Ако групата не съществува, тя се създава автоматично.
  2. Ado::Command::version  показва информация за версиите на инсталираните задължителни и незадължителни модули.
1. Не на последно място, кодът е добре покрит от тестове. Положени са специални грижи
 да не се натрупва технически дълг, като тестовете с Test::Perl::Critic са настроени 
 на ниво "сурово". По този начин изискваме стилът на писане на код да е
  последователен и еднообразен навсякъде, и да се избегнат лошите практики.

Ето как изглежда една система, базирана на Адо като архитектура:

![Съставни части на Адо](/img/Ado-Building-Blocks.png "Съставни части на Адо")

##Инсталация/Разполагане
Начинът на инсталиране, който ви дава най-голяма гъвкавост, е на командния ред.
Силно се препоръчва да ползвате отделна дистрибуция на Perl предназначена специално за целта - не тази, която идва с операционната ви система.
ActivePerl или perlbrew са добър избор.

Всички сценарии описани на адрес [Mojolicious/Guides/Cookbook#DEPLOYMENT](http://mojolicio.us/perldoc/Mojolicious/Guides/Cookbook#DEPLOYMENT)
са валидни за Адо, като може да направите и ваша собствена комбинация.

##REST API[^restbg]
Адо се стреми към строго разпределение на отговорностите (MVC[^mvcbg]).
Най-добрият начин да се постигне това е като напълно се отдели програмният код, 
работещ при клиента (в браузъра) от кода, работещ на сървъра. Адо е идеално пригоден
за тази цел благодарение на Mojolicious. Всеки ресурс е достъпен чрез програмния 
REST интерфейс. Ние следим от близо и надграждаме върху препоръките от
"Добри практики за услуги, базирани на REST" на www.RestApiTutorial.com.

##Пътна карта

1. Създаване на Ado::Plugin::I18N  за съобщение, които се зареждат от базата данни
(разпространява се с Ado).
2. Създаване на Ado::Plugin::Vest – приложение за уеб-базирани съобщения.
3. Създаване на Ado::Plugin::CORS – дава възможност елементи от потребителския
 интерфейс на Адо да се вграждат в други сайтове. 
4. Създаване на Ado::Plugin::Site – Интерфейс за външни потребители.
1. Създаване на Ado::Plugin::Signup – Регистрация на потребители.
2. Създаване на Ado::Plugin::Profile – възможност за потребителите да редактират профилите си.
5. Създаване на Ado::Plugin::Admin – приложение за управление на система, базирана на Адо - "Контролен Панел".
  1. Създаване на Ado::Plugin::Domains – контролери за управление на система с много домейни в контролния панел.
  2. Създаване на контролери за управление на страници в сайта.
  3. Създаване на контролери за управление на съдържанието (секции) в страниците.
  4. Създаване на контролери за управление на потребители и групи.


Красимир Беров, 2014-05-06

[^adobg]: Ado - busy or delaying activity; bustle; fuss - суматоха, бъркотия, суетня.
Вижте също http://www.thefreedictionary.com/ado

[^mvcbg]: http://bg.wikipedia.org/wiki/MVC

[^restbg]: http://bg.wikipedia.org/wiki/REST


