/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.xml.sax.Attributes;

@JsxClass(domClasses={HtmlImage.class})
public class HTMLImageElement
extends HTMLElement {
    private static final Map<String, String> NORMALIZED_ALIGN_VALUES = new HashMap<String, String>();
    private boolean instantiatedViaJavaScript_ = false;

    @JsxConstructor
    public void jsConstructor() {
        this.instantiatedViaJavaScript_ = true;
        SgmlPage page = (SgmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        DomElement fake = HTMLParser.getFactory("img").createElement(page, "img", (Attributes)new AttributeList());
        this.setDomNode(fake);
    }

    @JsxSetter
    public void setSrc(String src) {
        HtmlElement img = this.getDomNodeOrDie();
        img.setAttribute("src", src);
    }

    @JsxGetter
    public String getSrc() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String src = img.getSrcAttribute();
        if (this.instantiatedViaJavaScript_ && "".equals(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)img.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
            throw Context.reportRuntimeError((String)msg);
        }
    }

    @JsxSetter
    public void setOnload(Object onloadHandler) {
        this.setEventHandlerProp("onload", onloadHandler);
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        img.doOnLoad();
    }

    @JsxGetter
    public Object getOnload() {
        return this.getEventHandlerProp("onload");
    }

    @JsxGetter
    public String getAlt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        return alt;
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        String align = this.getDomNodeOrDie().getAttribute("align");
        if (acceptArbitraryValues) {
            return align;
        }
        String normalizedValue = NORMALIZED_ALIGN_VALUES.get(align.toLowerCase());
        if (null != normalizedValue) {
            return normalizedValue;
        }
        return "";
    }

    @JsxSetter
    public void setAlign(String align) {
        align = align.toLowerCase();
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues) {
            this.getDomNodeOrDie().setAttribute("align", align);
            return;
        }
        String normalizedValue = NORMALIZED_ALIGN_VALUES.get(align.toLowerCase());
        if (null != normalizedValue) {
            this.getDomNodeOrDie().setAttribute("align", normalizedValue);
            return;
        }
        throw Context.reportRuntimeError((String)("Cannot set the align property to invalid value: '" + align + "'"));
    }

    @Override
    @JsxGetter
    public int getWidth() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String width = img.getWidthAttribute();
        try {
            return Integer.parseInt(width);
        }
        catch (NumberFormatException e) {
            return 24;
        }
    }

    @JsxSetter
    public void setWidth(String width) {
        this.getDomNodeOrDie().setAttribute("width", width);
    }

    @Override
    @JsxGetter
    public int getHeight() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String height = img.getHeightAttribute();
        try {
            return Integer.parseInt(height);
        }
        catch (NumberFormatException e) {
            return 24;
        }
    }

    @JsxSetter
    public void setHeight(String height) {
        this.getDomNodeOrDie().setAttribute("height", height);
    }

    static {
        NORMALIZED_ALIGN_VALUES.put("center", "center");
        NORMALIZED_ALIGN_VALUES.put("left", "left");
        NORMALIZED_ALIGN_VALUES.put("right", "right");
        NORMALIZED_ALIGN_VALUES.put("bottom", "bottom");
        NORMALIZED_ALIGN_VALUES.put("middle", "middle");
        NORMALIZED_ALIGN_VALUES.put("top", "top");
        NORMALIZED_ALIGN_VALUES.put("absbottom", "absBottom");
        NORMALIZED_ALIGN_VALUES.put("absmiddle", "absMiddle");
        NORMALIZED_ALIGN_VALUES.put("baseline", "baseline");
        NORMALIZED_ALIGN_VALUES.put("texttop", "textTop");
    }
}

