/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollectionTags;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.NamespaceCollection;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.NodeFilter;
import com.gargoylesoftware.htmlunit.javascript.host.Range;
import com.gargoylesoftware.htmlunit.javascript.host.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import com.gargoylesoftware.htmlunit.javascript.host.TreeWalker;
import com.gargoylesoftware.htmlunit.javascript.host.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.UniqueTag;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLDocument
extends Document
implements ScriptableWithFallbackGetter {
    private static final long serialVersionUID = -7646789903352066465L;
    static final String EMPTY_COOKIE_NAME = "HTMLUNIT_EMPTY_COOKIE";
    private static final Map<String, Class<? extends Event>> SUPPORTED_EVENT_TYPE_MAP;
    private static final List<String> EXECUTE_CMDS_IE;
    private static final List<String> EXECUTE_CMDS_FF;
    private static int UniqueID_Counter_;
    private HTMLCollection all_;
    private HTMLCollection forms_;
    private HTMLCollection links_;
    private HTMLCollection images_;
    private HTMLCollection scripts_;
    private HTMLCollection anchors_;
    private HTMLCollection applets_;
    private StyleSheetList styleSheets_;
    private NamespaceCollection namespaces_;
    private HTMLElement activeElement_;
    private final StringBuilder writeBuffer_ = new StringBuilder();
    private boolean writeInCurrentDocument_ = true;
    private String domain_;
    private String uniqueID_;

    public void jsConstructor() {
    }

    @Override
    public DomNode getDomNodeOrDie() throws IllegalStateException {
        try {
            return super.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            DomNode node = this.getDomNodeOrNullFromRealDocument();
            if (node != null) {
                return node;
            }
            throw e;
        }
    }

    @Override
    public DomNode getDomNodeOrNull() {
        DomNode node = super.getDomNodeOrNull();
        if (node == null) {
            node = this.getDomNodeOrNullFromRealDocument();
        }
        return node;
    }

    private DomNode getDomNodeOrNullFromRealDocument() {
        Window w;
        HTMLDocument realDocument;
        Scriptable scope;
        DomNode node = null;
        boolean ie = this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE();
        if (ie && (scope = this.getParentScope()) instanceof Window && (realDocument = (w = (Window)scope).jsxGet_document()) != this) {
            node = realDocument.getDomNodeOrDie();
        }
        return node;
    }

    public HtmlPage getHtmlPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    public HtmlPage getHtmlPageOrNull() {
        return (HtmlPage)this.getDomNodeOrNull();
    }

    public Object jsxGet_forms() {
        if (this.forms_ == null) {
            this.forms_ = new HTMLCollection(this);
            this.forms_.init(this.getDomNodeOrDie(), ".//form");
        }
        return this.forms_;
    }

    public Object jsxGet_links() {
        if (this.links_ == null) {
            this.links_ = new HTMLCollection(this);
            this.links_.init(this.getDomNodeOrDie(), ".//a[@href] | .//area[@href]");
        }
        return this.links_;
    }

    public Object jsxGet_namespaces() {
        if (this.namespaces_ == null) {
            this.namespaces_ = new NamespaceCollection(this);
        }
        return this.namespaces_;
    }

    public Object jsxGet_anchors() {
        if (this.anchors_ == null) {
            this.anchors_ = new HTMLCollection(this);
            String xpath = this.getBrowserVersion().isIE() ? ".//a[@name or @id]" : ".//a[@name]";
            this.anchors_.init(this.getDomNodeOrDie(), xpath);
        }
        return this.anchors_;
    }

    public Object jsxGet_applets() {
        if (this.applets_ == null) {
            this.applets_ = new HTMLCollection(this);
            this.applets_.init(this.getDomNodeOrDie(), ".//applet");
        }
        return this.applets_;
    }

    public static void jsxFunction_write(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuilder buffer = new StringBuilder();
        for (Object arg : args) {
            buffer.append(Context.toString((Object)arg));
        }
        return buffer.toString();
    }

    public static void jsxFunction_writeln(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args) + "\n");
    }

    private static HTMLDocument getDocument(Scriptable thisObj) {
        if (thisObj instanceof HTMLDocument && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)thisObj;
        }
        Window window = HTMLDocument.getWindow(thisObj);
        BrowserVersion browser = window.getWebWindow().getWebClient().getBrowserVersion();
        if (browser.isIE()) {
            return window.jsxGet_document();
        }
        throw Context.reportRuntimeError((String)"Function can't be used detached from document");
    }

    protected void write(String content) {
        this.getLog().debug((Object)("write: " + content));
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
        if (!page.isBeingParsed()) {
            this.writeInCurrentDocument_ = false;
        }
        this.writeBuffer_.append(content);
        if (!this.writeInCurrentDocument_) {
            this.getLog().debug((Object)"wrote content to buffer");
            return;
        }
        String bufferedContent = this.writeBuffer_.toString();
        if (!HTMLDocument.canAlreadyBeParsed(bufferedContent)) {
            this.getLog().debug((Object)"write: not enough content to parsed it now");
            return;
        }
        this.writeBuffer_.setLength(0);
        page.writeInParsedStream(bufferedContent.toString());
    }

    private static boolean canAlreadyBeParsed(String content) {
        boolean tagOutside = false;
        boolean tagSart = true;
        int tagInName = 2;
        int tagInside = 3;
        int tagState = 0;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        int index = 0;
        for (char currentChar : content.toCharArray()) {
            switch (tagState) {
                case 0: {
                    if (currentChar != '<') break;
                    tagState = 1;
                    tagIsOpen = true;
                    break;
                }
                case 1: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = 2;
                    break;
                }
                case 2: {
                    if (Character.isLetter(currentChar)) break;
                    String tagName = content.substring(tagNameBeginIndex, index);
                    if (tagName.equalsIgnoreCase("script")) {
                        if (tagIsOpen) {
                            ++scriptTagCount;
                        } else if (scriptTagCount > 0) {
                            --scriptTagCount;
                        }
                    }
                    if (currentChar == '>') {
                        tagState = 0;
                        break;
                    }
                    tagState = 3;
                    break;
                }
                case 3: {
                    if (currentChar != '>') break;
                    tagState = 0;
                    break;
                }
            }
            ++index;
        }
        return scriptTagCount <= 0 && tagState == 0;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastChild();
        if (lastChild == null || !(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    public String jsxGet_cookie() {
        HtmlPage page = this.getHtmlPage();
        URL url = page.getWebResponse().getRequestUrl();
        url = HTMLDocument.replaceForCookieIfNecessary(url);
        boolean secure = "https".equals(url.getProtocol());
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        CookieSpec spec = CookiePolicy.getCookieSpec((String)"compatibility");
        Cookie[] allCookies = page.getWebClient().getCookieManager().getCookies().toArray(new Cookie[0]);
        Cookie[] matchingCookies = spec.match(url.getHost(), port, url.getPath(), secure, allCookies);
        if (matchingCookies == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Cookie cookie : matchingCookies) {
            if (buffer.length() != 0) {
                buffer.append("; ");
            }
            if (!EMPTY_COOKIE_NAME.equals(cookie.getName())) {
                buffer.append(cookie.getName());
                buffer.append("=");
            }
            if (cookie.getValue().contains(" ")) {
                buffer.append('\"');
            }
            buffer.append(cookie.getValue());
            if (!cookie.getValue().contains(" ")) continue;
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public String jsxGet_compatMode() {
        boolean strict = false;
        DocumentType docType = this.getPage().getDoctype();
        if (docType != null) {
            String publicId = docType.getPublicId();
            String systemId = docType.getSystemId();
            if (systemId != null) {
                if (systemId.equals("http://www.w3.org/TR/html4/strict.dtd")) {
                    strict = true;
                } else if (systemId.equals("http://www.w3.org/TR/html4/loose.dtd")) {
                    if (publicId.equals("-//W3C//DTD HTML 4.01 Transitional//EN") || publicId.equals("-//W3C//DTD HTML 4.0 Transitional//EN") && this.getBrowserVersion().isIE()) {
                        strict = true;
                    }
                } else if (systemId.equals("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd") || systemId.equals("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd")) {
                    strict = true;
                }
            }
        }
        if (strict) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    public void jsxSet_cookie(String newCookie) {
        CookieManager cookieManager = this.getHtmlPage().getWebClient().getCookieManager();
        if (cookieManager.isCookiesEnabled()) {
            URL url = this.getHtmlPage().getWebResponse().getRequestUrl();
            url = HTMLDocument.replaceForCookieIfNecessary(url);
            Cookie cookie = HTMLDocument.buildCookie(newCookie, url);
            cookieManager.addCookie(cookie);
            this.getLog().debug((Object)("Added cookie: " + cookie));
        } else {
            this.getLog().debug((Object)("Skipped adding cookie: " + newCookie));
        }
    }

    private static URL replaceForCookieIfNecessary(URL url) {
        String protocol = url.getProtocol();
        boolean file = "file".equals(protocol);
        if (file) {
            try {
                url = UrlUtils.getUrlWithNewPort(UrlUtils.getUrlWithNewHost(url, "LOCAL_FILESYSTEM"), 0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    static Cookie buildCookie(String newCookie, URL currentURL) {
        String value;
        String name;
        StringTokenizer st = new StringTokenizer(newCookie, ";");
        if (newCookie.contains("=")) {
            String nameAndValue = st.nextToken();
            name = StringUtils.substringBefore((String)nameAndValue, (String)"=").trim();
            value = StringUtils.substringAfter((String)nameAndValue, (String)"=").trim();
        } else {
            name = EMPTY_COOKIE_NAME;
            value = newCookie;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.put("domain", currentURL.getHost());
        atts.put("path", "");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexEqual = token.indexOf("=");
            if (indexEqual > -1) {
                atts.put(token.substring(0, indexEqual).toLowerCase().trim(), token.substring(indexEqual + 1).trim());
                continue;
            }
            atts.put(token.toLowerCase().trim(), Boolean.TRUE);
        }
        Date expires = null;
        String date = (String)atts.get("expires");
        if (date != null) {
            try {
                expires = DateUtil.parseDate((String)date);
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        String domain = (String)atts.get("domain");
        String path = (String)atts.get("path");
        boolean secure = atts.get("secure") != null;
        Cookie cookie = new Cookie(domain, name, value, path, expires, secure);
        return cookie;
    }

    public Object jsxGet_images() {
        if (this.images_ == null) {
            this.images_ = new HTMLCollection(this);
            this.images_.init(this.getDomNodeOrDie(), ".//img");
        }
        return this.images_;
    }

    public String jsxGet_URL() {
        return this.getHtmlPage().getWebResponse().getRequestUrl().toExternalForm();
    }

    public String jsxGet_uniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    public HTMLCollection jsxGet_all() {
        if (this.all_ == null) {
            this.all_ = new HTMLCollectionTags(this);
            this.all_.setAvoidObjectDetection(!this.getBrowserVersion().isIE());
            this.all_.init(this.getDomNodeOrDie(), ".//*");
        }
        return this.all_;
    }

    public Object jsxFunction_open(String url, Object name, Object features, Object replace) {
        HtmlPage page = this.getHtmlPage();
        if (page.isBeingParsed()) {
            this.getLog().warn((Object)"Ignoring call to open() during the parsing stage.");
            return null;
        }
        if (!this.writeInCurrentDocument_) {
            this.getLog().warn((Object)"Function open() called when document is already open.");
        }
        this.writeInCurrentDocument_ = false;
        return null;
    }

    public void jsxFunction_close() throws IOException {
        if (this.writeInCurrentDocument_) {
            this.getLog().warn((Object)"close() called when document is not open.");
        } else {
            HtmlPage page = this.getHtmlPage();
            URL url = page.getWebResponse().getRequestUrl();
            StringWebResponse webResponse = new StringWebResponse(this.writeBuffer_.toString(), url);
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            webClient.loadWebResponseInto(webResponse, window);
            this.writeInCurrentDocument_ = true;
            this.writeBuffer_.setLength(0);
        }
    }

    public Object jsxGet_parentWindow() {
        return this.getWindow();
    }

    @Override
    public Object jsxFunction_appendChild(Object childObject) {
        if (this.limitAppendChildToIE() && !this.getBrowserVersion().isIE()) {
            throw new RuntimeException("Node cannot be inserted at the specified point in the hierarchy.");
        }
        return super.jsxFunction_appendChild(childObject);
    }

    protected boolean limitAppendChildToIE() {
        return true;
    }

    @Override
    public Object jsxFunction_createElement(String tagName) {
        Object result;
        block6: {
            result = NOT_FOUND;
            try {
                if (tagName.startsWith("<") && this.getBrowserVersion().isIE()) {
                    try {
                        HtmlDivision proxyNode = new HtmlDivision(null, "div", this.getHtmlPage(), null);
                        HTMLParser.parseFragment(proxyNode, tagName);
                        DomNode resultNode = proxyNode.getFirstChild();
                        resultNode.removeAllChildren();
                        result = resultNode.getScriptObject();
                        break block6;
                    }
                    catch (SAXException e) {
                        String msg = "Unexpected exception occurred while parsing HTML snippet";
                        this.getLog().error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
                        throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
                    }
                    catch (IOException e) {
                        String msg = "Unexpected exception occurred while parsing HTML snippet";
                        this.getLog().error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
                        throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
                    }
                }
                return super.jsxFunction_createElement(tagName);
            }
            catch (ElementNotFoundException elementNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    public Object jsxFunction_createElementNS(String namespaceURI, String qualifiedName) {
        Element element = this.getBrowserVersion().isFirefox() && "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI) ? new HtmlDivision(namespaceURI, qualifiedName, this.getPage(), null) : ("http://www.w3.org/1999/xhtml".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null));
        return this.getScriptableFor(element);
    }

    public Stylesheet jsxFunction_createStyleSheet(String url, int index) {
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setPrototype(this.getPrototype(Stylesheet.class));
        stylesheet.setParentScope(this.getWindow());
        return stylesheet;
    }

    public Object jsxFunction_getElementById(String id) {
        Object result = null;
        try {
            Object htmlElement = ((HtmlPage)this.getDomNodeOrDie()).getDocumentElement().getElementById(id);
            SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a JavaScript object for the HTML element " + htmlElement.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException e) {
            BrowserVersion browser = this.getBrowserVersion();
            if (browser.isIE()) {
                HTMLCollection elements = this.jsxFunction_getElementsByName(id);
                result = elements.get(0, (Scriptable)elements);
                if (result instanceof UniqueTag) {
                    return null;
                }
                this.getLog().warn((Object)("getElementById(" + id + ") did a getElementByName for Internet Explorer"));
                return result;
            }
            this.getLog().debug((Object)("getElementById(" + id + "): no DOM node found with this id"));
        }
        return result;
    }

    public HTMLCollection jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection = new HTMLCollection(this);
        String exp = tagName.equals("*") ? "//*" : "//*[lower-case(local-name()) = '" + tagName.toLowerCase() + "']";
        collection.init(this.getDomNodeOrDie(), exp);
        return collection;
    }

    public HTMLCollection jsxFunction_getElementsByClassName(String className) {
        return ((HTMLElement)this.jsxGet_documentElement()).jsxFunction_getElementsByClassName(className);
    }

    public HTMLCollection jsxFunction_getElementsByName(String elementName) {
        HTMLCollection collection = new HTMLCollection(this);
        String exp = ".//*[@name='" + elementName + "']";
        collection.init(this.getDomNodeOrDie(), exp);
        return collection;
    }

    @Override
    protected Object getWithPreemption(String name) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if (page == null || this.getBrowserVersion().isFirefox()) {
            return NOT_FOUND;
        }
        return this.getIt(name);
    }

    private Object getIt(String name) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        List<HtmlElement> elements = this.getBrowserVersion().isIE() ? page.getElementsByIdAndOrName(name) : page.getElementsByName(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            HtmlElement element = elements.get(0);
            String tagName = element.getTagName();
            if ("img".equals(tagName) || "form".equals(tagName) || "applet".equals(tagName)) {
                return this.getScriptableFor(element);
            }
            return NOT_FOUND;
        }
        HTMLCollection collection = new HTMLCollection(this);
        String xpath = ".//*[(@name = '" + name + "' and (name() = 'img' or name() = 'form'))]";
        collection.init(page, xpath);
        int size = collection.jsxGet_length();
        if (size == 1) {
            return collection.get(0, (Scriptable)collection);
        }
        if (size > 1) {
            return collection;
        }
        return NOT_FOUND;
    }

    @Override
    public Object getWithFallback(String name) {
        if (this.getBrowserVersion().isFirefox()) {
            return this.getIt(name);
        }
        return NOT_FOUND;
    }

    public Object jsxGet_body() {
        HtmlPage enclosingPage;
        HtmlPage page = this.getHtmlPage();
        if (this.getBrowserVersion().isIE() && page.getEnclosingWindow() instanceof FrameWindow && (enclosingPage = (HtmlPage)page.getEnclosingWindow().getParentWindow().getEnclosedPage()).getReadyState() != "complete") {
            return null;
        }
        HtmlElement body = this.getHtmlPage().getBody();
        if (body != null) {
            return body.getScriptObject();
        }
        return null;
    }

    public String jsxGet_title() {
        return this.getHtmlPage().getTitleText();
    }

    public void jsxSet_title(String title) {
        this.getHtmlPage().setTitleText(title);
    }

    public String jsxGet_readyState() {
        DomNode node = this.getDomNodeOrDie();
        return node.getReadyState();
    }

    public String jsxGet_domain() {
        if (this.domain_ == null) {
            this.domain_ = this.getHtmlPage().getWebResponse().getRequestUrl().getHost();
            BrowserVersion browser = this.getBrowserVersion();
            if (browser.isFirefox()) {
                this.domain_ = this.domain_.toLowerCase();
            }
        }
        return this.domain_;
    }

    public void jsxSet_domain(String newDomain) {
        String currentDomain = this.jsxGet_domain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(".") == -1 || !currentDomain.toLowerCase().endsWith("." + newDomain.toLowerCase())) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\""));
        }
        this.domain_ = this.getBrowserVersion().isFirefox() ? newDomain.toLowerCase() : newDomain;
    }

    public Object jsxGet_scripts() {
        if (this.scripts_ == null) {
            this.scripts_ = new HTMLCollection(this);
            this.scripts_.init(this.getDomNodeOrDie(), ".//script");
        }
        return this.scripts_;
    }

    public Selection jsxGet_selection() {
        return this.getWindow().getSelection();
    }

    public Object jsxGet_frames() {
        return this.getWindow().jsxGet_frames();
    }

    public StyleSheetList jsxGet_styleSheets() {
        if (this.styleSheets_ == null) {
            this.styleSheets_ = new StyleSheetList(this);
        }
        return this.styleSheets_;
    }

    public Event jsxFunction_createEvent(String eventType) throws DOMException {
        Class<? extends Event> clazz = SUPPORTED_EVENT_TYPE_MAP.get(eventType);
        if (clazz == null) {
            throw new DOMException(9, "Event Type is not supported: " + eventType);
        }
        try {
            Event event = clazz.newInstance();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CREATEEVENT_INITALIZES_TARGET)) {
                event.setTarget(this);
            }
            event.setEventType(eventType);
            event.setParentScope(this.getWindow());
            event.setPrototype(this.getPrototype(clazz));
            return event;
        }
        catch (InstantiationException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
    }

    public Event jsxFunction_createEventObject() {
        MouseEvent event = new MouseEvent();
        event.setParentScope(this.getWindow());
        event.setPrototype(this.getPrototype(event.getClass()));
        return event;
    }

    public Object jsxFunction_elementFromPoint(int x, int y) {
        return this.jsxGet_body();
    }

    public Object jsxFunction_createRange() {
        Range r = new Range();
        r.setParentScope(this.getWindow());
        r.setPrototype(this.getPrototype(Range.class));
        return r;
    }

    public Object jsxFunction_createTreeWalker(Node root, int whatToShow, final NativeObject filter, boolean expandEntityReferences) throws DOMException {
        NodeFilter filterWrapper = null;
        if (filter != null) {
            filterWrapper = new NodeFilter(){
                private static final long serialVersionUID = -7572357836681155579L;

                public short acceptNode(Node n) {
                    Object response = ScriptableObject.callMethod((Scriptable)filter, (String)"acceptNode", (Object[])new Object[]{n});
                    return (short)Context.toNumber((Object)response);
                }
            };
        }
        TreeWalker t = new TreeWalker(root, whatToShow, filterWrapper, expandEntityReferences);
        t.setParentScope(HTMLDocument.getWindow(this));
        t.setPrototype(HTMLDocument.staticGetPrototype(HTMLDocument.getWindow(this), TreeWalker.class));
        return t;
    }

    private static Scriptable staticGetPrototype(Window window, Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = window.getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return HTMLDocument.staticGetPrototype(window, javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    public boolean jsxFunction_queryCommandSupported(String cmd) {
        boolean ff = this.getBrowserVersion().isFirefox();
        String mode = this.jsxGet_designMode();
        if (!ff) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_IE, cmd);
        }
        if (!"on".equals(mode)) {
            String msg = "queryCommandSupported() called while document.designMode='" + mode + "'.";
            throw Context.reportRuntimeError((String)msg);
        }
        return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_FF, cmd);
    }

    public boolean jsxFunction_queryCommandEnabled(String cmd) {
        boolean ff = this.getBrowserVersion().isFirefox();
        String mode = this.jsxGet_designMode();
        if (!ff) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_IE, cmd);
        }
        if (!"on".equals(mode)) {
            String msg = "queryCommandEnabled() called while document.designMode='" + mode + "'.";
            throw Context.reportRuntimeError((String)msg);
        }
        return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_FF, cmd);
    }

    public boolean jsxFunction_execCommand(String cmd, boolean userInterface, Object value) {
        boolean ie = this.getBrowserVersion().isIE();
        if (ie && !com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_IE, cmd) || !ie && !com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_FF, cmd)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EXECCOMMAND_THROWS_ON_WRONG_COMMAND)) {
                throw Context.reportRuntimeError((String)("document.execCommand(): invalid command '" + cmd + "'"));
            }
            return false;
        }
        this.getLog().warn((Object)("Nothing done for execCommand(" + cmd + ", ...) (feature not implemented)"));
        return true;
    }

    public Object jsxGet_activeElement() {
        return this.activeElement_;
    }

    public void setActiveElement(HTMLElement element) {
        this.activeElement_ = element;
    }

    @Override
    public SimpleScriptable jsxGet_doctype() {
        if (this.getBrowserVersion().isIE()) {
            return null;
        }
        return super.jsxGet_doctype();
    }

    public boolean jsxFunction_dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    static {
        EXECUTE_CMDS_IE = Arrays.asList("2D-Position", "AbsolutePosition", "BackColor", "BackgroundImageCache", "BlockDirLTR", "BlockDirRTL", "Bold", "BrowseMode", "ClearAuthenticationCache", "Copy", "CreateBookmark", "CreateLink", "Cut", "Delete", "DirLTR", "DirRTL", "EditMode", "FontName", "FontSize", "ForeColor", "FormatBlock", "Indent", "InlineDirLTR", "InlineDirRTL", "InsertButton", "InsertFieldset", "InsertHorizontalRule", "InsertIFrame", "InsertImage", "InsertInputButton", "InsertInputCheckbox", "InsertInputFileUpload", "InsertInputHidden", "InsertInputImage", "InsertInputPassword", "InsertInputRadio", "InsertInputReset", "InsertInputSubmit", "InsertInputText", "InsertMarquee", "InsertOrderedList", "InsertParagraph", "InsertSelectDropdown", "InsertSelectListbox", "InsertTextArea", "InsertUnorderedList", "Italic", "JustifyCenter", "JustifyFull", "JustifyLeft", "JustifyNone", "JustifyRight", "LiveResize", "MultipleSelection", "Open", "Outdent", "OverWrite", "Paste", "PlayImage", "Print", "Redo", "Refresh", "RemoveFormat", "RemoveParaFormat", "SaveAs", "SelectAll", "SizeToControl", "SizeToControlHeight", "SizeToControlWidth", "Stop", "StopImage", "StrikeThrough", "Subscript", "Superscript", "UnBookmark", "Underline", "Undo", "Unlink", "Unselect");
        EXECUTE_CMDS_FF = Arrays.asList("backColor", "bold", "contentReadOnly", "copy", "createLink", "cut", "decreaseFontSize", "delete", "fontName", "fontSize", "foreColor", "formatBlock", "heading", "hiliteColor", "increaseFontSize", "indent", "insertHorizontalRule", "insertHTML", "insertImage", "insertOrderedList", "insertUnorderedList", "insertParagraph", "italic", "justifyCenter", "justifyLeft", "justifyRight", "outdent", "paste", "redo", "removeFormat", "selectAll", "strikeThrough", "subscript", "superscript", "underline", "undo", "unlink", "useCSS", "styleWithCSS");
        UniqueID_Counter_ = 1;
        HashMap<String, Class<MouseEvent>> eventMap = new HashMap<String, Class<MouseEvent>>();
        eventMap.put("Event", Event.class);
        eventMap.put("Events", Event.class);
        eventMap.put("HTMLEvents", Event.class);
        eventMap.put("UIEvent", UIEvent.class);
        eventMap.put("UIEvents", UIEvent.class);
        eventMap.put("MouseEvent", MouseEvent.class);
        eventMap.put("MouseEvents", MouseEvent.class);
        SUPPORTED_EVENT_TYPE_MAP = Collections.unmodifiableMap(eventMap);
    }
}

