/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.net.MalformedURLException;
import org.mozilla.javascript.Context;

public class HTMLImageElement
extends HTMLElement {
    private static final long serialVersionUID = 5630843390548382869L;
    private String src_;

    public void jsConstructor() {
    }

    public void jsxSet_src(String src) {
        this.src_ = src;
        HtmlImage img = (HtmlImage)this.getHtmlElementOrNull();
        if (img != null) {
            img.setAttribute("src", src);
        }
        this.getWindow().getJavaScriptEngine().addPostponedAction(new ImageOnLoadAction());
    }

    public String jsxGet_src() {
        HtmlImage img = (HtmlImage)this.getHtmlElementOrNull();
        if (img != null) {
            String src = img.getSrcAttribute();
            try {
                HtmlPage page = (HtmlPage)img.getPage();
                return page.getFullyQualifiedUrl(src).toExternalForm();
            }
            catch (MalformedURLException e) {
                String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
                throw Context.reportRuntimeError((String)msg);
            }
        }
        if (this.src_ == null) {
            return "";
        }
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        HtmlPage currentPage = (HtmlPage)webClient.getCurrentWindow().getEnclosedPage();
        try {
            return currentPage.getFullyQualifiedUrl(this.src_).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
            throw Context.reportRuntimeError((String)msg);
        }
    }

    public void jsxSet_onload(Object onloadHandler) {
        this.setEventHandlerProp("onload", onloadHandler);
        this.getWindow().getJavaScriptEngine().addPostponedAction(new ImageOnLoadAction());
    }

    public Object jsxGet_onload() {
        return this.getEventHandlerProp("onload");
    }

    private class ImageOnLoadAction
    implements PostponedAction {
        private ImageOnLoadAction() {
        }

        public void execute() throws Exception {
            HtmlImage img = (HtmlImage)HTMLImageElement.this.getHtmlElementOrNull();
            if (img != null) {
                img.doOnLoad();
            }
        }
    }
}

