/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScriptable
extends ScriptableObject {
    private static final long serialVersionUID = 3120000176890886780L;
    private DomNode domNode_;

    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response != NOT_FOUND) {
            return response;
        }
        if (this == start) {
            return this.getWithPreemption(name);
        }
        return NOT_FOUND;
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    public String getClassName() {
        String javaClassName = ((Object)((Object)this)).getClass().getName();
        int index = javaClassName.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException("No dot in classname: " + javaClassName);
        }
        return javaClassName.substring(index + 1);
    }

    public final DomNode getDomNodeOrDie() throws IllegalStateException {
        if (this.domNode_ == null) {
            String clazz = ((Object)((Object)this)).getClass().getName();
            throw new IllegalStateException("DomNode has not been set for this SimpleScriptable: " + clazz);
        }
        return this.domNode_;
    }

    public final DomNode getDomNodeOrNull() {
        return this.domNode_;
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        WebAssert.notNull("domNode", domNode);
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptObject(this);
        }
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        this.setDomNode(htmlElement);
    }

    protected final Log getLog() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    protected SimpleScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (SimpleScriptable)((Object)((WebWindow)object).getScriptObject());
        }
        DomNode domNode = (DomNode)object;
        ScriptableObject scriptObject = domNode.getScriptObject();
        if (scriptObject != null) {
            return (SimpleScriptable)scriptObject;
        }
        return this.makeScriptableFor(domNode);
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        Class<? extends SimpleScriptable> javaScriptClass = null;
        for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
            javaScriptClass = JavaScriptConfiguration.getHtmlJavaScriptMapping().get(c);
        }
        if (javaScriptClass == null) {
            scriptable = new HTMLElement();
            this.getLog().debug((Object)("No JavaScript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement"));
        } else {
            try {
                scriptable = (SimpleScriptable)((Object)javaScriptClass.newInstance());
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        if (domNode.getPage().getEnclosingWindow().getEnclosedPage() == domNode.getPage()) {
            scriptable.setParentScope(this.getWindow());
        } else {
            scriptable.setParentScope(ScriptableObject.getTopLevelScope((Scriptable)((SgmlPage)domNode.getPage()).getScriptObject()));
        }
    }

    protected Scriptable getPrototype(Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = this.getWindow().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    protected Transformer getTransformerScriptableFor() {
        return new Transformer(){

            public Object transform(Object obj) {
                return SimpleScriptable.this.getScriptableFor(obj);
            }
        };
    }

    public static Object getObjectArg(int index, Object[] args, Object defaultValue) {
        if (index >= args.length) {
            return defaultValue;
        }
        return args[index];
    }

    public static String getStringArg(int index, Object[] args, String defaultValue) {
        return Context.toString((Object)SimpleScriptable.getObjectArg(index, args, defaultValue));
    }

    public static boolean getBooleanArg(int index, Object[] args, boolean defaultValue) {
        Boolean defaultBoolean = defaultValue;
        return Context.toBoolean((Object)SimpleScriptable.getObjectArg(index, args, defaultBoolean));
    }

    public static int getIntArg(int index, Object[] args, int defaultValue) {
        return (int)Context.toNumber((Object)SimpleScriptable.getObjectArg(index, args, new Integer(defaultValue)));
    }

    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            if (this.getBrowserVersion().isIE()) {
                return "[object]";
            }
            Window window = (Window)SimpleScriptable.getTopLevelScope((Scriptable)this);
            if (ScriptableObject.getProperty((Scriptable)window, (String)this.getClassName()) == this) {
                return "[" + this.getClassName() + "]";
            }
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    public Window getWindow() throws RuntimeException {
        return SimpleScriptable.getWindow((Scriptable)this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope((Scriptable)s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected Scriptable getStartingScope() {
        return (Scriptable)Context.getCurrentContext().getThreadLocal((Object)"startingScope");
    }

    public void defineProperty(String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = clazz.getMethods();
        Method getter = SimpleScriptable.findMethod(methods, getterName);
        Method setter = SimpleScriptable.findMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter, attributes);
    }

    public void defineFunctionProperties(String[] names, Class<?> clazz, int attributes) {
        Method[] methods = clazz.getMethods();
        for (String name : names) {
            Method method = SimpleScriptable.findMethod(methods, name);
            if (method == null) {
                throw Context.reportRuntimeError((String)("Method \"" + name + "\" not found in \"" + clazz.getName() + '\"'));
            }
            FunctionObject f = new FunctionObject(name, (Member)method, (Scriptable)this);
            this.defineProperty(name, f, attributes);
        }
    }

    private static Method findMethod(Method[] methods, String name) {
        for (Method m : methods) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    protected BrowserVersion getBrowserVersion() {
        return this.getWindow().getWebWindow().getWebClient().getBrowserVersion();
    }
}

