/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitPrefixResolver;
import com.gargoylesoftware.htmlunit.html.xpath.XPathAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathUtils {
    private XPathUtils() {
    }

    public static List<Object> getByXPath(Node node, String xpathExpr) {
        ArrayList<Object> list;
        block8: {
            if (xpathExpr == null) {
                throw new NullPointerException("Null is not a valid XPath expression");
            }
            list = new ArrayList<Object>();
            try {
                XObject result = XPathUtils.evaluateXPath(node, xpathExpr);
                if (result instanceof XNodeSet) {
                    NodeList nodelist = ((XNodeSet)result).nodelist();
                    for (int i = 0; i < nodelist.getLength(); ++i) {
                        list.add(nodelist.item(i));
                    }
                    break block8;
                }
                if (result instanceof XNumber) {
                    list.add(result.num());
                    break block8;
                }
                if (result instanceof XBoolean) {
                    list.add(result.bool());
                    break block8;
                }
                if (result instanceof XString) {
                    list.add(result.str());
                    break block8;
                }
                throw new RuntimeException("Unproccessed " + result.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve XPath >" + xpathExpr + "< on " + node, e);
            }
        }
        return list;
    }

    private static XObject evaluateXPath(Node contextNode, String str) throws TransformerException {
        XPathContext xpathSupport = new XPathContext((Object)false);
        Node xpathExpressionContext = contextNode.getNodeType() == 9 ? ((Document)contextNode).getDocumentElement() : contextNode;
        HtmlUnitPrefixResolver prefixResolver = new HtmlUnitPrefixResolver(xpathExpressionContext);
        XPathAdapter xpath = new XPathAdapter(str, null, (PrefixResolver)prefixResolver, 0, null);
        int ctxtNode = xpathSupport.getDTMHandleFromNode(contextNode);
        return xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
    }
}

