/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlPage
extends SgmlPage
implements Cloneable,
Document {
    private HTMLParser.HtmlUnitDOMBuilder builder_;
    private static final long serialVersionUID = 1779746292119944291L;
    private String originalCharset_;
    private Map<String, List<HtmlElement>> idMap_ = new HashMap<String, List<HtmlElement>>();
    private Map<String, List<HtmlElement>> nameMap_ = new HashMap<String, List<HtmlElement>>();
    private HtmlElement documentElement_;
    private HtmlElement elementWithFocus_;
    private int parserCount_;
    private int snippetParserCount_;
    private final transient Log javascriptLog_ = LogFactory.getLog((String)"com.gargoylesoftware.htmlunit.javascript");
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());
    private List<HtmlAttributeChangeListener> attributeListeners_;
    private final transient Object lock_ = new Object();
    private final Range selection_ = new SimpleRange(this.getDocumentElement());

    public HtmlPage(URL originatingUrl, WebResponse webResponse, WebWindow webWindow) {
        super(webResponse, webWindow);
    }

    @Override
    public HtmlPage getPage() {
        return this;
    }

    @Override
    public void initialize() throws IOException, FailingHttpStatusCodeException {
        this.loadFrames();
        this.setReadyState("complete");
        this.getDocumentElement().setReadyState("complete");
        if (!this.getWebClient().getBrowserVersion().isIE()) {
            this.executeEventHandlersIfNeeded("DOMContentLoaded");
        }
        this.executeDeferredScriptsIfNeeded();
        this.executeEventHandlersIfNeeded("load");
        this.setReadyStateOnDeferredScriptsIfNeeded();
        this.executeRefreshIfNeeded();
    }

    @Override
    public void cleanUp() throws IOException {
        this.executeEventHandlersIfNeeded("unload");
        this.deregisterFramesIfNeeded();
    }

    @Override
    public HtmlElement getDocumentElement() {
        if (this.documentElement_ == null) {
            DomNode childNode;
            for (childNode = this.getFirstChild(); childNode != null && !(childNode instanceof HtmlElement); childNode = childNode.getNextSibling()) {
            }
            this.documentElement_ = (HtmlElement)childNode;
        }
        return this.documentElement_;
    }

    @Deprecated
    public HtmlElement getDocumentHtmlElement() {
        return this.getDocumentElement();
    }

    public HtmlElement getBody() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlBody) && !(node instanceof HtmlFrameSet)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) {
        throw new UnsupportedOperationException("HtmlPage.importNode is not yet implemented.");
    }

    @Override
    public NodeList getElementsByTagName(String tagName) {
        return new DomNodeList(this, "//" + tagName);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("HtmlPage.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public Element getElementById(String elementId) {
        try {
            return this.getDocumentElement().getHtmlElementById(elementId);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getInputEncoding is not yet implemented.");
    }

    @Override
    public String getXmlEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getXmlEncoding is not yet implemented.");
    }

    @Override
    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("HtmlPage.getXmlStandalone is not yet implemented.");
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlStandalone is not yet implemented.");
    }

    @Override
    public String getXmlVersion() {
        throw new UnsupportedOperationException("HtmlPage.getXmlVersion is not yet implemented.");
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlVersion is not yet implemented.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("HtmlPage.getStrictErrorChecking is not yet implemented.");
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("HtmlPage.setStrictErrorChecking is not yet implemented.");
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("HtmlPage.getDocumentURI is not yet implemented.");
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("HtmlPage.setDocumentURI is not yet implemented.");
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.adoptNode is not yet implemented.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("HtmlPage.getDomConfig is not yet implemented.");
    }

    @Override
    public void normalizeDocument() {
        throw new UnsupportedOperationException("HtmlPage.normalizeDocument is not yet implemented.");
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node newNode, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.renameNode is not yet implemented.");
    }

    @Override
    public String getPageEncoding() {
        if (this.originalCharset_ != null) {
            return this.originalCharset_;
        }
        for (HtmlMeta meta : this.getMetaTags("content-type")) {
            String contents = meta.getContentAttribute();
            int pos = contents.toLowerCase().indexOf("charset=");
            if (pos < 0) continue;
            this.originalCharset_ = contents.substring(pos + 8);
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug((Object)("Page Encoding detected: " + this.originalCharset_));
            }
            return this.originalCharset_;
        }
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.getWebResponse().getContentCharSet();
        }
        return this.originalCharset_;
    }

    @Override
    public Element createElement(String tagName) {
        return this.createHtmlElement(tagName);
    }

    public HtmlElement createHtmlElement(String tagName) {
        String tagLower = tagName.toLowerCase();
        return HTMLParser.getFactory(tagLower).createElement(this, tagLower, null);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return this.createHtmlElementNS(namespaceURI, qualifiedName);
    }

    public HtmlElement createHtmlElementNS(String namespaceURI, String qualifiedName) {
        String tagLower = qualifiedName.toLowerCase().substring(qualifiedName.indexOf(58) + 1);
        return HTMLParser.getFactory(tagLower).createElementNS(this, namespaceURI, qualifiedName, null);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createAttributeNS is not yet implemented.");
    }

    @Override
    public Attr createAttribute(String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createAttribute is not yet implemented.");
    }

    @Override
    public Comment createComment(String data) {
        return new DomComment(this, data);
    }

    @Override
    public Text createTextNode(String data) {
        return new DomText(this, data);
    }

    @Override
    public CDATASection createCDATASection(String data) {
        return new DomCData(this, data);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DomDocumentFragment(this);
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("HtmlPage.getImplementation is not yet implemented.");
    }

    @Override
    public DocumentType getDoctype() {
        throw new UnsupportedOperationException("HtmlPage.getDoctype is not yet implemented.");
    }

    @Override
    public EntityReference createEntityReference(String id) {
        throw new UnsupportedOperationException("HtmlPage.createEntityReference is not yet implemented.");
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createProcessingInstruction is not yet implemented.");
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List<HtmlAnchor> getAnchors() {
        return this.getDocumentElement().getHtmlElementsByTagName("a");
    }

    public HtmlAnchor getFirstAnchorByText(String text) throws ElementNotFoundException {
        WebAssert.notNull("text", text);
        for (HtmlAnchor anchor : this.getAnchors()) {
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getDocumentElement().getHtmlElementsByAttribute("form", "name", name);
        if (forms.size() == 0) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List<HtmlForm> getForms() {
        return this.getDocumentElement().getHtmlElementsByTagName("form");
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        URL baseUrl;
        List baseElements = this.getDocumentElement().getHtmlElementsByTagName("base");
        if (baseElements.isEmpty()) {
            baseUrl = this.getWebResponse().getUrl();
        } else {
            if (baseElements.size() > 1) {
                this.notifyIncorrectness("Multiple 'base' detected, only the first is used.");
            }
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            boolean insideHead = false;
            for (DomNode parent = htmlBase.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof HtmlHead)) continue;
                insideHead = true;
                break;
            }
            if (!insideHead) {
                this.notifyIncorrectness("Element 'base' must appear in <head>, it is ignored.");
            }
            String href = htmlBase.getHrefAttribute();
            if (!insideHead || StringUtils.isEmpty((String)href)) {
                baseUrl = this.getWebResponse().getUrl();
            } else {
                try {
                    baseUrl = new URL(href);
                }
                catch (MalformedURLException e) {
                    this.notifyIncorrectness("Invalid base url: \"" + href + "\", ignoring it");
                    baseUrl = this.getWebResponse().getUrl();
                }
            }
        }
        if (this.getWebClient().getBrowserVersion().isNetscape()) {
            boolean incorrectnessNotified = false;
            while (relativeUrl.startsWith("http:") && !relativeUrl.startsWith("http://")) {
                if (!incorrectnessNotified) {
                    this.notifyIncorrectness("Incorrect URL \"" + relativeUrl + "\" has been corrected");
                    incorrectnessNotified = true;
                }
                relativeUrl = "http:/" + relativeUrl.substring(5);
            }
        }
        return WebClient.expandUrl(baseUrl, relativeUrl);
    }

    public String getResolvedTarget(String elementTarget) {
        String resolvedTarget;
        List baseElements = this.getDocumentElement().getHtmlElementsByTagName("base");
        if (baseElements.isEmpty()) {
            resolvedTarget = elementTarget;
        } else if (elementTarget != null && elementTarget.length() > 0) {
            resolvedTarget = elementTarget;
        } else {
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            resolvedTarget = htmlBase.getTargetAttribute();
        }
        return resolvedTarget;
    }

    public List<String> getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlElement element : this.getTabbableElements()) {
            list.add(element.getAttributeValue("id"));
        }
        return Collections.unmodifiableList(list);
    }

    public List<HtmlElement> getTabbableElements() {
        List<String> tags = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        for (HtmlElement element : this.getAllHtmlChildElements()) {
            boolean disabled;
            String tagName = element.getTagName();
            if (!tags.contains(tagName) || (disabled = element.isAttributeDefined("disabled")) || element.getTabIndex() == HtmlElement.TAB_INDEX_OUT_OF_BOUNDS) continue;
            tabbableElements.add(element);
        }
        Collections.sort(tabbableElements, this.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private Comparator<HtmlElement> createTabOrderComparator() {
        return new Comparator<HtmlElement>(){

            @Override
            public int compare(HtmlElement element1, HtmlElement element2) {
                Short i1 = element1.getTabIndex();
                Short i2 = element2.getTabIndex();
                int index1 = i1 != null ? (int)i1.shortValue() : -1;
                int index2 = i2 != null ? (int)i2.shortValue() : -1;
                int result = index1 > 0 && index2 > 0 ? index1 - index2 : (index1 > 0 ? -1 : (index2 > 0 ? 1 : (index1 == index2 ? 0 : index2 - index1)));
                return result;
            }
        };
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List<HtmlElement> elements = this.getHtmlElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public List<HtmlElement> getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = ("" + accessKey).toLowerCase();
        List<String> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");
        for (HtmlElement element : this.getAllHtmlChildElements()) {
            String accessKeyAttribute;
            if (!acceptableTagNames.contains(element.getTagName()) || !searchString.equalsIgnoreCase(accessKeyAttribute = element.getAttributeValue("accesskey"))) continue;
            elements.add(element);
        }
        return elements;
    }

    public ScriptResult executeJavaScript(String sourceCode) {
        return this.executeJavaScriptIfPossible(sourceCode, "injected script", 1);
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, int startLine) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        int prefixLength = "javascript:".length();
        if (sourceCode.length() > prefixLength && sourceCode.substring(0, prefixLength).equalsIgnoreCase("javascript:")) {
            sourceCode = sourceCode.substring(prefixLength);
        }
        Object result = this.getWebClient().getJavaScriptEngine().execute(this, sourceCode, sourceName, startLine);
        return new ScriptResult(result, this.getWebClient().getCurrentWindow().getEnclosedPage());
    }

    public ScriptResult executeJavaScriptFunctionIfPossible(Function function, Scriptable thisObject, Object[] args, DomNode htmlElementScope) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        JavaScriptEngine engine = this.getWebClient().getJavaScriptEngine();
        Object result = engine.callFunction(this, function, thisObject, args, htmlElementScope);
        return new ScriptResult(result, this.getWebClient().getCurrentWindow().getEnclosedPage());
    }

    protected Log getJsLog() {
        return this.javascriptLog_;
    }

    void loadExternalJavaScriptFile(String srcAttribute, String charset) {
        if (this.getWebClient().isJavaScriptEnabled()) {
            URL scriptURL;
            try {
                scriptURL = this.getFullyQualifiedUrl(srcAttribute);
                if (scriptURL.getProtocol().equals("javascript")) {
                    if (this.mainLog_.isInfoEnabled()) {
                        this.mainLog_.info((Object)("Ignoring script src [" + srcAttribute + "]"));
                    }
                    return;
                }
            }
            catch (MalformedURLException e) {
                if (this.mainLog_.isErrorEnabled()) {
                    this.mainLog_.error((Object)("Unable to build URL for script src tag [" + srcAttribute + "]"));
                }
                if (this.getWebClient().isThrowExceptionOnScriptError()) {
                    throw new ScriptException(this, (Throwable)e);
                }
                return;
            }
            Script script = this.loadJavaScriptFromUrl(scriptURL, charset);
            if (script != null) {
                this.getWebClient().getJavaScriptEngine().execute(this, script);
            }
        }
    }

    public static boolean isJavaScript(String typeAttribute, String languageAttribute) {
        boolean isJavaScript = languageAttribute != null && languageAttribute.length() != 0 ? TextUtil.startsWithIgnoreCase(languageAttribute, "javascript") : (typeAttribute != null && typeAttribute.length() != 0 ? typeAttribute.equalsIgnoreCase("text/javascript") : true);
        return isJavaScript;
    }

    private Script loadJavaScriptFromUrl(URL url, String charset) {
        boolean successful;
        WebResponse response;
        String scriptEncoding = charset;
        this.getPageEncoding();
        WebClient client = this.getWebClient();
        Cache cache = client.getCache();
        WebRequestSettings request = new WebRequestSettings(url);
        Script cachedScript = cache.getCachedScript(request);
        if (cachedScript != null) {
            return cachedScript;
        }
        try {
            response = client.loadWebResponse(request);
        }
        catch (IOException e) {
            if (this.mainLog_.isErrorEnabled()) {
                this.mainLog_.error((Object)("Error loading JavaScript from [" + url + "]."), (Throwable)e);
            }
            return null;
        }
        client.printContentIfNecessary(response);
        client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
        int statusCode = response.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300;
        if (!successful) {
            return null;
        }
        String contentType = response.getContentType();
        if (!contentType.equalsIgnoreCase("text/javascript") && !contentType.equalsIgnoreCase("application/x-javascript") && this.mainLog_.isWarnEnabled()) {
            this.mainLog_.warn((Object)("Expected content type of 'text/javascript' or 'application/x-javascript' for remotely loaded JavaScript element at '" + url + "', " + "but got '" + contentType + "'."));
        }
        if (StringUtils.isEmpty((String)scriptEncoding)) {
            String contentCharset = response.getContentCharSet();
            scriptEncoding = !contentCharset.equals("ISO-8859-1") ? contentCharset : (!this.originalCharset_.equals("ISO-8859-1") ? this.originalCharset_ : "ISO-8859-1");
        }
        byte[] data = response.getResponseBody();
        String scriptCode = EncodingUtil.getString((byte[])data, (int)0, (int)data.length, (String)scriptEncoding);
        JavaScriptEngine javaScriptEngine = client.getJavaScriptEngine();
        Script script = javaScriptEngine.compile(this, scriptCode, url.toExternalForm(), 1);
        cache.cacheIfPossible(request, response, script);
        return script;
    }

    public String getTitleText() {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement != null) {
            return titleElement.asText();
        }
        return "";
    }

    public void setTitleText(String message) {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement == null) {
            HtmlHead head;
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug((Object)"No title element, creating one");
            }
            if ((head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class)) == null) {
                throw new IllegalStateException("Headelement was not defined for this page");
            }
            Map<String, DomAttr> emptyMap = Collections.emptyMap();
            titleElement = new HtmlTitle(null, "title", this, emptyMap);
            if (head.getFirstChild() != null) {
                head.getFirstChild().insertBefore(titleElement);
            } else {
                head.appendChild(titleElement);
            }
        }
        titleElement.setNodeValue(message);
    }

    private HtmlElement getFirstChildElement(HtmlElement startElement, Class<?> clazz) {
        for (HtmlElement element : startElement.getChildElements()) {
            if (!clazz.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    private HtmlTitle getTitleElement() {
        HtmlHead head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class);
        if (head != null) {
            return (HtmlTitle)this.getFirstChildElement(head, HtmlTitle.class);
        }
        return null;
    }

    private boolean executeEventHandlersIfNeeded(String eventType) {
        FrameWindow fw;
        BaseFrame frame;
        Function frameTagEventHandler;
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return true;
        }
        WebWindow window = this.getEnclosingWindow();
        Window jsWindow = (Window)window.getScriptObject();
        if (jsWindow != null) {
            HtmlElement element = this.getDocumentElement();
            Event event = new Event(element, eventType);
            element.fireEvent(event);
            if (!this.isOnbeforeunloadAccepted(this, event)) {
                return false;
            }
        }
        if (window instanceof FrameWindow && (frameTagEventHandler = (frame = (fw = (FrameWindow)window).getFrameElement()).getEventHandler("on" + eventType)) != null) {
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug((Object)("Executing on" + eventType + " handler for " + frame));
            }
            Event event = new Event(frame, eventType);
            ((Node)frame.getScriptObject()).executeEvent(event);
            if (!this.isOnbeforeunloadAccepted((HtmlPage)frame.getPage(), event)) {
                return false;
            }
        }
        return true;
    }

    private boolean isOnbeforeunloadAccepted(HtmlPage page, Event event) {
        if (event.jsxGet_type().equals("beforeunload") && event.jsxGet_returnValue() != null) {
            OnbeforeunloadHandler handler = this.getWebClient().getOnbeforeunloadHandler();
            if (handler == null) {
                if (this.mainLog_.isWarnEnabled()) {
                    this.mainLog_.warn((Object)"document.onbeforeunload() returned a string in event.returnValue, but no onbeforeunload handler installed.");
                }
            } else {
                String message = Context.toString((Object)event.jsxGet_returnValue());
                return handler.handleEvent(page, message);
            }
        }
        return true;
    }

    private void executeRefreshIfNeeded() throws IOException {
        URL url;
        int time;
        boolean timeOnly;
        WebWindow window = this.getEnclosingWindow();
        if (window == null) {
            return;
        }
        String refreshString = this.getRefreshStringOrNull();
        if (refreshString == null || refreshString.length() == 0) {
            return;
        }
        int index = refreshString.indexOf(";");
        boolean bl = timeOnly = index == -1;
        if (timeOnly) {
            try {
                time = Integer.parseInt(refreshString);
            }
            catch (NumberFormatException e) {
                if (this.mainLog_.isErrorEnabled()) {
                    this.mainLog_.error((Object)("Malformed refresh string (no ';' but not a number): " + refreshString), (Throwable)e);
                }
                return;
            }
            url = this.getWebResponse().getUrl();
        } else {
            try {
                time = Integer.parseInt(refreshString.substring(0, index).trim());
            }
            catch (NumberFormatException e) {
                if (this.mainLog_.isErrorEnabled()) {
                    this.mainLog_.error((Object)("Malformed refresh string (no valid number before ';') " + refreshString), (Throwable)e);
                }
                return;
            }
            index = refreshString.toLowerCase().indexOf("url=", index);
            if (index == -1) {
                if (this.mainLog_.isErrorEnabled()) {
                    this.mainLog_.error((Object)("Malformed refresh string (found ';' but no 'url='): " + refreshString));
                }
                return;
            }
            StringBuilder buffer = new StringBuilder(refreshString.substring(index + 4));
            if (buffer.toString().trim().length() == 0) {
                url = this.getWebResponse().getUrl();
            } else {
                if (buffer.charAt(0) == '\"' || buffer.charAt(0) == '\'') {
                    buffer.deleteCharAt(0);
                }
                if (buffer.charAt(buffer.length() - 1) == '\"' || buffer.charAt(buffer.length() - 1) == '\'') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                String urlString = buffer.toString();
                try {
                    url = this.getFullyQualifiedUrl(urlString);
                }
                catch (MalformedURLException e) {
                    if (this.mainLog_.isErrorEnabled()) {
                        this.mainLog_.error((Object)("Malformed URL in refresh string: " + refreshString), (Throwable)e);
                    }
                    throw e;
                }
            }
        }
        this.getWebClient().getRefreshHandler().handleRefresh(this, url, time);
    }

    private String getRefreshStringOrNull() {
        boolean javaScriptEnabled = this.getWebClient().isJavaScriptEnabled();
        for (HtmlMeta meta : this.getMetaTags("refresh")) {
            if (javaScriptEnabled && this.getFirstParent(meta, "noscript") != null) continue;
            return meta.getContentAttribute();
        }
        return this.getWebResponse().getResponseHeaderValue("Refresh");
    }

    private void executeDeferredScriptsIfNeeded() {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return;
        }
        if (!this.getWebClient().getBrowserVersion().isIE()) {
            return;
        }
        HtmlElement doc = this.getDocumentElement();
        List elements = doc.getHtmlElementsByTagName("script");
        for (HtmlElement e : elements) {
            HtmlScript script;
            if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred()) continue;
            script.executeScriptIfNeeded(true);
        }
    }

    private void setReadyStateOnDeferredScriptsIfNeeded() {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return;
        }
        if (!this.getWebClient().getBrowserVersion().isIE()) {
            return;
        }
        List elements = this.getDocumentElement().getHtmlElementsByTagName("script");
        for (HtmlElement e : elements) {
            HtmlScript script;
            if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred()) continue;
            script.setReadyStateComplete();
        }
    }

    private DomNode getFirstParent(DomNode node, String nodeName) {
        for (DomNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!parent.getNodeName().equals(nodeName)) continue;
            return parent;
        }
        return null;
    }

    public void deregisterFramesIfNeeded() {
        for (FrameWindow window : this.getFrames()) {
            HtmlPage page;
            this.getWebClient().deregisterWebWindow(window);
            if (!(window.getEnclosedPage() instanceof HtmlPage) || (page = (HtmlPage)window.getEnclosedPage()) == null) continue;
            page.deregisterFramesIfNeeded();
        }
    }

    public List<FrameWindow> getFrames() {
        ArrayList<FrameWindow> list = new ArrayList<FrameWindow>();
        WebWindow enclosingWindow = this.getEnclosingWindow();
        for (WebWindow window : this.getWebClient().getWebWindows()) {
            if (enclosingWindow != window.getParentWindow() || enclosingWindow == window) continue;
            list.add((FrameWindow)window);
        }
        return list;
    }

    public FrameWindow getFrameByName(String name) throws ElementNotFoundException {
        for (FrameWindow frame : this.getFrames()) {
            if (!frame.getName().equals(name)) continue;
            return frame;
        }
        throw new ElementNotFoundException("frame or iframe", "name", name);
    }

    public HtmlElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getHtmlElementByAccessKey(accessKey);
        if (element != null) {
            element.focus();
            Object newPage = element instanceof HtmlAnchor ? ((HtmlAnchor)element).click() : (element instanceof HtmlArea ? ((HtmlArea)element).click() : (element instanceof HtmlButton ? ((HtmlButton)element).click() : (element instanceof HtmlInput ? ((HtmlInput)element).click() : (element instanceof HtmlLabel ? ((HtmlLabel)element).click() : (element instanceof HtmlLegend ? ((HtmlLegend)element).click() : (element instanceof HtmlTextArea ? ((HtmlTextArea)element).click() : this))))));
            if (newPage != this && this.getFocusedElement() == element) {
                this.getFocusedElement().blur();
            }
        }
        return this.getFocusedElement();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(0) : (index == elements.size() - 1 ? elements.get(0) : elements.get(index + 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(elements.size() - 1) : (index == 0 ? elements.get(elements.size() - 1) : elements.get(index - 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public <E extends HtmlElement> E getHtmlElementById(String id) throws ElementNotFoundException {
        List<HtmlElement> elements = this.idMap_.get(id);
        if (elements != null) {
            return (E)elements.get(0);
        }
        throw new ElementNotFoundException("*", "id", id);
    }

    public List<HtmlElement> getHtmlElementsByName(String name) {
        List<HtmlElement> list = this.nameMap_.get(name);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<HtmlElement> getHtmlElementsByIdAndOrName(String idAndOrName) {
        List<HtmlElement> list1 = this.idMap_.get(idAndOrName);
        List<HtmlElement> list2 = this.nameMap_.get(idAndOrName);
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            for (HtmlElement elt : list2) {
                if (list.contains(elt)) continue;
                list.add(elt);
            }
        }
        return Collections.unmodifiableList(list);
    }

    void addMappedElement(HtmlElement element) {
        this.addMappedElement(element, false);
    }

    void addMappedElement(HtmlElement element, boolean recurse) {
        if (this.isDescendant(element)) {
            this.addElement(this.idMap_, element, "id", recurse);
            this.addElement(this.nameMap_, element, "name", recurse);
        }
    }

    private boolean isDescendant(HtmlElement element) {
        for (DomNode parent = element; parent != null; parent = parent.getParentNode()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    private void addElement(Map<String, List<HtmlElement>> map, HtmlElement element, String attribute, boolean recurse) {
        String value = element.getAttributeValue(attribute);
        if (!StringUtils.isEmpty((String)value)) {
            List<HtmlElement> elements = map.get(value);
            if (elements == null) {
                elements = new ArrayList<HtmlElement>();
                elements.add(element);
                map.put(value, elements);
            } else if (!elements.contains(element)) {
                elements.add(element);
            }
        }
        if (recurse) {
            for (HtmlElement child : element.getChildElements()) {
                this.addElement(map, child, attribute, true);
            }
        }
    }

    void removeMappedElement(HtmlElement element) {
        this.removeMappedElement(element, false, false);
    }

    void removeMappedElement(HtmlElement element, boolean recurse, boolean descendant) {
        if (descendant || this.isDescendant(element)) {
            this.removeElement(this.idMap_, element, "id", recurse);
            this.removeElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void removeElement(Map<String, List<HtmlElement>> map, HtmlElement element, String att, boolean recurse) {
        List<HtmlElement> elements;
        String value = element.getAttributeValue(att);
        if (!(StringUtils.isEmpty((String)value) || (elements = map.remove(value)) == null || elements.size() == 1 && elements.contains(element))) {
            elements.remove(element);
            map.put(value, elements);
        }
        if (recurse) {
            for (HtmlElement child : element.getChildElements()) {
                this.removeElement(map, child, att, true);
            }
        }
    }

    void notifyNodeAdded(DomNode node) {
        if (node instanceof HtmlElement) {
            boolean insideNoScript = false;
            if (this.getWebClient().isJavaScriptEnabled()) {
                for (DomNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                    if (!(parent instanceof HtmlNoScript)) continue;
                    insideNoScript = true;
                    break;
                }
            }
            if (!insideNoScript) {
                this.addMappedElement((HtmlElement)node, true);
            }
        }
        node.onAddedToPage();
    }

    void notifyNodeRemoved(DomNode node) {
        if (node instanceof HtmlElement) {
            this.removeMappedElement((HtmlElement)node, true, true);
        }
    }

    void loadFrames() throws FailingHttpStatusCodeException {
        for (FrameWindow w : this.getFrames()) {
            BaseFrame frame = w.getFrameElement();
            if (frame.getEnclosedPage().getWebResponse().getUrl() != WebClient.URL_ABOUT_BLANK) continue;
            frame.loadInnerPage();
        }
    }

    @Override
    public String asXml() {
        return this.getDocumentElement().asXml();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("HtmlPage(");
        buffer.append(this.getWebResponse().getUrl());
        buffer.append(")@");
        buffer.append(this.hashCode());
        return buffer.toString();
    }

    @Deprecated
    public boolean moveFocusToElement(HtmlElement newElement) {
        return this.setFocusedElement(newElement);
    }

    public boolean setFocusedElement(HtmlElement newElement) {
        return this.setFocusedElement(newElement, false);
    }

    public boolean setFocusedElement(HtmlElement newElement, boolean windowActivated) {
        if (this.elementWithFocus_ == newElement && !windowActivated) {
            return true;
        }
        if (newElement != null && newElement.getPage() != this) {
            throw new IllegalArgumentException("Can't move focus to an element from an other page");
        }
        if (!windowActivated) {
            if (this.elementWithFocus_ != null) {
                this.elementWithFocus_.fireEvent("focusout");
            }
            if (newElement != null) {
                newElement.fireEvent("focusin");
            }
            if (this.elementWithFocus_ != null) {
                if (this.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.BLUR_BEFORE_ONCHANGE)) {
                    this.elementWithFocus_.fireEvent("blur");
                    this.elementWithFocus_.removeFocus();
                } else {
                    this.elementWithFocus_.removeFocus();
                    this.elementWithFocus_.fireEvent("blur");
                }
            }
        }
        this.elementWithFocus_ = newElement;
        if (newElement != null) {
            this.elementWithFocus_.focus();
            newElement.fireEvent("focus");
        }
        return this == this.getEnclosingWindow().getEnclosedPage();
    }

    @Deprecated
    public HtmlElement getElementWithFocus() {
        return this.getFocusedElement();
    }

    public HtmlElement getFocusedElement() {
        return this.elementWithFocus_;
    }

    protected List<HtmlMeta> getMetaTags(String httpEquiv) {
        String nameLC = httpEquiv.toLowerCase();
        List<HtmlMeta> tags = this.getDocumentElement().getHtmlElementsByTagName("meta");
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            HtmlMeta element = (HtmlMeta)iter.next();
            if (nameLC.equals(element.getHttpEquivAttribute().toLowerCase())) continue;
            iter.remove();
        }
        return tags;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        List<?> pageInputs = this.getByXPath("//input[lower-case(@type)='radio' and @name='" + radioButtonInput.getNameAttribute() + "']");
        List<?> formInputs = this.getByXPath("//form//input[lower-case(@type)='radio' and @name='" + radioButtonInput.getNameAttribute() + "']");
        pageInputs.removeAll(formInputs);
        for (HtmlRadioButtonInput input : pageInputs) {
            if (input == radioButtonInput) {
                input.setAttributeValue("checked", "checked");
                continue;
            }
            input.removeAttribute("checked");
        }
    }

    protected HtmlPage clone() {
        try {
            HtmlPage result = (HtmlPage)super.clone();
            result.documentElement_ = null;
            result.elementWithFocus_ = null;
            result.idMap_ = new HashMap<String, List<HtmlElement>>();
            result.nameMap_ = new HashMap<String, List<HtmlElement>>();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported");
        }
    }

    @Override
    public HtmlPage cloneNode(boolean deep) {
        HtmlPage result = (HtmlPage)super.cloneNode(deep);
        result.setScriptObject(this.getScriptObject());
        if (deep) {
            for (HtmlElement child : result.getAllHtmlChildElements()) {
                this.removeMappedElement(child);
                result.addMappedElement(child);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new ArrayList<HtmlAttributeChangeListener>();
            }
            if (!this.attributeListeners_.contains(listener)) {
                this.attributeListeners_.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeAdded(event);
            }
        }
    }

    void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeReplaced(event);
            }
        }
    }

    void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HtmlAttributeChangeListener> safeGetAttributeListeners() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                return new ArrayList<HtmlAttributeChangeListener>(this.attributeListeners_);
            }
            return null;
        }
    }

    @Override
    protected void checkChildHierarchy(org.w3c.dom.Node newChild) throws DOMException {
        if (newChild instanceof Element) {
            if (this.getDocumentElement() != null) {
                throw new DOMException(3, "The Document may only have a single child Element.");
            }
        } else if (newChild instanceof DocumentType) {
            if (this.getDoctype() != null) {
                throw new DOMException(3, "The Document may only have a single child DocumentType.");
            }
        } else if (!(newChild instanceof Comment) && !(newChild instanceof ProcessingInstruction)) {
            throw new DOMException(3, "The Document may not have a child of this type: " + newChild.getNodeType());
        }
        super.checkChildHierarchy(newChild);
    }

    public boolean isOnbeforeunloadAccepted() {
        return this.executeEventHandlersIfNeeded("beforeunload");
    }

    public boolean isBeingParsed() {
        return this.parserCount_ > 0;
    }

    void registerParsingStart() {
        ++this.parserCount_;
    }

    void registerParsingEnd() {
        --this.parserCount_;
    }

    public Page refresh() throws IOException {
        return this.getWebClient().getPage(this.getWebResponse().getRequestSettings());
    }

    public void writeInParsedStream(String string) {
        this.builder_.pushInputString(string);
    }

    void setBuilder(HTMLParser.HtmlUnitDOMBuilder htmlUnitDOMBuilder) {
        this.builder_ = htmlUnitDOMBuilder;
    }

    HTMLParser.HtmlUnitDOMBuilder getBuilder() {
        return this.builder_;
    }

    void registerSnippetParsingStart() {
        ++this.snippetParserCount_;
    }

    void registerSnippetParsingEnd() {
        --this.snippetParserCount_;
    }

    boolean isParsingHtmlSnippet() {
        return this.snippetParserCount_ > 0;
    }

    public Range getSelection() {
        return this.selection_;
    }
}

