/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager
implements Serializable {
    private static final long serialVersionUID = 4145377365165079425L;
    public static final String HTMLUNIT_COOKIE_POLICY = "compatibility";
    private boolean cookiesEnabled_ = true;
    private final Set<Cookie> cookies_ = new LinkedHashSet<Cookie>();
    private transient WeakReference<HttpState> lastStateUpdated_ = null;
    private transient boolean cookiesModified_ = false;

    public void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled_ = enabled;
        if (!this.cookiesEnabled_) {
            this.lastStateUpdated_ = null;
        }
    }

    public boolean isCookiesEnabled() {
        return this.cookiesEnabled_;
    }

    public Set<Cookie> getCookies() {
        return Collections.unmodifiableSet(this.cookies_);
    }

    public Set<Cookie> getCookies(String domain) {
        LinkedHashSet<Cookie> cookies = new LinkedHashSet<Cookie>();
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals((String)cookie.getDomain(), (String)domain)) continue;
            cookies.add(cookie);
        }
        return Collections.unmodifiableSet(cookies);
    }

    public Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals((String)cookie.getName(), (String)name)) continue;
            return cookie;
        }
        return null;
    }

    public void addCookie(Cookie cookie) {
        this.cookies_.add(cookie);
        this.cookiesModified_ = true;
    }

    public void removeCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
        this.cookiesModified_ = true;
    }

    public void clearCookies() {
        this.cookies_.clear();
        this.cookiesModified_ = true;
    }

    protected void updateState(HttpState state) {
        HttpState lastStateUpdated;
        if (!this.cookiesEnabled_) {
            return;
        }
        if (this.lastStateUpdated_ != null && state == (lastStateUpdated = (HttpState)this.lastStateUpdated_.get()) && !this.cookiesModified_) {
            return;
        }
        state.clearCookies();
        for (Cookie cookie : this.cookies_) {
            state.addCookie(cookie);
        }
        this.lastStateUpdated_ = new WeakReference<HttpState>(state);
        this.cookiesModified_ = false;
    }

    protected void updateFromState(HttpState state) {
        List<Cookie> stateCookies = Arrays.asList(state.getCookies());
        for (Cookie stateCookie : stateCookies) {
            if (this.cookies_.contains(stateCookie)) continue;
            this.cookies_.add(stateCookie);
            this.cookiesModified_ = true;
        }
        Iterator<Cookie> i = this.cookies_.iterator();
        while (i.hasNext()) {
            Cookie cookie = i.next();
            if (stateCookies.contains(cookie)) continue;
            i.remove();
            this.cookiesModified_ = true;
        }
    }

    boolean isCookiesModified() {
        return this.cookiesModified_;
    }

    HttpState getLastStateUpdated() {
        return (HttpState)this.lastStateUpdated_.get();
    }
}

