package Zing;

use 5.014;

use strict;
use warnings;

use registry 'Zing::Types';
use routines;

use Data::Object::Class;
use Data::Object::ClassHas;

extends 'Zing::Watcher';

use Zing::Kernel;

our $VERSION = '0.03'; # VERSION

# ATTRIBUTES

has 'scheme' => (
  is => 'ro',
  isa => 'Scheme',
  req => 1,
);

# METHODS

method start() {
  Zing::Kernel->new(scheme => $self->scheme)->execute;
}

1;

=encoding utf8

=head1 NAME

Zing - Multi-Process Management System

=cut

=head1 ABSTRACT

Actor Toolkit and Multi-Process Management System

=cut

=head1 SYNOPSIS

  use Zing;

  my $zing = Zing->new(scheme => ['MyApp', [], 1]);

  # $zing->execute;

=cut

=head1 DESCRIPTION

This distribution includes an actor-model architecture toolkit and
Redis-powered multi-process management system which provides primatives for
building powerful, reactive, concurrent, distributed, and resilient
message-driven applications in Perl 5. If you're unfamiliar with this
architectural pattern, learn more about L<"the actor
model"|https://en.wikipedia.org/wiki/Actor_model>.

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Zing::Watcher>

=cut

=head1 LIBRARIES

This package uses type constraints from:

L<Zing::Types>

=cut

=head1 ATTRIBUTES

This package has the following attributes:

=cut

=head2 scheme

  scheme(Scheme)

This attribute is read-only, accepts C<(Scheme)> values, and is required.

=cut

=head1 METHODS

This package implements the following methods:

=cut

=head2 start

  start() : Kernel

The start method builds a L<Zing::Kernel> and executes its event-loop.

=over 4

=item start example #1

  # given: synopsis

  $zing->start;

=back

=cut

=head1 FEATURES

While this is, at present, a proof-of-concept, the API is not expected to
change. The documentation is a work-in-progress. Please see the examples
included for demonstrations of the objects in action. The following is a list
of features currently supported by the framework:

=over 4

=item *

parallel processing

=item *

asynchronous programming

=item *

event-driven applications

=item *

actor-model based framework

=item *

process (actor) mailboxes

=item *

distributed processes (actors)

=item *

erlang-style supervision trees

=item *

hot-reloadable processes (actors)

=item *

automated multi-process management

=item *

atomicity without lock management

=item *

multitasking processes (event-loop actors)

=item *

chainable/extendable process (actor) event-loops

=item *

none-blocking yieldable routines

=item *

high performance message queues

=item *

high performance message channels

=item *

high performance message passing

=item *

built-in high performance log shipping

=item *

operable as a cluster or single-node

=item *

resilient to memory leaks

=item *

no new funcs/idioms

=item *

no callbacks, futures or promises

=item *

no zombie processes

=back

=head1 SEE ALSO

L<The Actor Model|https://en.wikipedia.org/wiki/Actor_model>

L<Concurrent Computation|https://www.amazon.com/Actors-Concurrent-Computation-Distributed-Systems/dp/026251141X>

L<Concurrency in Go/Erlang|https://www.youtube.com/watch?v=2yiKUIDFc2I>

L<The Akka Project|https://github.com/akka/akka>

L<The Actorkit Project|https://github.com/influx6/actorkit>

L<The Orleans Project|http://dotnet.github.io/orleans>

L<The Pyakka Project|https://github.com/jodal/pykka>

L<The Reactive Manifesto|http://www.reactivemanifesto.org>

=head1 AUTHOR

Al Newkirk, C<awncorp@cpan.org>

=head1 LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the L<"license
file"|https://github.com/iamalnewkirk/zing/blob/master/LICENSE>.

=head1 PROJECT

L<Wiki|https://github.com/iamalnewkirk/zing/wiki>

L<Project|https://github.com/iamalnewkirk/zing>

L<Initiatives|https://github.com/iamalnewkirk/zing/projects>

L<Milestones|https://github.com/iamalnewkirk/zing/milestones>

L<Contributing|https://github.com/iamalnewkirk/zing/blob/master/CONTRIBUTE.md>

L<Issues|https://github.com/iamalnewkirk/zing/issues>

=cut