package Data::Object::Autobox::String;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->string(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::String

=cut

=head1 ABSTRACT

Data-Object Autoboxing for String Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::String;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::String> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Str $arg1) : StringObject

Construct a new object.

=over 4

=item new example

  my $string = Data::Object::Autobox::String->new('ehlo');

=back

=cut
