package Data::Object::Autobox::Any;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->any(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Any

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Any Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Any;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Any> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Any $arg1) : AnyObject

Construct a new object.

=over 4

=item new example

  my $any = Data::Object::Autobox::Any->new(\*main);

=back

=cut
