#  Package
#
package WebMod::Proto;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;


#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',

    PM					   =>  {
	'Proto.pm'			   =>  '$(INST_LIBDIR)/Proto.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/Proto/VERSION.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/Proto/LICENSE',
    },

    'dist'				   =>  {
	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz',
    },

    'depend'				   =>  {
	Makefile			   =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Proto.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),


);


