#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebMod::Base.
#
#  WebMod::Base is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Base.pm,v 1.3 2003/11/03 02:45:05 aspeer Exp $


#
#  Packge to bring togther most commonly used base library modules
#
package WebMod::Base;


#  Compiler Pragma
#
use strict qw(vars);


#  Global vars
#
use vars qw(@ISA $VERSION $REVISION $PACKAGE %EXPORT_TAGS);


#  Require the exporter
#
require Exporter;
@ISA=qw(Exporter);


#  External modules
#
use WebMod::Err   qw(:all);
use WebMod::Proto qw(:all);
use WebMod::Debug qw(:all);
use WebMod::Log;


#  Version Info, must be all one line for MakeMaker, CPAN.
#
$VERSION = eval { require WebMod::Base::VERSION; do $INC{'WebMod/Base/VERSION.pm'}};


#  Release info
#
$REVISION = (qw $Revision: 1.3 $)[1];



#  Export Tags
#
%EXPORT_TAGS=(
	all	=>	[]
);


#  Go through each module and add its 'all' tag array into
#  ours
#
foreach my $module (qw(WebMod::Err WebMod::Proto WebMod::Debug)) {


	#  Push onto our all tag
	#
	push @{$EXPORT_TAGS{'all'}}, @{ (\%{"${module}::EXPORT_TAGS"})->{'all'} };

}


#  And add to EXPORT_OK array by default
#
&Exporter::export_ok_tags('all');


#  All done
#
return OK;
