#!/usr/bin/perl
# yharn.t

use strict;
use File::Basename ();
use Acme::EyeDrops qw(sightly);
use Test::Harness;

select(STDERR);$|=1;select(STDOUT);$|=1;  # autoflush

# --------------------------------------------------

sub skip_test {
   my $msg = @_ ? shift() : '';
   print "1..0 # Skipped: $msg\n";
   exit;
}

sub build_file {
   my ($f, $d) = @_;
   local *F; open(F, '>'.$f) or die "open '$f': $!";
   print F $d; close(F);
}

sub get_first_line {
   my $f = shift; local *T; open(T, $f) or die "open '$f': $!";
   my $s = <T>; close(T); $s;
}

# --------------------------------------------------

skip_test('Skipping long running generator tests unless $ENV{PERL_SMOKE} is true')
   unless $ENV{PERL_SMOKE};

print STDERR "Long running generated tests running...\n";
print STDERR "(these are only run if PERL_SMOKE environment variable is true).\n";

print "1..1\n";

# --------------------------------------------------

my $outf = 'out.tmp';
my $errf = 'err.tmp';
-f $outf and (unlink($outf) or die "error: unlink '$outf': $!");
-f $errf and (unlink($errf) or die "error: unlink '$errf': $!");

my %attrs = (
   Shape          => 'camel',
   Regex          => 0,
   Compact        => 1,
   TrapEvalDie    => 1,
   InformHandler  => sub {},
   Shape          => 'camel',
   Gap            => 1
);
my @pnames = ( 'border.t', 'vshape.t', 'text.t', 'sightly.t' );
# zsightly.t test works but the following might be written to stderr:
# Scalar found where operator expected at (eval 2) line 41, near "regex_eval_sightly($hellostr"
# This seems to happen only on Perl versions before 5.6.1. Is this a Perl bug?

my $itest = 0;

# --------------------------------------------------

# Generate sightly-encoded versions of test programs (see also gen.t).

my $base = File::Basename::dirname($0);
for my $p (@pnames) {
   $attrs{SourceFile} = "$base/$p";
   # Assume first line is #!/usr/bin/perl (needed for taint mode tests).
   my $s_new = get_first_line($attrs{SourceFile}) .
               "# This program was generated by yharn.t\n";
   $s_new .= sightly(\%attrs);
   build_file("$base/z$p", $s_new);
}

# Run them with TestHarness::runtests

my @tests = map("$base/z$_", @pnames);

local *SAVERR; open(SAVERR, ">&STDERR");  # save original STDERR
local *SAVOUT; open(SAVOUT, ">&STDOUT");  # save original STDOUT
open(STDOUT, '>'.$outf) or die "Could not create '$outf': $!";
open(STDERR, '>'.$errf) or die "Could not create '$errf': $!";

my $status = runtests(@tests);

open(STDERR, ">&SAVERR");  # restore STDERR
open(STDOUT, ">&SAVOUT");  # restore STDOUT

my $outstr = Acme::EyeDrops::slurp_tfile($outf);
my $errstr = Acme::EyeDrops::slurp_tfile($errf);

print STDERR "stdout of TestHarness::runtests:\n$outstr\n";
print STDERR "stderr of TestHarness::runtests:\n$errstr\n";

$status or print "not ";
++$itest; print "ok $itest - TestHarness::runtests of generated tests\n";

# ----------------------------------------------------

for my $t (@tests) { unlink($t) or die "error: unlink '$t': $!" }

unlink($outf) or die "error: unlink '$outf': $!";
unlink($errf) or die "error: unlink '$errf': $!";

exit 0;
