package Arthas::Defaults;

use v5.14;
use warnings;
use utf8;

use version;
our $VERSION = qv("v1.0.1");

sub import {
    feature->import(':5.14');
    warnings->import();
    warnings->unimport('uninitialized');
}

sub unimport {
    feature->unimport();
    warnings->unimport();
}


=head1 NAME

Arthas::Defaults - Defaults for coding - Do not use if you're not Arthas

=head1 SYNOPSIS

    use Arthas::Defaults;

=head1 DESCRIPTION

It's like saying:

    use v5.14;
    use utf8;
    use warnings;
    no warnings 'uninitialized';

Might change without notice, at any time. DO NOT USE!

=head1 AUTHOR

Michele Beltrame, C<mb@italpro.net>

=head1 LICENSE

This library is free software . You can redistribute it and/or modify
it under the same terms as perl itself.

=cut

1;
