package main;
use Evo::Base -strict;
use Test::More;

plan skip_all => 'set TEST_PROMISES env to enable this test'
  unless $ENV{TEST_PROMISES};

plan tests => 4;
eval { require Promises; };
use Promises6 'deferred';

my $d;

$d = deferred;
$d->promise

  # rej
  ->then(sub { Promises::Deferred->new->reject('reason')->promise })
  ->then(sub {fail}, sub {pass})

  # resolve
  ->then(sub { Promises::Deferred->new->resolve('reason')->promise })
  ->then(sub {pass}, sub {fail});


$d->resolve('S');

$d = Promises::Deferred->new;

$d->promise

  # rej
  ->then(sub { deferred->reject('reason')->promise })
  ->then(sub {fail}, sub($v) { is $v, 'reason' })

  # resolve
  ->then(sub { deferred->resolve('value')->promise })
  ->then(sub($v) { is $v, 'value' }, sub {fail});


$d->resolve('S');

done_testing;
