use Devel::CheckLib;
check_lib_or_exit(lib => 'dl');
check_lib_or_exit(lib => 'ffi');
# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Raw FFI library for Perl',
  'AUTHOR' => 'Alessandro Ghedini <alexbio@cpan.org>',
  'BUILD_REQUIRES' => {
    'File::Find' => '0',
    'File::Temp' => '0',
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'Devel::CheckLib' => '0',
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'FFI-Raw',
  'EXE_FILES' => [],
  'INC' => '-I.',
  'LIBS' => [
    '-ldl -lffi'
  ],
  'LICENSE' => 'perl',
  'NAME' => 'FFI::Raw',
  'OBJECT' => '$(O_FILES)',
  'PREREQ_PM' => {
    'XSLoader' => '0',
    'strict' => '0',
    'warnings' => '0'
  },
  'VERSION' => '0.01',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

