#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Template distribution).
#
#------------------------------------------------------------------------
#
# $Id: Grammar.pm,v 2.14 2001/11/29 16:44:19 abw Exp $
#
#========================================================================

package Template::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.14 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ne
    == eq
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			"\"" => 45,
			'BLOCK' => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			"[" => 53,
			'DEFAULT' => 52,
			"{" => 17,
			'THROW' => 57,
			'CALL' => 56,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 30,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'loop' => 55,
			'defblock' => 54,
			'capture' => 18,
			'template' => 42,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 1
		DEFAULT => -101
	},
	{#State 2
		DEFAULT => -110
	},
	{#State 3
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 73,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 4
		DEFAULT => -24
	},
	{#State 5
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -27
	},
	{#State 6
		DEFAULT => -76,
		GOTOS => {
			'@5-1' => 75
		}
	},
	{#State 7
		ACTIONS => {
			'IDENT' => 76
		}
	},
	{#State 8
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 86,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 9
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 89
		},
		DEFAULT => -106
	},
	{#State 10
		DEFAULT => -15
	},
	{#State 11
		DEFAULT => -6
	},
	{#State 12
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 51,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 91,
			'assign' => 92,
			'item' => 25,
			'ident' => 90,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 13
		DEFAULT => -21
	},
	{#State 14
		DEFAULT => -12
	},
	{#State 15
		ACTIONS => {
			";" => 93
		}
	},
	{#State 16
		ACTIONS => {
			'IDENT' => 95
		},
		GOTOS => {
			'meta' => 96,
			'metadata' => 94
		}
	},
	{#State 17
		ACTIONS => {
			"\${" => 49,
			'LITERAL' => 99,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -116,
		GOTOS => {
			'param' => 101,
			'params' => 97,
			'item' => 98,
			'hash' => 100
		}
	},
	{#State 18
		DEFAULT => -11
	},
	{#State 19
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			";" => -16,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -26
	},
	{#State 20
		DEFAULT => -100
	},
	{#State 21
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 112,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 22
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 113,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 23
		ACTIONS => {
			"\${" => 49,
			'LITERAL' => 116,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 69,
			'setlist' => 115,
			'item' => 25,
			'ident' => 114,
			'node' => 58
		}
	},
	{#State 24
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 117,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 25
		ACTIONS => {
			"(" => 118
		},
		DEFAULT => -125
	},
	{#State 26
		ACTIONS => {
			'COMMA' => 119,
			"\${" => 49,
			'LITERAL' => 116,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -19,
		GOTOS => {
			'assign' => 120,
			'item' => 25,
			'ident' => 114,
			'node' => 58
		}
	},
	{#State 27
		DEFAULT => -5
	},
	{#State 28
		DEFAULT => -127
	},
	{#State 29
		ACTIONS => {
			";" => 121
		}
	},
	{#State 30
		DEFAULT => -1
	},
	{#State 31
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 122,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 32
		ACTIONS => {
			"\${" => 49,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 123,
			'node' => 58
		}
	},
	{#State 33
		ACTIONS => {
			'IDENT' => 124
		}
	},
	{#State 34
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 125,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 35
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 126,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 36
		DEFAULT => -8
	},
	{#State 37
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 131,
			"\${" => 49,
			'FILENAME' => 79,
			'LITERAL' => 132,
			'IDENT' => 129,
			"\$" => 127
		},
		GOTOS => {
			'lvalue' => 133,
			'lnameargs' => 130,
			'nameargs' => 134,
			'item' => 128,
			'filename' => 80,
			'filepart' => 85,
			'name' => 82,
			'names' => 87
		}
	},
	{#State 38
		DEFAULT => -36
	},
	{#State 39
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 135,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 40
		DEFAULT => -41
	},
	{#State 41
		DEFAULT => -39
	},
	{#State 42
		ACTIONS => {
			'' => 136
		}
	},
	{#State 43
		ACTIONS => {
			";" => 137
		}
	},
	{#State 44
		ACTIONS => {
			'NUMBER' => 77,
			'FILENAME' => 79,
			'LITERAL' => 143,
			'IDENT' => 141
		},
		DEFAULT => -84,
		GOTOS => {
			'meta' => 96,
			'blockname' => 142,
			'filename' => 140,
			'blockargs' => 138,
			'filepart' => 85,
			'metadata' => 139
		}
	},
	{#State 45
		DEFAULT => -173,
		GOTOS => {
			'quoted' => 144
		}
	},
	{#State 46
		DEFAULT => -22
	},
	{#State 47
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 131,
			"\${" => 49,
			'FILENAME' => 79,
			'LITERAL' => 132,
			'IDENT' => 129,
			"\$" => 127
		},
		GOTOS => {
			'lvalue' => 133,
			'lnameargs' => 145,
			'nameargs' => 134,
			'item' => 128,
			'filename' => 80,
			'filepart' => 85,
			'name' => 82,
			'names' => 87
		}
	},
	{#State 48
		DEFAULT => -10
	},
	{#State 49
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 49,
			'REF' => 32,
			'LITERAL' => 74,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 146,
			'item' => 25,
			'ident' => 72,
			'node' => 58
		}
	},
	{#State 50
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -2,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 147,
			'atomdir' => 5,
			'switch' => 46,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 51
		ACTIONS => {
			'ASSIGN' => 148
		},
		DEFAULT => -109
	},
	{#State 52
		ACTIONS => {
			"\${" => 49,
			'LITERAL' => 116,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 69,
			'setlist' => 149,
			'item' => 25,
			'ident' => 114,
			'node' => 58
		}
	},
	{#State 53
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			"]" => 152,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 150,
			'list' => 151,
			'range' => 153,
			'item' => 25,
			'ident' => 72,
			'term' => 154,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 54
		DEFAULT => -9
	},
	{#State 55
		DEFAULT => -23
	},
	{#State 56
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 155,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 57
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 156,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 58
		DEFAULT => -124
	},
	{#State 59
		DEFAULT => -37
	},
	{#State 60
		DEFAULT => -14
	},
	{#State 61
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 157,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 159,
			'lterm' => 20,
			'loopvar' => 158,
			'node' => 58
		}
	},
	{#State 62
		DEFAULT => -25
	},
	{#State 63
		DEFAULT => -38
	},
	{#State 64
		DEFAULT => -42
	},
	{#State 65
		DEFAULT => -13
	},
	{#State 66
		DEFAULT => -40
	},
	{#State 67
		ACTIONS => {
			'FOR' => 164,
			'UNLESS' => 160,
			'IF' => 165,
			'WHILE' => 162,
			'FILTER' => 163,
			'WRAPPER' => 161
		}
	},
	{#State 68
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 166,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 69
		DEFAULT => -146
	},
	{#State 70
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 167,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 71
		DEFAULT => -143
	},
	{#State 72
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -106
	},
	{#State 73
		ACTIONS => {
			'CAT' => 109,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -139
	},
	{#State 74
		DEFAULT => -109
	},
	{#State 75
		ACTIONS => {
			";" => 168
		}
	},
	{#State 76
		DEFAULT => -129
	},
	{#State 77
		DEFAULT => -171
	},
	{#State 78
		ACTIONS => {
			"\${" => 49,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 169,
			'node' => 58
		}
	},
	{#State 79
		DEFAULT => -169
	},
	{#State 80
		ACTIONS => {
			'DOT' => 170
		},
		DEFAULT => -165
	},
	{#State 81
		DEFAULT => -170
	},
	{#State 82
		DEFAULT => -163
	},
	{#State 83
		DEFAULT => -173,
		GOTOS => {
			'quoted' => 171
		}
	},
	{#State 84
		DEFAULT => -166
	},
	{#State 85
		DEFAULT => -168
	},
	{#State 86
		DEFAULT => -34
	},
	{#State 87
		ACTIONS => {
			"(" => 173,
			"+" => 174
		},
		DEFAULT => -153,
		GOTOS => {
			'args' => 172
		}
	},
	{#State 88
		ACTIONS => {
			'NUMBER' => 175,
			"\${" => 49,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'node' => 176
		}
	},
	{#State 89
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 180,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			"(" => 12,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		GOTOS => {
			'directive' => 179,
			'sterm' => 1,
			'mdir' => 177,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 67,
			'loop' => 55,
			'expr' => 178,
			'assign' => 69,
			'perl' => 62,
			'ident' => 90,
			'term' => 71,
			'filter' => 64,
			'lterm' => 20,
			'node' => 58,
			'condition' => 13
		}
	},
	{#State 90
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 181
		},
		DEFAULT => -106
	},
	{#State 91
		ACTIONS => {
			'MOD' => 102,
			")" => 182,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		}
	},
	{#State 92
		ACTIONS => {
			")" => 183
		}
	},
	{#State 93
		DEFAULT => -7
	},
	{#State 94
		ACTIONS => {
			'COMMA' => 184,
			'IDENT' => 95
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 185
		}
	},
	{#State 95
		ACTIONS => {
			'ASSIGN' => 186
		}
	},
	{#State 96
		DEFAULT => -96
	},
	{#State 97
		ACTIONS => {
			'COMMA' => 187,
			"\${" => 49,
			'LITERAL' => 99,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -115,
		GOTOS => {
			'param' => 188,
			'item' => 98
		}
	},
	{#State 98
		ACTIONS => {
			'ASSIGN' => 189
		}
	},
	{#State 99
		ACTIONS => {
			'ASSIGN' => 190
		}
	},
	{#State 100
		ACTIONS => {
			"}" => 191
		}
	},
	{#State 101
		DEFAULT => -119
	},
	{#State 102
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 192,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 103
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 193,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 104
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 194,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 105
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 195,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 106
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 196,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 107
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 197,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 108
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 198,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 109
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 199,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 110
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 200,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 111
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 201,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 112
		ACTIONS => {
			";" => 202
		}
	},
	{#State 113
		DEFAULT => -32
	},
	{#State 114
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 181
		}
	},
	{#State 115
		ACTIONS => {
			'LITERAL' => 116,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 119,
			"\${" => 49
		},
		DEFAULT => -30,
		GOTOS => {
			'assign' => 120,
			'item' => 25,
			'ident' => 114,
			'node' => 58
		}
	},
	{#State 116
		ACTIONS => {
			'ASSIGN' => 148
		}
	},
	{#State 117
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			";" => 203,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		}
	},
	{#State 118
		DEFAULT => -153,
		GOTOS => {
			'args' => 204
		}
	},
	{#State 119
		DEFAULT => -145
	},
	{#State 120
		DEFAULT => -144
	},
	{#State 121
		DEFAULT => -74,
		GOTOS => {
			'@4-2' => 205
		}
	},
	{#State 122
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			";" => 206,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		}
	},
	{#State 123
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -107
	},
	{#State 124
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 180,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			"(" => 207,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		GOTOS => {
			'directive' => 179,
			'sterm' => 1,
			'mdir' => 208,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 67,
			'loop' => 55,
			'expr' => 209,
			'assign' => 69,
			'perl' => 62,
			'ident' => 90,
			'term' => 71,
			'filter' => 64,
			'lterm' => 20,
			'node' => 58,
			'condition' => 13
		}
	},
	{#State 125
		DEFAULT => -33
	},
	{#State 126
		ACTIONS => {
			";" => 210
		}
	},
	{#State 127
		ACTIONS => {
			"\${" => 49,
			'IDENT' => 211,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 169,
			'node' => 58
		}
	},
	{#State 128
		DEFAULT => -156
	},
	{#State 129
		ACTIONS => {
			'ASSIGN' => -127
		},
		DEFAULT => -170
	},
	{#State 130
		DEFAULT => -71
	},
	{#State 131
		DEFAULT => -173,
		GOTOS => {
			'quoted' => 212
		}
	},
	{#State 132
		ACTIONS => {
			'ASSIGN' => -158
		},
		DEFAULT => -166
	},
	{#State 133
		ACTIONS => {
			'ASSIGN' => 213
		}
	},
	{#State 134
		DEFAULT => -155
	},
	{#State 135
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			";" => 214,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		}
	},
	{#State 136
		DEFAULT => -0
	},
	{#State 137
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 215,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 138
		ACTIONS => {
			";" => 216
		}
	},
	{#State 139
		ACTIONS => {
			'COMMA' => 184,
			'IDENT' => 95
		},
		DEFAULT => -83,
		GOTOS => {
			'meta' => 185
		}
	},
	{#State 140
		ACTIONS => {
			'DOT' => 170
		},
		DEFAULT => -81
	},
	{#State 141
		ACTIONS => {
			'ASSIGN' => 186
		},
		DEFAULT => -170
	},
	{#State 142
		ACTIONS => {
			'IDENT' => 95
		},
		DEFAULT => -84,
		GOTOS => {
			'meta' => 96,
			'blockargs' => 217,
			'metadata' => 139
		}
	},
	{#State 143
		DEFAULT => -82
	},
	{#State 144
		ACTIONS => {
			"\"" => 221,
			"\${" => 49,
			'TEXT' => 219,
			";" => 220,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 222,
			'item' => 25,
			'ident' => 218,
			'node' => 58
		}
	},
	{#State 145
		ACTIONS => {
			";" => 223
		}
	},
	{#State 146
		ACTIONS => {
			"}" => 224
		}
	},
	{#State 147
		DEFAULT => -4
	},
	{#State 148
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 225,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 149
		ACTIONS => {
			'LITERAL' => 116,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 119,
			"\${" => 49
		},
		DEFAULT => -31,
		GOTOS => {
			'assign' => 120,
			'item' => 25,
			'ident' => 114,
			'node' => 58
		}
	},
	{#State 150
		ACTIONS => {
			'TO' => 226
		},
		DEFAULT => -101
	},
	{#State 151
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 228,
			"{" => 17,
			"]" => 227,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 229,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 152
		DEFAULT => -104
	},
	{#State 153
		ACTIONS => {
			"]" => 230
		}
	},
	{#State 154
		DEFAULT => -113
	},
	{#State 155
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -29
	},
	{#State 156
		DEFAULT => -35
	},
	{#State 157
		ACTIONS => {
			'ASSIGN' => 231
		},
		DEFAULT => -127
	},
	{#State 158
		ACTIONS => {
			";" => 232
		}
	},
	{#State 159
		DEFAULT => -153,
		GOTOS => {
			'args' => 233
		}
	},
	{#State 160
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 234,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 161
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 235,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 162
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 236,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 163
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 131,
			"\${" => 49,
			'FILENAME' => 79,
			'LITERAL' => 132,
			'IDENT' => 129,
			"\$" => 127
		},
		GOTOS => {
			'lvalue' => 133,
			'lnameargs' => 237,
			'nameargs' => 134,
			'item' => 128,
			'filename' => 80,
			'filepart' => 85,
			'name' => 82,
			'names' => 87
		}
	},
	{#State 164
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 157,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 159,
			'lterm' => 20,
			'loopvar' => 238,
			'node' => 58
		}
	},
	{#State 165
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 239,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 166
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -28
	},
	{#State 167
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			";" => 240,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		}
	},
	{#State 168
		ACTIONS => {
			'TEXT' => 241
		}
	},
	{#State 169
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -153,
		GOTOS => {
			'args' => 242
		}
	},
	{#State 170
		ACTIONS => {
			'NUMBER' => 77,
			'FILENAME' => 79,
			'IDENT' => 81
		},
		GOTOS => {
			'filepart' => 243
		}
	},
	{#State 171
		ACTIONS => {
			"\"" => 244,
			"\${" => 49,
			'TEXT' => 219,
			";" => 220,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 222,
			'item' => 25,
			'ident' => 218,
			'node' => 58
		}
	},
	{#State 172
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'IDENT' => 28,
			"\$" => 7,
			'REF' => 32,
			"\${" => 49,
			'LITERAL' => 247,
			"[" => 53,
			"{" => 17,
			'COMMA' => 248
		},
		DEFAULT => -160,
		GOTOS => {
			'sterm' => 1,
			'param' => 249,
			'item' => 246,
			'ident' => 245,
			'term' => 250,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 173
		DEFAULT => -153,
		GOTOS => {
			'args' => 251
		}
	},
	{#State 174
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81
		},
		GOTOS => {
			'filename' => 80,
			'filepart' => 85,
			'name' => 252
		}
	},
	{#State 175
		DEFAULT => -123
	},
	{#State 176
		DEFAULT => -122
	},
	{#State 177
		DEFAULT => -86
	},
	{#State 178
		ACTIONS => {
			'CAT' => 109,
			'IDENT' => -147,
			"\$" => -147,
			'AND' => 105,
			"\${" => -147,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			";" => -147,
			'LITERAL' => -147,
			'COMMA' => -147,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -26
	},
	{#State 179
		DEFAULT => -89
	},
	{#State 180
		ACTIONS => {
			";" => 253
		}
	},
	{#State 181
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 254,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 182
		DEFAULT => -142
	},
	{#State 183
		DEFAULT => -141
	},
	{#State 184
		DEFAULT => -95
	},
	{#State 185
		DEFAULT => -94
	},
	{#State 186
		ACTIONS => {
			'NUMBER' => 255,
			"\"" => 256,
			'LITERAL' => 257
		}
	},
	{#State 187
		DEFAULT => -118
	},
	{#State 188
		DEFAULT => -117
	},
	{#State 189
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 258,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 190
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 259,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 191
		DEFAULT => -105
	},
	{#State 192
		DEFAULT => -134
	},
	{#State 193
		ACTIONS => {
			'MOD' => 102,
			'AND' => 105,
			'BINOP' => 104,
			'DIV' => 108,
			":" => 260,
			'CMPOP' => 106,
			"/" => 111,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			"?" => 103
		}
	},
	{#State 194
		ACTIONS => {
			'MOD' => 102,
			"+" => 110,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -130
	},
	{#State 195
		ACTIONS => {
			'CAT' => 109,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -137
	},
	{#State 196
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -135
	},
	{#State 197
		ACTIONS => {
			'CAT' => 109,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -138
	},
	{#State 198
		ACTIONS => {
			'MOD' => 102
		},
		DEFAULT => -133
	},
	{#State 199
		ACTIONS => {
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -136
	},
	{#State 200
		ACTIONS => {
			'MOD' => 102,
			'DIV' => 108,
			"/" => 111
		},
		DEFAULT => -132
	},
	{#State 201
		ACTIONS => {
			'MOD' => 102,
			'DIV' => 108
		},
		DEFAULT => -131
	},
	{#State 202
		DEFAULT => -72,
		GOTOS => {
			'@3-3' => 261
		}
	},
	{#State 203
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 262,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 204
		ACTIONS => {
			")" => 263,
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 247,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 248,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 249,
			'item' => 246,
			'ident' => 245,
			'term' => 250,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 205
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 264,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 206
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 265,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 207
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 51,
			"[" => 53,
			'IDENT' => 266,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 91,
			'assign' => 92,
			'margs' => 267,
			'item' => 25,
			'ident' => 90,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 208
		DEFAULT => -88
	},
	{#State 209
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -26
	},
	{#State 210
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 268,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 211
		ACTIONS => {
			'ASSIGN' => -129
		},
		DEFAULT => -127
	},
	{#State 212
		ACTIONS => {
			"\"" => 269,
			"\${" => 49,
			'TEXT' => 219,
			";" => 220,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 222,
			'item' => 25,
			'ident' => 218,
			'node' => 58
		}
	},
	{#State 213
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 270,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 214
		DEFAULT => -58,
		GOTOS => {
			'@2-3' => 271
		}
	},
	{#State 215
		ACTIONS => {
			'CATCH' => 272,
			'FINAL' => 274
		},
		DEFAULT => -70,
		GOTOS => {
			'final' => 273
		}
	},
	{#State 216
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 275,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 217
		ACTIONS => {
			";" => 276
		}
	},
	{#State 218
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -174
	},
	{#State 219
		DEFAULT => -175
	},
	{#State 220
		DEFAULT => -176
	},
	{#State 221
		DEFAULT => -108
	},
	{#State 222
		DEFAULT => -172
	},
	{#State 223
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 277,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 224
		DEFAULT => -128
	},
	{#State 225
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -148
	},
	{#State 226
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 49,
			'REF' => 32,
			'LITERAL' => 74,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 278,
			'item' => 25,
			'ident' => 72,
			'node' => 58
		}
	},
	{#State 227
		DEFAULT => -102
	},
	{#State 228
		DEFAULT => -112
	},
	{#State 229
		DEFAULT => -111
	},
	{#State 230
		DEFAULT => -103
	},
	{#State 231
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 279,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 232
		DEFAULT => -55,
		GOTOS => {
			'@1-3' => 280
		}
	},
	{#State 233
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 247,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 248,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		DEFAULT => -62,
		GOTOS => {
			'sterm' => 1,
			'param' => 249,
			'item' => 246,
			'ident' => 245,
			'term' => 250,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 234
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -46
	},
	{#State 235
		DEFAULT => -64
	},
	{#State 236
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -60
	},
	{#State 237
		DEFAULT => -79
	},
	{#State 238
		DEFAULT => -57
	},
	{#State 239
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -44
	},
	{#State 240
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 281,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 241
		ACTIONS => {
			'END' => 282
		}
	},
	{#State 242
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'IDENT' => 28,
			"\$" => 7,
			'REF' => 32,
			"\${" => 49,
			'LITERAL' => 247,
			"[" => 53,
			"{" => 17,
			'COMMA' => 248
		},
		DEFAULT => -159,
		GOTOS => {
			'sterm' => 1,
			'param' => 249,
			'item' => 246,
			'ident' => 245,
			'term' => 250,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 243
		DEFAULT => -167
	},
	{#State 244
		DEFAULT => -164
	},
	{#State 245
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 283
		},
		DEFAULT => -106
	},
	{#State 246
		ACTIONS => {
			"(" => 118,
			'ASSIGN' => 189
		},
		DEFAULT => -125
	},
	{#State 247
		ACTIONS => {
			'ASSIGN' => 190
		},
		DEFAULT => -109
	},
	{#State 248
		DEFAULT => -152
	},
	{#State 249
		DEFAULT => -150
	},
	{#State 250
		DEFAULT => -149
	},
	{#State 251
		ACTIONS => {
			")" => 284,
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 247,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 248,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 249,
			'item' => 246,
			'ident' => 245,
			'term' => 250,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 252
		DEFAULT => -162
	},
	{#State 253
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 285,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 254
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -147
	},
	{#State 255
		DEFAULT => -99
	},
	{#State 256
		ACTIONS => {
			'TEXT' => 286
		}
	},
	{#State 257
		DEFAULT => -97
	},
	{#State 258
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -121
	},
	{#State 259
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -120
	},
	{#State 260
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 287,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 261
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 288,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 262
		ACTIONS => {
			'CASE' => 290
		},
		DEFAULT => -54,
		GOTOS => {
			'case' => 289
		}
	},
	{#State 263
		DEFAULT => -126
	},
	{#State 264
		ACTIONS => {
			'END' => 291
		}
	},
	{#State 265
		ACTIONS => {
			'ELSE' => 292,
			'ELSIF' => 294
		},
		DEFAULT => -49,
		GOTOS => {
			'else' => 293
		}
	},
	{#State 266
		ACTIONS => {
			'IDENT' => -93,
			")" => -93,
			'COMMA' => -93
		},
		DEFAULT => -127
	},
	{#State 267
		ACTIONS => {
			'COMMA' => 297,
			")" => 296,
			'IDENT' => 295
		}
	},
	{#State 268
		ACTIONS => {
			'END' => 298
		}
	},
	{#State 269
		ACTIONS => {
			'ASSIGN' => -157
		},
		DEFAULT => -164
	},
	{#State 270
		DEFAULT => -154
	},
	{#State 271
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 299,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 272
		ACTIONS => {
			'NUMBER' => 77,
			'FILENAME' => 79,
			";" => 300,
			'DEFAULT' => 302,
			'IDENT' => 81
		},
		GOTOS => {
			'filename' => 301,
			'filepart' => 85
		}
	},
	{#State 273
		ACTIONS => {
			'END' => 303
		}
	},
	{#State 274
		ACTIONS => {
			";" => 304
		}
	},
	{#State 275
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 276
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 30,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'template' => 306,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 277
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 278
		DEFAULT => -114
	},
	{#State 279
		DEFAULT => -153,
		GOTOS => {
			'args' => 308
		}
	},
	{#State 280
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 309,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 281
		ACTIONS => {
			'ELSE' => 292,
			'ELSIF' => 294
		},
		DEFAULT => -49,
		GOTOS => {
			'else' => 310
		}
	},
	{#State 282
		DEFAULT => -77
	},
	{#State 283
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 311,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 284
		DEFAULT => -161
	},
	{#State 285
		ACTIONS => {
			'END' => 312
		}
	},
	{#State 286
		ACTIONS => {
			"\"" => 313
		}
	},
	{#State 287
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -140
	},
	{#State 288
		ACTIONS => {
			'END' => 314
		}
	},
	{#State 289
		ACTIONS => {
			'END' => 315
		}
	},
	{#State 290
		ACTIONS => {
			"{" => 17,
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 49,
			'REF' => 32,
			'LITERAL' => 74,
			";" => 316,
			'DEFAULT' => 317,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 318,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 291
		DEFAULT => -75
	},
	{#State 292
		ACTIONS => {
			";" => 319
		}
	},
	{#State 293
		ACTIONS => {
			'END' => 320
		}
	},
	{#State 294
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 321,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 295
		DEFAULT => -91
	},
	{#State 296
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 180,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			"(" => 12,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		GOTOS => {
			'directive' => 179,
			'sterm' => 1,
			'mdir' => 322,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 67,
			'loop' => 55,
			'expr' => 209,
			'assign' => 69,
			'perl' => 62,
			'ident' => 90,
			'term' => 71,
			'filter' => 64,
			'lterm' => 20,
			'node' => 58,
			'condition' => 13
		}
	},
	{#State 297
		DEFAULT => -92
	},
	{#State 298
		DEFAULT => -63
	},
	{#State 299
		ACTIONS => {
			'END' => 323
		}
	},
	{#State 300
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 324,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 301
		ACTIONS => {
			'DOT' => 170,
			";" => 325
		}
	},
	{#State 302
		ACTIONS => {
			";" => 326
		}
	},
	{#State 303
		DEFAULT => -65
	},
	{#State 304
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 327,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 305
		DEFAULT => -85
	},
	{#State 306
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 307
		DEFAULT => -78
	},
	{#State 308
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 247,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 248,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		DEFAULT => -61,
		GOTOS => {
			'sterm' => 1,
			'param' => 249,
			'item' => 246,
			'ident' => 245,
			'term' => 250,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 309
		ACTIONS => {
			'END' => 329
		}
	},
	{#State 310
		ACTIONS => {
			'END' => 330
		}
	},
	{#State 311
		ACTIONS => {
			'CAT' => 109,
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 110,
			'DIV' => 108,
			"/" => 111,
			"?" => 103
		},
		DEFAULT => -151
	},
	{#State 312
		DEFAULT => -90
	},
	{#State 313
		DEFAULT => -98
	},
	{#State 314
		DEFAULT => -73
	},
	{#State 315
		DEFAULT => -50
	},
	{#State 316
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 331,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 317
		ACTIONS => {
			";" => 332
		}
	},
	{#State 318
		ACTIONS => {
			";" => 333
		}
	},
	{#State 319
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 334,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 320
		DEFAULT => -45
	},
	{#State 321
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 110,
			'CAT' => 109,
			'OR' => 107,
			";" => 335,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 111,
			"?" => 103
		}
	},
	{#State 322
		DEFAULT => -87
	},
	{#State 323
		DEFAULT => -59
	},
	{#State 324
		ACTIONS => {
			'CATCH' => 272,
			'FINAL' => 274
		},
		DEFAULT => -70,
		GOTOS => {
			'final' => 336
		}
	},
	{#State 325
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 337,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 326
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 338,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 327
		DEFAULT => -69
	},
	{#State 328
		DEFAULT => -80
	},
	{#State 329
		DEFAULT => -56
	},
	{#State 330
		DEFAULT => -43
	},
	{#State 331
		DEFAULT => -53
	},
	{#State 332
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 339,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 333
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 340,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 334
		DEFAULT => -48
	},
	{#State 335
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 341,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 336
		DEFAULT => -68
	},
	{#State 337
		ACTIONS => {
			'CATCH' => 272,
			'FINAL' => 274
		},
		DEFAULT => -70,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 338
		ACTIONS => {
			'CATCH' => 272,
			'FINAL' => 274
		},
		DEFAULT => -70,
		GOTOS => {
			'final' => 343
		}
	},
	{#State 339
		DEFAULT => -52
	},
	{#State 340
		ACTIONS => {
			'CASE' => 290
		},
		DEFAULT => -54,
		GOTOS => {
			'case' => 344
		}
	},
	{#State 341
		ACTIONS => {
			'ELSE' => 292,
			'ELSIF' => 294
		},
		DEFAULT => -49,
		GOTOS => {
			'else' => 345
		}
	},
	{#State 342
		DEFAULT => -66
	},
	{#State 343
		DEFAULT => -67
	},
	{#State 344
		DEFAULT => -51
	},
	{#State 345
		DEFAULT => -47
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 64 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 67 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 68 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 71 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 73 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 76 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2, undef
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 89 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 90 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 94 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'atomexpr', 1,
sub
#line 108 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 27
		 'atomexpr', 1, undef
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 112 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 113 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 114 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 115 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 116 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 117 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 120 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 121 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 122 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 123 "Parser.yp"
{ $_[0]->{ INFOR } || $_[0]->{ INWHILE }
                                        ? 'last LOOP;'
                                        : 'last;'                         }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 126 "Parser.yp"
{ $_[0]->{ INFOR }
					? $factory->next()
				        : ($_[0]->{ INWHILE }
                                           ? 'next LOOP;'
                                           : 'next;')                     }
	],
	[#Rule 41
		 'atomdir', 1, undef
	],
	[#Rule 42
		 'atomdir', 1, undef
	],
	[#Rule 43
		 'condition', 6,
sub
#line 136 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 44
		 'condition', 3,
sub
#line 137 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 45
		 'condition', 6,
sub
#line 139 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 46
		 'condition', 3,
sub
#line 140 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 47
		 'else', 5,
sub
#line 144 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 48
		 'else', 3,
sub
#line 146 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 49
		 'else', 0,
sub
#line 147 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 50
		 'switch', 6,
sub
#line 151 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 51
		 'case', 5,
sub
#line 155 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 52
		 'case', 4,
sub
#line 157 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 53
		 'case', 3,
sub
#line 158 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 54
		 'case', 0,
sub
#line 159 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 55
		 '@1-3', 0,
sub
#line 162 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 56
		 'loop', 6,
sub
#line 163 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 57
		 'loop', 3,
sub
#line 167 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 58
		 '@2-3', 0,
sub
#line 168 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 169 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 171 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 61
		 'loopvar', 4,
sub
#line 174 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 62
		 'loopvar', 2,
sub
#line 175 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 63
		 'wrapper', 5,
sub
#line 179 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 64
		 'wrapper', 3,
sub
#line 181 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 65
		 'try', 5,
sub
#line 185 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 66
		 'final', 5,
sub
#line 189 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 67
		 'final', 5,
sub
#line 192 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 68
		 'final', 4,
sub
#line 195 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 69
		 'final', 3,
sub
#line 197 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 70
		 'final', 0,
sub
#line 198 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 71
		 'use', 2,
sub
#line 201 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 72
		 '@3-3', 0,
sub
#line 204 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 73
		 'view', 6,
sub
#line 205 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 74
		 '@4-2', 0,
sub
#line 209 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 75
		 'perl', 5,
sub
#line 210 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->perl($_[4])             
				      : $factory->no_perl();              }
	],
	[#Rule 76
		 '@5-1', 0,
sub
#line 216 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
				      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 77
		 'rawperl', 5,
sub
#line 218 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->rawperl($_[4], $rawstart)
				      : $factory->no_perl();              }
	],
	[#Rule 78
		 'filter', 5,
sub
#line 225 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 79
		 'filter', 3,
sub
#line 227 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 80
		 'defblock', 6,
sub
#line 235 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[3] }]\n"
					  if $_[3];
				      $_[0]->define_block(@_[2, 5]); 
				      undef                               }
	],
	[#Rule 81
		 'blockname', 1, undef
	],
	[#Rule 82
		 'blockname', 1,
sub
#line 243 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 83
		 'blockargs', 1, undef
	],
	[#Rule 84
		 'blockargs', 0, undef
	],
	[#Rule 85
		 'anonblock', 5,
sub
#line 251 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 86
		 'capture', 3,
sub
#line 257 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 87
		 'macro', 6,
sub
#line 261 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 88
		 'macro', 3,
sub
#line 262 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 89
		 'mdir', 1, undef
	],
	[#Rule 90
		 'mdir', 4,
sub
#line 266 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 91
		 'margs', 2,
sub
#line 269 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 92
		 'margs', 2,
sub
#line 270 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 93
		 'margs', 1,
sub
#line 271 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 94
		 'metadata', 2,
sub
#line 274 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 95
		 'metadata', 2, undef
	],
	[#Rule 96
		 'metadata', 1, undef
	],
	[#Rule 97
		 'meta', 3,
sub
#line 279 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 98
		 'meta', 5,
sub
#line 282 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 99
		 'meta', 3,
sub
#line 283 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 100
		 'term', 1, undef
	],
	[#Rule 101
		 'term', 1, undef
	],
	[#Rule 102
		 'lterm', 3,
sub
#line 295 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 103
		 'lterm', 3,
sub
#line 296 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 104
		 'lterm', 2,
sub
#line 297 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 105
		 'lterm', 3,
sub
#line 298 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 106
		 'sterm', 1,
sub
#line 301 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 107
		 'sterm', 2,
sub
#line 302 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 108
		 'sterm', 3,
sub
#line 303 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 109
		 'sterm', 1, undef
	],
	[#Rule 110
		 'sterm', 1, undef
	],
	[#Rule 111
		 'list', 2,
sub
#line 308 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 112
		 'list', 2, undef
	],
	[#Rule 113
		 'list', 1, undef
	],
	[#Rule 114
		 'range', 3,
sub
#line 313 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 115
		 'hash', 1, undef
	],
	[#Rule 116
		 'hash', 0,
sub
#line 318 "Parser.yp"
{ "" }
	],
	[#Rule 117
		 'params', 2,
sub
#line 321 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 118
		 'params', 2, undef
	],
	[#Rule 119
		 'params', 1, undef
	],
	[#Rule 120
		 'param', 3,
sub
#line 326 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 121
		 'param', 3,
sub
#line 327 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 122
		 'ident', 3,
sub
#line 330 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 123
		 'ident', 3,
sub
#line 331 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 124
		 'ident', 1, undef
	],
	[#Rule 125
		 'node', 1,
sub
#line 337 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 126
		 'node', 4,
sub
#line 338 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 127
		 'item', 1,
sub
#line 341 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 128
		 'item', 3,
sub
#line 342 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 129
		 'item', 2,
sub
#line 343 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 130
		 'expr', 3,
sub
#line 348 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 131
		 'expr', 3,
sub
#line 349 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 132
		 'expr', 3,
sub
#line 350 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 351 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 352 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 353 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 354 "Parser.yp"
{ "$_[1]  . $_[3]"                    }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 139
		 'expr', 2,
sub
#line 357 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 140
		 'expr', 5,
sub
#line 358 "Parser.yp"
{ "(($_[1]) ? ($_[3]) : ($_[5]))"     }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 143
		 'expr', 1, undef
	],
	[#Rule 144
		 'setlist', 2,
sub
#line 364 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 145
		 'setlist', 2, undef
	],
	[#Rule 146
		 'setlist', 1, undef
	],
	[#Rule 147
		 'assign', 3,
sub
#line 370 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 148
		 'assign', 3,
sub
#line 371 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 149
		 'args', 2,
sub
#line 378 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 150
		 'args', 2,
sub
#line 379 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 151
		 'args', 4,
sub
#line 380 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 152
		 'args', 2,
sub
#line 382 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 153
		 'args', 0,
sub
#line 383 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 154
		 'lnameargs', 3,
sub
#line 393 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 155
		 'lnameargs', 1, undef
	],
	[#Rule 156
		 'lvalue', 1, undef
	],
	[#Rule 157
		 'lvalue', 3,
sub
#line 398 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 158
		 'lvalue', 1, undef
	],
	[#Rule 159
		 'nameargs', 3,
sub
#line 402 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 160
		 'nameargs', 2,
sub
#line 403 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 161
		 'nameargs', 4,
sub
#line 404 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 162
		 'names', 3,
sub
#line 407 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 163
		 'names', 1,
sub
#line 408 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 164
		 'name', 3,
sub
#line 411 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 165
		 'name', 1,
sub
#line 412 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 166
		 'name', 1, undef
	],
	[#Rule 167
		 'filename', 3,
sub
#line 424 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 168
		 'filename', 1, undef
	],
	[#Rule 169
		 'filepart', 1, undef
	],
	[#Rule 170
		 'filepart', 1, undef
	],
	[#Rule 171
		 'filepart', 1, undef
	],
	[#Rule 172
		 'quoted', 2,
sub
#line 438 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 173
		 'quoted', 0,
sub
#line 440 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 174
		 'quotable', 1,
sub
#line 443 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 175
		 'quotable', 1,
sub
#line 444 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 176
		 'quotable', 1,
sub
#line 445 "Parser.yp"
{ undef                               }
	]
];



1;












