use Test::More tests => 974;
use Basset::DB::Table;
package Basset::DB::Table;
{		Test::More::ok(1, "uses strict");
		Test::More::ok(1, "uses warnings");
};
{
#line 79  name
$| = 1;
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
Test::More::ok($o->name('test name'), "Set name");
Test::More::is($o->name, 'test name', "retrieved name");
Test::More::is($o->name('test name 2'), 'test name 2', 're-set name');
Test::More::is($o->name, 'test name 2', 'retrieved reset name');

Test::More::is(scalar(Basset::DB::Table->name('invalid name')), undef, 'Could not set name for class attribute');
};
{
#line 119  primary_column

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
Test::More::ok($o->primary_column('id'), "Set primary column");
Test::More::is($o->primary_column, 'id', "retrieved primary column");
Test::More::is($o->primary_column('id2'), 'id2', 're-set primary column');
Test::More::is($o->primary_column, 'id2', 'retrieved reset primary column');

my $a = [qw(id id2)];
Test::More::ok($a, "created arrayref");
Test::More::is($a->[0], 'id', 'proper array element 0');
Test::More::is($a->[1], 'id2', 'proper array element 1');
Test::More::is($o->primary_column($a), $a, 'set primary column to arrayref');

Test::More::is(scalar(Basset::DB::Table->primary_column('invalid name')), undef, 'Could not set primary column for class attribute');
};
{
#line 165  autogenerated

my $o = Basset::DB::Table->new();

Test::More::ok($o, "created object");
Test::More::is($o->autogenerated(1), 1, "set autogenerated");
Test::More::is($o->autogenerated(), 1, "accessed autogenerated");
Test::More::is($o->autogenerated(0), 0, "shut off autogenerated");
Test::More::is($o->autogenerated, 0, "accessed autogenerated");

Test::More::is(scalar(Basset::DB::Table->autogenerated(1)), undef, "Could not set autogenerated for class");
};
{
#line 242  definition

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->definition($h), $h, "Set definition");
Test::More::is($o->definition(), $h, 'reset definition');
Test::More::is(scalar(Basset::DB::Table->definition(1)), undef, 'Could not set definition for class');
};
{
#line 285  references

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->references($h), $h, "Set references");
Test::More::is($o->references(), $h, 'reset references');
Test::More::is(scalar(Basset::DB::Table->references(1)), undef, 'Could not set references for class');
};
{
#line 356  extra_select

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->extra_select($h), $h, "Set extra_select");
Test::More::is($o->extra_select(), $h, 'reset extra_select');
Test::More::is(scalar(Basset::DB::Table->extra_select(1)), undef, 'Could not set extra_select for class');
};
{
#line 404  db_read_translation

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->db_read_translation($h), $h, "Set db_read_translation");
Test::More::is($o->db_read_translation(), $h, 'reset db_read_translation');
Test::More::is(scalar(Basset::DB::Table->db_read_translation(1)), undef, 'Could not set db_read_translation for class');
};
{
#line 535  db_write_translation

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->db_write_translation($h), $h, "Set db_write_translation");
Test::More::is($o->db_write_translation(), $h, 'reset db_write_translation');
Test::More::is(scalar(Basset::DB::Table->db_write_translation(1)), undef, 'Could not set db_write_translation for class');
};
{
#line 580  column_aliases

my $aliases = {
	'able' => 'aliased_able',
	'baker' => 'aliased_baker',
	'charlie' => 'aliased_charlie',
	'delta' => 'aliased_delta'
};

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

Test::More::is($o->column_aliases($aliases), $aliases, "Set column aliases");
Test::More::is($o->column_aliases(), $aliases, "Got column aliases");
};
{
#line 607  _cached_queries

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is(scalar(Basset::DB::Table->_cached_queries), undef, "could not call object method as class method");
Test::More::is(Basset::DB::Table->errcode, "BO-08", "proper error code");
Test::More::is(ref($o->_cached_queries), 'HASH', '_cached_queries is hashref');
Test::More::is($o->_cached_queries('abc'), 'abc', 'set _cached_queries to abc');
Test::More::is($o->_cached_queries(), 'abc', 'read value of _cached_queries - abc');
my $h = {};
Test::More::ok($h, 'got hashref');
Test::More::is($o->_cached_queries($h), $h, 'set _cached_queries to hashref');
Test::More::is($o->_cached_queries(), $h, 'read value of _cached_queries  - hashref');
my $a = [];
Test::More::ok($a, 'got arrayref');
Test::More::is($o->_cached_queries($a), $a, 'set _cached_queries to arrayref');
Test::More::is($o->_cached_queries(), $a, 'read value of _cached_queries  - arrayref');
};
{
#line 635  _cached_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is(scalar(Basset::DB::Table->_cached_bindables), undef, "could not call object method as class method");
Test::More::is(Basset::DB::Table->errcode, "BO-08", "proper error code");
Test::More::is(ref($o->_cached_bindables), 'HASH', '_cached_bindables is hashref');
Test::More::is($o->_cached_bindables('abc'), 'abc', 'set _cached_bindables to abc');
Test::More::is($o->_cached_bindables(), 'abc', 'read value of _cached_bindables - abc');
my $h = {};
Test::More::ok($h, 'got hashref');
Test::More::is($o->_cached_bindables($h), $h, 'set _cached_bindables to hashref');
Test::More::is($o->_cached_bindables(), $h, 'read value of _cached_bindables  - hashref');
my $a = [];
Test::More::ok($a, 'got arrayref');
Test::More::is($o->_cached_bindables($a), $a, 'set _cached_bindables to arrayref');
Test::More::is($o->_cached_bindables(), $a, 'read value of _cached_bindables  - arrayref');
};
{
#line 710  last_insert_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "got object");

Test::More::ok(! scalar(Basset::DB::Table->last_insert_query), "Cannot call object method as class method");

Test::More::is($o->last_insert_query('foo'), 'foo', "set query to foo");
Test::More::is($o->last_insert_query(), 'foo', 'got insert query');
};
{
#line 726  insert_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, 1, 'baker is an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, 1, 'delta is an insert col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 insert columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->insert_columns($icols)), join(',',@$icols), "set new insert columns");
	Test::More::is(join(',',$o->insert_columns), join(',',@$icols), "got new insert columns");


	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an insert col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 insert columns');
}

{
	my $icols = [qw()];

	$o->insert_columns($icols);

	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, 1, 'baker is an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, 1, 'delta is an insert col');	
	Test::More::is(scalar(keys %icols), 4, '4 insert columns');
}

{
	$o->insert_columns(undef);
	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, 1, 'baker is an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, 1, 'delta is an insert col');	
	Test::More::is(scalar(keys %icols), 4, '4 insert columns');
}

Test::More::is(scalar($o->insert_columns(['junk'])), undef, 'could not insert unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 800  update_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, 1, 'baker is an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, 1, 'delta is an update col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 update columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->update_columns($icols)), join(',',@$icols), "set new update columns");
	Test::More::is(join(',',$o->update_columns), join(',',@$icols), "got new update columns");


	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an update col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 update columns');
}

{
	my $icols = [qw()];

	$o->update_columns($icols);

	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, 1, 'baker is an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, 1, 'delta is an update col');	
	Test::More::is(scalar(keys %icols), 4, '4 update columns');
}

{
	$o->update_columns(undef);
	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, 1, 'baker is an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, 1, 'delta is an update col');	
	Test::More::is(scalar(keys %icols), 4, '4 update columns');
}

Test::More::is(scalar($o->update_columns(['junk'])), undef, 'could not update unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 874  delete_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, 1, 'baker is an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, 1, 'delta is an delete col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 delete columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->delete_columns($icols)), join(',',@$icols), "set new delete columns");
	Test::More::is(join(',',$o->delete_columns), join(',',@$icols), "got new delete columns");


	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an delete col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 delete columns');
}

{
	my $icols = [qw()];

	$o->delete_columns($icols);

	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, 1, 'baker is an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, 1, 'delta is an delete col');	
	Test::More::is(scalar(keys %icols), 4, '4 delete columns');
}

{
	$o->delete_columns(undef);
	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, 1, 'baker is an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, 1, 'delta is an delete col');	
	Test::More::is(scalar(keys %icols), 4, '4 delete columns');
}

Test::More::is(scalar($o->delete_columns(['junk'])), undef, 'could not delete unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 948  replace_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, 1, 'baker is an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, 1, 'delta is an replace col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 replace columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->replace_columns($icols)), join(',',@$icols), "set new replace columns");
	Test::More::is(join(',',$o->replace_columns), join(',',@$icols), "got new replace columns");


	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an replace col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 replace columns');
}

{
	my $icols = [qw()];

	$o->replace_columns($icols);

	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, 1, 'baker is an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, 1, 'delta is an replace col');	
	Test::More::is(scalar(keys %icols), 4, '4 replace columns');
}

{
	$o->replace_columns(undef);
	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, 1, 'baker is an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, 1, 'delta is an replace col');	
	Test::More::is(scalar(keys %icols), 4, '4 replace columns');
}

Test::More::is(scalar($o->replace_columns(['junk'])), undef, 'could not replace unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 1022  select_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, 1, 'baker is an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, 1, 'delta is an select col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 select columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->select_columns($icols)), join(',',@$icols), "set new select columns");
	Test::More::is(join(',',$o->select_columns), join(',',@$icols), "got new select columns");


	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an select col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 select columns');
}

{
	my $icols = [qw(able charlie)];
	my $nicols = [qw(able)];

	Test::More::is(join(',',$o->select_columns($icols)), join(',',@$icols), "set new select columns");
	Test::More::is(join(',',$o->select_columns), join(',',@$icols), "got new select columns");

	Test::More::is(join(',',$o->nonselect_columns($nicols)), join(',',@$nicols), "set new non-select columns");
	Test::More::is(join(',',$o->nonselect_columns), join(',',@$nicols), "got new non-select columns");


	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, undef, 'able is a select col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an select col');	
	Test::More::is(scalar(keys %icols), 1, 'only 1 select column');
}



{
	my $icols = [qw()];

	$o->select_columns($icols);
	$o->nonselect_columns([]);

	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, 1, 'baker is an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, 1, 'delta is an select col');	
	Test::More::is(scalar(keys %icols), 4, '4 select columns');
}

{
	$o->select_columns(undef);
	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, 1, 'baker is an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, 1, 'delta is an select col');	
	Test::More::is(scalar(keys %icols), 4, '4 select columns');
}

Test::More::is(scalar($o->select_columns(['junk'])), undef, 'could not select unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 1131  _column_list_accessor

Test::More::ok("testing is implied", "testing is implied");
};
{
#line 1191  init

my $o = Basset::DB::Table->new();
Test::More::ok($o, "got object");
Test::More::is(ref $o->definition, 'HASH', 'definition initialized to hash');
Test::More::is(ref $o->extra_select, 'HASH', 'extra_select initialized to hash');
Test::More::is(ref $o->db_write_translation, 'HASH', 'db_write_translation initialized to hash');
Test::More::is(ref $o->db_read_translation, 'HASH', 'db_read_translation initialized to hash');
Test::More::is(ref $o->column_aliases, 'HASH', 'column_aliases initialized to hash');
Test::More::is(ref $o->references, 'HASH', 'references initialized to hash');
};
{
#line 1276  cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_VARCHAR',
	'charlie' => 'SQL_DATE',
	'delta' => 'SQL_UNKNOWN_TYPE'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %cols = map {$_, 1} $o->cols();

Test::More::is(scalar(keys %cols), scalar(keys %$def), "proper number of columns");
Test::More::is($cols{'able'}, 1, 'able is column');
Test::More::is($cols{'baker'}, 1, 'baker is column');
Test::More::is($cols{'charlie'}, 1, 'charlie is column');
Test::More::is($cols{'delta'}, 1, 'delta is column');
Test::More::is($cols{'edgar'}, undef, 'edgar is not column');
Test::More::is($cols{'foxtrot'}, undef, 'foxtrot is not column');
Test::More::is($cols{'goat'}, undef, 'goat is not column');
};
{
#line 1321  defs

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_VARCHAR',
	'charlie' => 'SQL_DATE',
	'delta' => 'SQL_UNKNOWN_TYPE'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my @cols = $o->cols();
my @defs = $o->defs();

Test::More::is(scalar(@defs), scalar(keys %$def), "proper number of definitions");
Test::More::is($defs[0], $o->definition->{$cols[0]}, "Definition matches column 0");
Test::More::is($defs[1], $o->definition->{$cols[1]}, "Definition matches column 1");
Test::More::is($defs[2], $o->definition->{$cols[2]}, "Definition matches column 2");
Test::More::is($defs[3], $o->definition->{$cols[3]}, "Definition matches column 3");
};
{
#line 1367  is_bindable

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is(scalar($o->is_bindable()), undef, 'Cannot bind w/o type');
Test::More::is($o->errcode, 'BDT-31', 'proper error code for is_bindable (type)');
Test::More::is(scalar($o->is_bindable('able')), undef, 'Cannot bind w/o col');
Test::More::is($o->errcode, 'BDT-30', 'proper error code for is_bindable (col)');

Test::More::is($o->is_bindable('I', 'able'), 1, 'able binds on insert');
Test::More::is($o->is_bindable('I', 'baker'), 1, 'baker binds on insert');
Test::More::is($o->is_bindable('I', 'charlie'), 1, 'charlie binds on insert');
Test::More::is($o->is_bindable('I', 'delta'), 1, 'delta binds on insert');

Test::More::is($o->is_bindable('U', 'able'), 1, 'able binds on update');
Test::More::is($o->is_bindable('U', 'baker'), 1, 'baker binds on update');
Test::More::is($o->is_bindable('U', 'charlie'), 1, 'charlie binds on update');
Test::More::is($o->is_bindable('U', 'delta'), 1, 'delta binds on update');

Test::More::is($o->is_bindable('R', 'able'), 1, 'able binds on replace');
Test::More::is($o->is_bindable('R', 'baker'), 1, 'baker binds on replace');
Test::More::is($o->is_bindable('R', 'charlie'), 1, 'charlie binds on replace');
Test::More::is($o->is_bindable('R', 'delta'), 1, 'delta binds on replace');

Test::More::is($o->is_bindable('D', 'able'), 1, 'able binds on delete');
Test::More::is($o->is_bindable('D', 'baker'), 1, 'baker binds on delete');
Test::More::is($o->is_bindable('D', 'charlie'), 1, 'charlie binds on delete');
Test::More::is($o->is_bindable('D', 'delta'), 1, 'delta binds on delete');

Test::More::is($o->is_bindable('S', 'able'), 1, 'able binds on select');
Test::More::is($o->is_bindable('S', 'baker'), 1, 'baker binds on select');
Test::More::is($o->is_bindable('S', 'charlie'), 1, 'charlie binds on select');
Test::More::is($o->is_bindable('S', 'delta'), 1, 'delta binds on select');

Test::More::is($o->is_bindable('A', 'able'), 1, 'able binds on all');
Test::More::is($o->is_bindable('A', 'baker'), 1, 'baker binds on all');
Test::More::is($o->is_bindable('A', 'charlie'), 1, 'charlie binds on all');
Test::More::is($o->is_bindable('A', 'delta'), 1, 'delta binds on all');

my $translator = 	{
		'able' => {
			'I' => {
				'val' => 'NOW()',
				'binds' => 0
			},
		},
		'baker' => {
			'U' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'charlie' => {
			'R' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'delta' => {
			'D' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
	};

Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

Test::More::is($o->is_bindable('I', 'able'), 0, 'able does not bind on insert');
Test::More::is($o->is_bindable('I', 'baker'), 1, 'baker binds on insert');
Test::More::is($o->is_bindable('I', 'charlie'), 1, 'charlie binds on insert');
Test::More::is($o->is_bindable('I', 'delta'), 1, 'delta binds on insert');

Test::More::is($o->is_bindable('U', 'able'), 1, 'able binds on update');
Test::More::is($o->is_bindable('U', 'baker'), 0, 'baker does not bind on update');
Test::More::is($o->is_bindable('U', 'charlie'), 1, 'charlie binds on update');
Test::More::is($o->is_bindable('U', 'delta'), 1, 'delta binds on update');

Test::More::is($o->is_bindable('R', 'able'), 1, 'able binds on replace');
Test::More::is($o->is_bindable('R', 'baker'), 1, 'baker binds on replace');
Test::More::is($o->is_bindable('R', 'charlie'), 0, 'charlie does not bind on replace');
Test::More::is($o->is_bindable('R', 'delta'), 1, 'delta binds on replace');

Test::More::is($o->is_bindable('D', 'able'), 1, 'able binds on delete');
Test::More::is($o->is_bindable('D', 'baker'), 1, 'baker binds on delete');
Test::More::is($o->is_bindable('D', 'charlie'), 1, 'charlie binds on delete');
Test::More::is($o->is_bindable('D', 'delta'), 0, 'delta does not bind on delete');

Test::More::is($o->is_bindable('S', 'able'), 1, 'able binds on select');
Test::More::is($o->is_bindable('S', 'baker'), 1, 'baker binds on select');
Test::More::is($o->is_bindable('S', 'charlie'), 1, 'charlie binds on select');
Test::More::is($o->is_bindable('S', 'delta'), 1, 'delta binds on select');

Test::More::is($o->is_bindable('A', 'able'), 1, 'able binds on all');
Test::More::is($o->is_bindable('A', 'baker'), 1, 'baker binds on all');
Test::More::is($o->is_bindable('A', 'charlie'), 1, 'charlie binds on all');
Test::More::is($o->is_bindable('A', 'delta'), 1, 'delta binds on all');

my $translator2 = 	{
		'able' => {
			'S' => {
				'val' => 'NOW()',
				'binds' => 0
			},
		},
		'baker' => {
			'A' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'charlie' => {
			'I' => {
				'val' => 'NOW()',
				'binds' => 1,
			},
			'A' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'delta' => {
			'A' => {
				'val' => '?',
				'binds' => 1,
			}
		},
	};

Test::More::is($o->db_write_translation($translator2), $translator2, "Set translator again");

Test::More::is($o->is_bindable('I', 'able'), 1, 'able binds on insert');
Test::More::is($o->is_bindable('I', 'baker'), 0, 'baker does not bind on insert');
Test::More::is($o->is_bindable('I', 'charlie'), 1, 'charlie binds on insert');
Test::More::is($o->is_bindable('I', 'delta'), 1, 'delta binds on insert');

Test::More::is($o->is_bindable('U', 'able'), 1, 'able binds on update');
Test::More::is($o->is_bindable('U', 'baker'), 0, 'baker does not bind on update');
Test::More::is($o->is_bindable('U', 'charlie'), 0, 'charlie does not bind on update');
Test::More::is($o->is_bindable('U', 'delta'), 1, 'delta binds on update');

Test::More::is($o->is_bindable('R', 'able'), 1, 'able binds on replace');
Test::More::is($o->is_bindable('R', 'baker'), 0, 'baker does not bind replace');
Test::More::is($o->is_bindable('R', 'charlie'), 0, 'charlie does not bind on replace');
Test::More::is($o->is_bindable('R', 'delta'), 1, 'delta binds on replace');

Test::More::is($o->is_bindable('D', 'able'), 1, 'able binds on delete');
Test::More::is($o->is_bindable('D', 'baker'), 0, 'baker does not bind delete');
Test::More::is($o->is_bindable('D', 'charlie'), 0, 'charlie does not bind on delete');
Test::More::is($o->is_bindable('D', 'delta'), 1, 'delta binds on delete');

Test::More::is($o->is_bindable('S', 'able'), 0, 'able does not bind on select');
Test::More::is($o->is_bindable('S', 'baker'), 0, 'baker does not bind on select');
Test::More::is($o->is_bindable('S', 'charlie'), 0, 'charlie does not bind on select');
Test::More::is($o->is_bindable('S', 'delta'), 1, 'delta binds on select');

Test::More::is($o->is_bindable('A', 'able'), 1, 'able binds on all');
Test::More::is($o->is_bindable('A', 'baker'), 0, 'baker does not bind on all');
Test::More::is($o->is_bindable('A', 'charlie'), 0, 'charlie does not bind on all');
Test::More::is($o->is_bindable('A', 'delta'), 1, 'delta binds on all');
};
{
#line 1568  is_selectable

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is(scalar($o->is_selectable), undef, 'Could not determine selectableness w/o value');
Test::More::is($o->errcode, 'BDT-44', 'proper error code');

Test::More::is($o->is_selectable('able'), 1, 'selects column');
Test::More::is($o->is_selectable('7'), 1, 'selects integer');
Test::More::is($o->is_selectable('7 as seven'), 1, 'selects aliased integer');
Test::More::is($o->is_selectable('98.6'), 1, 'selects float');
Test::More::is($o->is_selectable('98.6 as temp'), 1, 'selects aliased float');
Test::More::is($o->is_selectable('.778'), 1, 'selects decimal started float');
Test::More::is($o->is_selectable('.778 as small'), 1, 'selects decimal started float');
Test::More::is($o->is_selectable("'string'"), 1, 'selects single quoted string');
Test::More::is($o->is_selectable("'string' as alias"), 1, 'selects aliased single quoted string');
Test::More::is($o->is_selectable('"string"'), 1, 'selects double quoted string');
Test::More::is($o->is_selectable('"string" as alias'), 1, 'selects aliased double quoted string');
Test::More::is($o->is_selectable('NOW()'), 1, 'selects empty function');
Test::More::is($o->is_selectable('NOW() as "now"'), 1, 'selects aliased empty function');
Test::More::is($o->is_selectable('lc("able")'), 1, 'selects single arg function');
Test::More::is($o->is_selectable('lc("able") as "lc able"'), 1, 'selects aliased single arg function');
Test::More::is($o->is_selectable('lc("able")'), 1, 'selects double arg function');
Test::More::is($o->is_selectable('lc("able") as "lc able"'), 1, 'selects aliased double arg function');
};
{
#line 1631  db_translate_write

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is(scalar($o->db_translate_write()), undef, 'Cannot db_translate_write w/o type');
Test::More::is($o->errcode, 'BDT-33', 'proper error code for db_translate_write (col)');
Test::More::is(scalar($o->db_translate_write('I')), undef, 'Cannot db_translate_write w/o cols');
Test::More::is($o->errcode, 'BDT-32', 'proper error code for db_translate_write (type)');

Test::More::is($o->db_translate_write('I', 'able'), '?', 'db_translate_write for able on insert');
Test::More::is($o->db_translate_write('I', 'baker'), '?', 'db_translate_write for baker on insert');
Test::More::is($o->db_translate_write('I', 'charlie'), '?', 'db_translate_write for charlie on insert');
Test::More::is($o->db_translate_write('I', 'delta'), '?', 'db_translate_write for delta on insert');

Test::More::is($o->db_translate_write('U', 'able'), '?', 'db_translate_write for able on update');
Test::More::is($o->db_translate_write('U', 'baker'), '?', 'db_translate_write for baker on update');
Test::More::is($o->db_translate_write('U', 'charlie'), '?', 'db_translate_write for charlie on update');
Test::More::is($o->db_translate_write('U', 'delta'), '?', 'db_translate_write for delta on update');

Test::More::is($o->db_translate_write('R', 'able'), '?', 'db_translate_write for able on replace');
Test::More::is($o->db_translate_write('R', 'baker'), '?', 'db_translate_write for baker on replace');
Test::More::is($o->db_translate_write('R', 'charlie'), '?', 'db_translate_write for charlie on replace');
Test::More::is($o->db_translate_write('R', 'delta'), '?', 'db_translate_write for delta on replace');

Test::More::is($o->db_translate_write('D', 'able'), '?', 'db_translate_write for able on delete');
Test::More::is($o->db_translate_write('D', 'baker'), '?', 'db_translate_write for baker on delete');
Test::More::is($o->db_translate_write('D', 'charlie'), '?', 'db_translate_write for charlie on delete');
Test::More::is($o->db_translate_write('D', 'delta'), '?', 'db_translate_write for delta on delete');

Test::More::is($o->db_translate_write('S', 'able'), '?', 'db_translate_write for able on select');
Test::More::is($o->db_translate_write('S', 'baker'), '?', 'db_translate_write for baker on select');
Test::More::is($o->db_translate_write('S', 'charlie'), '?', 'db_translate_write for charlie on select');
Test::More::is($o->db_translate_write('S', 'delta'), '?', 'db_translate_write for delta on select');

Test::More::is($o->db_translate_write('A', 'able'), '?', 'db_translate_write for able on all');
Test::More::is($o->db_translate_write('A', 'baker'), '?', 'db_translate_write for baker on all');
Test::More::is($o->db_translate_write('A', 'charlie'), '?', 'db_translate_write for charlie on all');
Test::More::is($o->db_translate_write('A', 'delta'), '?', 'db_translate_write for delta on all');

{
	my @insert_all = $o->db_translate_write('I', sort $o->cols);
	Test::More::is($insert_all[0], '?', 'able is ? on insert in multi pass');
	Test::More::is($insert_all[1], '?', 'baker is ? on insert in multi pass');
	Test::More::is($insert_all[2], '?', 'charlie is ? on insert in multi pass');
	Test::More::is($insert_all[3], '?', 'delta is ? on insert in multi pass');
	
	my @update_all = $o->db_translate_write('U', sort $o->cols);
	Test::More::is($update_all[0], '?', 'able is ? on update in multi pass');
	Test::More::is($update_all[1], '?', 'baker is ? on update in multi pass');
	Test::More::is($update_all[2], '?', 'charlie is ? on update in multi pass');
	Test::More::is($update_all[3], '?', 'delta is ? on update in multi pass');
	
	my @replace_all = $o->db_translate_write('R', sort $o->cols);
	Test::More::is($replace_all[0], '?', 'able is ? on replace in multi pass');
	Test::More::is($replace_all[1], '?', 'baker is ? on replace in multi pass');
	Test::More::is($replace_all[2], '?', 'charlie is ? on replace in multi pass');
	Test::More::is($replace_all[3], '?', 'delta is ? on replace in multi pass');
	
	my @delete_all = $o->db_translate_write('D', sort $o->cols);
	Test::More::is($delete_all[0], '?', 'able is ? on delete in multi pass');
	Test::More::is($delete_all[1], '?', 'baker is ? on delete in multi pass');
	Test::More::is($delete_all[2], '?', 'charlie is ? on delete in multi pass');
	Test::More::is($delete_all[3], '?', 'delta is ? on delete in multi pass');
	
	my @all_all = $o->db_translate_write('A', sort $o->cols);
	Test::More::is($all_all[0], '?', 'able is ? on all in multi pass');
	Test::More::is($all_all[1], '?', 'baker is ? on all in multi pass');
	Test::More::is($all_all[2], '?', 'charlie is ? on all in multi pass');
	Test::More::is($all_all[3], '?', 'delta is ? on all in multi pass');
}

my $translator = 	{
		'able' => {
			'I' => {
				'val' => 'ableprime',
				'binds' => 0
			},
		},
		'baker' => {
			'U' => {
				'val' => 'bakerprime',
				'binds' => 0,
			},
		},
		'charlie' => {
			'R' => {
				'val' => 'charlieprime',
				'binds' => 1,
			},
		},
		'delta' => {
			'D' => {
				'val' => 'deltaprime',
				'binds' => 0,
			},
		},
	};

Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

Test::More::is($o->db_translate_write('I', 'able'), 'ableprime', 'db_translate_write for able on insert');
Test::More::is($o->db_translate_write('I', 'baker'), '?', 'db_translate_write for baker on insert');
Test::More::is($o->db_translate_write('I', 'charlie'), '?', 'db_translate_write for charlie on insert');
Test::More::is($o->db_translate_write('I', 'delta'), '?', 'db_translate_write for delta on insert');

Test::More::is($o->db_translate_write('U', 'able'), '?', 'db_translate_write for able on update');
Test::More::is($o->db_translate_write('U', 'baker'), 'bakerprime', 'db_translate_write for baker on update');
Test::More::is($o->db_translate_write('U', 'charlie'), '?', 'db_translate_write for charlie on update');
Test::More::is($o->db_translate_write('U', 'delta'), '?', 'db_translate_write for delta on update');

Test::More::is($o->db_translate_write('R', 'able'), '?', 'db_translate_write for able on replace');
Test::More::is($o->db_translate_write('R', 'baker'), '?', 'db_translate_write for baker on replace');
Test::More::is($o->db_translate_write('R', 'charlie'), 'charlieprime', 'db_translate_write for charlie on replace');
Test::More::is($o->db_translate_write('R', 'delta'), '?', 'db_translate_write for delta on replace');

Test::More::is($o->db_translate_write('D', 'able'), '?', 'db_translate_write for able on delete');
Test::More::is($o->db_translate_write('D', 'baker'), '?', 'db_translate_write for baker on delete');
Test::More::is($o->db_translate_write('D', 'charlie'), '?', 'db_translate_write for charlie on delete');
Test::More::is($o->db_translate_write('D', 'delta'), 'deltaprime', 'db_translate_write for delta on delete');

Test::More::is($o->db_translate_write('S', 'able'), '?', 'db_translate_write for able on select');
Test::More::is($o->db_translate_write('S', 'baker'), '?', 'db_translate_write for baker on select');
Test::More::is($o->db_translate_write('S', 'charlie'), '?', 'db_translate_write for charlie on select');
Test::More::is($o->db_translate_write('S', 'delta'), '?', 'db_translate_write for delta on select');

Test::More::is($o->db_translate_write('A', 'able'), '?', 'db_translate_write for able on all');
Test::More::is($o->db_translate_write('A', 'baker'), '?', 'db_translate_write for baker on all');
Test::More::is($o->db_translate_write('A', 'charlie'), '?', 'db_translate_write for charlie on all');
Test::More::is($o->db_translate_write('A', 'delta'), '?', 'db_translate_write for delta on all');

{
	my @insert_all = $o->db_translate_write('I', sort $o->cols);
	Test::More::is($insert_all[0], 'ableprime', 'able is ableprime on insert in multi pass');
	Test::More::is($insert_all[1], '?', 'baker is ? on insert in multi pass');
	Test::More::is($insert_all[2], '?', 'charlie is ? on insert in multi pass');
	Test::More::is($insert_all[3], '?', 'delta is ? on insert in multi pass');
	
	my @update_all = $o->db_translate_write('U', sort $o->cols);

	Test::More::is($update_all[0], '?', 'able is ? on update in multi pass');
	Test::More::is($update_all[1], 'bakerprime', 'baker is bakerprime on update in multi pass');
	Test::More::is($update_all[2], '?', 'charlie is ? on update in multi pass');
	Test::More::is($update_all[3], '?', 'delta is ? on update in multi pass');
	
	my @replace_all = $o->db_translate_write('R', sort $o->cols);
	Test::More::is($replace_all[0], '?', 'able is ? on replace in multi pass');
	Test::More::is($replace_all[1], '?', 'baker is ? on replace in multi pass');
	Test::More::is($replace_all[2], 'charlieprime', 'charlie is charlieprime on replace in multi pass');
	Test::More::is($replace_all[3], '?', 'delta is ? on replace in multi pass');
	
	my @delete_all = $o->db_translate_write('D', sort $o->cols);
	Test::More::is($delete_all[0], '?', 'able is ? on delete in multi pass');
	Test::More::is($delete_all[1], '?', 'baker is ? on delete in multi pass');
	Test::More::is($delete_all[2], '?', 'charlie is ? on delete in multi pass');
	Test::More::is($delete_all[3], 'deltaprime', 'delta is deltaprime on delete in multi pass');
	
	my @all_all = $o->db_translate_write('A', sort $o->cols);
	Test::More::is($all_all[0], '?', 'able is ? on all in multi pass');
	Test::More::is($all_all[1], '?', 'baker is ? on all in multi pass');
	Test::More::is($all_all[2], '?', 'charlie is ? on all in multi pass');
	Test::More::is($all_all[3], '?', 'delta is ? on all in multi pass');
}

my $translator2 = 	{
		'able' => {
			'S' => {
				'val' => 'ableselectorprime',
				'binds' => 0
			},
		},
		'baker' => {
			'A' => {
				'val' => 'bakerallprime',
				'binds' => 0,
			},
		},
		'charlie' => {
			'I' => {
				'val' => 'charlieinsertprime',
				'binds' => 1,
			},
			'A' => {
				'val' => 'charlieallprime',
				'binds' => 0,
			},
		},
	};

Test::More::is($o->db_write_translation($translator2), $translator2, "Set translator again");

Test::More::is($o->db_translate_write('I', 'able'), '?', 'db_translate_write for able on insert');
Test::More::is($o->db_translate_write('I', 'baker'), 'bakerallprime', 'db_translate_write for baker on insert');
Test::More::is($o->db_translate_write('I', 'charlie'), 'charlieinsertprime', 'db_translate_write for charlie on insert');
Test::More::is($o->db_translate_write('I', 'delta'), '?', 'db_translate_write for delta on insert');

Test::More::is($o->db_translate_write('U', 'able'), '?', 'db_translate_write for able on update');
Test::More::is($o->db_translate_write('U', 'baker'), 'bakerallprime', 'db_translate_write for baker on update');
Test::More::is($o->db_translate_write('U', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on update');
Test::More::is($o->db_translate_write('U', 'delta'), '?', 'db_translate_write for delta on update');

Test::More::is($o->db_translate_write('R', 'able'), '?', 'db_translate_write for able on replace');
Test::More::is($o->db_translate_write('R', 'baker'), 'bakerallprime', 'db_translate_write for baker on replace');
Test::More::is($o->db_translate_write('R', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on replace');
Test::More::is($o->db_translate_write('R', 'delta'), '?', 'db_translate_write for delta on replace');

Test::More::is($o->db_translate_write('D', 'able'), '?', 'db_translate_write for able on delete');
Test::More::is($o->db_translate_write('D', 'baker'), 'bakerallprime', 'db_translate_write for baker on delete');
Test::More::is($o->db_translate_write('D', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on delete');
Test::More::is($o->db_translate_write('D', 'delta'), '?', 'db_translate_write for delta on delete');

Test::More::is($o->db_translate_write('S', 'able'), 'ableselectorprime', 'db_translate_write for able on select');
Test::More::is($o->db_translate_write('S', 'baker'), 'bakerallprime', 'db_translate_write for baker on select');
Test::More::is($o->db_translate_write('S', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on select');
Test::More::is($o->db_translate_write('S', 'delta'), '?', 'db_translate_write for delta on select');

Test::More::is($o->db_translate_write('A', 'able'), '?', 'db_translate_write for able on all');
Test::More::is($o->db_translate_write('A', 'baker'), 'bakerallprime', 'db_translate_write for baker on all');
Test::More::is($o->db_translate_write('A', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on all');
Test::More::is($o->db_translate_write('A', 'delta'), '?', 'db_translate_write for delta on all');

{
	my @insert_all = $o->db_translate_write('I', sort $o->cols);
	Test::More::is($insert_all[0], '?', 'able is ? on insert in multi pass');
	Test::More::is($insert_all[1], 'bakerallprime', 'baker is bakerallprime on insert in multi pass');
	Test::More::is($insert_all[2], 'charlieinsertprime', 'charlie is charlieinsertprime on insert in multi pass');
	Test::More::is($insert_all[3], '?', 'delta is ? on insert in multi pass');
	
	my @update_all = $o->db_translate_write('U', sort $o->cols);
	Test::More::is($update_all[0], '?', 'able is ? on update in multi pass');
	Test::More::is($update_all[1], 'bakerallprime', 'baker is bakerallprime on update in multi pass');
	Test::More::is($update_all[2], 'charlieallprime', 'charlie is charlieallprime on update in multi pass');
	Test::More::is($update_all[3], '?', 'delta is ? on update in multi pass');
	
	my @replace_all = $o->db_translate_write('R', sort $o->cols);
	Test::More::is($replace_all[0], '?', 'able is ? on replace in multi pass');
	Test::More::is($replace_all[1], 'bakerallprime', 'baker is bakerallprime on replace in multi pass');
	Test::More::is($replace_all[2], 'charlieallprime', 'charlie is charlieallprime on replace in multi pass');
	Test::More::is($replace_all[3], '?', 'delta is ? on replace in multi pass');
	
	my @delete_all = $o->db_translate_write('D', sort $o->cols);
	Test::More::is($delete_all[0], '?', 'able is ? on delete in multi pass');
	Test::More::is($delete_all[1], 'bakerallprime', 'baker is bakerallprime on delete in multi pass');
	Test::More::is($delete_all[2], 'charlieallprime', 'charlie is charlieallprime on delete in multi pass');
	Test::More::is($delete_all[3], '?', 'delta is ? on delete in multi pass');
	
	my @all_all = $o->db_translate_write('A', sort $o->cols);
	Test::More::is($all_all[0], '?', 'able is ? on all in multi pass');
	Test::More::is($all_all[1], 'bakerallprime', 'baker is bakerallprime on all in multi pass');
	Test::More::is($all_all[2], 'charlieallprime', 'charlie is charlieallprime on all in multi pass');
	Test::More::is($all_all[3], '?', 'delta is ? on all in multi pass');
}
};
{
#line 1931  db_translate_read

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");
Test::More::is($o->name('table'), 'table', 'Set table name');

Test::More::is(scalar($o->db_translate_read()), undef, 'Cannot db_translate_read w/o col');
Test::More::is($o->errcode, 'BDT-34', 'proper error code for db_translate_read (col)');

Test::More::is($o->db_translate_read('able'), 'table.able', 'db_translate_read for able on select');
Test::More::is($o->db_translate_read('baker'), 'table.baker', 'db_translate_read for baker on select');
Test::More::is($o->db_translate_read('charlie'), 'table.charlie', 'db_translate_read for charlie on select');
Test::More::is($o->db_translate_read('delta'), 'table.delta', 'db_translate_read for delta on select');

my $translator = 	{
		'able' => 'ableselectorprime',
		'baker' => 'bakerallprime',
		'charlie' => 'charlieselectprime',
	};

Test::More::is($o->db_read_translation($translator), $translator, "Set translator again");

Test::More::is($o->db_translate_read('able'), 'ableselectorprime', 'db_translate_read for able on select');
Test::More::is($o->db_translate_read('baker'), 'bakerallprime', 'db_translate_read for baker on select');
Test::More::is($o->db_translate_read('charlie'), 'charlieselectprime', 'db_translate_read for charlie on select');
Test::More::is($o->db_translate_read('delta'), 'table.delta', 'db_translate_read for delta on select');
};
{
#line 2007  alias_column

my $o = Basset::DB::Table->new('name' => 'testtable1');
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $aliases = {
	'able' => 'aliased_able',
	'baker' => 'aliased_baker',
	'charlie' => 'aliased_charlie',
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->column_aliases($aliases), $aliases, "Set column aliases");
Test::More::is($o->column_aliases(), $aliases, "Got column aliases");

Test::More::is(scalar($o->alias_column()), undef, "Could not alias_column w/o column");
Test::More::is($o->errcode, 'BDT-36', 'proper error code for alias_column (col)');

Test::More::is($o->alias_column('able'), 'aliased_able', 'properly aliased able');
Test::More::is($o->alias_column('baker'), 'aliased_baker', 'properly aliased baker');
Test::More::is($o->alias_column('charlie'), 'aliased_charlie', 'properly aliased charlie');
Test::More::is($o->alias_column('delta'), 'delta', 'properly aliased able (no alias)');

Test::More::is($o->alias_column('testtable1.able'), 'aliased_able', 'properly aliased able');
Test::More::is($o->alias_column('testtable1.baker'), 'aliased_baker', 'properly aliased baker');
Test::More::is($o->alias_column('testtable1.charlie'), 'aliased_charlie', 'properly aliased charlie');
Test::More::is($o->alias_column('testtable1.delta'), 'delta', 'properly aliased able (no alias)');
};
{
#line 2082  column_for_alias

my $o = Basset::DB::Table->new('name' => 'testtable2');
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $aliases = {
	'able' => 'aliased_able',
	'baker' => 'aliased_baker',
	'charlie' => 'aliased_charlie',
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->column_aliases($aliases), $aliases, "Set column aliases");
Test::More::is($o->column_aliases(), $aliases, "Got column aliases");

Test::More::is(scalar($o->column_for_alias()), undef, "Could not get column_for_alias w/o alias");
Test::More::is($o->errcode, 'BDT-35', 'proper error code for column_for_alias (alias)');

Test::More::is($o->column_for_alias('aliased_able'), 'able', 'properly unaliased able');
Test::More::is($o->column_for_alias('aliased_baker'), 'baker', 'properly unaliased baker');
Test::More::is($o->column_for_alias('aliased_charlie'), 'charlie', 'unproperly aliased charlie');
Test::More::is($o->column_for_alias('delta'), 'delta', 'properly aliased able (no alias)');

Test::More::is($o->column_for_alias('testtable2.aliased_able'), 'able', 'properly unaliased able');
Test::More::is($o->column_for_alias('testtable2.aliased_baker'), 'baker', 'properly unaliased baker');
Test::More::is($o->column_for_alias('testtable2.aliased_charlie'), 'charlie', 'unproperly aliased charlie');
Test::More::is($o->column_for_alias('testtable2.delta'), 'delta', 'properly aliased able (no alias)');
};
{
#line 2149  insert_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} $o->insert_bindables();

Test::More::is($bindable{'able'}, 1, 'able is insert bindable');
Test::More::is($bindable{'baker'}, 1, 'baker is insert bindable');
Test::More::is($bindable{'charlie'}, 1, 'charlie is insert bindable');
Test::More::is($bindable{'delta'}, 1, 'delta is insert bindable');

my $translator = {
	'able' => {
		'I' => {
			'val' => 'lc(?)',
			'binds' => 1
		},
		'A' => {
			'val' => 'NOW()',
			'binds' => 0,
		},
	},
	'baker' => {
		'I' => {
			'val' => 'NOW()',
			'binds' => 0
		},
		'A' => {
			'val' => '?',
			'binds' => 1,
		},
	},
	'charlie' => {
		'I' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
	'delta' => {
		'A' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
};

Test::More::is($o->db_write_translation($translator), $translator, 'set db_write_translation');

my %bindable2 = map {$_, 1} $o->insert_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is insert bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not insert bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not insert bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not insert bindable');
};
{
#line 2242  replace_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} $o->replace_bindables();

Test::More::is($bindable{'able'}, 1, 'able is replace bindable');
Test::More::is($bindable{'baker'}, 1, 'baker is replace bindable');
Test::More::is($bindable{'charlie'}, 1, 'charlie is replace bindable');
Test::More::is($bindable{'delta'}, 1, 'delta is replace bindable');

my $translator = {
	'able' => {
		'R' => {
			'val' => 'lc(?)',
			'binds' => 1
		},
		'A' => {
			'val' => 'NOW()',
			'binds' => 0,
		},
	},
	'baker' => {
		'R' => {
			'val' => 'NOW()',
			'binds' => 0
		},
		'A' => {
			'val' => '?',
			'binds' => 1,
		},
	},
	'charlie' => {
		'R' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
	'delta' => {
		'A' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
};

Test::More::is($o->db_write_translation($translator), $translator, 'set db_write_translation');

my %bindable2 = map {$_, 1} $o->replace_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is replace bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not replace bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not replace bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not replace bindable');
};
{
#line 2329  update_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} $o->update_bindables();

Test::More::is($bindable{'able'}, 1, 'able is update bindable');
Test::More::is($bindable{'baker'}, 1, 'baker is update bindable');
Test::More::is($bindable{'charlie'}, 1, 'charlie is update bindable');
Test::More::is($bindable{'delta'}, 1, 'delta is update bindable');

my $translator = {
	'able' => {
		'U' => {
			'val' => 'lc(?)',
			'binds' => 1
		},
		'A' => {
			'val' => 'NOW()',
			'binds' => 0,
		},
	},
	'baker' => {
		'U' => {
			'val' => 'NOW()',
			'binds' => 0
		},
		'A' => {
			'val' => '?',
			'binds' => 1,
		},
	},
	'charlie' => {
		'U' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
	'delta' => {
		'A' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
};

Test::More::is($o->db_write_translation($translator), $translator, 'set db_write_translation');

my %bindable2 = map {$_, 1} $o->update_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is update bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not update bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not update bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not update bindable');
};
{
#line 2425  delete_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} grep {defined} $o->delete_bindables();

Test::More::is($bindable{'able'}, undef, 'able is not delete bindable');
Test::More::is($bindable{'baker'}, undef, 'baker is not delete bindable');
Test::More::is($bindable{'charlie'}, undef, 'charlie is not delete bindable');
Test::More::is($bindable{'delta'}, undef, 'delta is not delete bindable');

$o->primary_column('able');

my %bindable2 = map {$_, 1} $o->delete_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is delete bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not delete bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not delete bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not delete bindable');

$o->primary_column(['charlie', 'delta']);

my %bindable3 = map {$_, 1} $o->delete_bindables();

Test::More::is($bindable3{'able'}, undef, 'able is not delete bindable');
Test::More::is($bindable3{'baker'}, undef, 'baker is not delete bindable');
Test::More::is($bindable3{'charlie'}, 1, 'charlie is delete bindable');
Test::More::is($bindable3{'delta'}, 1, 'delta is delete bindable');
};
{
#line 2477  select_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} grep {defined} $o->select_bindables;

Test::More::is($bindable{'able'}, undef, 'able is not select bindable');
Test::More::is($bindable{'baker'}, undef, 'baker is not select bindable');
Test::More::is($bindable{'charlie'}, undef, 'charlie is not select bindable');
Test::More::is($bindable{'delta'}, undef, 'delta is not select bindable');

$o->primary_column('able');

my %bindable2 = map {$_, 1} $o->select_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is select bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not select bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not select bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not select bindable');

$o->primary_column(['charlie', 'delta']);

my %bindable3 = map {$_, 1} $o->select_bindables();

Test::More::is($bindable3{'able'}, undef, 'able is not select bindable');
Test::More::is($bindable3{'baker'}, undef, 'baker is not select bindable');
Test::More::is($bindable3{'charlie'}, 1, 'charlie is select bindable');
Test::More::is($bindable3{'delta'}, 1, 'delta is select bindable');
};
{
#line 2548  insert_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

{
	my @insert = $o->insert_columns;

	Test::More::is($o->insert_query, "insert into mytable (" . join(', ', @insert)
		. ") values (?, ?, ?, ?)", "got default insert query");
}

{
	my @insert = $o->insert_columns(['able']);

	Test::More::is($o->insert_query, "insert into mytable (" . join(', ', @insert)
		. ") values (?)", "got able insert query");
	$o->insert_columns(undef);
}

{
	my @insert = $o->insert_columns(['able', 'baker']);

	Test::More::is($o->insert_query, "insert into mytable (" . join(', ', @insert)
		. ") values (?, ?)", "got able, baker insert query");
	$o->insert_columns(undef);
}

{

	Test::More::is(scalar($o->insert_query('foo')), undef, "Could not get insert query w/invalid column");
	Test::More::is($o->errcode, 'BDT-07', 'proper error code');
}

{
	Test::More::is($o->insert_query('able', 'baker'), "insert into mytable (able, baker) values (?, ?)", "got able, baker insert query");
}

{
	my $translator = 	{
			'able' => {
				'I' => {
					'val' => 'lc(?)',
					'binds' => 0
				},
			},
			'baker' => {
				'A' => {
					'val' => 'uc(?)',
					'binds' => 0,
				},
			},
		};

	Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

	my @insert = $o->insert_columns;

	my $q = "insert into mytable (" . join(', ', @insert)
		. ") values (" . join(', ', map{$_ eq 'able' ? 'lc(?)' : $_ eq 'baker' ? 'uc(?)' : '?'} @insert) . ")";

	Test::More::is($o->insert_query, $q, "got re-written default insert query");

}
};
{
#line 2677  replace_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

{
	my @replace = $o->replace_columns;

	Test::More::is($o->replace_query, "replace into mytable (" . join(', ', @replace)
		. ") values (?, ?, ?, ?)", "got default replace query");
}

{
	my @replace = $o->replace_columns(['able']);

	Test::More::is($o->replace_query, "replace into mytable (" . join(', ', @replace)
		. ") values (?)", "got able replace query");
	$o->replace_columns(undef);
}

{
	my @replace = $o->replace_columns(['able', 'baker']);

	Test::More::is($o->replace_query, "replace into mytable (" . join(', ', @replace)
		. ") values (?, ?)", "got able, baker replace query");
	$o->replace_columns(undef);
}

{

	Test::More::is(scalar($o->replace_query('foo')), undef, "Could not get replace query w/invalid column");
	Test::More::is($o->errcode, 'BDT-08', 'proper error code');
}

{
	Test::More::is($o->replace_query('able', 'baker'), "replace into mytable (able, baker) values (?, ?)", "got able, baker replace query");
}

{
	my $translator = 	{
			'able' => {
				'R' => {
					'val' => 'lc(?)',
					'binds' => 0
				},
			},
			'baker' => {
				'A' => {
					'val' => 'uc(?)',
					'binds' => 0,
				},
			},
		};

	Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

	my @replace = $o->replace_columns;

	my $q = "replace into mytable (" . join(', ', @replace)
		. ") values (" . join(', ', map{$_ eq 'able' ? 'lc(?)' : $_ eq 'baker' ? 'uc(?)' : '?'} @replace) . ")";

	Test::More::is($o->replace_query, $q, "got re-written default replace query");

}
};
{
#line 2808  update_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

{
	my @update = $o->update_columns;

	Test::More::is($o->update_query, "update mytable set " . join(', ', map {"$_ = ?"} @update), "got default update query");
}

{
	my @update = $o->update_columns(['able']);

	Test::More::is($o->update_query, "update mytable set " . join(', ', map {"$_ = ?"} @update), "got able update query");

	$o->update_columns(undef);
}

{
	my @update = $o->update_columns(['able', 'baker']);

	Test::More::is($o->update_query, "update mytable set " . join(', ', map {"$_ = ?"} @update), "got able, baker update query");
	$o->update_columns(undef);
}

{

	Test::More::is(scalar($o->update_query('foo')), undef, "Could not get update query w/invalid column");
	Test::More::is($o->errcode, 'BDT-06', 'proper error code');
}

{
	Test::More::is($o->update_query('able', 'baker'), "update mytable set able = ?, baker = ?", "got able, baker update query");
}

{
	my $translator = 	{
			'able' => {
				'U' => {
					'val' => 'lc(?)',
					'binds' => 0
				},
			},
			'baker' => {
				'A' => {
					'val' => 'uc(?)',
					'binds' => 0,
				},
			},
		};

	Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

	my @update = $o->update_columns;

	my $q = "update mytable set " . join(', ', map{$_ . ' = ' . ($_ eq 'able' ? 'lc(?)' : $_ eq 'baker' ? 'uc(?)' : '?')} @update);

	Test::More::is($o->update_query, $q, "got re-written default update query");

}
};
{
#line 2927  delete_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

Test::More::is($o->delete_query, 'delete from mytable', 'proper delete query');
};
{
#line 2969  select_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

Test::More::is(scalar($o->select_query('fake')), undef, 'Could not select unknown column');
Test::More::is($o->errcode, 'BDT-05', 'proper error code');

{
	my @select = $o->select_columns;

	Test::More::is($o->select_query, 'select ' . join(', ', map {"mytable.$_ as $_"} @select) . ' from mytable', "got default select query");	

}

{
	my @select = $o->select_columns(['able']);

	Test::More::is($o->select_query, 'select ' . join(', ', map {"mytable.$_ as $_"} @select) . ' from mytable', "got able select query");	

	$o->select_columns(undef);
}

{
	my @select = $o->select_columns(['able', 'baker']);

	Test::More::is($o->select_query, 'select ' . join(', ', map {"mytable.$_ as $_"} @select) . ' from mytable', "got able baker select query");	

	$o->select_columns(undef);
}

{
	Test::More::is($o->select_query('able', 'baker'), 'select mytable.able as able, mytable.baker as baker from mytable', 'got able baker passed select query');
}

{
	Test::More::is($o->select_query('NOW()', '"const1"', "'const2'", 2004), 'select NOW(), "const1", \'const2\', 2004 from mytable', 'got function, constant select query');
}

{
	my $translator = 	{
		'able' => 'lc(able)',
		'baker' => 'uc(baker)',
	};

	my @select = $o->select_columns();

	Test::More::is($o->db_read_translation($translator), $translator, "Set translator");

	Test::More::is($o->select_query, 'select ' . join(', ', map{($_ eq 'able' ? 'lc(able)' : $_ eq 'baker' ? 'uc(baker)' : "mytable.$_") . " as $_"} @select) . ' from mytable', "got translated select query");	

	$o->db_read_translation({});
}

{
	my $extra = {
		'current_time' => 'NOW()'
	};

	Test::More::is($o->extra_select($extra), $extra, "Set extra select");

	my @select = ((map {"mytable.$_ as $_"} $o->select_columns), (map {$extra->{$_} . ' as ' . $_} keys %$extra));

	Test::More::is($o->select_query, 'select ' . join(', ', @select) . ' from mytable', "got extra selecting select query");
};
};
{
#line 3255  multiselect_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object");

my $o3 = Basset::DB::Table->new();
Test::More::ok($o3, "Created object");

my $o4 = Basset::DB::Table->new();
Test::More::ok($o4, "Created object");

my $def1 = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $ref1 = {
	'able' => 'table2.aid',
	'baker' => 'table4.b',
	'charlie' => 'table4.c',
};

Test::More::is($o->definition($def1), $def1, "Set definition");
Test::More::is($o->references($ref1), $ref1, "Set references");
Test::More::is($o->name("table1"), "table1", "set table name");
Test::More::is($o->primary_column("able"), "able", "set table primary id");

my $def2 = {
	'aid' => 'SQL_INTEGER',
	'bid' => 'SQL_INTEGER',
	'cid' => 'SQL_INTEGER',
	'did' => 'SQL_INTEGER'
};

my $ref2 = {
	'aid' => 'table3.ace'
};

my $aliases2 = {
	'aid' => 'ALIASED_aid',
};

Test::More::is($o2->definition($def2), $def2, "Set definition");
Test::More::is($o2->references($ref2), $ref2, "Set references");
Test::More::is($o2->column_aliases($aliases2), $aliases2, "Set aliases");
Test::More::is($o2->name("table2"), "table2", "set table name");
Test::More::is($o2->primary_column("aid"), "aid", "set table primary id");

my $def3 = {
	'ace' => 'SQL_INTEGER',
	'bogey' => 'SQL_INTEGER',
};

Test::More::is($o3->definition($def3), $def3, "Set definition");
Test::More::is($o3->name("table3"), "table3", "set table name");
Test::More::is($o3->primary_column("ace"), "ace", "set table primary id");

my $def4 = {
	'a' => 'SQL_INTEGER',
	'b' => 'SQL_INTEGER',
	'c' => 'SQL_INTEGER',
	'd' => 'SQL_INTEGER'
};

Test::More::is($o4->definition($def4), $def4, "Set definition");
Test::More::is($o4->name("table4"), "table4", "set table name");
Test::More::ok($o4->primary_column([qw(b c)]), "set table primary id");

my @o1select = $o->select_columns();
my @o2select = $o2->select_columns();
my @o3select = $o3->select_columns();
my @o4select = $o4->select_columns();

Test::More::is(scalar(Basset::DB::Table->multiselect_query()), undef, "Could not multiselect w/o tables");
Test::More::is(Basset::DB::Table->errcode, 'BDT-47', 'proper error code');

Test::More::is(Basset::DB::Table->multiselect_query('tables' => $o),
"select " . (join(", ",map {"table1.$_ as $_"} @o1select)) . " from table1",
'multi selected single table');

Test::More::is(Basset::DB::Table->multiselect_query('tables' => [$o]),
"select " . (join(", ",map {"table1.$_ as $_"} @o1select)) . " from table1",
'multi selected single table in arrayref');


Test::More::is(Basset::DB::Table->multiselect_query('cols' => 'able', 'tables' => $o),
"select " . (join(", ",map {"table1.$_ as $_"} ('able'))) . " from table1",
'multi selected single table, different cols');

Test::More::is(Basset::DB::Table->multiselect_query('cols' => ['able'], 'tables' => $o),
"select " . (join(", ",map {"table1.$_ as $_"} ('able'))) . " from table1",
'multi selected single table, different cols in arrayref');

Test::More::is(Basset::DB::Table->multiselect_query('cols' => ['able'], 'tables' => [$o]),
"select " . (join(", ",map {"table1.$_ as $_"} ('able'))) . " from table1",
'multi selected single table in arrayref, different cols');

Test::More::is(Basset::DB::Table->multiselect_query('tables' => [$o, $o2]),
"select\n" . (join(",\n",map {"\ttable1.$_"} @o1select)) 
. ",\n" . (join(",\n",map {"\ttable2.$_"} @o2select)) . "\nfrom\n" .
"table1
	inner join
		table2
			on table1.able = table2.aid",
'multi selected multi table in arrayref');

Test::More::is(Basset::DB::Table->multiselect_query('cols' => ['able', 'baker'], 'tables' => [$o, $o2]),
"select\n" . (join(",\n",map {"\t$_"} ('able'))) 
. ",\n" . (join(",\n",map {"\t$_"} ('baker'))) . "\nfrom\n" .
"table1
	inner join
		table2
			on table1.able = table2.aid",
'multi selected multi table in arrayref with differing columns');

Test::More::is(Basset::DB::Table->multiselect_query('use_aliases' => 1, 'tables' => [$o, $o2]),
"select\n" . (join(",\n",map {"\ttable1.$_ as " . $o2->alias_column($_)} @o1select)) 
. ",\n" . (join(",\n",map {"\ttable2.$_ as " . $o2->alias_column($_)} @o2select)) . "\nfrom\n" .
"table1
	inner join
		table2
			on table1.able = table2.aid",
'multi selected multi table in arrayref with aliases');
};
{
#line 3446  count_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

Test::More::is($o->name('count_query_table'), 'count_query_table', 'Set table name');
Test::More::is($o->count_query, 'select count(1) as count from count_query_table', 'Got count query');
};
{
#line 3476  optimize_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is($o->name("test table"), "test table", "set table name");
Test::More::is($o->optimize_query, 'optimize table test table', "got optimize query");
};
{
#line 3505  describe_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is($o->name("test table"), "test table", "set table name");
Test::More::is($o->describe_query, 'desc test table', "got desc query");
};
{
#line 3544  reference_query

my $def = {
	'user_id' => 'SQL_INTEGER',
	'user_name' => 'SQL_VARCHAR',
};

my $foreign = {
	'user_id' => 'user.id',
	'user_name' => 'user.name'
};

my $o = Basset::DB::Table->new(
	'definition' => $def,
	'references' => $foreign,
);
Test::More::ok($o, "Got object");
Test::More::is($o->definition, $def, "proper definition");
Test::More::is($o->references, $foreign, "proper foreign references");

my $f2 = {%$foreign};

Test::More::is($o->references($f2), $f2, "properly reset foreign reference");

Test::More::is($o->reference_query('user_id'), "select count(1) as count from user\n  where id = ?", "successful reference query");
Test::More::is($o->reference_query('user_name'), "select count(1) as count from user\n  where name = ?", "successful reference query");

Test::More::is(scalar($o->reference_query('foo')), undef, "got nothing for non-referenced column");
Test::More::is($o->errcode, "BDT-14", "Proper error code");
};
{
#line 3608  is_column

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::ok($o->is_column('able'), 'able is column');
Test::More::ok($o->is_column('baker'), 'baker is column');
Test::More::ok($o->is_column('charlie'), 'charlie is column');
Test::More::ok($o->is_column('delta'), 'delta is column');
Test::More::is($o->is_column('edgar'), 0, 'edgar is not column');
Test::More::is($o->is_column('foxtrot'), 0, 'foxtrot is not column');

Test::More::is(scalar($o->is_column), undef, "Cannot call w/o column");
Test::More::is($o->errcode, "BDT-04", "proper error code");
};
{
#line 3658  is_primary

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->primary_column('able'), 'able', 'Set primary column');;

Test::More::is(scalar($o->is_primary), undef, 'Cannot determine primary-ness w/o a column');
Test::More::is($o->errcode, 'BDT-01', 'proper error code');

Test::More::ok($o->is_primary('able'), 'able is primary');
Test::More::is($o->is_primary('baker'), 0, 'baker is not primary');
Test::More::is($o->is_primary('charlie'), 0, 'charlie is not primary');
Test::More::is($o->is_primary('delta'), 0, 'delta is not primary');
Test::More::is($o->is_primary('edgar'), 0, 'edgar is not primary');
Test::More::is($o->is_primary('foxtrot'), 0, 'foxtrot is not primary');

my $primaries = [qw(baker delta)];

Test::More::is($o->primary_column($primaries), $primaries, 'set primary column');

Test::More::is($o->is_primary('able'), 0, 'able is not primary');
Test::More::is($o->is_primary('baker'), 1, 'baker is primary');
Test::More::is($o->is_primary('charlie'), 0, 'charlie is not primary');
Test::More::is($o->is_primary('delta'), 1, 'delta is primary');
Test::More::is($o->is_primary('edgar'), 0, 'edgar is not primary');
Test::More::is($o->is_primary('foxtrot'), 0, 'foxtrot is not primary');

Test::More::is(scalar($o->is_primary), undef, "Cannot call w/o column");
Test::More::is($o->errcode, "BDT-01", "proper error code");
};
{
#line 3722  non_primary_cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");

{
	my %primary = map {$_, 1} $o->non_primary_cols;

	Test::More::is($primary{'able'}, 1, 'able is not primary column');
	Test::More::is($primary{'baker'}, 1, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, 1, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, 1, 'delta is not primary column');
}

{
	$o->primary_column('able');

	my %primary = map {$_, 1} $o->non_primary_cols;

	Test::More::is($primary{'able'}, undef, 'able is primary column');
	Test::More::is($primary{'baker'}, 1, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, 1, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, 1, 'delta is not primary column');
}

{
	$o->primary_column(['charlie', 'delta']);

	my %primary = map {$_, 1} $o->non_primary_cols;

	Test::More::is($primary{'able'}, 1, 'able is not primary column');
	Test::More::is($primary{'baker'}, 1, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, undef, 'charlie is primary column');
	Test::More::is($primary{'delta'}, undef, 'delta is primary column');
}
};
{
#line 3788  primary_cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");

{
	my %primary = map {$_, 1} grep {defined} $o->primary_cols;

	Test::More::is($primary{'able'}, undef, 'able is not primary column');
	Test::More::is($primary{'baker'}, undef, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, undef, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, undef, 'delta is not primary column');
}

{
	$o->primary_column('able');

	my %primary = map {$_, 1} $o->primary_cols;

	Test::More::is($primary{'able'}, 1, 'able is primary column');
	Test::More::is($primary{'baker'}, undef, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, undef, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, undef, 'delta is not primary column');
}

{
	$o->primary_column(['charlie', 'delta']);

	my %primary = map {$_, 1} $o->primary_cols;

	Test::More::is($primary{'able'}, undef, 'able is not primary column');
	Test::More::is($primary{'baker'}, undef, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, 1, 'charlie is primary column');
	Test::More::is($primary{'delta'}, 1, 'delta is primary column');
}
};
{
#line 3872  foreign_cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->name('tableone'), 'tableone', 'set object 1 name');
Test::More::ok($o->primary_column(['able', 'baker']), 'set object 1 primary columns');

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object 2");
my $def2 = {
	'edgar' => 'SQL_VARCHAR',
	'foxtrot' => 'SQL_DATE',
	'goats' => 'SQL_TIMESTAMP',
	'henry' => 'SQL_FLOAT'
};

Test::More::is($o2->definition($def2), $def2, "set object 2 definition");
Test::More::is($o2->name('tabletoo'), 'tabletoo', "set object 2 name");
Test::More::ok($o2->primary_column(['edgar', 'foxtrot']), 'set object 2 primary columns');

my $ref1 = {
	'able' => 'tabletoo.edgar',
	'baker' => 'tabletoo.foxtrot',
	'charlie' => 'tablethree.col'
};

Test::More::is($o->references($ref1), $ref1, "Set reference 1");

my $o3 = Basset::DB::Table->new();
Test::More::ok($o3, "Created object 3");
my $def3 = {
	'col' => 'SQL_VARCHAR',
};

Test::More::is($o3->definition($def3), $def3, "set object 3 definition");
Test::More::is($o3->name('tablethree'), 'tablethree', "set object 3 name");

my $o4 = Basset::DB::Table->new();
Test::More::ok($o4, "Created object 4");
Test::More::is($o4->name('tablefour'), 'tablefour', "set object 4 name");


Test::More::is(scalar($o->foreign_cols), undef, "Cannot get foreign cols w/o table");
Test::More::is($o->errcode, 'BDT-45', "Proper error code");

{
	my $i = 1;
	my %f1 = map {$_, $i++} $o->foreign_cols($o2);
	Test::More::is($f1{'able'}, 1, 'able is foreign column');
	Test::More::is($f1{'baker'}, 2, 'baker is foreign column');
	Test::More::is(scalar (keys %f1), 2, 'only 2 foreign columns');
}

{
	my %f2 = map {$_, 1} $o->foreign_cols($o3);
	Test::More::is(scalar (keys %f2), 0, 'object 1 references no primary columns in object 3');
}

{
	my %f2 = map {$_, 1} $o->foreign_cols($o3, 'col');
	Test::More::is($f2{'charlie'}, 1, 'charlie is foreign column');
	Test::More::is(scalar (keys %f2), 1, 'only 1 foreign column');
}
};
{
#line 3984  referenced_column

my $def = {
	'user_id' => 'SQL_INTEGER',
	'user_name' => 'SQL_VARCHAR',
	'user_extra' => 'SQL_VARCHAR',
};

my $foreign = {
	'user_id' => 'user.id',
	'user_name' => 'user.name'
};

my $o = Basset::DB::Table->new(
	'definition' => $def,
	'references' => $foreign,
);
Test::More::ok($o, "Got object");
Test::More::is($o->definition, $def, "proper definition");
Test::More::is($o->references, $foreign, "proper foreign references");

my $f2 = {%$foreign};

Test::More::is($o->references($f2), $f2, "properly reset foreign reference");

Test::More::is(scalar($o->referenced_column), undef, "Cannot get referenced column w/o column");
Test::More::is($o->errcode, "BDT-15", "proper error code");

Test::More::is($o->referenced_column('user_id'), 'user.id', 'user_id properly referenced');
Test::More::is($o->referenced_column('user_name'), 'user.name', 'user_id properly referenced');
Test::More::is(scalar($o->referenced_column('user_extra')), undef, 'user_id properly referenced');
Test::More::is($o->errcode, "BDT-16", "proper error code");
};
{
#line 4103  attach_to_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', 'set table name');

Test::More::is(scalar($o->attach_to_query), undef, "Cannot attach to query w/o query");
Test::More::is($o->errcode, "BDT-02", "proper error code");

Test::More::is($o->select_query, 'select mytable.able as able from mytable', 'proper select query');
my $query = $o->select_query;
Test::More::is(scalar($o->attach_to_query($query)), $query, "No clauses returns original query");
Test::More::is(scalar($o->attach_to_query($query, {})), $query, "Empty clauses returns original query");
Test::More::is(scalar($o->attach_to_query($query, {'having' => 'having clause'})), undef, "Cannot have having w/o group");
Test::More::is($o->errcode, "BDT-09", "proper error code");

Test::More::is($o->attach_to_query($query, {'where' => 'able = ?'}), $query . "\n  where able = ?", "attached where clause");
Test::More::is($o->attach_to_query($query, {'group by' => 'able'}), $query . "\n  group by able", "attached group by clause");
Test::More::is($o->attach_to_query($query, {'order by' => 'baker'}), $query . "\n  order by baker", "attached order by clause");
Test::More::is($o->attach_to_query($query, {'limit' => '5'}), $query . "\n  limit 5", "attached limit clause");

Test::More::is(
	$o->attach_to_query(
		$query, 
		{
			'where' => 'able = ?',
			'group by' => 'baker',
		}
	), $query . "\n  where able = ?\n  group by baker", "attached where and group by clause");

Test::More::is(
	$o->attach_to_query(
		$query, 
		{
			'where' => 'able = ?',
			'group by' => 'baker',
			'having' => 'count(*) > 1'
		}
	), $query . "\n  where able = ?\n  group by baker\n  having count(*) > 1", "attached where, group by, and having clause");
};
{
#line 4308  join_tables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object");

my $o3 = Basset::DB::Table->new();
Test::More::ok($o3, "Created object");

my $o4 = Basset::DB::Table->new();
Test::More::ok($o4, "Created object");

my $def1 = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $ref1 = {
	'able' => 'table2.aid',
	'baker' => 'table4.b',
	'charlie' => 'table4.c',
};

Test::More::is($o->definition($def1), $def1, "Set definition");
Test::More::is($o->references($ref1), $ref1, "Set references");
Test::More::is($o->name("table1"), "table1", "set table name");
Test::More::is($o->primary_column("able"), "able", "set table primary id");

my $def2 = {
	'aid' => 'SQL_INTEGER',
	'bid' => 'SQL_INTEGER',
	'cid' => 'SQL_INTEGER',
	'did' => 'SQL_INTEGER'
};

my $ref2 = {
	'aid' => 'table3.ace'
};

Test::More::is($o2->definition($def2), $def2, "Set definition");
Test::More::is($o2->references($ref2), $ref2, "Set references");
Test::More::is($o2->name("table2"), "table2", "set table name");
Test::More::is($o2->primary_column("aid"), "aid", "set table primary id");

my $def3 = {
	'ace' => 'SQL_INTEGER',
	'bogey' => 'SQL_INTEGER',
};

Test::More::is($o3->definition($def3), $def3, "Set definition");
Test::More::is($o3->name("table3"), "table3", "set table name");
Test::More::is($o3->primary_column("ace"), "ace", "set table primary id");

my $def4 = {
	'a' => 'SQL_INTEGER',
	'b' => 'SQL_INTEGER',
	'c' => 'SQL_INTEGER',
	'd' => 'SQL_INTEGER'
};

Test::More::is($o4->definition($def4), $def4, "Set definition");
Test::More::is($o4->name("table4"), "table4", "set table name");
Test::More::ok($o4->primary_column([qw(b c)]), "set table primary id");


Test::More::is(scalar(Basset::DB::Table->join_tables), undef, "Could not join w/o tables");
Test::More::is(Basset::DB::Table->errcode, "BDT-28", "proper error code BDT-28");

Test::More::is(Basset::DB::Table->join_tables($o), "table1", "Join with one table is same table");

Test::More::is(Basset::DB::Table->join_tables($o, $o2),
"table1
	inner join
		table2
			on table1.able = table2.aid",
"Default joined two tables"
);

Test::More::is(Basset::DB::Table->join_tables($o2, $o),
"table2
	inner join
		table1
			on table1.able = table2.aid",
"Reverse  joined two tables"
);

Test::More::is(Basset::DB::Table->join_tables($o, $o2, $o3),
"table1
	inner join
		table2
			on table1.able = table2.aid
	inner join
		table3
			on table2.aid = table3.ace",
"Default joined three tables"
);
Test::More::is(Basset::DB::Table->join_tables($o, $o2, $o3, $o4),
"table1
	inner join
		table2
			on table1.able = table2.aid
	inner join
		table3
			on table2.aid = table3.ace
	inner join
		table4
			on table1.baker = table4.b
			and table1.charlie = table4.c",
"Default joined four tables"
);

Test::More::is(Basset::DB::Table->join_tables($o, [$o2]),
"table1
	inner join
		table2
			on table1.able = table2.aid",
"Default joined two tables w/arrayref table only"
);

Test::More::is(Basset::DB::Table->join_tables($o, ['inner',$o2]),
"table1
	inner join
		table2
			on table1.able = table2.aid",
"inner joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['outer',$o2]),
"table1
	outer join
		table2
			on table1.able = table2.aid",
"outer joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['natural',$o2]),
"table1
	natural join
		table2",
"natural joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['left',$o2]),
"table1
	left join
		table2
			on table1.able = table2.aid",
"left joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['right',$o2]),
"table1
	right join
		table2
			on table1.able = table2.aid",
"right joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['left outer',$o2]),
"table1
	left outer join
		table2
			on table1.able = table2.aid",
"left outer joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['right outer',$o2]),
"table1
	right outer join
		table2
			on table1.able = table2.aid",
"right outer joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, [$o4, 'table1.baker = table4.b']),
"table1
	inner join
		table4
			on table1.baker = table4.b",
"joined 2 tables with alternate clause");

Test::More::is(Basset::DB::Table->join_tables($o, ['outer', $o4, 'table1.baker = table4.b']),
"table1
	outer join
		table4
			on table1.baker = table4.b",
"outer joined 2 tables with 3 arg alternate clause");

Test::More::is(Basset::DB::Table->join_tables($o, [$o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	inner join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"joined 2 tables with 2 alternate clauses");

Test::More::is(Basset::DB::Table->join_tables($o, ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses");

Test::More::is(Basset::DB::Table->join_tables(['inner', $o], ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses w/ first table array");

Test::More::is(Basset::DB::Table->join_tables(['inner', $o, 'foo = bar'], ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses w/ first table array and columns");

Test::More::is(Basset::DB::Table->join_tables([$o, 'foo = bar'], ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses w/ first table array and columns, non-inner");

Test::More::is(scalar(Basset::DB::Table->join_tables($o, $o3)), undef, "Cannot auto-join unreferenced tables");
Test::More::is(Basset::DB::Table->errcode, 'BDT-27', 'proper error code');
};
{
#line 4658  many_clause

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");
Test::More::is($o->name('test'), 'test', 'set name');

Test::More::is(scalar($o->many_clause), undef, "Cannot build many clause w/o column");
Test::More::is($o->errcode, 'BDT-21', 'proper error code');

Test::More::is(scalar($o->many_clause('able')), undef, "Cannot build many clause w/o values");
Test::More::is($o->errcode, 'BDT-22', 'proper error code');

Test::More::is(scalar($o->many_clause('able', [])), undef, "Cannot build many clause w/o values");
Test::More::is($o->errcode, 'BDT-22', 'proper error code');

Test::More::is($o->many_clause('able', 1), 'test.able in (?)', 'built single many clause');
Test::More::is($o->many_clause('able', 1, 2), 'test.able in (?, ?)', 'built double many clause');
Test::More::is($o->many_clause('able', 1, 2, 3), 'test.able in (?, ?, ?)', 'built triple many clause');

Test::More::is($o->many_clause('able', [1]), 'test.able in (?)', 'built single many clause from arrayref');
Test::More::is($o->many_clause('able', [1, 2]), 'test.able in (?, ?)', 'built double many clause from arrayref');
Test::More::is($o->many_clause('able', [1, 2, 3]), 'test.able in (?, ?, ?)', 'built triple many clause from arrayref');

Test::More::is($o->many_clause('able', 'not', [1]), 'test.able not in (?)', 'built single not many clause');
Test::More::is($o->many_clause('able', 'not', [1, 2]), 'test.able not in (?, ?)', 'built double not many clause');
Test::More::is($o->many_clause('able', 'not', [1, 2, 3]), 'test.able not in (?, ?, ?)', 'built triple not many clause');
Test::More::is($o->many_clause('able', 1, [1, 2, 3]), 'test.able not in (?, ?, ?)', 'built triple not many clause w/arbitrary true value');
};
{
#line 4714  qualified_name

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

Test::More::is(scalar($o->qualified_name()), undef, 'could not get qualified name w/o column');

Test::More::is($o->errcode, 'BDT-23', 'Proper error code');
Test::More::is(scalar($o->qualified_name('foo')), undef, 'could not get qualified name w/o table name');
Test::More::is($o->errcode, 'BDT-24', 'Proper error code');
Test::More::is($o->name('test1'), 'test1', 'Set table name');
Test::More::is($o->qualified_name('foo'), 'test1.foo', 'column foo properly qualified');
Test::More::is($o->qualified_name('bar'), 'test1.bar', 'column bar properly qualified');
Test::More::is($o->name('test2'), 'test2', 'changed column name to test2');
Test::More::is($o->qualified_name('foo'), 'test2.foo', 'column foo properly qualified');
Test::More::is($o->qualified_name('bar'), 'test2.bar', 'column bar properly qualified');
Test::More::is($o->qualified_name('test2.foo'), 'test2.foo', 'previously column test2.foo properly qualified');
Test::More::is($o->qualified_name('test2.bar'), 'test2.bar', 'previously column test2.bar properly qualified');
};
{
#line 4763  nonqualified_name

Test::More::is(scalar(Basset::DB::Table->nonqualified_name()), undef, "Could not get nonqualified name w/o column");
Test::More::is(Basset::DB::Table->nonqualified_name('foo.bar'), 'bar', 'stripped table name');
Test::More::is(Basset::DB::Table->nonqualified_name('bar'), 'bar', 'returned column w/o table name');
};
{
#line 4972  construct_where_clause

Test::More::ok(! Basset::DB::Table->construct_where_clause, "Cannot construct_where_clause w/o tables");
Test::More::is(Basset::DB::Table->errcode, "BDT-48", 'proper error code');

my $t1 = Basset::DB::Table->new(
	'name'				=> 't1',
	'primary_column'	=> 'id',
	'definition'	=> {
		'id' => 'SQL_INTEGER',
		'name' => 'SQL_VARCHAR',
	}
);

Test::More::ok($t1, 'built first table');

my $t2 = Basset::DB::Table->new(
	'name'				=> 't2',
	'primary_column'	=> 'id',
	'definition'	=> {
		'id' => 'SQL_INTEGER',
		'size' => 'SQL_VARCHAR',
	}
);

Test::More::ok($t2, 'built second table');

my $one_table = [$t1];
my $two_tables = [$t1, $t2];

Test::More::ok(! Basset::DB::Table->construct_where_clause($one_table), "Cannot construct_where_clause w/o clauses");
Test::More::is(Basset::DB::Table->errcode, "BDT-49", 'proper error code');

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, 'name' => 'foo');
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t1.name = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], 'foo', 'proper value');
}

{
	Test::More::ok(!Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, 'name' => 'foo', 'bar' => 'baz'),
		'could not construct_where_clause w/non-existent column');
	Test::More::is(Basset::DB::Table->errcode, 'BDT-50', 'proper error code');
}

{
	Test::More::ok(!Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, 'name' => 'foo', ['bar' => 'baz']),
		'could not construct_where_clause w/non-existent column');
	Test::More::is(Basset::DB::Table->errcode, 'BDT-50', 'proper error code');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => [qw(a b c)]);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id in (?, ?, ?)', 'proper clause');
	Test::More::is($return[1], 'a', 'proper value');
	Test::More::is($return[2], 'b', 'proper value');
	Test::More::is($return[3], 'c', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1});
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id > ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1, '<' => 10});
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], '(t1.id < ? OR t1.id > ?)', 'proper clause');
	Test::More::is($return[1], '10', 'proper value');
	Test::More::is($return[2], '1', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1, '<' => 10}, 'name' => 'you');
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], '(t1.id < ? OR t1.id > ?) AND t1.name = ?', 'proper clause');
	Test::More::is($return[1], '10', 'proper value');
	Test::More::is($return[2], '1', 'proper value');
	Test::More::is($return[3], 'you', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1}, 'id' => {'<' => 10});
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id > ? AND t1.id < ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '10', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, ['name' => 'me', 'id' => 3]);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], 'me', 'proper value');
	Test::More::is($return[3], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, ['name' => 'me', 'id' => 3], 'id' => 5);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t1.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '5', 'proper value');
	Test::More::is($return[3], 'me', 'proper value');
	Test::More::is($return[4], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => 1, ['name' => 'me', 'id' => 3], 'id' => 5);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t1.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '5', 'proper value');
	Test::More::is($return[3], 'me', 'proper value');
	Test::More::is($return[4], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => 1, ['name' => 'me', 'id' => 3], 't2.id' => 5);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t2.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '5', 'proper value');
	Test::More::is($return[3], 'me', 'proper value');
	Test::More::is($return[4], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => 1, 'size' => 7);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t2.size = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '7', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => \1, 'size' => \7);
	Test::More::is(scalar(@return), 1, "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = 1 AND t2.size = 7', 'proper clause');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => {'is' => \'NULL'}, 'size' => 7);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id is NULL AND t2.size = ?', 'proper clause');
	Test::More::is($return[1], '7', 'proper value');
}
};
{
#line 5149  arbitrary_sql

my $poclass = Basset::DB::Table->pkg->pkg_for_type('persistentobject');

Test::More::ok($poclass, "Got persistent object class");
Test::More::ok($poclass->can('arbitrary_sql'), 'persistent class can arbitrary_sql');
};
