package Locales::DB::Territory::sk;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::sk::VERSION = '0.09';

$Locales::DB::Territory::sk::cldr_version = '2.0';

%Locales::DB::Territory::sk::code_to_name = (
    '001' => 'Svet',
    '002' => 'Afrika',
    '003' => "Severná\ Amerika\ \[003\]",
    '005' => "Južná\ Amerika",
    '009' => 'Oceánia',
    '011' => "Západná\ Afrika",
    '013' => "Stredná\ Amerika",
    '014' => "Východná\ Afrika",
    '015' => "Severná\ Afrika",
    '017' => "Stredná\ Afrika",
    '018' => "Južná\ Afrika\ \[018\]",
    '019' => "Americký\ kontinent",
    '021' => "Severná\ Amerika",
    '029' => 'Karibik',
    '030' => "Východná\ Ázia",
    '034' => "Južná\ Ázia",
    '035' => "Juhovýchodná\ Ázia",
    '039' => "Južná\ Európa",
    '053' => "Austrália\ a\ Nový\ Zéland",
    '054' => 'Melanézia',
    '057' => "Mikronézia\ –\ oblasť",
    '061' => 'Polynézia',
    '062' => "Stredná\ a\ južná\ Ázia",
    142   => 'Ázia',
    143   => "Stredná\ Ázia",
    145   => "Západná\ Ázia",
    150   => 'Európa',
    151   => "Východná\ Európa",
    154   => "Severná\ Európa",
    155   => "Západná\ Európa",
    172   => "Spoločenstvo\ nezávislých\ štátov",
    200   => 'Československo',
    419   => "Latinská\ Amerika",
    830   => "Normanské\ ostrovy",
    'ac'  => "Ostrov\ Ascensión",
    'ad'  => 'Andorra',
    'ae'  => "Spojené\ arabské\ emiráty",
    'af'  => 'Afganistan',
    'ag'  => "Antigua\ a\ Barbados",
    'ai'  => 'Anguilla',
    'al'  => 'Albánsko',
    'am'  => 'Arménsko',
    'an'  => "Holandské\ Antily",
    'ao'  => 'Angola',
    'aq'  => 'Antarctica',
    'ar'  => 'Argentína',
    'as'  => "Americká\ Samoa",
    'at'  => 'Rakúsko',
    'au'  => 'Austrália',
    'aw'  => 'Aruba',
    'ax'  => "Alandské\ ostrovy",
    'az'  => 'Azerbajdžan',
    'ba'  => "Bosna\ a\ Hercegovina",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladéš',
    'be'  => 'Belgicko',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulharsko',
    'bh'  => 'Bahrajn',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "Svätý\ Bartolomej",
    'bm'  => 'Bermudy',
    'bn'  => 'Brunej',
    'bo'  => 'Bolívia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brazília',
    'bs'  => 'Bahamy',
    'bt'  => 'Bután',
    'bv'  => "Bouvetov\ ostrov",
    'bw'  => 'Botswana',
    'by'  => 'Bielorusko',
    'bz'  => 'Belize',
    'ca'  => 'Kanada',
    'cc'  => "Kokosové\ ostrovy",
    'cd'  => "Kongo\ \[DRK\]",
    'cf'  => "Stredoafrická\ republika",
    'cg'  => "Kongo\ \[republika\]",
    'ch'  => 'Švajčiarsko',
    'ci'  => "Pobrežie\ Slonoviny",
    'ck'  => "Cookove\ ostrovy",
    'cl'  => 'Čile',
    'cm'  => 'Kamerun',
    'cn'  => 'Čína',
    'co'  => 'Kolumbia',
    'cp'  => "Ostrov\ Clipperton",
    'cr'  => 'Kostarika',
    'cs'  => "Srbsko\ a\ Čierna\ Hora",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kuba',
    'cv'  => 'Kapverdy',
    'cx'  => "Vianočný\ ostrov",
    'cy'  => 'Cyprus',
    'cz'  => "Česká\ republika",
    'dd'  => "East\ Germany",
    'de'  => 'Nemecko',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Džibuti',
    'dk'  => 'Dánsko',
    'dm'  => 'Dominika',
    'do'  => "Dominikánska\ republika",
    'dz'  => 'Alžírsko',
    'ea'  => "Ceuta\ a\ Melilla",
    'ec'  => 'Ekvádor',
    'ee'  => 'Estónsko',
    'eg'  => 'Egypt',
    'eh'  => "Západná\ Sahara",
    'er'  => 'Eritrea',
    'es'  => 'Španielsko',
    'et'  => 'Etiópia',
    'eu'  => "Európska\ únia",
    'fi'  => 'Fínsko',
    'fj'  => 'Fidži',
    'fk'  => "Falklandy\ \[Islas\ Malvinas\]",
    'fm'  => 'Mikronézia',
    'fo'  => "Faerské\ ostrovy",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Francúzsko',
    'fx'  => "Metropolitné\ Francúzsko",
    'ga'  => 'Gabon',
    'gb'  => "Spojené\ kráľovstvo",
    'gd'  => 'Grenada',
    'ge'  => 'Gruzínsko',
    'gf'  => "Francúzska\ Guayana",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Gibraltár',
    'gl'  => 'Grónsko',
    'gm'  => 'Gambia',
    'gn'  => 'Guinea',
    'gp'  => 'Guadeloupe',
    'gq'  => "Rovníková\ Guinea",
    'gr'  => 'Grécko',
    'gs'  => "Južná\ Georgia\ a\ Južné\ Sandwichove\ ostrovy",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guinea\-Bissau",
    'gy'  => 'Guayana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heardove\ ostrovy\ a\ McDonaldove\ ostrovy",
    'hn'  => 'Honduras',
    'hr'  => 'Chorvátsko',
    'ht'  => 'Haiti',
    'hu'  => 'Maďarsko',
    'ic'  => "Kanárske\ ostrovy",
    'id'  => 'Indonézia',
    'ie'  => 'Írsko',
    'il'  => 'Izrael',
    'im'  => "Ostrov\ Man",
    'in'  => 'India',
    'io'  => "Britské\ územie\ v\ Indickom\ oceáne",
    'iq'  => 'Irak',
    'ir'  => 'Irán',
    'is'  => 'Island',
    'it'  => 'Taliansko',
    'je'  => 'Jersey',
    'jm'  => 'Jamajka',
    'jo'  => 'Jordánsko',
    'jp'  => 'Japonsko',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Keňa',
    'kg'  => 'Kirgizsko',
    'kh'  => 'Kambodža',
    'ki'  => 'Kiribati',
    'km'  => 'Komory',
    'kn'  => "Saint\ Kitts\ a\ Nevis",
    'kp'  => "Kórejská\ ľudovodemokratická\ republika",
    'kr'  => "Kórejská\ republika",
    'kw'  => 'Kuvajt',
    'ky'  => "Kajmanské\ ostrovy",
    'kz'  => 'Kazachstan',
    'la'  => "Laoská\ ľudovodemokratická\ republika",
    'lb'  => 'Libanon',
    'lc'  => "Svätá\ Lucia",
    'li'  => 'Lichtenštajnsko',
    'lk'  => "Srí\ Lanka",
    'lr'  => 'Libéria',
    'ls'  => 'Lesotho',
    'lt'  => 'Litva',
    'lu'  => 'Luxembursko',
    'lv'  => 'Lotyšsko',
    'ly'  => "Lýbijská\ arabská\ džamahírija",
    'ma'  => 'Maroko',
    'mc'  => 'Monako',
    'md'  => 'Moldavsko',
    'me'  => "Čierna\ Hora",
    'mf'  => "Svätý\ Martin",
    'mg'  => 'Madagaskar',
    'mh'  => "Marshallove\ ostrovy",
    'mi'  => "Midway\ Islands",
    'mk'  => "Macedónsko\ \[FYROM\]",
    'ml'  => 'Mali',
    'mm'  => 'Mjanmarsko',
    'mn'  => 'Mongolsko',
    'mo'  => 'Macao',
    'mp'  => "Severné\ Mariány",
    'mq'  => 'Martinik',
    'mr'  => 'Mauritánia',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Maurícius',
    'mv'  => 'Maldivy',
    'mw'  => 'Malawi',
    'mx'  => 'Mexiko',
    'my'  => 'Malajzia',
    'mz'  => 'Mozambik',
    'na'  => 'Namíbia',
    'nc'  => "Nová\ Kaledónia",
    'ne'  => 'Niger',
    'nf'  => "Norfolkov\ ostrov",
    'ng'  => 'Nigéria',
    'ni'  => 'Nikaragua',
    'nl'  => 'Holandsko',
    'no'  => 'Nórsko',
    'np'  => 'Nepál',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "Nový\ Zéland",
    'om'  => 'Omán',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Francúzska\ Polynézia",
    'pg'  => "Papua\ Nová\ Guinea",
    'ph'  => 'Filipíny',
    'pk'  => 'Pakistan',
    'pl'  => 'Poľsko',
    'pm'  => "Saint\ Pierre\ a\ Miquelon",
    'pn'  => "Pitcairnove\ ostrovy",
    'pr'  => 'Portoriko',
    'ps'  => "Palestínske\ územie",
    'pt'  => 'Portugalsko',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguaj',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katar',
    'qo'  => "Tichomorie\ \-\ ostatné",
    're'  => 'Reunion',
    'ro'  => 'Rumunsko',
    'rs'  => 'Srbsko',
    'ru'  => "Ruská\ federácia",
    'rw'  => 'Rwanda',
    'sa'  => "Saudská\ Arábia",
    'sb'  => "Šalamúnove\ ostrovy",
    'sc'  => "Seychelské\ ostrovy",
    'sd'  => 'Sudán',
    'se'  => 'Švédsko',
    'sg'  => 'Singapur',
    'sh'  => "Svätá\ Helena",
    'si'  => 'Slovinsko',
    'sj'  => "Špicbergy\ a\ Jan\ Mayen",
    'sk'  => "Slovenská\ republika",
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Maríno",
    'sn'  => 'Senegal',
    'so'  => 'Somálsko',
    'sr'  => 'Surinam',
    'st'  => "Svätý\ Tomáš\ a\ Princove\ ostrovy",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Salvador',
    'sy'  => "Sýrska\ arabská\ republika",
    'sz'  => 'Svazijsko',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ a\ Caicos",
    'td'  => 'Čad',
    'tf'  => "Francúzske\ južné\ územia",
    'tg'  => 'Togo',
    'th'  => 'Thajsko',
    'tj'  => 'Tadžikistan',
    'tk'  => 'Tokelau',
    'tl'  => "Východný\ Timor",
    'tm'  => 'Turkménsko',
    'tn'  => 'Tunisko',
    'to'  => 'Tonga',
    'tr'  => 'Turecko',
    'tt'  => "Trinidad\ a\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Tajwan',
    'tz'  => 'Tanzánia',
    'ua'  => 'Ukrajina',
    'ug'  => 'Uganda',
    'um'  => "Menšie\ odľahlé\ ostrovy\ USA",
    'us'  => "Spojené\ štáty",
    'uy'  => 'Uruguaj',
    'uz'  => 'Uzbekistan',
    'va'  => 'Vatikán',
    'vc'  => "Svätý\ Vincent\ a\ Grenadíny",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Britské\ panenské\ ostrovy",
    'vi'  => "Panenské\ ostrovy\ \-\ USA",
    'vn'  => 'Vietnam',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ a\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Jemen',
    'yt'  => 'Mayotte',
    'za'  => "Južná\ Afrika",
    'zm'  => 'Zambia',
    'zw'  => 'Zimbabwe',
    'zz'  => "Neznámy\ alebo\ neplatný\ región",
);

%Locales::DB::Territory::sk::name_to_code = (
    'afganistan'                                => 'af',
    'afrika'                                    => '002',
    'alandskéostrovy'                          => 'ax',
    'albánsko'                                 => 'al',
    'alžírsko'                                => 'dz',
    'americkásamoa'                            => 'as',
    'americkýkontinent'                        => '019',
    'andorra'                                   => 'ad',
    'angola'                                    => 'ao',
    'anguilla'                                  => 'ai',
    'antarctica'                                => 'aq',
    'antiguaabarbados'                          => 'ag',
    'argentína'                                => 'ar',
    'arménsko'                                 => 'am',
    'aruba'                                     => 'aw',
    'austrália'                                => 'au',
    'austráliaanovýzéland'                   => '053',
    'azerbajdžan'                              => 'az',
    'bahamy'                                    => 'bs',
    'bahrajn'                                   => 'bh',
    'bangladéš'                               => 'bd',
    'barbados'                                  => 'bb',
    'belgicko'                                  => 'be',
    'belize'                                    => 'bz',
    'benin'                                     => 'bj',
    'bermudy'                                   => 'bm',
    'bielorusko'                                => 'by',
    'bolívia'                                  => 'bo',
    'bosnaahercegovina'                         => 'ba',
    'botswana'                                  => 'bw',
    'bouvetovostrov'                            => 'bv',
    'brazília'                                 => 'br',
    'britishantarcticterritory'                 => 'bq',
    'britsképanenskéostrovy'                  => 'vg',
    'britskéúzemievindickomoceáne'           => 'io',
    'brunej'                                    => 'bn',
    'bulharsko'                                 => 'bg',
    'burkinafaso'                               => 'bf',
    'burundi'                                   => 'bi',
    'bután'                                    => 'bt',
    'cantonandenderburyislands'                 => 'ct',
    'ceutaamelilla'                             => 'ea',
    'chorvátsko'                               => 'hr',
    'cookoveostrovy'                            => 'ck',
    'cyprus'                                    => 'cy',
    'diegogarcia'                               => 'dg',
    'dominika'                                  => 'dm',
    'dominikánskarepublika'                    => 'do',
    'dronningmaudland'                          => 'nq',
    'dánsko'                                   => 'dk',
    'džibuti'                                  => 'dj',
    'eastgermany'                               => 'dd',
    'egypt'                                     => 'eg',
    'ekvádor'                                  => 'ec',
    'eritrea'                                   => 'er',
    'estónsko'                                 => 'ee',
    'etiópia'                                  => 'et',
    'európa'                                   => 150,
    'európskaúnia'                            => 'eu',
    'faerskéostrovy'                           => 'fo',
    'falklandyislasmalvinas'                    => 'fk',
    'fidži'                                    => 'fj',
    'filipíny'                                 => 'ph',
    'francúzskaguayana'                        => 'gf',
    'francúzskapolynézia'                     => 'pf',
    'francúzskejužnéúzemia'                 => 'tf',
    'francúzsko'                               => 'fr',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'fínsko'                                   => 'fi',
    'gabon'                                     => 'ga',
    'gambia'                                    => 'gm',
    'ghana'                                     => 'gh',
    'gibraltár'                                => 'gi',
    'grenada'                                   => 'gd',
    'gruzínsko'                                => 'ge',
    'grécko'                                   => 'gr',
    'grónsko'                                  => 'gl',
    'guadeloupe'                                => 'gp',
    'guam'                                      => 'gu',
    'guatemala'                                 => 'gt',
    'guayana'                                   => 'gy',
    'guernsey'                                  => 'gg',
    'guinea'                                    => 'gn',
    'guineabissau'                              => 'gw',
    'haiti'                                     => 'ht',
    'heardoveostrovyamcdonaldoveostrovy'        => 'hm',
    'holandsko'                                 => 'nl',
    'holandskéantily'                          => 'an',
    'honduras'                                  => 'hn',
    'hongkong'                                  => 'hk',
    'india'                                     => 'in',
    'indonézia'                                => 'id',
    'irak'                                      => 'iq',
    'irán'                                     => 'ir',
    'island'                                    => 'is',
    'izrael'                                    => 'il',
    'jamajka'                                   => 'jm',
    'japonsko'                                  => 'jp',
    'jemen'                                     => 'ye',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'jordánsko'                                => 'jo',
    'juhovýchodnáÁzia'                       => '035',
    'južnáafrika'                             => 'za',
    'južnáafrika018'                          => '018',
    'južnáamerika'                            => '005',
    'južnáeurópa'                            => '039',
    'južnágeorgiaajužnésandwichoveostrovy'  => 'gs',
    'južnáÁzia'                              => '034',
    'kajmanskéostrovy'                         => 'ky',
    'kambodža'                                 => 'kh',
    'kamerun'                                   => 'cm',
    'kanada'                                    => 'ca',
    'kanárskeostrovy'                          => 'ic',
    'kapverdy'                                  => 'cv',
    'karibik'                                   => '029',
    'katar'                                     => 'qa',
    'kazachstan'                                => 'kz',
    'keňa'                                     => 'ke',
    'kirgizsko'                                 => 'kg',
    'kiribati'                                  => 'ki',
    'kokosovéostrovy'                          => 'cc',
    'kolumbia'                                  => 'co',
    'komory'                                    => 'km',
    'kongodrk'                                  => 'cd',
    'kongorepublika'                            => 'cg',
    'kostarika'                                 => 'cr',
    'kuba'                                      => 'cu',
    'kuvajt'                                    => 'kw',
    'kórejskárepublika'                       => 'kr',
    'kórejskáľudovodemokratickárepublika'   => 'kp',
    'laoskáľudovodemokratickárepublika'      => 'la',
    'latinskáamerika'                          => 419,
    'lesotho'                                   => 'ls',
    'libanon'                                   => 'lb',
    'libéria'                                  => 'lr',
    'lichtenštajnsko'                          => 'li',
    'litva'                                     => 'lt',
    'lotyšsko'                                 => 'lv',
    'luxembursko'                               => 'lu',
    'lýbijskáarabskádžamahírija'           => 'ly',
    'macao'                                     => 'mo',
    'macedónskofyrom'                          => 'mk',
    'madagaskar'                                => 'mg',
    'malajzia'                                  => 'my',
    'malawi'                                    => 'mw',
    'maldivy'                                   => 'mv',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'maroko'                                    => 'ma',
    'marshalloveostrovy'                        => 'mh',
    'martinik'                                  => 'mq',
    'mauritánia'                               => 'mr',
    'maurícius'                                => 'mu',
    'mayotte'                                   => 'yt',
    'maďarsko'                                 => 'hu',
    'melanézia'                                => '054',
    'menšieodľahléostrovyusa'                => 'um',
    'metropolitnéfrancúzsko'                  => 'fx',
    'mexiko'                                    => 'mx',
    'midwayislands'                             => 'mi',
    'mikronézia'                               => 'fm',
    'mikronézia–oblasť'                     => '057',
    'mjanmarsko'                                => 'mm',
    'moldavsko'                                 => 'md',
    'monako'                                    => 'mc',
    'mongolsko'                                 => 'mn',
    'montserrat'                                => 'ms',
    'mozambik'                                  => 'mz',
    'namíbia'                                  => 'na',
    'nauru'                                     => 'nr',
    'nemecko'                                   => 'de',
    'nepál'                                    => 'np',
    'neutralzone'                               => 'nt',
    'neznámyaleboneplatnýregión'             => 'zz',
    'niger'                                     => 'ne',
    'nigéria'                                  => 'ng',
    'nikaragua'                                 => 'ni',
    'niue'                                      => 'nu',
    'norfolkovostrov'                           => 'nf',
    'normanskéostrovy'                         => 830,
    'northvietnam'                              => 'vd',
    'novákaledónia'                           => 'nc',
    'novýzéland'                              => 'nz',
    'nórsko'                                   => 'no',
    'oceánia'                                  => '009',
    'omán'                                     => 'om',
    'ostrovascensión'                          => 'ac',
    'ostrovclipperton'                          => 'cp',
    'ostrovman'                                 => 'im',
    'pacificislandstrustterritory'              => 'pc',
    'pakistan'                                  => 'pk',
    'palau'                                     => 'pw',
    'palestínskeúzemie'                       => 'ps',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'panenskéostrovyusa'                       => 'vi',
    'papuanováguinea'                          => 'pg',
    'paraguaj'                                  => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'pitcairnoveostrovy'                        => 'pn',
    'pobrežieslonoviny'                        => 'ci',
    'polynézia'                                => '061',
    'portoriko'                                 => 'pr',
    'portugalsko'                               => 'pt',
    'poľsko'                                   => 'pl',
    'rakúsko'                                  => 'at',
    'reunion'                                   => 're',
    'rovníkováguinea'                         => 'gq',
    'rumunsko'                                  => 'ro',
    'ruskáfederácia'                          => 'ru',
    'rwanda'                                    => 'rw',
    'saintkittsanevis'                          => 'kn',
    'saintpierreamiquelon'                      => 'pm',
    'salvador'                                  => 'sv',
    'samoa'                                     => 'ws',
    'sanmaríno'                                => 'sm',
    'saudskáarábia'                           => 'sa',
    'senegal'                                   => 'sn',
    'severnáafrika'                            => '015',
    'severnáamerika'                           => '021',
    'severnáamerika003'                        => '003',
    'severnáeurópa'                           => 154,
    'severnémariány'                          => 'mp',
    'seychelskéostrovy'                        => 'sc',
    'sierraleone'                               => 'sl',
    'singapur'                                  => 'sg',
    'slovenskárepublika'                       => 'sk',
    'slovinsko'                                 => 'si',
    'somálsko'                                 => 'so',
    'spojenéarabskéemiráty'                  => 'ae',
    'spojenékráľovstvo'                      => 'gb',
    'spojenéštáty'                           => 'us',
    'spoločenstvonezávislýchštátov'        => 172,
    'srbsko'                                    => 'rs',
    'srbskoaČiernahora'                        => 'cs',
    'srílanka'                                 => 'lk',
    'strednáafrika'                            => '017',
    'strednáajužnáÁzia'                     => '062',
    'strednáamerika'                           => '013',
    'strednáÁzia'                             => 143,
    'stredoafrickárepublika'                   => 'cf',
    'sudán'                                    => 'sd',
    'surinam'                                   => 'sr',
    'svazijsko'                                 => 'sz',
    'svet'                                      => '001',
    'svätáhelena'                             => 'sh',
    'svätálucia'                              => 'lc',
    'svätýbartolomej'                         => 'bl',
    'svätýmartin'                             => 'mf',
    'svätýtomášaprincoveostrovy'            => 'st',
    'svätývincentagrenadíny'                 => 'vc',
    'sýrskaarabskárepublika'                  => 'sy',
    'tadžikistan'                              => 'tj',
    'tajwan'                                    => 'tw',
    'taliansko'                                 => 'it',
    'tanzánia'                                 => 'tz',
    'thajsko'                                   => 'th',
    'tichomorieostatné'                        => 'qo',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinidadatobago'                           => 'tt',
    'tristandacunha'                            => 'ta',
    'tunisko'                                   => 'tn',
    'turecko'                                   => 'tr',
    'turkménsko'                               => 'tm',
    'turksacaicos'                              => 'tc',
    'tuvalu'                                    => 'tv',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'uganda'                                    => 'ug',
    'ukrajina'                                  => 'ua',
    'unionofsovietsocialistrepublics'           => 'su',
    'uruguaj'                                   => 'uy',
    'uzbekistan'                                => 'uz',
    'vanuatu'                                   => 'vu',
    'vatikán'                                  => 'va',
    'venezuela'                                 => 've',
    'vianočnýostrov'                          => 'cx',
    'vietnam'                                   => 'vn',
    'východnáafrika'                          => '014',
    'východnáeurópa'                         => 151,
    'východnáÁzia'                           => '030',
    'východnýtimor'                           => 'tl',
    'wakeisland'                                => 'wk',
    'wallisafutuna'                             => 'wf',
    'zambia'                                    => 'zm',
    'zimbabwe'                                  => 'zw',
    'západnáafrika'                           => '011',
    'západnáeurópa'                          => 155,
    'západnásahara'                           => 'eh',
    'západnáÁzia'                            => 145,
    'Ázia'                                     => 142,
    'Írsko'                                    => 'ie',
    'Čad'                                      => 'td',
    'Československo'                           => 200,
    'Českárepublika'                          => 'cz',
    'Čiernahora'                               => 'me',
    'Čile'                                     => 'cl',
    'Čína'                                    => 'cn',
    'Šalamúnoveostrovy'                       => 'sb',
    'Španielsko'                               => 'es',
    'Špicbergyajanmayen'                       => 'sj',
    'Švajčiarsko'                             => 'ch',
    'Švédsko'                                 => 'se',
);

1;

