#!/usr/bin/perl -w

use strict;

my $n;
use Test::More tests => ($n = 29) * 6 + 2;

BEGIN { use_ok("MPEG::Audio::Frame") }

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "MPEG1") or diag $frame->version;
	ok($frame->layer2, "layer II");
	ok(!$frame->broken, "frame not broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 44100, "sample rate");
}

is(MPEG::Audio::Frame->read(*DATA), undef, "nothing more on __DATA__");

__DATA__
 9EgVV4$#"          O2D"6k7w893wӝ8ˎn3㍟ 7@O{}ww_>k`" kI6_nS/suBþw
_>k_<z5ڋ^E	(n굢A"D$I<?9$ 0>볹wx>
ahw2u;sO`2t4^ODH褫bmE11夒6}DjMbi5qD^cY!ʢ1
E7|qT:8qyNUyf-z_j蕞CRTtbʎ6)+yFRw"fZ3<H?
p;u/6%={%4(&-pcw٘{Ctḏo2˪Z\=UJN1#XjGгqѾ>ᘁQt5yOIIncԛ
WJ)t;IwBg5	4-
n]ʇ2A̤֊:d4PskkM*WuS3ESD41"                     ?4<VaWkڍڽޮ0-31Üӗ   ?>lm|ֵ0 L ` W@ot`rggwww[ݛkb[m|kw?Nㅜ{4efǬrR]JV~ِ@9='"!lgvwMKmlm浭5wwM·n7f{QP\ۭ<K|"[Q	lԲUt뼃V5ƭ/aذ\FdWwuj/$hѵ$t޸QwCa#nlUm|:ɤfp\7R*G7h<TeAk"N%_b&y7DQՂ_~j]an><MlL&)\i-m<ڄR[p|P܏Ky{y؞~@YU(
&smH>xZ&gL}
&*&cJC
[g;P7B\ӓJtҡe^$KRQx5g   2eDDC"2"!D@         *R76-mmۍyߝ獹ス oPªvADx^NDeҬZtHZ=Xo+-^
Yh5
MKȄ.Þ`"Jig|HNL㢶$m~-jmlpg$iSe_flQ6.>i!#Zب *p`MSP7)AyJϑ'CR殓Bpȕã|9\jȖeA:$}dc0#Snty|_Ԫ1\ۍgYȐR;.V]v_&|HC^֢k`ks}wZ}44"YU&-I6
Y#)I$,SP1CZ 
y+qHH'}l]H7ǆdP
DJkwOp폷HFU󩈭1H?fcN<)ηĞ~QJKe-S nMUvitwQaVsI!&vŬFLMK ZW)`Vm
nl؈㣋-YK)#Pq\b}FY67ȃ̌̈HD@@                      &5M45#u}vmu}m}ߎtDA.[( \&8޾FP]ֹ
Hr/	
sJm,M9D8J\Vs4Z$
4U'\Η~,5-cG}fj3-xeJ.3'v
ՍRjY:V9|cvWC
-niW8b-e.5|G"|E##+j8]eSƫ;IMbSTHB*5%b,35b)49
UbY-~%=Ӡ-,toXPp0ڊNT`tv5M@)Jƺ,oM0A.ZdT^?/hK}h+BnOؘ68Cg"~YЉԄw>@@CfuI_N,F46[@3"\0zcA͞`^aBcԂA6( !d6V?)*8?Wx3Q*Qō.|ɒ% V?p/)lvE0THI%>   %EE4CC2HI         (*b%y46
獹]m띵睸7x߈|=Ђ_7!0TI@OI\FpڒD4LCJk] J6m%.DR8"#ݽoIud) e`V
%+*!m5V%ib?	A/fAN$3Bhk sqHM-a.+]"+<D!\
+N=d80+Dؚh9HjZd75*o -N 뚉sI)lMQ3E֦Z..B5>i	ApoTy|

n|;JJq1ŵWp eKND?è9AUMռ5lmOFԌO8\M.ғDlRa
RrԻI$i;5UDfX`ʒ3OKa!΂&8VwP:qR]lUG
sJhQLTO$IYSV8V2֮7M,k:#WOLqZmo$O$1N{b{,	Y`E;wiXJ-K*kxw(<eDDDD@@                   
{sTMc@޲oxםﭺ~9ۭۭndԉ./- pN#k|U)KjFh1h16(+mx-TOa nݤvZ-mTˠw	O0q߬&CzZa_KR:	nڢ۞w(IE_/J$oVIƚ]sZ#F`>cAۖa{uNg
c/VP8ZVjFYdC8%eqIhJ{7lmƺec"^5dl#Ir,	rHvhgk-~tZr	WAiT.\	N 6YyV<h|@>u{R{[Joj7
sK`ev7fD
'pL	p2t ;CHr[e6uI"ѪIz`h' b{I䬑\g[KTn!6YoRa Fx
zY]Mqu()  "7IE4%43C         
k.jWmhR7n9u9מznx۞8ӝ~~e&$KoI3{9rt"05 IvMbj-\}eVfFw
> p'<P+2Z@H)4>In%~Z/uٴr`3Wmݦ-$ټҒM6EE2鎋CHO@əӨƐ:M$mͶcTl,rvZ2[uczt7
qA(vu
$h{$eLk.˯Qt&/m PgT*ݡZN6C,MEMVtf۶
aDVo#˩W;Bllmi)0r̛mJI@
'}\bKq$5)u@=F&"K}fȠIu3NRM6L!;|=R^V!Gd4*Y3gKS<HL@#[*9ۤʓУ7
5Q#Ri1^BM|8Y=a~W,id *
N;IW4?uwyh32"!"!!H                 ).Ϊ޹ݽy54fb֏Fێ8:מ9}y׎x׭w}3\8mkmM$Oyf,&cjƷR
W#>|7%'rnOTC{dJ&["ʈƵQr#`jme ]iYY[K9j2,C8>vNH:H߄u2-ƒrZrJ}WF[?'Cn9T-L744bsZK[HFpFlPNYSd/ P")C`F;榴mOK?$Q#SrN:R#jcMMs`VY8}1u@>p0 AzGh1I8UAjuơ TMcIE	]'I'?L=`eEmI['h0UZ8lpąeLtjISbKYfk	u$t,,X}U3tC$>-So,
)k9IJrO] БG/=H˦J$׶  ?"#;D3355m&YD       
櫛瞸%sM7b9׎5~6y}m0ɇoK~>z'bHJșŐ#{ȒPZT,0phP%w'6xQ`;"$`6P8p.@مVl	.cUvzd;4-"dƖ]֝B
MIQBצ!pj06gM$mjح"6I"5CCrN6G(_ σPR2E7#Q[!y8E+	IV
_Uua:؎6F%@S!c'X&/Q3|DxF$2Ɍm7˭THi\Jtmm4Fj\| 4aߑsn\~ve4V6ܯ
5*WLV4C{UXUEuҩۄjL
8]h(l	6DnqRm3TR@
vt6&@o{Ŏ{-`oC]YBqb17BDLf`̄DDHMH                
G++79
i%5ԍ53xW㎸8n5㍵}n߭@[%T|jmJ6n7깮fلYfY('1lpA{M%i9 `fIkE-vB6a/Si	rpZqIzPðP$sOEMlr֪hhNM3{sLC4aOX\I+k0k4n,
e(u~g&eM:I5w'\	2"mkBFldK6+$z	FB*[f'9E%AǤuרb0:p; 
;(N8.ㅢ5*9o~|7Eʌ26KZ+[٦B!|z"z?}6@	v-ZߚUTQMxn3wciڕdg|9
ks屶Ixm%'ӋeeZe?<7Pо~j-mn|nb`
a]W7} g?|,31}A
o
k  oV"2!dDDu(       
}89
n4׸߼Ww睸n^y8ۨA@]oiO	_ľ0TeіqX=Q)5Nآ6qSDfjI@j@U+8ϮQ5'4ұy[5,,yWQkq.$Pxb1
!х\8
R[[}oI<# !xzLc*2]I3aFzM2E"ɤ
!o^u\<ۘ!#:┦Qa1G.t,1bA"0de,05`Zbe3Go
5B5`YYKYr0մB[qGI |C3#i	[mcal"!ҶBԁM2N6)L[-JZ-VvB(ܓdJ먆"rb\rGaFZ׋[*/b=[u"cwϑ/]1$$oQOTIA4"FK2\䕲HnR9oɹU
v;;ڇt `[2ۉ F̓=#YbPŲJ\x%(<DDD jfdHHHHKe               O8
5]aR5#x7wy۞xmzۮ5#kA*=ܐiEY$"`W2WRj5!7sTX;l^8~E9(DԮFu
*ژ&n
sh-2E8ezS	ymᐲ6kk|؏9A[aJv֘`	x˭GLͶTpAq1]ME*RݮUR$>v|:6i(ٟ̭qgMy
W!٫]\T1F%Zxu&̵ d)*o%Mf;aSNj@΋5D$cy.x@gYJvK1(
jq>'tbVfAi۶uN:+z[Ύ0ϡ))!JIئm6ڸ뢨:M2?сݕz	VmUiVŢBP}?r3|Հ]"dBhnM0DѦo;ݛ;*F/QIiPO!Cڍ~    ؖ331trGP       	*>}zX4zN9~8筹^9~XQKfstVD(&L	$'`IcZ&H\L֮7Qnc_PP6HbĖBrՑ&WtHeҵ!b^bmtjq%$]Fo	H:ln%2U=uz#Bm_Dr2j
q:ձ4~6ح\V{SeYfb9tH܇M11Z5Mnl";؆
.:qM
4]G10+}dy67NVԞ&!͡nºX;iHfjb0uVrB],;˳F6[1N|O|tXB	hd0,c|:6[jhxE&iIM*_!`n
@j+5%. Ȋ.
qTJw"TIt"ndm:8*
,5{
Jp#e"b
|>{4UkRtiğ[aeKKQÌ]?>OWNPspɈŸj:V7QD fbd@HHQ(@             
j
J7y߮x~M5&om&
@޷xy9߭ߍ瞸]]xN?#C.!еDϐV
XP@B;¿%DlKJGЮ6V
5{gsNSW2$XRᤤٻAP:Ж%T&>S@,l.&P 1ҩP4m4aUonLjVZmnWLqR9P(+H(!L./Wя[N͔rկ*6C3Njn܋DN
85#h'$;#DGp6M#yQ|n;7|lNE
E6`2VObDt+!1A.ub9[j?tH,׈0 !$}`rTץx܌,W5rDMR-eZJd!?q5/> <Z	4vi&̘B2R|d[Q#	ljꔶ ##jmd$]*Q'<|x^*oJ5+5jAMTN婾3
4#
7 m%9m)V`    e332@
I0      *980Dv8p8獹㮷8מ6NcK[N<Iv56df$]qRޡZi<M&Ue/y[VC.',KaU`I7rVKExU{g"lмY$32o5)"VN$
vsP}KK/03`Qw?.b%PɄ\q6RgϞif*^D5F/KP3m&BjƌvG! NdpzA=ZxMĸ!4Qgf|fSR78	 2XR!%CdmͦҢܬ?~{F8Y+&5	JpKa)эa"cr;?FpYu<]*0pX,5"M*M8SqWW#lzd*ơ}fڳiu$3l0*p%cbcB{j"[>6[+NSM Y2\O	
]EՏ<&85DEdز7"^ɋm  !""  
H  "%$$@$           *~j*xzߞzx9ZÓM7\TS7xێw㎺߾7~nC5*$; }ű_<WHe½-DG,3T\BڕmWRЮ/ǗgK^I0IdȒN$6͜~ rBW\Wtؙ"1Py%o\r
)c<mK٘wmG`N% r*E$l_``O%_HXG6Z-SsƁ51$ELmdrPČxwa9HkXS4ŭy)i"6χǷ4EJ:V UN [N0ȡe~m#;=ŞL{f&>"#pZl2k3Ҕ3Cك.>SZ
7
U"
ʢw+rwv>>3kXaj*֔tfҿu)Ddm7Ʉ{ @o^7
֎ll7#LPJvb`?!N)~
m^  $333Q IA      
ߎ~v27UR>⥍79~7~y9ٳ]nic7 Nz^Ds~d`|7*V1@@Xxgu#9{(+p2aBCʮiuʲ)ݥ_
yV9\NeDf]k]~tN2K-.H5nEdCRs3n0"DtqFYw`:LEe(tXeᒪ*ڣ%'4Ѿ
̫UA2NM	PEIdZS*ggx`R  Ɨxx@9CY!|د!ʹ*"RйJ@{"˶u _Q(+FܒDIjjLHi˦WIeGd[7'2?ws`kS
Ϯ9dicRZ g@u
xtYIn=l,kUh9\C0P@mJMd-RiIWua`^nZK\䳅+
­Du42So=q$EkFWkב8H~Y$*rz\wկz$!¶j!""!!   
! II             92޹~8yԐs$
4yTMy;ߞx8yY[
$&|5_Ok?#,b2`8F-vVB6jVF@5y}WkYZ1(duz&D[E&9mCmJcfM(
2҈2j@kޥ/Omck 	n8՚19r)F\><,\GDX'frͥ>D>QV)t,ʤlt7 }BlÙ՗Խ逸S"W]})R9~,˴E0&f$%_QH".=sCGV|Cק%M9Tifs:kZjRCui+UB(c[Qi5GA߹'!߯IPdJS-@T8<<RKz[M`ZRD6ƊX4,$VQ(2`y&22e3^~4$c
5+nr$lM~:Kզ.%=m^tZ-RR+YV1n30UkD~@l.]mh@    N333R@a,@      $v玹:n5'&nx3x.7~8~:w~)%%Jch&b2v7/07#s]$X7t\
ZQF#[VҮ	k\)T0i-u6Mit(IHbkSNsv0{(<
Sq/ɪaZef`АQAepsY4 J-.RiqTٖ7CXn7q-:793Fl	-R;RasjTQ]&N)YXń3F8IR
Ƃ.SfWEg]^b^yt/!S]0e%Vdbo^f(i&6{br$Q"PTrnv$gxd@򰅡
A[g@7νsVHlaV%vT,Oɵʫ8V6HoIxFСyweI-tg:3[bzC<`R-'ZfֽuMPk^PAK*X]3\'HoTϓQtU3NxM<Ȉ   @*h A2QH             *.	v߮y8sMI4V$89~7UYKd6B،pg~!ْ	7 {6k,DۈQ6pfa.(=%*?
	4"1FcPSHGEr#6%ydJ~yC<)F{ fԉ;.R%-a1qӳ	yqP6ɄӖcl\i#?n2ӭe^, և9Ì홂(kH`A鮻hza
B+c,d?!:Űa̪S?Pu5΍W@mf5ֻEQYMRL]EJgWxTԤSl|h+uem4H!7܎%Ɍ:cR]H8ӛm*Sl?4f yzfl/Ⴓ%lCI4eYM9H3a&U!#VRLnDPwvT</JziHZ.5RUD5e /[k>rI2pP,ĥo%"I)e-ل0jBbp(WV%PmǢXM'1j  33CcP0@"@      
j*:߭㎷~7۽85%M߭7wx(RWXwHÁKM^l$zRHI2kU,\FJ&ǋ5
X	'j0r"E<FyZå`*$Z\fJ!VϨ6<tQTPxnsBc9dEL$pV(H!7_ߵeYaۗvxQ9FG9(IIЕtW\MKĶ:Ŭۻ%q*&*8\3MQG\?oW[Ab\/ϰfTz0WY:ai{IZՅ#Ulr2ĉ7@@:[u+DR=|Z&Ҋe6Ȯ2vRA,Ɏ )ME$ĥSFliHll"dkQez-Ɛ,j;=_Ȏ
C)m1bo!D+7t8xLmߋH'amfcj[Q3}ЈI)ljuڽ0J@^@1?7ґd%p#mTcx$<Ȑ@  ZD            '87ߍ8}ӋMJ~u5M5D
zyW25e`
J^T_`u>#M |XI*⶜	JNYVM xݍ߁w%	ysӇ@%ys2f=2kxڑ%3ަd$/ldĀD*qS
]1m4ImbZR-VIkGiID@.b	3"ji{ ͔2=׮q`]\ф(#N)}D坷q.F
PыP09p{蘆aae$WghfXLĜm7xd@s8Qk_=VwB<??Sϒ=dʑqi$rn͏s36$Ma~r(l"g34݊d[D
}C9 )<
YDHJʤצubhhyFR<&'#X6C5Mp%
qA53,erP>6cTl'
)##QQS Lv<i> s袊Z   C3Cda0  C @      nw7ζ߮"ۓ_LzyFߎ#rL5&凄*E-wZ^p
PN{jos=$ʛhԿh5L5#0Q>||w^}L\TyV-Y6nDXl~v&6t{|0R{#9`+oXijeAgp8[@_|\Jh;+DBI45&3SMC6ZƷLt2RT
v\oף4g4b2AVY[FXgĥͦQ]}9	$dcHd#Dr*P]sb&Ք'VKt%k4TIMO
avLYsgtL}o>Dhmkwz4󨃷|VɎ$xA-3CmJ"JtL"T(;Rp]G"A-߄wYrrs&則5!;
TcWm R\ O.XX;z;&=Ul݆׺'%kR7Ɲh+C)6UBKfv6
)	5 dbT'@J`[wG
""2"#    
 D"	            (`x8}9߾Mضx5xxQq8jV;SG{u݉Rdӥ4ڷVD%M+NslZLxwyk{ݕ}zDP[uI 	,M;|e6`ހ0!
*HI4) 䵰-_i8]έ 
͢t}K۱Chky(!]M3i6עp_ 8:,j} t'Tфx52=wg䰧2(I*9\g#2P1b<'zY7$%Ged'lHTjD[r;X%4	H7\!PNHIPTz4\,ecZ {Dl!Ps#^oϮR-mۏ:FncMFm,}f3RWZH!
:ͲܟDedCMpD:OAG
[K͠WfvS[fV-
m~Jxx+~pS\c]hX  [V333da@   z@      
ߝߎy}eܟD&3y愶~ݛ ^񠻥Ӹ}|2kT[
ql2mVC"RI 
$l9CiX/Cz`_ھdSbݥ/!n|&ՂڴtתL+ǰbpEt@5>Mvl%Vi!ԡZ
SZ`E2Ppm--@IܦZQ8^MI:,aQAN0F.ΐ|>*	}ucA]MeFJ!XXJl;/&$C2
.aҢZa5Q|ݽtprN/qB!2:tdUY)`1B쭥s` .(S_ܚ66Ep]Xc]f\]p K%aV0dud8C!RI6x'L!b
qYe7R>+IأKu}qA5tkMk"]aRls 2CbؗA5-_ߎuo
o	Z,j6tc.6LTt
\%ܬ 6 Yh>#8Y@ImM%ؠ""""BC      	r H            ˪cy}߭z۞x5iPb'5sxx`HwTer&I,+W]s
FLXpk@Y4l74v8L0
X\yߟ^Xl]5nr4Ɔ$Di5be$ J:.fA&QMf^VZ%drMB
)úW+w: =akBM)l%QEU
{ܥ;`RI UW3(?RrC36&䘤I)!C6g䭆kU(lkm)Zr8u98Ms|+Ck2ʎw闌̙ (;KT)j	%4'.eNC7T0:eP)RwÝVkX
R2ܑ7+2ЬF}U#~.@Z76֒mm{%L'KI~=obX[,ketvmK6mm82Z46ǡMy'niZ=W[Fe#}}BU+￫qѶf  333ebP0 	 9@      
9㮷9^c|ӗǓyq)
_R+#U"8~hvSlBLtZԩ+zb7CGu=q"
 ]HƁm=jX})cy5emeg4%[aeX<J^d#Ƃ#_dլ#+jS-t*ҳ_$Bl7W؛eVV9YLwhP, 'K`>ٍ?T?FkK-+U1YI"N[DM߾k'agfF$9`)sVZӶº
Ba
K.-E<Cɼ:,9xl2e~Xb{7e+vn`dYڡM1Se'	}3i
%>py,wn݃s4/m,'HR\BQhSh]boT]nR^sL}&rW|d{_QO~D
1/9-6e{hB2JNDK=AX`PULTU?,kK`""""33    
 8 @            ڪ˳vw㮹9/e6<[7tQnW VH@~& i*\0^ܚi	"&Dъ&ѻH5oV(P( 5h{f}ʎ#e12K!YYe4摢KWܐ}+l36ܑ)En`jF-#N',U^Ii/0% n[n'r(mԩ&r9!OXaf7bۨ%JuƈXՎ e&UgQ!eYu߳Q	:UgX[LƛȣZW[0(.p8`Lr/wDL5&`w|.cm6m,\6ZTw
$|Hָo
z O7<,mlSq9mdk}bP`hSֹΪ\9}>ho
I'%H2(<єh"	ፏgڙE3w [@TU,YS)Xք0m6E2!	$$Y[#z m,T[ʆU$k9d62jP$Lo?Ru^f5H4Β  M233UdP@           
Ҏ9߭8Y#x(75	i*f
2Qho"pW2\9,^x_Bֿ@ĳ*i^ENj
U".jЬ̔Zi."zgc)NS7I72L-ƳUGS^IOݮ#ڗ(T>vmӆz	v|IIE,ÞCUBY0?pэI!+q2ѫvcvΈp_ÃRj7fP;:`aZU٤"AV}:恅L3dFLO|-|dyKE##4e[<)]*De191i

mj0g[Sq!@?߿$r8aTRFJ8ЮEѷ*+9Uxj
*v)ߝ]A=-cMQ%Z5xK_:00j1+uFm1ZJٜ'xMs?04}BISz.Ѣ^a2^)#Ni4qCEnd;օ*u8ѡ#;K_+JwNYo
Ӡ!"""C4      8              *$9߮9~~x~SٰV4R7yQq"m$b,qI\s5#Ht]H"\iMkuukp-X_$fKȄ/o*fgֈxQŜ
8ȉ<7$L2Ujr;GtlQhE[[0#*o%FhtL:.yAy$I"P:U{d8BwsY=KA֨[̎ SR+XBŴ0)#
P?+n
ʇKD̙M8ٍus8ZH:kg8DzkݢNaiWAo\vK2jn9FQaݔ0Tr*6)1ѧcFa{04G|$1
m,5$f&Jr:Ή-4U+U4xi-`"mW$RqLD\McNMpVuA5GVSe9ayG)8$8Cl+xWG>#ga%P1rq Ddm­jFxMEJ:А/hE!%_8b9 "33UTaP0 p 8      )ے{~x~{~w߭ZR
cV؋mG0
ZF%ZqY*/g*(f}l/_
ۡnecd8BErl!Km9j
%	ؗIC`G+ur(D7+Zewu%]'t,eN]&F]+vִHݯ|FfIӊ5k'Jg^8]E^x77"E	3ߔ}sz|Ū!,y9 Im]^\_#t%w`C.pUgwiHuJd6#GjuA݈zn~	#gYcf.-!l#
I%6"_&(#vM)yt#n٫jy%Yof̥ɛI26Yzm}'uΫǨ=3/0Hm\
խg9Оڧ
*\sye.hѹٯ٘Wg`^%	f`aDynyzYaؙ'gaN!![]^kWa-0)&.֞^I`: MO 23                    7~|~~yߎzߍ55Mt3
j\ocnFIq}@|M?X|
ZI\v\ZBoZ29.Ǳ\l[8GlC}X*-fD}neEuZT7+Zeo4݅bS'FH3qJ9
q wv^߭ѬuSg[+
jOcibbיr:	wyr oDe?Ӄ|~{٥F	f~ҧjۢ𗠢3<Xiȼ
(iu\
]FuS]=~#GjuAQ7}s2evFN)Vڿs5XT\~J\RܠL6Շ7U+sv
\LdJyiŗϚߢwwѩ%xiH٥66\TVt?tXħ>ntqBcSe2f#A=fbf`aDyny]ƞiӔ,X|nP«41 "	"F<×ppȣhWaL   ##3TSa`@   q 8    

.~筺~9߮۞^j`v5
TØbꦁb̨$<6csW{/ T=%U pӬs/t)ȪޤKD*N-.Ckt`s͖9U˗qYDV+a;=۠f|͛X18GWWJBN6ĘĸCm#Nq[& 8fD%$ز`[ǫQ>:s00e*vۣjU<?[rp`AoxBF)fVU)J* 9%>X<^	_ܷ֡sJTX1evkRpKرp(Ϛ_B!϶;%mZQ!2K(kG
3lVEPuh|*f-٦ޔuVZ!`xRmi+;QWZ2^!( VTzUS-,-h<=DV<'$:	 `M0jE<*SYd5wzvZ酌7Č9IZg­tƕ#PphTO0
,oWLpA0./o_4j7>vDDDHHD@        r? 8            
髨"
㭺w߽+č66͗:r֬ZE@B=t޽D-fZU[6mҨ Q@O9ȅR>>}^ہ|wPڧI5 $f9=דۜ}21UnkXfmUđƻ[\$"z712!%ja?#ůZ7m6Xg8}[8OCRLCm9#Q`skYL1<vKNxfŖ⊇k"G޾U5,mSlEuOϚwuM.-IƿK6DJ=m-NѴ`#4+}]"K}4jQ8j"_B#T~֌./=\E}-LK"4-n +ac<Th4<);,	fIJKqL|?11Vmx:f5G"ÎO$HÙH.\OW6b0b0k;^D1?NhFiRܕi4{0R`ߓcq)~
?*   "#3eeaP@    q       
&9ꈷy85ͶmxM
P[jTˋvT'	T3zV+xK輱އ[ft߬}4|#q'-u">݊Jaσc)oܾ#'ZdȍDŷRKo":>k
:ȱ1e$K{=nwydEN
[8ӒLEY]O>F.Rʕ7&LBHBhu)fa/luMQaio:3ul
1"8{{m:tGex^3*ht_LCװEޫarɼT
(c$DKͦ7l/ٯ+( >bD	q)\9}p,ib+R)5Qޔcc}t0ałq#&n/lm7O
v%4t43	I9l̅%}Smnƶ9$S.\!<ީZaQ#0?:@?Oͫ6M$\LJvf7j4otĂȅ͏ `;AjۍUذŏ]Râ_ IZ>{A+5U/P v[mAncx<DH @      x            
ߞvxߝێw۞Sb\@h]6%MRۼ"*b&ƤLms/
:oIF4omo,͊\QFzEF8n+P]dL+
Miu:OK$\=90v5񧍷q+\	%";yqJRl2ŵ4N!X4L>
)!ȘXu*Ў)n*{S2%RMəf(<L8\ 靺:6OF<mOJ4<Ƿ!^if8VYPg~g9SMܱ,6^mH	':~CBs MhTuf7߷G!NCsb:b_Gw0`ÎF/b~
+v&6F㐶z{Ü{aնYmq[NG]FyUn'bT& ~Sq)/ο1Cd$FZ
ÎH89ir ءK;VlVyW(kU[RRB&QMGBVwsWkeYH>0/     233EUSA00         .۾4N;~8vxߞ54ٓ74K*B:-NjԬ5Jj^<v0yZs	̥)dp5P$oi/ƃ+9KY)<GW=L31Ej,JZiە^-93ÄinYOV>ătSę
(,~D	br<)X
||~Xкjg@;^sܺʳ@ZXۚϗӦ.!v/1\7l81>XN1UqJ7hb:3I
p?3Pl%E[g3xj2ւU_o.K$%kzDq,:=˲MMf]*&ͪlhË`F=K=AK4̍	d}v-c;}ڔiA:>l;63U"L<S*s_HUV%1}$
,YT3$#-lfK2H12o^Z6&Kgh}F2biU[Ь:a+FqUpVwPK}Ph}67@DDDLHD        0          
62
8mߍ6;JCMA
b3O_E:-iSp]&҄ZILծVOI#T$o;1y`_%TVs_3՞	^/5\UvUTpOF?P+6NZrf13|@bYx_i^Xm;!0q2;#>LxR,d?z_i;QUlժ!-J
-8qύ27/M\BCՂ q i|2shTf?|@іu
~gzlnuIe宊cJ:ws#I,(kc\CBnhԫo=ڨYkzB"XYS3˛T|
uB1lS=6h QZǆw5oVm_LR]RCZC&tH2j;mԛ@b6H:YI
|<`NmjJ% x9M-|?,M")|ܝe#5D"-^S})@@3FVe:&8ߟ\    ;!"2SS21         8  
梫#vy^7׎9xT47xq]#wL4QF.SiK_Y+oT\kSSVqͷޭBXnsgz)~$ǘׁS[+z6	u}C#fpۯYJNm"$O´:5f` Y*|MJJrϗTub-cXъ
k~$X"R~w3i%N3\n<.fhJI]>I
1"' 9mjm.Hw34xd
l=XWH4eB4zz_!˞po亱8u(]
4[F4Ƀtl/`#7Dq$Js#
N&T3+?+l#O!W|p(-߮hZwb4ٓLXK4*R>k'?c.Roƶ1mzbֵt␱0p sj9bK.(+\g湘ԜpTQ
P@sDE^qP>AüjΘÌtMRJ^:t%g*P"gqdx<  DDHD @         p8         { 78^8:^v5D5CTgLg)ZͰ]	:⹟Dҗzw VO%h _6:WbSJrR!H4	Sei $@!U_"["7m#-
#twnI.HhihtjjoTt U2|kѸwp?B3[#1[ՏT0$nmf,7Mk#Ze@/v5kb&/!Iffhk6D2zW1#7eƬ8s*j u+HyMJ|i4imp&T1D>)-Z>ebsD}"ŀqV6,F
BPT'e$=v<`[5j	m$9 ,DbiU5_8@eb[ûH5 ]2aDAnօ#Mh!XVa--{vWN|)6	*%ۋx0`єP=
Op1TEGoa|n)  8#"""CDSA@0   p   0  jN <㝹~8nzm׾nscL9m3IDh[S0Jo"^GiXSߺ?eF֨
nBiMԕ
Z3络IuFxsmi<M(GZ
NŤ%JDQNOtBX2L
wۃX62	"L&eP [8d
٠)<Z}wzdi[$,
Ra=R}8-"Å7|Ġ(`n7mڈg8e.^m':0ȼ2y6re3DiKI&G]:L9?tܫN{OX ]Wo0rcI65jH4(ju.,f\.-0Ow#1[ [I6q,č9]];(UFaAԌ$.y@(XW25K9!4biZ啨>F2N>hsLzT,txht喙$$m.(y#F)$ǾxAي#5ƜҬmViEREm$ӂ|
/e	4uy E  1           8        + ޷n{]^8nMcLڗ8s,c')

?&}Ă __kDABw1=_>Fy=?.J ^#B
nX@lȫGOѬ@s͋Bu9	iSWֈ<Μ_0'aUVmY5kU
-kN'Bvh
{62\>bW!&Yi
2gT,HN;;{AQ`$76
MŮ5;"K"FΌ65A )cL>$yL_Od7*Og- +C
NGm456t&<bnʓi8L6w&`FŮ#\s\m@:1mAxu#	,jmx#XxU1}a	T5N
shQ2^h57)H_x7mښǱlVd*wՔbY:2?.G-VVGS')P%BuWyo#%;m|KiIM@~   &""3TUDCA@@0@  q    
ꪮ9߮:߮8睹ۭzT` IZ6Tu
p'VPXaYٴ-V8#$i><{T-X"*pSA&YT}-HVZ$tb	bmؓQ_ψ,jjHzxY5eVØ{$_~ʎt?!\]wOGerEPxwJu~[һW:Z! >Vα*fGQ*UGjQ֨yc	C

xf5{l6'([.Z1-ݨ6
HsDiK5F]hX@<σTZ=h qQCHvEvMkDU͡=bdnu:o[w@lgv,paVT
6kelޅq9I3Tw80C6i~eMJ_ZM#Hs{4zC^Fki]b([	?0u- (Ep	-[qyRjCXA#Zxl;'RqUw)ays<?>BIc..YݔYh%pWW~145tQuYn$7H@DH@        ap      * 
~v^{ߎ9yI
F
zct%f?q&fZG§e*Q
BӪ|x-2mz;u5&zVCDo?cA'F ,zǔX0$NƲ͕jji1)N(yM=Gs
'37~A7#h+-a*z}jogXml
6ʳҾ--^;lOGZfK*O[Me+%daj{Z'ͦ@<cx}reŷj1mEuͶ{s׈@{rU9`ml>po>}-@580!"e-3a,Lpo\RCxh4)oᝈ
eFDէLN
Fm>	}.۱~rQ8@NU㊜Їց#(C7c7[J/9Ƥ4fGZTD%]1u_?~
"l>䓩8HxUHN*֛XsQ£QJrEnPp<sϫlN """DDDB100   q     ɭ߾8델ߎyy랶}F#z\PVpӎ gzȤv͠`5~X+mEr7#qiuɄW)y<>W,މߝVi#E "Ti5щ[-cm>-q'ʦ7
G*Luͬjd8氶{4OfLWB6}=M۵FjԋI5dͪmMf._TO<^hw_ ۉ#Eӊe.&Z.ugtҽyw#7Η@BQv
MQiז{pţ{uorNJ1IjshӎM6Q+oO]Klx;iKQ56Vtѕ$ff
aڅjJ-LcrAW3#q.kHgqRq-L[
?b;bٟ~;	i-4[t\FYz
M&Wg(v^=2?oڀٜ֣tQؚM"7h@dՑ)hšaEvuÙz7ۃ DDH           8  P     	認7nu89yy95J.MŤQg-b5vc#Ȓp@6	:sbVoP~iv?!g>8Yt kEr>c(#4f9&7-IU]UyWxmWE%g؝U&ֶ-";R
V&C+.۸.PlSo>UY)O)IUvXSܕoƳYH^Oh'EAwӬf,,KR*#*nKTҽyw|\]`\W86]4x>T,F0#^-R&*
^blN{A4C@,k<r3o͂KIkTZÕȨd`Y^Ҿcxo+U`ZQhİU(kҶ#->x#ITֈIpűAf-܃P7'nR]jS[u"NWW$nJl85؊d/&
+L'd#HP,hXQh7' @      """DETC1@0         (몯w:߾8獻}7QDU6Fzd%$!Dۊ08dWG;x&ax3'Feem@wmjjEa&zR#hs&BmͶX:%F܊21Fc	n֖򾌺7u(14@Ѫw@G72 |< Gukj+4 끍)d)[""=Xbr<TK`
ѹWX	ZiJRHۓI1IK^-H#EyF
;5
]fݦĚ	-L"0 Y@`ՄZCR/ph&$uYeAwYDEK;4Xܳcѷ68O'aB[SZ8I' ܁3Zib/(N|xeS~&?R,{U5BM-dޛM_jbGll.vi*ToSaSR˵uƁP8%
/U\G}!@JmVVc*5a("2#>xi Cݍ
 B  !1"           p     .87}y^8y7sV4Q5;7GOQ*Uf"nRFI3F
;s<U*dCSQivܪh~
tJh^ 5h1]=e&|gZohHk@nBT;;4nϦ:`dG }$V}B釚H<R_DxɔH`M@7ndsqZ%G#eh`Q.Ōɖ(P!7pͪFTS{ Gom\G
3ewk7`_񩏃-h2ֹVJ8Q7^.CV@`ՄZ[ #N>Ck:PݳwT]/0Y((`[vH7L,nY{kHrmZ5|mhxwA jVZ{Xw!ʵ|y՘ZB5RmSҧ04T3cYZ?U|ɱ
b{_MI6
kװ<Dۘ	/Qg\hk0Â[pFY^bLҵ:U{nqy=чŔsbhN  !""CDDD3! 0@        (y;w~w۽nxמ9ۍy~55MhڑǬDpsTgoTmNj
P:K b_8;:![ka7È/M$W4*=AE{hd$yȪJhWdÑBi'YJHN$M9B.4*MT
-@T.@Kڭ;ű:MX>FRU8ʈ]i5Eyzٗ&38+V9A"FHi"r蔹%km/CL8aPbf%^/HPcP4nJ#9,Ll৐*y8p_cAEUԭj"գ+j#146*>
<sM!	Q 7Ki7eƌkq0\STVVrmAXҘ%#[`Û$l
T\K~k:Wr72r"Ti+ģAىIɶNmY0⩧Cߔ`vc1$i&ɵ٬F6d=^|@7g ڀzUL57Ճ DDHȄLD            00   
* 
wߍߞxnwߝߞ5띹si`^Lԟ>6#[]~ezq\#bSъP
\߿A
~xK_8kxW#ok2	D2ywka7È/GȻ&#t
)6C&
"̌[&EPSB&T+^BWĮTr85lPU<`dEn̝kYwcIrڵZaw&js/T[Wj2pMJ"ZxMI	
>2>	À~+FN)$b>	T$f^E+:j߲|0S<]RcyD;fzsZ-Vt:mzhlю"·4r
4ơ닶[P[E;P%Izh5љ&y%(jߚZ!fX%=ًjj7\NkM.o^Kؔ\K~k۵WJҕًT8m^j71n֗7ZȱM8z
Ar>btn7JIIaC$
68@   E"!"36542   @    p   ʪ+89׽ۍ~8֛nhSK"5*l܌Z׶<q<ibB(ч`}\\a%7J%T)LňheX5gI9ތf-"=+?Uo;b*QEU&G"!(O#=:BGv8nnlq*MYL$4C:;	FR~fo`8T=iB-*R J]$O5vِqq7G7{q$md*+GV!Gg!Z-uA
DLin띷P$o^XVЙW[IȨvt1=#ѕAGcr܄'[+44%/&7#
/
Y`X%2Q5mƆVE>S2RMĻg(z ~*pcCB=,i-vły.JE>UiCs票#墥 W9 eQZBY%BDcIÍo2A'4&CTT?sI~G6IqIv"!h䊚QSőU4l|Qr7,%DDDLH@H @              
 xߎ:ߎ8ߎw5ێۮvn׮u+5i6I
ӵ.k.$D˅% ش۱
ҵ
Ldg8v,b[!aW}s=EjB𵶅%>f^UhvvѾ[r,DBvu7ˤF5Hq-RuJo ob2^+КͱQ^mR0/ƵȌ@={D5l9Wo{!6>or1J
U;w5#g1G6kTBG}Mk2FSS_&szZ^@˚*	0}*YдrnSp*Zm#ĹPDэnD}Sf$$9>~Mm0P;Hz ~΄d!]t>#ZZɺm;MĎ4ΦLV뫤҇nr5nA(g;︴ ۇM|>Dsk%}u_&ܑ4>Tuw=BKs^,lک:4'@  ""#FEED3200`   p   ʫꪢ:nyםߎ87~87IzRsvq rKm̘(nSliJ Db$HLhϯfJSsѮIg/W&["ignZTi8u\Z|q"c?me?v]wcﵡM9R{Ȍ.MH؊qu[IQNe얓2yBHK.kHi]2@[خM2:tD9\?fnHmEC`J<dKM$s,mbG&nXN6u5hq
bZY1/PqXB^ GTA+\jSZUHc;~Kl&1e6XP4ig;m"BQ.܊t< 9kvK%C	`rIآ&qb2l;M~*XHA{h"ݽ^jRWuNk7!*H}G"TN*o2|҈u;7BQM=7+ͩ4"B-QfB7#ʎۣ]d*c~pcts7B @DHDȈHDD            |     
2 ݶ~9׎6}ێ:׎5~
A
IzI
D+QfAi5ֹY.IoaA2Lz΅DLs*
~pR2MMطml>Ŕ)a}?O7b[<)D;<Z {Ƶi\J5\Vq}Flׯk(K<7+6
UijJsb4sl*Z̽=_NBpm$mxKZ
6:' Mj"ڨskGk[-z
!wuYЫe0&MW4Ap#lFKUD`e&S<!
zz`>v8*jU8'%JԒi	yT>t'mAD\*rF6!K ͱ`~N0^>zMxڄ{'&)Ȩ^ƚ=_=B!FDgKٝ($ѭmn:9m
j㭐k栾ٺ;ހ8wgceSNǭ@n1bh4?^o{Lo^!y8hJh  z443UVfUDSA@    q   
J8םx瞸89ߞ9玷857- 6jVXHfejZD0پ	Nh-ITsniM+2it&n:@pj;+wm
)[
l(jbG.jH@Ef$v>HJ,b"slY6{!eZ0̴IJU#^3ǝprU6Kxfk*v$z,tHED#evC
С绯J&~QA%U(뀹
5h(vn{]7 I١,5UEPa#1JCdVQ6_r@3*OZˡ$ݬex+8.O\V$J̒lOZ>ڽU$uFw5$d/K<Ѩ*@Ij`'9"S'woLjXjZ\zLs\ uK
(kZ<57tb\^,k*eXh3t)'46GwV}
+x8:ʌ
\!5I"V3-
oZ5FZi7ڬ"D !31               0  #*27]|~۞׎6۝㎷5N555QU'YP"'wkS\p'F4Z_ˡ+ӌOITLD[؊j]md;6ima8d^J

Ů(vj~ƲUL1x96~_%&S1
I qپʅdkf`θ8~ԆѓV)B
W<1Ki8PX}aק0y ᆚYFis]Ck6m}삮ʐr$~-5[`|mS*mz?EyV/\ QvMZGLhh%׍ՄRO$l8I6zɧTbB{`s-6(͛!7y+l!EO0Єdt@+}-}QGZS	B>-O:1.O*+.*j=ҖU .H{>y>6!Ӕ	]uĎZ0k[VN;E1S
`mVr"|t   +#34UefUDCBA       n;מ987<xyՍ922uvڇu˹33&71-]a-S'1~|[}JpL,25Jyir<\#+֔[
FM0
@݆h4ɍ&ETQK:##աm}
s]1\pK9ӭ1i\ҡ(h]&ՃS@!=;}E9S]65Z3Ll0<~fMmT+퓍٢A3;NřR5naXB=%Ɉaf/Bor_]Q4I=nЈ'I3hzBI,q&_GA<C363fD\rT50̪9A][#Q\WNUZ83x,Dn3TCG-
uMTˎTZҴ[6m˃SV^-bne|("jmN(T̍*^D;#oF`jg$hU!Ef:ufy5-.mId'70<:a|pr%DEq_M($YE`
V)Mygw%g]7d DDHHDDD@              8 0 
"ݶmyێ9ߞ87UsqV44
S`䱴g4Tb?_xyUD`s#IFi5R`ʏw Tm#ˊзm#RGT,~-Nb++HVmNn+X
Lֽe6C-DH
FnHONp.jQiZ{ UBSl${p	{xI|z ŋpg;-Kek26haT9l/Bor_]QNu"XKvkYmJ(Lh0y6ׇ	w
0iL8ƷAD%a´Q7y]9Wh\P"j"aź)(4? JKcs+Ahc&o ݖ](I$r:m?mI!IHIaց%RQF՘#=b Y+^IǓQ/7@0/ֵျ"[xd|A/JjY>IpYG_nԃ   
