# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

BEGIN {
  binmode STDOUT, ':utf8';
  binmode STDERR, ':utf8';
}

use Test::More tests => 4993 + 1;
use Test::NoWarnings;

use Unicode::UCD;
use Net::IDN::UTS46 (':all');

no warnings 'utf8';

our $UCD_VERSION = eval('v'.(Unicode::UCD::UnicodeVersion()));

my %p = ("TransitionalProcessing" => "0");

is(eval{uts46_to_unicode("fass.de", %p)},	"fass.de",	"to_unicode\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:60\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:61\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:62\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:63\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:64\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--fa-hia.de", %p)},	"faß.de",	"to_unicode\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:65\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{05D0}", %p)},	undef,	"to_unicode\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:69\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:70\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:71\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{05D0}", %p)},	undef,	"to_unicode\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:72\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0à.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0à\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:73\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0a\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:74\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0A\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0À.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0À\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:76\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0-sfa.xn--4db", %p)},	"0à.\x{05D0}",	"to_unicode\(\'xn\-\-0\-sfa\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:77\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:78\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'a\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:79\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'A\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:80\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:81\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca.xn--ssa73l", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:82\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:83\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:85\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}.\x{05D0}", %p)},	undef,	"to_unicode\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:87\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:89\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'a\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'A\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'Àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca88g.xn--4db", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'xn\-\-0ca88g\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'a\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'A\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca81i.xn--4db", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ab", %p)},	"ab",	"to_unicode\(\'ab\'\)\ \[data\/IdnaTest\.txt\:111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf", %p)},	"a\x{094D}b",	"to_unicode\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}B", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf604u", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf014u", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("¡", %p)},	"¡",	"to_unicode\(\'\¡\'\)\ \[data\/IdnaTest\.txt\:164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7a", %p)},	"¡",	"to_unicode\(\'xn\-\-7a\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("᧚", %p)},	"᧚",	"to_unicode\(\'᧚\'\)\ \[data\/IdnaTest\.txt\:166\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--pkf", %p)},	"᧚",	"to_unicode\(\'xn\-\-pkf\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("。", %p)},	undef,	"to_unicode\(\'\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890a\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890a\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890A\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890A\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.eXample.cOm", %p)},	"www.example.com",	"to_unicode\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bücher.de", %p)},	"bücher.de",	"to_unicode\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'Bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bücher.de", %p)},	"bücher.de",	"to_unicode\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BÜCHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BU\x{0308}CHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BU\\u0308CHER\.DE\'\)\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bcher-kva.de", %p)},	"bücher.de",	"to_unicode\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ÖBB", %p)},	"öbb",	"to_unicode\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}BB", %p)},	"öbb",	"to_unicode\(\'O\\u0308BB\'\)\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("o\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'o\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("öbb", %p)},	"öbb",	"to_unicode\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Öbb", %p)},	"öbb",	"to_unicode\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'O\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bb-eka", %p)},	"öbb",	"to_unicode\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b.com", %p)},	"βόλοσ.com",	"to_unicode\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c.com", %p)},	"βόλος.com",	"to_unicode\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c", %p)},	"βόλος",	"to_unicode\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b", %p)},	"βόλοσ",	"to_unicode\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b660p.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b．c。d｡", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b．c\。d｡\'\)\ \[data\/IdnaTest\.txt\:235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c。d。", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\。d\。\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c.d.", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--tda.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.ü", %p)},	"ü.ü",	"to_unicode\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.U\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.U\\u0308\'\)\ \[data\/IdnaTest\.txt\:245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.Ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--u-ccb", %p)},	undef,	"to_unicode\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a⒈com", %p)},	undef,	"to_unicode\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a1.com", %p)},	"a1.com",	"to_unicode\(\'a1\.com\'\)\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈COM", %p)},	undef,	"to_unicode\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈Com", %p)},	undef,	"to_unicode\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ecp.ru", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0.pt", %p)},	undef,	"to_unicode\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-Ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-a\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-a\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-Ä.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-A\x{0308}.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-A\\u0308\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-Ä.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ＪＰ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。JP", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。JP\'\)\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--wgv71a119e.jp", %p)},	"日本語.jp",	"to_unicode\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語.jp", %p)},	"日本語.jp",	"to_unicode\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。Ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("☕", %p)},	"☕",	"to_unicode\(\'\☕\'\)\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--53h", %p)},	"☕",	"to_unicode\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bss", %p)},	"夙",	"to_unicode\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夙", %p)},	"夙",	"to_unicode\(\'夙\'\)\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰\x{E01EF}ﬄ", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\\uDB40\\uDDEFﬄ\'\)\ \[data\/IdnaTest\.txt\:301\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}n\x{200B}-\x{00AD}-\x{180C}b\x{FE00}s\x{2064}s\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034Fn\\u200B\-\\u00AD\-\\u180Cb\\uFE00s\\u2064s\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:303\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("X\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}S\x{E01EF}FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064S\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("X\x{034F}n\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034Fn\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("xn--bssffl", %p)},	"夡夞夜夙",	"to_unicode\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夡夞夜夙", %p)},	"夡夞夜夙",	"to_unicode\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:307\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰\x{E01EF}FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}s\x{E01EF}FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064s\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'a\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'A\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--ä-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a\x{0308}-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\\u0308\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--A\x{0308}-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--Ä-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..xn---q----jra.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a..c", %p)},	undef,	"to_unicode\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-b.", %p)},	undef,	"to_unicode\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b-.c", %p)},	undef,	"to_unicode\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-.c", %p)},	undef,	"to_unicode\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.bc--de.f", %p)},	undef,	"to_unicode\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-b.", %p)},	undef,	"to_unicode\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-b.", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-B.", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-B.", %p)},	undef,	"to_unicode\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.b-.c", %p)},	undef,	"to_unicode\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.b-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.B-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.B-.C", %p)},	undef,	"to_unicode\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-.c", %p)},	undef,	"to_unicode\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-.C", %p)},	undef,	"to_unicode\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.bc--de.f", %p)},	undef,	"to_unicode\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.bc--de.f", %p)},	undef,	"to_unicode\(\'a\\u0308\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.BC--DE.F", %p)},	undef,	"to_unicode\(\'A\\u0308\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.BC--DE.F", %p)},	undef,	"to_unicode\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.\x{0308}c.d", %p)},	undef,	"to_unicode\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B.\x{0308}C.D", %p)},	undef,	"to_unicode\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.xn--c-bcb.d", %p)},	undef,	"to_unicode\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A0", %p)},	"a0",	"to_unicode\(\'A0\'\)\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A", %p)},	"0a",	"to_unicode\(\'0A\'\)\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A.\x{05D0}", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0A\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a.xn--4db", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0a\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.xn--0-eha.xn--4db", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0u\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0u\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0U\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0U\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0Ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0Ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("b-.\x{05D0}", %p)},	undef,	"to_unicode\(\'b\-\.\\u05D0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("d.xn----dha.xn--4db", %p)},	undef,	"to_unicode\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}\x{05C7}", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--vdbr", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}9\x{05C7}", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--9-ihcz", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}a\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}A\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{05D0}\x{05EA}", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05F3}\x{05EA}", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c0a", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}Tz", %p)},	undef,	"to_unicode\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}tz", %p)},	undef,	"to_unicode\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}TZ", %p)},	undef,	"to_unicode\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}tz", %p)},	undef,	"to_unicode\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}T\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}t\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{05EA}", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7-zhc3f", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{0667}\x{05EA}", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c6t", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a7\x{0667}z", %p)},	undef,	"to_unicode\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}Z", %p)},	undef,	"to_unicode\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}z", %p)},	undef,	"to_unicode\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b194h", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc", %p)},	"ஹ",	"to_unicode\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ", %p)},	"ஹ",	"to_unicode\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4by94h", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia7523a", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3q", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3qq34f", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga828w", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06EF}", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a953d", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxq", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--cmba", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{06EF}", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb", %p)},	"\x{0644}",	"to_unicode\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}", %p)},	"\x{0644}",	"to_unicode\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒕∝⅀\x{10EE1E}．-\x{E002E}", %p)},	undef,	"to_unicode\(\'⒕\∝⅀\\uDBFB\\uDE1E．\-\\uDB40\\uDC2E\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("14.∝∑\x{10EE1E}.-\x{E002E}", %p)},	undef,	"to_unicode\(\'14\.\∝\∑\\uDBFB\\uDE1E\.\-\\uDB40\\uDC2E\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:473\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0854}.\x{06CA}", %p)},	"\x{0854}.\x{06CA}",	"to_unicode\(\'\\u0854\.\\u06CA\'\)\ \[data\/IdnaTest\.txt\:474\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--jwb.xn--9kb", %p)},	"\x{0854}.\x{06CA}",	"to_unicode\(\'xn\-\-jwb\.xn\-\-9kb\'\)\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{0600}｡-", %p)},	undef,	"to_unicode\(\'\≯\\u0600｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0600}｡-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0600｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0600}。-", %p)},	undef,	"to_unicode\(\'\≯\\u0600\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0600}。-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0600\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{E0D30}ςႭ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\uDB43\\uDD30ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{E0D30}ςႭ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\uDB43\\uDD30ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{E0D30}ςⴍ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\uDB43\\uDD30ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{E0D30}ΣႭ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\uDB43\\uDD30ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{E0D30}σⴍ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\uDB43\\uDD30σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{E0D30}Σⴍ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\uDB43\\uDD30Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{E0D30}ςⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\uDB43\\uDD30ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{E0D30}ΣႭ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\uDB43\\uDD30ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{E0D30}σⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\uDB43\\uDD30σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{E0D30}Σⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\uDB43\\uDD30Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡰ≯.솣-ᠢႠ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᡰ\≯\.솣\-ᠢႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡰ≯.솣-ᠢႠ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᡰ\≯\.솣\-ᠢႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡰ>\x{0338}.솣-ᠢႠ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡰ\>\\u0338\.솣\-ᠢႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡰ>\x{0338}.솣-ᠢႠ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡰ\>\\u0338\.솣\-ᠢႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡰ>\x{0338}.솣-ᠢⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡰ\>\\u0338\.솣\-ᠢⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡰ>\x{0338}.솣-ᠢⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡰ\>\\u0338\.솣\-ᠢⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡰ≯.솣-ᠢⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᡰ\≯\.솣\-ᠢⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡰ≯.솣-ᠢⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᡰ\≯\.솣\-ᠢⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E8141}．\x{FBEE}\x{0FB2}\x{0751}\x{0664}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDD41．\\uFBEE\\u0FB2\\u0751\\u0664\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E8141}.\x{0626}\x{0648}\x{0FB2}\x{0751}\x{0664}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDD41\.\\u0626\\u0648\\u0FB2\\u0751\\u0664\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E8141}.\x{064A}\x{0654}\x{0648}\x{0FB2}\x{0751}\x{0664}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDD41\.\\u064A\\u0654\\u0648\\u0FB2\\u0751\\u0664\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{109DA0}\x{1CE0}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\uDBE7\\uDDA0\\u1CE0\.\\uABED\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076D}\x{0820}\x{D9CF3}。\x{1D169}Ⴣ\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u076D\\u0820\\uDB27\\uDCF3\。\\uD834\\uDD69Ⴣ\\u07D1\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076D}\x{0820}\x{D9CF3}。\x{1D169}ⴣ\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u076D\\u0820\\uDB27\\uDCF3\。\\uD834\\uDD69ⴣ\\u07D1\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{10E62}\x{1B44}ς\x{08E4}。\x{0732}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62\\u1B44ς\\u08E4\。\\u0732렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{10E62}\x{1B44}ς\x{08E4}。\x{0732}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62\\u1B44ς\\u08E4\。\\u0732렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{10E62}\x{1B44}Σ\x{08E4}。\x{0732}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62\\u1B44Σ\\u08E4\。\\u0732렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{10E62}\x{1B44}Σ\x{08E4}。\x{0732}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62\\u1B44Σ\\u08E4\。\\u0732렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:507\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{10E62}\x{1B44}σ\x{08E4}。\x{0732}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62\\u1B44σ\\u08E4\。\\u0732렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{10E62}\x{1B44}σ\x{08E4}。\x{0732}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62\\u1B44σ\\u08E4\。\\u0732렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{200D}。\x{0686}\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\\u0686\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。\x{0686}\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\\u0686\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。\x{0686}\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\\u0686\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。\x{0686}\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\\u0686\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{6A11F}.Ⴒ\x{2D7F}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD968\\uDD1F\.Ⴒ\\u2D7F\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{6A11F}.Ⴒ\x{2D7F}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD968\\uDD1F\.Ⴒ\\u2D7F\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{6A11F}.ⴒ\x{2D7F}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD968\\uDD1F\.ⴒ\\u2D7F\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{6A11F}.ⴒ\x{2D7F}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD968\\uDD1F\.ⴒ\\u2D7F\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0CCD}\x{200D}.８︒", %p)},	undef,	"to_unicode\(\'繱\\u0CCD\\u200D\.８︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0CCD}\x{200D}.8。", %p)},	"繱\x{0CCD}\x{200D}.8.",	"to_unicode\(\'繱\\u0CCD\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0CCD}\x{200D}.8。", %p)},	"繱\x{0CCD}\x{200D}.8.",	"to_unicode\(\'繱\\u0CCD\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--8tc7929c.8.", %p)},	"繱\x{0CCD}.8.",	"to_unicode\(\'xn\-\-8tc7929c\.8\.\'\)\ \[data\/IdnaTest\.txt\:521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0CCD}.8.", %p)},	"繱\x{0CCD}.8.",	"to_unicode\(\'繱\\u0CCD\.8\.\'\)\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--8tc079gf52e.8.", %p)},	"繱\x{0CCD}\x{200D}.8.",	"to_unicode\(\'xn\-\-8tc079gf52e\.8\.\'\)\ \[data\/IdnaTest\.txt\:523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0CCD}\x{200D}.8.", %p)},	"繱\x{0CCD}\x{200D}.8.",	"to_unicode\(\'繱\\u0CCD\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0CCD}\x{200D}.8.", %p)},	"繱\x{0CCD}\x{200D}.8.",	"to_unicode\(\'繱\\u0CCD\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:525\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0325}．\x{116B0}", %p)},	undef,	"to_unicode\(\'\\u0325．\\uD805\\uDEB0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0325}.\x{116B0}", %p)},	undef,	"to_unicode\(\'\\u0325\.\\uD805\\uDEB0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:527\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ß\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:528\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ß\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:529\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("SS\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:530\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("SS\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ss\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:532\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ss\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Ss\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:534\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Ss\x{1033}。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\\u1033\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:535\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("xn--ss-t3j.", %p)},	"ss\x{1033}.",	"to_unicode\(\'xn\-\-ss\-t3j\.\'\)\ \[data\/IdnaTest\.txt\:536\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ss\x{1033}.", %p)},	"ss\x{1033}.",	"to_unicode\(\'ss\\u1033\.\'\)\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("SS\x{1033}.", %p)},	"ss\x{1033}.",	"to_unicode\(\'SS\\u1033\.\'\)\ \[data\/IdnaTest\.txt\:538\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Ss\x{1033}.", %p)},	"ss\x{1033}.",	"to_unicode\(\'Ss\\u1033\.\'\)\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0A67}\x{200C}⒈．\x{E0C38}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE67\\u200C⒈．\\uDB43\\uDC38\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A67}\x{200C}⒈．\x{E0C38}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE67\\u200C⒈．\\uDB43\\uDC38\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A67}\x{200C}1..\x{E0C38}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE67\\u200C1\.\.\\uDB43\\uDC38\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A67}\x{200C}1..\x{E0C38}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE67\\u200C1\.\.\\uDB43\\uDC38\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91269}\x{E005B}\x{0D01}ß。\x{CA3CB}", %p)},	undef,	"to_unicode\(\'\\uDA04\\uDE69\\uDB40\\uDC5B\\u0D01ß\。\\uDAE8\\uDFCB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91269}\x{E005B}\x{0D01}SS。\x{CA3CB}", %p)},	undef,	"to_unicode\(\'\\uDA04\\uDE69\\uDB40\\uDC5B\\u0D01SS\。\\uDAE8\\uDFCB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91269}\x{E005B}\x{0D01}ss。\x{CA3CB}", %p)},	undef,	"to_unicode\(\'\\uDA04\\uDE69\\uDB40\\uDC5B\\u0D01ss\。\\uDAE8\\uDFCB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91269}\x{E005B}\x{0D01}Ss。\x{CA3CB}", %p)},	undef,	"to_unicode\(\'\\uDA04\\uDE69\\uDB40\\uDC5B\\u0D01Ss\。\\uDAE8\\uDFCB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B84}\x{200C}\x{0620}。\x{AA43A}䉜\x{200D}\x{CDC5F}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF84\\u200C\\u0620\。\\uDA69\\uDC3A䉜\\u200D\\uDAF7\\uDC5F\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B84}\x{200C}\x{0620}。\x{AA43A}䉜\x{200D}\x{CDC5F}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF84\\u200C\\u0620\。\\uDA69\\uDC3A䉜\\u200D\\uDAF7\\uDC5F\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼ς\x{0692}⒈.≮\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼ς\\u0692⒈\.\≮\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼ς\x{0692}⒈.<\x{0338}\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼ς\\u0692⒈\.\<\\u0338\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼ς\x{0692}1..≮\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼ς\\u06921\.\.\≮\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼ς\x{0692}1..<\x{0338}\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼ς\\u06921\.\.\<\\u0338\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼Σ\x{0692}1..<\x{0338}\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼Σ\\u06921\.\.\<\\u0338\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼Σ\x{0692}1..≮\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼Σ\\u06921\.\.\≮\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼σ\x{0692}1..≮\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼σ\\u06921\.\.\≮\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼σ\x{0692}1..<\x{0338}\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼σ\\u06921\.\.\<\\u0338\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼Σ\x{0692}⒈.<\x{0338}\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼Σ\\u0692⒈\.\<\\u0338\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼Σ\x{0692}⒈.≮\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼Σ\\u0692⒈\.\≮\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼σ\x{0692}⒈.≮\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼σ\\u0692⒈\.\≮\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𦮼σ\x{0692}⒈.<\x{0338}\x{1163F}\x{200D}\x{06CB}", %p)},	undef,	"to_unicode\(\'𦮼σ\\u0692⒈\.\<\\u0338\\uD805\\uDE3F\\u200D\\u06CB\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{094D}Ⴀ\x{E014C}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u094DႠ\\uDB40\\uDD4C\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{094D}Ⴀ\x{E014C}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u094DႠ\\uDB40\\uDD4C\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{094D}ⴀ\x{E014C}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u094Dⴀ\\uDB40\\uDD4C\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{094D}ⴀ\x{E014C}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u094Dⴀ\\uDB40\\uDD4C\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🞀\x{200D}．\x{0E3A}\x{1CDA}\x{073B}\x{E016E}", %p)},	undef,	"to_unicode\(\'🞀\\u200D．\\u0E3A\\u1CDA\\u073B\\uDB40\\uDD6E\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🞀\x{200D}．\x{0E3A}\x{1CDA}\x{073B}\x{E016E}", %p)},	undef,	"to_unicode\(\'🞀\\u200D．\\u0E3A\\u1CDA\\u073B\\uDB40\\uDD6E\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:567\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🞀\x{200D}．\x{0E3A}\x{073B}\x{1CDA}\x{E016E}", %p)},	undef,	"to_unicode\(\'🞀\\u200D．\\u0E3A\\u073B\\u1CDA\\uDB40\\uDD6E\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:568\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🞀\x{200D}．\x{0E3A}\x{073B}\x{1CDA}\x{E016E}", %p)},	undef,	"to_unicode\(\'🞀\\u200D．\\u0E3A\\u073B\\u1CDA\\uDB40\\uDD6E\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🞀\x{200D}.\x{0E3A}\x{073B}\x{1CDA}\x{E016E}", %p)},	undef,	"to_unicode\(\'🞀\\u200D\.\\u0E3A\\u073B\\u1CDA\\uDB40\\uDD6E\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:570\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🞀\x{200D}.\x{0E3A}\x{073B}\x{1CDA}\x{E016E}", %p)},	undef,	"to_unicode\(\'🞀\\u200D\.\\u0E3A\\u073B\\u1CDA\\uDB40\\uDD6E\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:571\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮\x{10A04}\x{10C06}.≯\x{DD67D}ᢕ", %p)},	undef,	"to_unicode\(\'\≮\\uD802\\uDE04\\uD803\\uDC06\.\≯\\uDB35\\uDE7Dᢕ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{10A04}\x{10C06}.>\x{0338}\x{DD67D}ᢕ", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uD802\\uDE04\\uD803\\uDC06\.\>\\u0338\\uDB35\\uDE7Dᢕ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:573\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DE3}\x{10B80}\x{0695}\x{E0175}｡\x{0ACD}ᡵ", %p)},	undef,	"to_unicode\(\'\\u1DE3\\uD802\\uDF80\\u0695\\uDB40\\uDD75｡\\u0ACDᡵ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DE3}\x{10B80}\x{0695}\x{E0175}。\x{0ACD}ᡵ", %p)},	undef,	"to_unicode\(\'\\u1DE3\\uD802\\uDF80\\u0695\\uDB40\\uDD75\。\\u0ACDᡵ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E01C5}。\x{D07E7}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDC5\。\\uDB01\\uDFE7\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1134D}\x{1DE1}．\x{1160}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDF4D\\u1DE1．\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1134D}\x{1DE1}.\x{1160}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDF4D\\u1DE1\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0769}\x{200D}。\x{EF092}\x{0767}", %p)},	undef,	"to_unicode\(\'\-\\u0769\\u200D\。\\uDB7C\\uDC92\\u0767\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0769}\x{200D}。\x{EF092}\x{0767}", %p)},	undef,	"to_unicode\(\'\-\\u0769\\u200D\。\\uDB7C\\uDC92\\u0767\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0725}¡≯\x{AB398}。\x{E005F}⾇滸\x{10E6D}", %p)},	undef,	"to_unicode\(\'\\u0725\¡\≯\\uDA6C\\uDF98\。\\uDB40\\uDC5F⾇滸\\uD803\\uDE6D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0725}¡>\x{0338}\x{AB398}。\x{E005F}⾇滸\x{10E6D}", %p)},	undef,	"to_unicode\(\'\\u0725\¡\>\\u0338\\uDA6C\\uDF98\。\\uDB40\\uDC5F⾇滸\\uD803\\uDE6D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0725}¡≯\x{AB398}。\x{E005F}舛滸\x{10E6D}", %p)},	undef,	"to_unicode\(\'\\u0725\¡\≯\\uDA6C\\uDF98\。\\uDB40\\uDC5F舛滸\\uD803\\uDE6D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0725}¡>\x{0338}\x{AB398}。\x{E005F}舛滸\x{10E6D}", %p)},	undef,	"to_unicode\(\'\\u0725\¡\>\\u0338\\uDA6C\\uDF98\。\\uDB40\\uDC5F舛滸\\uD803\\uDE6D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:584\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("蔏｡\x{2DE6}", %p)},	undef,	"to_unicode\(\'蔏｡\\u2DE6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:585\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("蔏。\x{2DE6}", %p)},	undef,	"to_unicode\(\'蔏\。\\u2DE6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟿\x{071E}。\x{073B}", %p)},	undef,	"to_unicode\(\'𝟿\\u071E\。\\u073B\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9\x{071E}。\x{073B}", %p)},	undef,	"to_unicode\(\'9\\u071E\。\\u073B\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{DC305}-䟖F。ᠶ⒈\x{10E63}", %p)},	undef,	"to_unicode\(\'\\uDB30\\uDF05\-䟖F\。ᠶ⒈\\uD803\\uDE63\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{DC305}-䟖F。ᠶ1.\x{10E63}", %p)},	undef,	"to_unicode\(\'\\uDB30\\uDF05\-䟖F\。ᠶ1\.\\uD803\\uDE63\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{DC305}-䟖f。ᠶ1.\x{10E63}", %p)},	undef,	"to_unicode\(\'\\uDB30\\uDF05\-䟖f\。ᠶ1\.\\uD803\\uDE63\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{DC305}-䟖f。ᠶ⒈\x{10E63}", %p)},	undef,	"to_unicode\(\'\\uDB30\\uDF05\-䟖f\。ᠶ⒈\\uD803\\uDE63\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}｡\x{10E63}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uD803\\uDE63\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:593\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}｡\x{10E63}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uD803\\uDE63\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}。\x{10E63}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uD803\\uDE63\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:595\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}。\x{10E63}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uD803\\uDE63\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{08CC}.≯\x{200C}-\x{06BA}", %p)},	undef,	"to_unicode\(\'\\u08CC\.\≯\\u200C\-\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08CC}.≯\x{200C}-\x{06BA}", %p)},	undef,	"to_unicode\(\'\\u08CC\.\≯\\u200C\-\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08CC}.>\x{0338}\x{200C}-\x{06BA}", %p)},	undef,	"to_unicode\(\'\\u08CC\.\>\\u0338\\u200C\-\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08CC}.>\x{0338}\x{200C}-\x{06BA}", %p)},	undef,	"to_unicode\(\'\\u08CC\.\>\\u0338\\u200C\-\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0352}-。≠\x{10AE8}", %p)},	undef,	"to_unicode\(\'\\u0352\-\。\≠\\uD802\\uDEE8\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0352}-。=\x{0338}\x{10AE8}", %p)},	undef,	"to_unicode\(\'\\u0352\-\。\=\\u0338\\uD802\\uDEE8\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A04D6}\x{1714}。\x{200D}\x{1E95A}", %p)},	undef,	"to_unicode\(\'\\uDA41\\uDCD6\\u1714\。\\u200D\\uD83A\\uDD5A\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A04D6}\x{1714}。\x{200D}\x{1E95A}", %p)},	undef,	"to_unicode\(\'\\uDA41\\uDCD6\\u1714\。\\u200D\\uD83A\\uDD5A\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01E1}\x{A8C4}2｡㧉\x{8003F}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDE1\\uA8C42｡㧉\\uD9C0\\uDC3F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01E1}\x{A8C4}2。㧉\x{8003F}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDE1\\uA8C42\。㧉\\uD9C0\\uDC3F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{9227E}\x{10E7E}\x{10C16}。≯6", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA08\\uDE7E\\uD803\\uDE7E\\uD803\\uDC16\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{9227E}\x{10E7E}\x{10C16}。≯6", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA08\\uDE7E\\uD803\\uDE7E\\uD803\\uDC16\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{9227E}\x{10E7E}\x{10C16}。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA08\\uDE7E\\uD803\\uDE7E\\uD803\\uDC16\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{9227E}\x{10E7E}\x{10C16}。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA08\\uDE7E\\uD803\\uDE7E\\uD803\\uDC16\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}．\x{10E79}\x{CBB12}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA9C0．\\uD803\\uDE79\\uDAEE\\uDF12\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}．\x{10E79}\x{CBB12}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA9C0．\\uD803\\uDE79\\uDAEE\\uDF12\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}.\x{10E79}\x{CBB12}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA9C0\.\\uD803\\uDE79\\uDAEE\\uDF12\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}.\x{10E79}\x{CBB12}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA9C0\.\\uD803\\uDE79\\uDAEE\\uDF12\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䷃ς\x{D2676}｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'䷃ς\\uDB09\\uDE76｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䷃ς\x{D2676}。\x{1160}", %p)},	undef,	"to_unicode\(\'䷃ς\\uDB09\\uDE76\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䷃Σ\x{D2676}。\x{1160}", %p)},	undef,	"to_unicode\(\'䷃Σ\\uDB09\\uDE76\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䷃σ\x{D2676}。\x{1160}", %p)},	undef,	"to_unicode\(\'䷃σ\\uDB09\\uDE76\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䷃Σ\x{D2676}｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'䷃Σ\\uDB09\\uDE76｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䷃σ\x{D2676}｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'䷃σ\\uDB09\\uDE76｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡆ\x{11080}ᠨ\x{06A1}.\x{10DC1}\x{1163F}Ⴃ", %p)},	undef,	"to_unicode\(\'ꡆ\\uD804\\uDC80ᠨ\\u06A1\.\\uD803\\uDDC1\\uD805\\uDE3FႣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡆ\x{11080}ᠨ\x{06A1}.\x{10DC1}\x{1163F}ⴃ", %p)},	undef,	"to_unicode\(\'ꡆ\\uD804\\uDC80ᠨ\\u06A1\.\\uD803\\uDDC1\\uD805\\uDE3Fⴃ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}\x{11235}-킼.\x{0E3A}\x{0344}\x{06DD}≯", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\\uD804\\uDE35\-킼\.\\u0E3A\\u0344\\u06DD\≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}\x{11235}-킼.\x{0E3A}\x{0308}\x{0301}\x{06DD}≯", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\\uD804\\uDE35\-킼\.\\u0E3A\\u0308\\u0301\\u06DD\≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}\x{11235}-킼.\x{0E3A}\x{0308}\x{0301}\x{06DD}>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\\uD804\\uDE35\-킼\.\\u0E3A\\u0308\\u0301\\u06DD\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。ᠶ\x{0667}\x{C8E3F}\x{11046}", %p)},	undef,	"to_unicode\(\'\-\。ᠶ\\u0667\\uDAE3\\uDE3F\\uD804\\uDC46\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{A461E}\x{E01C5}．\x{0354}\x{CE2E4}\x{0684}𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA51\\uDE1E\\uDB40\\uDDC5．\\u0354\\uDAF8\\uDEE4\\u0684𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{A461E}\x{E01C5}．\x{0354}\x{CE2E4}\x{0684}𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA51\\uDE1E\\uDB40\\uDDC5．\\u0354\\uDAF8\\uDEE4\\u0684𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{A461E}\x{E01C5}.\x{0354}\x{CE2E4}\x{0684}𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA51\\uDE1E\\uDB40\\uDDC5\.\\u0354\\uDAF8\\uDEE4\\u0684𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{A461E}\x{E01C5}.\x{0354}\x{CE2E4}\x{0684}𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA51\\uDE1E\\uDB40\\uDDC5\.\\u0354\\uDAF8\\uDEE4\\u0684𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{EC185}ς\x{BE80F}｡ᢘ", %p)},	undef,	"to_unicode\(\'︒\\uDB70\\uDD85ς\\uDABA\\uDC0F｡ᢘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。\x{EC185}ς\x{BE80F}。ᢘ", %p)},	undef,	"to_unicode\(\'\。\\uDB70\\uDD85ς\\uDABA\\uDC0F\。ᢘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。\x{EC185}Σ\x{BE80F}。ᢘ", %p)},	undef,	"to_unicode\(\'\。\\uDB70\\uDD85Σ\\uDABA\\uDC0F\。ᢘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。\x{EC185}σ\x{BE80F}。ᢘ", %p)},	undef,	"to_unicode\(\'\。\\uDB70\\uDD85σ\\uDABA\\uDC0F\。ᢘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{EC185}Σ\x{BE80F}｡ᢘ", %p)},	undef,	"to_unicode\(\'︒\\uDB70\\uDD85Σ\\uDABA\\uDC0F｡ᢘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{EC185}σ\x{BE80F}｡ᢘ", %p)},	undef,	"to_unicode\(\'︒\\uDB70\\uDD85σ\\uDABA\\uDC0F｡ᢘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EC90}．\x{FB26}\x{B5ECF}≯\x{E01C0}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC90．\\uFB26\\uDA97\\uDECF\≯\\uDB40\\uDDC0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EC90}．\x{FB26}\x{B5ECF}>\x{0338}\x{E01C0}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC90．\\uFB26\\uDA97\\uDECF\>\\u0338\\uDB40\\uDDC0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EC90}.\x{05DD}\x{B5ECF}≯\x{E01C0}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC90\.\\u05DD\\uDA97\\uDECF\≯\\uDB40\\uDDC0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EC90}.\x{05DD}\x{B5ECF}>\x{0338}\x{E01C0}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC90\.\\u05DD\\uDA97\\uDECF\>\\u0338\\uDB40\\uDDC0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CBC}\x{5DAB4}.\x{1EE23}", %p)},	undef,	"to_unicode\(\'\\u0CBC\\uD936\\uDEB4\.\\uD83B\\uDE23\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉\x{E0C96}≠｡Ⴟ\x{E0870}Ⴈ", %p)},	undef,	"to_unicode\(\'⒉\\uDB43\\uDC96\≠｡Ⴟ\\uDB42\\uDC70Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉\x{E0C96}=\x{0338}｡Ⴟ\x{E0870}Ⴈ", %p)},	undef,	"to_unicode\(\'⒉\\uDB43\\uDC96\=\\u0338｡Ⴟ\\uDB42\\uDC70Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.\x{E0C96}≠。Ⴟ\x{E0870}Ⴈ", %p)},	undef,	"to_unicode\(\'2\.\\uDB43\\uDC96\≠\。Ⴟ\\uDB42\\uDC70Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.\x{E0C96}=\x{0338}。Ⴟ\x{E0870}Ⴈ", %p)},	undef,	"to_unicode\(\'2\.\\uDB43\\uDC96\=\\u0338\。Ⴟ\\uDB42\\uDC70Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.\x{E0C96}=\x{0338}。ⴟ\x{E0870}ⴈ", %p)},	undef,	"to_unicode\(\'2\.\\uDB43\\uDC96\=\\u0338\。ⴟ\\uDB42\\uDC70ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.\x{E0C96}≠。ⴟ\x{E0870}ⴈ", %p)},	undef,	"to_unicode\(\'2\.\\uDB43\\uDC96\≠\。ⴟ\\uDB42\\uDC70ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉\x{E0C96}=\x{0338}｡ⴟ\x{E0870}ⴈ", %p)},	undef,	"to_unicode\(\'⒉\\uDB43\\uDC96\=\\u0338｡ⴟ\\uDB42\\uDC70ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉\x{E0C96}≠｡ⴟ\x{E0870}ⴈ", %p)},	undef,	"to_unicode\(\'⒉\\uDB43\\uDC96\≠｡ⴟ\\uDB42\\uDC70ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-◚\x{1920}Ⴥ。-\x{0660}\x{0762}\x{17DD}", %p)},	undef,	"to_unicode\(\'\-\◚\\u1920Ⴥ\。\-\\u0660\\u0762\\u17DD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("-◚\x{1920}ⴥ。-\x{0660}\x{0762}\x{17DD}", %p)},	undef,	"to_unicode\(\'\-\◚\\u1920ⴥ\。\-\\u0660\\u0762\\u17DD\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E010F}。\x{11046}︒\x{0672}ᢓ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD0F\。\\uD804\\uDC46︒\\u0672ᢓ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:652\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{E010F}。\x{11046}。\x{0672}ᢓ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD0F\。\\uD804\\uDC46\。\\u0672ᢓ\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴙᠠ.\x{E017F}\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙᠠ\.\\uDB40\\uDD7F\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴙᠠ.\x{E017F}\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙᠠ\.\\uDB40\\uDD7F\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙᠠ.\x{E017F}\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙᠠ\.\\uDB40\\uDD7F\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:656\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙᠠ.\x{E017F}\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙᠠ\.\\uDB40\\uDD7F\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:657\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--26e158h.", %p)},	"ⴙᠠ.",	"to_unicode\(\'xn\-\-26e158h\.\'\)\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙᠠ.", %p)},	"ⴙᠠ.",	"to_unicode\(\'ⴙᠠ\.\'\)\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴙᠠ.", %p)},	undef,	"to_unicode\(\'Ⴙᠠ\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1037}｡₆０\x{10975}ᡍ", %p)},	undef,	"to_unicode\(\'\\u1037｡₆０\\uD802\\uDD75ᡍ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1037}。60\x{10975}ᡍ", %p)},	undef,	"to_unicode\(\'\\u1037\。60\\uD802\\uDD75ᡍ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:662\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("6\x{07CD}｡-\x{033E}", %p)},	undef,	"to_unicode\(\'6\\u07CD｡\-\\u033E\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:663\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("6\x{07CD}。-\x{033E}", %p)},	undef,	"to_unicode\(\'6\\u07CD\。\-\\u033E\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:664\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}｡\x{AAF6}ς\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662｡\\uAAF6ς\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}｡\x{AAF6}ς\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662｡\\uAAF6ς\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}。\x{AAF6}ς\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662\。\\uAAF6ς\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}。\x{AAF6}ς\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662\。\\uAAF6ς\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}。\x{AAF6}Σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662\。\\uAAF6Σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}。\x{AAF6}Σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662\。\\uAAF6Σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}。\x{AAF6}σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662\。\\uAAF6σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}。\x{AAF6}σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662\。\\uAAF6σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}｡\x{AAF6}Σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662｡\\uAAF6Σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}｡\x{AAF6}Σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662｡\\uAAF6Σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}｡\x{AAF6}σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662｡\\uAAF6σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{FCE21}\x{0662}｡\x{AAF6}σ\x{1EF08}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDBB3\\uDE21\\u0662｡\\uAAF6σ\\uD83B\\uDF08\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{369A2}Ⴓ⒪．\x{0EB1}\x{318DA}\x{10BAB}\x{0665}", %p)},	undef,	"to_unicode\(\'⒈\\uD89A\\uDDA2Ⴓ⒪．\\u0EB1\\uD886\\uDCDA\\uD802\\uDFAB\\u0665\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{369A2}Ⴓ(o).\x{0EB1}\x{318DA}\x{10BAB}\x{0665}", %p)},	undef,	"to_unicode\(\'1\.\\uD89A\\uDDA2Ⴓ\(o\)\.\\u0EB1\\uD886\\uDCDA\\uD802\\uDFAB\\u0665\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{369A2}ⴓ(o).\x{0EB1}\x{318DA}\x{10BAB}\x{0665}", %p)},	undef,	"to_unicode\(\'1\.\\uD89A\\uDDA2ⴓ\(o\)\.\\u0EB1\\uD886\\uDCDA\\uD802\\uDFAB\\u0665\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{369A2}Ⴓ(O).\x{0EB1}\x{318DA}\x{10BAB}\x{0665}", %p)},	undef,	"to_unicode\(\'1\.\\uD89A\\uDDA2Ⴓ\(O\)\.\\u0EB1\\uD886\\uDCDA\\uD802\\uDFAB\\u0665\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{369A2}ⴓ⒪．\x{0EB1}\x{318DA}\x{10BAB}\x{0665}", %p)},	undef,	"to_unicode\(\'⒈\\uD89A\\uDDA2ⴓ⒪．\\u0EB1\\uD886\\uDCDA\\uD802\\uDFAB\\u0665\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B8}.\x{07DC}\x{1EF55}\x{10E70}ᢚ", %p)},	undef,	"to_unicode\(\'\\u06B8\.\\u07DC\\uD83B\\uDF55\\uD803\\uDE70ᢚ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EC95}-｡\x{0B4D}\x{45D3B}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC95\-｡\\u0B4D\\uD8D7\\uDD3B\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EC95}-。\x{0B4D}\x{45D3B}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC95\-\。\\u0B4D\\uD8D7\\uDD3B\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-⮋\x{0840}．\x{E0AA1}\x{10002F}🄉", %p)},	undef,	"to_unicode\(\'\-\⮋\\u0840．\\uDB42\\uDEA1\\uDBC0\\uDC2F🄉\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-⮋\x{0840}.\x{E0AA1}\x{10002F}8,", %p)},	undef,	"to_unicode\(\'\-\⮋\\u0840\.\\uDB42\\uDEA1\\uDBC0\\uDC2F8\,\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("¢🡣\x{C9168}\x{E2E78}.ᠱ𝟝", %p)},	undef,	"to_unicode\(\'\¢🡣\\uDAE4\\uDD68\\uDB4B\\uDE78\.ᠱ𝟝\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("¢🡣\x{C9168}\x{E2E78}.ᠱ5", %p)},	undef,	"to_unicode\(\'\¢🡣\\uDAE4\\uDD68\\uDB4B\\uDE78\.ᠱ5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{066C}．\x{11635}", %p)},	undef,	"to_unicode\(\'\≮\\u066C．\\uD805\\uDE35\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{066C}．\x{11635}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u066C．\\uD805\\uDE35\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{066C}.\x{11635}", %p)},	undef,	"to_unicode\(\'\≮\\u066C\.\\uD805\\uDE35\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{066C}.\x{11635}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u066C\.\\uD805\\uDE35\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:692\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10E6D}ᯛ\x{11046}｡脥", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Dᯛ\\uD804\\uDC46｡脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:693\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10E6D}ᯛ\x{11046}。脥", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Dᯛ\\uD804\\uDC46\。脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{11046}\x{115F}\x{1EFD0}\x{78B63}.-", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC46\\u115F\\uD83B\\uDFD0\\uD9A2\\uDF63\.\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:695\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}｡\x{08E4}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\u08E4\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}｡\x{08E4}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\u08E4\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:697\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}。\x{08E4}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u08E4\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}。\x{08E4}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u08E4\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:699\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07D9}\x{1C2C}．ꡄႮ", %p)},	undef,	"to_unicode\(\'\\u07D9\\u1C2C．ꡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D9}\x{1C2C}.ꡄႮ", %p)},	undef,	"to_unicode\(\'\\u07D9\\u1C2C\.ꡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:701\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{07D9}\x{1C2C}.ꡄⴎ", %p)},	"\x{07D9}\x{1C2C}.ꡄⴎ",	"to_unicode\(\'\\u07D9\\u1C2C\.ꡄⴎ\'\)\ \[data\/IdnaTest\.txt\:702\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("xn--0sb025h.xn--5kj1550b", %p)},	"\x{07D9}\x{1C2C}.ꡄⴎ",	"to_unicode\(\'xn\-\-0sb025h\.xn\-\-5kj1550b\'\)\ \[data\/IdnaTest\.txt\:703\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{07D9}\x{1C2C}．ꡄⴎ", %p)},	"\x{07D9}\x{1C2C}.ꡄⴎ",	"to_unicode\(\'\\u07D9\\u1C2C．ꡄⴎ\'\)\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{08A3}\x{07AA}Ξ．\x{F64C9}㛨\x{E0CC3}", %p)},	undef,	"to_unicode\(\'\\u08A3\\u07AAΞ．\\uDB99\\uDCC9㛨\\uDB43\\uDCC3\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}\x{07AA}Ξ.\x{F64C9}㛨\x{E0CC3}", %p)},	undef,	"to_unicode\(\'\\u08A3\\u07AAΞ\.\\uDB99\\uDCC9㛨\\uDB43\\uDCC3\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}\x{07AA}ξ.\x{F64C9}㛨\x{E0CC3}", %p)},	undef,	"to_unicode\(\'\\u08A3\\u07AAξ\.\\uDB99\\uDCC9㛨\\uDB43\\uDCC3\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}\x{07AA}ξ．\x{F64C9}㛨\x{E0CC3}", %p)},	undef,	"to_unicode\(\'\\u08A3\\u07AAξ．\\uDB99\\uDCC9㛨\\uDB43\\uDCC3\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{072C}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u072C\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{072C}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u072C︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✞.︒🞰\x{200C}\x{10E7D}", %p)},	undef,	"to_unicode\(\'\✞\.︒🞰\\u200C\\uD803\\uDE7D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✞.︒🞰\x{200C}\x{10E7D}", %p)},	undef,	"to_unicode\(\'\✞\.︒🞰\\u200C\\uD803\\uDE7D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:726\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("✞.。🞰\x{200C}\x{10E7D}", %p)},	undef,	"to_unicode\(\'\✞\.\。🞰\\u200C\\uD803\\uDE7D\'\)\ throws\ error\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:727\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("✞.。🞰\x{200C}\x{10E7D}", %p)},	undef,	"to_unicode\(\'\✞\.\。🞰\\u200C\\uD803\\uDE7D\'\)\ throws\ error\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:728\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FDB1}.\x{10E62}Ⴑ\x{429C6}ᢌ", %p)},	undef,	"to_unicode\(\'\\uFDB1\.\\uD803\\uDE62Ⴑ\\uD8CA\\uDDC6ᢌ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0645}\x{0645}\x{064A}.\x{10E62}Ⴑ\x{429C6}ᢌ", %p)},	undef,	"to_unicode\(\'\\u0645\\u0645\\u064A\.\\uD803\\uDE62Ⴑ\\uD8CA\\uDDC6ᢌ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0645}\x{0645}\x{064A}.\x{10E62}ⴑ\x{429C6}ᢌ", %p)},	undef,	"to_unicode\(\'\\u0645\\u0645\\u064A\.\\uD803\\uDE62ⴑ\\uD8CA\\uDDC6ᢌ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDB1}.\x{10E62}ⴑ\x{429C6}ᢌ", %p)},	undef,	"to_unicode\(\'\\uFDB1\.\\uD803\\uDE62ⴑ\\uD8CA\\uDDC6ᢌ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F90}䕝．𝟭Ⴛ", %p)},	undef,	"to_unicode\(\'\\u0F90䕝．𝟭Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F90}䕝.1Ⴛ", %p)},	undef,	"to_unicode\(\'\\u0F90䕝\.1Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:734\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0F90}䕝.1ⴛ", %p)},	undef,	"to_unicode\(\'\\u0F90䕝\.1ⴛ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:735\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0F90}䕝．𝟭ⴛ", %p)},	undef,	"to_unicode\(\'\\u0F90䕝．𝟭ⴛ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:736\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{05B6}齀。릿\x{1EB2F}", %p)},	undef,	"to_unicode\(\'\-\\u05B6齀\。릿\\uD83A\\uDF2F\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{05B6}齀。릿\x{1EB2F}", %p)},	undef,	"to_unicode\(\'\-\\u05B6齀\。릿\\uD83A\\uDF2F\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E018C}\x{07D2}鹝꾗。\x{765BA}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD8C\\u07D2鹝꾗\。\\uD999\\uDDBA\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E018C}\x{07D2}鹝꾗。\x{765BA}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD8C\\u07D2鹝꾗\。\\uD999\\uDDBA\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E018C}\x{07D2}鹝꾗。\x{765BA}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD8C\\u07D2鹝꾗\。\\uD999\\uDDBA\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E018C}\x{07D2}鹝꾗。\x{765BA}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD8C\\u07D2鹝꾗\。\\uD999\\uDDBA\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮．-\x{FD19}--", %p)},	undef,	"to_unicode\(\'\≮．\-\\uFD19\-\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．-\x{FD19}--", %p)},	undef,	"to_unicode\(\'\<\\u0338．\-\\uFD19\-\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.-\x{0634}\x{0649}--", %p)},	undef,	"to_unicode\(\'\≮\.\-\\u0634\\u0649\-\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.-\x{0634}\x{0649}--", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\-\\u0634\\u0649\-\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:746\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}ς𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dς𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}ς𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dς𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:748\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}ς7", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dς7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}ς7", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dς7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:750\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}Σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200DΣ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}Σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200DΣ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dσ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dσ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:754\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}Σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200DΣ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}Σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200DΣ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:756\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dσ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0664}⛁。\x{200D}σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⛁\。\\u200Dσ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:758\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς\x{4CE18}８.\x{1EC07}", %p)},	undef,	"to_unicode\(\'ς\\uD8F3\\uDE18８\.\\uD83B\\uDC07\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{4CE18}8.\x{1EC07}", %p)},	undef,	"to_unicode\(\'ς\\uD8F3\\uDE188\.\\uD83B\\uDC07\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{4CE18}8.\x{1EC07}", %p)},	undef,	"to_unicode\(\'Σ\\uD8F3\\uDE188\.\\uD83B\\uDC07\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{4CE18}8.\x{1EC07}", %p)},	undef,	"to_unicode\(\'σ\\uD8F3\\uDE188\.\\uD83B\\uDC07\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{4CE18}８.\x{1EC07}", %p)},	undef,	"to_unicode\(\'Σ\\uD8F3\\uDE18８\.\\uD83B\\uDC07\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{4CE18}８.\x{1EC07}", %p)},	undef,	"to_unicode\(\'σ\\uD8F3\\uDE18８\.\\uD83B\\uDC07\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0771}🄀ᢊ．-\x{10AD0}\x{A67A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0771🄀ᢊ．\-\\uD802\\uDED0\\uA67A\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0771}🄀ᢊ．-\x{10AD0}\x{A67A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0771🄀ᢊ．\-\\uD802\\uDED0\\uA67A\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:766\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{0771}0.ᢊ.-\x{10AD0}\x{A67A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u07710\.ᢊ\.\-\\uD802\\uDED0\\uA67A\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{0771}0.ᢊ.-\x{10AD0}\x{A67A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u07710\.ᢊ\.\-\\uD802\\uDED0\\uA67A\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{EF487}。\x{1E894}넯\x{6BBF0}", %p)},	undef,	"to_unicode\(\'\\uDB7D\\uDC87\。\\uD83A\\uDC94넯\\uD96E\\uDFF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EF487}。\x{1E894}넯\x{6BBF0}", %p)},	undef,	"to_unicode\(\'\\uDB7D\\uDC87\。\\uD83A\\uDC94넯\\uD96E\\uDFF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡒႸ。\x{0600}Ⴈ\x{11368}", %p)},	undef,	"to_unicode\(\'ꡒႸ\。\\u0600Ⴈ\\uD804\\uDF68\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡒⴘ。\x{0600}ⴈ\x{11368}", %p)},	undef,	"to_unicode\(\'ꡒⴘ\。\\u0600ⴈ\\uD804\\uDF68\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚🐩\x{077F}。牣\x{10E64}Ⴜᣥ", %p)},	undef,	"to_unicode\(\'⒚🐩\\u077F\。牣\\uD803\\uDE64Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.🐩\x{077F}。牣\x{10E64}Ⴜᣥ", %p)},	undef,	"to_unicode\(\'19\.🐩\\u077F\。牣\\uD803\\uDE64Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:774\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("19.🐩\x{077F}。牣\x{10E64}ⴜᣥ", %p)},	undef,	"to_unicode\(\'19\.🐩\\u077F\。牣\\uD803\\uDE64ⴜᣥ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒚🐩\x{077F}。牣\x{10E64}ⴜᣥ", %p)},	undef,	"to_unicode\(\'⒚🐩\\u077F\。牣\\uD803\\uDE64ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:776\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱\x{080F}⒈.Ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱\\u080F⒈\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱\x{080F}1..Ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱\\u080F1\.\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:778\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𐋱\x{080F}1..ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱\\u080F1\.\.ⴓ\'\)\ throws\ error\ V3\ B1\ A4_2\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-𐋱\x{080F}⒈.ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱\\u080F⒈\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.\x{C9AB3}-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.\\uDAE6\\uDEB3\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.\x{C9AB3}-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.\\uDAE6\\uDEB3\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.\x{C9AB3}-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.\\uDAE6\\uDEB3\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.\x{C9AB3}-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.\\uDAE6\\uDEB3\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("뉓泓\x{70643}.\x{1163F}\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓\\uD981\\uDE43\.\\uD805\\uDE3F\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("뉓泓\x{70643}.\x{1163F}\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓\\uD981\\uDE43\.\\uD805\\uDE3F\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss。\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs\。\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss｡\x{0730}\x{2B75}\x{DB4B0}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs｡\\u0730\\u2B75\\uDB2D\\uDCB0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}．\x{11133}-≮≠", %p)},	undef,	"to_unicode\(\'\\u1734．\\uD804\\uDD33\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}．\x{11133}-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u1734．\\uD804\\uDD33\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}.\x{11133}-≮≠", %p)},	undef,	"to_unicode\(\'\\u1734\.\\uD804\\uDD33\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}.\x{11133}-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u1734\.\\uD804\\uDD33\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}Ⴑ\x{115F}．\x{1B44}Ⅎ", %p)},	undef,	"to_unicode\(\'\\uA953Ⴑ\\u115F．\\u1B44Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}Ⴑ\x{115F}.\x{1B44}Ⅎ", %p)},	undef,	"to_unicode\(\'\\uA953Ⴑ\\u115F\.\\u1B44Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}ⴑ\x{115F}.\x{1B44}ⅎ", %p)},	undef,	"to_unicode\(\'\\uA953ⴑ\\u115F\.\\u1B44ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}Ⴑ\x{115F}.\x{1B44}ⅎ", %p)},	undef,	"to_unicode\(\'\\uA953Ⴑ\\u115F\.\\u1B44ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}ⴑ\x{115F}．\x{1B44}ⅎ", %p)},	undef,	"to_unicode\(\'\\uA953ⴑ\\u115F．\\u1B44ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}Ⴑ\x{115F}．\x{1B44}ⅎ", %p)},	undef,	"to_unicode\(\'\\uA953Ⴑ\\u115F．\\u1B44ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{884B3}。Ⴃ\x{10ADD}\x{0601}똯", %p)},	undef,	"to_unicode\(\'\\uD9E1\\uDCB3\。Ⴃ\\uD802\\uDEDD\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{884B3}。Ⴃ\x{10ADD}\x{0601}똯", %p)},	undef,	"to_unicode\(\'\\uD9E1\\uDCB3\。Ⴃ\\uD802\\uDEDD\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{884B3}。ⴃ\x{10ADD}\x{0601}똯", %p)},	undef,	"to_unicode\(\'\\uD9E1\\uDCB3\。ⴃ\\uD802\\uDEDD\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{884B3}。ⴃ\x{10ADD}\x{0601}똯", %p)},	undef,	"to_unicode\(\'\\uD9E1\\uDCB3\。ⴃ\\uD802\\uDEDD\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ｡⳻\x{E0FA9}\x{116B3}\x{3164}", %p)},	undef,	"to_unicode\(\'ᡒ｡⳻\\uDB43\\uDFA9\\uD805\\uDEB3\\u3164\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ。⳻\x{E0FA9}\x{116B3}\x{1160}", %p)},	undef,	"to_unicode\(\'ᡒ\。⳻\\uDB43\\uDFA9\\uD805\\uDEB3\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10A49}⾇．\x{075D}-𐋰", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE49⾇．\\u075D\-𐋰\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10A49}舛.\x{075D}-𐋰", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE49舛\.\\u075D\-𐋰\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕\x{C1AEB}≮．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uDAC6\\uDEEB\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕\x{C1AEB}<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uDAC6\\uDEEB\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕\x{C1AEB}≮.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uDAC6\\uDEEB\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕\x{C1AEB}<\x{0338}.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uDAC6\\uDEEB\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕\x{C1AEB}<\x{0338}.。", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uDAC6\\uDEEB\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕\x{C1AEB}≮.。", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uDAC6\\uDEEB\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕\x{C1AEB}<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uDAC6\\uDEEB\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕\x{C1AEB}≮．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uDAC6\\uDEEB\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E05A2}｡\x{071D}鳳\x{0770}\x{2DFB}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDDA2｡\\u071D鳳\\u0770\\u2DFB\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E05A2}。\x{071D}鳳\x{0770}\x{2DFB}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDDA2\。\\u071D鳳\\u0770\\u2DFB\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{10E6E}。ß", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6E\。ß\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:831\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{10E6E}。ß", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6E\。ß\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{10E6E}。SS", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6E\。SS\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:833\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{10E6E}。SS", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6E\。SS\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A70}\x{55618}\x{E0067}ꡞ.\x{D4138}-\x{1A7A}", %p)},	undef,	"to_unicode\(\'\\u0A70\\uD915\\uDE18\\uDB40\\uDC67ꡞ\.\\uDB10\\uDD38\-\\u1A7A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς.ß\x{F6A5C}\x{0668}\x{1714}", %p)},	undef,	"to_unicode\(\'ς\.ß\\uDB9A\\uDE5C\\u0668\\u1714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.SS\x{F6A5C}\x{0668}\x{1714}", %p)},	undef,	"to_unicode\(\'Σ\.SS\\uDB9A\\uDE5C\\u0668\\u1714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.ss\x{F6A5C}\x{0668}\x{1714}", %p)},	undef,	"to_unicode\(\'σ\.ss\\uDB9A\\uDE5C\\u0668\\u1714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.ss\x{F6A5C}\x{0668}\x{1714}", %p)},	undef,	"to_unicode\(\'Σ\.ss\\uDB9A\\uDE5C\\u0668\\u1714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.ß\x{F6A5C}\x{0668}\x{1714}", %p)},	undef,	"to_unicode\(\'Σ\.ß\\uDB9A\\uDE5C\\u0668\\u1714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.ß\x{F6A5C}\x{0668}\x{1714}", %p)},	undef,	"to_unicode\(\'σ\.ß\\uDB9A\\uDE5C\\u0668\\u1714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:857\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0846}\x{1B6C}｡\x{10E6B}\x{115B5}", %p)},	undef,	"to_unicode\(\'\\u0846\\u1B6C｡\\uD803\\uDE6B\\uD805\\uDDB5\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:858\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0846}\x{1B6C}。\x{10E6B}\x{115B5}", %p)},	undef,	"to_unicode\(\'\\u0846\\u1B6C\。\\uD803\\uDE6B\\uD805\\uDDB5\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:859\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꗆ\x{200C}\x{1EC15}｡\x{E0EDD}\x{35CB3}-\x{1EA47}", %p)},	undef,	"to_unicode\(\'ꗆ\\u200C\\uD83B\\uDC15｡\\uDB43\\uDEDD\\uD897\\uDCB3\-\\uD83A\\uDE47\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꗆ\x{200C}\x{1EC15}｡\x{E0EDD}\x{35CB3}-\x{1EA47}", %p)},	undef,	"to_unicode\(\'ꗆ\\u200C\\uD83B\\uDC15｡\\uDB43\\uDEDD\\uD897\\uDCB3\-\\uD83A\\uDE47\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꗆ\x{200C}\x{1EC15}。\x{E0EDD}\x{35CB3}-\x{1EA47}", %p)},	undef,	"to_unicode\(\'ꗆ\\u200C\\uD83B\\uDC15\。\\uDB43\\uDEDD\\uD897\\uDCB3\-\\uD83A\\uDE47\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꗆ\x{200C}\x{1EC15}。\x{E0EDD}\x{35CB3}-\x{1EA47}", %p)},	undef,	"to_unicode\(\'ꗆ\\u200C\\uD83B\\uDC15\。\\uDB43\\uDEDD\\uD897\\uDCB3\-\\uD83A\\uDE47\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}\x{DB573}\x{200C}。\x{1B6B}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDB2D\\uDD73\\u200C\。\\u1B6B\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{E01D9}⒈ß", %p)},	undef,	"to_unicode\(\'🄄．\\uDB40\\uDDD9⒈ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3,.\x{E01D9}1.ß", %p)},	undef,	"to_unicode\(\'3\,\.\\uDB40\\uDDD91\.ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3,.\x{E01D9}1.SS", %p)},	undef,	"to_unicode\(\'3\,\.\\uDB40\\uDDD91\.SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{E01D9}⒈SS", %p)},	undef,	"to_unicode\(\'🄄．\\uDB40\\uDDD9⒈SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{E01D9}⒈ss", %p)},	undef,	"to_unicode\(\'🄄．\\uDB40\\uDDD9⒈ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{E01D9}⒈Ss", %p)},	undef,	"to_unicode\(\'🄄．\\uDB40\\uDDD9⒈Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C707}\x{110B9}｡\x{1EA00}\x{4D170}\x{0FA6}", %p)},	undef,	"to_unicode\(\'\\uD831\\uDF07\\uD804\\uDCB9｡\\uD83A\\uDE00\\uD8F4\\uDD70\\u0FA6\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C707}\x{110B9}。\x{1EA00}\x{4D170}\x{0FA6}", %p)},	undef,	"to_unicode\(\'\\uD831\\uDF07\\uD804\\uDCB9\。\\uD83A\\uDE00\\uD8F4\\uDD70\\u0FA6\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0743}\x{094D}\x{0CCD}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0743\\u094D\\u0CCD．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0743}\x{094D}\x{0CCD}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0743\\u094D\\u0CCD．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{0CCD}\x{0743}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u094D\\u0CCD\\u0743\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ𐋨娤.\x{200D}\x{A9B6}\x{0601}\x{05A2}", %p)},	undef,	"to_unicode\(\'Ⴁ𐋨娤\.\\u200D\\uA9B6\\u0601\\u05A2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ𐋨娤.\x{200D}\x{A9B6}\x{0601}\x{05A2}", %p)},	undef,	"to_unicode\(\'Ⴁ𐋨娤\.\\u200D\\uA9B6\\u0601\\u05A2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ𐋨娤.\x{200D}\x{A9B6}\x{0601}\x{05A2}", %p)},	undef,	"to_unicode\(\'ⴁ𐋨娤\.\\u200D\\uA9B6\\u0601\\u05A2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ𐋨娤.\x{200D}\x{A9B6}\x{0601}\x{05A2}", %p)},	undef,	"to_unicode\(\'ⴁ𐋨娤\.\\u200D\\uA9B6\\u0601\\u05A2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ\x{10E7E}\x{2DFC}。⒈\x{105F}ß", %p)},	undef,	"to_unicode\(\'🄀Ⴄ\\uD803\\uDE7E\\u2DFC\。⒈\\u105Fß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.Ⴄ\x{10E7E}\x{2DFC}。1.\x{105F}ß", %p)},	undef,	"to_unicode\(\'0\.Ⴄ\\uD803\\uDE7E\\u2DFC\。1\.\\u105Fß\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:895\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0.ⴄ\x{10E7E}\x{2DFC}。1.\x{105F}ß", %p)},	undef,	"to_unicode\(\'0\.ⴄ\\uD803\\uDE7E\\u2DFC\。1\.\\u105Fß\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:896\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("0.Ⴄ\x{10E7E}\x{2DFC}。1.\x{105F}SS", %p)},	undef,	"to_unicode\(\'0\.Ⴄ\\uD803\\uDE7E\\u2DFC\。1\.\\u105FSS\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:897\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0.ⴄ\x{10E7E}\x{2DFC}。1.\x{105F}ss", %p)},	undef,	"to_unicode\(\'0\.ⴄ\\uD803\\uDE7E\\u2DFC\。1\.\\u105Fss\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:898\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("0.Ⴄ\x{10E7E}\x{2DFC}。1.\x{105F}Ss", %p)},	undef,	"to_unicode\(\'0\.Ⴄ\\uD803\\uDE7E\\u2DFC\。1\.\\u105FSs\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀ⴄ\x{10E7E}\x{2DFC}。⒈\x{105F}ß", %p)},	undef,	"to_unicode\(\'🄀ⴄ\\uD803\\uDE7E\\u2DFC\。⒈\\u105Fß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ\x{10E7E}\x{2DFC}。⒈\x{105F}SS", %p)},	undef,	"to_unicode\(\'🄀Ⴄ\\uD803\\uDE7E\\u2DFC\。⒈\\u105FSS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀ⴄ\x{10E7E}\x{2DFC}。⒈\x{105F}ss", %p)},	undef,	"to_unicode\(\'🄀ⴄ\\uD803\\uDE7E\\u2DFC\。⒈\\u105Fss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ\x{10E7E}\x{2DFC}。⒈\x{105F}Ss", %p)},	undef,	"to_unicode\(\'🄀Ⴄ\\uD803\\uDE7E\\u2DFC\。⒈\\u105FSs\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-\x{10E78}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200C\-\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-\x{10E78}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200C\-\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-\x{10E78}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-\x{10E78}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}۱｡\x{E0A60}\x{109FE}\x{0663}", %p)},	undef,	"to_unicode\(\'\\u0665۱｡\\uDB42\\uDE60\\uD802\\uDDFE\\u0663\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}۱。\x{E0A60}\x{109FE}\x{0663}", %p)},	undef,	"to_unicode\(\'\\u0665۱\。\\uDB42\\uDE60\\uD802\\uDDFE\\u0663\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}⒖。\x{C1B59}\x{3FA1F}\x{0CCD}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B⒖\。\\uDAC6\\uDF59\\uD8BE\\uDE1F\\u0CCD\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}⒖。\x{C1B59}\x{3FA1F}\x{0CCD}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B⒖\。\\uDAC6\\uDF59\\uD8BE\\uDE1F\\u0CCD\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}15.。\x{C1B59}\x{3FA1F}\x{0CCD}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B15\.\。\\uDAC6\\uDF59\\uD8BE\\uDE1F\\u0CCD\'\)\ throws\ error\ P1\ V6\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}15.。\x{C1B59}\x{3FA1F}\x{0CCD}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B15\.\。\\uDAC6\\uDF59\\uD8BE\\uDE1F\\u0CCD\'\)\ throws\ error\ P1\ V6\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E3A}.-逋\x{B7CFE}\x{76AFA}", %p)},	undef,	"to_unicode\(\'\\u0E3A\.\-逋\\uDA9F\\uDCFE\\uD99A\\uDEFA\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAE}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAE\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}Ⴃ｡\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620Ⴃ｡\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}Ⴃ｡\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620Ⴃ｡\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}Ⴃ。\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620Ⴃ\。\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}Ⴃ。\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620Ⴃ\。\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}ⴃ。\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620ⴃ\。\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}ⴃ。\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620ⴃ\。\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}ⴃ｡\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620ⴃ｡\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}ⴃ｡\x{597A5}\x{11635}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0620ⴃ｡\\uD925\\uDFA5\\uD805\\uDE35\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}．ς\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E．ς\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}．ς\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E．ς\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}.ς\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E\.ς\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}.ς\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E\.ς\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}.Σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E\.Σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}.Σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E\.Σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}.σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E\.σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}.σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E\.σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}．Σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E．Σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}．Σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E．Σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}．σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E．σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠳ\x{E0A9E}．σ\x{075C}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠳ\\uDB42\\uDE9E．σ\\u075C\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B5}。\x{10FCD}ꡪ⩒", %p)},	undef,	"to_unicode\(\'\\u17B5\。\\uD803\\uDFCDꡪ\⩒\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{9BA0C}暑．⾑\x{0662}", %p)},	undef,	"to_unicode\(\'\\uDA2E\\uDE0C暑．⾑\\u0662\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{9BA0C}暑.襾\x{0662}", %p)},	undef,	"to_unicode\(\'\\uDA2E\\uDE0C暑\.襾\\u0662\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}≯ᠬ。\x{1EF5B}\x{06D7}", %p)},	undef,	"to_unicode\(\'\\uA8C4\≯ᠬ\。\\uD83B\\uDF5B\\u06D7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}>\x{0338}ᠬ。\x{1EF5B}\x{06D7}", %p)},	undef,	"to_unicode\(\'\\uA8C4\>\\u0338ᠬ\。\\uD83B\\uDF5B\\u06D7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EF3B}\x{46F29}\x{112EA}\x{0E3A}.\x{5967C}Ⴗ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF3B\\uD8DB\\uDF29\\uD804\\uDEEA\\u0E3A\.\\uD925\\uDE7CႷ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EF3B}\x{46F29}\x{112EA}\x{0E3A}.\x{5967C}ⴗ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF3B\\uD8DB\\uDF29\\uD804\\uDEEA\\u0E3A\.\\uD925\\uDE7Cⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DA}｡\x{0F84}\x{B384D}\x{79B7D}", %p)},	undef,	"to_unicode\(\'\\u20DA｡\\u0F84\\uDA8E\\uDC4D\\uD9A6\\uDF7D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DA}。\x{0F84}\x{B384D}\x{79B7D}", %p)},	undef,	"to_unicode\(\'\\u20DA\。\\u0F84\\uDA8E\\uDC4D\\uD9A6\\uDF7D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0346}\x{200C}．\x{087F}\x{200C}ᡶ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDF46\\u200C．\\u087F\\u200Cᡶ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0346}\x{200C}．\x{087F}\x{200C}ᡶ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDF46\\u200C．\\u087F\\u200Cᡶ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0346}\x{200C}.\x{087F}\x{200C}ᡶ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDF46\\u200C\.\\u087F\\u200Cᡶ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0346}\x{200C}.\x{087F}\x{200C}ᡶ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDF46\\u200C\.\\u087F\\u200Cᡶ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0755}\x{ACFE1}ß.ጧ", %p)},	undef,	"to_unicode\(\'\\u0755\\uDA73\\uDFE1ß\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0755}\x{ACFE1}SS.ጧ", %p)},	undef,	"to_unicode\(\'\\u0755\\uDA73\\uDFE1SS\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0755}\x{ACFE1}ss.ጧ", %p)},	undef,	"to_unicode\(\'\\u0755\\uDA73\\uDFE1ss\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0755}\x{ACFE1}Ss.ጧ", %p)},	undef,	"to_unicode\(\'\\u0755\\uDA73\\uDFE1Ss\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑊\x{200C}.\x{E61D2}\x{200C}", %p)},	undef,	"to_unicode\(\'\⑊\\u200C\.\\uDB58\\uDDD2\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑊\x{200C}.\x{E61D2}\x{200C}", %p)},	undef,	"to_unicode\(\'\⑊\\u200C\.\\uDB58\\uDDD2\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CB}\x{E9D98}\x{0663}。Ⴜ", %p)},	undef,	"to_unicode\(\'\\u07CB\\uDB67\\uDD98\\u0663\。Ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CB}\x{E9D98}\x{0663}。ⴜ", %p)},	undef,	"to_unicode\(\'\\u07CB\\uDB67\\uDD98\\u0663\。ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{20EE}｡\x{89DAC}\x{07E8}", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u20EE｡\\uD9E7\\uDDAC\\u07E8\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{20EE}｡\x{89DAC}\x{07E8}", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u20EE｡\\uD9E7\\uDDAC\\u07E8\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{20EE}。\x{89DAC}\x{07E8}", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u20EE\。\\uD9E7\\uDDAC\\u07E8\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{20EE}。\x{89DAC}\x{07E8}", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u20EE\。\\uD9E7\\uDDAC\\u07E8\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。デß\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'Ⴒ\。デß\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}ß\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099ß\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:973\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ß\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'ⴒ\。テ\\u3099ß\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:974\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴒ。デß\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'ⴒ\。デß\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:975\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デSS\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'Ⴒ\。デSS\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}SS\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099SS\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:977\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ss\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'ⴒ\。テ\\u3099ss\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:978\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴒ。デss\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'ⴒ\。デss\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:979\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デSs\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'Ⴒ\。デSs\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}Ss\x{06A8}\x{1163F}", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099Ss\\u06A8\\uD805\\uDE3F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:981\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0F84}\x{0CCD}．７-\x{0754}", %p)},	undef,	"to_unicode\(\'\\u0F84\\u0CCD．７\-\\u0754\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0F84}\x{0CCD}.7-\x{0754}", %p)},	undef,	"to_unicode\(\'\\u0F84\\u0CCD\.7\-\\u0754\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:983\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{1B44}\x{E0C54}.\x{0ACD}\x{45872}\x{07EF}\x{10BAD}", %p)},	undef,	"to_unicode\(\'\≯\\u1B44\\uDB43\\uDC54\.\\u0ACD\\uD8D6\\uDC72\\u07EF\\uD802\\uDFAD\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1B44}\x{E0C54}.\x{0ACD}\x{45872}\x{07EF}\x{10BAD}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u1B44\\uDB43\\uDC54\.\\u0ACD\\uD8D6\\uDC72\\u07EF\\uD802\\uDFAD\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4E}\x{83B8F}Ⴗ쏔。\x{FBC6}", %p)},	undef,	"to_unicode\(\'\\u0E4E\\uD9CE\\uDF8FႷ쏔\。\\uFBC6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4E}\x{83B8F}Ⴗ쏔。\x{FBC6}", %p)},	undef,	"to_unicode\(\'\\u0E4E\\uD9CE\\uDF8FႷ쏔\。\\uFBC6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4E}\x{83B8F}ⴗ쏔。\x{FBC6}", %p)},	undef,	"to_unicode\(\'\\u0E4E\\uD9CE\\uDF8Fⴗ쏔\。\\uFBC6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4E}\x{83B8F}ⴗ쏔。\x{FBC6}", %p)},	undef,	"to_unicode\(\'\\u0E4E\\uD9CE\\uDF8Fⴗ쏔\。\\uFBC6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß｡𐋳Ⴌ\x{1DD8}", %p)},	undef,	"to_unicode\(\'ß｡𐋳Ⴌ\\u1DD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß。𐋳Ⴌ\x{1DD8}", %p)},	undef,	"to_unicode\(\'ß\。𐋳Ⴌ\\u1DD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:991\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß。𐋳ⴌ\x{1DD8}", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ß\。𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:992\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß。𐋳ⴌ\x{1DD8}", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ß\。𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:993\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS。𐋳Ⴌ\x{1DD8}", %p)},	undef,	"to_unicode\(\'SS\。𐋳Ⴌ\\u1DD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:994\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss。𐋳ⴌ\x{1DD8}", %p)},	"ss.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ss\。𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:995\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss.xn--weg506dvy5n", %p)},	"ss.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ss\.xn\-\-weg506dvy5n\'\)\ \[data\/IdnaTest\.txt\:996\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss.𐋳ⴌ\x{1DD8}", %p)},	"ss.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ss\.𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:997\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS.𐋳Ⴌ\x{1DD8}", %p)},	undef,	"to_unicode\(\'SS\.𐋳Ⴌ\\u1DD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:998\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--zca.xn--weg506dvy5n", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'xn\-\-zca\.xn\-\-weg506dvy5n\'\)\ \[data\/IdnaTest\.txt\:999\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß.𐋳ⴌ\x{1DD8}", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ß\.𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:1000\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß.𐋳ⴌ\x{1DD8}", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ß\.𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:1001\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß｡𐋳ⴌ\x{1DD8}", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ß｡𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:1002\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß｡𐋳ⴌ\x{1DD8}", %p)},	"ß.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ß｡𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:1003\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS｡𐋳Ⴌ\x{1DD8}", %p)},	undef,	"to_unicode\(\'SS｡𐋳Ⴌ\\u1DD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1004\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss｡𐋳ⴌ\x{1DD8}", %p)},	"ss.𐋳ⴌ\x{1DD8}",	"to_unicode\(\'ss｡𐋳ⴌ\\u1DD8\'\)\ \[data\/IdnaTest\.txt\:1005\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-ᠽ\x{1EB4E}.\x{200C}\x{0017}\x{1BAA}", %p)},	undef,	"to_unicode\(\'\-ᠽ\\uD83A\\uDF4E\.\\u200C\\u0017\\u1BAA\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ᠽ\x{1EB4E}.\x{200C}\x{0017}\x{1BAA}", %p)},	undef,	"to_unicode\(\'\-ᠽ\\uD83A\\uDF4E\.\\u200C\\u0017\\u1BAA\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1007\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⯁ᡴ\x{1DC2}\x{11134}.🖅\x{200D}", %p)},	undef,	"to_unicode\(\'\⯁ᡴ\\u1DC2\\uD804\\uDD34\.🖅\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1008\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⯁ᡴ\x{1DC2}\x{11134}.🖅\x{200D}", %p)},	undef,	"to_unicode\(\'\⯁ᡴ\\u1DC2\\uD804\\uDD34\.🖅\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1009\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⯁ᡴ\x{11134}\x{1DC2}.🖅\x{200D}", %p)},	undef,	"to_unicode\(\'\⯁ᡴ\\uD804\\uDD34\\u1DC2\.🖅\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1010\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⯁ᡴ\x{11134}\x{1DC2}.🖅\x{200D}", %p)},	undef,	"to_unicode\(\'\⯁ᡴ\\uD804\\uDD34\\u1DC2\.🖅\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1011\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--h9e03yc8ncx7t.xn--vy8h", %p)},	"⯁ᡴ\x{11134}\x{1DC2}.🖅",	"to_unicode\(\'xn\-\-h9e03yc8ncx7t\.xn\-\-vy8h\'\)\ \[data\/IdnaTest\.txt\:1012\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⯁ᡴ\x{11134}\x{1DC2}.🖅", %p)},	"⯁ᡴ\x{11134}\x{1DC2}.🖅",	"to_unicode\(\'\⯁ᡴ\\uD804\\uDD34\\u1DC2\.🖅\'\)\ \[data\/IdnaTest\.txt\:1013\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0311}\x{200D}\x{E02F9}\x{10AE0}.ᡟ\x{200C}🡔", %p)},	undef,	"to_unicode\(\'\\u0311\\u200D\\uDB40\\uDEF9\\uD802\\uDEE0\.ᡟ\\u200C🡔\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0311}\x{200D}\x{E02F9}\x{10AE0}.ᡟ\x{200C}🡔", %p)},	undef,	"to_unicode\(\'\\u0311\\u200D\\uDB40\\uDEF9\\uD802\\uDEE0\.ᡟ\\u200C🡔\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴑ．\x{06BF}\x{FBE9}\x{0642}", %p)},	undef,	"to_unicode\(\'Ⴑ．\\u06BF\\uFBE9\\u0642\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴑ.\x{06BF}\x{0649}\x{0642}", %p)},	undef,	"to_unicode\(\'Ⴑ\.\\u06BF\\u0649\\u0642\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1017\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴑ.\x{06BF}\x{0649}\x{0642}", %p)},	"ⴑ.\x{06BF}\x{0649}\x{0642}",	"to_unicode\(\'ⴑ\.\\u06BF\\u0649\\u0642\'\)\ \[data\/IdnaTest\.txt\:1018\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--8kj.xn--ehbn76a", %p)},	"ⴑ.\x{06BF}\x{0649}\x{0642}",	"to_unicode\(\'xn\-\-8kj\.xn\-\-ehbn76a\'\)\ \[data\/IdnaTest\.txt\:1019\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴑ．\x{06BF}\x{FBE9}\x{0642}", %p)},	"ⴑ.\x{06BF}\x{0649}\x{0642}",	"to_unicode\(\'ⴑ．\\u06BF\\uFBE9\\u0642\'\)\ \[data\/IdnaTest\.txt\:1020\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E014C}\x{1025FD}\x{11134}。𑒈𝟵", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4C\\uDBC9\\uDDFD\\uD804\\uDD34\。𑒈𝟵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014C}\x{1025FD}\x{11134}。𑒈9", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4C\\uDBC9\\uDDFD\\uD804\\uDD34\。𑒈9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}𝟗｡Ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE17𝟗｡Ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}𝟗｡Ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE17𝟗｡Ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}9。Ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE179\。Ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}9。Ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE179\。Ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}9。ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE179\。ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}9。ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE179\。ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}𝟗｡ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE17𝟗｡ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡓ\x{5B217}𝟗｡ⴣ␄\x{10B67}\x{63619}", %p)},	undef,	"to_unicode\(\'\\u200Cᡓ\\uD92C\\uDE17𝟗｡ⴣ\␄\\uD802\\uDF67\\uD94D\\uDE19\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:1030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ｡\x{1A5B}\x{D8D7D}\x{0488}-", %p)},	undef,	"to_unicode\(\'ᡭ｡\\u1A5B\\uDB23\\uDD7D\\u0488\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ。\x{1A5B}\x{D8D7D}\x{0488}-", %p)},	undef,	"to_unicode\(\'ᡭ\。\\u1A5B\\uDB23\\uDD7D\\u0488\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EF40}\x{BAA93}。絧\x{16AF2}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF40\\uDAAA\\uDE93\。絧\\uD81A\\uDEF2\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}Ⴋ．𝟳≯︒\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDႫ．𝟳\≯︒\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}Ⴋ．𝟳>\x{0338}︒\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDႫ．𝟳\>\\u0338︒\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}Ⴋ.7≯。\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDႫ\.7\≯\。\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}Ⴋ.7>\x{0338}。\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDႫ\.7\>\\u0338\。\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}ⴋ.7>\x{0338}。\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDⴋ\.7\>\\u0338\。\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}ⴋ.7≯。\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDⴋ\.7\≯\。\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}ⴋ．𝟳>\x{0338}︒\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDⴋ．𝟳\>\\u0338︒\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DED}ⴋ．𝟳≯︒\x{0A4D}", %p)},	undef,	"to_unicode\(\'\\u1DEDⴋ．𝟳\≯︒\\u0A4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{0C4D}。\x{2DF9}︒\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200DF\\u0C4D\。\\u2DF9︒\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{0C4D}。\x{2DF9}︒\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200DF\\u0C4D\。\\u2DF9︒\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1043\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}F\x{0C4D}。\x{2DF9}。\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200DF\\u0C4D\。\\u2DF9\。\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1044\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}F\x{0C4D}。\x{2DF9}。\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200DF\\u0C4D\。\\u2DF9\。\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1045\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}f\x{0C4D}。\x{2DF9}。\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200Df\\u0C4D\。\\u2DF9\。\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1046\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}f\x{0C4D}。\x{2DF9}。\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200Df\\u0C4D\。\\u2DF9\。\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1047\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}f\x{0C4D}。\x{2DF9}︒\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200Df\\u0C4D\。\\u2DF9︒\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f\x{0C4D}。\x{2DF9}︒\x{06B0}\x{10E78}", %p)},	undef,	"to_unicode\(\'\\u200Df\\u0C4D\。\\u2DF9︒\\u06B0\\uD803\\uDE78\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡁ🄇\x{1EC97}︒｡\x{10E70}\x{1107F}", %p)},	undef,	"to_unicode\(\'ꡁ🄇\\uD83B\\uDC97︒｡\\uD803\\uDE70\\uD804\\uDC7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡁ6,\x{1EC97}。。\x{10E70}\x{1107F}", %p)},	undef,	"to_unicode\(\'ꡁ6\,\\uD83B\\uDC97\。\。\\uD803\\uDE70\\uD804\\uDC7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED09}.\x{114C0}\x{E011E}\x{10F9D}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD09\.\\uD805\\uDCC0\\uDB40\\uDD1E\\uD803\\uDF9D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴂ䠺。\x{0680}\x{D6976}\x{419A9}\x{06AD}", %p)},	undef,	"to_unicode\(\'Ⴂ䠺\。\\u0680\\uDB1A\\uDD76\\uD8C6\\uDDA9\\u06AD\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴂ䠺。\x{0680}\x{D6976}\x{419A9}\x{06AD}", %p)},	undef,	"to_unicode\(\'ⴂ䠺\。\\u0680\\uDB1A\\uDD76\\uD8C6\\uDDA9\\u06AD\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄇伐︒.\x{1C73A}\x{A806}", %p)},	undef,	"to_unicode\(\'🄇伐︒\.\\uD831\\uDF3A\\uA806\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6,伐。.\x{1C73A}\x{A806}", %p)},	undef,	"to_unicode\(\'6\,伐\。\.\\uD831\\uDF3A\\uA806\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E64}\x{0ACD}𐆗。\x{200D}\x{07DF}Ⴚ\x{1734}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE64\\u0ACD𐆗\。\\u200D\\u07DFႺ\\u1734\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10E64}\x{0ACD}𐆗。\x{200D}\x{07DF}Ⴚ\x{1734}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE64\\u0ACD𐆗\。\\u200D\\u07DFႺ\\u1734\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1058\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{10E64}\x{0ACD}𐆗。\x{200D}\x{07DF}ⴚ\x{1734}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE64\\u0ACD𐆗\。\\u200D\\u07DFⴚ\\u1734\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1059\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{10E64}\x{0ACD}𐆗。\x{200D}\x{07DF}ⴚ\x{1734}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE64\\u0ACD𐆗\。\\u200D\\u07DFⴚ\\u1734\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1060\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1112F}．\x{4572B}\x{56E48}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD2F．\\uD8D5\\uDF2B\\uD91B\\uDE48\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11132}\x{11127}．\x{4572B}\x{56E48}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD32\\uD804\\uDD27．\\uD8D5\\uDF2B\\uD91B\\uDE48\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1112F}.\x{4572B}\x{56E48}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD2F\.\\uD8D5\\uDF2B\\uD91B\\uDE48\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11132}\x{11127}.\x{4572B}\x{56E48}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD32\\uD804\\uDD27\.\\uD8D5\\uDF2B\\uD91B\\uDE48\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}Ⴆ.≠\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200CႦ\.\≠\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}Ⴆ.≠\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200CႦ\.\≠\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}Ⴆ.=\x{0338}\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200CႦ\.\=\\u0338\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}Ⴆ.=\x{0338}\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200CႦ\.\=\\u0338\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}ⴆ.=\x{0338}\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200Cⴆ\.\=\\u0338\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}ⴆ.=\x{0338}\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200Cⴆ\.\=\\u0338\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}ⴆ.≠\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200Cⴆ\.\≠\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AF}\x{200C}ⴆ.≠\x{10812}", %p)},	undef,	"to_unicode\(\'\\u06AF\\u200Cⴆ\.\≠\\uD802\\uDC12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A806}\x{664A8}𝟥ꘌ．\x{0769}", %p)},	undef,	"to_unicode\(\'\\uA806\\uD959\\uDCA8𝟥ꘌ．\\u0769\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A806}\x{664A8}3ꘌ.\x{0769}", %p)},	undef,	"to_unicode\(\'\\uA806\\uD959\\uDCA83ꘌ\.\\u0769\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{0C40}\x{42C30}-", %p)},	undef,	"to_unicode\(\'\-\.\\u0C40\\uD8CB\\uDC30\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}｡\x{200C}\x{FD6B}ς", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C｡\\u200C\\uFD6Bς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}｡\x{200C}\x{FD6B}ς", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C｡\\u200C\\uFD6Bς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}。\x{200C}\x{0634}\x{0645}\x{062E}ς", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C\。\\u200C\\u0634\\u0645\\u062Eς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}。\x{200C}\x{0634}\x{0645}\x{062E}ς", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C\。\\u200C\\u0634\\u0645\\u062Eς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}。\x{200C}\x{0634}\x{0645}\x{062E}Σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C\。\\u200C\\u0634\\u0645\\u062EΣ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}。\x{200C}\x{0634}\x{0645}\x{062E}Σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C\。\\u200C\\u0634\\u0645\\u062EΣ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}。\x{200C}\x{0634}\x{0645}\x{062E}σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C\。\\u200C\\u0634\\u0645\\u062Eσ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}。\x{200C}\x{0634}\x{0645}\x{062E}σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C\。\\u200C\\u0634\\u0645\\u062Eσ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}｡\x{200C}\x{FD6B}Σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C｡\\u200C\\uFD6BΣ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}｡\x{200C}\x{FD6B}Σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C｡\\u200C\\uFD6BΣ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}｡\x{200C}\x{FD6B}σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C｡\\u200C\\uFD6Bσ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{73D1D}\x{200C}｡\x{200C}\x{FD6B}σ", %p)},	undef,	"to_unicode\(\'\\uD98F\\uDD1D\\u200C｡\\u200C\\uFD6Bσ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("堕\x{115BF}\x{E0CEE}。ᢗ\x{10AD5}\x{200C}-", %p)},	undef,	"to_unicode\(\'堕\\uD805\\uDDBF\\uDB43\\uDCEE\。ᢗ\\uD802\\uDED5\\u200C\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("堕\x{115BF}\x{E0CEE}。ᢗ\x{10AD5}\x{200C}-", %p)},	undef,	"to_unicode\(\'堕\\uD805\\uDDBF\\uDB43\\uDCEE\。ᢗ\\uD802\\uDED5\\u200C\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1089\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}｡\x{06BB}ςᡃς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C｡\\u06BBςᡃς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1090\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}。\x{06BB}ςᡃς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C\。\\u06BBςᡃς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1091\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}。\x{06BB}ΣᡃΣ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C\。\\u06BBΣᡃΣ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1092\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}。\x{06BB}σᡃς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C\。\\u06BBσᡃς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}。\x{06BB}σᡃσ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C\。\\u06BBσᡃσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}。\x{06BB}Σᡃσ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C\。\\u06BBΣᡃσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1095\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}。\x{06BB}Σᡃς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C\。\\u06BBΣᡃς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1096\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}｡\x{06BB}ΣᡃΣ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C｡\\u06BBΣᡃΣ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1097\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}｡\x{06BB}σᡃς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C｡\\u06BBσᡃς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1098\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}｡\x{06BB}σᡃσ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C｡\\u06BBσᡃσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1099\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}｡\x{06BB}Σᡃσ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C｡\\u06BBΣᡃσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1100\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E65}\x{0D4D}\x{10AED}\x{067C}｡\x{06BB}Σᡃς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE65\\u0D4D\\uD802\\uDEED\\u067C｡\\u06BBΣᡃς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1101\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{6E385}．-𝟻ß", %p)},	undef,	"to_unicode\(\'\\uD978\\uDF85．\-𝟻ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6E385}.-5ß", %p)},	undef,	"to_unicode\(\'\\uD978\\uDF85\.\-5ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6E385}.-5SS", %p)},	undef,	"to_unicode\(\'\\uD978\\uDF85\.\-5SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6E385}．-𝟻SS", %p)},	undef,	"to_unicode\(\'\\uD978\\uDF85．\-𝟻SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6E385}．-𝟻ss", %p)},	undef,	"to_unicode\(\'\\uD978\\uDF85．\-𝟻ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6E385}．-𝟻Ss", %p)},	undef,	"to_unicode\(\'\\uD978\\uDF85．\-𝟻Ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0C4D}.⨀Ⴥ\x{14569}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0C4D\.\⨀Ⴥ\\uD811\\uDD69\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0C4D}.⨀Ⴥ\x{14569}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0C4D\.\⨀Ⴥ\\uD811\\uDD69\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0C4D}.⨀ⴥ\x{14569}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0C4D\.\⨀ⴥ\\uD811\\uDD69\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0C4D}.⨀ⴥ\x{14569}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0C4D\.\⨀ⴥ\\uD811\\uDD69\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。ß\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。ß\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。ß\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。ß\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。SS\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。SS\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。SS\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。SS\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。ss\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。ss\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。ss\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。ss\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。Ss\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。Ss\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E59EA}。Ss\x{82DF1}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDDEA\。Ss\\uD9CB\\uDDF1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{A56F4}。\x{1E8D4}﴿\x{109C1}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA55\\uDEF4\。\\uD83A\\uDCD4\﴿\\uD802\\uDDC1\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{A56F4}。\x{1E8D4}﴿\x{109C1}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA55\\uDEF4\。\\uD83A\\uDCD4\﴿\\uD802\\uDDC1\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED0E}\x{200C}\x{E0196}。\x{10E7E}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD0E\\u200C\\uDB40\\uDD96\。\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED0E}\x{200C}\x{E0196}。\x{10E7E}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD0E\\u200C\\uDB40\\uDD96\。\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}ς≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}ς≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}ς≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}ς≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7FΣ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7FΣ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}Σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7FΣ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}Σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7FΣ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fσ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fσ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fσ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}。\x{114C2}\x{2D7F}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F\。\\uD805\\uDCC2\\u2D7Fσ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7FΣ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7FΣ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}Σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7FΣ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}Σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7FΣ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fσ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}σ≠", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fσ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fσ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DD}\x{A310E}\x{200C}\x{E0B0F}｡\x{114C2}\x{2D7F}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u20DD\\uDA4C\\uDD0E\\u200C\\uDB42\\uDF0F｡\\uD805\\uDCC2\\u2D7Fσ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋｡⒈\x{200D}\x{83A40}", %p)},	undef,	"to_unicode\(\'⒋｡⒈\\u200D\\uD9CE\\uDE40\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋｡⒈\x{200D}\x{83A40}", %p)},	undef,	"to_unicode\(\'⒋｡⒈\\u200D\\uD9CE\\uDE40\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.。1.\x{200D}\x{83A40}", %p)},	undef,	"to_unicode\(\'4\.\。1\.\\u200D\\uD9CE\\uDE40\'\)\ throws\ error\ P1\ V6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:1150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.。1.\x{200D}\x{83A40}", %p)},	undef,	"to_unicode\(\'4\.\。1\.\\u200D\\uD9CE\\uDE40\'\)\ throws\ error\ P1\ V6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:1151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}ß｡\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4ß｡\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}ß。\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4ß\。\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}SS。\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4SS\。\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}ss。\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4ss\。\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}Ss。\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4Ss\。\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}SS｡\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4SS｡\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}ss｡\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4ss｡\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D4}Ss｡\x{1103A}\x{11133}\x{461CC}ᡉ", %p)},	undef,	"to_unicode\(\'\\u07D4Ss｡\\uD804\\uDC3A\\uD804\\uDD33\\uD8D8\\uDDCCᡉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}\x{1163F}\x{B065A}.\x{1CF9}\x{0489}\x{094D}\x{11235}", %p)},	undef,	"to_unicode\(\'\\u0661\\uD805\\uDE3F\\uDA81\\uDE5A\.\\u1CF9\\u0489\\u094D\\uD804\\uDE35\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴓ\x{110B9}\x{200D}\x{68161}．ꡩ\x{0AC2}", %p)},	undef,	"to_unicode\(\'Ⴓ\\uD804\\uDCB9\\u200D\\uD960\\uDD61．ꡩ\\u0AC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴓ\x{110B9}\x{200D}\x{68161}.ꡩ\x{0AC2}", %p)},	undef,	"to_unicode\(\'Ⴓ\\uD804\\uDCB9\\u200D\\uD960\\uDD61\.ꡩ\\u0AC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴓ\x{110B9}\x{200D}\x{68161}.ꡩ\x{0AC2}", %p)},	undef,	"to_unicode\(\'ⴓ\\uD804\\uDCB9\\u200D\\uD960\\uDD61\.ꡩ\\u0AC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴓ\x{110B9}\x{200D}\x{68161}．ꡩ\x{0AC2}", %p)},	undef,	"to_unicode\(\'ⴓ\\uD804\\uDCB9\\u200D\\uD960\\uDD61．ꡩ\\u0AC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0D4D}.🄆\x{E0B4D}", %p)},	undef,	"to_unicode\(\'\\u0D4D\.🄆\\uDB42\\uDF4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0D4D}.5,\x{E0B4D}", %p)},	undef,	"to_unicode\(\'\\u0D4D\.5\,\\uDB42\\uDF4D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11AAC}𧧄۸。⿴-", %p)},	undef,	"to_unicode\(\'\\uD806\\uDEAC𧧄۸\。⿴\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{31FEA}\x{0680}\x{10E66}。\x{0667}\x{10ADD}ꡙ", %p)},	undef,	"to_unicode\(\'\\uD887\\uDFEA\\u0680\\uD803\\uDE66\。\\u0667\\uD802\\uDEDDꡙ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}Ⴞ🄂.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFႾ🄂\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}Ⴞ🄂.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFႾ🄂\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}Ⴞ1,.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFႾ1\,\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}Ⴞ1,.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFႾ1\,\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}ⴞ1,.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFⴞ1\,\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}ⴞ1,.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFⴞ1\,\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}ⴞ🄂.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFⴞ🄂\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{06FF}ⴞ🄂.\x{06E2}\x{10B90}\x{C8208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\\u06FFⴞ🄂\.\\u06E2\\uD802\\uDF90\\uDAE0\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1176\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0665}\x{075D}．\x{1A60}𧇧⾆", %p)},	undef,	"to_unicode\(\'\\u0665\\u075D．\\u1A60𧇧⾆\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1177\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0665}\x{075D}.\x{1A60}𧇧舌", %p)},	undef,	"to_unicode\(\'\\u0665\\u075D\.\\u1A60𧇧舌\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1178\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🁓\x{E0BE8}\x{C35B9}.\x{67177}", %p)},	undef,	"to_unicode\(\'🁓\\uDB42\\uDFE8\\uDACD\\uDDB9\.\\uD95C\\uDD77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0149}\x{DA062}-\x{79909}.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD49\\uDB28\\uDC62\-\\uD9A6\\uDD09\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0149}\x{DA062}-\x{79909}.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD49\\uDB28\\uDC62\-\\uD9A6\\uDD09\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0149}\x{DA062}-\x{79909}.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD49\\uDB28\\uDC62\-\\uD9A6\\uDD09\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0149}\x{DA062}-\x{79909}.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD49\\uDB28\\uDC62\-\\uD9A6\\uDD09\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1183\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ｡∗ß\x{1CD8}", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'ᚭ｡\∗ß\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1184\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ｡∗ß\x{1CD8}", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'ᚭ｡\∗ß\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1185\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ。∗ß\x{1CD8}", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'ᚭ\。\∗ß\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1186\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ。∗ß\x{1CD8}", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'ᚭ\。\∗ß\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1187\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ。∗SS\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ\。\∗SS\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1188\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ。∗ss\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ\。\∗ss\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1189\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ。∗Ss\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ\。\∗Ss\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--hwe.xn--ss-90rx11a", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'xn\-\-hwe\.xn\-\-ss\-90rx11a\'\)\ \[data\/IdnaTest\.txt\:1191\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ.∗ss\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ\.\∗ss\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1192\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ.∗SS\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ\.\∗SS\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1193\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ.∗Ss\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ\.\∗Ss\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1194\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--hwe.xn--zca634lctd", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'xn\-\-hwe\.xn\-\-zca634lctd\'\)\ \[data\/IdnaTest\.txt\:1195\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ.∗ß\x{1CD8}", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'ᚭ\.\∗ß\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1196\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ.∗ß\x{1CD8}", %p)},	"ᚭ.∗ß\x{1CD8}",	"to_unicode\(\'ᚭ\.\∗ß\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1197\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ｡∗SS\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ｡\∗SS\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1198\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ｡∗ss\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ｡\∗ss\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1199\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᚭ｡∗Ss\x{1CD8}", %p)},	"ᚭ.∗ss\x{1CD8}",	"to_unicode\(\'ᚭ｡\∗Ss\\u1CD8\'\)\ \[data\/IdnaTest\.txt\:1200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("₁｡\x{07CB}ᡉ", %p)},	undef,	"to_unicode\(\'₁｡\\u07CBᡉ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1201\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("1。\x{07CB}ᡉ", %p)},	undef,	"to_unicode\(\'1\。\\u07CBᡉ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1202\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{DE3C8}\x{200C}.\x{10B23}\x{2E61C}\x{F1723}", %p)},	undef,	"to_unicode\(\'\\uDB38\\uDFC8\\u200C\.\\uD802\\uDF23\\uD879\\uDE1C\\uDB85\\uDF23\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{DE3C8}\x{200C}.\x{10B23}\x{2E61C}\x{F1723}", %p)},	undef,	"to_unicode\(\'\\uDB38\\uDFC8\\u200C\.\\uD802\\uDF23\\uD879\\uDE1C\\uDB85\\uDF23\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}≯｡\x{E0906}", %p)},	undef,	"to_unicode\(\'\\u2D7F\≯｡\\uDB42\\uDD06\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}>\x{0338}｡\x{E0906}", %p)},	undef,	"to_unicode\(\'\\u2D7F\>\\u0338｡\\uDB42\\uDD06\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}≯。\x{E0906}", %p)},	undef,	"to_unicode\(\'\\u2D7F\≯\。\\uDB42\\uDD06\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}>\x{0338}。\x{E0906}", %p)},	undef,	"to_unicode\(\'\\u2D7F\>\\u0338\。\\uDB42\\uDD06\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\≮\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\≮\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\≮\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮\x{D5FD4}。\x{200D}\x{E0133}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\≮\\uDB17\\uDFD4\。\\u200D\\uDB40\\uDD33𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{114C2}.\x{97956}≯", %p)},	undef,	"to_unicode\(\'\\uD805\\uDCC2\.\\uDA1E\\uDD56\≯\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{114C2}.\x{97956}>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD805\\uDCC2\.\\uDA1E\\uDD56\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}．\x{FE27}É🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806．\\uFE27É🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}．\x{FE27}E\x{0301}🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806．\\uFE27E\\u0301🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}.\x{FE27}É🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806\.\\uFE27É🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}.\x{FE27}E\x{0301}🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806\.\\uFE27E\\u0301🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}.\x{FE27}e\x{0301}🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806\.\\uFE27e\\u0301🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}.\x{FE27}é🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806\.\\uFE27é🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}．\x{FE27}e\x{0301}🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806．\\uFE27e\\u0301🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{91A47}\x{A806}．\x{FE27}é🀔\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDA06\\uDE47\\uA806．\\uFE27é🀔\\u1BF3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ\x{200D}\x{0DCA}｡︒\x{084E}", %p)},	undef,	"to_unicode\(\'ᡉ\\u200D\\u0DCA｡︒\\u084E\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ\x{200D}\x{0DCA}｡︒\x{084E}", %p)},	undef,	"to_unicode\(\'ᡉ\\u200D\\u0DCA｡︒\\u084E\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1228\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ᡉ\x{200D}\x{0DCA}。。\x{084E}", %p)},	undef,	"to_unicode\(\'ᡉ\\u200D\\u0DCA\。\。\\u084E\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1229\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ᡉ\x{200D}\x{0DCA}。。\x{084E}", %p)},	undef,	"to_unicode\(\'ᡉ\\u200D\\u0DCA\。\。\\u084E\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1230\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FB55}\x{1CF88}\x{0CCD}\x{200C}｡\x{06B4}\x{17B4}≮", %p)},	undef,	"to_unicode\(\'\\uFB55\\uD833\\uDF88\\u0CCD\\u200C｡\\u06B4\\u17B4\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB55}\x{1CF88}\x{0CCD}\x{200C}｡\x{06B4}\x{17B4}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFB55\\uD833\\uDF88\\u0CCD\\u200C｡\\u06B4\\u17B4\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067B}\x{1CF88}\x{0CCD}\x{200C}。\x{06B4}\x{17B4}≮", %p)},	undef,	"to_unicode\(\'\\u067B\\uD833\\uDF88\\u0CCD\\u200C\。\\u06B4\\u17B4\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067B}\x{1CF88}\x{0CCD}\x{200C}。\x{06B4}\x{17B4}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u067B\\uD833\\uDF88\\u0CCD\\u200C\。\\u06B4\\u17B4\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ．\x{17BD}ᡎ", %p)},	undef,	"to_unicode\(\'Ⴣ．\\u17BDᡎ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ.\x{17BD}ᡎ", %p)},	undef,	"to_unicode\(\'Ⴣ\.\\u17BDᡎ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1236\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴣ.\x{17BD}ᡎ", %p)},	undef,	"to_unicode\(\'ⴣ\.\\u17BDᡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1237\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴣ．\x{17BD}ᡎ", %p)},	undef,	"to_unicode\(\'ⴣ．\\u17BDᡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1238\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⧍\x{10932}．\x{6AA2C}\x{DDDAB}Ⴤ\x{4D940}", %p)},	undef,	"to_unicode\(\'\⧍\\uD802\\uDD32．\\uD96A\\uDE2C\\uDB37\\uDDABჄ\\uD8F6\\uDD40\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧍\x{10932}.\x{6AA2C}\x{DDDAB}Ⴤ\x{4D940}", %p)},	undef,	"to_unicode\(\'\⧍\\uD802\\uDD32\.\\uD96A\\uDE2C\\uDB37\\uDDABჄ\\uD8F6\\uDD40\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧍\x{10932}.\x{6AA2C}\x{DDDAB}ⴤ\x{4D940}", %p)},	undef,	"to_unicode\(\'\⧍\\uD802\\uDD32\.\\uD96A\\uDE2C\\uDB37\\uDDABⴤ\\uD8F6\\uDD40\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧍\x{10932}．\x{6AA2C}\x{DDDAB}ⴤ\x{4D940}", %p)},	undef,	"to_unicode\(\'\⧍\\uD802\\uDD32．\\uD96A\\uDE2C\\uDB37\\uDDABⴤ\\uD8F6\\uDD40\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034A}\x{1086}≮．⦱", %p)},	undef,	"to_unicode\(\'\\u034A\\u1086\≮．\⦱\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034A}\x{1086}<\x{0338}．⦱", %p)},	undef,	"to_unicode\(\'\\u034A\\u1086\<\\u0338．\⦱\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034A}\x{1086}≮.⦱", %p)},	undef,	"to_unicode\(\'\\u034A\\u1086\≮\.\⦱\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034A}\x{1086}<\x{0338}.⦱", %p)},	undef,	"to_unicode\(\'\\u034A\\u1086\<\\u0338\.\⦱\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{FCCA}≮Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uFCCA\≮Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{FCCA}<\x{0338}Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uFCCA\<\\u0338Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{0644}\x{062D}≮Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\u0644\\u062D\≮Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{0644}\x{062D}<\x{0338}Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\u0644\\u062D\<\\u0338Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{0644}\x{062D}<\x{0338}ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\u0644\\u062D\<\\u0338ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{0644}\x{062D}≮ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\u0644\\u062D\≮ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{0644}\x{062D}≮Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\u0644\\u062D\≮Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{0644}\x{062D}<\x{0338}Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\u0644\\u062D\<\\u0338Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{FCCA}<\x{0338}ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uFCCA\<\\u0338ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{FCCA}≮ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uFCCA\≮ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{FCCA}≮Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uFCCA\≮Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E66}\x{FCCA}<\x{0338}Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uFCCA\<\\u0338Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1258\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{112EA}。-", %p)},	undef,	"to_unicode\(\'\\uD804\\uDEEA\。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1259\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1039}\x{F14D9}\x{E04AD}｡饈≠\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u1039\\uDB85\\uDCD9\\uDB41\\uDCAD｡饈\≠\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}\x{F14D9}\x{E04AD}｡饈=\x{0338}\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u1039\\uDB85\\uDCD9\\uDB41\\uDCAD｡饈\=\\u0338\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}\x{F14D9}\x{E04AD}。饈≠\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u1039\\uDB85\\uDCD9\\uDB41\\uDCAD\。饈\≠\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}\x{F14D9}\x{E04AD}。饈=\x{0338}\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u1039\\uDB85\\uDCD9\\uDB41\\uDCAD\。饈\=\\u0338\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077C}ᢓ⁷｡≯邅\x{E06DB}4", %p)},	undef,	"to_unicode\(\'\\u077Cᢓ⁷｡\≯邅\\uDB41\\uDEDB4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077C}ᢓ⁷｡>\x{0338}邅\x{E06DB}4", %p)},	undef,	"to_unicode\(\'\\u077Cᢓ⁷｡\>\\u0338邅\\uDB41\\uDEDB4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077C}ᢓ7。≯邅\x{E06DB}4", %p)},	undef,	"to_unicode\(\'\\u077Cᢓ7\。\≯邅\\uDB41\\uDEDB4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077C}ᢓ7。>\x{0338}邅\x{E06DB}4", %p)},	undef,	"to_unicode\(\'\\u077Cᢓ7\。\>\\u0338邅\\uDB41\\uDEDB4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{414D5}ꡠ-\x{0340}.\x{0665}𐋫\x{10E76}\x{48E11}", %p)},	undef,	"to_unicode\(\'\\uD8C5\\uDCD5ꡠ\-\\u0340\.\\u0665𐋫\\uD803\\uDE76\\uD8E3\\uDE11\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{414D5}ꡠ-\x{0300}.\x{0665}𐋫\x{10E76}\x{48E11}", %p)},	undef,	"to_unicode\(\'\\uD8C5\\uDCD5ꡠ\-\\u0300\.\\u0665𐋫\\uD803\\uDE76\\uD8E3\\uDE11\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1091CC}\x{07E1}\x{200E}.넨-\x{F622A}", %p)},	undef,	"to_unicode\(\'\\uDBE4\\uDDCC\\u07E1\\u200E\.넨\-\\uDB98\\uDE2A\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1091CC}\x{07E1}\x{200E}.넨-\x{F622A}", %p)},	undef,	"to_unicode\(\'\\uDBE4\\uDDCC\\u07E1\\u200E\.넨\-\\uDB98\\uDE2A\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084E}ᠰ\x{200D}⒈。𐋣-", %p)},	undef,	"to_unicode\(\'\\u084Eᠰ\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ C2\ \[data\/IdnaTest\.txt\:1272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084E}ᠰ\x{200D}⒈。𐋣-", %p)},	undef,	"to_unicode\(\'\\u084Eᠰ\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ C2\ \[data\/IdnaTest\.txt\:1273\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{084E}ᠰ\x{200D}1.。𐋣-", %p)},	undef,	"to_unicode\(\'\\u084Eᠰ\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ B2\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1274\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{084E}ᠰ\x{200D}1.。𐋣-", %p)},	undef,	"to_unicode\(\'\\u084Eᠰ\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ B2\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1275\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴌ。\x{CCAC6}\x{10C5A}", %p)},	undef,	"to_unicode\(\'Ⴌ\。\\uDAF2\\uDEC6\\uD803\\uDC5A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ。\x{CCAC6}\x{10C5A}", %p)},	undef,	"to_unicode\(\'ⴌ\。\\uDAF2\\uDEC6\\uD803\\uDC5A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}\x{10EE6}.\x{17D2}\x{065D}-\x{C0074}", %p)},	undef,	"to_unicode\(\'\\u075E\\uD803\\uDEE6\.\\u17D2\\u065D\-\\uDAC0\\uDC74\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{8285E}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD9CA\\uDC5E\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("て。\x{200C}\x{E08C8}\x{114BA}", %p)},	undef,	"to_unicode\(\'て\。\\u200C\\uDB42\\uDCC8\\uD805\\uDCBA\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("て。\x{200C}\x{E08C8}\x{114BA}", %p)},	undef,	"to_unicode\(\'て\。\\u200C\\uDB42\\uDCC8\\uD805\\uDCBA\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς｡\x{0C4D}\x{0B56}", %p)},	undef,	"to_unicode\(\'ς｡\\u0C4D\\u0B56\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς。\x{0C4D}\x{0B56}", %p)},	undef,	"to_unicode\(\'ς\。\\u0C4D\\u0B56\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ。\x{0C4D}\x{0B56}", %p)},	undef,	"to_unicode\(\'Σ\。\\u0C4D\\u0B56\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ。\x{0C4D}\x{0B56}", %p)},	undef,	"to_unicode\(\'σ\。\\u0C4D\\u0B56\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ｡\x{0C4D}\x{0B56}", %p)},	undef,	"to_unicode\(\'Σ｡\\u0C4D\\u0B56\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ｡\x{0C4D}\x{0B56}", %p)},	undef,	"to_unicode\(\'σ｡\\u0C4D\\u0B56\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{DC1A7}\x{302FF}.ႢႵ", %p)},	undef,	"to_unicode\(\'\\u1A60\\uDB30\\uDDA7\\uD880\\uDEFF\.ႢႵ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{DC1A7}\x{302FF}.ⴂⴕ", %p)},	undef,	"to_unicode\(\'\\u1A60\\uDB30\\uDDA7\\uD880\\uDEFF\.ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{DC1A7}\x{302FF}.Ⴂⴕ", %p)},	undef,	"to_unicode\(\'\\u1A60\\uDB30\\uDDA7\\uD880\\uDEFF\.Ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0597}🄈⾛\x{031C}．\x{200D}\x{17F93}\x{1E81D}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD97🄈⾛\\u031C．\\u200D\\uD81F\\uDF93\\uD83A\\uDC1D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0597}🄈⾛\x{031C}．\x{200D}\x{17F93}\x{1E81D}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD97🄈⾛\\u031C．\\u200D\\uD81F\\uDF93\\uD83A\\uDC1D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0597}7,走\x{031C}.\x{200D}\x{17F93}\x{1E81D}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD977\,走\\u031C\.\\u200D\\uD81F\\uDF93\\uD83A\\uDC1D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0597}7,走\x{031C}.\x{200D}\x{17F93}\x{1E81D}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD977\,走\\u031C\.\\u200D\\uD81F\\uDF93\\uD83A\\uDC1D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}｡Ӏ\x{EFDD8}", %p)},	undef,	"to_unicode\(\'\\u075E｡Ӏ\\uDB7F\\uDDD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}。Ӏ\x{EFDD8}", %p)},	undef,	"to_unicode\(\'\\u075E\。Ӏ\\uDB7F\\uDDD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}。ӏ\x{EFDD8}", %p)},	undef,	"to_unicode\(\'\\u075E\。ӏ\\uDB7F\\uDDD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}｡ӏ\x{EFDD8}", %p)},	undef,	"to_unicode\(\'\\u075E｡ӏ\\uDB7F\\uDDD8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1305\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0666}-。𪺟🎫ᄾ", %p)},	undef,	"to_unicode\(\'\\u0666\-\。𪺟🎫ᄾ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𐋷\x{0F91}。\x{1B02}", %p)},	undef,	"to_unicode\(\'\-𐋷\\u0F91\。\\u1B02\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1307\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{10E74}\x{1CDE}멈.\x{AAF6}\x{BCA74}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE74\\u1CDE멈\.\\uAAF6\\uDAB2\\uDE74\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E74}\x{1CDE}멈.\x{AAF6}\x{BCA74}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE74\\u1CDE멈\.\\uAAF6\\uDAB2\\uDE74\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E74}\x{1CDE}멈.\x{AAF6}\x{BCA74}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE74\\u1CDE멈\.\\uAAF6\\uDAB2\\uDE74\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E74}\x{1CDE}멈.\x{AAF6}\x{BCA74}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE74\\u1CDE멈\.\\uAAF6\\uDAB2\\uDE74\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.\x{063E}\x{10E75}", %p)},	undef,	"to_unicode\(\'\≮\.\\u063E\\uD803\\uDE75\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{063E}\x{10E75}", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u063E\\uD803\\uDE75\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C25}⾆｡\x{200C}\x{1BAA}\x{C9BA4}\x{1EEC6}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC25⾆｡\\u200C\\u1BAA\\uDAE6\\uDFA4\\uD83B\\uDEC6\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C25}⾆｡\x{200C}\x{1BAA}\x{C9BA4}\x{1EEC6}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC25⾆｡\\u200C\\u1BAA\\uDAE6\\uDFA4\\uD83B\\uDEC6\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C25}舌。\x{200C}\x{1BAA}\x{C9BA4}\x{1EEC6}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC25舌\。\\u200C\\u1BAA\\uDAE6\\uDFA4\\uD83B\\uDEC6\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C25}舌。\x{200C}\x{1BAA}\x{C9BA4}\x{1EEC6}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC25舌\。\\u200C\\u1BAA\\uDAE6\\uDFA4\\uD83B\\uDEC6\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1Σ\x{1E8FE}Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1Σ\\uD83A\\uDCFEΣ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1Σ\x{1E8FE}Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1Σ\\uD83A\\uDCFEΣ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1σ\x{1E8FE}σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1σ\\uD83A\\uDCFEσ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1σ\x{1E8FE}σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1σ\\uD83A\\uDCFEσ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷ς\x{1E8FE}ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷ς\\uD83A\\uDCFEς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷Σ\x{1E8FE}Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷Σ\\uD83A\\uDCFEΣ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷Σ\x{1E8FE}Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷Σ\\uD83A\\uDCFEΣ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷σ\x{1E8FE}σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷σ\\uD83A\\uDCFEσ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷σ\x{1E8FE}σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷σ\\uD83A\\uDCFEσ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DC3}\x{0948}\x{CE955}｡𝟪Ⴜ", %p)},	undef,	"to_unicode\(\'\\u1DC3\\u0948\\uDAFA\\uDD55｡𝟪Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DC3}\x{0948}\x{CE955}。8Ⴜ", %p)},	undef,	"to_unicode\(\'\\u1DC3\\u0948\\uDAFA\\uDD55\。8Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DC3}\x{0948}\x{CE955}。8ⴜ", %p)},	undef,	"to_unicode\(\'\\u1DC3\\u0948\\uDAFA\\uDD55\。8ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DC3}\x{0948}\x{CE955}｡𝟪ⴜ", %p)},	undef,	"to_unicode\(\'\\u1DC3\\u0948\\uDAFA\\uDD55｡𝟪ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1337\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("䪏\x{1EEA5}ꡮ\x{05B5}｡뭕\x{066E}\x{1CDC}", %p)},	undef,	"to_unicode\(\'䪏\\uD83B\\uDEA5ꡮ\\u05B5｡뭕\\u066E\\u1CDC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1338\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("䪏\x{1EEA5}ꡮ\x{05B5}｡뭕\x{066E}\x{1CDC}", %p)},	undef,	"to_unicode\(\'䪏\\uD83B\\uDEA5ꡮ\\u05B5｡뭕\\u066E\\u1CDC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1339\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("䪏\x{0648}ꡮ\x{05B5}。뭕\x{066E}\x{1CDC}", %p)},	undef,	"to_unicode\(\'䪏\\u0648ꡮ\\u05B5\。뭕\\u066E\\u1CDC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1340\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("䪏\x{0648}ꡮ\x{05B5}。뭕\x{066E}\x{1CDC}", %p)},	undef,	"to_unicode\(\'䪏\\u0648ꡮ\\u05B5\。뭕\\u066E\\u1CDC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1341\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{11134}｡🐮\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD34｡🐮\\u1A6A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1342\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{11134}。🐮\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD34\。🐮\\u1A6A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1343\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{ECC0B}\x{0655}。ς\x{200D}\x{0600}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDC0B\\u0655\。ς\\u200D\\u0600\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ECC0B}\x{0655}。ς\x{200D}\x{0600}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDC0B\\u0655\。ς\\u200D\\u0600\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ECC0B}\x{0655}。Σ\x{200D}\x{0600}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDC0B\\u0655\。Σ\\u200D\\u0600\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ECC0B}\x{0655}。Σ\x{200D}\x{0600}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDC0B\\u0655\。Σ\\u200D\\u0600\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ECC0B}\x{0655}。σ\x{200D}\x{0600}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDC0B\\u0655\。σ\\u200D\\u0600\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ECC0B}\x{0655}。σ\x{200D}\x{0600}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDC0B\\u0655\。σ\\u200D\\u0600\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1349\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0750}\x{066F}\x{0E3A}．\x{1714}", %p)},	undef,	"to_unicode\(\'\\u0750\\u066F\\u0E3A．\\u1714\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1350\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0750}\x{066F}\x{0E3A}.\x{1714}", %p)},	undef,	"to_unicode\(\'\\u0750\\u066F\\u0E3A\.\\u1714\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1351\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{ABB80}\x{ABAB6}\x{E9CD2}-。\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDA6E\\uDF80\\uDA6E\\uDEB6\\uDB67\\uDCD2\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABB80}\x{ABAB6}\x{E9CD2}-。\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDA6E\\uDF80\\uDA6E\\uDEB6\\uDB67\\uDCD2\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E75}．\x{1EB5F}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75．\\uD83A\\uDF5F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E75}.\x{1EB5F}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75\.\\uD83A\\uDF5F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{10AD7}｡Ↄ", %p)},	undef,	"to_unicode\(\'\-\\uD802\\uDED7｡Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{10AD7}。Ↄ", %p)},	undef,	"to_unicode\(\'\-\\uD802\\uDED7\。Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1357\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{10AD7}。ↄ", %p)},	undef,	"to_unicode\(\'\-\\uD802\\uDED7\。ↄ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1358\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{10AD7}｡ↄ", %p)},	undef,	"to_unicode\(\'\-\\uD802\\uDED7｡ↄ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1359\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。ß哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。ß哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。ß哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。ß哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1361\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。ß哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。ß哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1362\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。ß哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。ß哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1363\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。SS哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。SS哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1364\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。SS哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。SS哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1365\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1366\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1367\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。Ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。Ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1368\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}-。\x{07EE}。Ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u07EE\。Ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ V3\ V5\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1369\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。SS哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。SS哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。SS哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。SS哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。Ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。Ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{07EE}。Ss哑\x{200C}\x{10B0A}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u07EE\。Ss哑\\u200C\\uD802\\uDF0A\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒．\x{0333}\x{11134}", %p)},	undef,	"to_unicode\(\'︒．\\u0333\\uD804\\uDD34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒．\x{11134}\x{0333}", %p)},	undef,	"to_unicode\(\'︒．\\uD804\\uDD34\\u0333\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1377\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("。.\x{11134}\x{0333}", %p)},	undef,	"to_unicode\(\'\。\.\\uD804\\uDD34\\u0333\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1378\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1D174}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD74\。\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1D174}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD74\。\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1380\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}🕆｡\x{FC2D}", %p)},	undef,	"to_unicode\(\'\\u200D🕆｡\\uFC2D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1381\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}🕆｡\x{FC2D}", %p)},	undef,	"to_unicode\(\'\\u200D🕆｡\\uFC2D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1382\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}🕆。\x{0641}\x{062C}", %p)},	undef,	"to_unicode\(\'\\u200D🕆\。\\u0641\\u062C\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1383\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}🕆。\x{0641}\x{062C}", %p)},	undef,	"to_unicode\(\'\\u200D🕆\。\\u0641\\u062C\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1384\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--2w8h.xn--rgb5b", %p)},	"🕆.\x{0641}\x{062C}",	"to_unicode\(\'xn\-\-2w8h\.xn\-\-rgb5b\'\)\ \[data\/IdnaTest\.txt\:1385\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🕆.\x{0641}\x{062C}", %p)},	"🕆.\x{0641}\x{062C}",	"to_unicode\(\'🕆\.\\u0641\\u062C\'\)\ \[data\/IdnaTest\.txt\:1386\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ𝟢\x{0669}．\x{0322}ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟢\\u0669．\\u0322ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ0\x{0669}.\x{0322}ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ0\\u0669\.\\u0322ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1388\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("-ⴄ0\x{0669}.\x{0322}ς", %p)},	undef,	"to_unicode\(\'\-ⴄ0\\u0669\.\\u0322ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1389\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ0\x{0669}.\x{0322}Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ0\\u0669\.\\u0322Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1390\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("-ⴄ0\x{0669}.\x{0322}σ", %p)},	undef,	"to_unicode\(\'\-ⴄ0\\u0669\.\\u0322σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1391\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("-ⴄ𝟢\x{0669}．\x{0322}ς", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟢\\u0669．\\u0322ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1392\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ𝟢\x{0669}．\x{0322}Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟢\\u0669．\\u0322Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1393\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("-ⴄ𝟢\x{0669}．\x{0322}σ", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟢\\u0669．\\u0322σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1394\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{59404}。-", %p)},	undef,	"to_unicode\(\'\\uD925\\uDC04\。\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．\x{A2E4B}\x{1136A}ß≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6Aß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．\x{A2E4B}\x{1136A}ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6Aß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.\x{A2E4B}\x{1136A}ß≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6Aß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.\x{A2E4B}\x{1136A}ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6Aß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.\x{A2E4B}\x{1136A}SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6ASS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.\x{A2E4B}\x{1136A}SS≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6ASS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.\x{A2E4B}\x{1136A}ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6Ass\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.\x{A2E4B}\x{1136A}ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6Ass\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.\x{A2E4B}\x{1136A}Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6ASs\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.\x{A2E4B}\x{1136A}Ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\\uDA4B\\uDE4B\\uD804\\uDF6ASs\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．\x{A2E4B}\x{1136A}SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6ASS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．\x{A2E4B}\x{1136A}SS≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6ASS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．\x{A2E4B}\x{1136A}ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6Ass\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．\x{A2E4B}\x{1136A}ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6Ass\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．\x{A2E4B}\x{1136A}Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6ASs\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．\x{A2E4B}\x{1136A}Ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\\uDA4B\\uDE4B\\uD804\\uDF6ASs\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0662}｡㉗\x{10BCC}\x{BDCBA}", %p)},	undef,	"to_unicode\(\'1𐋸\\u0662｡㉗\\uD802\\uDFCC\\uDAB7\\uDCBA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0662}。27\x{10BCC}\x{BDCBA}", %p)},	undef,	"to_unicode\(\'1𐋸\\u0662\。27\\uD802\\uDFCC\\uDAB7\\uDCBA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}Ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663Ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}Ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663Ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}Ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663Ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}Ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663Ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}ⴢ\x{7F818}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663ⴢ\\uD9BE\\uDC18\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟺𐋷\x{06C1}．ᡢ\x{4B716}", %p)},	undef,	"to_unicode\(\'𝟺𐋷\\u06C1．ᡢ\\uD8ED\\uDF16\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4𐋷\x{06C1}.ᡢ\x{4B716}", %p)},	undef,	"to_unicode\(\'4𐋷\\u06C1\.ᡢ\\uD8ED\\uDF16\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-\x{071E}\x{FE23}.⒈\x{10E71}", %p)},	undef,	"to_unicode\(\'\≯\-\\u071E\\uFE23\.⒈\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-\x{071E}\x{FE23}.⒈\x{10E71}", %p)},	undef,	"to_unicode\(\'\>\\u0338\-\\u071E\\uFE23\.⒈\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-\x{071E}\x{FE23}.1.\x{10E71}", %p)},	undef,	"to_unicode\(\'\≯\-\\u071E\\uFE23\.1\.\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-\x{071E}\x{FE23}.1.\x{10E71}", %p)},	undef,	"to_unicode\(\'\>\\u0338\-\\u071E\\uFE23\.1\.\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0169}．\x{C5449}蚀", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD69．\\uDAD5\\uDC49蚀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0169}.\x{C5449}蚀", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD69\.\\uDAD5\\uDC49蚀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EFB9}Ⴘ.\x{109E5}\x{AAF6}ß\x{E0145}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDFB9Ⴘ\.\\uD802\\uDDE5\\uAAF6ß\\uDB40\\uDD45\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EFB9}ⴘ.\x{109E5}\x{AAF6}ß\x{E0145}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDFB9ⴘ\.\\uD802\\uDDE5\\uAAF6ß\\uDB40\\uDD45\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EFB9}Ⴘ.\x{109E5}\x{AAF6}SS\x{E0145}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDFB9Ⴘ\.\\uD802\\uDDE5\\uAAF6SS\\uDB40\\uDD45\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EFB9}ⴘ.\x{109E5}\x{AAF6}ss\x{E0145}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDFB9ⴘ\.\\uD802\\uDDE5\\uAAF6ss\\uDB40\\uDD45\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EFB9}Ⴘ.\x{109E5}\x{AAF6}Ss\x{E0145}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDFB9Ⴘ\.\\uD802\\uDDE5\\uAAF6Ss\\uDB40\\uDD45\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0028}\x{0605}\x{2C808}｡凬", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC28\\u0605\\uD872\\uDC08｡凬\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0028}\x{0605}\x{2C808}。凬", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC28\\u0605\\uD872\\uDC08\。凬\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⥆🄈\x{200D}ꡜ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'\⥆🄈\\u200Dꡜ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⥆🄈\x{200D}ꡜ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'\⥆🄈\\u200Dꡜ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⥆7,\x{200D}ꡜ。\x{0F84}", %p)},	undef,	"to_unicode\(\'\⥆7\,\\u200Dꡜ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⥆7,\x{200D}ꡜ。\x{0F84}", %p)},	undef,	"to_unicode\(\'\⥆7\,\\u200Dꡜ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1440\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084A}。\x{0E3A}\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u084A\。\\u0E3A\\u06A3\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1441\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{112EA}≮.\x{1E8D2}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDEEA\≮\.\\uD83A\\uDCD2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{112EA}<\x{0338}.\x{1E8D2}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDEEA\<\\u0338\.\\uD83A\\uDCD2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦．ᠺ\x{06AD}Ⴞꡍ", %p)},	undef,	"to_unicode\(\'Ⴢ\≯褦．ᠺ\\u06ADႾꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦．ᠺ\x{06AD}Ⴞꡍ", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦．ᠺ\\u06ADႾꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦.ᠺ\x{06AD}Ⴞꡍ", %p)},	undef,	"to_unicode\(\'Ⴢ\≯褦\.ᠺ\\u06ADႾꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦.ᠺ\x{06AD}Ⴞꡍ", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦\.ᠺ\\u06ADႾꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦.ᠺ\x{06AD}ⴞꡍ", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦\.ᠺ\\u06ADⴞꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦.ᠺ\x{06AD}ⴞꡍ", %p)},	undef,	"to_unicode\(\'ⴢ\≯褦\.ᠺ\\u06ADⴞꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦．ᠺ\x{06AD}ⴞꡍ", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦．ᠺ\\u06ADⴞꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦．ᠺ\x{06AD}ⴞꡍ", %p)},	undef,	"to_unicode\(\'ⴢ\≯褦．ᠺ\\u06ADⴞꡍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0F20}\x{E019A}\x{200C}\x{111C0}。ᠤᡇ\x{0721}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDF20\\uDB40\\uDD9A\\u200C\\uD804\\uDDC0\。ᠤᡇ\\u0721\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:1452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0F20}\x{E019A}\x{200C}\x{111C0}。ᠤᡇ\x{0721}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDF20\\uDB40\\uDD9A\\u200C\\uD804\\uDDC0\。ᠤᡇ\\u0721\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:1453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{167B6}\x{BDE71}-．\x{0DCA}-悜", %p)},	undef,	"to_unicode\(\'\\uD819\\uDFB6\\uDAB7\\uDE71\-．\\u0DCA\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{167B6}\x{BDE71}-.\x{0DCA}-悜", %p)},	undef,	"to_unicode\(\'\\uD819\\uDFB6\\uDAB7\\uDE71\-\.\\u0DCA\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠨ\x{BF164}\x{E0BB9}\x{07D0}.-\x{200D}\x{E0110}\x{1DCB}", %p)},	undef,	"to_unicode\(\'ᠨ\\uDABC\\uDD64\\uDB42\\uDFB9\\u07D0\.\-\\u200D\\uDB40\\uDD10\\u1DCB\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠨ\x{BF164}\x{E0BB9}\x{07D0}.-\x{200D}\x{E0110}\x{1DCB}", %p)},	undef,	"to_unicode\(\'ᠨ\\uDABC\\uDD64\\uDB42\\uDFB9\\u07D0\.\-\\u200D\\uDB40\\uDD10\\u1DCB\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{075A}Ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u075AႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{075A}Ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u075AႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{075A}Ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u075AႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{075A}Ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u075AႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1465\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("9.\x{200C}衃ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1466\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("9.\x{200C}衃ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1467\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{075A}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u075Aⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1473\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10BA9}\x{200C}。--\x{0EC8}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFA9\\u200C\。\-\-\\u0EC8\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1474\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10BA9}\x{200C}。--\x{0EC8}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFA9\\u200C\。\-\-\\u0EC8\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1475\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10EED}．\x{10AC2}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDEED．\\uD802\\uDEC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10EED}.\x{10AC2}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDEED\.\\uD802\\uDEC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1477\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0302}-．-\x{112EA}", %p)},	undef,	"to_unicode\(\'\\u0302\-．\-\\uD804\\uDEEA\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1478\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0302}-.-\x{112EA}", %p)},	undef,	"to_unicode\(\'\\u0302\-\.\-\\uD804\\uDEEA\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1479\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0F79}\x{06CF}-.\x{E0042}", %p)},	undef,	"to_unicode\(\'\\u0F79\\u06CF\-\.\\uDB40\\uDC42\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB3}\x{0F71}\x{0F80}\x{06CF}-.\x{E0042}", %p)},	undef,	"to_unicode\(\'\\u0FB3\\u0F71\\u0F80\\u06CF\-\.\\uDB40\\uDC42\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06FA}\x{FE0D}⮕\x{10E6F}.\x{1BAA}⒌\x{51BF8}", %p)},	undef,	"to_unicode\(\'\\u06FA\\uFE0D\⮕\\uD803\\uDE6F\.\\u1BAA⒌\\uD906\\uDFF8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06FA}\x{FE0D}⮕\x{10E6F}.\x{1BAA}5.\x{51BF8}", %p)},	undef,	"to_unicode\(\'\\u06FA\\uFE0D\⮕\\uD803\\uDE6F\.\\u1BAA5\.\\uD906\\uDFF8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08EB}₀。\x{E0025}\x{200C}\x{1E93A}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u08EB₀\。\\uDB40\\uDC25\\u200C\\uD83A\\uDD3A\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08EB}₀。\x{E0025}\x{200C}\x{1E93A}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u08EB₀\。\\uDB40\\uDC25\\u200C\\uD83A\\uDD3A\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08EB}0。\x{E0025}\x{200C}\x{1E93A}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u08EB0\。\\uDB40\\uDC25\\u200C\\uD83A\\uDD3A\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08EB}0。\x{E0025}\x{200C}\x{1E93A}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u08EB0\。\\uDB40\\uDC25\\u200C\\uD83A\\uDD3A\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ𐋸\x{1D178}。𝟝\x{7BAB9}\x{0E3A}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\\uD834\\uDD78\。𝟝\\uD9AE\\uDEB9\\u0E3A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ𐋸\x{1D178}。5\x{7BAB9}\x{0E3A}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\\uD834\\uDD78\。5\\uD9AE\\uDEB9\\u0E3A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ𐋸\x{1D178}。5\x{7BAB9}\x{0E3A}", %p)},	undef,	"to_unicode\(\'ⴚ𐋸\\uD834\\uDD78\。5\\uD9AE\\uDEB9\\u0E3A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ𐋸\x{1D178}。𝟝\x{7BAB9}\x{0E3A}", %p)},	undef,	"to_unicode\(\'ⴚ𐋸\\uD834\\uDD78\。𝟝\\uD9AE\\uDEB9\\u0E3A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1491\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}-ᢐ⟮.\x{1DD4}\x{11180}", %p)},	undef,	"to_unicode\(\'\\u200D\-ᢐ\⟮\.\\u1DD4\\uD804\\uDD80\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1492\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}-ᢐ⟮.\x{1DD4}\x{11180}", %p)},	undef,	"to_unicode\(\'\\u200D\-ᢐ\⟮\.\\u1DD4\\uD804\\uDD80\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1493\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠.ꡝ", %p)},	undef,	"to_unicode\(\'\≠\.ꡝ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.ꡝ", %p)},	undef,	"to_unicode\(\'\=\\u0338\.ꡝ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1495\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{069D}\x{1DCE}｡㌪", %p)},	"\x{069D}\x{1DCE}.ハイツ",	"to_unicode\(\'\\u069D\\u1DCE｡㌪\'\)\ \[data\/IdnaTest\.txt\:1496\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{069D}\x{1DCE}。ハイツ", %p)},	"\x{069D}\x{1DCE}.ハイツ",	"to_unicode\(\'\\u069D\\u1DCE\。ハイツ\'\)\ \[data\/IdnaTest\.txt\:1497\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("xn--zjb889i.xn--eck4c5a", %p)},	"\x{069D}\x{1DCE}.ハイツ",	"to_unicode\(\'xn\-\-zjb889i\.xn\-\-eck4c5a\'\)\ \[data\/IdnaTest\.txt\:1498\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{069D}\x{1DCE}.ハイツ", %p)},	"\x{069D}\x{1DCE}.ハイツ",	"to_unicode\(\'\\u069D\\u1DCE\.ハイツ\'\)\ \[data\/IdnaTest\.txt\:1499\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FE91}\x{08EF}≮.\x{116B6}-", %p)},	undef,	"to_unicode\(\'\\uFE91\\u08EF\≮\.\\uD805\\uDEB6\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE91}\x{08EF}<\x{0338}.\x{116B6}-", %p)},	undef,	"to_unicode\(\'\\uFE91\\u08EF\<\\u0338\.\\uD805\\uDEB6\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{08EF}≮.\x{116B6}-", %p)},	undef,	"to_unicode\(\'\\u0628\\u08EF\≮\.\\uD805\\uDEB6\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{08EF}<\x{0338}.\x{116B6}-", %p)},	undef,	"to_unicode\(\'\\u0628\\u08EF\<\\u0338\.\\uD805\\uDEB6\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₆榎\x{69825}\x{2D7F}｡\x{072E}\x{E0040}\x{10FD9}\x{E0966}", %p)},	undef,	"to_unicode\(\'₆榎\\uD966\\uDC25\\u2D7F｡\\u072E\\uDB40\\uDC40\\uD803\\uDFD9\\uDB42\\uDD66\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6榎\x{69825}\x{2D7F}。\x{072E}\x{E0040}\x{10FD9}\x{E0966}", %p)},	undef,	"to_unicode\(\'6榎\\uD966\\uDC25\\u2D7F\。\\u072E\\uDB40\\uDC40\\uD803\\uDFD9\\uDB42\\uDD66\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C3AB1}．\x{E63F9}", %p)},	undef,	"to_unicode\(\'\\uDACE\\uDEB1．\\uDB58\\uDFF9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C3AB1}.\x{E63F9}", %p)},	undef,	"to_unicode\(\'\\uDACE\\uDEB1\.\\uDB58\\uDFF9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡\x{075C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡\\u075C\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡\x{075C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡\\u075C\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1509\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}。。\x{075C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\。\\u075C\\u200C\'\)\ throws\ error\ C2\ A4_2\ B3\ C1\ \[data\/IdnaTest\.txt\:1510\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}。。\x{075C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\。\\u075C\\u200C\'\)\ throws\ error\ C2\ A4_2\ B3\ C1\ \[data\/IdnaTest\.txt\:1511\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--gpb", %p)},	"\x{075C}",	"to_unicode\(\'xn\-\-gpb\'\)\ \[data\/IdnaTest\.txt\:1512\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{075C}", %p)},	"\x{075C}",	"to_unicode\(\'\\u075C\'\)\ \[data\/IdnaTest\.txt\:1513\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0604}\x{200C}\x{10E6C}。\x{E0665}", %p)},	undef,	"to_unicode\(\'\\u0604\\u200C\\uD803\\uDE6C\。\\uDB41\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}\x{200C}\x{10E6C}。\x{E0665}", %p)},	undef,	"to_unicode\(\'\\u0604\\u200C\\uD803\\uDE6C\。\\uDB41\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1515\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{2D7F}\x{E0167}\x{AA7C}𝟭。-\x{061A}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\uDB40\\uDD67\\uAA7C𝟭\。\-\\u061A\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1516\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{2D7F}\x{E0167}\x{AA7C}1。-\x{061A}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\uDB40\\uDD67\\uAA7C1\。\-\\u061A\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1517\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{8CF7D}。뙏", %p)},	undef,	"to_unicode\(\'\\uD9F3\\uDF7D\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8CF7D}。뙏", %p)},	undef,	"to_unicode\(\'\\uD9F3\\uDF7D\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{698BB}\x{E0180}\x{BDDCA}ꡬ.\x{0753}", %p)},	undef,	"to_unicode\(\'\\uD966\\uDCBB\\uDB40\\uDD80\\uDAB7\\uDDCAꡬ\.\\u0753\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{D7E63}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uDB1F\\uDE63\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{D7E63}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uDB1F\\uDE63\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{D7E63}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uDB1F\\uDE63\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{D7E63}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uDB1F\\uDE63\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ皥．-", %p)},	undef,	"to_unicode\(\'ᡤ皥．\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ皥.-", %p)},	undef,	"to_unicode\(\'ᡤ皥\.\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1E9EC}\x{0944}ᡌ．⒈\x{07CC}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDDEC\\u0944ᡌ．⒈\\u07CC\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1E9EC}\x{0944}ᡌ.1.\x{07CC}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDDEC\\u0944ᡌ\.1\.\\u07CC\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{1160}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\u1160A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E01D3}\x{200D}。\x{FFA0}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDDD3\\u200D\。\\uFFA0A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0CC3}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCC3\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。ß", %p)},	undef,	"to_unicode\(\'\≯⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。ß", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。ß", %p)},	undef,	"to_unicode\(\'\≯1\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。ß", %p)},	undef,	"to_unicode\(\'\>\\u03381\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。SS", %p)},	undef,	"to_unicode\(\'\>\\u03381\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。SS", %p)},	undef,	"to_unicode\(\'\≯1\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。SS", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。SS", %p)},	undef,	"to_unicode\(\'\≯⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}｡\x{067F}-₆Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD｡\\u067F\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}｡\x{067F}-₆Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD｡\\u067F\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}。\x{067F}-6Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD\。\\u067F\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}。\x{067F}-6Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD\。\\u067F\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}。\x{067F}-6ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD\。\\u067F\-6ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}。\x{067F}-6ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD\。\\u067F\-6ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}｡\x{067F}-₆ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD｡\\u067F\-₆ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}\x{10CCD}｡\x{067F}-₆ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D\\uD803\\uDCCD｡\\u067F\-₆ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1584\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{094D}\x{FE0A}.ꡨ\x{110B9}\x{A678}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u094D\\uFE0A\.ꡨ\\uD804\\uDCB9\\uA678\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:1585\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{094D}\x{FE0A}.ꡨ\x{110B9}\x{A678}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u094D\\uFE0A\.ꡨ\\uD804\\uDCB9\\uA678\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:1586\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}Ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202DↃ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}Ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202DↃ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202DↃ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202DↃ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202Dↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202Dↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202Dↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EE8B3}\x{200D}\x{7EC51}.\x{202D}ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uDB7A\\uDCB3\\u200D\\uD9BB\\uDC51\.\\u202Dↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}ς\x{200D}𝟳。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86ς\\u200D𝟳\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}ς\x{200D}𝟳。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86ς\\u200D𝟳\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}ς\x{200D}7。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86ς\\u200D7\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}ς\x{200D}7。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86ς\\u200D7\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}Σ\x{200D}7。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86Σ\\u200D7\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}Σ\x{200D}7。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86Σ\\u200D7\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}σ\x{200D}7。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86σ\\u200D7\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}σ\x{200D}7。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86σ\\u200D7\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}Σ\x{200D}𝟳。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86Σ\\u200D𝟳\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}Σ\x{200D}𝟳。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86Σ\\u200D𝟳\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}σ\x{200D}𝟳。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86σ\\u200D𝟳\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B86}σ\x{200D}𝟳。蔑\x{78561}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF86σ\\u200D𝟳\。蔑\\uD9A1\\uDD61\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1606\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E76}.\x{10E79}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE76\.\\uD803\\uDE79\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1607\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{074E}.\x{7D91A}", %p)},	undef,	"to_unicode\(\'\-\\u074E\.\\uD9B6\\uDD1A\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{10FB5}\x{05A9}。誆⒈", %p)},	undef,	"to_unicode\(\'\≯\\uD803\\uDFB5\\u05A9\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{10FB5}\x{05A9}。誆⒈", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD803\\uDFB5\\u05A9\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{10FB5}\x{05A9}。誆1.", %p)},	undef,	"to_unicode\(\'\≯\\uD803\\uDFB5\\u05A9\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{10FB5}\x{05A9}。誆1.", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD803\\uDFB5\\u05A9\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{036B}\x{1E925}䐊\x{20E4}．︒\x{1E8A0}⇯\x{10AC1}", %p)},	undef,	"to_unicode\(\'\\u036B\\uD83A\\uDD25䐊\\u20E4．︒\\uD83A\\uDCA0\⇯\\uD802\\uDEC1\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{036B}\x{1E925}䐊\x{20E4}.。\x{1E8A0}⇯\x{10AC1}", %p)},	undef,	"to_unicode\(\'\\u036B\\uD83A\\uDD25䐊\\u20E4\.\。\\uD83A\\uDCA0\⇯\\uD802\\uDEC1\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:1614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{D1F81}.\x{200C}\x{11041}\x{601C3}۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uDB07\\uDF81\.\\u200C\\uD804\\uDC41\\uD940\\uDDC3۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{D1F81}.\x{200C}\x{11041}\x{601C3}۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uDB07\\uDF81\.\\u200C\\uD804\\uDC41\\uD940\\uDDC3۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{D1F81}.\x{200C}\x{11041}\x{601C3}۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uDB07\\uDF81\.\\u200C\\uD804\\uDC41\\uD940\\uDDC3۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{D1F81}.\x{200C}\x{11041}\x{601C3}۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uDB07\\uDF81\.\\u200C\\uD804\\uDC41\\uD940\\uDDC3۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬", %p)},	"퀬",	"to_unicode\(\'퀬\'\)\ \[data\/IdnaTest\.txt\:1619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬", %p)},	"퀬",	"to_unicode\(\'퀬\'\)\ \[data\/IdnaTest\.txt\:1620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--8n7b", %p)},	"퀬",	"to_unicode\(\'xn\-\-8n7b\'\)\ \[data\/IdnaTest\.txt\:1621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ.\x{0664}︒\x{0BCD}\x{10EA3}", %p)},	undef,	"to_unicode\(\'Ⴌ\.\\u0664︒\\u0BCD\\uD803\\uDEA3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ.\x{0664}。\x{0BCD}\x{10EA3}", %p)},	undef,	"to_unicode\(\'Ⴌ\.\\u0664\。\\u0BCD\\uD803\\uDEA3\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ.\x{0664}。\x{0BCD}\x{10EA3}", %p)},	undef,	"to_unicode\(\'ⴌ\.\\u0664\。\\u0BCD\\uD803\\uDEA3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ.\x{0664}︒\x{0BCD}\x{10EA3}", %p)},	undef,	"to_unicode\(\'ⴌ\.\\u0664︒\\u0BCD\\uD803\\uDEA3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E2C46}\x{E0D04}。\x{10FB0}\x{E0072}", %p)},	undef,	"to_unicode\(\'\\uDB4B\\uDC46\\uDB43\\uDD04\。\\uD803\\uDFB0\\uDB40\\uDC72\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1626\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}♉\x{10377}．\x{0942}\x{102F}\x{0F84}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\♉\\uD800\\uDF77．\\u0942\\u102F\\u0F84\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1627\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}♉\x{10377}．\x{0942}\x{102F}\x{0F84}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\♉\\uD800\\uDF77．\\u0942\\u102F\\u0F84\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1628\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}♉\x{10377}.\x{0942}\x{102F}\x{0F84}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\♉\\uD800\\uDF77\.\\u0942\\u102F\\u0F84\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1629\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}♉\x{10377}.\x{0942}\x{102F}\x{0F84}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\♉\\uD800\\uDF77\.\\u0942\\u102F\\u0F84\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1630\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{31416}｡🄂", %p)},	undef,	"to_unicode\(\'\\uD885\\uDC16｡🄂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{31416}。1,", %p)},	undef,	"to_unicode\(\'\\uD885\\uDC16\。1\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A951}刍.\x{E0225}", %p)},	undef,	"to_unicode\(\'\\uA951刍\.\\uDB40\\uDE25\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1633\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("♘3｡\x{A826}𝟒", %p)},	undef,	"to_unicode\(\'\♘3｡\\uA826𝟒\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1634\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("♘3。\x{A826}4", %p)},	undef,	"to_unicode\(\'\♘3\。\\uA8264\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1635\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0777}６Ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0777６Ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}６Ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0777６Ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}6Ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07776Ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}6Ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07776Ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}6ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07776ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}6ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07776ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}６ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0777６ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0777}６ⴔ辘.\x{1ED9F}\x{074F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0777６ⴔ辘\.\\uD83B\\uDD9F\\u074F\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16AF3}.\x{069B}\x{0896}\x{AFF7A}۹", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDEF3\.\\u069B\\u0896\\uDA7F\\uDF7A۹\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:1644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}≯．\x{B9D54}\x{744A1}", %p)},	undef,	"to_unicode\(\'\\uA87D\≯．\\uDAA7\\uDD54\\uD991\\uDCA1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}>\x{0338}．\x{B9D54}\x{744A1}", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338．\\uDAA7\\uDD54\\uD991\\uDCA1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}≯.\x{B9D54}\x{744A1}", %p)},	undef,	"to_unicode\(\'\\uA87D\≯\.\\uDAA7\\uDD54\\uD991\\uDCA1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}>\x{0338}.\x{B9D54}\x{744A1}", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338\.\\uDAA7\\uDD54\\uD991\\uDCA1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςო\x{06D0}.ςᡕ", %p)},	undef,	"to_unicode\(\'ςო\\u06D0\.ςᡕ\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σო\x{06D0}.Σᡕ", %p)},	undef,	"to_unicode\(\'Σო\\u06D0\.Σᡕ\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σო\x{06D0}.σᡕ", %p)},	undef,	"to_unicode\(\'σო\\u06D0\.σᡕ\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σო\x{06D0}.σᡕ", %p)},	undef,	"to_unicode\(\'Σო\\u06D0\.σᡕ\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σო\x{06D0}.ςᡕ", %p)},	undef,	"to_unicode\(\'Σო\\u06D0\.ςᡕ\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σო\x{06D0}.ςᡕ", %p)},	undef,	"to_unicode\(\'σო\\u06D0\.ςᡕ\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{83604}\x{A802}\x{108E29}\x{0636}｡\x{E08E7}", %p)},	undef,	"to_unicode\(\'\\uD9CD\\uDE04\\uA802\\uDBE3\\uDE29\\u0636｡\\uDB42\\uDCE7\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{83604}\x{A802}\x{108E29}\x{0636}。\x{E08E7}", %p)},	undef,	"to_unicode\(\'\\uD9CD\\uDE04\\uA802\\uDBE3\\uDE29\\u0636\。\\uDB42\\uDCE7\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("No.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'No\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("No.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'No\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("No.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'No\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("No.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'No\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("no.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'no\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("no.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'no\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("no.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'no\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("no.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'no\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("№．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'№．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05F5}\x{A953}．\x{10E71}\x{E0670}", %p)},	undef,	"to_unicode\(\'\\u05F5\\uA953．\\uD803\\uDE71\\uDB41\\uDE70\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05F5}\x{A953}.\x{10E71}\x{E0670}", %p)},	undef,	"to_unicode\(\'\\u05F5\\uA953\.\\uD803\\uDE71\\uDB41\\uDE70\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒊⒈\x{16F8F}。9", %p)},	undef,	"to_unicode\(\'⒊⒈\\uD81B\\uDF8F\。9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1675\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("3.1.\x{16F8F}。9", %p)},	undef,	"to_unicode\(\'3\.1\.\\uD81B\\uDF8F\。9\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1676\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{200C}\x{031B}≮．\x{10E7E}\x{8A69B}4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\≮．\\uD803\\uDE7E\\uD9E9\\uDE9B4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}≮．\x{10E7E}\x{8A69B}4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\≮．\\uD803\\uDE7E\\uD9E9\\uDE9B4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}<\x{0338}．\x{10E7E}\x{8A69B}4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\<\\u0338．\\uD803\\uDE7E\\uD9E9\\uDE9B4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}<\x{0338}．\x{10E7E}\x{8A69B}4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\<\\u0338．\\uD803\\uDE7E\\uD9E9\\uDE9B4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}≮.\x{10E7E}\x{8A69B}49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\≮\.\\uD803\\uDE7E\\uD9E9\\uDE9B49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}≮.\x{10E7E}\x{8A69B}49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\≮\.\\uD803\\uDE7E\\uD9E9\\uDE9B49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}<\x{0338}.\x{10E7E}\x{8A69B}49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\<\\u0338\.\\uD803\\uDE7E\\uD9E9\\uDE9B49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{031B}<\x{0338}.\x{10E7E}\x{8A69B}49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u031B\<\\u0338\.\\uD803\\uDE7E\\uD9E9\\uDE9B49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≯딾｡\x{10B84}", %p)},	undef,	"to_unicode\(\'\-\≯딾｡\\uD802\\uDF84\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("->\x{0338}딾｡\x{10B84}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾｡\\uD802\\uDF84\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≯딾。\x{10B84}", %p)},	undef,	"to_unicode\(\'\-\≯딾\。\\uD802\\uDF84\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("->\x{0338}딾。\x{10B84}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾\。\\uD802\\uDF84\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E09A2}⒈\x{10E62}-｡✨\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDDA2⒈\\uD803\\uDE62\-｡\✨\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E09A2}⒈\x{10E62}-｡✨\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDDA2⒈\\uD803\\uDE62\-｡\✨\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E09A2}1.\x{10E62}-。✨\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDDA21\.\\uD803\\uDE62\-\。\✨\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:1691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E09A2}1.\x{10E62}-。✨\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDDA21\.\\uD803\\uDE62\-\。\✨\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:1692\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{A80B}．\x{A8F0}", %p)},	undef,	"to_unicode\(\'\\uA80B．\\uA8F0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1693\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{A80B}.\x{A8F0}", %p)},	undef,	"to_unicode\(\'\\uA80B\.\\uA8F0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1694\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("훉≮｡\x{1BED}", %p)},	undef,	"to_unicode\(\'훉\≮｡\\u1BED\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}｡\x{1BED}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338｡\\u1BED\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉≮。\x{1BED}", %p)},	undef,	"to_unicode\(\'훉\≮\。\\u1BED\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}。\x{1BED}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338\。\\u1BED\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE06}\x{A1A7E}\x{E0C53}．\x{515BC}𝟸\x{E0134}\x{0714}", %p)},	undef,	"to_unicode\(\'\\uFE06\\uDA46\\uDE7E\\uDB43\\uDC53．\\uD905\\uDDBC𝟸\\uDB40\\uDD34\\u0714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE06}\x{A1A7E}\x{E0C53}.\x{515BC}2\x{E0134}\x{0714}", %p)},	undef,	"to_unicode\(\'\\uFE06\\uDA46\\uDE7E\\uDB43\\uDC53\.\\uD905\\uDDBC2\\uDB40\\uDD34\\u0714\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}ß\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09ß\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}ß\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09ß\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}SS\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09SS\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}SS\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09SS\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}ss\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09ss\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}ss\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09ss\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}Ss\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09Ss\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D6E09}Ss\x{0627}\x{200C}。\x{0666}\x{1EF30}\x{06CF}-", %p)},	undef,	"to_unicode\(\'\\uDB1B\\uDE09Ss\\u0627\\u200C\。\\u0666\\uD83B\\uDF30\\u06CF\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡱ。Ↄ⦞놮-", %p)},	undef,	"to_unicode\(\'ᡱ\。Ↄ\⦞놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡱ。Ↄ⦞놮-", %p)},	undef,	"to_unicode\(\'ᡱ\。Ↄ\⦞놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1710\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡱ。ↄ⦞놮-", %p)},	undef,	"to_unicode\(\'ᡱ\。ↄ\⦞놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1711\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡱ。ↄ⦞놮-", %p)},	undef,	"to_unicode\(\'ᡱ\。ↄ\⦞놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1712\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10FB0}\x{200D}.\x{D7E00}\x{0751}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB0\\u200D\.\\uDB1F\\uDE00\\u0751\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB0}\x{200D}.\x{D7E00}\x{0751}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB0\\u200D\.\\uDB1F\\uDE00\\u0751\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{1DE3}\x{08BA}≯。\x{E01CB}℘\x{1071}", %p)},	undef,	"to_unicode\(\'Ⴜ\\u1DE3\\u08BA\≯\。\\uDB40\\uDDCB℘\\u1071\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{1DE3}\x{08BA}>\x{0338}。\x{E01CB}℘\x{1071}", %p)},	undef,	"to_unicode\(\'Ⴜ\\u1DE3\\u08BA\>\\u0338\。\\uDB40\\uDDCB℘\\u1071\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{1DE3}\x{08BA}>\x{0338}。\x{E01CB}℘\x{1071}", %p)},	undef,	"to_unicode\(\'ⴜ\\u1DE3\\u08BA\>\\u0338\。\\uDB40\\uDDCB℘\\u1071\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{1DE3}\x{08BA}≯。\x{E01CB}℘\x{1071}", %p)},	undef,	"to_unicode\(\'ⴜ\\u1DE3\\u08BA\≯\。\\uDB40\\uDDCB℘\\u1071\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋵。\x{10E15}", %p)},	undef,	"to_unicode\(\'𐋵\。\\uD803\\uDE15\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{ABE8}．\x{DF285}\x{08F8}\x{2E48}\x{EB10F}", %p)},	undef,	"to_unicode\(\'\≮\\uABE8．\\uDB3C\\uDE85\\u08F8\\u2E48\\uDB6C\\uDD0F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{ABE8}．\x{DF285}\x{08F8}\x{2E48}\x{EB10F}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uABE8．\\uDB3C\\uDE85\\u08F8\\u2E48\\uDB6C\\uDD0F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{ABE8}.\x{DF285}\x{08F8}\x{2E48}\x{EB10F}", %p)},	undef,	"to_unicode\(\'\≮\\uABE8\.\\uDB3C\\uDE85\\u08F8\\u2E48\\uDB6C\\uDD0F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{ABE8}.\x{DF285}\x{08F8}\x{2E48}\x{EB10F}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uABE8\.\\uDB3C\\uDE85\\u08F8\\u2E48\\uDB6C\\uDD0F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1723\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1B71}\x{035F}\x{0752}．\x{09C2}\x{0664}⛍", %p)},	undef,	"to_unicode\(\'\\u1B71\\u035F\\u0752．\\u09C2\\u0664\⛍\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1B71}\x{035F}\x{0752}.\x{09C2}\x{0664}⛍", %p)},	undef,	"to_unicode\(\'\\u1B71\\u035F\\u0752\.\\u09C2\\u0664\⛍\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1725\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FBCE}\x{06C2}\x{200C}\x{08A0}．\x{0B4D}\x{0656}", %p)},	undef,	"to_unicode\(\'\\uFBCE\\u06C2\\u200C\\u08A0．\\u0B4D\\u0656\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FBCE}\x{06C1}\x{0654}\x{200C}\x{08A0}．\x{0B4D}\x{0656}", %p)},	undef,	"to_unicode\(\'\\uFBCE\\u06C1\\u0654\\u200C\\u08A0．\\u0B4D\\u0656\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FBCE}\x{06C2}\x{200C}\x{08A0}.\x{0B4D}\x{0656}", %p)},	undef,	"to_unicode\(\'\\uFBCE\\u06C2\\u200C\\u08A0\.\\u0B4D\\u0656\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FBCE}\x{06C1}\x{0654}\x{200C}\x{08A0}.\x{0B4D}\x{0656}", %p)},	undef,	"to_unicode\(\'\\uFBCE\\u06C1\\u0654\\u200C\\u08A0\.\\u0B4D\\u0656\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115BF}｡\x{200D}\x{CE918}\x{E099F}\x{13656}", %p)},	undef,	"to_unicode\(\'\\uD805\\uDDBF｡\\u200D\\uDAFA\\uDD18\\uDB42\\uDD9F\\uD80D\\uDE56\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115BF}｡\x{200D}\x{CE918}\x{E099F}\x{13656}", %p)},	undef,	"to_unicode\(\'\\uD805\\uDDBF｡\\u200D\\uDAFA\\uDD18\\uDB42\\uDD9F\\uD80D\\uDE56\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115BF}。\x{200D}\x{CE918}\x{E099F}\x{13656}", %p)},	undef,	"to_unicode\(\'\\uD805\\uDDBF\。\\u200D\\uDAFA\\uDD18\\uDB42\\uDD9F\\uD80D\\uDE56\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115BF}。\x{200D}\x{CE918}\x{E099F}\x{13656}", %p)},	undef,	"to_unicode\(\'\\uD805\\uDDBF\。\\u200D\\uDAFA\\uDD18\\uDB42\\uDD9F\\uD80D\\uDE56\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{10896}。⒚", %p)},	undef,	"to_unicode\(\'\-\\uD802\\uDC96\。⒚\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1734\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{10896}。19.", %p)},	undef,	"to_unicode\(\'\-\\uD802\\uDC96\。19\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1735\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A8F4D}\x{0678}\x{200C}｡\x{06B8}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDA63\\uDF4D\\u0678\\u200C｡\\u06B8\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8F4D}\x{0678}\x{200C}｡\x{06B8}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDA63\\uDF4D\\u0678\\u200C｡\\u06B8\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8F4D}\x{064A}\x{0674}\x{200C}。\x{06B8}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDA63\\uDF4D\\u064A\\u0674\\u200C\。\\u06B8\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8F4D}\x{064A}\x{0674}\x{200C}。\x{06B8}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDA63\\uDF4D\\u064A\\u0674\\u200C\。\\u06B8\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1739\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ß\x{E016E}\x{0F72}。ꡁ8₅", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'ß\\uDB40\\uDD6E\\u0F72\。ꡁ8₅\'\)\ \[data\/IdnaTest\.txt\:1740\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ß\x{E016E}\x{0F72}。ꡁ8₅", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'ß\\uDB40\\uDD6E\\u0F72\。ꡁ8₅\'\)\ \[data\/IdnaTest\.txt\:1741\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ß\x{E016E}\x{0F72}。ꡁ85", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'ß\\uDB40\\uDD6E\\u0F72\。ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1742\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ß\x{E016E}\x{0F72}。ꡁ85", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'ß\\uDB40\\uDD6E\\u0F72\。ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1743\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("SS\x{E016E}\x{0F72}。ꡁ85", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'SS\\uDB40\\uDD6E\\u0F72\。ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1744\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ss\x{E016E}\x{0F72}。ꡁ85", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'ss\\uDB40\\uDD6E\\u0F72\。ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1745\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Ss\x{E016E}\x{0F72}。ꡁ85", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'Ss\\uDB40\\uDD6E\\u0F72\。ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1746\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--ss-9mj.xn--85-9f9h", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'xn\-\-ss\-9mj\.xn\-\-85\-9f9h\'\)\ \[data\/IdnaTest\.txt\:1747\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ss\x{0F72}.ꡁ85", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'ss\\u0F72\.ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1748\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("SS\x{0F72}.ꡁ85", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'SS\\u0F72\.ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1749\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Ss\x{0F72}.ꡁ85", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'Ss\\u0F72\.ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1750\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--zca675e.xn--85-9f9h", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'xn\-\-zca675e\.xn\-\-85\-9f9h\'\)\ \[data\/IdnaTest\.txt\:1751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ß\x{0F72}.ꡁ85", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'ß\\u0F72\.ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ß\x{0F72}.ꡁ85", %p)},	"ß\x{0F72}.ꡁ85",	"to_unicode\(\'ß\\u0F72\.ꡁ85\'\)\ \[data\/IdnaTest\.txt\:1753\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("SS\x{E016E}\x{0F72}。ꡁ8₅", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'SS\\uDB40\\uDD6E\\u0F72\。ꡁ8₅\'\)\ \[data\/IdnaTest\.txt\:1754\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ss\x{E016E}\x{0F72}。ꡁ8₅", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'ss\\uDB40\\uDD6E\\u0F72\。ꡁ8₅\'\)\ \[data\/IdnaTest\.txt\:1755\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Ss\x{E016E}\x{0F72}。ꡁ8₅", %p)},	"ss\x{0F72}.ꡁ85",	"to_unicode\(\'Ss\\uDB40\\uDD6E\\u0F72\。ꡁ8₅\'\)\ \[data\/IdnaTest\.txt\:1756\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅𝟣．₃\x{066C}ß", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅𝟣．₃\\u066Cß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1757\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅1.3\x{066C}ß", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅1\.3\\u066Cß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1758\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅1.3\x{066C}SS", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅1\.3\\u066CSS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1759\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅1.3\x{066C}ss", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅1\.3\\u066Css\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1760\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅1.3\x{066C}Ss", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅1\.3\\u066CSs\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1761\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅𝟣．₃\x{066C}SS", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅𝟣．₃\\u066CSS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1762\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅𝟣．₃\x{066C}ss", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅𝟣．₃\\u066Css\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1763\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A953}\x{2DFD}魅𝟣．₃\x{066C}Ss", %p)},	undef,	"to_unicode\(\'\\uA953\\u2DFD魅𝟣．₃\\u066CSs\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1764\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0751}｡\x{114C2}⒈\x{ABED}\x{E0EB2}", %p)},	undef,	"to_unicode\(\'\\u0751｡\\uD805\\uDCC2⒈\\uABED\\uDB43\\uDEB2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0751}。\x{114C2}1.\x{ABED}\x{E0EB2}", %p)},	undef,	"to_unicode\(\'\\u0751\。\\uD805\\uDCC21\.\\uABED\\uDB43\\uDEB2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1766\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{10A01}છ。嵨", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE01છ\。嵨\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1767\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴔ≠Ⴀ.\x{10E76}\x{10E71}", %p)},	undef,	"to_unicode\(\'Ⴔ\≠Ⴀ\.\\uD803\\uDE76\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ=\x{0338}Ⴀ.\x{10E76}\x{10E71}", %p)},	undef,	"to_unicode\(\'Ⴔ\=\\u0338Ⴀ\.\\uD803\\uDE76\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ=\x{0338}ⴀ.\x{10E76}\x{10E71}", %p)},	undef,	"to_unicode\(\'ⴔ\=\\u0338ⴀ\.\\uD803\\uDE76\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ≠ⴀ.\x{10E76}\x{10E71}", %p)},	undef,	"to_unicode\(\'ⴔ\≠ⴀ\.\\uD803\\uDE76\\uD803\\uDE71\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙\x{0313}｡\x{0652}", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙\\u0313｡\\u0652\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙\x{0313}｡\x{0652}", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙\\u0313｡\\u0652\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}18.\x{0313}。\x{0652}", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.\\u0313\。\\u0652\'\)\ throws\ error\ V3\ V5\ C1\ \[data\/IdnaTest\.txt\:1774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}18.\x{0313}。\x{0652}", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.\\u0313\。\\u0652\'\)\ throws\ error\ V3\ V5\ C1\ \[data\/IdnaTest\.txt\:1775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.ʌᢟ-\x{10E72}", %p)},	undef,	"to_unicode\(\'︒\.ʌᢟ\-\\uD803\\uDE72\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1776\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("。.ʌᢟ-\x{10E72}", %p)},	undef,	"to_unicode\(\'\。\.ʌᢟ\-\\uD803\\uDE72\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("。.Ʌᢟ-\x{10E72}", %p)},	undef,	"to_unicode\(\'\。\.Ʌᢟ\-\\uD803\\uDE72\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1778\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒.Ʌᢟ-\x{10E72}", %p)},	undef,	"to_unicode\(\'︒\.Ʌᢟ\-\\uD803\\uDE72\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A949}︒。\x{E34FE}\x{E0029}", %p)},	undef,	"to_unicode\(\'\\uA949︒\。\\uDB4D\\uDCFE\\uDB40\\uDC29\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A949}。。\x{E34FE}\x{E0029}", %p)},	undef,	"to_unicode\(\'\\uA949\。\。\\uDB4D\\uDCFE\\uDB40\\uDC29\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA65}ß\x{1017AC}。ᡴ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE65ß\\uDBC5\\uDFAC\。ᡴ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA65}SS\x{1017AC}。ᡴ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE65SS\\uDBC5\\uDFAC\。ᡴ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA65}ss\x{1017AC}。ᡴ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE65ss\\uDBC5\\uDFAC\。ᡴ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA65}Ss\x{1017AC}。ᡴ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE65Ss\\uDBC5\\uDFAC\。ᡴ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}\x{200D}\x{10AD8}\x{10E79}。\x{5E1A1}\x{DC0DB}\x{200C}\x{E01C4}", %p)},	undef,	"to_unicode\(\'\\uABED\\u200D\\uD802\\uDED8\\uD803\\uDE79\。\\uD938\\uDDA1\\uDB30\\uDCDB\\u200C\\uDB40\\uDDC4\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}\x{200D}\x{10AD8}\x{10E79}。\x{5E1A1}\x{DC0DB}\x{200C}\x{E01C4}", %p)},	undef,	"to_unicode\(\'\\uABED\\u200D\\uD802\\uDED8\\uD803\\uDE79\。\\uD938\\uDDA1\\uDB30\\uDCDB\\u200C\\uDB40\\uDDC4\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0746}．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDF46．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}｡≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}｡≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}。≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}。≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E9}\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07E9\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E69}\x{1EB7D}\x{10A05}\x{BFA3B}。\x{0737}🄀", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\\uD83A\\uDF7D\\uD802\\uDE05\\uDABE\\uDE3B\。\\u0737🄀\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E69}\x{1EB7D}\x{10A05}\x{BFA3B}。\x{0737}0.", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\\uD83A\\uDF7D\\uD802\\uDE05\\uDABE\\uDE3B\。\\u07370\.\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᢤ\x{B73B1}Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᢤ\x{B73B1}Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᢤ\x{B73B1}σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᢤ\x{B73B1}σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᢤ\\uDA9C\\uDFB1σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᢤ\x{B73B1}ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᢤ\x{B73B1}Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᢤ\x{B73B1}Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᢤ\x{B73B1}σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᢤ\x{B73B1}σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᢤ\\uDA9C\\uDFB1σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EA4B4}\x{0FB6}.Ⴕ", %p)},	undef,	"to_unicode\(\'\\uDB69\\uDCB4\\u0FB6\.Ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EA4B4}\x{0FB6}.ⴕ", %p)},	undef,	"to_unicode\(\'\\uDB69\\uDCB4\\u0FB6\.ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{1D182}\x{FD37}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\uD834\\uDD82\\uFD37\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{1D182}\x{FD37}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\uD834\\uDD82\\uFD37\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1D182}\x{FD37}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD834\\uDD82\\uFD37\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1D182}\x{FD37}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD834\\uDD82\\uFD37\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{1D182}\x{0634}\x{062C}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\uD834\\uDD82\\u0634\\u062C\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{1D182}\x{0634}\x{062C}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\uD834\\uDD82\\u0634\\u062C\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1D182}\x{0634}\x{062C}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD834\\uDD82\\u0634\\u062C\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1D182}\x{0634}\x{062C}。\x{200C}\x{AAF6}\x{009D}\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD834\\uDD82\\u0634\\u062C\。\\u200C\\uAAF6\\u009D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DD4}｡\x{10F4A5}", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DD4｡\\uDBFD\\uDCA5\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DD4}｡\x{10F4A5}", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DD4｡\\uDBFD\\uDCA5\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DD4}。\x{10F4A5}", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DD4\。\\uDBFD\\uDCA5\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DD4}。\x{10F4A5}", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DD4\。\\uDBFD\\uDCA5\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E016D}焅.\x{9D6CA}\x{200D}\x{07DA}", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDD6D焅\.\\uDA35\\uDECA\\u200D\\u07DA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E016D}焅.\x{9D6CA}\x{200D}\x{07DA}", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDD6D焅\.\\uDA35\\uDECA\\u200D\\u07DA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E016D}焅.\x{9D6CA}\x{200D}\x{07DA}", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDD6D焅\.\\uDA35\\uDECA\\u200D\\u07DA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E016D}焅.\x{9D6CA}\x{200D}\x{07DA}", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDD6D焅\.\\uDA35\\uDECA\\u200D\\u07DA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11128}ς≮.ς\x{1DD3}ᠼ0", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD28ς\≮\.ς\\u1DD3ᠼ0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11128}ς<\x{0338}.ς\x{1DD3}ᠼ0", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD28ς\<\\u0338\.ς\\u1DD3ᠼ0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11128}Σ<\x{0338}.Σ\x{1DD3}ᠼ0", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD28Σ\<\\u0338\.Σ\\u1DD3ᠼ0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11128}Σ≮.Σ\x{1DD3}ᠼ0", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD28Σ\≮\.Σ\\u1DD3ᠼ0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11128}σ≮.σ\x{1DD3}ᠼ0", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD28σ\≮\.σ\\u1DD3ᠼ0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11128}σ<\x{0338}.σ\x{1DD3}ᠼ0", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD28σ\<\\u0338\.σ\\u1DD3ᠼ0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5F8F6}ß\x{0AC4}\x{06BC}.\x{2DE0}ꡌ", %p)},	undef,	"to_unicode\(\'\\uD93E\\uDCF6ß\\u0AC4\\u06BC\.\\u2DE0ꡌ\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5F8F6}SS\x{0AC4}\x{06BC}.\x{2DE0}ꡌ", %p)},	undef,	"to_unicode\(\'\\uD93E\\uDCF6SS\\u0AC4\\u06BC\.\\u2DE0ꡌ\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5F8F6}ss\x{0AC4}\x{06BC}.\x{2DE0}ꡌ", %p)},	undef,	"to_unicode\(\'\\uD93E\\uDCF6ss\\u0AC4\\u06BC\.\\u2DE0ꡌ\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5F8F6}Ss\x{0AC4}\x{06BC}.\x{2DE0}ꡌ", %p)},	undef,	"to_unicode\(\'\\uD93E\\uDCF6Ss\\u0AC4\\u06BC\.\\u2DE0ꡌ\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{06FC}｡⒈", %p)},	undef,	"to_unicode\(\'\-\\u06FC｡⒈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{06FC}。1.", %p)},	undef,	"to_unicode\(\'\-\\u06FC\。1\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1875\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("壾\x{10AD2}𝟡。ꡑ\x{09CD}", %p)},	undef,	"to_unicode\(\'壾\\uD802\\uDED2𝟡\。ꡑ\\u09CD\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:1876\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("壾\x{10AD2}9。ꡑ\x{09CD}", %p)},	undef,	"to_unicode\(\'壾\\uD802\\uDED29\。ꡑ\\u09CD\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:1877\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E68}\x{071E}\x{10E7D}\x{FEFF}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68\\u071E\\uD803\\uDE7D\\uFEFF\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1878\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E68}\x{071E}\x{10E7D}\x{FEFF}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68\\u071E\\uD803\\uDE7D\\uFEFF\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1879\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟘．Ⴇ\x{ACA50}\x{1EDF6}\x{A852D}", %p)},	undef,	"to_unicode\(\'𝟘．Ⴇ\\uDA72\\uDE50\\uD83B\\uDDF6\\uDA61\\uDD2D\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.Ⴇ\x{ACA50}\x{1EDF6}\x{A852D}", %p)},	undef,	"to_unicode\(\'0\.Ⴇ\\uDA72\\uDE50\\uD83B\\uDDF6\\uDA61\\uDD2D\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.ⴇ\x{ACA50}\x{1EDF6}\x{A852D}", %p)},	undef,	"to_unicode\(\'0\.ⴇ\\uDA72\\uDE50\\uD83B\\uDDF6\\uDA61\\uDD2D\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟘．ⴇ\x{ACA50}\x{1EDF6}\x{A852D}", %p)},	undef,	"to_unicode\(\'𝟘．ⴇ\\uDA72\\uDE50\\uD83B\\uDDF6\\uDA61\\uDD2D\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1883\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10A3F}💗.\x{0EB8}ꡪ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE3F💗\.\\u0EB8ꡪ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1884\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-\x{10AD9}.\x{5F549}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\uD802\\uDED9\.\\uD93D\\uDD49\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-\x{10AD9}.\x{5F549}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\uD802\\uDED9\.\\uD93D\\uDD49\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0622}\x{075B}寐｡\x{200C}≯\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0622\\u075B寐｡\\u200C\≯\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0622}\x{075B}寐｡\x{200C}≯\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0622\\u075B寐｡\\u200C\≯\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0627}\x{0653}\x{075B}寐｡\x{200C}>\x{0338}\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0627\\u0653\\u075B寐｡\\u200C\>\\u0338\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0627}\x{0653}\x{075B}寐｡\x{200C}>\x{0338}\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0627\\u0653\\u075B寐｡\\u200C\>\\u0338\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0622}\x{075B}寐。\x{200C}≯\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0622\\u075B寐\。\\u200C\≯\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0622}\x{075B}寐。\x{200C}≯\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0622\\u075B寐\。\\u200C\≯\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0627}\x{0653}\x{075B}寐。\x{200C}>\x{0338}\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0627\\u0653\\u075B寐\。\\u200C\>\\u0338\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{0627}\x{0653}\x{075B}寐。\x{200C}>\x{0338}\x{E0BAE}", %p)},	undef,	"to_unicode\(\'ᡀ\\u0627\\u0653\\u075B寐\。\\u200C\>\\u0338\\uDB42\\uDFAE\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{56DEC}ႺႴ\x{FEC9}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uD91B\\uDDECႺႴ\\uFEC9\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{56DEC}ႺႴ\x{FEC9}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uD91B\\uDDECႺႴ\\uFEC9\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{56DEC}ႺႴ\x{0639}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uD91B\\uDDECႺႴ\\u0639\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{56DEC}ႺႴ\x{0639}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uD91B\\uDDECႺႴ\\u0639\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{56DEC}ⴚⴔ\x{0639}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uD91B\\uDDECⴚⴔ\\u0639\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{56DEC}ⴚⴔ\x{0639}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uD91B\\uDDECⴚⴔ\\u0639\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{56DEC}Ⴚⴔ\x{0639}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uD91B\\uDDECႺⴔ\\u0639\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{56DEC}Ⴚⴔ\x{0639}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\uD91B\\uDDECႺⴔ\\u0639\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{56DEC}ⴚⴔ\x{FEC9}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uD91B\\uDDECⴚⴔ\\uFEC9\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{56DEC}ⴚⴔ\x{FEC9}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uD91B\\uDDECⴚⴔ\\uFEC9\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{56DEC}Ⴚⴔ\x{FEC9}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uD91B\\uDDECႺⴔ\\uFEC9\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{56DEC}Ⴚⴔ\x{FEC9}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uD91B\\uDDECႺⴔ\\uFEC9\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1906\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("-3.\x{200D}ヌ\x{0852}", %p)},	undef,	"to_unicode\(\'\-3\.\\u200Dヌ\\u0852\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1907\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("-3.\x{200D}ヌ\x{0852}", %p)},	undef,	"to_unicode\(\'\-3\.\\u200Dヌ\\u0852\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1908\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ß\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ß\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ß\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ß\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ß\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ß\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ß\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ß\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}SS\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665SS\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}SS\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665SS\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ss\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ss\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ss\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ss\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}Ss\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665Ss\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}Ss\x{200D}。\x{0020}\x{0304}\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665Ss\\u200D\。\\u0020\\u0304\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}SS\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665SS\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}SS\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665SS\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ss\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ss\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}ss\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665ss\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}Ss\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665Ss\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E014E}\x{0665}Ss\x{200D}。￣\x{743DF}\x{10C88}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4E\\u0665Ss\\u200D\。￣\\uD990\\uDFDF\\uD803\\uDC88\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꇟ-\x{10D4F}ᠰ。乤\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\uD803\\uDD4Fᠰ\。乤\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꇟ-\x{10D4F}ᠰ。乤\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\uD803\\uDD4Fᠰ\。乤\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066C}.\x{E012E}\x{1EE07}\x{1DE7}\x{ECB7D}", %p)},	undef,	"to_unicode\(\'\\u066C\.\\uDB40\\uDD2E\\uD83B\\uDE07\\u1DE7\\uDB72\\uDF7D\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066C}.\x{E012E}\x{062D}\x{1DE7}\x{ECB7D}", %p)},	undef,	"to_unicode\(\'\\u066C\.\\uDB40\\uDD2E\\u062D\\u1DE7\\uDB72\\uDF7D\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{C935F}\x{0762}\x{1BAA}", %p)},	undef,	"to_unicode\(\'\-\.\\uDAE4\\uDF5F\\u0762\\u1BAA\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:1929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}ς.\x{1EBA7}녫ß", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34ς\.\\uD83A\\uDFA7녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}ς.\x{1EBA7}녫ß", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34ς\.\\uD83A\\uDFA7녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}Σ.\x{1EBA7}녫SS", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34Σ\.\\uD83A\\uDFA7녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}Σ.\x{1EBA7}녫SS", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34Σ\.\\uD83A\\uDFA7녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}σ.\x{1EBA7}녫ss", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34σ\.\\uD83A\\uDFA7녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}σ.\x{1EBA7}녫ss", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34σ\.\\uD83A\\uDFA7녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}Σ.\x{1EBA7}녫Ss", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34Σ\.\\uD83A\\uDFA7녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{8E634}Σ.\x{1EBA7}녫Ss", %p)},	undef,	"to_unicode\(\'\\uD9F9\\uDE34Σ\.\\uD83A\\uDFA7녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{0BCD}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u0BCD\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{0BCD}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u0BCD\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{115BF}\x{094D}\x{93A95}．\x{200C}\x{2D7F}\x{075F}", %p)},	undef,	"to_unicode\(\'𐋺\\uD805\\uDDBF\\u094D\\uDA0E\\uDE95．\\u200C\\u2D7F\\u075F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{115BF}\x{094D}\x{93A95}．\x{200C}\x{2D7F}\x{075F}", %p)},	undef,	"to_unicode\(\'𐋺\\uD805\\uDDBF\\u094D\\uDA0E\\uDE95．\\u200C\\u2D7F\\u075F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{115BF}\x{094D}\x{93A95}.\x{200C}\x{2D7F}\x{075F}", %p)},	undef,	"to_unicode\(\'𐋺\\uD805\\uDDBF\\u094D\\uDA0E\\uDE95\.\\u200C\\u2D7F\\u075F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{115BF}\x{094D}\x{93A95}.\x{200C}\x{2D7F}\x{075F}", %p)},	undef,	"to_unicode\(\'𐋺\\uD805\\uDDBF\\u094D\\uDA0E\\uDE95\.\\u200C\\u2D7F\\u075F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{72E4F}\x{08EA}．≯", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDE4F\\u08EA．\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{72E4F}\x{08EA}．>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDE4F\\u08EA．\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{72E4F}\x{08EA}.≯", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDE4F\\u08EA\.\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{72E4F}\x{08EA}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDE4F\\u08EA\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}Ⴓ．\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6FႳ．\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}Ⴓ．\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6FႳ．\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}Ⴓ.\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6FႳ\.\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}Ⴓ.\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6FႳ\.\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}ⴓ.\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6Fⴓ\.\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}ⴓ.\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6Fⴓ\.\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}ⴓ．\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6Fⴓ．\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{10C6F}ⴓ．\x{E0136}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDC6Fⴓ．\\uDB40\\uDD36\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1969\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}ß\x{11131}．ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0Bß\\uD804\\uDD31．ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1970\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}ß\x{11131}.ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0Bß\\uD804\\uDD31\.ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1971\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}SS\x{11131}.ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0BSS\\uD804\\uDD31\.ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1972\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}ss\x{11131}.ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0Bss\\uD804\\uDD31\.ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1973\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}Ss\x{11131}.ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0BSs\\uD804\\uDD31\.ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1974\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}SS\x{11131}．ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0BSS\\uD804\\uDD31．ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1975\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}ss\x{11131}．ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0Bss\\uD804\\uDD31．ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1976\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1080B}Ss\x{11131}．ᠷ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC0BSs\\uD804\\uDD31．ᠷ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1977\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A806}\x{1D173}鸮\x{A806}.ς", %p)},	undef,	"to_unicode\(\'\\uA806\\uD834\\uDD73鸮\\uA806\.ς\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A806}\x{1D173}鸮\x{A806}.Σ", %p)},	undef,	"to_unicode\(\'\\uA806\\uD834\\uDD73鸮\\uA806\.Σ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A806}\x{1D173}鸮\x{A806}.σ", %p)},	undef,	"to_unicode\(\'\\uA806\\uD834\\uDD73鸮\\uA806\.σ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒗\x{067B}。-\x{A806}", %p)},	undef,	"to_unicode\(\'⒗\\u067B\。\-\\uA806\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1981\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("16.\x{067B}。-\x{A806}", %p)},	undef,	"to_unicode\(\'16\.\\u067B\。\-\\uA806\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1982\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡏ\x{06A9}\x{E038D}｡\x{10E61}ᢨ⒈", %p)},	undef,	"to_unicode\(\'ꡏ\\u06A9\\uDB40\\uDF8D｡\\uD803\\uDE61ᢨ⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ\x{06A9}\x{E038D}。\x{10E61}ᢨ1.", %p)},	undef,	"to_unicode\(\'ꡏ\\u06A9\\uDB40\\uDF8D\。\\uD803\\uDE61ᢨ1\.\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2433}串𝟧\x{10E76}.ᡲ8\x{309A}\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u2433串𝟧\\uD803\\uDE76\.ᡲ8\\u309A\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2433}串𝟧\x{10E76}.ᡲ8\x{309A}\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u2433串𝟧\\uD803\\uDE76\.ᡲ8\\u309A\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2433}串5\x{10E76}.ᡲ8\x{309A}\x{10E7B}", %p)},	undef,	"to_unicode\(\'\\u2433串5\\uD803\\uDE76\.ᡲ8\\u309A\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7A}.🄀⒒-\x{8A0EC}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7A\.🄀⒒\-\\uD9E8\\uDCEC\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7A}.0.11.-\x{8A0EC}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7A\.0\.11\.\-\\uD9E8\\uDCEC\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11133}-\x{0F72}．\x{206B}Ⴄ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD33\-\\u0F72．\\u206BႤ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11133}-\x{0F72}.\x{206B}Ⴄ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD33\-\\u0F72\.\\u206BႤ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11133}-\x{0F72}.\x{206B}ⴄ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD33\-\\u0F72\.\\u206Bⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11133}-\x{0F72}．\x{206B}ⴄ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD33\-\\u0F72．\\u206Bⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{15BE2}⊊ᢡ\x{FB41}｡⊵⒈", %p)},	undef,	"to_unicode\(\'\\uD816\\uDFE2\⊊ᢡ\\uFB41｡\⊵⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{15BE2}⊊ᢡ\x{05E1}\x{05BC}｡⊵⒈", %p)},	undef,	"to_unicode\(\'\\uD816\\uDFE2\⊊ᢡ\\u05E1\\u05BC｡\⊵⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{15BE2}⊊ᢡ\x{05E1}\x{05BC}。⊵1.", %p)},	undef,	"to_unicode\(\'\\uD816\\uDFE2\⊊ᢡ\\u05E1\\u05BC\。\⊵1\.\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2008\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{E0121}．ꡭ\x{1A5C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD21．ꡭ\\u1A5C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2009\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{E0121}．ꡭ\x{1A5C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD21．ꡭ\\u1A5C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2010\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{E0121}.ꡭ\x{1A5C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD21\.ꡭ\\u1A5C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2011\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{E0121}.ꡭ\x{1A5C}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD21\.ꡭ\\u1A5C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2012\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--fof1427d", %p)},	"ꡭ\x{1A5C}",	"to_unicode\(\'xn\-\-fof1427d\'\)\ \[data\/IdnaTest\.txt\:2013\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ꡭ\x{1A5C}", %p)},	"ꡭ\x{1A5C}",	"to_unicode\(\'ꡭ\\u1A5C\'\)\ \[data\/IdnaTest\.txt\:2014\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{B8437}\x{0690}≮\x{0B4D}．\x{10A29}", %p)},	undef,	"to_unicode\(\'\\uDAA1\\uDC37\\u0690\≮\\u0B4D．\\uD802\\uDE29\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B8437}\x{0690}<\x{0338}\x{0B4D}．\x{10A29}", %p)},	undef,	"to_unicode\(\'\\uDAA1\\uDC37\\u0690\<\\u0338\\u0B4D．\\uD802\\uDE29\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B8437}\x{0690}≮\x{0B4D}.\x{10A29}", %p)},	undef,	"to_unicode\(\'\\uDAA1\\uDC37\\u0690\≮\\u0B4D\.\\uD802\\uDE29\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B8437}\x{0690}<\x{0338}\x{0B4D}.\x{10A29}", %p)},	undef,	"to_unicode\(\'\\uDAA1\\uDC37\\u0690\<\\u0338\\u0B4D\.\\uD802\\uDE29\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{1085}⒈ꡍ\x{BAE34}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u1085⒈ꡍ\\uDAAB\\uDE34\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{1085}⒈ꡍ\x{BAE34}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u1085⒈ꡍ\\uDAAB\\uDE34\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{1085}1.ꡍ\x{BAE34}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u10851\.ꡍ\\uDAAB\\uDE34\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{1085}1.ꡍ\x{BAE34}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u10851\.ꡍ\\uDAAB\\uDE34\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₈\x{10B85}．\x{1ECD7}≠", %p)},	undef,	"to_unicode\(\'₈\\uD802\\uDF85．\\uD83B\\uDCD7\≠\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₈\x{10B85}．\x{1ECD7}=\x{0338}", %p)},	undef,	"to_unicode\(\'₈\\uD802\\uDF85．\\uD83B\\uDCD7\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{10B85}.\x{1ECD7}≠", %p)},	undef,	"to_unicode\(\'8\\uD802\\uDF85\.\\uD83B\\uDCD7\≠\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{10B85}.\x{1ECD7}=\x{0338}", %p)},	undef,	"to_unicode\(\'8\\uD802\\uDF85\.\\uD83B\\uDCD7\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10ACE}\x{063C}\x{CCEE4}.⒒\x{071A}\x{0B62}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDECE\\u063C\\uDAF3\\uDEE4\.⒒\\u071A\\u0B62\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10ACE}\x{063C}\x{CCEE4}.11.\x{071A}\x{0B62}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDECE\\u063C\\uDAF3\\uDEE4\.11\.\\u071A\\u0B62\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A47}-\x{10E62}𝟜.🗾\x{0FA9}⒏", %p)},	undef,	"to_unicode\(\'\\u0A47\-\\uD803\\uDE62𝟜\.🗾\\u0FA9⒏\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2029\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0A47}-\x{10E62}4.🗾\x{0FA9}8.", %p)},	undef,	"to_unicode\(\'\\u0A47\-\\uD803\\uDE624\.🗾\\u0FA98\.\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2030\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⫐｡Ⴠ-\x{5AB58}", %p)},	undef,	"to_unicode\(\'\⫐｡Ⴠ\-\\uD92A\\uDF58\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐。Ⴠ-\x{5AB58}", %p)},	undef,	"to_unicode\(\'\⫐\。Ⴠ\-\\uD92A\\uDF58\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐。ⴠ-\x{5AB58}", %p)},	undef,	"to_unicode\(\'\⫐\。ⴠ\-\\uD92A\\uDF58\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐｡ⴠ-\x{5AB58}", %p)},	undef,	"to_unicode\(\'\⫐｡ⴠ\-\\uD92A\\uDF58\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}↥．⦟\x{E0AAC}", %p)},	undef,	"to_unicode\(\'\\uA8C4\↥．\⦟\\uDB42\\uDEAC\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}↥.⦟\x{E0AAC}", %p)},	undef,	"to_unicode\(\'\\uA8C4\↥\.\⦟\\uDB42\\uDEAC\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17177}-\x{10E66}。\x{B6439}ꡅ", %p)},	undef,	"to_unicode\(\'\\uD81C\\uDD77\-\\uD803\\uDE66\。\\uDA99\\uDC39ꡅ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D2}。\x{E0C5A}\x{0336}\x{FCE1}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u06D2\。\\uDB43\\uDC5A\\u0336\\uFCE1\\uD803\\uDE66\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D2}。\x{E0C5A}\x{0336}\x{0628}\x{0645}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u06D2\。\\uDB43\\uDC5A\\u0336\\u0628\\u0645\\uD803\\uDE66\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA60}ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE60ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA60}ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE60ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA60}ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE60ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EA60}ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE60ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₀\x{10E67}。\x{B6556}≯-", %p)},	undef,	"to_unicode\(\'₀\\uD803\\uDE67\。\\uDA99\\uDD56\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₀\x{10E67}。\x{B6556}>\x{0338}-", %p)},	undef,	"to_unicode\(\'₀\\uD803\\uDE67\。\\uDA99\\uDD56\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{10E67}。\x{B6556}≯-", %p)},	undef,	"to_unicode\(\'0\\uD803\\uDE67\。\\uDA99\\uDD56\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{10E67}。\x{B6556}>\x{0338}-", %p)},	undef,	"to_unicode\(\'0\\uD803\\uDE67\。\\uDA99\\uDD56\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⌡\x{10E68}-\x{108F8}.𐋤\x{076B}", %p)},	undef,	"to_unicode\(\'\⌡\\uD803\\uDE68\-\\uD802\\uDCF8\.𐋤\\u076B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡\x{081C}\x{0665}Ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\≠｡\\u081C\\u0665Ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡\x{081C}\x{0665}Ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡\\u081C\\u0665Ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。\x{081C}\x{0665}Ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\≠\。\\u081C\\u0665Ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。\x{081C}\x{0665}Ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\=\\u0338\。\\u081C\\u0665Ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。\x{081C}\x{0665}ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\=\\u0338\。\\u081C\\u0665ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。\x{081C}\x{0665}ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\≠\。\\u081C\\u0665ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡\x{081C}\x{0665}ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡\\u081C\\u0665ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡\x{081C}\x{0665}ⴡ\x{031C}", %p)},	undef,	"to_unicode\(\'\≠｡\\u081C\\u0665ⴡ\\u031C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05AF}≠.Ⴀᠣ", %p)},	undef,	"to_unicode\(\'\\u05AF\≠\.Ⴀᠣ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05AF}=\x{0338}.Ⴀᠣ", %p)},	undef,	"to_unicode\(\'\\u05AF\=\\u0338\.Ⴀᠣ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05AF}=\x{0338}.ⴀᠣ", %p)},	undef,	"to_unicode\(\'\\u05AF\=\\u0338\.ⴀᠣ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05AF}≠.ⴀᠣ", %p)},	undef,	"to_unicode\(\'\\u05AF\≠\.ⴀᠣ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{E014F}\x{E0155}ᢢ．ᠡ閪\x{10E7A}\x{0FA3}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4F\\uDB40\\uDD55ᢢ．ᠡ閪\\uD803\\uDE7A\\u0FA3\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2061\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{E014F}\x{E0155}ᢢ.ᠡ閪\x{10E7A}\x{0FA3}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD4F\\uDB40\\uDD55ᢢ\.ᠡ閪\\uD803\\uDE7A\\u0FA3\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2062\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{2DE4}\x{10C88}\x{2DF8}｡\x{FE0D}\x{1B72}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u2DE4\\uD803\\uDC88\\u2DF8｡\\uFE0D\\u1B72\-ᛟ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{2DE4}\x{10C88}\x{2DF8}｡\x{FE0D}\x{1B72}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u2DE4\\uD803\\uDC88\\u2DF8｡\\uFE0D\\u1B72\-ᛟ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{2DE4}\x{10C88}\x{2DF8}。\x{FE0D}\x{1B72}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u2DE4\\uD803\\uDC88\\u2DF8\。\\uFE0D\\u1B72\-ᛟ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{2DE4}\x{10C88}\x{2DF8}。\x{FE0D}\x{1B72}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u2DE4\\uD803\\uDC88\\u2DF8\。\\uFE0D\\u1B72\-ᛟ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁𥡿\x{0ACD}\x{157DA}。\x{10AED}𝟜", %p)},	undef,	"to_unicode\(\'헁𥡿\\u0ACD\\uD815\\uDFDA\。\\uD802\\uDEED𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁𥡿\x{0ACD}\x{157DA}。\x{10AED}𝟜", %p)},	undef,	"to_unicode\(\'헁𥡿\\u0ACD\\uD815\\uDFDA\。\\uD802\\uDEED𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁𥡿\x{0ACD}\x{157DA}。\x{10AED}4", %p)},	undef,	"to_unicode\(\'헁𥡿\\u0ACD\\uD815\\uDFDA\。\\uD802\\uDEED4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁𥡿\x{0ACD}\x{157DA}。\x{10AED}4", %p)},	undef,	"to_unicode\(\'헁𥡿\\u0ACD\\uD815\\uDFDA\。\\uD802\\uDEED4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}｡\x{B41DF}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B｡\\uDA90\\uDDDF\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}｡\x{B41DF}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B｡\\uDA90\\uDDDF\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}。\x{B41DF}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B\。\\uDA90\\uDDDF\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}。\x{B41DF}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B\。\\uDA90\\uDDDF\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}。\x{B41DF}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B\。\\uDA90\\uDDDF\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}。\x{B41DF}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B\。\\uDA90\\uDDDF\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}｡\x{B41DF}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B｡\\uDA90\\uDDDF\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7B}｡\x{B41DF}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7B｡\\uDA90\\uDDDF\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2078\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{103A}.\x{059D}\x{1D169}馋", %p)},	undef,	"to_unicode\(\'\\u103A\.\\u059D\\uD834\\uDD69馋\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2079\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{103A}.\x{1D169}\x{059D}馋", %p)},	undef,	"to_unicode\(\'\\u103A\.\\uD834\\uDD69\\u059D馋\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2080\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{96511}\x{7F1C8}\x{200D}｡\x{CF53F}", %p)},	undef,	"to_unicode\(\'\\uDA19\\uDD11\\uD9BC\\uDDC8\\u200D｡\\uDAFD\\uDD3F\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{96511}\x{7F1C8}\x{200D}｡\x{CF53F}", %p)},	undef,	"to_unicode\(\'\\uDA19\\uDD11\\uD9BC\\uDDC8\\u200D｡\\uDAFD\\uDD3F\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{96511}\x{7F1C8}\x{200D}。\x{CF53F}", %p)},	undef,	"to_unicode\(\'\\uDA19\\uDD11\\uD9BC\\uDDC8\\u200D\。\\uDAFD\\uDD3F\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{96511}\x{7F1C8}\x{200D}。\x{CF53F}", %p)},	undef,	"to_unicode\(\'\\uDA19\\uDD11\\uD9BC\\uDDC8\\u200D\。\\uDAFD\\uDD3F\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡭ\x{E0574}姶🄉．۷\x{200D}\x{E0197}\x{200D}", %p)},	undef,	"to_unicode\(\'ꡭ\\uDB41\\uDD74姶🄉．۷\\u200D\\uDB40\\uDD97\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡭ\x{E0574}姶🄉．۷\x{200D}\x{E0197}\x{200D}", %p)},	undef,	"to_unicode\(\'ꡭ\\uDB41\\uDD74姶🄉．۷\\u200D\\uDB40\\uDD97\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡭ\x{E0574}姶8,.۷\x{200D}\x{E0197}\x{200D}", %p)},	undef,	"to_unicode\(\'ꡭ\\uDB41\\uDD74姶8\,\.۷\\u200D\\uDB40\\uDD97\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡭ\x{E0574}姶8,.۷\x{200D}\x{E0197}\x{200D}", %p)},	undef,	"to_unicode\(\'ꡭ\\uDB41\\uDD74姶8\,\.۷\\u200D\\uDB40\\uDD97\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10961}.\x{10E74}🌎\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDD61\.\\uD803\\uDE74🌎\\u0B4D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{06C3}｡\x{10E7C}\x{E0133}۹", %p)},	undef,	"to_unicode\(\'Ⴔ\\u06C3｡\\uD803\\uDE7C\\uDB40\\uDD33۹\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{06C3}。\x{10E7C}\x{E0133}۹", %p)},	undef,	"to_unicode\(\'Ⴔ\\u06C3\。\\uD803\\uDE7C\\uDB40\\uDD33۹\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2091\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{06C3}。\x{10E7C}\x{E0133}۹", %p)},	undef,	"to_unicode\(\'ⴔ\\u06C3\。\\uD803\\uDE7C\\uDB40\\uDD33۹\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2092\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{06C3}｡\x{10E7C}\x{E0133}۹", %p)},	undef,	"to_unicode\(\'ⴔ\\u06C3｡\\uD803\\uDE7C\\uDB40\\uDD33۹\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2093\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0E72}\x{0727}\x{200C}．︒-\x{1036}-", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDE72\\u0727\\u200C．︒\-\\u1036\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:2094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0E72}\x{0727}\x{200C}．︒-\x{1036}-", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDE72\\u0727\\u200C．︒\-\\u1036\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:2095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0E72}\x{0727}\x{200C}.。-\x{1036}-", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDE72\\u0727\\u200C\.\。\-\\u1036\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0E72}\x{0727}\x{200C}.。-\x{1036}-", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDE72\\u0727\\u200C\.\。\-\\u1036\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0661}⒖\x{200C}.\x{0619}\x{10A70}", %p)},	undef,	"to_unicode\(\'⒈\\u0661⒖\\u200C\.\\u0619\\uD802\\uDE70\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0661}⒖\x{200C}.\x{0619}\x{10A70}", %p)},	undef,	"to_unicode\(\'⒈\\u0661⒖\\u200C\.\\u0619\\uD802\\uDE70\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2099\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("1.\x{0661}15.\x{200C}.\x{0619}\x{10A70}", %p)},	undef,	"to_unicode\(\'1\.\\u066115\.\\u200C\.\\u0619\\uD802\\uDE70\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2100\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("1.\x{0661}15.\x{200C}.\x{0619}\x{10A70}", %p)},	undef,	"to_unicode\(\'1\.\\u066115\.\\u200C\.\\u0619\\uD802\\uDE70\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2101\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0B63}。-\x{1163F}Ⴋ", %p)},	undef,	"to_unicode\(\'\\u0B63\。\-\\uD805\\uDE3FႫ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:2102\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0B63}。-\x{1163F}ⴋ", %p)},	undef,	"to_unicode\(\'\\u0B63\。\-\\uD805\\uDE3Fⴋ\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:2103\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ßჀ.\x{07E8}刯Ⴝ", %p)},	undef,	"to_unicode\(\'ßჀ\.\\u07E8刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2104\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ßⴠ.\x{07E8}刯ⴝ", %p)},	undef,	"to_unicode\(\'ßⴠ\.\\u07E8刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2105\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SSჀ.\x{07E8}刯Ⴝ", %p)},	undef,	"to_unicode\(\'SSჀ\.\\u07E8刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2106\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ssⴠ.\x{07E8}刯ⴝ", %p)},	undef,	"to_unicode\(\'ssⴠ\.\\u07E8刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2107\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ssⴠ.\x{07E8}刯Ⴝ", %p)},	undef,	"to_unicode\(\'Ssⴠ\.\\u07E8刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}ႣℲ｡\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣℲ｡\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}ႣℲ｡\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣℲ｡\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}ႣℲ。\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣℲ\。\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}ႣℲ。\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣℲ\。\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2112\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{ABED}ⴃⅎ。\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDⴃⅎ\。\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:2113\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{ABED}ⴃⅎ。\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDⴃⅎ\。\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:2114\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{ABED}Ⴃⅎ。\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣⅎ\。\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}Ⴃⅎ。\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣⅎ\。\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2116\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{ABED}ⴃⅎ｡\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDⴃⅎ｡\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:2117\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{ABED}ⴃⅎ｡\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDⴃⅎ｡\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:2118\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{ABED}Ⴃⅎ｡\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣⅎ｡\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}Ⴃⅎ｡\x{06A4}툻\x{1E861}", %p)},	undef,	"to_unicode\(\'\\uABEDႣⅎ｡\\u06A4툻\\uD83A\\uDC61\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0DEB}.ᠱ\x{10E6B}\x{06A5}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDEB\.ᠱ\\uD803\\uDE6B\\u06A5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2121\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AD9}\x{073C}。₇\x{0DCA}", %p)},	"\x{10AD9}\x{073C}.7\x{0DCA}",	"to_unicode\(\'\\uD802\\uDED9\\u073C\。₇\\u0DCA\'\)\ \[data\/IdnaTest\.txt\:2122\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AD9}\x{073C}。7\x{0DCA}", %p)},	"\x{10AD9}\x{073C}.7\x{0DCA}",	"to_unicode\(\'\\uD802\\uDED9\\u073C\。7\\u0DCA\'\)\ \[data\/IdnaTest\.txt\:2123\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--job5304k.xn--7-ptf", %p)},	"\x{10AD9}\x{073C}.7\x{0DCA}",	"to_unicode\(\'xn\-\-job5304k\.xn\-\-7\-ptf\'\)\ \[data\/IdnaTest\.txt\:2124\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AD9}\x{073C}.7\x{0DCA}", %p)},	"\x{10AD9}\x{073C}.7\x{0DCA}",	"to_unicode\(\'\\uD802\\uDED9\\u073C\.7\\u0DCA\'\)\ \[data\/IdnaTest\.txt\:2125\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{0817}≮〰", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\u0817\≮\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{0817}≮〰", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\u0817\≮\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{0817}<\x{0338}〰", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\u0817\<\\u0338\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{0817}<\x{0338}〰", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\u0817\<\\u0338\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{0817}<\x{0338}〰", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\u0817\<\\u0338\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{0817}<\x{0338}〰", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\u0817\<\\u0338\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{0817}≮〰", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\u0817\≮\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{0817}≮〰", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\u0817\≮\〰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2133\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("𝟵隁⅛．\x{1DD5}\x{200C}", %p)},	undef,	"to_unicode\(\'𝟵隁⅛．\\u1DD5\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2134\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("𝟵隁⅛．\x{1DD5}\x{200C}", %p)},	undef,	"to_unicode\(\'𝟵隁⅛．\\u1DD5\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2135\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("9隁1⁄8.\x{1DD5}\x{200C}", %p)},	undef,	"to_unicode\(\'9隁1\⁄8\.\\u1DD5\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2136\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("9隁1⁄8.\x{1DD5}\x{200C}", %p)},	undef,	"to_unicode\(\'9隁1\⁄8\.\\u1DD5\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2137\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒏\x{10E77}｡Ⴣ\x{ABED}彦", %p)},	undef,	"to_unicode\(\'⒏\\uD803\\uDE77｡Ⴣ\\uABED彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8.\x{10E77}。Ⴣ\x{ABED}彦", %p)},	undef,	"to_unicode\(\'8\.\\uD803\\uDE77\。Ⴣ\\uABED彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2139\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("8.\x{10E77}。ⴣ\x{ABED}彦", %p)},	undef,	"to_unicode\(\'8\.\\uD803\\uDE77\。ⴣ\\uABED彦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2140\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒏\x{10E77}｡ⴣ\x{ABED}彦", %p)},	undef,	"to_unicode\(\'⒏\\uD803\\uDE77｡ⴣ\\uABED彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-问\x{5E42F}⒛。\x{0664}-\x{64094}橬", %p)},	undef,	"to_unicode\(\'\-问\\uD939\\uDC2F⒛\。\\u0664\-\\uD950\\uDC94橬\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-问\x{5E42F}20.。\x{0664}-\x{64094}橬", %p)},	undef,	"to_unicode\(\'\-问\\uD939\\uDC2F20\.\。\\u0664\-\\uD950\\uDC94橬\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1103A}Ⴌ\x{200C}\x{0316}。𝟸", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3AႬ\\u200C\\u0316\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1103A}Ⴌ\x{200C}\x{0316}。𝟸", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3AႬ\\u200C\\u0316\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1103A}Ⴌ\x{200C}\x{0316}。2", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3AႬ\\u200C\\u0316\。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1103A}Ⴌ\x{200C}\x{0316}。2", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3AႬ\\u200C\\u0316\。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2147\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1103A}ⴌ\x{200C}\x{0316}。2", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3Aⴌ\\u200C\\u0316\。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2148\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1103A}ⴌ\x{200C}\x{0316}。2", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3Aⴌ\\u200C\\u0316\。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2149\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1103A}ⴌ\x{200C}\x{0316}。𝟸", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3Aⴌ\\u200C\\u0316\。𝟸\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2150\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1103A}ⴌ\x{200C}\x{0316}。𝟸", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC3Aⴌ\\u200C\\u0316\。𝟸\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2151\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{DC5F}。\x{0ACD}\x{10E6B}ˆ", %p)},	undef,	"to_unicode\(\'\\uDC5F\。\\u0ACD\\uD803\\uDE6Bˆ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E019F}\x{E013B}⾶｡₇︒눇≮", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD9F\\uDB40\\uDD3B⾶｡₇︒눇\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E019F}\x{E013B}⾶｡₇︒눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD9F\\uDB40\\uDD3B⾶｡₇︒눇\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E019F}\x{E013B}飛。7。눇≮", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD9F\\uDB40\\uDD3B飛\。7\。눇\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E019F}\x{E013B}飛。7。눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD9F\\uDB40\\uDD3B飛\。7\。눇\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2156\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{0C4A}\x{10E7D}\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\u0C4A\\uD803\\uDE7D\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2157\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{0C4A}\x{10E7D}\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\u0C4A\\uD803\\uDE7D\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2158\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{0C4A}\x{10E7D}\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\u0C4A\\uD803\\uDE7D\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2159\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{0C4A}\x{10E7D}\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\u0C4A\\uD803\\uDE7D\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2160\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{11039}．\x{200D}\x{E0D95}\x{1E9C8}\x{20EB}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC39．\\u200D\\uDB43\\uDD95\\uD83A\\uDDC8\\u20EB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11039}．\x{200D}\x{E0D95}\x{1E9C8}\x{20EB}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC39．\\u200D\\uDB43\\uDD95\\uD83A\\uDDC8\\u20EB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11039}.\x{200D}\x{E0D95}\x{1E9C8}\x{20EB}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC39\.\\u200D\\uDB43\\uDD95\\uD83A\\uDDC8\\u20EB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11039}.\x{200D}\x{E0D95}\x{1E9C8}\x{20EB}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC39\.\\u200D\\uDB43\\uDD95\\uD83A\\uDDC8\\u20EB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2164\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᢦ\x{07EB}.ꡏ\x{200D}", %p)},	undef,	"to_unicode\(\'ᢦ\\u07EB\.ꡏ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2165\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᢦ\x{07EB}.ꡏ\x{200D}", %p)},	undef,	"to_unicode\(\'ᢦ\\u07EB\.ꡏ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2166\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--jtb976f.xn--oc9a", %p)},	"ᢦ\x{07EB}.ꡏ",	"to_unicode\(\'xn\-\-jtb976f\.xn\-\-oc9a\'\)\ \[data\/IdnaTest\.txt\:2167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᢦ\x{07EB}.ꡏ", %p)},	"ᢦ\x{07EB}.ꡏ",	"to_unicode\(\'ᢦ\\u07EB\.ꡏ\'\)\ \[data\/IdnaTest\.txt\:2168\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0662}\x{A806}-．\x{591EA}\x{17D2}\x{C2117}", %p)},	undef,	"to_unicode\(\'\\u0662\\uA806\-．\\uD924\\uDDEA\\u17D2\\uDAC8\\uDD17\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0662}\x{A806}-.\x{591EA}\x{17D2}\x{C2117}", %p)},	undef,	"to_unicode\(\'\\u0662\\uA806\-\.\\uD924\\uDDEA\\u17D2\\uDAC8\\uDD17\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}｡\x{0EBB}\x{200C}\x{10E62}≮", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664｡\\u0EBB\\u200C\\uD803\\uDE62\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}｡\x{0EBB}\x{200C}\x{10E62}≮", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664｡\\u0EBB\\u200C\\uD803\\uDE62\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}｡\x{0EBB}\x{200C}\x{10E62}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664｡\\u0EBB\\u200C\\uD803\\uDE62\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}｡\x{0EBB}\x{200C}\x{10E62}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664｡\\u0EBB\\u200C\\uD803\\uDE62\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}。\x{0EBB}\x{200C}\x{10E62}≮", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664\。\\u0EBB\\u200C\\uD803\\uDE62\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}。\x{0EBB}\x{200C}\x{10E62}≮", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664\。\\u0EBB\\u200C\\uD803\\uDE62\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}。\x{0EBB}\x{200C}\x{10E62}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664\。\\u0EBB\\u200C\\uD803\\uDE62\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1734}-\x{0664}。\x{0EBB}\x{200C}\x{10E62}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1734\-\\u0664\。\\u0EBB\\u200C\\uD803\\uDE62\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{2D7F}\x{11368}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uFFA0\\u2D7F\\uD804\\uDF68\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{2D7F}\x{11368}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uFFA0\\u2D7F\\uD804\\uDF68\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{2D7F}\x{11368}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u1160\\u2D7F\\uD804\\uDF68\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{2D7F}\x{11368}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u1160\\u2D7F\\uD804\\uDF68\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{E24AB}．\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\≯\\uDB49\\uDCAB．\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{E24AB}．\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\≯\\uDB49\\uDCAB．\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{E24AB}．\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uDB49\\uDCAB．\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{E24AB}．\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uDB49\\uDCAB．\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{E24AB}.\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\≯\\uDB49\\uDCAB\.\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{E24AB}.\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\≯\\uDB49\\uDCAB\.\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{E24AB}.\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uDB49\\uDCAB\.\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{E24AB}.\x{200D}\x{E0869}\x{9EFE8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uDB49\\uDCAB\.\\u200D\\uDB42\\uDC69\\uDA3B\\uDFE8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}ß\x{10BC1}｡𝟕\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682ß\\uD802\\uDFC1｡𝟕\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}ß\x{10BC1}。7\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682ß\\uD802\\uDFC1\。7\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}SS\x{10BC1}。7\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682SS\\uD802\\uDFC1\。7\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}ss\x{10BC1}。7\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682ss\\uD802\\uDFC1\。7\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}Ss\x{10BC1}。7\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682Ss\\uD802\\uDFC1\。7\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}SS\x{10BC1}｡𝟕\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682SS\\uD802\\uDFC1｡𝟕\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}ss\x{10BC1}｡𝟕\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682ss\\uD802\\uDFC1｡𝟕\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}Ss\x{10BC1}｡𝟕\x{06A3}", %p)},	undef,	"to_unicode\(\'\\u0682Ss\\uD802\\uDFC1｡𝟕\\u06A3\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:2198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{AA31}\x{E0054}\x{07B2}。\x{1EF97}\x{62DAD}\x{10E65}", %p)},	undef,	"to_unicode\(\'ß\\uAA31\\uDB40\\uDC54\\u07B2\。\\uD83B\\uDF97\\uD94B\\uDDAD\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{AA31}\x{E0054}\x{07B2}。\x{1EF97}\x{62DAD}\x{10E65}", %p)},	undef,	"to_unicode\(\'SS\\uAA31\\uDB40\\uDC54\\u07B2\。\\uD83B\\uDF97\\uD94B\\uDDAD\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{AA31}\x{E0054}\x{07B2}。\x{1EF97}\x{62DAD}\x{10E65}", %p)},	undef,	"to_unicode\(\'ss\\uAA31\\uDB40\\uDC54\\u07B2\。\\uD83B\\uDF97\\uD94B\\uDDAD\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{AA31}\x{E0054}\x{07B2}。\x{1EF97}\x{62DAD}\x{10E65}", %p)},	undef,	"to_unicode\(\'Ss\\uAA31\\uDB40\\uDC54\\u07B2\。\\uD83B\\uDF97\\uD94B\\uDDAD\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡⸹⒌\x{10923}", %p)},	undef,	"to_unicode\(\'\-｡\⸹⒌\\uD802\\uDD23\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2203\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("-。⸹5.\x{10923}", %p)},	undef,	"to_unicode\(\'\-\。\⸹5\.\\uD802\\uDD23\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2204\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{F9CE1}ς．-≮\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1ς．\-\≮\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}ς．-<\x{0338}\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1ς．\-\<\\u0338\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}ς.-≮\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1ς\.\-\≮\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}ς.-<\x{0338}\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1ς\.\-\<\\u0338\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}Σ.-<\x{0338}\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1Σ\.\-\<\\u0338\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}Σ.-≮\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1Σ\.\-\≮\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}σ.-≮\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1σ\.\-\≮\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}σ.-<\x{0338}\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1σ\.\-\<\\u0338\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}Σ．-<\x{0338}\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1Σ．\-\<\\u0338\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}Σ．-≮\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1Σ．\-\≮\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}σ．-≮\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1σ．\-\≮\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{F9CE1}σ．-<\x{0338}\x{1E898}", %p)},	undef,	"to_unicode\(\'\\uDBA7\\uDCE1σ．\-\<\\u0338\\uD83A\\uDC98\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C2}ꡚᠣ．\x{5E8E6}🂏\x{1714}\x{FB54}", %p)},	undef,	"to_unicode\(\'\\u06C2ꡚᠣ．\\uD93A\\uDCE6🂏\\u1714\\uFB54\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C1}\x{0654}ꡚᠣ．\x{5E8E6}🂏\x{1714}\x{FB54}", %p)},	undef,	"to_unicode\(\'\\u06C1\\u0654ꡚᠣ．\\uD93A\\uDCE6🂏\\u1714\\uFB54\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C2}ꡚᠣ.\x{5E8E6}🂏\x{1714}\x{067B}", %p)},	undef,	"to_unicode\(\'\\u06C2ꡚᠣ\.\\uD93A\\uDCE6🂏\\u1714\\u067B\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C1}\x{0654}ꡚᠣ.\x{5E8E6}🂏\x{1714}\x{067B}", %p)},	undef,	"to_unicode\(\'\\u06C1\\u0654ꡚᠣ\.\\uD93A\\uDCE6🂏\\u1714\\u067B\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EADE}\x{0642}ᡯᡧ。𐋦\x{10376}\x{0367}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDEDE\\u0642ᡯᡧ\。𐋦\\uD800\\uDF76\\u0367\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₂\x{9E796}--。ꡋ\x{200C}\x{10A5D}\x{0ACD}", %p)},	undef,	"to_unicode\(\'₂\\uDA39\\uDF96\-\-\。ꡋ\\u200C\\uD802\\uDE5D\\u0ACD\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₂\x{9E796}--。ꡋ\x{200C}\x{10A5D}\x{0ACD}", %p)},	undef,	"to_unicode\(\'₂\\uDA39\\uDF96\-\-\。ꡋ\\u200C\\uD802\\uDE5D\\u0ACD\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{9E796}--。ꡋ\x{200C}\x{10A5D}\x{0ACD}", %p)},	undef,	"to_unicode\(\'2\\uDA39\\uDF96\-\-\。ꡋ\\u200C\\uD802\\uDE5D\\u0ACD\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{9E796}--。ꡋ\x{200C}\x{10A5D}\x{0ACD}", %p)},	undef,	"to_unicode\(\'2\\uDA39\\uDF96\-\-\。ꡋ\\u200C\\uD802\\uDE5D\\u0ACD\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{E62FF}．\x{062B}\x{06A1}-", %p)},	undef,	"to_unicode\(\'\-\\uDB58\\uDEFF．\\u062B\\u06A1\-\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:2226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{E62FF}.\x{062B}\x{06A1}-", %p)},	undef,	"to_unicode\(\'\-\\uDB58\\uDEFF\.\\u062B\\u06A1\-\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:2227\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2228\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2229\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2230\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2231\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2232\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2233\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2234\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2235\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2236\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss。ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss\。ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2237\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2238\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2239\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2240\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2241\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2242\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss｡ᡪ\x{10E65}\x{06AD}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᡪ\\uD803\\uDE65\\u06AD\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2243\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("꧐Ӏ\x{1163F}\x{1073}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\uD805\\uDE3F\\u1073．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1163F}\x{1073}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\uD805\\uDE3F\\u1073．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1163F}\x{1073}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\uD805\\uDE3F\\u1073\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1163F}\x{1073}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\uD805\\uDE3F\\u1073\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2247\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1163F}\x{1073}.눵", %p)},	"꧐ӏ\x{1163F}\x{1073}.눵",	"to_unicode\(\'꧐ӏ\\uD805\\uDE3F\\u1073\.눵\'\)\ \[data\/IdnaTest\.txt\:2248\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1163F}\x{1073}.눵", %p)},	"꧐ӏ\x{1163F}\x{1073}.눵",	"to_unicode\(\'꧐ӏ\\uD805\\uDE3F\\u1073\.눵\'\)\ \[data\/IdnaTest\.txt\:2249\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--s5a470dgr8jrwyd.xn--2e1b", %p)},	"꧐ӏ\x{1163F}\x{1073}.눵",	"to_unicode\(\'xn\-\-s5a470dgr8jrwyd\.xn\-\-2e1b\'\)\ \[data\/IdnaTest\.txt\:2250\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1163F}\x{1073}．눵", %p)},	"꧐ӏ\x{1163F}\x{1073}.눵",	"to_unicode\(\'꧐ӏ\\uD805\\uDE3F\\u1073．눵\'\)\ \[data\/IdnaTest\.txt\:2251\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1163F}\x{1073}．눵", %p)},	"꧐ӏ\x{1163F}\x{1073}.눵",	"to_unicode\(\'꧐ӏ\\uD805\\uDE3F\\u1073．눵\'\)\ \[data\/IdnaTest\.txt\:2252\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07A6}｡\x{10C787}\x{2063}\x{A674}", %p)},	undef,	"to_unicode\(\'\\u07A6｡\\uDBF1\\uDF87\\u2063\\uA674\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07A6}。\x{10C787}\x{2063}\x{A674}", %p)},	undef,	"to_unicode\(\'\\u07A6\。\\uDBF1\\uDF87\\u2063\\uA674\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{68E8A}\x{2060}。\x{76B1D}≯⾇", %p)},	undef,	"to_unicode\(\'\\uD963\\uDE8A\\u2060\。\\uD99A\\uDF1D\≯⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{68E8A}\x{2060}。\x{76B1D}>\x{0338}⾇", %p)},	undef,	"to_unicode\(\'\\uD963\\uDE8A\\u2060\。\\uD99A\\uDF1D\>\\u0338⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{68E8A}\x{2060}。\x{76B1D}≯舛", %p)},	undef,	"to_unicode\(\'\\uD963\\uDE8A\\u2060\。\\uD99A\\uDF1D\≯舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{68E8A}\x{2060}。\x{76B1D}>\x{0338}舛", %p)},	undef,	"to_unicode\(\'\\uD963\\uDE8A\\u2060\。\\uD99A\\uDF1D\>\\u0338舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2258\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC4}\x{066B}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC4\\u066B\\u200C．\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2259\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC4}\x{066B}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC4\\u066B\\u200C．\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2260\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC4}\x{066B}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC4\\u066B\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2261\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC4}\x{066B}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC4\\u066B\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2262\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--kib1144k.", %p)},	"\x{10AC4}\x{066B}.",	"to_unicode\(\'xn\-\-kib1144k\.\'\)\ \[data\/IdnaTest\.txt\:2263\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC4}\x{066B}.", %p)},	"\x{10AC4}\x{066B}.",	"to_unicode\(\'\\uD802\\uDEC4\\u066B\.\'\)\ \[data\/IdnaTest\.txt\:2264\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{3C842}砪≯\x{06BA}｡≯\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\≯\\u06BA｡\≯\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪≯\x{06BA}｡≯\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\≯\\u06BA｡\≯\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪>\x{0338}\x{06BA}｡>\x{0338}\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\>\\u0338\\u06BA｡\>\\u0338\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪>\x{0338}\x{06BA}｡>\x{0338}\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\>\\u0338\\u06BA｡\>\\u0338\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪≯\x{06BA}。≯\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\≯\\u06BA\。\≯\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪≯\x{06BA}。≯\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\≯\\u06BA\。\≯\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪>\x{0338}\x{06BA}。>\x{0338}\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\>\\u0338\\u06BA\。\>\\u0338\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C842}砪>\x{0338}\x{06BA}。>\x{0338}\x{FE24}\x{5F529}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDC42砪\>\\u0338\\u06BA\。\>\\u0338\\uFE24\\uD93D\\uDD29\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ.\x{17D2}㊸", %p)},	undef,	"to_unicode\(\'Ⴥ\.\\u17D2㊸\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ.\x{17D2}43", %p)},	undef,	"to_unicode\(\'Ⴥ\.\\u17D243\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2274\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴥ.\x{17D2}43", %p)},	undef,	"to_unicode\(\'ⴥ\.\\u17D243\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2275\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴥ.\x{17D2}㊸", %p)},	undef,	"to_unicode\(\'ⴥ\.\\u17D2㊸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2276\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟎\x{066C}。Ⴒ\x{063A}\x{1C2C}\x{10E74}", %p)},	undef,	"to_unicode\(\'𝟎\\u066C\。Ⴒ\\u063A\\u1C2C\\uD803\\uDE74\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{066C}。Ⴒ\x{063A}\x{1C2C}\x{10E74}", %p)},	undef,	"to_unicode\(\'0\\u066C\。Ⴒ\\u063A\\u1C2C\\uD803\\uDE74\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2278\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0\x{066C}。ⴒ\x{063A}\x{1C2C}\x{10E74}", %p)},	undef,	"to_unicode\(\'0\\u066C\。ⴒ\\u063A\\u1C2C\\uD803\\uDE74\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2279\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟎\x{066C}。ⴒ\x{063A}\x{1C2C}\x{10E74}", %p)},	undef,	"to_unicode\(\'𝟎\\u066C\。ⴒ\\u063A\\u1C2C\\uD803\\uDE74\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2280\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{74B75}\x{E01D0}\x{FFA0}\x{AAB2}.\x{12A00}\x{09CD}", %p)},	undef,	"to_unicode\(\'\\uD992\\uDF75\\uDB40\\uDDD0\\uFFA0\\uAAB2\.\\uD80A\\uDE00\\u09CD\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{74B75}\x{E01D0}\x{1160}\x{AAB2}.\x{12A00}\x{09CD}", %p)},	undef,	"to_unicode\(\'\\uD992\\uDF75\\uDB40\\uDDD0\\u1160\\uAAB2\.\\uD80A\\uDE00\\u09CD\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2282\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06DA}.۳\x{200C}\x{114C2}", %p)},	undef,	"to_unicode\(\'\\u06DA\.۳\\u200C\\uD805\\uDCC2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2283\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06DA}.۳\x{200C}\x{114C2}", %p)},	undef,	"to_unicode\(\'\\u06DA\.۳\\u200C\\uD805\\uDCC2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2284\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0750}．︒\x{10ADF}", %p)},	undef,	"to_unicode\(\'\\u0750．︒\\uD802\\uDEDF\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2285\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0750}.。\x{10ADF}", %p)},	undef,	"to_unicode\(\'\\u0750\.\。\\uD802\\uDEDF\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2286\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0C4D}\x{20E7}｡\x{077A}", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u20E7｡\\u077A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2287\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0C4D}\x{20E7}。\x{077A}", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u20E7\。\\u077A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2288\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1EDD6}。\x{07DF}\x{30E72}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDD6\。\\u07DF\\uD883\\uDE72\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}㴼．\x{200C}\x{0669}\x{E0193}\x{ED87C}", %p)},	undef,	"to_unicode\(\'\\u0F84㴼．\\u200C\\u0669\\uDB40\\uDD93\\uDB76\\uDC7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}㴼．\x{200C}\x{0669}\x{E0193}\x{ED87C}", %p)},	undef,	"to_unicode\(\'\\u0F84㴼．\\u200C\\u0669\\uDB40\\uDD93\\uDB76\\uDC7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}㴼.\x{200C}\x{0669}\x{E0193}\x{ED87C}", %p)},	undef,	"to_unicode\(\'\\u0F84㴼\.\\u200C\\u0669\\uDB40\\uDD93\\uDB76\\uDC7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}㴼.\x{200C}\x{0669}\x{E0193}\x{ED87C}", %p)},	undef,	"to_unicode\(\'\\u0F84㴼\.\\u200C\\u0669\\uDB40\\uDD93\\uDB76\\uDC7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10453B}\x{0600}⊪｡\x{1BA5}", %p)},	undef,	"to_unicode\(\'\\uDBD1\\uDD3B\\u0600\⊪｡\\u1BA5\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10453B}\x{0600}⊪。\x{1BA5}", %p)},	undef,	"to_unicode\(\'\\uDBD1\\uDD3B\\u0600\⊪\。\\u1BA5\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077B}뾜\x{E0CF4}\x{11235}。\x{089D}\x{0600}", %p)},	undef,	"to_unicode\(\'\\u077B뾜\\uDB43\\uDCF4\\uD804\\uDE35\。\\u089D\\u0600\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077B}뾜\x{E0CF4}\x{11235}。\x{089D}\x{0600}", %p)},	undef,	"to_unicode\(\'\\u077B뾜\\uDB43\\uDCF4\\uD804\\uDE35\。\\u089D\\u0600\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}≠｡𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\≠｡𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}≠｡𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\≠｡𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}=\x{0338}｡𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\=\\u0338｡𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}=\x{0338}｡𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\=\\u0338｡𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}≠。𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\≠\。𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}≠。𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\≠\。𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}=\x{0338}。𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\=\\u0338\。𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E77}=\x{0338}。𐋲⥚\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\=\\u0338\。𐋲\⥚\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{30645}\x{1734}．\x{200D}\x{09CD}\x{1ECEA}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD881\\uDE45\\u1734．\\u200D\\u09CD\\uD83B\\uDCEA\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{30645}\x{1734}．\x{200D}\x{09CD}\x{1ECEA}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD881\\uDE45\\u1734．\\u200D\\u09CD\\uD83B\\uDCEA\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{30645}\x{1734}.\x{200D}\x{09CD}\x{1ECEA}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD881\\uDE45\\u1734\.\\u200D\\u09CD\\uD83B\\uDCEA\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{30645}\x{1734}.\x{200D}\x{09CD}\x{1ECEA}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD881\\uDE45\\u1734\.\\u200D\\u09CD\\uD83B\\uDCEA\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EC1DA}\x{E01E9}\x{0EB6}\x{E01C4}。≮", %p)},	undef,	"to_unicode\(\'\\uDB70\\uDDDA\\uDB40\\uDDE9\\u0EB6\\uDB40\\uDDC4\。\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EC1DA}\x{E01E9}\x{0EB6}\x{E01C4}。<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB70\\uDDDA\\uDB40\\uDDE9\\u0EB6\\uDB40\\uDDC4\。\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE09}.\x{0946}暀≠", %p)},	undef,	"to_unicode\(\'\\uFE09\.\\u0946暀\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE09}.\x{0946}暀=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFE09\.\\u0946暀\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FD9E}\x{1A60}｡\x{08DA}\x{9CA68}\x{0C3F}", %p)},	undef,	"to_unicode\(\'\\uFD9E\\u1A60｡\\u08DA\\uDA32\\uDE68\\u0C3F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{062E}\x{064A}\x{1A60}。\x{08DA}\x{9CA68}\x{0C3F}", %p)},	undef,	"to_unicode\(\'\\u0628\\u062E\\u064A\\u1A60\。\\u08DA\\uDA32\\uDE68\\u0C3F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0598}\x{200D}⒈｡Ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D⒈｡Ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0598}\x{200D}⒈｡Ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D⒈｡Ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0598}\x{200D}1.。Ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D1\.\。Ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0598}\x{200D}1.。Ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D1\.\。Ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2319\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0598}\x{200D}1.。ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D1\.\。ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ V5\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2320\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0598}\x{200D}1.。ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D1\.\。ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ V5\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2321\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0598}\x{200D}⒈｡ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D⒈｡ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0598}\x{200D}⒈｡ⴌ\x{1E80A}", %p)},	undef,	"to_unicode\(\'\\u0598\\u200D⒈｡ⴌ\\uD83A\\uDC0A\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0559}\x{1134D}\x{3709C}ᡏ.ς\x{D83F8}\x{E2F42}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD59\\uD804\\uDF4D\\uD89C\\uDC9Cᡏ\.ς\\uDB20\\uDFF8\\uDB4B\\uDF42\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0559}\x{1134D}\x{3709C}ᡏ.Σ\x{D83F8}\x{E2F42}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD59\\uD804\\uDF4D\\uD89C\\uDC9Cᡏ\.Σ\\uDB20\\uDFF8\\uDB4B\\uDF42\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0559}\x{1134D}\x{3709C}ᡏ.σ\x{D83F8}\x{E2F42}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDD59\\uD804\\uDF4D\\uD89C\\uDC9Cᡏ\.σ\\uDB20\\uDFF8\\uDB4B\\uDF42\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072F}。\x{200C}\x{07E7}\x{34BCF}", %p)},	undef,	"to_unicode\(\'\\u072F\。\\u200C\\u07E7\\uD892\\uDFCF\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072F}。\x{200C}\x{07E7}\x{34BCF}", %p)},	undef,	"to_unicode\(\'\\u072F\。\\u200C\\u07E7\\uD892\\uDFCF\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2328\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DE0}\x{1DC2}.\x{1086}ᡓ\x{0758}\x{16B36}", %p)},	undef,	"to_unicode\(\'\\u1DE0\\u1DC2\.\\u1086ᡓ\\u0758\\uD81A\\uDF36\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2329\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DC2}\x{1DE0}.\x{1086}ᡓ\x{0758}\x{16B36}", %p)},	undef,	"to_unicode\(\'\\u1DC2\\u1DE0\.\\u1086ᡓ\\u0758\\uD81A\\uDF36\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2330\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䂹\x{57C2F}𐋦．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uD91F\\uDC2F𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{57C2F}𐋦．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uD91F\\uDC2F𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{57C2F}𐋦.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uD91F\\uDC2F𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{57C2F}𐋦.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uD91F\\uDC2F𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}\x{0667}\x{200C}｡\x{1ED05}🄉", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C\\u0667\\u200C｡\\uD83B\\uDD05🄉\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}\x{0667}\x{200C}｡\x{1ED05}🄉", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C\\u0667\\u200C｡\\uD83B\\uDD05🄉\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}\x{0667}\x{200C}。\x{1ED05}8,", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C\\u0667\\u200C\。\\uD83B\\uDD058\,\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ B3\ \[data\/IdnaTest\.txt\:2337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}\x{0667}\x{200C}。\x{1ED05}8,", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C\\u0667\\u200C\。\\uD83B\\uDD058\,\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ B3\ \[data\/IdnaTest\.txt\:2338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ≯", %p)},	undef,	"to_unicode\(\'\。\。Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'\。\。Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'\。\。ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ≯", %p)},	undef,	"to_unicode\(\'\。\。ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}｡\x{E0541}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61｡\\uDB41\\uDD41\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}｡\x{E0541}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61｡\\uDB41\\uDD41\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}。\x{E0541}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\。\\uDB41\\uDD41\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}。\x{E0541}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\。\\uDB41\\uDD41\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{10E6E}｡︒\x{0855}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD803\\uDE6E｡︒\\u0855\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{10E6E}｡︒\x{0855}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD803\\uDE6E｡︒\\u0855\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{10E6E}。。\x{0855}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD803\\uDE6E\。\。\\u0855\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{10E6E}。。\x{0855}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD803\\uDE6E\。\。\\u0855\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2354\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ⴞ\x{10E6E}。。\x{0855}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\uD803\\uDE6E\。\。\\u0855\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2355\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ⴞ\x{10E6E}。。\x{0855}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\uD803\\uDE6E\。\。\\u0855\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2356\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ⴞ\x{10E6E}｡︒\x{0855}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\uD803\\uDE6E｡︒\\u0855\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{10E6E}｡︒\x{0855}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\uD803\\uDE6E｡︒\\u0855\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ𝟹。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200CႦ𝟹\。\-\\u102F\-ᠢ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:2359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ𝟹。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200CႦ𝟹\。\-\\u102F\-ᠢ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:2360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ3。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200CႦ3\。\-\\u102F\-ᠢ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:2361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ3。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200CႦ3\。\-\\u102F\-ᠢ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:2362\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴆ3。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ3\。\-\\u102F\-ᠢ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2363\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴆ3。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ3\。\-\\u102F\-ᠢ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2364\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴆ𝟹。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ𝟹\。\-\\u102F\-ᠢ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2365\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴆ𝟹。-\x{102F}-ᠢ", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ𝟹\。\-\\u102F\-ᠢ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2366\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("箃Ⴡ-\x{FE24}｡≠-﹪", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uFE24｡\≠\-﹪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{FE24}｡=\x{0338}-﹪", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uFE24｡\=\\u0338\-﹪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{FE24}。≠-%", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uFE24\。\≠\-\%\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{FE24}。=\x{0338}-%", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uFE24\。\=\\u0338\-\%\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{FE24}。=\x{0338}-%", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uFE24\。\=\\u0338\-\%\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{FE24}。≠-%", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uFE24\。\≠\-\%\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{FE24}｡=\x{0338}-﹪", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uFE24｡\=\\u0338\-﹪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{FE24}｡≠-﹪", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uFE24｡\≠\-﹪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢉ.ᢢ", %p)},	"ᢉ.ᢢ",	"to_unicode\(\'ᢉ\.ᢢ\'\)\ \[data\/IdnaTest\.txt\:2375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--29e.xn--sbf", %p)},	"ᢉ.ᢢ",	"to_unicode\(\'xn\-\-29e\.xn\-\-sbf\'\)\ \[data\/IdnaTest\.txt\:2376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}.\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.\\u06EE\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}.\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.\\u06EE\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bmb", %p)},	"\x{06EE}",	"to_unicode\(\'xn\-\-bmb\'\)\ \[data\/IdnaTest\.txt\:2379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}", %p)},	"\x{06EE}",	"to_unicode\(\'\\u06EE\'\)\ \[data\/IdnaTest\.txt\:2380\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("꒷\x{10E6E}\x{0645}.ς\x{0DCA}蜹", %p)},	undef,	"to_unicode\(\'꒷\\uD803\\uDE6E\\u0645\.ς\\u0DCA蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2381\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("꒷\x{10E6E}\x{0645}.Σ\x{0DCA}蜹", %p)},	undef,	"to_unicode\(\'꒷\\uD803\\uDE6E\\u0645\.Σ\\u0DCA蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2382\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("꒷\x{10E6E}\x{0645}.σ\x{0DCA}蜹", %p)},	undef,	"to_unicode\(\'꒷\\uD803\\uDE6E\\u0645\.σ\\u0DCA蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2383\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A6EF0}ス\x{10510A}\x{10E61}．\x{DEDE0}", %p)},	undef,	"to_unicode\(\'\\uDA5B\\uDEF0ス\\uDBD4\\uDD0A\\uD803\\uDE61．\\uDB3B\\uDDE0\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A6EF0}ス\x{10510A}\x{10E61}.\x{DEDE0}", %p)},	undef,	"to_unicode\(\'\\uDA5B\\uDEF0ス\\uDBD4\\uDD0A\\uD803\\uDE61\.\\uDB3B\\uDDE0\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01DE}\x{8800E}．\x{0AC3}\x{D850}\x{10AD6}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDDE\\uD9E0\\uDC0E．\\u0AC3\\uD850\\uD802\\uDED6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01DE}\x{8800E}.\x{0AC3}\x{D850}\x{10AD6}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDDE\\uD9E0\\uDC0E\.\\u0AC3\\uD850\\uD802\\uDED6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0662}\x{1527A}\x{200C}。ᠣ", %p)},	undef,	"to_unicode\(\'\\u0662\\uD814\\uDE7A\\u200C\。ᠣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0662}\x{1527A}\x{200C}。ᠣ", %p)},	undef,	"to_unicode\(\'\\u0662\\uD814\\uDE7A\\u200C\。ᠣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'\\u1734\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'\\u1734\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡\x{1BAA}ᢋ", %p)},	undef,	"to_unicode\(\'︒｡\\u1BAAᢋ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2392\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("。。\x{1BAA}ᢋ", %p)},	undef,	"to_unicode\(\'\。\。\\u1BAAᢋ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2393\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳß。ጫ\x{10AD7}\x{06D0}𝟐", %p)},	undef,	"to_unicode\(\'ᠳß\。ጫ\\uD802\\uDED7\\u06D0𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2394\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳß。ጫ\x{10AD7}\x{06D0}2", %p)},	undef,	"to_unicode\(\'ᠳß\。ጫ\\uD802\\uDED7\\u06D02\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2395\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳSS。ጫ\x{10AD7}\x{06D0}2", %p)},	undef,	"to_unicode\(\'ᠳSS\。ጫ\\uD802\\uDED7\\u06D02\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2396\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳss。ጫ\x{10AD7}\x{06D0}2", %p)},	undef,	"to_unicode\(\'ᠳss\。ጫ\\uD802\\uDED7\\u06D02\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2397\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳSs。ጫ\x{10AD7}\x{06D0}2", %p)},	undef,	"to_unicode\(\'ᠳSs\。ጫ\\uD802\\uDED7\\u06D02\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2398\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳSS。ጫ\x{10AD7}\x{06D0}𝟐", %p)},	undef,	"to_unicode\(\'ᠳSS\。ጫ\\uD802\\uDED7\\u06D0𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2399\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳss。ጫ\x{10AD7}\x{06D0}𝟐", %p)},	undef,	"to_unicode\(\'ᠳss\。ጫ\\uD802\\uDED7\\u06D0𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2400\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᠳSs。ጫ\x{10AD7}\x{06D0}𝟐", %p)},	undef,	"to_unicode\(\'ᠳSs\。ጫ\\uD802\\uDED7\\u06D0𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2401\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10CE8}\x{FB60}ᚲ.\x{114B5}☝𝟚\x{112EA}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDCE8\\uFB60ᚲ\.\\uD805\\uDCB5\☝𝟚\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10CE8}\x{067A}ᚲ.\x{114B5}☝2\x{112EA}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDCE8\\u067Aᚲ\.\\uD805\\uDCB5\☝2\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1107F}︒\x{200D}.\x{DD272}\x{10057B}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDC7F︒\\u200D\.\\uDB34\\uDE72\\uDBC1\\uDD7B\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1107F}︒\x{200D}.\x{DD272}\x{10057B}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDC7F︒\\u200D\.\\uDB34\\uDE72\\uDBC1\\uDD7B\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1107F}。\x{200D}.\x{DD272}\x{10057B}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDC7F\。\\u200D\.\\uDB34\\uDE72\\uDBC1\\uDD7B\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1107F}。\x{200D}.\x{DD272}\x{10057B}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDC7F\。\\u200D\.\\uDB34\\uDE72\\uDBC1\\uDD7B\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("📌.≯\x{E01A1}", %p)},	undef,	"to_unicode\(\'📌\.\≯\\uDB40\\uDDA1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("📌.>\x{0338}\x{E01A1}", %p)},	undef,	"to_unicode\(\'📌\.\>\\u0338\\uDB40\\uDDA1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{103A}\x{E04B4}\x{0601}。\x{10E3D}", %p)},	undef,	"to_unicode\(\'\-\\u103A\\uDB41\\uDCB4\\u0601\。\\uD803\\uDE3D\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}．ꡌ\x{115F}", %p)},	undef,	"to_unicode\(\'\\u06CD．ꡌ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}.ꡌ\x{115F}", %p)},	undef,	"to_unicode\(\'\\u06CD\.ꡌ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨛\x{C4C73}.︒𝟕\x{1136C}", %p)},	undef,	"to_unicode\(\'㨛\\uDAD3\\uDC73\.︒𝟕\\uD804\\uDF6C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨛\x{C4C73}.。7\x{1136C}", %p)},	undef,	"to_unicode\(\'㨛\\uDAD3\\uDC73\.\。7\\uD804\\uDF6C\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}\x{5EBBB}-｡\x{10D3E}\x{A92B}ᢊ≮", %p)},	undef,	"to_unicode\(\'\\u0663\\uD93A\\uDFBB\-｡\\uD803\\uDD3E\\uA92Bᢊ\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}\x{5EBBB}-｡\x{10D3E}\x{A92B}ᢊ<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0663\\uD93A\\uDFBB\-｡\\uD803\\uDD3E\\uA92Bᢊ\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}\x{5EBBB}-。\x{10D3E}\x{A92B}ᢊ≮", %p)},	undef,	"to_unicode\(\'\\u0663\\uD93A\\uDFBB\-\。\\uD803\\uDD3E\\uA92Bᢊ\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}\x{5EBBB}-。\x{10D3E}\x{A92B}ᢊ<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0663\\uD93A\\uDFBB\-\。\\uD803\\uDD3E\\uA92Bᢊ\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C2}.\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C2}.\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C2}.\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C2\.\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C1}\x{0654}.\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654\.\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200C}\x{E010D}\x{06C2}．\x{E08AF}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C2}．\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C2}．\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C2．\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{E010D}\x{06C1}\x{0654}．\x{E08AF}Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uDB40\\uDD0D\\u06C1\\u0654．\\uDB42\\uDCAFჁⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ς\x{E0130}", %p)},	undef,	"to_unicode\(\'\\u200D\。ς\\uDB40\\uDD30\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ς\x{E0130}", %p)},	undef,	"to_unicode\(\'\\u200D\。ς\\uDB40\\uDD30\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。Σ\x{E0130}", %p)},	undef,	"to_unicode\(\'\\u200D\。Σ\\uDB40\\uDD30\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。Σ\x{E0130}", %p)},	undef,	"to_unicode\(\'\\u200D\。Σ\\uDB40\\uDD30\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。σ\x{E0130}", %p)},	undef,	"to_unicode\(\'\\u200D\。σ\\uDB40\\uDD30\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。σ\x{E0130}", %p)},	undef,	"to_unicode\(\'\\u200D\。σ\\uDB40\\uDD30\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4xa", %p)},	"σ",	"to_unicode\(\'xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ", %p)},	"σ",	"to_unicode\(\'σ\'\)\ \[data\/IdnaTest\.txt\:2466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ", %p)},	"σ",	"to_unicode\(\'Σ\'\)\ \[data\/IdnaTest\.txt\:2467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}ß.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9ß\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}ß.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9ß\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}SS.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9SS\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}SS.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9SS\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}ss.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9ss\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}ss.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9ss\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}Ss.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9Ss\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EAD9}Ss.ᡩ\x{200D}᠇-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDED9Ss\.ᡩ\\u200D᠇\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D9}\x{200D}\x{10AD9}．\x{0662}\x{C9468}-", %p)},	undef,	"to_unicode\(\'\\u06D9\\u200D\\uD802\\uDED9．\\u0662\\uDAE5\\uDC68\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D9}\x{200D}\x{10AD9}．\x{0662}\x{C9468}-", %p)},	undef,	"to_unicode\(\'\\u06D9\\u200D\\uD802\\uDED9．\\u0662\\uDAE5\\uDC68\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D9}\x{200D}\x{10AD9}.\x{0662}\x{C9468}-", %p)},	undef,	"to_unicode\(\'\\u06D9\\u200D\\uD802\\uDED9\.\\u0662\\uDAE5\\uDC68\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D9}\x{200D}\x{10AD9}.\x{0662}\x{C9468}-", %p)},	undef,	"to_unicode\(\'\\u06D9\\u200D\\uD802\\uDED9\.\\u0662\\uDAE5\\uDC68\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒒\x{46F93}\x{9AB6E}\x{1BC9D}.-\x{1ADFC}", %p)},	undef,	"to_unicode\(\'⒒\\uD8DB\\uDF93\\uDA2A\\uDF6E\\uD82F\\uDC9D\.\-\\uD82B\\uDDFC\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("11.\x{46F93}\x{9AB6E}\x{1BC9D}.-\x{1ADFC}", %p)},	undef,	"to_unicode\(\'11\.\\uD8DB\\uDF93\\uDA2A\\uDF6E\\uD82F\\uDC9D\.\-\\uD82B\\uDDFC\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{06AC}．ς¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u06AC．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{06AC}．ς¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u06AC．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{06AC}.ς1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u06AC\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{06AC}.ς1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u06AC\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{06AC}.Σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u06AC\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{06AC}.Σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u06AC\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{06AC}.σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u06AC\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{06AC}.σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u06AC\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{06AC}．Σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u06AC．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{06AC}．Σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u06AC．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{06AC}．σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u06AC．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{06AC}．σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u06AC．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ\x{10D412}\x{892C7}｡\x{FB2A}𝟠", %p)},	undef,	"to_unicode\(\'ቬ\\uDBF5\\uDC12\\uD9E4\\uDEC7｡\\uFB2A𝟠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ\x{10D412}\x{892C7}｡\x{05E9}\x{05C1}𝟠", %p)},	undef,	"to_unicode\(\'ቬ\\uDBF5\\uDC12\\uD9E4\\uDEC7｡\\u05E9\\u05C1𝟠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ\x{10D412}\x{892C7}。\x{05E9}\x{05C1}8", %p)},	undef,	"to_unicode\(\'ቬ\\uDBF5\\uDC12\\uD9E4\\uDEC7\。\\u05E9\\u05C18\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10CED}。蔫\x{10AC7}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDCED\。蔫\\uD802\\uDEC7\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C3EFD}₃｡\x{06BD}\x{AA9F5}\x{0339}ᢤ", %p)},	undef,	"to_unicode\(\'\\uDACF\\uDEFD₃｡\\u06BD\\uDA6A\\uDDF5\\u0339ᢤ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C3EFD}3。\x{06BD}\x{AA9F5}\x{0339}ᢤ", %p)},	undef,	"to_unicode\(\'\\uDACF\\uDEFD3\。\\u06BD\\uDA6A\\uDDF5\\u0339ᢤ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7E575}\x{0680}≠.ß", %p)},	undef,	"to_unicode\(\'\\uD9B9\\uDD75\\u0680\≠\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7E575}\x{0680}=\x{0338}.ß", %p)},	undef,	"to_unicode\(\'\\uD9B9\\uDD75\\u0680\=\\u0338\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7E575}\x{0680}=\x{0338}.SS", %p)},	undef,	"to_unicode\(\'\\uD9B9\\uDD75\\u0680\=\\u0338\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7E575}\x{0680}≠.SS", %p)},	undef,	"to_unicode\(\'\\uD9B9\\uDD75\\u0680\≠\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E0}\x{06AE}\x{0EB6}⒊.\x{0666}\x{10C4F}\x{FFF3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07E0\\u06AE\\u0EB6⒊\.\\u0666\\uD803\\uDC4F\\uFFF3\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E0}\x{06AE}\x{0EB6}⒊.\x{0666}\x{10C4F}\x{FFF3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07E0\\u06AE\\u0EB6⒊\.\\u0666\\uD803\\uDC4F\\uFFF3\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E0}\x{06AE}\x{0EB6}3..\x{0666}\x{10C4F}\x{FFF3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07E0\\u06AE\\u0EB63\.\.\\u0666\\uD803\\uDC4F\\uFFF3\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:2510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E0}\x{06AE}\x{0EB6}3..\x{0666}\x{10C4F}\x{FFF3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07E0\\u06AE\\u0EB63\.\.\\u0666\\uD803\\uDC4F\\uFFF3\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:2511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ\x{AC529}", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ\\uDA71\\uDD29\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。🕔𝟲", %p)},	undef,	"to_unicode\(\'\≠\。🕔𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。🕔𝟲", %p)},	undef,	"to_unicode\(\'\=\\u0338\。🕔𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。🕔6", %p)},	undef,	"to_unicode\(\'\≠\。🕔6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。🕔6", %p)},	undef,	"to_unicode\(\'\=\\u0338\。🕔6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{4BD2D}.蠔", %p)},	undef,	"to_unicode\(\'\\uD8EF\\uDD2D\.蠔\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FC6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FC6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₇\x{0C4D}\x{5C5D9}\x{1EABB}。🎵ᡐ-\x{0830}", %p)},	undef,	"to_unicode\(\'₇\\u0C4D\\uD931\\uDDD9\\uD83A\\uDEBB\。🎵ᡐ\-\\u0830\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("7\x{0C4D}\x{5C5D9}\x{1EABB}。🎵ᡐ-\x{0830}", %p)},	undef,	"to_unicode\(\'7\\u0C4D\\uD931\\uDDD9\\uD83A\\uDEBB\。🎵ᡐ\-\\u0830\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡ᡌ", %p)},	undef,	"to_unicode\(\'\-｡ᡌ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。ᡌ", %p)},	undef,	"to_unicode\(\'\-\。ᡌ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0740}\x{4B3A8}｡-⒈\x{06C9}\x{069C}", %p)},	undef,	"to_unicode\(\'\\u0740\\uD8EC\\uDFA8｡\-⒈\\u06C9\\u069C\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0740}\x{4B3A8}。-1.\x{06C9}\x{069C}", %p)},	undef,	"to_unicode\(\'\\u0740\\uD8EC\\uDFA8\。\-1\.\\u06C9\\u069C\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:2538\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("璛\x{1134D}\x{0778}.-", %p)},	undef,	"to_unicode\(\'璛\\uD804\\uDF4D\\u0778\.\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2539\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1B02}ᠰ\x{1BF3}샕．\x{10E73}휁", %p)},	undef,	"to_unicode\(\'\\u1B02ᠰ\\u1BF3샕．\\uD803\\uDE73휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2540\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1B02}ᠰ\x{1BF3}샕．\x{10E73}휁", %p)},	undef,	"to_unicode\(\'\\u1B02ᠰ\\u1BF3샕．\\uD803\\uDE73휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2541\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1B02}ᠰ\x{1BF3}샕.\x{10E73}휁", %p)},	undef,	"to_unicode\(\'\\u1B02ᠰ\\u1BF3샕\.\\uD803\\uDE73휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2542\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1B02}ᠰ\x{1BF3}샕.\x{10E73}휁", %p)},	undef,	"to_unicode\(\'\\u1B02ᠰ\\u1BF3샕\.\\uD803\\uDE73휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2543\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{643C0}．\x{705C2}", %p)},	undef,	"to_unicode\(\'\\uD950\\uDFC0．\\uD981\\uDDC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{643C0}.\x{705C2}", %p)},	undef,	"to_unicode\(\'\\uD950\\uDFC0\.\\uD981\\uDDC2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{1EBD2}｡\x{116B6}\x{076F}Ⴍ-", %p)},	undef,	"to_unicode\(\'\\u0628\\uD83A\\uDFD2｡\\uD805\\uDEB6\\u076FႭ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{1EBD2}。\x{116B6}\x{076F}Ⴍ-", %p)},	undef,	"to_unicode\(\'\\u0628\\uD83A\\uDFD2\。\\uD805\\uDEB6\\u076FႭ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{1EBD2}。\x{116B6}\x{076F}ⴍ-", %p)},	undef,	"to_unicode\(\'\\u0628\\uD83A\\uDFD2\。\\uD805\\uDEB6\\u076Fⴍ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}\x{1EBD2}｡\x{116B6}\x{076F}ⴍ-", %p)},	undef,	"to_unicode\(\'\\u0628\\uD83A\\uDFD2｡\\uD805\\uDEB6\\u076Fⴍ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED87}\x{1ED3B}\x{1ED6F}。\x{ECADE}₄Ⴋ\x{2C6DF}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD87\\uD83B\\uDD3B\\uD83B\\uDD6F\。\\uDB72\\uDEDE₄Ⴋ\\uD871\\uDEDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED87}\x{1ED3B}\x{1ED6F}。\x{ECADE}4Ⴋ\x{2C6DF}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD87\\uD83B\\uDD3B\\uD83B\\uDD6F\。\\uDB72\\uDEDE4Ⴋ\\uD871\\uDEDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED87}\x{1ED3B}\x{1ED6F}。\x{ECADE}4ⴋ\x{2C6DF}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD87\\uD83B\\uDD3B\\uD83B\\uDD6F\。\\uDB72\\uDEDE4ⴋ\\uD871\\uDEDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ED87}\x{1ED3B}\x{1ED6F}。\x{ECADE}₄ⴋ\x{2C6DF}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD87\\uD83B\\uDD3B\\uD83B\\uDD6F\。\\uDB72\\uDEDE₄ⴋ\\uD871\\uDEDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{064A}︒\x{2DEA}.≠", %p)},	undef,	"to_unicode\(\'4\\u064A︒\\u2DEA\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{064A}︒\x{2DEA}.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u064A︒\\u2DEA\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{064A}。\x{2DEA}.≠", %p)},	undef,	"to_unicode\(\'4\\u064A\。\\u2DEA\.\≠\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{064A}。\x{2DEA}.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u064A\。\\u2DEA\.\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟓。\x{0308}", %p)},	undef,	"to_unicode\(\'𝟓\。\\u0308\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5。\x{0308}", %p)},	undef,	"to_unicode\(\'5\。\\u0308\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{15986}.⾕", %p)},	undef,	"to_unicode\(\'\\u200C\\uD816\\uDD86\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{15986}.⾕", %p)},	undef,	"to_unicode\(\'\\u200C\\uD816\\uDD86\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{15986}.谷", %p)},	undef,	"to_unicode\(\'\\u200C\\uD816\\uDD86\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{15986}.谷", %p)},	undef,	"to_unicode\(\'\\u200C\\uD816\\uDD86\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{5D409}\x{200D}.-\x{1DDD}\x{200C}", %p)},	undef,	"to_unicode\(\'︒\\uD935\\uDC09\\u200D\.\-\\u1DDD\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{5D409}\x{200D}.-\x{1DDD}\x{200C}", %p)},	undef,	"to_unicode\(\'︒\\uD935\\uDC09\\u200D\.\-\\u1DDD\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。\x{5D409}\x{200D}.-\x{1DDD}\x{200C}", %p)},	undef,	"to_unicode\(\'\。\\uD935\\uDC09\\u200D\.\-\\u1DDD\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。\x{5D409}\x{200D}.-\x{1DDD}\x{200C}", %p)},	undef,	"to_unicode\(\'\。\\uD935\\uDC09\\u200D\.\-\\u1DDD\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{06BC}。ᢇ", %p)},	undef,	"to_unicode\(\'\≯\\u06BC\。ᢇ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{06BC}。ᢇ", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u06BC\。ᢇ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E010C}\x{B4C0E}📁。ᠹ\x{0600}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD0C\\uDA93\\uDC0E📁\。ᠹ\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B9}\x{0712}⁷𝟹｡𝟬", %p)},	undef,	"to_unicode\(\'\\u17B9\\u0712⁷𝟹｡𝟬\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B9}\x{0712}73。0", %p)},	undef,	"to_unicode\(\'\\u17B9\\u071273\。0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．𝟗", %p)},	undef,	"to_unicode\(\'\\u200D．𝟗\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．𝟗", %p)},	undef,	"to_unicode\(\'\\u200D．𝟗\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.9", %p)},	undef,	"to_unicode\(\'\\u200D\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.9", %p)},	undef,	"to_unicode\(\'\\u200D\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9", %p)},	"9",	"to_unicode\(\'9\'\)\ \[data\/IdnaTest\.txt\:2577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}\x{06C8}\x{10E616}。ꡕ\x{E0189}", %p)},	undef,	"to_unicode\(\'\\u084F\\u06C8\\uDBF9\\uDE16\。ꡕ\\uDB40\\uDD89\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡛ５ᡍ겙。\x{E01D4}\x{1EC92}", %p)},	undef,	"to_unicode\(\'ꡛ５ᡍ겙\。\\uDB40\\uDDD4\\uD83B\\uDC92\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡛ５ᡍ겙。\x{E01D4}\x{1EC92}", %p)},	undef,	"to_unicode\(\'ꡛ５ᡍ겙\。\\uDB40\\uDDD4\\uD83B\\uDC92\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡛ5ᡍ겙。\x{E01D4}\x{1EC92}", %p)},	undef,	"to_unicode\(\'ꡛ5ᡍ겙\。\\uDB40\\uDDD4\\uD83B\\uDC92\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡛ5ᡍ겙。\x{E01D4}\x{1EC92}", %p)},	undef,	"to_unicode\(\'ꡛ5ᡍ겙\。\\uDB40\\uDDD4\\uD83B\\uDC92\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ\x{FC775}\x{06A2}\x{0309}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\\uDBB1\\uDF75\\u06A2\\u0309\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ\x{FC775}\x{06A2}\x{0309}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\\uDBB1\\uDF75\\u06A2\\u0309\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ\x{FC775}\x{06A2}\x{0309}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\\uDBB1\\uDF75\\u06A2\\u0309\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ\x{FC775}\x{06A2}\x{0309}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\\uDBB1\\uDF75\\u06A2\\u0309\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋰。\x{530CD}", %p)},	undef,	"to_unicode\(\'𐋰\。\\uD90C\\uDCCD\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E7710}\x{17B4}\x{1BAA}.\x{10E74}", %p)},	undef,	"to_unicode\(\'\\uDB5D\\uDF10\\u17B4\\u1BAA\.\\uD803\\uDE74\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}Ⴋ\x{859EE}\x{6B0B3}．\x{94A54}𝟢휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6Ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3．\\uDA12\\uDE54𝟢휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}Ⴋ\x{859EE}\x{6B0B3}．\x{94A54}𝟢휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6Ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3．\\uDA12\\uDE54𝟢휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}Ⴋ\x{859EE}\x{6B0B3}.\x{94A54}0휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6Ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3\.\\uDA12\\uDE540휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}Ⴋ\x{859EE}\x{6B0B3}.\x{94A54}0휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6Ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3\.\\uDA12\\uDE540휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}ⴋ\x{859EE}\x{6B0B3}.\x{94A54}0휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3\.\\uDA12\\uDE540휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}ⴋ\x{859EE}\x{6B0B3}.\x{94A54}0휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3\.\\uDA12\\uDE540휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}ⴋ\x{859EE}\x{6B0B3}．\x{94A54}𝟢휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3．\\uDA12\\uDE54𝟢휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0EB6}ⴋ\x{859EE}\x{6B0B3}．\x{94A54}𝟢휪\x{206D}", %p)},	undef,	"to_unicode\(\'\\u0EB6ⴋ\\uD9D6\\uDDEE\\uD96C\\uDCB3．\\uDA12\\uDE54𝟢휪\\u206D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2596\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{067F}．\x{FC82}\x{10E74}", %p)},	"\x{067F}.\x{0643}\x{0645}\x{10E74}",	"to_unicode\(\'\\u067F．\\uFC82\\uD803\\uDE74\'\)\ \[data\/IdnaTest\.txt\:2597\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{067F}.\x{0643}\x{0645}\x{10E74}", %p)},	"\x{067F}.\x{0643}\x{0645}\x{10E74}",	"to_unicode\(\'\\u067F\.\\u0643\\u0645\\uD803\\uDE74\'\)\ \[data\/IdnaTest\.txt\:2598\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--4ib.xn--fhbe7004r", %p)},	"\x{067F}.\x{0643}\x{0645}\x{10E74}",	"to_unicode\(\'xn\-\-4ib\.xn\-\-fhbe7004r\'\)\ \[data\/IdnaTest\.txt\:2599\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1714}₃.8\x{11134}\x{200D}\x{E087B}", %p)},	undef,	"to_unicode\(\'\\u1714₃\.8\\uD804\\uDD34\\u200D\\uDB42\\uDC7B\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}3.8\x{11134}\x{200D}\x{E087B}", %p)},	undef,	"to_unicode\(\'\\u17143\.8\\uD804\\uDD34\\u200D\\uDB42\\uDC7B\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0BFE}⩷\x{E019C}。\x{10810}\x{116B0}\x{1E8D1}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDFFE\⩷\\uDB40\\uDD9C\。\\uD802\\uDC10\\uD805\\uDEB0\\uD83A\\uDCD1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡨ≠\x{110B3}\x{E418C}｡\x{FC41}\x{116B5}\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡨ\≠\\uD804\\uDCB3\\uDB50\\uDD8C｡\\uFC41\\uD805\\uDEB5\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡨ=\x{0338}\x{110B3}\x{E418C}｡\x{FC41}\x{116B5}\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡨ\=\\u0338\\uD804\\uDCB3\\uDB50\\uDD8C｡\\uFC41\\uD805\\uDEB5\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡨ≠\x{110B3}\x{E418C}。\x{0644}\x{062E}\x{116B5}\x{1160}", %p)},	undef,	"to_unicode\(\'ꡨ\≠\\uD804\\uDCB3\\uDB50\\uDD8C\。\\u0644\\u062E\\uD805\\uDEB5\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡨ=\x{0338}\x{110B3}\x{E418C}。\x{0644}\x{062E}\x{116B5}\x{1160}", %p)},	undef,	"to_unicode\(\'ꡨ\=\\u0338\\uD804\\uDCB3\\uDB50\\uDD8C\。\\u0644\\u062E\\uD805\\uDEB5\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊\。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊\。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--rt6a.", %p)},	"鱊.",	"to_unicode\(\'xn\-\-rt6a\.\'\)\ \[data\/IdnaTest\.txt\:2609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊.", %p)},	"鱊.",	"to_unicode\(\'鱊\.\'\)\ \[data\/IdnaTest\.txt\:2610\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("8\x{10E7D}．\x{0C62}", %p)},	undef,	"to_unicode\(\'8\\uD803\\uDE7D．\\u0C62\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2611\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("8\x{10E7D}.\x{0C62}", %p)},	undef,	"to_unicode\(\'8\\uD803\\uDE7D\.\\u0C62\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2612\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🁈\x{10E2C}．\x{07E7}", %p)},	undef,	"to_unicode\(\'🁈\\uD803\\uDE2C．\\u07E7\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🁈\x{10E2C}.\x{07E7}", %p)},	undef,	"to_unicode\(\'🁈\\uD803\\uDE2C\.\\u07E7\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2614\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC3}ᢓ4．\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3ᢓ4．\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC3}ᢓ4．\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3ᢓ4．\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2616\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC3}ᢓ4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3ᢓ4\.\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2617\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10AC3}ᢓ4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3ᢓ4\.\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2618\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒗\x{FE0C}\x{0364}-.\x{10E67}⛣", %p)},	undef,	"to_unicode\(\'⒗\\uFE0C\\u0364\-\.\\uD803\\uDE67\⛣\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2619\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("16.\x{FE0C}\x{0364}-.\x{10E67}⛣", %p)},	undef,	"to_unicode\(\'16\.\\uFE0C\\u0364\-\.\\uD803\\uDE67\⛣\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2620\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡䏛", %p)},	undef,	"to_unicode\(\'\-｡䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。䏛", %p)},	undef,	"to_unicode\(\'\-\。䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{CB084}．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAEC\\uDC84．\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{CB084}．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAEC\\uDC84．\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{CB084}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAEC\\uDC84\.\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{CB084}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAEC\\uDC84\.\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E0011}\x{54F5D}｡\x{10E6B}\x{200D}\x{5F1C8}Ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDC11\\uD913\\uDF5D｡\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E0011}\x{54F5D}｡\x{10E6B}\x{200D}\x{5F1C8}Ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDC11\\uD913\\uDF5D｡\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E0011}\x{54F5D}。\x{10E6B}\x{200D}\x{5F1C8}Ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDC11\\uD913\\uDF5D\。\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E0011}\x{54F5D}。\x{10E6B}\x{200D}\x{5F1C8}Ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDC11\\uD913\\uDF5D\。\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E0011}\x{54F5D}。\x{10E6B}\x{200D}\x{5F1C8}ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDC11\\uD913\\uDF5D\。\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E0011}\x{54F5D}。\x{10E6B}\x{200D}\x{5F1C8}ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDC11\\uD913\\uDF5D\。\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E0011}\x{54F5D}｡\x{10E6B}\x{200D}\x{5F1C8}ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDC11\\uD913\\uDF5D｡\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E0011}\x{54F5D}｡\x{10E6B}\x{200D}\x{5F1C8}ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDC11\\uD913\\uDF5D｡\\uD803\\uDE6B\\u200D\\uD93C\\uDDC8ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-ß｡\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-ß｡\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-ß。\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-ß\。\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-SS。\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-SS\。\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-ss。\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-ss\。\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-Ss。\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-Ss\。\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-SS｡\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-SS｡\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-ss｡\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-ss｡\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10FB5}ꡡ-Ss｡\x{1921}効\x{10E7A}\x{11930}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDFB5ꡡ\-Ss｡\\u1921効\\uD803\\uDE7A\\uD806\\uDD30\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}.⅋", %p)},	undef,	"to_unicode\(\'\\u0A4D\.⅋\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E03AA}3\x{1ECA8}｡𝟘\x{11235}\x{1081E}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDFAA3\\uD83B\\uDCA8｡𝟘\\uD804\\uDE35\\uD802\\uDC1E\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E03AA}3\x{1ECA8}。0\x{11235}\x{1081E}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDFAA3\\uD83B\\uDCA8\。0\\uD804\\uDE35\\uD802\\uDC1E\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2645\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{075F}６\x{0613}\x{10B8A}。\x{E013A}", %p)},	"\x{075F}6\x{0613}\x{10B8A}.",	"to_unicode\(\'\\u075F６\\u0613\\uD802\\uDF8A\。\\uDB40\\uDD3A\'\)\ \[data\/IdnaTest\.txt\:2646\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{075F}6\x{0613}\x{10B8A}。\x{E013A}", %p)},	"\x{075F}6\x{0613}\x{10B8A}.",	"to_unicode\(\'\\u075F6\\u0613\\uD802\\uDF8A\。\\uDB40\\uDD3A\'\)\ \[data\/IdnaTest\.txt\:2647\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--6-ulc80h3630e.", %p)},	"\x{075F}6\x{0613}\x{10B8A}.",	"to_unicode\(\'xn\-\-6\-ulc80h3630e\.\'\)\ \[data\/IdnaTest\.txt\:2648\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{075F}6\x{0613}\x{10B8A}.", %p)},	"\x{075F}6\x{0613}\x{10B8A}.",	"to_unicode\(\'\\u075F6\\u0613\\uD802\\uDF8A\.\'\)\ \[data\/IdnaTest\.txt\:2649\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E7E}-ॴႢ。\x{9E7C0}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\-ॴႢ\。\\uDA39\\uDFC0\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7E}-ॴႢ。\x{9E7C0}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\-ॴႢ\。\\uDA39\\uDFC0\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7E}-ॴⴂ。\x{9E7C0}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\-ॴⴂ\。\\uDA39\\uDFC0\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7E}-ॴⴂ。\x{9E7C0}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\-ॴⴂ\。\\uDA39\\uDFC0\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５≯ß", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\≯ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５>\x{0338}ß", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5≯ß", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\≯ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5>\x{0338}ß", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5>\x{0338}SS", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5≯SS", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\≯SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5≯ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\≯ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5>\x{0338}ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0753}5≯Ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07535\≯Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５>\x{0338}SS", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５≯SS", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\≯SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５≯ss", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\≯ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５>\x{0338}ss", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0753}５≯Ss", %p)},	undef,	"to_unicode\(\'⾆．\\u0753５\≯Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1163F}8\x{200D}．\x{1BA44}ᡉ", %p)},	undef,	"to_unicode\(\'\\uD805\\uDE3F8\\u200D．\\uD82E\\uDE44ᡉ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1163F}8\x{200D}．\x{1BA44}ᡉ", %p)},	undef,	"to_unicode\(\'\\uD805\\uDE3F8\\u200D．\\uD82E\\uDE44ᡉ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1163F}8\x{200D}.\x{1BA44}ᡉ", %p)},	undef,	"to_unicode\(\'\\uD805\\uDE3F8\\u200D\.\\uD82E\\uDE44ᡉ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1163F}8\x{200D}.\x{1BA44}ᡉ", %p)},	undef,	"to_unicode\(\'\\uD805\\uDE3F8\\u200D\.\\uD82E\\uDE44ᡉ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BCD6}\x{A927}≮\x{8C2D6}．𣪷⁷⏷\x{06BB}", %p)},	undef,	"to_unicode\(\'\\uD82F\\uDCD6\\uA927\≮\\uD9F0\\uDED6．𣪷⁷\⏷\\u06BB\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BCD6}\x{A927}<\x{0338}\x{8C2D6}．𣪷⁷⏷\x{06BB}", %p)},	undef,	"to_unicode\(\'\\uD82F\\uDCD6\\uA927\<\\u0338\\uD9F0\\uDED6．𣪷⁷\⏷\\u06BB\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BCD6}\x{A927}≮\x{8C2D6}.𣪷7⏷\x{06BB}", %p)},	undef,	"to_unicode\(\'\\uD82F\\uDCD6\\uA927\≮\\uD9F0\\uDED6\.𣪷7\⏷\\u06BB\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BCD6}\x{A927}<\x{0338}\x{8C2D6}.𣪷7⏷\x{06BB}", %p)},	undef,	"to_unicode\(\'\\uD82F\\uDCD6\\uA927\<\\u0338\\uD9F0\\uDED6\.𣪷7\⏷\\u06BB\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{071B}.ς", %p)},	"\x{071B}.ς",	"to_unicode\(\'\\u071B\.ς\'\)\ \[data\/IdnaTest\.txt\:2678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{071B}.ς", %p)},	"\x{071B}.ς",	"to_unicode\(\'\\u071B\.ς\'\)\ \[data\/IdnaTest\.txt\:2679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{071B}.Σ", %p)},	"\x{071B}.σ",	"to_unicode\(\'\\u071B\.Σ\'\)\ \[data\/IdnaTest\.txt\:2680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{071B}.σ", %p)},	"\x{071B}.σ",	"to_unicode\(\'\\u071B\.σ\'\)\ \[data\/IdnaTest\.txt\:2681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--lnb.xn--4xa", %p)},	"\x{071B}.σ",	"to_unicode\(\'xn\-\-lnb\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--lnb.xn--3xa", %p)},	"\x{071B}.ς",	"to_unicode\(\'xn\-\-lnb\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2687\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2688\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2689\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2691\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2692\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2693\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--ilj.xn--4xa", %p)},	"ⴚ.σ",	"to_unicode\(\'xn\-\-ilj\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2694\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.σ", %p)},	"ⴚ.σ",	"to_unicode\(\'ⴚ\.σ\'\)\ \[data\/IdnaTest\.txt\:2695\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.Σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2696\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2697\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2698\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.ς", %p)},	undef,	"to_unicode\(\'Ⴚ\.ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2699\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--ilj.xn--3xa", %p)},	"ⴚ.ς",	"to_unicode\(\'xn\-\-ilj\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2700\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2701\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2702\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2703\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2705\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2706\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0679}．\x{10E79}", %p)},	undef,	"to_unicode\(\'\\u0679．\\uD803\\uDE79\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2708\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0679}.\x{10E79}", %p)},	undef,	"to_unicode\(\'\\u0679\.\\uD803\\uDE79\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2709\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0B44}\x{110B9}\x{10BAA}", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\u0B44\\uD804\\uDCB9\\uD802\\uDFAA\'\)\ throws\ error\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:2710\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0B44}\x{110B9}\x{10BAA}", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\u0B44\\uD804\\uDCB9\\uD802\\uDFAA\'\)\ throws\ error\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:2711\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{0B44}\x{110B9}\x{10BAA}", %p)},	undef,	"to_unicode\(\'\\u200D谷\。\\u200C\\u0B44\\uD804\\uDCB9\\uD802\\uDFAA\'\)\ throws\ error\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:2712\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{0B44}\x{110B9}\x{10BAA}", %p)},	undef,	"to_unicode\(\'\\u200D谷\。\\u200C\\u0B44\\uD804\\uDCB9\\uD802\\uDFAA\'\)\ throws\ error\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:2713\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔．\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔．\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔．\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔．\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2715\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔．\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔．\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2716\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔．\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔．\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2717\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔.\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔\.\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2718\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔.\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔\.\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2719\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔.\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔\.\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2720\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}-뉔.\x{07D0}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07CF\-뉔\.\\u07D0\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2721\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𡼫５ᦛς.\x{114C2}ᡓ\x{AA36}\x{0FAE}", %p)},	undef,	"to_unicode\(\'𡼫５ᦛς\.\\uD805\\uDCC2ᡓ\\uAA36\\u0FAE\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2722\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𡼫5ᦛς.\x{114C2}ᡓ\x{AA36}\x{0FAE}", %p)},	undef,	"to_unicode\(\'𡼫5ᦛς\.\\uD805\\uDCC2ᡓ\\uAA36\\u0FAE\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𡼫5ᦛΣ.\x{114C2}ᡓ\x{AA36}\x{0FAE}", %p)},	undef,	"to_unicode\(\'𡼫5ᦛΣ\.\\uD805\\uDCC2ᡓ\\uAA36\\u0FAE\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𡼫5ᦛσ.\x{114C2}ᡓ\x{AA36}\x{0FAE}", %p)},	undef,	"to_unicode\(\'𡼫5ᦛσ\.\\uD805\\uDCC2ᡓ\\uAA36\\u0FAE\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2725\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𡼫５ᦛΣ.\x{114C2}ᡓ\x{AA36}\x{0FAE}", %p)},	undef,	"to_unicode\(\'𡼫５ᦛΣ\.\\uD805\\uDCC2ᡓ\\uAA36\\u0FAE\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2726\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𡼫５ᦛσ.\x{114C2}ᡓ\x{AA36}\x{0FAE}", %p)},	undef,	"to_unicode\(\'𡼫５ᦛσ\.\\uD805\\uDCC2ᡓ\\uAA36\\u0FAE\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2727\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("淽。ᡑ", %p)},	"淽.ᡑ",	"to_unicode\(\'淽\。ᡑ\'\)\ \[data\/IdnaTest\.txt\:2728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--34w.xn--h8e", %p)},	"淽.ᡑ",	"to_unicode\(\'xn\-\-34w\.xn\-\-h8e\'\)\ \[data\/IdnaTest\.txt\:2729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("淽.ᡑ", %p)},	"淽.ᡑ",	"to_unicode\(\'淽\.ᡑ\'\)\ \[data\/IdnaTest\.txt\:2730\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10E73}\x{11237}。-", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73\\uD804\\uDE37\。\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2731\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{700AB}Ⴓ⸫｡\x{1CE5}", %p)},	undef,	"to_unicode\(\'\\uD980\\uDCABႳ\⸫｡\\u1CE5\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{700AB}Ⴓ⸫。\x{1CE5}", %p)},	undef,	"to_unicode\(\'\\uD980\\uDCABႳ\⸫\。\\u1CE5\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{700AB}ⴓ⸫。\x{1CE5}", %p)},	undef,	"to_unicode\(\'\\uD980\\uDCABⴓ\⸫\。\\u1CE5\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{700AB}ⴓ⸫｡\x{1CE5}", %p)},	undef,	"to_unicode\(\'\\uD980\\uDCABⴓ\⸫｡\\u1CE5\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2735\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2739\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ\。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2740\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ\。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2741\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2743\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ\。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2744\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ\。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2745\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2747\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2748\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2749\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2750\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2751\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084Fⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2753\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{084F}Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u084FႧ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B63DA}｡\x{10EFB}", %p)},	undef,	"to_unicode\(\'\\uDA98\\uDFDA｡\\uD803\\uDEFB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B63DA}。\x{10EFB}", %p)},	undef,	"to_unicode\(\'\\uDA98\\uDFDA\。\\uD803\\uDEFB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2757\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1A58}\x{200D}｡\x{1163F}\x{2DE1}", %p)},	undef,	"to_unicode\(\'\\u1A58\\u200D｡\\uD805\\uDE3F\\u2DE1\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2758\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1A58}\x{200D}｡\x{1163F}\x{2DE1}", %p)},	undef,	"to_unicode\(\'\\u1A58\\u200D｡\\uD805\\uDE3F\\u2DE1\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2759\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1A58}\x{200D}。\x{1163F}\x{2DE1}", %p)},	undef,	"to_unicode\(\'\\u1A58\\u200D\。\\uD805\\uDE3F\\u2DE1\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2760\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1A58}\x{200D}。\x{1163F}\x{2DE1}", %p)},	undef,	"to_unicode\(\'\\u1A58\\u200D\。\\uD805\\uDE3F\\u2DE1\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2761\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-≠\x{0844}．ᠵ\x{06B6}≮\x{5987F}", %p)},	undef,	"to_unicode\(\'\-\≠\\u0844．ᠵ\\u06B6\≮\\uD926\\uDC7F\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{0844}．ᠵ\x{06B6}<\x{0338}\x{5987F}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u0844．ᠵ\\u06B6\<\\u0338\\uD926\\uDC7F\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠\x{0844}.ᠵ\x{06B6}≮\x{5987F}", %p)},	undef,	"to_unicode\(\'\-\≠\\u0844\.ᠵ\\u06B6\≮\\uD926\\uDC7F\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{0844}.ᠵ\x{06B6}<\x{0338}\x{5987F}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u0844\.ᠵ\\u06B6\<\\u0338\\uD926\\uDC7F\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⸣≯\x{FBBB}\x{10E92}．\x{547FF}≮\x{1714}ꡣ", %p)},	undef,	"to_unicode\(\'\⸣\≯\\uFBBB\\uD803\\uDE92．\\uD911\\uDFFF\≮\\u1714ꡣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⸣>\x{0338}\x{FBBB}\x{10E92}．\x{547FF}<\x{0338}\x{1714}ꡣ", %p)},	undef,	"to_unicode\(\'\⸣\>\\u0338\\uFBBB\\uD803\\uDE92．\\uD911\\uDFFF\<\\u0338\\u1714ꡣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⸣≯\x{FBBB}\x{10E92}.\x{547FF}≮\x{1714}ꡣ", %p)},	undef,	"to_unicode\(\'\⸣\≯\\uFBBB\\uD803\\uDE92\.\\uD911\\uDFFF\≮\\u1714ꡣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⸣>\x{0338}\x{FBBB}\x{10E92}.\x{547FF}<\x{0338}\x{1714}ꡣ", %p)},	undef,	"to_unicode\(\'\⸣\>\\u0338\\uFBBB\\uD803\\uDE92\.\\uD911\\uDFFF\<\\u0338\\u1714ꡣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠\x{7991E}.\x{10E67}\x{1BAB}-\x{FC85}", %p)},	undef,	"to_unicode\(\'\≠\\uD9A6\\uDD1E\.\\uD803\\uDE67\\u1BAB\-\\uFC85\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}\x{7991E}.\x{10E67}\x{1BAB}-\x{FC85}", %p)},	undef,	"to_unicode\(\'\=\\u0338\\uD9A6\\uDD1E\.\\uD803\\uDE67\\u1BAB\-\\uFC85\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠\x{7991E}.\x{10E67}\x{1BAB}-\x{0644}\x{0645}", %p)},	undef,	"to_unicode\(\'\≠\\uD9A6\\uDD1E\.\\uD803\\uDE67\\u1BAB\-\\u0644\\u0645\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}\x{7991E}.\x{10E67}\x{1BAB}-\x{0644}\x{0645}", %p)},	undef,	"to_unicode\(\'\=\\u0338\\uD9A6\\uDD1E\.\\uD803\\uDE67\\u1BAB\-\\u0644\\u0645\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{030E}\x{08FF}≠｡\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\\u030E\\u08FF\≠｡\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{030E}\x{08FF}=\x{0338}｡\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\\u030E\\u08FF\=\\u0338｡\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{030E}\x{08FF}≠。\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\\u030E\\u08FF\≠\。\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2776\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{030E}\x{08FF}=\x{0338}。\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\\u030E\\u08FF\=\\u0338\。\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{DE6E3}\x{D7C1A}｡\x{1C37}\x{1DDE}ß", %p)},	undef,	"to_unicode\(\'ß\\uDB39\\uDEE3\\uDB1F\\uDC1A｡\\u1C37\\u1DDEß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{DE6E3}\x{D7C1A}。\x{1C37}\x{1DDE}ß", %p)},	undef,	"to_unicode\(\'ß\\uDB39\\uDEE3\\uDB1F\\uDC1A\。\\u1C37\\u1DDEß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{DE6E3}\x{D7C1A}。\x{1C37}\x{1DDE}SS", %p)},	undef,	"to_unicode\(\'SS\\uDB39\\uDEE3\\uDB1F\\uDC1A\。\\u1C37\\u1DDESS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{DE6E3}\x{D7C1A}。\x{1C37}\x{1DDE}ss", %p)},	undef,	"to_unicode\(\'ss\\uDB39\\uDEE3\\uDB1F\\uDC1A\。\\u1C37\\u1DDEss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{DE6E3}\x{D7C1A}。\x{1C37}\x{1DDE}Ss", %p)},	undef,	"to_unicode\(\'Ss\\uDB39\\uDEE3\\uDB1F\\uDC1A\。\\u1C37\\u1DDESs\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{DE6E3}\x{D7C1A}｡\x{1C37}\x{1DDE}SS", %p)},	undef,	"to_unicode\(\'SS\\uDB39\\uDEE3\\uDB1F\\uDC1A｡\\u1C37\\u1DDESS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{DE6E3}\x{D7C1A}｡\x{1C37}\x{1DDE}ss", %p)},	undef,	"to_unicode\(\'ss\\uDB39\\uDEE3\\uDB1F\\uDC1A｡\\u1C37\\u1DDEss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{DE6E3}\x{D7C1A}｡\x{1C37}\x{1DDE}Ss", %p)},	undef,	"to_unicode\(\'Ss\\uDB39\\uDEE3\\uDB1F\\uDC1A｡\\u1C37\\u1DDESs\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1CF4}\x{08B4}\x{200D}.\x{2DF8}\x{10A30}\x{49182}", %p)},	undef,	"to_unicode\(\'\\u1CF4\\u08B4\\u200D\.\\u2DF8\\uD802\\uDE30\\uD8E4\\uDD82\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1CF4}\x{08B4}\x{200D}.\x{2DF8}\x{10A30}\x{49182}", %p)},	undef,	"to_unicode\(\'\\u1CF4\\u08B4\\u200D\.\\u2DF8\\uD802\\uDE30\\uD8E4\\uDD82\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FC57}\x{200C}临。ᡤ\x{7E338}ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\uFC57\\u200C临\。ᡤ\\uD9B8\\uDF38ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FC57}\x{200C}临。ᡤ\x{7E338}ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\uFC57\\u200C临\。ᡤ\\uD9B8\\uDF38ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{064A}\x{062E}\x{200C}临。ᡤ\x{7E338}ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\u064A\\u062E\\u200C临\。ᡤ\\uD9B8\\uDF38ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{064A}\x{062E}\x{200C}临。ᡤ\x{7E338}ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\u064A\\u062E\\u200C临\。ᡤ\\uD9B8\\uDF38ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0854}．\x{17B9}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC54．\\u17B9\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0854}.\x{17B9}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC54\.\\u17B9\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2795\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0634}\x{1B44}．\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\u0634\\u1B44．\\u0ACD\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2796\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0634}\x{1B44}.\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\u0634\\u1B44\.\\u0ACD\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2797\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0334}\x{79DB1}멹。⒛⺘", %p)},	undef,	"to_unicode\(\'\\u0334\\uD9A7\\uDDB1멹\。⒛⺘\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0334}\x{79DB1}멹。⒛⺘", %p)},	undef,	"to_unicode\(\'\\u0334\\uD9A7\\uDDB1멹\。⒛⺘\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0334}\x{79DB1}멹。20.⺘", %p)},	undef,	"to_unicode\(\'\\u0334\\uD9A7\\uDDB1멹\。20\.⺘\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0334}\x{79DB1}멹。20.⺘", %p)},	undef,	"to_unicode\(\'\\u0334\\uD9A7\\uDDB1멹\。20\.⺘\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}⒊", %p)},	undef,	"to_unicode\(\'Ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}⒊", %p)},	undef,	"to_unicode\(\'Ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}3.", %p)},	undef,	"to_unicode\(\'Ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}3.", %p)},	undef,	"to_unicode\(\'Ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}3.", %p)},	undef,	"to_unicode\(\'ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}3.", %p)},	undef,	"to_unicode\(\'ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}⒊", %p)},	undef,	"to_unicode\(\'ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ\x{C091B}릖\x{E0E0B}.\x{071C}\x{10E6B}⒊", %p)},	undef,	"to_unicode\(\'ⴅ\\uDAC2\\uDD1B릖\\uDB43\\uDE0B\.\\u071C\\uD803\\uDE6B⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C\。\。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C\。\。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯ᢟ．₄", %p)},	undef,	"to_unicode\(\'\≯ᢟ．₄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}ᢟ．₄", %p)},	undef,	"to_unicode\(\'\>\\u0338ᢟ．₄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯ᢟ.4", %p)},	undef,	"to_unicode\(\'\≯ᢟ\.4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}ᢟ.4", %p)},	undef,	"to_unicode\(\'\>\\u0338ᢟ\.4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-3.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069D}-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u069D\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BBF}𝟦\x{07E7}\x{A1497}｡Ӏ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFBF𝟦\\u07E7\\uDA45\\uDC97｡Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BBF}4\x{07E7}\x{A1497}。Ӏ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFBF4\\u07E7\\uDA45\\uDC97\。Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BBF}4\x{07E7}\x{A1497}。ӏ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFBF4\\u07E7\\uDA45\\uDC97\。ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BBF}𝟦\x{07E7}\x{A1497}｡ӏ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFBF𝟦\\u07E7\\uDA45\\uDC97｡ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{10E6A}\x{1EEFA}\x{0F9D}🝅", %p)},	undef,	"to_unicode\(\'\-\.\\uD803\\uDE6A\\uD83B\\uDEFA\\u0F9D🝅\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{10E6A}\x{1EEFA}\x{0F9C}\x{0FB7}🝅", %p)},	undef,	"to_unicode\(\'\-\.\\uD803\\uDE6A\\uD83B\\uDEFA\\u0F9C\\u0FB7🝅\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{940E6}\x{06A3}。\x{08F5}\x{E0B98}", %p)},	undef,	"to_unicode\(\'\\uDA10\\uDCE6\\u06A3\。\\u08F5\\uDB42\\uDF98\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷᠻႫ｡\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\≠ႷᠻႫ｡\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷᠻႫ｡\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷᠻႫ｡\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷᠻႫ。\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\≠ႷᠻႫ\。\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷᠻႫ。\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷᠻႫ\。\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗᠻⴋ。\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗᠻⴋ\。\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗᠻⴋ。\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\≠ⴗᠻⴋ\。\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗᠻⴋ。\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\≠Ⴗᠻⴋ\。\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗᠻⴋ。\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗᠻⴋ\。\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗᠻⴋ｡\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗᠻⴋ｡\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗᠻⴋ｡\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\≠ⴗᠻⴋ｡\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗᠻⴋ｡\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\≠Ⴗᠻⴋ｡\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗᠻⴋ｡\x{D907}\x{07EE}\x{077B}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗᠻⴋ｡\\uD907\\u07EE\\u077B觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E76}.\x{FDCD}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE76\.\\uFDCD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E3A}𝟯｡\x{200D}\x{7646B}\x{10E61}\x{112EA}", %p)},	undef,	"to_unicode\(\'\\u0E3A𝟯｡\\u200D\\uD999\\uDC6B\\uD803\\uDE61\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E3A}𝟯｡\x{200D}\x{7646B}\x{10E61}\x{112EA}", %p)},	undef,	"to_unicode\(\'\\u0E3A𝟯｡\\u200D\\uD999\\uDC6B\\uD803\\uDE61\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E3A}3。\x{200D}\x{7646B}\x{10E61}\x{112EA}", %p)},	undef,	"to_unicode\(\'\\u0E3A3\。\\u200D\\uD999\\uDC6B\\uD803\\uDE61\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E3A}3。\x{200D}\x{7646B}\x{10E61}\x{112EA}", %p)},	undef,	"to_unicode\(\'\\u0E3A3\。\\u200D\\uD999\\uDC6B\\uD803\\uDE61\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AF34A}4\x{10E3AD}.≯\x{10E61}\x{ABE8}㉾", %p)},	undef,	"to_unicode\(\'\\uDA7C\\uDF4A4\\uDBF8\\uDFAD\.\≯\\uD803\\uDE61\\uABE8㉾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AF34A}4\x{10E3AD}.>\x{0338}\x{10E61}\x{ABE8}㉾", %p)},	undef,	"to_unicode\(\'\\uDA7C\\uDF4A4\\uDBF8\\uDFAD\.\>\\u0338\\uD803\\uDE61\\uABE8㉾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AF34A}4\x{10E3AD}.≯\x{10E61}\x{ABE8}우", %p)},	undef,	"to_unicode\(\'\\uDA7C\\uDF4A4\\uDBF8\\uDFAD\.\≯\\uD803\\uDE61\\uABE8우\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AF34A}4\x{10E3AD}.>\x{0338}\x{10E61}\x{ABE8}우", %p)},	undef,	"to_unicode\(\'\\uDA7C\\uDF4A4\\uDBF8\\uDFAD\.\>\\u0338\\uD803\\uDE61\\uABE8우\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17F8D}𝟯。⒈\x{ABE5}𝟚\x{2FE5E}", %p)},	undef,	"to_unicode\(\'\\uD81F\\uDF8D𝟯\。⒈\\uABE5𝟚\\uD87F\\uDE5E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17F8D}3。1.\x{ABE5}2\x{2FE5E}", %p)},	undef,	"to_unicode\(\'\\uD81F\\uDF8D3\。1\.\\uABE52\\uD87F\\uDE5E\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}．\x{63FBC}\x{0693}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062．\\uD94F\\uDFBC\\u0693\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}．\x{63FBC}\x{0693}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062．\\uD94F\\uDFBC\\u0693\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}．\x{63FBC}\x{0693}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062．\\uD94F\\uDFBC\\u0693\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}．\x{63FBC}\x{0693}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062．\\uD94F\\uDFBC\\u0693\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}.\x{63FBC}\x{0693}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062\.\\uD94F\\uDFBC\\u0693\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}.\x{63FBC}\x{0693}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062\.\\uD94F\\uDFBC\\u0693\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}.\x{63FBC}\x{0693}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062\.\\uD94F\\uDFBC\\u0693\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡤ\x{068A}\x{2062}.\x{63FBC}\x{0693}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡤ\\u068A\\u2062\.\\uD94F\\uDFBC\\u0693\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0072}｡\x{8A0C8}\x{10E6A}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC72｡\\uD9E8\\uDCC8\\uD803\\uDE6A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0072}。\x{8A0C8}\x{10E6A}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC72\。\\uD9E8\\uDCC8\\uD803\\uDE6A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟥\x{0669}。\x{E0072}", %p)},	undef,	"to_unicode\(\'𝟥\\u0669\。\\uDB40\\uDC72\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3\x{0669}。\x{E0072}", %p)},	undef,	"to_unicode\(\'3\\u0669\。\\uDB40\\uDC72\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2883\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᡘ\x{066B}\x{10E78}.ᠮ긷", %p)},	undef,	"to_unicode\(\'ᡘ\\u066B\\uD803\\uDE78\.ᠮ긷\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2884\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᡘ\x{066B}\x{10E78}.ᠮ긷", %p)},	undef,	"to_unicode\(\'ᡘ\\u066B\\uD803\\uDE78\.ᠮ긷\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2885\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒Ↄ\x{11044}\x{5C059}．Ⴗ\x{1E8F5}", %p)},	undef,	"to_unicode\(\'︒Ↄ\\uD804\\uDC44\\uD930\\uDC59．Ⴗ\\uD83A\\uDCF5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ↄ\x{11044}\x{5C059}.Ⴗ\x{1E8F5}", %p)},	undef,	"to_unicode\(\'\。Ↄ\\uD804\\uDC44\\uD930\\uDC59\.Ⴗ\\uD83A\\uDCF5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ↄ\x{11044}\x{5C059}.ⴗ\x{1E8F5}", %p)},	undef,	"to_unicode\(\'\。ↄ\\uD804\\uDC44\\uD930\\uDC59\.ⴗ\\uD83A\\uDCF5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ↄ\x{11044}\x{5C059}．ⴗ\x{1E8F5}", %p)},	undef,	"to_unicode\(\'︒ↄ\\uD804\\uDC44\\uD930\\uDC59．ⴗ\\uD83A\\uDCF5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2889\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E75}.\x{1CE2}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75\.\\u1CE2\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2890\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς≯｡\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\≯｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}｡\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\>\\u0338｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς≯。\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\≯\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}。\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\>\\u0338\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}。\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯。\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\≯\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯。\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\≯\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}。\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\>\\u0338\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}｡\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯｡\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\≯｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯｡\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\≯｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}｡\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\>\\u0338｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11046}\x{200D}\x{0765}。\x{0600}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC46\\u200D\\u0765\。\\u0600\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{BDEE8}\x{0A42}Ⴊ\x{5B7EC}.≮", %p)},	undef,	"to_unicode\(\'\\uDAB7\\uDEE8\\u0A42Ⴊ\\uD92D\\uDFEC\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{BDEE8}\x{0A42}Ⴊ\x{5B7EC}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDAB7\\uDEE8\\u0A42Ⴊ\\uD92D\\uDFEC\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{BDEE8}\x{0A42}ⴊ\x{5B7EC}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDAB7\\uDEE8\\u0A42ⴊ\\uD92D\\uDFEC\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{BDEE8}\x{0A42}ⴊ\x{5B7EC}.≮", %p)},	undef,	"to_unicode\(\'\\uDAB7\\uDEE8\\u0A42ⴊ\\uD92D\\uDFEC\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2907\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10B86}．۲", %p)},	"\x{10B86}.۲",	"to_unicode\(\'\\uD802\\uDF86．۲\'\)\ \[data\/IdnaTest\.txt\:2908\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10B86}.۲", %p)},	"\x{10B86}.۲",	"to_unicode\(\'\\uD802\\uDF86\.۲\'\)\ \[data\/IdnaTest\.txt\:2909\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--d29c.xn--fmb", %p)},	"\x{10B86}.۲",	"to_unicode\(\'xn\-\-d29c\.xn\-\-fmb\'\)\ \[data\/IdnaTest\.txt\:2910\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E69}\x{E6C0C}｡\x{06C2}🄄", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\\uDB5B\\uDC0C｡\\u06C2🄄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E69}\x{E6C0C}｡\x{06C1}\x{0654}🄄", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\\uDB5B\\uDC0C｡\\u06C1\\u0654🄄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E69}\x{E6C0C}。\x{06C2}3,", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\\uDB5B\\uDC0C\。\\u06C23\,\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E69}\x{E6C0C}。\x{06C1}\x{0654}3,", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\\uDB5B\\uDC0C\。\\u06C1\\u06543\,\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1734}\x{1EF81}\x{05AC}｡\x{200D}\x{AAF6}", %p)},	undef,	"to_unicode\(\'\-\\u1734\\uD83B\\uDF81\\u05AC｡\\u200D\\uAAF6\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1734}\x{1EF81}\x{05AC}｡\x{200D}\x{AAF6}", %p)},	undef,	"to_unicode\(\'\-\\u1734\\uD83B\\uDF81\\u05AC｡\\u200D\\uAAF6\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1734}\x{1EF81}\x{05AC}。\x{200D}\x{AAF6}", %p)},	undef,	"to_unicode\(\'\-\\u1734\\uD83B\\uDF81\\u05AC\。\\u200D\\uAAF6\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1734}\x{1EF81}\x{05AC}。\x{200D}\x{AAF6}", %p)},	undef,	"to_unicode\(\'\-\\u1734\\uD83B\\uDF81\\u05AC\。\\u200D\\uAAF6\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}🄆｡\x{200C}\x{111B8}\x{0345}", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA1🄆｡\\u200C\\uD804\\uDDB8\\u0345\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}🄆｡\x{200C}\x{111B8}\x{0345}", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA1🄆｡\\u200C\\uD804\\uDDB8\\u0345\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}5,。\x{200C}\x{111B8}\x{0345}", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA15\,\。\\u200C\\uD804\\uDDB8\\u0345\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}5,。\x{200C}\x{111B8}\x{0345}", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA15\,\。\\u200C\\uD804\\uDDB8\\u0345\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}5,。\x{200C}\x{111B8}Ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA15\,\。\\u200C\\uD804\\uDDB8Ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}5,。\x{200C}\x{111B8}Ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA15\,\。\\u200C\\uD804\\uDDB8Ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}5,。\x{200C}\x{111B8}ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA15\,\。\\u200C\\uD804\\uDDB8ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}5,。\x{200C}\x{111B8}ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA15\,\。\\u200C\\uD804\\uDDB8ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}🄆｡\x{200C}\x{111B8}Ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA1🄆｡\\u200C\\uD804\\uDDB8Ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}🄆｡\x{200C}\x{111B8}Ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA1🄆｡\\u200C\\uD804\\uDDB8Ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}🄆｡\x{200C}\x{111B8}ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA1🄆｡\\u200C\\uD804\\uDDB8ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{16B34}\x{200C}\x{104EA1}🄆｡\x{200C}\x{111B8}ι", %p)},	undef,	"to_unicode\(\'\\uD81A\\uDF34\\u200C\\uDBD3\\uDEA1🄆｡\\u200C\\uD804\\uDDB8ι\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2930\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("兎｡\x{0845}😤\x{1134D}\x{0F84}", %p)},	undef,	"to_unicode\(\'兎｡\\u0845😤\\uD804\\uDF4D\\u0F84\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2931\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("兎。\x{0845}😤\x{1134D}\x{0F84}", %p)},	undef,	"to_unicode\(\'兎\。\\u0845😤\\uD804\\uDF4D\\u0F84\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2932\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	undef,	"to_unicode\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	undef,	"to_unicode\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1。\x{200D}2\x{200D}7", %p)},	undef,	"to_unicode\(\'1\。\\u200D2\\u200D7\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1。\x{200D}2\x{200D}7", %p)},	undef,	"to_unicode\(\'1\。\\u200D2\\u200D7\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.27", %p)},	"1.27",	"to_unicode\(\'1\.27\'\)\ \[data\/IdnaTest\.txt\:2937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A1}-｡⽊𝟷", %p)},	undef,	"to_unicode\(\'\\u06A1\-｡⽊𝟷\'\)\ throws\ error\ V3\ B3\ \[data\/IdnaTest\.txt\:2938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A1}-。木1", %p)},	undef,	"to_unicode\(\'\\u06A1\-\。木1\'\)\ throws\ error\ V3\ B3\ \[data\/IdnaTest\.txt\:2939\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1CD8}𢖮\x{1EEB9}．\x{10E6C}⁹", %p)},	undef,	"to_unicode\(\'\\u1CD8𢖮\\uD83B\\uDEB9．\\uD803\\uDE6C⁹\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2940\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1CD8}𢖮\x{0636}.\x{10E6C}9", %p)},	undef,	"to_unicode\(\'\\u1CD8𢖮\\u0636\.\\uD803\\uDE6C9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2941\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴜ\x{69115}\x{0315}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\\uD964\\uDD15\\u0315⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{69115}\x{0315}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\\uD964\\uDD15\\u0315⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{69115}\x{0315}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\\uD964\\uDD15\\u0315舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{69115}\x{0315}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\\uD964\\uDD15\\u0315舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{69115}\x{0315}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\\uD964\\uDD15\\u0315舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{69115}\x{0315}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\\uD964\\uDD15\\u0315舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{69115}\x{0315}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\\uD964\\uDD15\\u0315⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{69115}\x{0315}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\\uD964\\uDD15\\u0315⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}𝟰.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0BCD𝟰\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}𝟰.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0BCD𝟰\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0BCD4\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0BCD4\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}Ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36Ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀。\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀\。\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{37E36}ⴞ癀｡\x{11133}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDE36ⴞ癀｡\\uD804\\uDD33\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{D93D5}-\x{A953}。\x{066E}", %p)},	undef,	"to_unicode\(\'\\uDB24\\uDFD5\-\\uA953\。\\u066E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}𝟧≯\x{08B0}．氁\x{C9234}ꁫ", %p)},	undef,	"to_unicode\(\'\\u063D𝟧\≯\\u08B0．氁\\uDAE4\\uDE34ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}𝟧>\x{0338}\x{08B0}．氁\x{C9234}ꁫ", %p)},	undef,	"to_unicode\(\'\\u063D𝟧\>\\u0338\\u08B0．氁\\uDAE4\\uDE34ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}5≯\x{08B0}.氁\x{C9234}ꁫ", %p)},	undef,	"to_unicode\(\'\\u063D5\≯\\u08B0\.氁\\uDAE4\\uDE34ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}5>\x{0338}\x{08B0}.氁\x{C9234}ꁫ", %p)},	undef,	"to_unicode\(\'\\u063D5\>\\u0338\\u08B0\.氁\\uDAE4\\uDE34ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}\x{0340}．\x{064F}", %p)},	undef,	"to_unicode\(\'\\u0660\\u0340．\\u064F\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}\x{0300}．\x{064F}", %p)},	undef,	"to_unicode\(\'\\u0660\\u0300．\\u064F\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}\x{0300}.\x{064F}", %p)},	undef,	"to_unicode\(\'\\u0660\\u0300\.\\u064F\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1112E}⒏．⒎\x{E3EC4}\x{0A81}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDD2E⒏．⒎\\uDB4F\\uDEC4\\u0A81\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{11131}\x{11127}⒏．⒎\x{E3EC4}\x{0A81}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDD31\\uD804\\uDD27⒏．⒎\\uDB4F\\uDEC4\\u0A81\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1112E}8..7.\x{E3EC4}\x{0A81}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDD2E8\.\.7\.\\uDB4F\\uDEC4\\u0A81\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{11131}\x{11127}8..7.\x{E3EC4}\x{0A81}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDD31\\uD804\\uDD278\.\.7\.\\uDB4F\\uDEC4\\u0A81\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}≯\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\≯\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}≯\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\≯\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}>\x{0338}\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\>\\u0338\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}>\x{0338}\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\>\\u0338\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}≯\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\≯\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}≯\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\≯\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}>\x{0338}\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\>\\u0338\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}>\x{0338}\x{DA0F9}\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\>\\u0338\\uDB28\\uDCF9\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{031F}\x{200D}．\x{C8DA6}\x{E0FD4}", %p)},	undef,	"to_unicode\(\'\\u031F\\u200D．\\uDAE3\\uDDA6\\uDB43\\uDFD4\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{031F}\x{200D}．\x{C8DA6}\x{E0FD4}", %p)},	undef,	"to_unicode\(\'\\u031F\\u200D．\\uDAE3\\uDDA6\\uDB43\\uDFD4\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{031F}\x{200D}.\x{C8DA6}\x{E0FD4}", %p)},	undef,	"to_unicode\(\'\\u031F\\u200D\.\\uDAE3\\uDDA6\\uDB43\\uDFD4\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{031F}\x{200D}.\x{C8DA6}\x{E0FD4}", %p)},	undef,	"to_unicode\(\'\\u031F\\u200D\.\\uDAE3\\uDDA6\\uDB43\\uDFD4\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{069D}｡\x{5DC5D}\x{1EF9E}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u069D｡\\uD937\\uDC5D\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3010\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{069D}｡\x{5DC5D}\x{1EF9E}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u069D｡\\uD937\\uDC5D\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{069D}。\x{5DC5D}\x{1EF9E}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u069D\。\\uD937\\uDC5D\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{069D}。\x{5DC5D}\x{1EF9E}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u069D\。\\uD937\\uDC5D\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}≠𝟫-.ς⒍\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u084F\≠𝟫\-\.ς⒍\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}=\x{0338}𝟫-.ς⒍\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u084F\=\\u0338𝟫\-\.ς⒍\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}≠9-.ς6.\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u084F\≠9\-\.ς6\.\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}=\x{0338}9-.ς6.\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u084F\=\\u03389\-\.ς6\.\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}=\x{0338}9-.Σ6.\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u084F\=\\u03389\-\.Σ6\.\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}≠9-.Σ6.\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u084F\≠9\-\.Σ6\.\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}≠9-.σ6.\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u084F\≠9\-\.σ6\.\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}=\x{0338}9-.σ6.\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u084F\=\\u03389\-\.σ6\.\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}=\x{0338}𝟫-.Σ⒍\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u084F\=\\u0338𝟫\-\.Σ⒍\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}≠𝟫-.Σ⒍\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u084F\≠𝟫\-\.Σ⒍\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}≠𝟫-.σ⒍\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u084F\≠𝟫\-\.σ⒍\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084F}=\x{0338}𝟫-.σ⒍\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u084F\=\\u0338𝟫\-\.σ⒍\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6189E}.-\x{0649}\x{0596}\x{0F7B}", %p)},	undef,	"to_unicode\(\'\\uD946\\uDC9E\.\-\\u0649\\u0596\\u0F7B\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{6189E}.-\x{0649}\x{0F7B}\x{0596}", %p)},	undef,	"to_unicode\(\'\\uD946\\uDC9E\.\-\\u0649\\u0F7B\\u0596\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ⒈ß\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ⒈ß\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ1.ß\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ1\.ß\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ1.SS\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ1\.SS\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ1.ss\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ1\.ss\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ1.Ss\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ1\.Ss\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ⒈SS\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ⒈SS\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ⒈ss\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ⒈ss\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠲ⒈Ss\x{1CD5}。\x{14DE9}-", %p)},	undef,	"to_unicode\(\'ᠲ⒈Ss\\u1CD5\。\\uD813\\uDDE9\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}.\x{A953}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9\.\\uA953Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1041D9}．\x{A953}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDBD0\\uDDD9．\\uA953Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆\x{10E6C}.\x{E0E49}", %p)},	undef,	"to_unicode\(\'⾆\\uD803\\uDE6C\.\\uDB43\\uDE49\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌\x{10E6C}.\x{E0E49}", %p)},	undef,	"to_unicode\(\'舌\\uD803\\uDE6C\.\\uDB43\\uDE49\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⻍\x{10E6D}\x{0742}。\x{E0A01}⒈", %p)},	undef,	"to_unicode\(\'⻍\\uD803\\uDE6D\\u0742\。\\uDB42\\uDE01⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⻍\x{10E6D}\x{0742}。\x{E0A01}1.", %p)},	undef,	"to_unicode\(\'⻍\\uD803\\uDE6D\\u0742\。\\uDB42\\uDE011\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}\x{0654}︒．\x{0CCD}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\u0654︒．\\u0CCD\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}\x{0654}︒．\x{0CCD}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\u0654︒．\\u0CCD\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}\x{0654}。.\x{0CCD}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\u0654\。\.\\u0CCD\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}\x{0654}。.\x{0CCD}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\u0654\。\.\\u0CCD\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A94F}。䰀\x{06DD}\x{1E982}\x{E007E}", %p)},	undef,	"to_unicode\(\'\\uA94F\。䰀\\u06DD\\uD83A\\uDD82\\uDB40\\uDC7E\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'ß\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'ß\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'SS\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'SS\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'ss\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'ss\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}.\x{1BF3}\x{18D07}", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.\\u1BF3\\uD823\\uDD07\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}\x{200C}≮.≮", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u200C\≮\.\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}\x{200C}<\x{0338}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u200C\<\\u0338\.\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🃃．\x{FFA0}", %p)},	undef,	"to_unicode\(\'🃃．\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🃃.\x{1160}", %p)},	undef,	"to_unicode\(\'🃃\.\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AEF}\x{1EB5F}。\x{F5D4E}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEEF\\uD83A\\uDF5F\。\\uDB97\\uDD4E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爕\x{A9E55}．𝟰気", %p)},	undef,	"to_unicode\(\'爕\\uDA67\\uDE55．𝟰気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爕\x{A9E55}.4気", %p)},	undef,	"to_unicode\(\'爕\\uDA67\\uDE55\.4気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋\x{11133}Ⴝ-．\x{10878}\x{A9C0}\x{1B6E}", %p)},	undef,	"to_unicode\(\'⒋\\uD804\\uDD33Ⴝ\-．\\uD802\\uDC78\\uA9C0\\u1B6E\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.\x{11133}Ⴝ-.\x{10878}\x{A9C0}\x{1B6E}", %p)},	undef,	"to_unicode\(\'4\.\\uD804\\uDD33Ⴝ\-\.\\uD802\\uDC78\\uA9C0\\u1B6E\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3081\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("4.\x{11133}ⴝ-.\x{10878}\x{A9C0}\x{1B6E}", %p)},	undef,	"to_unicode\(\'4\.\\uD804\\uDD33ⴝ\-\.\\uD802\\uDC78\\uA9C0\\u1B6E\'\)\ throws\ error\ V3\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:3082\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒋\x{11133}ⴝ-．\x{10878}\x{A9C0}\x{1B6E}", %p)},	undef,	"to_unicode\(\'⒋\\uD804\\uDD33ⴝ\-．\\uD802\\uDC78\\uA9C0\\u1B6E\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2BF2D}。访\x{7BF66}--", %p)},	undef,	"to_unicode\(\'\\uD86F\\uDF2D\。访\\uD9AF\\uDF66\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:3084\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0684}｡\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0684｡\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3085\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0684}｡\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0684｡\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3086\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0684}。\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0684\。\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3087\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0684}。\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0684\。\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3088\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10BBA}\x{1ECC8}ᡶ｡\x{06B0}𤌿\x{0639}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFBA\\uD83B\\uDCC8ᡶ｡\\u06B0𤌿\\u0639\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BBA}\x{1ECC8}ᡶ。\x{06B0}𤌿\x{0639}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFBA\\uD83B\\uDCC8ᡶ\。\\u06B0𤌿\\u0639\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034C}\x{1EE31}\x{FD822}\x{0DCA}.\x{0715}\x{07E7}", %p)},	undef,	"to_unicode\(\'\\u034C\\uD83B\\uDE31\\uDBB6\\uDC22\\u0DCA\.\\u0715\\u07E7\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034C}\x{0635}\x{FD822}\x{0DCA}.\x{0715}\x{07E7}", %p)},	undef,	"to_unicode\(\'\\u034C\\u0635\\uDBB6\\uDC22\\u0DCA\.\\u0715\\u07E7\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡ςꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡ςꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3093\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡ςꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡ςꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。ςꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。ςꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。ςꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。ςꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。ΣꡮΣ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。ΣꡮΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。ΣꡮΣ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。ΣꡮΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。Σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。Σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。Σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。Σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。Σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。Σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。Σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。Σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}。σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750\。σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡ΣꡮΣ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡ΣꡮΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡ΣꡮΣ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡ΣꡮΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡Σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡Σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡Σꡮσ", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡Σꡮσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡Σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡Σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡Σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡Σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C28A3}킃\x{10378}\x{0750}｡σꡮς", %p)},	undef,	"to_unicode\(\'\\uDACA\\uDCA3킃\\uD800\\uDF78\\u0750｡σꡮς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3116\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("蔰。\x{A80B}\x{064E}-\x{1134D}", %p)},	undef,	"to_unicode\(\'蔰\。\\uA80B\\u064E\-\\uD804\\uDF4D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3117\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ςჅ。ᡃ", %p)},	undef,	"to_unicode\(\'ςჅ\。ᡃ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3118\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ。ᡃ", %p)},	"ςⴥ.ᡃ",	"to_unicode\(\'ςⴥ\。ᡃ\'\)\ \[data\/IdnaTest\.txt\:3119\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ。ᡃ", %p)},	"ςⴥ.ᡃ",	"to_unicode\(\'ςⴥ\。ᡃ\'\)\ \[data\/IdnaTest\.txt\:3120\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ΣჅ。ᡃ", %p)},	undef,	"to_unicode\(\'ΣჅ\。ᡃ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3121\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("σⴥ。ᡃ", %p)},	"σⴥ.ᡃ",	"to_unicode\(\'σⴥ\。ᡃ\'\)\ \[data\/IdnaTest\.txt\:3122\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("Σⴥ。ᡃ", %p)},	"σⴥ.ᡃ",	"to_unicode\(\'Σⴥ\。ᡃ\'\)\ \[data\/IdnaTest\.txt\:3123\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--4xa203s.xn--27e", %p)},	"σⴥ.ᡃ",	"to_unicode\(\'xn\-\-4xa203s\.xn\-\-27e\'\)\ \[data\/IdnaTest\.txt\:3124\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("σⴥ.ᡃ", %p)},	"σⴥ.ᡃ",	"to_unicode\(\'σⴥ\.ᡃ\'\)\ \[data\/IdnaTest\.txt\:3125\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ΣჅ.ᡃ", %p)},	undef,	"to_unicode\(\'ΣჅ\.ᡃ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3126\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("Σⴥ.ᡃ", %p)},	"σⴥ.ᡃ",	"to_unicode\(\'Σⴥ\.ᡃ\'\)\ \[data\/IdnaTest\.txt\:3127\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--3xa403s.xn--27e", %p)},	"ςⴥ.ᡃ",	"to_unicode\(\'xn\-\-3xa403s\.xn\-\-27e\'\)\ \[data\/IdnaTest\.txt\:3128\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ.ᡃ", %p)},	"ςⴥ.ᡃ",	"to_unicode\(\'ςⴥ\.ᡃ\'\)\ \[data\/IdnaTest\.txt\:3129\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ.ᡃ", %p)},	"ςⴥ.ᡃ",	"to_unicode\(\'ςⴥ\.ᡃ\'\)\ \[data\/IdnaTest\.txt\:3130\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1714}Ⴉ\x{1EDF2}．\x{0F7C}", %p)},	undef,	"to_unicode\(\'\\u1714Ⴉ\\uD83B\\uDDF2．\\u0F7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}Ⴉ\x{1EDF2}.\x{0F7C}", %p)},	undef,	"to_unicode\(\'\\u1714Ⴉ\\uD83B\\uDDF2\.\\u0F7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}ⴉ\x{1EDF2}.\x{0F7C}", %p)},	undef,	"to_unicode\(\'\\u1714ⴉ\\uD83B\\uDDF2\.\\u0F7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}ⴉ\x{1EDF2}．\x{0F7C}", %p)},	undef,	"to_unicode\(\'\\u1714ⴉ\\uD83B\\uDDF2．\\u0F7C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⇓≮\x{7F392}\x{1DEF}。\x{1EAFB}", %p)},	undef,	"to_unicode\(\'\⇓\≮\\uD9BC\\uDF92\\u1DEF\。\\uD83A\\uDEFB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⇓<\x{0338}\x{7F392}\x{1DEF}。\x{1EAFB}", %p)},	undef,	"to_unicode\(\'\⇓\<\\u0338\\uD9BC\\uDF92\\u1DEF\。\\uD83A\\uDEFB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3136\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200Dẏ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3137\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200Dẏ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3138\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200Dy\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3139\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200Dy\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3140\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200Dẏ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3141\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200Dẏ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3142\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200Dy\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3143\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200Dy\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3144\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}Y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200DY\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3145\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}Y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200DY\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3146\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}Ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200DẎ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3147\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}。\x{200D}Ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4\。\\u200DẎ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3148\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--vsb.xn--h8e903a", %p)},	"\x{07D4}.ẏᡑ",	"to_unicode\(\'xn\-\-vsb\.xn\-\-h8e903a\'\)\ \[data\/IdnaTest\.txt\:3149\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}.ẏᡑ", %p)},	"\x{07D4}.ẏᡑ",	"to_unicode\(\'\\u07D4\.ẏᡑ\'\)\ \[data\/IdnaTest\.txt\:3150\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}.y\x{0307}ᡑ", %p)},	"\x{07D4}.ẏᡑ",	"to_unicode\(\'\\u07D4\.y\\u0307ᡑ\'\)\ \[data\/IdnaTest\.txt\:3151\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}.Y\x{0307}ᡑ", %p)},	"\x{07D4}.ẏᡑ",	"to_unicode\(\'\\u07D4\.Y\\u0307ᡑ\'\)\ \[data\/IdnaTest\.txt\:3152\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}.Ẏᡑ", %p)},	"\x{07D4}.ẏᡑ",	"to_unicode\(\'\\u07D4\.Ẏᡑ\'\)\ \[data\/IdnaTest\.txt\:3153\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}Y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200DY\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3154\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}Y\x{0307}\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200DY\\u0307\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3155\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}Ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200DẎ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3156\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D4}｡\x{200D}Ẏ\x{200C}ᡑ", %p)},	undef,	"to_unicode\(\'\\u07D4｡\\u200DẎ\\u200Cᡑ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3157\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0661}\x{0326}。\x{9C6E1}\x{1714}", %p)},	undef,	"to_unicode\(\'\\u0661\\u0326\。\\uDA31\\uDEE1\\u1714\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠\x{10A3F}｡嵕\x{1E8FA}۴\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\≠\\uD802\\uDE3F｡嵕\\uD83A\\uDCFA۴\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{10A3F}｡嵕\x{1E8FA}۴\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\uD802\\uDE3F｡嵕\\uD83A\\uDCFA۴\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠\x{10A3F}。嵕\x{1E8FA}۴\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\≠\\uD802\\uDE3F\。嵕\\uD83A\\uDCFA۴\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{10A3F}。嵕\x{1E8FA}۴\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\uD802\\uDE3F\。嵕\\uD83A\\uDCFA۴\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ．\x{08AA}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ．\\u08AA\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ．\x{08AA}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ．\\u08AA\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ．\x{08AA}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ．\\u08AA\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ．\x{08AA}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ．\\u08AA\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ.\x{08AA}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ\.\\u08AA\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ.\x{08AA}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ\.\\u08AA\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ.\x{08AA}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ\.\\u08AA\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{2DD86}\x{10E6F}ꡑ.\x{08AA}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD877\\uDD86\\uD803\\uDE6Fꡑ\.\\u08AA\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮．\x{17B5}\x{072D}ᠧ", %p)},	undef,	"to_unicode\(\'\≮．\\u17B5\\u072Dᠧ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．\x{17B5}\x{072D}ᠧ", %p)},	undef,	"to_unicode\(\'\<\\u0338．\\u17B5\\u072Dᠧ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.\x{17B5}\x{072D}ᠧ", %p)},	undef,	"to_unicode\(\'\≮\.\\u17B5\\u072Dᠧ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{17B5}\x{072D}ᠧ", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u17B5\\u072Dᠧ\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3178\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06A6}\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D\。ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3179\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06A6}\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D\。ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3180\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06A6}\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3182\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--8jb.xn--0kjya", %p)},	"\x{06A6}.ⴉⴕ",	"to_unicode\(\'xn\-\-8jb\.xn\-\-0kjya\'\)\ \[data\/IdnaTest\.txt\:3183\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06A6}.ⴉⴕ", %p)},	"\x{06A6}.ⴉⴕ",	"to_unicode\(\'\\u06A6\.ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:3184\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06A6}.ႩႵ", %p)},	undef,	"to_unicode\(\'\\u06A6\.ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}.Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\.Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3186\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06A6}\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D｡ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3187\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06A6}\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D｡ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3188\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06A6}\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A6}\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\u06A6\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．\x{A94C}\x{A78B3}\x{E0193}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．\\uA94C\\uDA5E\\uDCB3\\uDB40\\uDD93\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．\x{A94C}\x{A78B3}\x{E0193}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．\\uA94C\\uDA5E\\uDCB3\\uDB40\\uDD93\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.\x{A94C}\x{A78B3}\x{E0193}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.\\uA94C\\uDA5E\\uDCB3\\uDB40\\uDD93\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.\x{A94C}\x{A78B3}\x{E0193}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.\\uA94C\\uDA5E\\uDCB3\\uDB40\\uDD93\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻｡-\x{200C}ᡫႷ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200CᡫႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻｡-\x{200C}ᡫႷ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200CᡫႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻。-\x{200C}ᡫႷ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200CᡫႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻。-\x{200C}ᡫႷ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200CᡫႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3198\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻。-\x{200C}ᡫⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200Cᡫⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3199\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻。-\x{200C}ᡫⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200Cᡫⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻｡-\x{200C}ᡫⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200Cᡫⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3201\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻｡-\x{200C}ᡫⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200Cᡫⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3202\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⦧\x{10823}．≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}．≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}.≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}.≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⦧\x{10823}.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⦧\\uD802\\uDC23\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01AA}\x{E015A}｡\x{108A0}\x{1BAA}🢡", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDAA\\uDB40\\uDD5A｡\\uD802\\uDCA0\\u1BAA🢡\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01AA}\x{E015A}。\x{108A0}\x{1BAA}🢡", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDAA\\uDB40\\uDD5A\。\\uD802\\uDCA0\\u1BAA🢡\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0FB3}₃\x{09CD}．𝟳\x{0595}\x{1A7C}", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0FB3₃\\u09CD．𝟳\\u0595\\u1A7C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0FB3}3\x{09CD}.7\x{0595}\x{1A7C}", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0FB33\\u09CD\.7\\u0595\\u1A7C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3214\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{0FB3}3\x{09CD}.7\x{0595}\x{1A7C}", %p)},	"ⴔ\x{0FB3}3\x{09CD}.7\x{0595}\x{1A7C}",	"to_unicode\(\'ⴔ\\u0FB33\\u09CD\.7\\u0595\\u1A7C\'\)\ \[data\/IdnaTest\.txt\:3215\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--3-d5d246bst9a.xn--7-nec761n", %p)},	"ⴔ\x{0FB3}3\x{09CD}.7\x{0595}\x{1A7C}",	"to_unicode\(\'xn\-\-3\-d5d246bst9a\.xn\-\-7\-nec761n\'\)\ \[data\/IdnaTest\.txt\:3216\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{0FB3}₃\x{09CD}．𝟳\x{0595}\x{1A7C}", %p)},	"ⴔ\x{0FB3}3\x{09CD}.7\x{0595}\x{1A7C}",	"to_unicode\(\'ⴔ\\u0FB3₃\\u09CD．𝟳\\u0595\\u1A7C\'\)\ \[data\/IdnaTest\.txt\:3217\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈\x{1005DF}", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C⒈\\uDBC1\\uDDDF\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈\x{1005DF}", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C⒈\\uDBC1\\uDDDF\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.\x{1005DF}", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C1\.\\uDBC1\\uDDDF\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.\x{1005DF}", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C1\.\\uDBC1\\uDDDF\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3221\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("１\x{1DD1}ß\x{17C9}｡\x{0FA5}", %p)},	undef,	"to_unicode\(\'１\\u1DD1ß\\u17C9｡\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3222\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("1\x{1DD1}ß\x{17C9}。\x{0FA5}", %p)},	undef,	"to_unicode\(\'1\\u1DD1ß\\u17C9\。\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3223\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("1\x{1DD1}SS\x{17C9}。\x{0FA5}", %p)},	undef,	"to_unicode\(\'1\\u1DD1SS\\u17C9\。\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3224\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("1\x{1DD1}ss\x{17C9}。\x{0FA5}", %p)},	undef,	"to_unicode\(\'1\\u1DD1ss\\u17C9\。\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3225\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("1\x{1DD1}Ss\x{17C9}。\x{0FA5}", %p)},	undef,	"to_unicode\(\'1\\u1DD1Ss\\u17C9\。\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3226\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("１\x{1DD1}SS\x{17C9}｡\x{0FA5}", %p)},	undef,	"to_unicode\(\'１\\u1DD1SS\\u17C9｡\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3227\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("１\x{1DD1}ss\x{17C9}｡\x{0FA5}", %p)},	undef,	"to_unicode\(\'１\\u1DD1ss\\u17C9｡\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3228\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("１\x{1DD1}Ss\x{17C9}｡\x{0FA5}", %p)},	undef,	"to_unicode\(\'１\\u1DD1Ss\\u17C9｡\\u0FA5\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3229\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{D1FB5}\x{FD05}\x{AAF6}｡ꡛ⒈", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB07\\uDFB5\\uFD05\\uAAF6｡ꡛ⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{D1FB5}\x{FD05}\x{AAF6}｡ꡛ⒈", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB07\\uDFB5\\uFD05\\uAAF6｡ꡛ⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{D1FB5}\x{0635}\x{0649}\x{AAF6}。ꡛ1.", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB07\\uDFB5\\u0635\\u0649\\uAAF6\。ꡛ1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{D1FB5}\x{0635}\x{0649}\x{AAF6}。ꡛ1.", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB07\\uDFB5\\u0635\\u0649\\uAAF6\。ꡛ1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05B5}．\x{1EB3F}\x{56A35}\x{7D8A0}\x{06BF}", %p)},	undef,	"to_unicode\(\'\\u05B5．\\uD83A\\uDF3F\\uD91A\\uDE35\\uD9B6\\uDCA0\\u06BF\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:3234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05B5}.\x{1EB3F}\x{56A35}\x{7D8A0}\x{06BF}", %p)},	undef,	"to_unicode\(\'\\u05B5\.\\uD83A\\uDF3F\\uD91A\\uDE35\\uD9B6\\uDCA0\\u06BF\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:3235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B8}\x{10F42}⒈．\x{E0E3D}８\x{70305}\x{06A2}", %p)},	undef,	"to_unicode\(\'\\u06B8\\uD803\\uDF42⒈．\\uDB43\\uDE3D８\\uD980\\uDF05\\u06A2\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B8}\x{10F42}1..\x{E0E3D}8\x{70305}\x{06A2}", %p)},	undef,	"to_unicode\(\'\\u06B8\\uD803\\uDF421\.\.\\uDB43\\uDE3D8\\uD980\\uDF05\\u06A2\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05B6}\x{084B}\x{11340}\x{06FB}。-💦\x{9AA5F}", %p)},	undef,	"to_unicode\(\'\\u05B6\\u084B\\uD804\\uDF40\\u06FB\。\-💦\\uDA2A\\uDE5F\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3238\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-.\x{ABED}剘ß᠇", %p)},	undef,	"to_unicode\(\'\-\.\\uABED剘ß᠇\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3239\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-.\x{ABED}剘SS᠇", %p)},	undef,	"to_unicode\(\'\-\.\\uABED剘SS᠇\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3240\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-.\x{ABED}剘ss᠇", %p)},	undef,	"to_unicode\(\'\-\.\\uABED剘ss᠇\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3241\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-.\x{ABED}剘Ss᠇", %p)},	undef,	"to_unicode\(\'\-\.\\uABED剘Ss᠇\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3242\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E05F8}\x{10DB9}｡-", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDDF8\\uD803\\uDDB9｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E05F8}\x{10DB9}。-", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDDF8\\uD803\\uDDB9\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈👡\x{10E78}｡≠\x{10E7B}\x{10E66}", %p)},	undef,	"to_unicode\(\'⒈👡\\uD803\\uDE78｡\≠\\uD803\\uDE7B\\uD803\\uDE66\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈👡\x{10E78}｡=\x{0338}\x{10E7B}\x{10E66}", %p)},	undef,	"to_unicode\(\'⒈👡\\uD803\\uDE78｡\=\\u0338\\uD803\\uDE7B\\uD803\\uDE66\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.👡\x{10E78}。≠\x{10E7B}\x{10E66}", %p)},	undef,	"to_unicode\(\'1\.👡\\uD803\\uDE78\。\≠\\uD803\\uDE7B\\uD803\\uDE66\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.👡\x{10E78}。=\x{0338}\x{10E7B}\x{10E66}", %p)},	undef,	"to_unicode\(\'1\.👡\\uD803\\uDE78\。\=\\u0338\\uD803\\uDE7B\\uD803\\uDE66\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E60}\x{E0822}Ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE60\\uDB42\\uDC22Ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E60}\x{E0822}Ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE60\\uDB42\\uDC22Ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E60}\x{E0822}ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE60\\uDB42\\uDC22ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E60}\x{E0822}ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE60\\uDB42\\uDC22ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{871BE}．\x{07C7}ᢑႳႧ", %p)},	undef,	"to_unicode\(\'\\uD9DC\\uDDBE．\\u07C7ᢑႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{871BE}.\x{07C7}ᢑႳႧ", %p)},	undef,	"to_unicode\(\'\\uD9DC\\uDDBE\.\\u07C7ᢑႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{871BE}.\x{07C7}ᢑⴓⴇ", %p)},	undef,	"to_unicode\(\'\\uD9DC\\uDDBE\.\\u07C7ᢑⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{871BE}.\x{07C7}ᢑႳⴇ", %p)},	undef,	"to_unicode\(\'\\uD9DC\\uDDBE\.\\u07C7ᢑႳⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{871BE}．\x{07C7}ᢑⴓⴇ", %p)},	undef,	"to_unicode\(\'\\uD9DC\\uDDBE．\\u07C7ᢑⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{871BE}．\x{07C7}ᢑႳⴇ", %p)},	undef,	"to_unicode\(\'\\uD9DC\\uDDBE．\\u07C7ᢑႳⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{90229}.\x{109D1}\x{1EF24}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA00\\uDE29\.\\uD802\\uDDD1\\uD83B\\uDF24\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{90229}.\x{109D1}\x{1EF24}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA00\\uDE29\.\\uD802\\uDDD1\\uD83B\\uDF24\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A35D1}⒛\x{E0259}．ꡡ⒈", %p)},	undef,	"to_unicode\(\'\\uDA4D\\uDDD1⒛\\uDB40\\uDE59．ꡡ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A35D1}20.\x{E0259}.ꡡ1.", %p)},	undef,	"to_unicode\(\'\\uDA4D\\uDDD120\.\\uDB40\\uDE59\.ꡡ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}８Ͳ-｡\x{96A0E}\x{1734}\x{1ECA0}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\u08A3８Ͳ\-｡\\uDA1A\\uDE0E\\u1734\\uD83B\\uDCA0\\u1BAB\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}8Ͳ-。\x{96A0E}\x{1734}\x{1ECA0}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\u08A38Ͳ\-\。\\uDA1A\\uDE0E\\u1734\\uD83B\\uDCA0\\u1BAB\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}8ͳ-。\x{96A0E}\x{1734}\x{1ECA0}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\u08A38ͳ\-\。\\uDA1A\\uDE0E\\u1734\\uD83B\\uDCA0\\u1BAB\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08A3}８ͳ-｡\x{96A0E}\x{1734}\x{1ECA0}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\u08A3８ͳ\-｡\\uDA1A\\uDE0E\\u1734\\uD83B\\uDCA0\\u1BAB\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮ß\x{E0131}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮ß\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}ß\x{E0131}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338ß\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰<\x{0338}ß\x{E0131}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\<\\u0338ß\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰≮ß\x{E0131}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\≮ß\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮SS\x{E0131}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮SS\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}SS\x{E0131}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338SS\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰<\x{0338}ss\x{E0131}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\<\\u0338ss\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰≮ss\x{E0131}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\≮ss\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮Ss\x{E0131}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮Ss\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}Ss\x{E0131}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338Ss\\uDB40\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3276\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0675}-.\x{1DF3}꒱\x{E017D}", %p)},	undef,	"to_unicode\(\'\\u0675\-\.\\u1DF3꒱\\uDB40\\uDD7D\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:3277\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0627}\x{0674}-.\x{1DF3}꒱\x{E017D}", %p)},	undef,	"to_unicode\(\'\\u0627\\u0674\-\.\\u1DF3꒱\\uDB40\\uDD7D\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:3278\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E82}\x{200C}.≯䕵◂", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE82\\u200C\.\≯䕵\◂\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E82}\x{200C}.≯䕵◂", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE82\\u200C\.\≯䕵\◂\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E82}\x{200C}.>\x{0338}䕵◂", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE82\\u200C\.\>\\u0338䕵\◂\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E82}\x{200C}.>\x{0338}䕵◂", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE82\\u200C\.\>\\u0338䕵\◂\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}ß\x{10BE5}.\x{08A7}۳︒", %p)},	undef,	"to_unicode\(\'\\u0F84ß\\uD802\\uDFE5\.\\u08A7۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}ß\x{10BE5}.\x{08A7}۳。", %p)},	undef,	"to_unicode\(\'\\u0F84ß\\uD802\\uDFE5\.\\u08A7۳\。\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}SS\x{10BE5}.\x{08A7}۳。", %p)},	undef,	"to_unicode\(\'\\u0F84SS\\uD802\\uDFE5\.\\u08A7۳\。\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}ss\x{10BE5}.\x{08A7}۳。", %p)},	undef,	"to_unicode\(\'\\u0F84ss\\uD802\\uDFE5\.\\u08A7۳\。\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}Ss\x{10BE5}.\x{08A7}۳。", %p)},	undef,	"to_unicode\(\'\\u0F84Ss\\uD802\\uDFE5\.\\u08A7۳\。\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}SS\x{10BE5}.\x{08A7}۳︒", %p)},	undef,	"to_unicode\(\'\\u0F84SS\\uD802\\uDFE5\.\\u08A7۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}ss\x{10BE5}.\x{08A7}۳︒", %p)},	undef,	"to_unicode\(\'\\u0F84ss\\uD802\\uDFE5\.\\u08A7۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F84}Ss\x{10BE5}.\x{08A7}۳︒", %p)},	undef,	"to_unicode\(\'\\u0F84Ss\\uD802\\uDFE5\.\\u08A7۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≮➲\x{0B43}.\x{E0E1F}Ⴁᠥ", %p)},	undef,	"to_unicode\(\'\-\≮\➲\\u0B43\.\\uDB43\\uDE1FႡᠥ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-<\x{0338}➲\x{0B43}.\x{E0E1F}Ⴁᠥ", %p)},	undef,	"to_unicode\(\'\-\<\\u0338\➲\\u0B43\.\\uDB43\\uDE1FႡᠥ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-<\x{0338}➲\x{0B43}.\x{E0E1F}ⴁᠥ", %p)},	undef,	"to_unicode\(\'\-\<\\u0338\➲\\u0B43\.\\uDB43\\uDE1Fⴁᠥ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≮➲\x{0B43}.\x{E0E1F}ⴁᠥ", %p)},	undef,	"to_unicode\(\'\-\≮\➲\\u0B43\.\\uDB43\\uDE1Fⴁᠥ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3294\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0841}｡ᠯ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0841｡ᠯ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3295\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0841}｡ᠯ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0841｡ᠯ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3296\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0841}。ᠯ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0841\。ᠯ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3297\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0841}。ᠯ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0841\。ᠯ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3298\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--zvb.xn--i7e", %p)},	"\x{0841}.ᠯ",	"to_unicode\(\'xn\-\-zvb\.xn\-\-i7e\'\)\ \[data\/IdnaTest\.txt\:3299\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0841}.ᠯ", %p)},	"\x{0841}.ᠯ",	"to_unicode\(\'\\u0841\.ᠯ\'\)\ \[data\/IdnaTest\.txt\:3300\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0651}\x{1D167}．ꡫ\x{A949}\x{10E62}", %p)},	undef,	"to_unicode\(\'\\u0651\\uD834\\uDD67．ꡫ\\uA949\\uD803\\uDE62\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3301\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1D167}\x{0651}．ꡫ\x{A949}\x{10E62}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD67\\u0651．ꡫ\\uA949\\uD803\\uDE62\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3302\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1D167}\x{0651}.ꡫ\x{A949}\x{10E62}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD67\\u0651\.ꡫ\\uA949\\uD803\\uDE62\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3303\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⅎ\x{08E7}\x{D15BD}。≯⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\\u08E7\\uDB05\\uDDBD\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{08E7}\x{D15BD}。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\\u08E7\\uDB05\\uDDBD\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{08E7}\x{D15BD}。≯襾", %p)},	undef,	"to_unicode\(\'Ⅎ\\u08E7\\uDB05\\uDDBD\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{08E7}\x{D15BD}。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'Ⅎ\\u08E7\\uDB05\\uDDBD\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{08E7}\x{D15BD}。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'ⅎ\\u08E7\\uDB05\\uDDBD\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{08E7}\x{D15BD}。≯襾", %p)},	undef,	"to_unicode\(\'ⅎ\\u08E7\\uDB05\\uDDBD\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{08E7}\x{D15BD}。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'ⅎ\\u08E7\\uDB05\\uDDBD\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{08E7}\x{D15BD}。≯⾑", %p)},	undef,	"to_unicode\(\'ⅎ\\u08E7\\uDB05\\uDDBD\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3311\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0981}\x{10E6F}｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0981\\uD803\\uDE6F｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3312\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0981}\x{10E6F}｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0981\\uD803\\uDE6F｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3313\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0981}\x{10E6F}。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0981\\uD803\\uDE6F\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3314\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0981}\x{10E6F}。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0981\\uD803\\uDE6F\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3315\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0981}\x{10E6F}。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0981\\uD803\\uDE6F\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3316\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0981}\x{10E6F}。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0981\\uD803\\uDE6F\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3317\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0981}\x{10E6F}。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0981\\uD803\\uDE6F\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3318\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0981}\x{10E6F}。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0981\\uD803\\uDE6F\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3319\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0981}\x{10E6F}｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0981\\uD803\\uDE6F｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3320\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0981}\x{10E6F}｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0981\\uD803\\uDE6F｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3321\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0981}\x{10E6F}｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0981\\uD803\\uDE6F｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3322\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0981}\x{10E6F}｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0981\\uD803\\uDE6F｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3323\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3325\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3326\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3327\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3329\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3330\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3331\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3332\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3333\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{BEABC}\x{10B8A}㓱。⾑", %p)},	undef,	"to_unicode\(\'\\uDABA\\uDEBC\\uD802\\uDF8A㓱\。⾑\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{BEABC}\x{10B8A}㓱。襾", %p)},	undef,	"to_unicode\(\'\\uDABA\\uDEBC\\uD802\\uDF8A㓱\。襾\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠱ\x{0643}\x{0665}≮。≯⬐\x{200D}", %p)},	undef,	"to_unicode\(\'ᠱ\\u0643\\u0665\≮\。\≯\⬐\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠱ\x{0643}\x{0665}≮。≯⬐\x{200D}", %p)},	undef,	"to_unicode\(\'ᠱ\\u0643\\u0665\≮\。\≯\⬐\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠱ\x{0643}\x{0665}<\x{0338}。>\x{0338}⬐\x{200D}", %p)},	undef,	"to_unicode\(\'ᠱ\\u0643\\u0665\<\\u0338\。\>\\u0338\⬐\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠱ\x{0643}\x{0665}<\x{0338}。>\x{0338}⬐\x{200D}", %p)},	undef,	"to_unicode\(\'ᠱ\\u0643\\u0665\<\\u0338\。\>\\u0338\⬐\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟞｡\x{7BAB9}\x{063B}\x{0774}⩋", %p)},	undef,	"to_unicode\(\'𝟞｡\\uD9AE\\uDEB9\\u063B\\u0774\⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6。\x{7BAB9}\x{063B}\x{0774}⩋", %p)},	undef,	"to_unicode\(\'6\。\\uD9AE\\uDEB9\\u063B\\u0774\⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0646}。\x{E007C}\x{116B6}", %p)},	undef,	"to_unicode\(\'\-\\u0646\。\\uDB40\\uDC7C\\uD805\\uDEB6\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{E0459}𝟏.\x{E014D}\x{A3753}\x{0665}\x{64EA0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB41\\uDC59𝟏\.\\uDB40\\uDD4D\\uDA4D\\uDF53\\u0665\\uD953\\uDEA0\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:3343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{E0459}𝟏.\x{E014D}\x{A3753}\x{0665}\x{64EA0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB41\\uDC59𝟏\.\\uDB40\\uDD4D\\uDA4D\\uDF53\\u0665\\uD953\\uDEA0\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:3344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{E0459}1.\x{E014D}\x{A3753}\x{0665}\x{64EA0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB41\\uDC591\.\\uDB40\\uDD4D\\uDA4D\\uDF53\\u0665\\uD953\\uDEA0\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:3345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{E0459}1.\x{E014D}\x{A3753}\x{0665}\x{64EA0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB41\\uDC591\.\\uDB40\\uDD4D\\uDA4D\\uDF53\\u0665\\uD953\\uDEA0\'\)\ throws\ error\ P1\ V6\ C1\ B5\ \[data\/IdnaTest\.txt\:3346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.SS", %p)},	"齙--4.ss",	"to_unicode\(\'齙\-\-4\.SS\'\)\ \[data\/IdnaTest\.txt\:3351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----4-p16k.ss", %p)},	"齙--4.ss",	"to_unicode\(\'xn\-\-\-\-4\-p16k\.ss\'\)\ \[data\/IdnaTest\.txt\:3352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----4-p16k.xn--zca", %p)},	"齙--4.ß",	"to_unicode\(\'xn\-\-\-\-4\-p16k\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:3353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.SS", %p)},	"齙--4.ss",	"to_unicode\(\'齙\-\-𝟰\.SS\'\)\ \[data\/IdnaTest\.txt\:3354\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1107F}.\x{0660}\x{1059}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC7F\.\\u0660\\u1059\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3355\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1107F}.\x{0660}\x{1059}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC7F\.\\u0660\\u1059\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3356\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{3336C}𐆕｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD88C\\uDF6C𐆕｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3336C}𐆕｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD88C\\uDF6C𐆕｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3336C}𐆕。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD88C\\uDF6C𐆕\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3336C}𐆕。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD88C\\uDF6C𐆕\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3336C}𐆕", %p)},	undef,	"to_unicode\(\'\\uD88C\\uDF6C𐆕\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11235}．\x{10F7E}-\x{05B1}悎", %p)},	undef,	"to_unicode\(\'\\uD804\\uDE35．\\uD803\\uDF7E\-\\u05B1悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{11235}.\x{10F7E}-\x{05B1}悎", %p)},	undef,	"to_unicode\(\'\\uD804\\uDE35\.\\uD803\\uDF7E\-\\u05B1悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AA880}\x{E0907}．\x{0728}\x{AE62E}", %p)},	undef,	"to_unicode\(\'\\uDA6A\\uDC80\\uDB42\\uDD07．\\u0728\\uDA79\\uDE2E\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AA880}\x{E0907}.\x{0728}\x{AE62E}", %p)},	undef,	"to_unicode\(\'\\uDA6A\\uDC80\\uDB42\\uDD07\.\\u0728\\uDA79\\uDE2E\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3365\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᡒ\x{1098D}\x{10ADA}.𐋲", %p)},	undef,	"to_unicode\(\'ᡒ\\uD802\\uDD8D\\uD802\\uDEDA\.𐋲\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:3366\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1E981}ᢤ\x{0679}\x{0668}.\x{DF56}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDD81ᢤ\\u0679\\u0668\.\\uDF56\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1E981}ᢤ\x{0679}\x{0668}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDD81ᢤ\\u0679\\u0668\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ↄ。\x{0C4D}\x{1DD1}\x{10D2E}", %p)},	undef,	"to_unicode\(\'Ↄ\。\\u0C4D\\u1DD1\\uD803\\uDD2E\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ↄ。\x{0C4D}\x{1DD1}\x{10D2E}", %p)},	undef,	"to_unicode\(\'ↄ\。\\u0C4D\\u1DD1\\uD803\\uDD2E\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01BA}-。\x{771B0}≮\x{0C4D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDBA\-\。\\uD99C\\uDDB0\≮\\u0C4D\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01BA}-。\x{771B0}<\x{0338}\x{0C4D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDBA\-\。\\uD99C\\uDDB0\<\\u0338\\u0C4D\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}℥\x{200D}。\x{6BBEA}≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C℥\\u200D\。\\uD96E\\uDFEA\≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E61}-\x{110B9}᠇。︒䖐⾆", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\-\\uD804\\uDCB9᠇\。︒䖐⾆\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3381\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E61}-\x{110B9}᠇。。䖐舌", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61\-\\uD804\\uDCB9᠇\。\。䖐舌\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:3382\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A47}Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0A47Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A47}Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0A47Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A47}Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0A47Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A47}Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0A47Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3386\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A47}ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0A47ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3387\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A47}ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0A47ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3388\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A47}ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0A47ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A47}ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0A47ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3390\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0DCA}쩁\x{10E61}.\x{F3289}", %p)},	undef,	"to_unicode\(\'\\u0DCA쩁\\uD803\\uDE61\.\\uDB8C\\uDE89\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}쩁\x{10E61}.\x{F3289}", %p)},	undef,	"to_unicode\(\'\\u0DCA쩁\\uD803\\uDE61\.\\uDB8C\\uDE89\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}０\x{200C}｡⼯\x{EDC30}", %p)},	undef,	"to_unicode\(\'\\u0693０\\u200C｡⼯\\uDB77\\uDC30\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}０\x{200C}｡⼯\x{EDC30}", %p)},	undef,	"to_unicode\(\'\\u0693０\\u200C｡⼯\\uDB77\\uDC30\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}0\x{200C}。工\x{EDC30}", %p)},	undef,	"to_unicode\(\'\\u06930\\u200C\。工\\uDB77\\uDC30\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}0\x{200C}。工\x{EDC30}", %p)},	undef,	"to_unicode\(\'\\u06930\\u200C\。工\\uDB77\\uDC30\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}9ꍩ\x{E01BE}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC09ꍩ\\uDB40\\uDDBE\.\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E98C0}９ꍩ\x{E01BE}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\\uDB66\\uDCC0９ꍩ\\uDB40\\uDDBE．\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꗷ\x{030D}.ᢦ\x{08E0}", %p)},	undef,	"to_unicode\(\'ꗷ\\u030D\.ᢦ\\u08E0\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐≯-。︒\x{76B6B}-\x{3C26C}", %p)},	undef,	"to_unicode\(\'⒐\≯\-\。︒\\uD99A\\uDF6B\-\\uD8B0\\uDE6C\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐>\x{0338}-。︒\x{76B6B}-\x{3C26C}", %p)},	undef,	"to_unicode\(\'⒐\>\\u0338\-\。︒\\uD99A\\uDF6B\-\\uD8B0\\uDE6C\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.≯-。。\x{76B6B}-\x{3C26C}", %p)},	undef,	"to_unicode\(\'9\.\≯\-\。\。\\uD99A\\uDF6B\-\\uD8B0\\uDE6C\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.>\x{0338}-。。\x{76B6B}-\x{3C26C}", %p)},	undef,	"to_unicode\(\'9\.\>\\u0338\-\。\。\\uD99A\\uDF6B\-\\uD8B0\\uDE6C\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B656B}\x{E016F}Ⴡ\x{E033B}．\x{10C33}", %p)},	undef,	"to_unicode\(\'\\uDA99\\uDD6B\\uDB40\\uDD6FჁ\\uDB40\\uDF3B．\\uD803\\uDC33\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B656B}\x{E016F}Ⴡ\x{E033B}.\x{10C33}", %p)},	undef,	"to_unicode\(\'\\uDA99\\uDD6B\\uDB40\\uDD6FჁ\\uDB40\\uDF3B\.\\uD803\\uDC33\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B656B}\x{E016F}ⴡ\x{E033B}.\x{10C33}", %p)},	undef,	"to_unicode\(\'\\uDA99\\uDD6B\\uDB40\\uDD6Fⴡ\\uDB40\\uDF3B\.\\uD803\\uDC33\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{B656B}\x{E016F}ⴡ\x{E033B}．\x{10C33}", %p)},	undef,	"to_unicode\(\'\\uDA99\\uDD6B\\uDB40\\uDD6Fⴡ\\uDB40\\uDF3B．\\uD803\\uDC33\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3421\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0C3F}。𐋩\x{076A}-\x{0645}", %p)},	undef,	"to_unicode\(\'\\u0C3F\。𐋩\\u076A\-\\u0645\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3422\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("싇。⾇\x{10C00}Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇\\uD803\\uDC00Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。⾇\x{10C00}Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇\\uD803\\uDC00Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛\x{10C00}Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛\\uD803\\uDC00Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛\x{10C00}Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛\\uD803\\uDC00Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3426\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("싇。舛\x{10C00}ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛\\uD803\\uDC00ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3427\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("싇。舛\x{10C00}ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛\\uD803\\uDC00ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3428\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("싇。⾇\x{10C00}ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇\\uD803\\uDC00ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3429\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("싇。⾇\x{10C00}ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇\\uD803\\uDC00ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3430\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E6E}ς。\x{200C}\x{07D7}Ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Eς\。\\u200C\\u07D7Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6E}ς。\x{200C}\x{07D7}Ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Eς\。\\u200C\\u07D7Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3432\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E6E}ς。\x{200C}\x{07D7}ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Eς\。\\u200C\\u07D7ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3433\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E6E}ς。\x{200C}\x{07D7}ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Eς\。\\u200C\\u07D7ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3434\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E6E}Σ。\x{200C}\x{07D7}Ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6EΣ\。\\u200C\\u07D7Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6E}Σ。\x{200C}\x{07D7}Ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6EΣ\。\\u200C\\u07D7Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3436\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E6E}σ。\x{200C}\x{07D7}ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Eσ\。\\u200C\\u07D7ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3437\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E6E}σ。\x{200C}\x{07D7}ⴠ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Eσ\。\\u200C\\u07D7ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3438\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-ß", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-ß", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-SS", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-SS", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-ss", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-ss", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-Ss", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{88EE4}\x{200C}\x{10E72}.ꡆ-Ss", %p)},	undef,	"to_unicode\(\'\\uD9E3\\uDEE4\\u200C\\uD803\\uDE72\.ꡆ\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{10AEE}.-\x{FEBC}\x{67B63}\x{1ECC7}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\uD802\\uDEEE\.\-\\uFEBC\\uD95E\\uDF63\\uD83B\\uDCC7\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{10AEE}.-\x{FEBC}\x{67B63}\x{1ECC7}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\uD802\\uDEEE\.\-\\uFEBC\\uD95E\\uDF63\\uD83B\\uDCC7\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{10AEE}.-\x{0635}\x{67B63}\x{1ECC7}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\uD802\\uDEEE\.\-\\u0635\\uD95E\\uDF63\\uD83B\\uDCC7\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{10AEE}.-\x{0635}\x{67B63}\x{1ECC7}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\uD802\\uDEEE\.\-\\u0635\\uD95E\\uDF63\\uD83B\\uDCC7\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{517DF}｡\x{10AE4}≠", %p)},	undef,	"to_unicode\(\'\\uD905\\uDFDF｡\\uD802\\uDEE4\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{517DF}｡\x{10AE4}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD905\\uDFDF｡\\uD802\\uDEE4\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{517DF}。\x{10AE4}≠", %p)},	undef,	"to_unicode\(\'\\uD905\\uDFDF\。\\uD802\\uDEE4\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{517DF}。\x{10AE4}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD905\\uDFDF\。\\uD802\\uDEE4\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E016C}\x{1E9A1}｡\x{0668}\x{10E70}덝۵", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD6C\\uD83A\\uDDA1｡\\u0668\\uD803\\uDE70덝۵\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E016C}\x{1E9A1}｡\x{0668}\x{10E70}덝۵", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD6C\\uD83A\\uDDA1｡\\u0668\\uD803\\uDE70덝۵\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E016C}\x{1E9A1}。\x{0668}\x{10E70}덝۵", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD6C\\uD83A\\uDDA1\。\\u0668\\uD803\\uDE70덝۵\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E016C}\x{1E9A1}。\x{0668}\x{10E70}덝۵", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD6C\\uD83A\\uDDA1\。\\u0668\\uD803\\uDE70덝۵\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{0826}-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u0826\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{0826}-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u0826\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{0826}-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u0826\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{0826}-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u0826\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3462\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴏ\x{0826}-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u0826\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3463\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴏ\x{0826}-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u0826\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3464\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴏ\x{0826}-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u0826\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3465\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴏ\x{0826}-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u0826\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3466\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E040B}\x{0DD3}\x{E09FF}\x{C560B}。\x{10E7C}\x{E0A8B}\x{11128}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDC0B\\u0DD3\\uDB42\\uDDFF\\uDAD5\\uDE0B\。\\uD803\\uDE7C\\uDB42\\uDE8B\\uD804\\uDD28\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ᢗ.┙🄇⒈", %p)},	undef,	"to_unicode\(\'\≠ᢗ\.\┙🄇⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ᢗ.┙🄇⒈", %p)},	undef,	"to_unicode\(\'\=\\u0338ᢗ\.\┙🄇⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ᢗ.┙6,1.", %p)},	undef,	"to_unicode\(\'\≠ᢗ\.\┙6\,1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ᢗ.┙6,1.", %p)},	undef,	"to_unicode\(\'\=\\u0338ᢗ\.\┙6\,1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦ß.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦ß\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦ß.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦ß\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦SS.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦SS\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦SS.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦SS\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦ss.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦ss\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦ss.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦ss\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦Ss.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦Ss\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103D}🎦Ss.\x{075D}\x{6B62A}\x{200C}\x{10E66}", %p)},	undef,	"to_unicode\(\'\\u103D🎦Ss\.\\u075D\\uD96D\\uDE2A\\u200C\\uD803\\uDE66\'\)\ throws\ error\ P1\ V5\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:3479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{1E810}\x{2D98}Ⴇ｡\x{1071}", %p)},	undef,	"to_unicode\(\'ß\\uD83A\\uDC10\\u2D98Ⴇ｡\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{1E810}\x{2D98}Ⴇ。\x{1071}", %p)},	undef,	"to_unicode\(\'ß\\uD83A\\uDC10\\u2D98Ⴇ\。\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{1E810}\x{2D98}ⴇ。\x{1071}", %p)},	undef,	"to_unicode\(\'ß\\uD83A\\uDC10\\u2D98ⴇ\。\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{1E810}\x{2D98}Ⴇ。\x{1071}", %p)},	undef,	"to_unicode\(\'SS\\uD83A\\uDC10\\u2D98Ⴇ\。\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{1E810}\x{2D98}ⴇ。\x{1071}", %p)},	undef,	"to_unicode\(\'ss\\uD83A\\uDC10\\u2D98ⴇ\。\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{1E810}\x{2D98}Ⴇ。\x{1071}", %p)},	undef,	"to_unicode\(\'Ss\\uD83A\\uDC10\\u2D98Ⴇ\。\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{1E810}\x{2D98}ⴇ｡\x{1071}", %p)},	undef,	"to_unicode\(\'ß\\uD83A\\uDC10\\u2D98ⴇ｡\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{1E810}\x{2D98}Ⴇ｡\x{1071}", %p)},	undef,	"to_unicode\(\'SS\\uD83A\\uDC10\\u2D98Ⴇ｡\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{1E810}\x{2D98}ⴇ｡\x{1071}", %p)},	undef,	"to_unicode\(\'ss\\uD83A\\uDC10\\u2D98ⴇ｡\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{1E810}\x{2D98}Ⴇ｡\x{1071}", %p)},	undef,	"to_unicode\(\'Ss\\uD83A\\uDC10\\u2D98Ⴇ｡\\u1071\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3489\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{114C2}。\x{093C}-\x{10A3F}", %p)},	undef,	"to_unicode\(\'\\uD805\\uDCC2\。\\u093C\-\\uD802\\uDE3F\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3490\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0A03}-．\x{46033}\x{A8E6}ß", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-．\\uD8D8\\uDC33\\uA8E6ß\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-.\x{46033}\x{A8E6}ß", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-\.\\uD8D8\\uDC33\\uA8E6ß\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-.\x{46033}\x{A8E6}SS", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-\.\\uD8D8\\uDC33\\uA8E6SS\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-.\x{46033}\x{A8E6}ss", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-\.\\uD8D8\\uDC33\\uA8E6ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-.\x{46033}\x{A8E6}Ss", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-\.\\uD8D8\\uDC33\\uA8E6Ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-．\x{46033}\x{A8E6}SS", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-．\\uD8D8\\uDC33\\uA8E6SS\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-．\x{46033}\x{A8E6}ss", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-．\\uD8D8\\uDC33\\uA8E6ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0A03}-．\x{46033}\x{A8E6}Ss", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE03\-．\\uD8D8\\uDC33\\uA8E6Ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AD9}-≮。\x{10E7D}\x{E012B}\x{06A0}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDED9\-\≮\。\\uD803\\uDE7D\\uDB40\\uDD2B\\u06A0\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AD9}-<\x{0338}。\x{10E7D}\x{E012B}\x{06A0}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDED9\-\<\\u0338\。\\uD803\\uDE7D\\uDB40\\uDD2B\\u06A0\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟥\x{E0DF2}\x{0A4D}\x{05A3}．\x{11134}\x{112EA}8\x{0343}", %p)},	undef,	"to_unicode\(\'𝟥\\uDB43\\uDDF2\\u0A4D\\u05A3．\\uD804\\uDD34\\uD804\\uDEEA8\\u0343\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟥\x{E0DF2}\x{0A4D}\x{05A3}．\x{11134}\x{112EA}8\x{0313}", %p)},	undef,	"to_unicode\(\'𝟥\\uDB43\\uDDF2\\u0A4D\\u05A3．\\uD804\\uDD34\\uD804\\uDEEA8\\u0313\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3\x{E0DF2}\x{0A4D}\x{05A3}.\x{11134}\x{112EA}8\x{0313}", %p)},	undef,	"to_unicode\(\'3\\uDB43\\uDDF2\\u0A4D\\u05A3\.\\uD804\\uDD34\\uD804\\uDEEA8\\u0313\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{BBAD1}\x{200D}💰", %p)},	undef,	"to_unicode\(\'\-｡\\uDAAE\\uDED1\\u200D💰\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{BBAD1}\x{200D}💰", %p)},	undef,	"to_unicode\(\'\-｡\\uDAAE\\uDED1\\u200D💰\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{BBAD1}\x{200D}💰", %p)},	undef,	"to_unicode\(\'\-\。\\uDAAE\\uDED1\\u200D💰\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{BBAD1}\x{200D}💰", %p)},	undef,	"to_unicode\(\'\-\。\\uDAAE\\uDED1\\u200D💰\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟓⼴𝟐\x{EAC8D}｡\x{E0103}\x{31592}", %p)},	undef,	"to_unicode\(\'𝟓⼴𝟐\\uDB6B\\uDC8D｡\\uDB40\\uDD03\\uD885\\uDD92\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5广2\x{EAC8D}。\x{E0103}\x{31592}", %p)},	undef,	"to_unicode\(\'5广2\\uDB6B\\uDC8D\。\\uDB40\\uDD03\\uD885\\uDD92\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.-├\x{57917}", %p)},	undef,	"to_unicode\(\'\-\.\-\├\\uD91E\\uDD17\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3510\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1DE6}\x{07E6}｡\x{200D}꒿", %p)},	undef,	"to_unicode\(\'\\u1DE6\\u07E6｡\\u200D꒿\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:3511\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1DE6}\x{07E6}｡\x{200D}꒿", %p)},	undef,	"to_unicode\(\'\\u1DE6\\u07E6｡\\u200D꒿\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:3512\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1DE6}\x{07E6}。\x{200D}꒿", %p)},	undef,	"to_unicode\(\'\\u1DE6\\u07E6\。\\u200D꒿\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:3513\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1DE6}\x{07E6}。\x{200D}꒿", %p)},	undef,	"to_unicode\(\'\\u1DE6\\u07E6\。\\u200D꒿\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:3514\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}Ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3DႮ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ.\x{200C}1.1.\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ\.\\u200C1\.1\.\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥\x{B193D}ⴎ．\x{200C}⒈⒈\x{10B85}", %p)},	undef,	"to_unicode\(\'쥥\\uDA86\\uDD3Dⴎ．\\u200C⒈⒈\\uD802\\uDF85\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3530\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{E0199}𝟶ꡖ-。\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD99𝟶ꡖ\-\。\\u0D4D\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3531\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{E0199}0ꡖ-。\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD990ꡖ\-\。\\u0D4D\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3532\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς．\x{FD89}\x{E0768}⒈", %p)},	undef,	"to_unicode\(\'ς．\\uFD89\\uDB41\\uDF68⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς.\x{0645}\x{062D}\x{062C}\x{E0768}1.", %p)},	undef,	"to_unicode\(\'ς\.\\u0645\\u062D\\u062C\\uDB41\\uDF681\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.\x{0645}\x{062D}\x{062C}\x{E0768}1.", %p)},	undef,	"to_unicode\(\'Σ\.\\u0645\\u062D\\u062C\\uDB41\\uDF681\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.\x{0645}\x{062D}\x{062C}\x{E0768}1.", %p)},	undef,	"to_unicode\(\'σ\.\\u0645\\u062D\\u062C\\uDB41\\uDF681\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ．\x{FD89}\x{E0768}⒈", %p)},	undef,	"to_unicode\(\'Σ．\\uFD89\\uDB41\\uDF68⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ．\x{FD89}\x{E0768}⒈", %p)},	undef,	"to_unicode\(\'σ．\\uFD89\\uDB41\\uDF68⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⓿-｡\x{10E79}\x{4428C}\x{E9C09}", %p)},	undef,	"to_unicode\(\'⓿\-｡\\uD803\\uDE79\\uD8D0\\uDE8C\\uDB67\\uDC09\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⓿-。\x{10E79}\x{4428C}\x{E9C09}", %p)},	undef,	"to_unicode\(\'⓿\-\。\\uD803\\uDE79\\uD8D0\\uDE8C\\uDB67\\uDC09\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C33}-\x{E02F3}｡𝟻\x{200C}\x{FC24}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC33\-\\uDB40\\uDEF3｡𝟻\\u200C\\uFC24\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C33}-\x{E02F3}｡𝟻\x{200C}\x{FC24}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC33\-\\uDB40\\uDEF3｡𝟻\\u200C\\uFC24\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C33}-\x{E02F3}。5\x{200C}\x{0636}\x{062E}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC33\-\\uDB40\\uDEF3\。5\\u200C\\u0636\\u062E\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10C33}-\x{E02F3}。5\x{200C}\x{0636}\x{062E}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC33\-\\uDB40\\uDEF3\。5\\u200C\\u0636\\u062E\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3544\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3545\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3546\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3547\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3550\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3551\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ß.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dß\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3552\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3553\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3554\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3555\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3556\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3557\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3558\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3559\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3560\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3561\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3562\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3563\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss.\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs\.\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3564\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3565\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3566\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3567\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}SS．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSS．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3568\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3570\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3571\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200Dss．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3572\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3573\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3574\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3575\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{10E78}늿\x{200D}Ss．\x{0758}0\x{1CE4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78늿\\u200DSs．\\u07580\\u1CE4\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3576\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("9\x{1107F}．\x{D290F}\x{08A3}", %p)},	undef,	"to_unicode\(\'9\\uD804\\uDC7F．\\uDB0A\\uDD0F\\u08A3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9\x{1107F}.\x{D290F}\x{08A3}", %p)},	undef,	"to_unicode\(\'9\\uD804\\uDC7F\.\\uDB0A\\uDD0F\\u08A3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺ß🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺ß🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺ß🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺ß🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡ß🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡ß🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡ß🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡ß🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡SS🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡SS🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡SS🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡SS🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡Ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡Ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{1EF3E}彡Ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\uD83B\\uDF3E彡Ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺SS🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺SS🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺SS🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺SS🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺Ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺Ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{1EF3E}⼺Ss🍺", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\uD83B\\uDF3E⼺Ss🍺\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ\x{11132}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\\uD804\\uDD32．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ\x{11132}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\\uD804\\uDD32．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ\x{11132}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。Ⴖ\\uD804\\uDD32\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ\x{11132}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。Ⴖ\\uD804\\uDD32\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3598\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("。ⴖ\x{11132}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。ⴖ\\uD804\\uDD32\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3599\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("。ⴖ\x{11132}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。ⴖ\\uD804\\uDD32\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3600\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("xn--eljy214e.", %p)},	"ⴖ\x{11132}.",	"to_unicode\(\'xn\-\-eljy214e\.\'\)\ \[data\/IdnaTest\.txt\:3601\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ⴖ\x{11132}.", %p)},	"ⴖ\x{11132}.",	"to_unicode\(\'ⴖ\\uD804\\uDD32\.\'\)\ \[data\/IdnaTest\.txt\:3602\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴖ\x{11132}.", %p)},	undef,	"to_unicode\(\'Ⴖ\\uD804\\uDD32\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ\x{11132}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\\uD804\\uDD32．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ\x{11132}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\\uD804\\uDD32．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}．\x{200C}Ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682．\\u200CႣ\\uDB40\\uDDEA\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}．\x{200C}Ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682．\\u200CႣ\\uDB40\\uDDEA\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}.\x{200C}Ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682\.\\u200CႣ\\uDB40\\uDDEA\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0682}.\x{200C}Ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682\.\\u200CႣ\\uDB40\\uDDEA\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3609\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0682}.\x{200C}ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682\.\\u200Cⴃ\\uDB40\\uDDEA\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3610\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0682}.\x{200C}ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682\.\\u200Cⴃ\\uDB40\\uDDEA\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3611\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--7ib.xn--ukj", %p)},	"\x{0682}.ⴃ",	"to_unicode\(\'xn\-\-7ib\.xn\-\-ukj\'\)\ \[data\/IdnaTest\.txt\:3612\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0682}.ⴃ", %p)},	"\x{0682}.ⴃ",	"to_unicode\(\'\\u0682\.ⴃ\'\)\ \[data\/IdnaTest\.txt\:3613\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0682}.Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0682\.Ⴃ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3614\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0682}．\x{200C}ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682．\\u200Cⴃ\\uDB40\\uDDEA\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0682}．\x{200C}ⴃ\x{E01EA}", %p)},	undef,	"to_unicode\(\'\\u0682．\\u200Cⴃ\\uDB40\\uDDEA\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3616\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{200C}。２䫷\x{E0FA1}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。２䫷\\uDB43\\uDFA1\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。２䫷\x{E0FA1}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。２䫷\\uDB43\\uDFA1\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。2䫷\x{E0FA1}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。2䫷\\uDB43\\uDFA1\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。2䫷\x{E0FA1}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。2䫷\\uDB43\\uDFA1\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{17CF}\x{BF656}。\x{D8692}", %p)},	undef,	"to_unicode\(\'\-\\u17CF\\uDABD\\uDE56\。\\uDB21\\uDE92\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C9316}︒\x{200C}㟀．\x{0683}⒈", %p)},	undef,	"to_unicode\(\'\\uDAE4\\uDF16︒\\u200C㟀．\\u0683⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C9316}︒\x{200C}㟀．\x{0683}⒈", %p)},	undef,	"to_unicode\(\'\\uDAE4\\uDF16︒\\u200C㟀．\\u0683⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C9316}。\x{200C}㟀.\x{0683}1.", %p)},	undef,	"to_unicode\(\'\\uDAE4\\uDF16\。\\u200C㟀\.\\u06831\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C9316}。\x{200C}㟀.\x{0683}1.", %p)},	undef,	"to_unicode\(\'\\uDAE4\\uDF16\。\\u200C㟀\.\\u06831\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3625\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0742}ᡳ\x{07EE}。-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0742ᡳ\\u07EE\。\-\\u200D\'\)\ throws\ error\ V5\ V3\ C2\ \[data\/IdnaTest\.txt\:3626\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0742}ᡳ\x{07EE}。-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0742ᡳ\\u07EE\。\-\\u200D\'\)\ throws\ error\ V5\ V3\ C2\ \[data\/IdnaTest\.txt\:3627\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ≠\x{10D81}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\≠\\uD803\\uDD81\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}。≯ς", %p)},	undef,	"to_unicode\(\'\\u07CF\。\≯ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}。>\x{0338}ς", %p)},	undef,	"to_unicode\(\'\\u07CF\。\>\\u0338ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}。>\x{0338}Σ", %p)},	undef,	"to_unicode\(\'\\u07CF\。\>\\u0338Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}。≯Σ", %p)},	undef,	"to_unicode\(\'\\u07CF\。\≯Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}。≯σ", %p)},	undef,	"to_unicode\(\'\\u07CF\。\≯σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}。>\x{0338}σ", %p)},	undef,	"to_unicode\(\'\\u07CF\。\>\\u0338σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FCB8}\x{10BFB}.\x{13E26}︒\x{145C2}Ⴐ", %p)},	undef,	"to_unicode\(\'\\uFCB8\\uD802\\uDFFB\.\\uD80F\\uDE26︒\\uD811\\uDDC2Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0637}\x{062D}\x{10BFB}.\x{13E26}。\x{145C2}Ⴐ", %p)},	undef,	"to_unicode\(\'\\u0637\\u062D\\uD802\\uDFFB\.\\uD80F\\uDE26\。\\uD811\\uDDC2Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0637}\x{062D}\x{10BFB}.\x{13E26}。\x{145C2}ⴐ", %p)},	undef,	"to_unicode\(\'\\u0637\\u062D\\uD802\\uDFFB\.\\uD80F\\uDE26\。\\uD811\\uDDC2ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FCB8}\x{10BFB}.\x{13E26}︒\x{145C2}ⴐ", %p)},	undef,	"to_unicode\(\'\\uFCB8\\uD802\\uDFFB\.\\uD80F\\uDE26︒\\uD811\\uDDC2ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ🖌\x{E01BF}🝗｡\x{2DF4}", %p)},	undef,	"to_unicode\(\'Ⴥ🖌\\uDB40\\uDDBF🝗｡\\u2DF4\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ🖌\x{E01BF}🝗。\x{2DF4}", %p)},	undef,	"to_unicode\(\'Ⴥ🖌\\uDB40\\uDDBF🝗\。\\u2DF4\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3655\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴥ🖌\x{E01BF}🝗。\x{2DF4}", %p)},	undef,	"to_unicode\(\'ⴥ🖌\\uDB40\\uDDBF🝗\。\\u2DF4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3656\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴥ🖌\x{E01BF}🝗｡\x{2DF4}", %p)},	undef,	"to_unicode\(\'ⴥ🖌\\uDB40\\uDDBF🝗｡\\u2DF4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3657\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🄈。⧙\x{06B1}", %p)},	undef,	"to_unicode\(\'🄈\。\⧙\\u06B1\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("7,。⧙\x{06B1}", %p)},	undef,	"to_unicode\(\'7\,\。\⧙\\u06B1\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{10AC3}。섖쮖ß", %p)},	undef,	"to_unicode\(\'\≮\\uD802\\uDEC3\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{10AC3}。섖쮖ß", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uD802\\uDEC3\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{10AC3}。섖쮖SS", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uD802\\uDEC3\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{10AC3}。섖쮖SS", %p)},	undef,	"to_unicode\(\'\≮\\uD802\\uDEC3\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{10AC3}。섖쮖ss", %p)},	undef,	"to_unicode\(\'\≮\\uD802\\uDEC3\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{10AC3}。섖쮖ss", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uD802\\uDEC3\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{10AC3}。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uD802\\uDEC3\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{10AC3}。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\≮\\uD802\\uDEC3\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0112}⤝-。ᡚ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD12\⤝\-\。ᡚ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1E9FA}\x{06DD}\x{10ADB}\x{114C2}。\x{06CF}ᠿ\x{200C}\x{08A8}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDDFA\\u06DD\\uD802\\uDEDB\\uD805\\uDCC2\。\\u06CFᠿ\\u200C\\u08A8\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67C}.\x{1EE04}\x{E5ED7}", %p)},	undef,	"to_unicode\(\'\\uA67C\.\\uD83B\\uDE04\\uDB57\\uDED7\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("--。\x{A03C6}\x{0760}\x{10831}\x{10F40}", %p)},	undef,	"to_unicode\(\'\-\-\。\\uDA40\\uDFC6\\u0760\\uD802\\uDC31\\uD803\\uDF40\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{44352}𐋥\x{10A68E}.≯ᠺ\x{0843}\x{696E9}", %p)},	undef,	"to_unicode\(\'\\uD8D0\\uDF52𐋥\\uDBE9\\uDE8E\.\≯ᠺ\\u0843\\uD965\\uDEE9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{44352}𐋥\x{10A68E}.>\x{0338}ᠺ\x{0843}\x{696E9}", %p)},	undef,	"to_unicode\(\'\\uD8D0\\uDF52𐋥\\uDBE9\\uDE8E\.\>\\u0338ᠺ\\u0843\\uD965\\uDEE9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䔛\x{E01EA}\x{3B775}\x{10E78}．-䤷", %p)},	undef,	"to_unicode\(\'䔛\\uDB40\\uDDEA\\uD8AD\\uDF75\\uD803\\uDE78．\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䔛\x{E01EA}\x{3B775}\x{10E78}.-䤷", %p)},	undef,	"to_unicode\(\'䔛\\uDB40\\uDDEA\\uD8AD\\uDF75\\uD803\\uDE78\.\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}．\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}．\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}.\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}.\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1CAEC}帷｡≯萺\x{E0461}-", %p)},	undef,	"to_unicode\(\'\\uD832\\uDEEC帷｡\≯萺\\uDB41\\uDC61\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1CAEC}帷｡>\x{0338}萺\x{E0461}-", %p)},	undef,	"to_unicode\(\'\\uD832\\uDEEC帷｡\>\\u0338萺\\uDB41\\uDC61\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1CAEC}帷。≯萺\x{E0461}-", %p)},	undef,	"to_unicode\(\'\\uD832\\uDEEC帷\。\≯萺\\uDB41\\uDC61\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1CAEC}帷。>\x{0338}萺\x{E0461}-", %p)},	undef,	"to_unicode\(\'\\uD832\\uDEEC帷\。\>\\u0338萺\\uDB41\\uDC61\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{0BCD}。ᡱ-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u0BCD\。ᡱ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{0BCD}。ᡱ-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u0BCD\。ᡱ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3685\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}攌\x{0BCD}。ᡱ-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u0BCD\。ᡱ\-ⴘ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3686\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}攌\x{0BCD}。ᡱ-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u0BCD\。ᡱ\-ⴘ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3687\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--xmc7086b.xn----i9j254i", %p)},	"攌\x{0BCD}.ᡱ-ⴘ",	"to_unicode\(\'xn\-\-xmc7086b\.xn\-\-\-\-i9j254i\'\)\ \[data\/IdnaTest\.txt\:3688\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("攌\x{0BCD}.ᡱ-ⴘ", %p)},	"攌\x{0BCD}.ᡱ-ⴘ",	"to_unicode\(\'攌\\u0BCD\.ᡱ\-ⴘ\'\)\ \[data\/IdnaTest\.txt\:3689\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("攌\x{0BCD}.ᡱ-Ⴘ", %p)},	undef,	"to_unicode\(\'攌\\u0BCD\.ᡱ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３\x{F10A1}۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３\\uDB84\\uDCA1۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３\x{F10A1}۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３\\uDB84\\uDCA1۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3\x{F10A1}۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3\\uDB84\\uDCA1۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3\x{F10A1}۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3\\uDB84\\uDCA1۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈걾6.\x{108B3}\x{06A8}", %p)},	undef,	"to_unicode\(\'⒈걾6\.\\uD802\\uDCB3\\u06A8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈걾6.\x{108B3}\x{06A8}", %p)},	undef,	"to_unicode\(\'⒈걾6\.\\uD802\\uDCB3\\u06A8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.걾6.\x{108B3}\x{06A8}", %p)},	undef,	"to_unicode\(\'1\.걾6\.\\uD802\\uDCB3\\u06A8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.걾6.\x{108B3}\x{06A8}", %p)},	undef,	"to_unicode\(\'1\.걾6\.\\uD802\\uDCB3\\u06A8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FCBD}𝟶≮≮.\x{05AF}\x{07CF}", %p)},	undef,	"to_unicode\(\'\\uFCBD𝟶\≮\≮\.\\u05AF\\u07CF\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FCBD}𝟶<\x{0338}<\x{0338}.\x{05AF}\x{07CF}", %p)},	undef,	"to_unicode\(\'\\uFCBD𝟶\<\\u0338\<\\u0338\.\\u05AF\\u07CF\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063A}\x{0645}0≮≮.\x{05AF}\x{07CF}", %p)},	undef,	"to_unicode\(\'\\u063A\\u06450\≮\≮\.\\u05AF\\u07CF\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063A}\x{0645}0<\x{0338}<\x{0338}.\x{05AF}\x{07CF}", %p)},	undef,	"to_unicode\(\'\\u063A\\u06450\<\\u0338\<\\u0338\.\\u05AF\\u07CF\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20D7}.\x{10E65}\x{115F}", %p)},	undef,	"to_unicode\(\'\\u20D7\.\\uD803\\uDE65\\u115F\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3703\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟏\x{1712}🃩.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏\\u1712🃩\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3704\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟏\x{1712}🃩.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏\\u1712🃩\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3705\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("1\x{1712}🃩.\x{200D}", %p)},	undef,	"to_unicode\(\'1\\u1712🃩\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3706\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("1\x{1712}🃩.\x{200D}", %p)},	undef,	"to_unicode\(\'1\\u1712🃩\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--1-hpj0501z.", %p)},	"1\x{1712}🃩.",	"to_unicode\(\'xn\-\-1\-hpj0501z\.\'\)\ \[data\/IdnaTest\.txt\:3708\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("1\x{1712}🃩.", %p)},	"1\x{1712}🃩.",	"to_unicode\(\'1\\u1712🃩\.\'\)\ \[data\/IdnaTest\.txt\:3709\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0676}≠\x{06AC}\x{115BF}｡-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0676\≠\\u06AC\\uD805\\uDDBF｡\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0676}≠\x{06AC}\x{115BF}｡-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0676\≠\\u06AC\\uD805\\uDDBF｡\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0676}=\x{0338}\x{06AC}\x{115BF}｡-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0676\=\\u0338\\u06AC\\uD805\\uDDBF｡\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0676}=\x{0338}\x{06AC}\x{115BF}｡-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0676\=\\u0338\\u06AC\\uD805\\uDDBF｡\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0648}\x{0674}≠\x{06AC}\x{115BF}。-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0648\\u0674\≠\\u06AC\\uD805\\uDDBF\。\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0648}\x{0674}≠\x{06AC}\x{115BF}。-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0648\\u0674\≠\\u06AC\\uD805\\uDDBF\。\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0648}\x{0674}=\x{0338}\x{06AC}\x{115BF}。-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0648\\u0674\=\\u0338\\u06AC\\uD805\\uDDBF\。\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0648}\x{0674}=\x{0338}\x{06AC}\x{115BF}。-\x{200C}\x{07E5}", %p)},	undef,	"to_unicode\(\'\\u0648\\u0674\=\\u0338\\u06AC\\uD805\\uDDBF\。\-\\u200C\\u07E5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3717\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10E79}\x{0314}-\x{084B}｡\x{06EF}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE79\\u0314\-\\u084B｡\\u06EF\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3718\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10E79}\x{0314}-\x{084B}。\x{06EF}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE79\\u0314\-\\u084B\。\\u06EF\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3719\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("F\x{10A0C}｡\x{60839}🌆", %p)},	undef,	"to_unicode\(\'F\\uD802\\uDE0C｡\\uD942\\uDC39🌆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("F\x{10A0C}。\x{60839}🌆", %p)},	undef,	"to_unicode\(\'F\\uD802\\uDE0C\。\\uD942\\uDC39🌆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f\x{10A0C}。\x{60839}🌆", %p)},	undef,	"to_unicode\(\'f\\uD802\\uDE0C\。\\uD942\\uDC39🌆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f\x{10A0C}｡\x{60839}🌆", %p)},	undef,	"to_unicode\(\'f\\uD802\\uDE0C｡\\uD942\\uDC39🌆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1134D}\x{1BAA}\x{0FAD}。𝟮Ⴘ\x{1A68}\x{EC67}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDF4D\\u1BAA\\u0FAD\。𝟮Ⴘ\\u1A68\\uEC67\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1134D}\x{1BAA}\x{0FAD}。2Ⴘ\x{1A68}\x{EC67}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDF4D\\u1BAA\\u0FAD\。2Ⴘ\\u1A68\\uEC67\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1134D}\x{1BAA}\x{0FAD}。2ⴘ\x{1A68}\x{EC67}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDF4D\\u1BAA\\u0FAD\。2ⴘ\\u1A68\\uEC67\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1134D}\x{1BAA}\x{0FAD}。𝟮ⴘ\x{1A68}\x{EC67}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDF4D\\u1BAA\\u0FAD\。𝟮ⴘ\\u1A68\\uEC67\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{413CA}\x{200C}\x{200C}⒈。勉\x{A94E}", %p)},	undef,	"to_unicode\(\'\\uD8C4\\uDFCA\\u200C\\u200C⒈\。勉\\uA94E\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{413CA}\x{200C}\x{200C}⒈。勉\x{A94E}", %p)},	undef,	"to_unicode\(\'\\uD8C4\\uDFCA\\u200C\\u200C⒈\。勉\\uA94E\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{413CA}\x{200C}\x{200C}1.。勉\x{A94E}", %p)},	undef,	"to_unicode\(\'\\uD8C4\\uDFCA\\u200C\\u200C1\.\。勉\\uA94E\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{413CA}\x{200C}\x{200C}1.。勉\x{A94E}", %p)},	undef,	"to_unicode\(\'\\uD8C4\\uDFCA\\u200C\\u200C1\.\。勉\\uA94E\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0725}.\x{101182}\x{A00DA}\x{5ED4C}", %p)},	undef,	"to_unicode\(\'\\u0725\.\\uDBC4\\uDD82\\uDA40\\uDCDA\\uD93B\\uDD4C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3735\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{111BA}\x{50BA1}.\x{86224}≯\x{06C4}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD804\\uDDBA\\uD902\\uDFA1\.\\uD9D8\\uDE24\≯\\u06C4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{111BA}\x{50BA1}.\x{86224}>\x{0338}\x{06C4}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD804\\uDDBA\\uD902\\uDFA1\.\\uD9D8\\uDE24\>\\u0338\\u06C4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⚺\x{0670}\x{200D}\x{06AE}.\x{0BC0}-\x{E0191}\x{5611B}", %p)},	undef,	"to_unicode\(\'\⚺\\u0670\\u200D\\u06AE\.\\u0BC0\-\\uDB40\\uDD91\\uD918\\uDD1B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⚺\x{0670}\x{200D}\x{06AE}.\x{0BC0}-\x{E0191}\x{5611B}", %p)},	undef,	"to_unicode\(\'\⚺\\u0670\\u200D\\u06AE\.\\u0BC0\-\\uDB40\\uDD91\\uD918\\uDD1B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01E4}．\x{0BCD}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDE4．\\u0BCD\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01E4}.\x{0BCD}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDE4\.\\u0BCD\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸ß.\x{E0521}⪨紙\x{077B}", %p)},	undef,	"to_unicode\(\'䮸ß\.\\uDB41\\uDD21\⪨紙\\u077B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸SS.\x{E0521}⪨紙\x{077B}", %p)},	undef,	"to_unicode\(\'䮸SS\.\\uDB41\\uDD21\⪨紙\\u077B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸ss.\x{E0521}⪨紙\x{077B}", %p)},	undef,	"to_unicode\(\'䮸ss\.\\uDB41\\uDD21\⪨紙\\u077B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸Ss.\x{E0521}⪨紙\x{077B}", %p)},	undef,	"to_unicode\(\'䮸Ss\.\\uDB41\\uDD21\⪨紙\\u077B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3750\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴞ.-\x{A8F0}⭋\x{1EF66}", %p)},	undef,	"to_unicode\(\'\-Ⴞ\.\-\\uA8F0\⭋\\uD83B\\uDF66\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ⴞ.-\x{A8F0}⭋\x{1EF66}", %p)},	undef,	"to_unicode\(\'\-ⴞ\.\-\\uA8F0\⭋\\uD83B\\uDF66\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AE9FD}\x{10E6E}\x{1D17C}｡\x{941B1}ꡨ\x{FC4A0}ᡋ", %p)},	undef,	"to_unicode\(\'\\uDA7A\\uDDFD\\uD803\\uDE6E\\uD834\\uDD7C｡\\uDA10\\uDDB1ꡨ\\uDBB1\\uDCA0ᡋ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AE9FD}\x{10E6E}\x{1D17C}。\x{941B1}ꡨ\x{FC4A0}ᡋ", %p)},	undef,	"to_unicode\(\'\\uDA7A\\uDDFD\\uD803\\uDE6E\\uD834\\uDD7C\。\\uDA10\\uDDB1ꡨ\\uDBB1\\uDCA0ᡋ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B8}-\x{200D}\x{0EBB}．\x{076F}\x{200D}\x{7A81D}", %p)},	undef,	"to_unicode\(\'\\u17B8\-\\u200D\\u0EBB．\\u076F\\u200D\\uD9AA\\uDC1D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B8}-\x{200D}\x{0EBB}．\x{076F}\x{200D}\x{7A81D}", %p)},	undef,	"to_unicode\(\'\\u17B8\-\\u200D\\u0EBB．\\u076F\\u200D\\uD9AA\\uDC1D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B8}-\x{200D}\x{0EBB}.\x{076F}\x{200D}\x{7A81D}", %p)},	undef,	"to_unicode\(\'\\u17B8\-\\u200D\\u0EBB\.\\u076F\\u200D\\uD9AA\\uDC1D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B8}-\x{200D}\x{0EBB}.\x{076F}\x{200D}\x{7A81D}", %p)},	undef,	"to_unicode\(\'\\u17B8\-\\u200D\\u0EBB\.\\u076F\\u200D\\uD9AA\\uDC1D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۱。≠\x{0667}", %p)},	undef,	"to_unicode\(\'۱\。\≠\\u0667\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۱。=\x{0338}\x{0667}", %p)},	undef,	"to_unicode\(\'۱\。\=\\u0338\\u0667\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}廊.\x{1EB94}", %p)},	undef,	"to_unicode\(\'\\uA9C0廊\.\\uD83A\\uDF94\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-．-Ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-．\-Ⴐ\\uD803\\uDE65\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-．-Ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-．\-Ⴐ\\uD803\\uDE65\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-.-Ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-\.\-Ⴐ\\uD803\\uDE65\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-.-Ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-\.\-Ⴐ\\uD803\\uDE65\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3765\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-.-ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-\.\-ⴐ\\uD803\\uDE65\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3766\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-.-ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-\.\-ⴐ\\uD803\\uDE65\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3767\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-．-ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-．\-ⴐ\\uD803\\uDE65\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3768\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{0CBC}-．-ⴐ\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0CBC\-．\-ⴐ\\uD803\\uDE65\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3769\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡉ\x{10E6F}挏\x{5195C}.-", %p)},	undef,	"to_unicode\(\'ᡉ\\uD803\\uDE6F挏\\uD906\\uDD5C\.\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:3770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{108FF}｡\x{10E6A}ꡲ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDCFF｡\\uD803\\uDE6Aꡲ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{108FF}。\x{10E6A}ꡲ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDCFF\。\\uD803\\uDE6Aꡲ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{8DDFF}\x{103011}．ᢋ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11．ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{8DDFF}\x{103011}．ᢋ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11．ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{8DDFF}\x{103011}.ᢋ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11\.ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{8DDFF}\x{103011}.ᢋ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11\.ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3776\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{8DDFF}\x{103011}.ᢋ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11\.ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{8DDFF}\x{103011}.ᢋ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11\.ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{8DDFF}\x{103011}．ᢋ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11．ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{8DDFF}\x{103011}．ᢋ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD9F7\\uDDFF\\uDBCC\\uDC11．ᢋ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}｡≯\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78｡\≯\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}｡≯\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78｡\≯\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}｡>\x{0338}\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78｡\>\\u0338\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}｡>\x{0338}\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78｡\>\\u0338\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}。≯\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78\。\≯\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}。≯\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78\。\≯\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}。>\x{0338}\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78\。\>\\u0338\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("֊\x{8F0F2}ᢤ\x{10E78}。>\x{0338}\x{200C}\x{E0134}", %p)},	undef,	"to_unicode\(\'֊\\uD9FC\\uDCF2ᢤ\\uD803\\uDE78\。\>\\u0338\\u200C\\uDB40\\uDD34\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ\x{E01D1}\x{1922}\x{200D}｡\x{0662}\x{0668}\x{FC8C}-", %p)},	undef,	"to_unicode\(\'ᛎ\\uDB40\\uDDD1\\u1922\\u200D｡\\u0662\\u0668\\uFC8C\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ\x{E01D1}\x{1922}\x{200D}｡\x{0662}\x{0668}\x{FC8C}-", %p)},	undef,	"to_unicode\(\'ᛎ\\uDB40\\uDDD1\\u1922\\u200D｡\\u0662\\u0668\\uFC8C\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ\x{E01D1}\x{1922}\x{200D}。\x{0662}\x{0668}\x{0646}\x{0645}-", %p)},	undef,	"to_unicode\(\'ᛎ\\uDB40\\uDDD1\\u1922\\u200D\。\\u0662\\u0668\\u0646\\u0645\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ\x{E01D1}\x{1922}\x{200D}。\x{0662}\x{0668}\x{0646}\x{0645}-", %p)},	undef,	"to_unicode\(\'ᛎ\\uDB40\\uDDD1\\u1922\\u200D\。\\u0662\\u0668\\u0646\\u0645\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0666}.ᢢ", %p)},	undef,	"to_unicode\(\'\\u0666\.ᢢ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0D4D}。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0D4D\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ss-79h.1.", %p)},	"ss\x{0D4D}.1.",	"to_unicode\(\'xn\-\-ss\-79h\.1\.\'\)\ \[data\/IdnaTest\.txt\:3804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{0D4D}.1.", %p)},	"ss\x{0D4D}.1.",	"to_unicode\(\'ss\\u0D4D\.1\.\'\)\ \[data\/IdnaTest\.txt\:3805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{0D4D}.1.", %p)},	"ss\x{0D4D}.1.",	"to_unicode\(\'SS\\u0D4D\.1\.\'\)\ \[data\/IdnaTest\.txt\:3806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{0D4D}.1.", %p)},	"ss\x{0D4D}.1.",	"to_unicode\(\'Ss\\u0D4D\.1\.\'\)\ \[data\/IdnaTest\.txt\:3807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0D4D}｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0D4D｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200C}\x{19CA5}\x{FEB4}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200C\\uD827\\uDCA5\\uFEB4\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200C}\x{19CA5}\x{FEB4}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200C\\uD827\\uDCA5\\uFEB4\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200C}\x{19CA5}\x{0633}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200C\\uD827\\uDCA5\\u0633\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200C}\x{19CA5}\x{0633}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200C\\uD827\\uDCA5\\u0633\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3817\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0643}｡ꡰ📦", %p)},	"\x{0643}.ꡰ📦",	"to_unicode\(\'\\u0643｡ꡰ📦\'\)\ \[data\/IdnaTest\.txt\:3818\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0643}。ꡰ📦", %p)},	"\x{0643}.ꡰ📦",	"to_unicode\(\'\\u0643\。ꡰ📦\'\)\ \[data\/IdnaTest\.txt\:3819\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--fhb.xn--md9am814d", %p)},	"\x{0643}.ꡰ📦",	"to_unicode\(\'xn\-\-fhb\.xn\-\-md9am814d\'\)\ \[data\/IdnaTest\.txt\:3820\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0643}.ꡰ📦", %p)},	"\x{0643}.ꡰ📦",	"to_unicode\(\'\\u0643\.ꡰ📦\'\)\ \[data\/IdnaTest\.txt\:3821\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ꡲ\x{09CD}。\x{0726}\x{11044}\x{200C}\x{AAF6}", %p)},	undef,	"to_unicode\(\'ꡲ\\u09CD\。\\u0726\\uD804\\uDC44\\u200C\\uAAF6\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:3822\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ꡲ\x{09CD}。\x{0726}\x{11044}\x{200C}\x{AAF6}", %p)},	undef,	"to_unicode\(\'ꡲ\\u09CD\。\\u0726\\uD804\\uDC44\\u200C\\uAAF6\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:3823\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("xn--b7b9332f.xn--wnb6894f5rxc", %p)},	"ꡲ\x{09CD}.\x{0726}\x{11044}\x{AAF6}",	"to_unicode\(\'xn\-\-b7b9332f\.xn\-\-wnb6894f5rxc\'\)\ \[data\/IdnaTest\.txt\:3824\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ꡲ\x{09CD}.\x{0726}\x{11044}\x{AAF6}", %p)},	"ꡲ\x{09CD}.\x{0726}\x{11044}\x{AAF6}",	"to_unicode\(\'ꡲ\\u09CD\.\\u0726\\uD804\\uDC44\\uAAF6\'\)\ \[data\/IdnaTest\.txt\:3825\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{D8801}.\x{111BE}ᡩ", %p)},	undef,	"to_unicode\(\'\\uDB22\\uDC01\.\\uD804\\uDDBEᡩ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3826\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}．ß\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953．ß\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3827\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}.ß\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953\.ß\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3828\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}.SS\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953\.SS\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3829\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}.ss\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953\.ss\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3830\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}.Ss\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953\.Ss\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3831\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}．SS\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953．SS\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3832\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}．ss\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953．ss\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3833\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084E}\x{A953}．Ss\x{0BCD}\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u084E\\uA953．Ss\\u0BCD\\u1A6A\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3834\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟠≮\x{200C}｡\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\≮\\u200C｡\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠≮\x{200C}｡\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\≮\\u200C｡\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠<\x{0338}\x{200C}｡\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\<\\u0338\\u200C｡\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠<\x{0338}\x{200C}｡\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\<\\u0338\\u200C｡\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8≮\x{200C}。\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\≮\\u200C\。\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8≮\x{200C}。\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\≮\\u200C\。\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8<\x{0338}\x{200C}。\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\<\\u0338\\u200C\。\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8<\x{0338}\x{200C}。\x{0319}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\<\\u0338\\u200C\。\\u0319\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}≯︒𐘦．Ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\≯︒𐘦．Ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}>\x{0338}︒𐘦．Ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\>\\u0338︒𐘦．Ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}≯。𐘦.Ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\≯\。𐘦\.Ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}>\x{0338}。𐘦.Ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\>\\u0338\。𐘦\.Ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}>\x{0338}。𐘦.ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\>\\u0338\。𐘦\.ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}≯。𐘦.ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\≯\。𐘦\.ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}>\x{0338}︒𐘦．ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\>\\u0338︒𐘦．ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}≯︒𐘦．ⴀ", %p)},	undef,	"to_unicode\(\'\\u068E\≯︒𐘦．ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0746}．-\x{E0159}", %p)},	undef,	"to_unicode\(\'\\u0746．\-\\uDB40\\uDD59\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0746}.-\x{E0159}", %p)},	undef,	"to_unicode\(\'\\u0746\.\-\\uDB40\\uDD59\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ\x{1CDC}．핒⒒⒈\x{937A4}", %p)},	undef,	"to_unicode\(\'ᵬ\\u1CDC．핒⒒⒈\\uDA0D\\uDFA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ\x{1CDC}．핒⒒⒈\x{937A4}", %p)},	undef,	"to_unicode\(\'ᵬ\\u1CDC．핒⒒⒈\\uDA0D\\uDFA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ\x{1CDC}.핒11.1.\x{937A4}", %p)},	undef,	"to_unicode\(\'ᵬ\\u1CDC\.핒11\.1\.\\uDA0D\\uDFA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ\x{1CDC}.핒11.1.\x{937A4}", %p)},	undef,	"to_unicode\(\'ᵬ\\u1CDC\.핒11\.1\.\\uDA0D\\uDFA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3856\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς\x{1A60}𐋢．\x{10E68}", %p)},	undef,	"to_unicode\(\'ς\\u1A60𐋢．\\uD803\\uDE68\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3857\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς\x{1A60}𐋢.\x{10E68}", %p)},	undef,	"to_unicode\(\'ς\\u1A60𐋢\.\\uD803\\uDE68\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3858\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ\x{1A60}𐋢.\x{10E68}", %p)},	undef,	"to_unicode\(\'Σ\\u1A60𐋢\.\\uD803\\uDE68\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3859\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ\x{1A60}𐋢.\x{10E68}", %p)},	undef,	"to_unicode\(\'σ\\u1A60𐋢\.\\uD803\\uDE68\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3860\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ\x{1A60}𐋢．\x{10E68}", %p)},	undef,	"to_unicode\(\'Σ\\u1A60𐋢．\\uD803\\uDE68\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3861\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ\x{1A60}𐋢．\x{10E68}", %p)},	undef,	"to_unicode\(\'σ\\u1A60𐋢．\\uD803\\uDE68\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3862\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0B4D}\x{200C}𐋻\x{200D}.\x{1E8D1}\x{10854}\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u0B4D\\u200C𐋻\\u200D\.\\uD83A\\uDCD1\\uD802\\uDC54\\uD803\\uDE65\'\)\ throws\ error\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:3863\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0B4D}\x{200C}𐋻\x{200D}.\x{1E8D1}\x{10854}\x{10E65}", %p)},	undef,	"to_unicode\(\'\\u0B4D\\u200C𐋻\\u200D\.\\uD83A\\uDCD1\\uD802\\uDC54\\uD803\\uDE65\'\)\ throws\ error\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:3864\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("🍯。亠ᢔ", %p)},	"🍯.亠ᢔ",	"to_unicode\(\'🍯\。亠ᢔ\'\)\ \[data\/IdnaTest\.txt\:3865\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--mj8h.xn--ebf587y", %p)},	"🍯.亠ᢔ",	"to_unicode\(\'xn\-\-mj8h\.xn\-\-ebf587y\'\)\ \[data\/IdnaTest\.txt\:3866\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("🍯.亠ᢔ", %p)},	"🍯.亠ᢔ",	"to_unicode\(\'🍯\.亠ᢔ\'\)\ \[data\/IdnaTest\.txt\:3867\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10EFB}\x{A835E}。\x{7441D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDEFB\\uDA60\\uDF5E\。\\uD991\\uDC1D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7E}\x{2DEE}\x{08A3}。ς\x{E06C4}\x{E05D7}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\\u2DEE\\u08A3\。ς\\uDB41\\uDEC4\\uDB41\\uDDD7\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7E}\x{2DEE}\x{08A3}。Σ\x{E06C4}\x{E05D7}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\\u2DEE\\u08A3\。Σ\\uDB41\\uDEC4\\uDB41\\uDDD7\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7E}\x{2DEE}\x{08A3}。σ\x{E06C4}\x{E05D7}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7E\\u2DEE\\u08A3\。σ\\uDB41\\uDEC4\\uDB41\\uDDD7\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3871\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("-\x{0794}ᡛ∵。\x{116B6}𝟥", %p)},	undef,	"to_unicode\(\'\-\\u0794ᡛ\∵\。\\uD805\\uDEB6𝟥\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3872\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("-\x{0794}ᡛ∵。\x{116B6}3", %p)},	undef,	"to_unicode\(\'\-\\u0794ᡛ\∵\。\\uD805\\uDEB63\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3873\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}﹖｡\x{C0855}≮\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C﹖｡\\uDAC2\\uDC55\≮\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}﹖｡\x{C0855}≮\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C﹖｡\\uDAC2\\uDC55\≮\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}﹖｡\x{C0855}<\x{0338}\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C﹖｡\\uDAC2\\uDC55\<\\u0338\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}﹖｡\x{C0855}<\x{0338}\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C﹖｡\\uDAC2\\uDC55\<\\u0338\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}?。\x{C0855}≮\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\uDAC2\\uDC55\≮\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}?。\x{C0855}≮\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\uDAC2\\uDC55\≮\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}?。\x{C0855}<\x{0338}\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\uDAC2\\uDC55\<\\u0338\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}?。\x{C0855}<\x{0338}\x{1EF57}", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\uDAC2\\uDC55\<\\u0338\\uD83B\\uDF57\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{E0A2A}\x{A2DCC}．𝟡\x{D3163}", %p)},	undef,	"to_unicode\(\'⒈\\uDB42\\uDE2A\\uDA4B\\uDDCC．𝟡\\uDB0C\\uDD63\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{E0A2A}\x{A2DCC}.9\x{D3163}", %p)},	undef,	"to_unicode\(\'1\.\\uDB42\\uDE2A\\uDA4B\\uDDCC\.9\\uDB0C\\uDD63\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08FF}ꡠ\x{10F90}.\x{10E77}\x{031B}", %p)},	undef,	"to_unicode\(\'\\u08FFꡠ\\uD803\\uDF90\.\\uD803\\uDE77\\u031B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς．\x{0D4D}\x{17D2}", %p)},	undef,	"to_unicode\(\'ς．\\u0D4D\\u17D2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς.\x{0D4D}\x{17D2}", %p)},	undef,	"to_unicode\(\'ς\.\\u0D4D\\u17D2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.\x{0D4D}\x{17D2}", %p)},	undef,	"to_unicode\(\'Σ\.\\u0D4D\\u17D2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.\x{0D4D}\x{17D2}", %p)},	undef,	"to_unicode\(\'σ\.\\u0D4D\\u17D2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ．\x{0D4D}\x{17D2}", %p)},	undef,	"to_unicode\(\'Σ．\\u0D4D\\u17D2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ．\x{0D4D}\x{17D2}", %p)},	undef,	"to_unicode\(\'σ．\\u0D4D\\u17D2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}≯\x{0794}．\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\≯\\u0794．\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}≯\x{0794}．\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\≯\\u0794．\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}>\x{0338}\x{0794}．\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\>\\u0338\\u0794．\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}>\x{0338}\x{0794}．\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\>\\u0338\\u0794．\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}≯\x{0794}.\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\≯\\u0794\.\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}≯\x{0794}.\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\≯\\u0794\.\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}>\x{0338}\x{0794}.\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\>\\u0338\\u0794\.\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E2}\x{200C}>\x{0338}\x{0794}.\x{E01DB}", %p)},	undef,	"to_unicode\(\'\\uA8E2\\u200C\>\\u0338\\u0794\.\\uDB40\\uDDDB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡≯", %p)},	undef,	"to_unicode\(\'羚｡\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡>\x{0338}", %p)},	undef,	"to_unicode\(\'羚｡\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。≯", %p)},	undef,	"to_unicode\(\'羚\。\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。>\x{0338}", %p)},	undef,	"to_unicode\(\'羚\。\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}\x{1759}．\x{0622}", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u1759．\\u0622\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}\x{1759}．\x{0627}\x{0653}", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u1759．\\u0627\\u0653\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}\x{1759}.\x{0622}", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u1759\.\\u0622\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}\x{1759}.\x{0627}\x{0653}", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u1759\.\\u0627\\u0653\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}｡\x{10E61}ҠჀ𝟑", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D｡\\uD803\\uDE61ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}｡\x{10E61}ҠჀ𝟑", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D｡\\uD803\\uDE61ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}。\x{10E61}ҠჀ3", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D\。\\uD803\\uDE61ҠჀ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}。\x{10E61}ҠჀ3", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D\。\\uD803\\uDE61ҠჀ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}。\x{10E61}ҡⴠ3", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D\。\\uD803\\uDE61ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}。\x{10E61}ҡⴠ3", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D\。\\uD803\\uDE61ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}。\x{10E61}Ҡⴠ3", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D\。\\uD803\\uDE61Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}。\x{10E61}Ҡⴠ3", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D\。\\uD803\\uDE61Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}｡\x{10E61}ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D｡\\uD803\\uDE61ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}｡\x{10E61}ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D｡\\uD803\\uDE61ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}｡\x{10E61}Ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D｡\\uD803\\uDE61Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3C900}\x{0B42}\x{200D}｡\x{10E61}Ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDD00\\u0B42\\u200D｡\\uD803\\uDE61Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3918\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{10B8D}。\x{0661}\x{E013A}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF8D\。\\u0661\\uDB40\\uDD3A\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3919\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}｡\x{10E7E}\x{DAB6A}\x{A9C0}ß", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6｡\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}。\x{10E7E}\x{DAB6A}\x{A9C0}ß", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6\。\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}。\x{10E7E}\x{DAB6A}\x{A9C0}SS", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6\。\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}。\x{10E7E}\x{DAB6A}\x{A9C0}ss", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6\。\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}。\x{10E7E}\x{DAB6A}\x{A9C0}Ss", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6\。\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}｡\x{10E7E}\x{DAB6A}\x{A9C0}SS", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6｡\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}｡\x{10E7E}\x{DAB6A}\x{A9C0}ss", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6｡\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{7C1B5}\x{116B6}｡\x{10E7E}\x{DAB6A}\x{A9C0}Ss", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDB5\\uD805\\uDEB6｡\\uD803\\uDE7E\\uDB2A\\uDF6A\\uA9C0Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}\x{5119A}\x{1A6B}.\x{E075C}︒≠", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68\\uD904\\uDD9A\\u1A6B\.\\uDB41\\uDF5C︒\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}\x{5119A}\x{1A6B}.\x{E075C}︒=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68\\uD904\\uDD9A\\u1A6B\.\\uDB41\\uDF5C︒\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}\x{5119A}\x{1A6B}.\x{E075C}。≠", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68\\uD904\\uDD9A\\u1A6B\.\\uDB41\\uDF5C\。\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}\x{5119A}\x{1A6B}.\x{E075C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68\\uD904\\uDD9A\\u1A6B\.\\uDB41\\uDF5C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}ỗ⒈．\x{EA430}\x{2CF18}⿑𝟫", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8Dỗ⒈．\\uDB69\\uDC30\\uD873\\uDF18⿑𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}o\x{0302}\x{0303}⒈．\x{EA430}\x{2CF18}⿑𝟫", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8Do\\u0302\\u0303⒈．\\uDB69\\uDC30\\uD873\\uDF18⿑𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}ỗ1..\x{EA430}\x{2CF18}齊9", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8Dỗ1\.\.\\uDB69\\uDC30\\uD873\\uDF18齊9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}o\x{0302}\x{0303}1..\x{EA430}\x{2CF18}齊9", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8Do\\u0302\\u03031\.\.\\uDB69\\uDC30\\uD873\\uDF18齊9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}O\x{0302}\x{0303}1..\x{EA430}\x{2CF18}齊9", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8DO\\u0302\\u03031\.\.\\uDB69\\uDC30\\uD873\\uDF18齊9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}Ỗ1..\x{EA430}\x{2CF18}齊9", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8DỖ1\.\.\\uDB69\\uDC30\\uD873\\uDF18齊9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}O\x{0302}\x{0303}⒈．\x{EA430}\x{2CF18}⿑𝟫", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8DO\\u0302\\u0303⒈．\\uDB69\\uDC30\\uD873\\uDF18⿑𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔹\x{5248D}Ỗ⒈．\x{EA430}\x{2CF18}⿑𝟫", %p)},	undef,	"to_unicode\(\'🔹\\uD909\\uDC8DỖ⒈．\\uDB69\\uDC30\\uD873\\uDF18⿑𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{068E}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\u068E\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡\x{068E}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\u068E\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{068E}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u068E\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{068E}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u068E\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--kjb", %p)},	"\x{068E}",	"to_unicode\(\'xn\-\-kjb\'\)\ \[data\/IdnaTest\.txt\:3944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}", %p)},	"\x{068E}",	"to_unicode\(\'\\u068E\'\)\ \[data\/IdnaTest\.txt\:3945\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1BA3}\x{0844}.\x{10AED}", %p)},	undef,	"to_unicode\(\'\\u1BA3\\u0844\.\\uD802\\uDEED\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3946\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}ß", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3Eß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}ß", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3Eß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}SS", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3ESS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}SS", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3ESS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}ss", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3Ess\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}ss", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3Ess\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}Ss", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3ESs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB8}\x{200C}-。\x{A213E}Ss", %p)},	undef,	"to_unicode\(\'\\u1AB8\\u200C\-\。\\uDA48\\uDD3ESs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς\x{E0B20}⒗.\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cς\\uDB42\\uDF20⒗\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς\x{E0B20}⒗.\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cς\\uDB42\\uDF20⒗\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς\x{E0B20}16..\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cς\\uDB42\\uDF2016\.\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς\x{E0B20}16..\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cς\\uDB42\\uDF2016\.\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ\x{E0B20}16..\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200CΣ\\uDB42\\uDF2016\.\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ\x{E0B20}16..\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200CΣ\\uDB42\\uDF2016\.\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ\x{E0B20}16..\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cσ\\uDB42\\uDF2016\.\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ\x{E0B20}16..\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cσ\\uDB42\\uDF2016\.\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ\x{E0B20}⒗.\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200CΣ\\uDB42\\uDF20⒗\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ\x{E0B20}⒗.\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200CΣ\\uDB42\\uDF20⒗\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ\x{E0B20}⒗.\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cσ\\uDB42\\uDF20⒗\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ\x{E0B20}⒗.\x{E0058}\x{F1A6C}\x{10AE0}", %p)},	undef,	"to_unicode\(\'\\u200Cσ\\uDB42\\uDF20⒗\.\\uDB40\\uDC58\\uDB86\\uDE6C\\uD802\\uDEE0\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{10826}", %p)},	undef,	"to_unicode\(\'\-\.\\uD802\\uDC26\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3967\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("𩨹\x{0635}.\x{E0136}\x{0777}", %p)},	undef,	"to_unicode\(\'𩨹\\u0635\.\\uDB40\\uDD36\\u0777\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:3968\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0FE6}ᠼ洰.\x{0645}", %p)},	undef,	"to_unicode\(\'\\u0FE6ᠼ洰\.\\u0645\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒß。\x{071F}", %p)},	"2ꐢᢒß.\x{071F}",	"to_unicode\(\'2ꐢᢒß\。\\u071F\'\)\ \[data\/IdnaTest\.txt\:3970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒß。\x{071F}", %p)},	"2ꐢᢒß.\x{071F}",	"to_unicode\(\'2ꐢᢒß\。\\u071F\'\)\ \[data\/IdnaTest\.txt\:3971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒSS。\x{071F}", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'2ꐢᢒSS\。\\u071F\'\)\ \[data\/IdnaTest\.txt\:3972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒss。\x{071F}", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'2ꐢᢒss\。\\u071F\'\)\ \[data\/IdnaTest\.txt\:3973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒSs。\x{071F}", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'2ꐢᢒSs\。\\u071F\'\)\ \[data\/IdnaTest\.txt\:3974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--2ss-jeuu515g.xn--pnb", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'xn\-\-2ss\-jeuu515g\.xn\-\-pnb\'\)\ \[data\/IdnaTest\.txt\:3975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒss.\x{071F}", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'2ꐢᢒss\.\\u071F\'\)\ \[data\/IdnaTest\.txt\:3976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒSS.\x{071F}", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'2ꐢᢒSS\.\\u071F\'\)\ \[data\/IdnaTest\.txt\:3977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒSs.\x{071F}", %p)},	"2ꐢᢒss.\x{071F}",	"to_unicode\(\'2ꐢᢒSs\.\\u071F\'\)\ \[data\/IdnaTest\.txt\:3978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--2-qfa413pgt1k.xn--pnb", %p)},	"2ꐢᢒß.\x{071F}",	"to_unicode\(\'xn\-\-2\-qfa413pgt1k\.xn\-\-pnb\'\)\ \[data\/IdnaTest\.txt\:3979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒß.\x{071F}", %p)},	"2ꐢᢒß.\x{071F}",	"to_unicode\(\'2ꐢᢒß\.\\u071F\'\)\ \[data\/IdnaTest\.txt\:3980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2ꐢᢒß.\x{071F}", %p)},	"2ꐢᢒß.\x{071F}",	"to_unicode\(\'2ꐢᢒß\.\\u071F\'\)\ \[data\/IdnaTest\.txt\:3981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}.ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338\.ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮.ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮\.ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔSS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔSS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4010\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}<\x{0338}．ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\<\\u0338．ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{0723}≮．ᡔSs-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u0723\≮．ᡔSs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{6393C}\x{1030}\x{1AB6}.\x{1086}-︒", %p)},	undef,	"to_unicode\(\'\-\\uD94E\\uDD3C\\u1030\\u1AB6\.\\u1086\-︒\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{6393C}\x{1030}\x{1AB6}.\x{1086}-。", %p)},	undef,	"to_unicode\(\'\-\\uD94E\\uDD3C\\u1030\\u1AB6\.\\u1086\-\。\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.\x{37E9D}\x{1C37}", %p)},	undef,	"to_unicode\(\'︒\.\\uD89F\\uDE9D\\u1C37\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。.\x{37E9D}\x{1C37}", %p)},	undef,	"to_unicode\(\'\。\.\\uD89F\\uDE9D\\u1C37\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4017\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0314}\x{E01C9}。\x{200C}⓾\x{200C}\x{0843}", %p)},	undef,	"to_unicode\(\'\\u0314\\uDB40\\uDDC9\。\\u200C⓾\\u200C\\u0843\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4018\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0314}\x{E01C9}。\x{200C}⓾\x{200C}\x{0843}", %p)},	undef,	"to_unicode\(\'\\u0314\\uDB40\\uDDC9\。\\u200C⓾\\u200C\\u0843\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4019\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{108FA}\x{10BAA}\x{066B}｡\x{E0105}ᢜ\x{1C31}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDCFA\\uD802\\uDFAA\\u066B｡\\uDB40\\uDD05ᢜ\\u1C31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{108FA}\x{10BAA}\x{066B}。\x{E0105}ᢜ\x{1C31}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDCFA\\uD802\\uDFAA\\u066B\。\\uDB40\\uDD05ᢜ\\u1C31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0022}.-𥦳", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC22\.\-𥦳\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⏈．赏", %p)},	"⏈.赏",	"to_unicode\(\'\⏈．赏\'\)\ \[data\/IdnaTest\.txt\:4023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⏈.赏", %p)},	"⏈.赏",	"to_unicode\(\'\⏈\.赏\'\)\ \[data\/IdnaTest\.txt\:4024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--cnh.xn--6o3a", %p)},	"⏈.赏",	"to_unicode\(\'xn\-\-cnh\.xn\-\-6o3a\'\)\ \[data\/IdnaTest\.txt\:4025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084A}\x{10AC9}｡Ⴁ", %p)},	undef,	"to_unicode\(\'\\u084A\\uD802\\uDEC9｡Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084A}\x{10AC9}。Ⴁ", %p)},	undef,	"to_unicode\(\'\\u084A\\uD802\\uDEC9\。Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4027\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{084A}\x{10AC9}。ⴁ", %p)},	"\x{084A}\x{10AC9}.ⴁ",	"to_unicode\(\'\\u084A\\uD802\\uDEC9\。ⴁ\'\)\ \[data\/IdnaTest\.txt\:4028\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--8vb4643k.xn--skj", %p)},	"\x{084A}\x{10AC9}.ⴁ",	"to_unicode\(\'xn\-\-8vb4643k\.xn\-\-skj\'\)\ \[data\/IdnaTest\.txt\:4029\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{084A}\x{10AC9}.ⴁ", %p)},	"\x{084A}\x{10AC9}.ⴁ",	"to_unicode\(\'\\u084A\\uD802\\uDEC9\.ⴁ\'\)\ \[data\/IdnaTest\.txt\:4030\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{084A}\x{10AC9}.Ⴁ", %p)},	undef,	"to_unicode\(\'\\u084A\\uD802\\uDEC9\.Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4031\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{084A}\x{10AC9}｡ⴁ", %p)},	"\x{084A}\x{10AC9}.ⴁ",	"to_unicode\(\'\\u084A\\uD802\\uDEC9｡ⴁ\'\)\ \[data\/IdnaTest\.txt\:4032\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0132}Ⴊ\x{0630}ς｡-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32Ⴊ\\u0630ς｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0132}Ⴊ\x{0630}ς。-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32Ⴊ\\u0630ς\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4034\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{E0132}ⴊ\x{0630}ς。-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32ⴊ\\u0630ς\。\-\'\)\ throws\ error\ V3\ B5\ \[data\/IdnaTest\.txt\:4035\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0132}Ⴊ\x{0630}Σ。-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32Ⴊ\\u0630Σ\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4036\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{E0132}ⴊ\x{0630}σ。-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32ⴊ\\u0630σ\。\-\'\)\ throws\ error\ V3\ B5\ \[data\/IdnaTest\.txt\:4037\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0132}Ⴊ\x{0630}σ。-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32Ⴊ\\u0630σ\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4038\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{E0132}ⴊ\x{0630}ς｡-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32ⴊ\\u0630ς｡\-\'\)\ throws\ error\ V3\ B5\ \[data\/IdnaTest\.txt\:4039\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0132}Ⴊ\x{0630}Σ｡-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32Ⴊ\\u0630Σ｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4040\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{E0132}ⴊ\x{0630}σ｡-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32ⴊ\\u0630σ｡\-\'\)\ throws\ error\ V3\ B5\ \[data\/IdnaTest\.txt\:4041\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0132}Ⴊ\x{0630}σ｡-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD32Ⴊ\\u0630σ｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ．\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ．\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ．\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ．\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ.\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\.\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ.\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\.\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ.\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\.\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ.\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\.\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ．\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ．\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ．\x{10C51E}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ．\\uDBF1\\uDD1E\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{30C15}ˬ.\x{0842}\x{0E3A}\x{98FA8}\x{112EA}", %p)},	undef,	"to_unicode\(\'\\uD883\\uDC15ˬ\.\\u0842\\u0E3A\\uDA23\\uDFA8\\uD804\\uDEEA\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𝈼ꡰ｡\x{0662}\x{1D17D}", %p)},	undef,	"to_unicode\(\'\≯𝈼ꡰ｡\\u0662\\uD834\\uDD7D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𝈼ꡰ｡\x{0662}\x{1D17D}", %p)},	undef,	"to_unicode\(\'\>\\u0338𝈼ꡰ｡\\u0662\\uD834\\uDD7D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𝈼ꡰ。\x{0662}\x{1D17D}", %p)},	undef,	"to_unicode\(\'\≯𝈼ꡰ\。\\u0662\\uD834\\uDD7D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𝈼ꡰ。\x{0662}\x{1D17D}", %p)},	undef,	"to_unicode\(\'\>\\u0338𝈼ꡰ\。\\u0662\\uD834\\uDD7D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5383C}\x{0601}\x{FBDF}\x{0666}。ႨꡑႯ", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDC3C\\u0601\\uFBDF\\u0666\。ႨꡑႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5383C}\x{0601}\x{06CB}\x{0666}。ႨꡑႯ", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDC3C\\u0601\\u06CB\\u0666\。ႨꡑႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5383C}\x{0601}\x{06CB}\x{0666}。ⴈꡑⴏ", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDC3C\\u0601\\u06CB\\u0666\。ⴈꡑⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5383C}\x{0601}\x{06CB}\x{0666}。Ⴈꡑⴏ", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDC3C\\u0601\\u06CB\\u0666\。Ⴈꡑⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5383C}\x{0601}\x{FBDF}\x{0666}。ⴈꡑⴏ", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDC3C\\u0601\\uFBDF\\u0666\。ⴈꡑⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{5383C}\x{0601}\x{FBDF}\x{0666}。Ⴈꡑⴏ", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDC3C\\u0601\\uFBDF\\u0666\。Ⴈꡑⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1ECA8}。\x{115BD}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDCA8\。\\uD805\\uDDBD\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟔\x{10E7D}．\x{1112A}\x{E0F72}９ꡐ", %p)},	undef,	"to_unicode\(\'𝟔\\uD803\\uDE7D．\\uD804\\uDD2A\\uDB43\\uDF72９ꡐ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6\x{10E7D}.\x{1112A}\x{E0F72}9ꡐ", %p)},	undef,	"to_unicode\(\'6\\uD803\\uDE7D\.\\uD804\\uDD2A\\uDB43\\uDF729ꡐ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{10E7E}\x{10EC9}．\x{0CC6}", %p)},	undef,	"to_unicode\(\'ᡀ\\uD803\\uDE7E\\uD803\\uDEC9．\\u0CC6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡀ\x{10E7E}\x{10EC9}.\x{0CC6}", %p)},	undef,	"to_unicode\(\'ᡀ\\uD803\\uDE7E\\uD803\\uDEC9\.\\u0CC6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⚯\x{71A0C}\x{10BAD}．\x{10BCA}\x{200D}\x{1ED77}", %p)},	undef,	"to_unicode\(\'\⚯\\uD986\\uDE0C\\uD802\\uDFAD．\\uD802\\uDFCA\\u200D\\uD83B\\uDD77\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⚯\x{71A0C}\x{10BAD}．\x{10BCA}\x{200D}\x{1ED77}", %p)},	undef,	"to_unicode\(\'\⚯\\uD986\\uDE0C\\uD802\\uDFAD．\\uD802\\uDFCA\\u200D\\uD83B\\uDD77\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⚯\x{71A0C}\x{10BAD}.\x{10BCA}\x{200D}\x{1ED77}", %p)},	undef,	"to_unicode\(\'\⚯\\uD986\\uDE0C\\uD802\\uDFAD\.\\uD802\\uDFCA\\u200D\\uD83B\\uDD77\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⚯\x{71A0C}\x{10BAD}.\x{10BCA}\x{200D}\x{1ED77}", %p)},	undef,	"to_unicode\(\'\⚯\\uD986\\uDE0C\\uD802\\uDFAD\.\\uD802\\uDFCA\\u200D\\uD83B\\uDD77\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AC3}\x{72CFF}\x{1E812}-．≠\x{FBDBB}\x{A953}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3\\uD98B\\uDCFF\\uD83A\\uDC12\-．\≠\\uDBAF\\uDDBB\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AC3}\x{72CFF}\x{1E812}-．=\x{0338}\x{FBDBB}\x{A953}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3\\uD98B\\uDCFF\\uD83A\\uDC12\-．\=\\u0338\\uDBAF\\uDDBB\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AC3}\x{72CFF}\x{1E812}-.≠\x{FBDBB}\x{A953}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3\\uD98B\\uDCFF\\uD83A\\uDC12\-\.\≠\\uDBAF\\uDDBB\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10AC3}\x{72CFF}\x{1E812}-.=\x{0338}\x{FBDBB}\x{A953}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEC3\\uD98B\\uDCFF\\uD83A\\uDC12\-\.\=\\u0338\\uDBAF\\uDDBB\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟛．\x{91B25}", %p)},	undef,	"to_unicode\(\'𝟛．\\uDA06\\uDF25\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3.\x{91B25}", %p)},	undef,	"to_unicode\(\'3\.\\uDA06\\uDF25\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:4077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:4078\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:4079\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:4080\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ςß\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4081\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ςß\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4082\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ςß\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4083\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ςß\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4084\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4085\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4086\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σss\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4087\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σss\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4088\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σss\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4089\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σss\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4090\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σß\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4091\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σß\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4092\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σß\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σß\x{035C}.\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u035C\.\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4095\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4096\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σss\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4097\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σss\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4098\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σss\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4099\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σss\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4100\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σß\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4101\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}Σß\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4102\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σß\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4103\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}σß\x{035C}．\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u035C．\\uABED\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4104\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠．\x{200D}", %p)},	undef,	"to_unicode\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠．\x{200D}", %p)},	undef,	"to_unicode\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}．\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}．\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200D}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200D}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EEC5}｡\x{11373}\x{07CF}\x{E0767}\x{B518F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDEC5｡\\uD804\\uDF73\\u07CF\\uDB41\\uDF67\\uDA94\\uDD8F\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1EEC5}。\x{11373}\x{07CF}\x{E0767}\x{B518F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDEC5\。\\uD804\\uDF73\\u07CF\\uDB41\\uDF67\\uDA94\\uDD8F\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}ς．ς\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33ς．ς\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}ς.ς\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33ς\.ς\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}Σ.Σ\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33Σ\.Σ\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}σ.ς\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33σ\.ς\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}σ.σ\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33σ\.σ\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}Σ.σ\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33Σ\.σ\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}Σ.ς\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33Σ\.ς\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}Σ．Σ\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33Σ．Σ\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}σ．ς\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33σ．ς\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}σ．σ\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33σ．σ\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}Σ．σ\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33Σ．σ\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E1951}\x{11133}Σ．ς\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\uDB46\\uDD51\\uD804\\uDD33Σ．ς\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAD}\x{07D1}牅\x{05B6}｡\x{1E870}\x{A9E5}\x{D20A5}Ⴙ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAD\\u07D1牅\\u05B6｡\\uD83A\\uDC70\\uA9E5\\uDB08\\uDCA5Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAD}\x{07D1}牅\x{05B6}。\x{1E870}\x{A9E5}\x{D20A5}Ⴙ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAD\\u07D1牅\\u05B6\。\\uD83A\\uDC70\\uA9E5\\uDB08\\uDCA5Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAD}\x{07D1}牅\x{05B6}。\x{1E870}\x{A9E5}\x{D20A5}ⴙ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAD\\u07D1牅\\u05B6\。\\uD83A\\uDC70\\uA9E5\\uDB08\\uDCA5ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10BAD}\x{07D1}牅\x{05B6}｡\x{1E870}\x{A9E5}\x{D20A5}ⴙ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDFAD\\u07D1牅\\u05B6｡\\uD83A\\uDC70\\uA9E5\\uDB08\\uDCA5ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C8742}｡륧", %p)},	undef,	"to_unicode\(\'\\uDAE1\\uDF42｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C8742}｡륧", %p)},	undef,	"to_unicode\(\'\\uDAE1\\uDF42｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C8742}。륧", %p)},	undef,	"to_unicode\(\'\\uDAE1\\uDF42\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{C8742}。륧", %p)},	undef,	"to_unicode\(\'\\uDAE1\\uDF42\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E71}\x{200D}。\x{6A1A8}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE71\\u200D\。\\uD968\\uDDA8\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E71}\x{200D}。\x{6A1A8}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE71\\u200D\。\\uD968\\uDDA8\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘ\x{0724}\x{0337}｡-", %p)},	undef,	"to_unicode\(\'Ⴘ\\u0724\\u0337｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘ\x{0724}\x{0337}。-", %p)},	undef,	"to_unicode\(\'Ⴘ\\u0724\\u0337\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4138\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴘ\x{0724}\x{0337}。-", %p)},	undef,	"to_unicode\(\'ⴘ\\u0724\\u0337\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4139\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴘ\x{0724}\x{0337}｡-", %p)},	undef,	"to_unicode\(\'ⴘ\\u0724\\u0337｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4140\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{ABED}ᢋ₆ᡄ。᠈\x{1EF7E}", %p)},	undef,	"to_unicode\(\'\\uABEDᢋ₆ᡄ\。᠈\\uD83B\\uDF7E\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}ᢋ6ᡄ。᠈\x{1EF7E}", %p)},	undef,	"to_unicode\(\'\\uABEDᢋ6ᡄ\。᠈\\uD83B\\uDF7E\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{4A95E}.⤾ᠷᠪ\x{06A8}", %p)},	undef,	"to_unicode\(\'\\uD8EA\\uDD5E\.\⤾ᠷᠪ\\u06A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4143\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{071B}𫜄。-ᡅ", %p)},	undef,	"to_unicode\(\'\\u071B𫜄\。\-ᡅ\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4144\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ςᡎ⾑．\x{200C}ᡯ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'ςᡎ⾑．\\u200Cᡯ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςᡎ⾑．\x{200C}ᡯ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'ςᡎ⾑．\\u200Cᡯ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςᡎ襾.\x{200C}ᡯ\x{200C}1.", %p)},	undef,	"to_unicode\(\'ςᡎ襾\.\\u200Cᡯ\\u200C1\.\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςᡎ襾.\x{200C}ᡯ\x{200C}1.", %p)},	undef,	"to_unicode\(\'ςᡎ襾\.\\u200Cᡯ\\u200C1\.\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σᡎ襾.\x{200C}ᡯ\x{200C}1.", %p)},	undef,	"to_unicode\(\'Σᡎ襾\.\\u200Cᡯ\\u200C1\.\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σᡎ襾.\x{200C}ᡯ\x{200C}1.", %p)},	undef,	"to_unicode\(\'Σᡎ襾\.\\u200Cᡯ\\u200C1\.\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σᡎ襾.\x{200C}ᡯ\x{200C}1.", %p)},	undef,	"to_unicode\(\'σᡎ襾\.\\u200Cᡯ\\u200C1\.\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σᡎ襾.\x{200C}ᡯ\x{200C}1.", %p)},	undef,	"to_unicode\(\'σᡎ襾\.\\u200Cᡯ\\u200C1\.\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4xa236hxx6f.xn--1-e9j.", %p)},	"σᡎ襾.ᡯ1.",	"to_unicode\(\'xn\-\-4xa236hxx6f\.xn\-\-1\-e9j\.\'\)\ \[data\/IdnaTest\.txt\:4153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σᡎ襾.ᡯ1.", %p)},	"σᡎ襾.ᡯ1.",	"to_unicode\(\'σᡎ襾\.ᡯ1\.\'\)\ \[data\/IdnaTest\.txt\:4154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σᡎ襾.ᡯ1.", %p)},	"σᡎ襾.ᡯ1.",	"to_unicode\(\'Σᡎ襾\.ᡯ1\.\'\)\ \[data\/IdnaTest\.txt\:4155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σᡎ⾑．\x{200C}ᡯ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'Σᡎ⾑．\\u200Cᡯ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σᡎ⾑．\x{200C}ᡯ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'Σᡎ⾑．\\u200Cᡯ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σᡎ⾑．\x{200C}ᡯ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'σᡎ⾑．\\u200Cᡯ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σᡎ⾑．\x{200C}ᡯ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'σᡎ⾑．\\u200Cᡯ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢤ\x{82F0A}．\x{10C44}", %p)},	undef,	"to_unicode\(\'ᢤ\\uD9CB\\uDF0A．\\uD803\\uDC44\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢤ\x{82F0A}.\x{10C44}", %p)},	undef,	"to_unicode\(\'ᢤ\\uD9CB\\uDF0A\.\\uD803\\uDC44\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAB}\x{C9A71}\x{E018C}｡\x{200C}\x{0628}\x{E6475}", %p)},	undef,	"to_unicode\(\'\\u1BAB\\uDAE6\\uDE71\\uDB40\\uDD8C｡\\u200C\\u0628\\uDB59\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAB}\x{C9A71}\x{E018C}｡\x{200C}\x{0628}\x{E6475}", %p)},	undef,	"to_unicode\(\'\\u1BAB\\uDAE6\\uDE71\\uDB40\\uDD8C｡\\u200C\\u0628\\uDB59\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAB}\x{C9A71}\x{E018C}。\x{200C}\x{0628}\x{E6475}", %p)},	undef,	"to_unicode\(\'\\u1BAB\\uDAE6\\uDE71\\uDB40\\uDD8C\。\\u200C\\u0628\\uDB59\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAB}\x{C9A71}\x{E018C}。\x{200C}\x{0628}\x{E6475}", %p)},	undef,	"to_unicode\(\'\\u1BAB\\uDAE6\\uDE71\\uDB40\\uDD8C\。\\u200C\\u0628\\uDB59\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{066F}\x{E0068}\x{36B7A}-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u066F\\uDB40\\uDC68\\uD89A\\uDF7A\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FF546}｡\x{06AE}", %p)},	undef,	"to_unicode\(\'\\uDBBD\\uDD46｡\\u06AE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FF546}。\x{06AE}", %p)},	undef,	"to_unicode\(\'\\uDBBD\\uDD46\。\\u06AE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4175\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃❯．\x{200D}\x{1DE1}", %p)},	undef,	"to_unicode\(\'嬃\❯．\\u200D\\u1DE1\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4176\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃❯．\x{200D}\x{1DE1}", %p)},	undef,	"to_unicode\(\'嬃\❯．\\u200D\\u1DE1\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4177\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃❯.\x{200D}\x{1DE1}", %p)},	undef,	"to_unicode\(\'嬃\❯\.\\u200D\\u1DE1\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4178\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃❯.\x{200D}\x{1DE1}", %p)},	undef,	"to_unicode\(\'嬃\❯\.\\u200D\\u1DE1\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4179\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E64}📗≯．\x{9CA52}\x{54DB0}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64📗\≯．\\uDA32\\uDE52\\uD913\\uDDB0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E64}📗>\x{0338}．\x{9CA52}\x{54DB0}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64📗\>\\u0338．\\uDA32\\uDE52\\uD913\\uDDB0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E64}📗≯.\x{9CA52}\x{54DB0}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64📗\≯\.\\uDA32\\uDE52\\uD913\\uDDB0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E64}📗>\x{0338}.\x{9CA52}\x{54DB0}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64📗\>\\u0338\.\\uDA32\\uDE52\\uD913\\uDDB0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{92478}ᠴ\x{08F6}\x{1BF3}.\x{1EF1B}", %p)},	undef,	"to_unicode\(\'\\uDA09\\uDC78ᠴ\\u08F6\\u1BF3\.\\uD83B\\uDF1B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{92478}ᠴ\x{1BF3}\x{08F6}.\x{1EF1B}", %p)},	undef,	"to_unicode\(\'\\uDA09\\uDC78ᠴ\\u1BF3\\u08F6\.\\uD83B\\uDF1B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{E31E1}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\uDB4C\\uDDE1\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{E31E1}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\uDB4C\\uDDE1\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{86A0F}Ⴃ䠅．\x{1EC59}", %p)},	undef,	"to_unicode\(\'\\uD9DA\\uDE0FႣ䠅．\\uD83B\\uDC59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{86A0F}Ⴃ䠅.\x{1EC59}", %p)},	undef,	"to_unicode\(\'\\uD9DA\\uDE0FႣ䠅\.\\uD83B\\uDC59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{86A0F}ⴃ䠅.\x{1EC59}", %p)},	undef,	"to_unicode\(\'\\uD9DA\\uDE0Fⴃ䠅\.\\uD83B\\uDC59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{86A0F}ⴃ䠅．\x{1EC59}", %p)},	undef,	"to_unicode\(\'\\uD9DA\\uDE0Fⴃ䠅．\\uD83B\\uDC59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{193A}\x{0662}\x{10E6E}\x{10AED}｡𝟨Ⴅ", %p)},	undef,	"to_unicode\(\'\\u193A\\u0662\\uD803\\uDE6E\\uD802\\uDEED｡𝟨Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{193A}\x{0662}\x{10E6E}\x{10AED}。6Ⴅ", %p)},	undef,	"to_unicode\(\'\\u193A\\u0662\\uD803\\uDE6E\\uD802\\uDEED\。6Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4193\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{193A}\x{0662}\x{10E6E}\x{10AED}。6ⴅ", %p)},	undef,	"to_unicode\(\'\\u193A\\u0662\\uD803\\uDE6E\\uD802\\uDEED\。6ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4194\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{193A}\x{0662}\x{10E6E}\x{10AED}｡𝟨ⴅ", %p)},	undef,	"to_unicode\(\'\\u193A\\u0662\\uD803\\uDE6E\\uD802\\uDEED｡𝟨ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4195\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡︒", %p)},	undef,	"to_unicode\(\'\-｡︒\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。。", %p)},	undef,	"to_unicode\(\'\-\。\。\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:4197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CA}Ⴠ｡-⁵--", %p)},	undef,	"to_unicode\(\'\\u07CAჀ｡\-⁵\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CA}Ⴠ。-5--", %p)},	undef,	"to_unicode\(\'\\u07CAჀ\。\-5\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4199\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CA}ⴠ。-5--", %p)},	undef,	"to_unicode\(\'\\u07CAⴠ\。\-5\-\-\'\)\ throws\ error\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CA}ⴠ｡-⁵--", %p)},	undef,	"to_unicode\(\'\\u07CAⴠ｡\-⁵\-\-\'\)\ throws\ error\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4201\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{D8DD}🀾｡\x{066C}\x{10E63}≯\x{10D8A}", %p)},	undef,	"to_unicode\(\'\≯\\uD8DD🀾｡\\u066C\\uD803\\uDE63\≯\\uD803\\uDD8A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{D8DD}🀾｡\x{066C}\x{10E63}>\x{0338}\x{10D8A}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD8DD🀾｡\\u066C\\uD803\\uDE63\>\\u0338\\uD803\\uDD8A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{D8DD}🀾。\x{066C}\x{10E63}≯\x{10D8A}", %p)},	undef,	"to_unicode\(\'\≯\\uD8DD🀾\。\\u066C\\uD803\\uDE63\≯\\uD803\\uDD8A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{D8DD}🀾。\x{066C}\x{10E63}>\x{0338}\x{10D8A}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD8DD🀾\。\\u066C\\uD803\\uDE63\>\\u0338\\uD803\\uDD8A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㍔\x{ABED}\x{06CC}\x{200D}。\x{E01B6}\x{A0BCB}\x{E0166}\x{10E7E}", %p)},	undef,	"to_unicode\(\'㍔\\uABED\\u06CC\\u200D\。\\uDB40\\uDDB6\\uDA42\\uDFCB\\uDB40\\uDD66\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㍔\x{ABED}\x{06CC}\x{200D}。\x{E01B6}\x{A0BCB}\x{E0166}\x{10E7E}", %p)},	undef,	"to_unicode\(\'㍔\\uABED\\u06CC\\u200D\。\\uDB40\\uDDB6\\uDA42\\uDFCB\\uDB40\\uDD66\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーブル\x{ABED}\x{06CC}\x{200D}。\x{E01B6}\x{A0BCB}\x{E0166}\x{10E7E}", %p)},	undef,	"to_unicode\(\'ルーブル\\uABED\\u06CC\\u200D\。\\uDB40\\uDDB6\\uDA42\\uDFCB\\uDB40\\uDD66\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーブル\x{ABED}\x{06CC}\x{200D}。\x{E01B6}\x{A0BCB}\x{E0166}\x{10E7E}", %p)},	undef,	"to_unicode\(\'ルーブル\\uABED\\u06CC\\u200D\。\\uDB40\\uDDB6\\uDA42\\uDFCB\\uDB40\\uDD66\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーフ\x{3099}ル\x{ABED}\x{06CC}\x{200D}。\x{E01B6}\x{A0BCB}\x{E0166}\x{10E7E}", %p)},	undef,	"to_unicode\(\'ルーフ\\u3099ル\\uABED\\u06CC\\u200D\。\\uDB40\\uDDB6\\uDA42\\uDFCB\\uDB40\\uDD66\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーフ\x{3099}ル\x{ABED}\x{06CC}\x{200D}。\x{E01B6}\x{A0BCB}\x{E0166}\x{10E7E}", %p)},	undef,	"to_unicode\(\'ルーフ\\u3099ル\\uABED\\u06CC\\u200D\。\\uDB40\\uDDB6\\uDA42\\uDFCB\\uDB40\\uDD66\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.F", %p)},	undef,	"to_unicode\(\'\\u200D\.F\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.F", %p)},	undef,	"to_unicode\(\'\\u200D\.F\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f", %p)},	"f",	"to_unicode\(\'f\'\)\ \[data\/IdnaTest\.txt\:4214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--9bm.ss", %p)},	"㨲.ss",	"to_unicode\(\'xn\-\-9bm\.ss\'\)\ \[data\/IdnaTest\.txt\:4221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨲.ss", %p)},	"㨲.ss",	"to_unicode\(\'㨲\.ss\'\)\ \[data\/IdnaTest\.txt\:4222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4224\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10E72}\x{0844}｡\x{067F}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE72\\u0844｡\\u067F\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4225\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{10E72}\x{0844}。\x{067F}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE72\\u0844\。\\u067F\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4226\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("⾑ᠼꡋ。\x{10E7B}ᡨ", %p)},	undef,	"to_unicode\(\'⾑ᠼꡋ\。\\uD803\\uDE7Bᡨ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4227\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("襾ᠼꡋ。\x{10E7B}ᡨ", %p)},	undef,	"to_unicode\(\'襾ᠼꡋ\。\\uD803\\uDE7Bᡨ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4228\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{3293B}ς-\x{E0EF9}｡ꡮ-\x{08A4}", %p)},	undef,	"to_unicode\(\'\\uD88A\\uDD3Bς\-\\uDB43\\uDEF9｡ꡮ\-\\u08A4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3293B}ς-\x{E0EF9}。ꡮ-\x{08A4}", %p)},	undef,	"to_unicode\(\'\\uD88A\\uDD3Bς\-\\uDB43\\uDEF9\。ꡮ\-\\u08A4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3293B}Σ-\x{E0EF9}。ꡮ-\x{08A4}", %p)},	undef,	"to_unicode\(\'\\uD88A\\uDD3BΣ\-\\uDB43\\uDEF9\。ꡮ\-\\u08A4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3293B}σ-\x{E0EF9}。ꡮ-\x{08A4}", %p)},	undef,	"to_unicode\(\'\\uD88A\\uDD3Bσ\-\\uDB43\\uDEF9\。ꡮ\-\\u08A4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3293B}Σ-\x{E0EF9}｡ꡮ-\x{08A4}", %p)},	undef,	"to_unicode\(\'\\uD88A\\uDD3BΣ\-\\uDB43\\uDEF9｡ꡮ\-\\u08A4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3293B}σ-\x{E0EF9}｡ꡮ-\x{08A4}", %p)},	undef,	"to_unicode\(\'\\uD88A\\uDD3Bσ\-\\uDB43\\uDEF9｡ꡮ\-\\u08A4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．\x{8A4A6}", %p)},	undef,	"to_unicode\(\'\\u200D．\\uD9E9\\uDCA6\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．\x{8A4A6}", %p)},	undef,	"to_unicode\(\'\\u200D．\\uD9E9\\uDCA6\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.\x{8A4A6}", %p)},	undef,	"to_unicode\(\'\\u200D\.\\uD9E9\\uDCA6\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.\x{8A4A6}", %p)},	undef,	"to_unicode\(\'\\u200D\.\\uD9E9\\uDCA6\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10EA31}\x{DFEE7}｡≠𝟲", %p)},	undef,	"to_unicode\(\'\\uDBFA\\uDE31\\uDB3F\\uDEE7｡\≠𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10EA31}\x{DFEE7}｡=\x{0338}𝟲", %p)},	undef,	"to_unicode\(\'\\uDBFA\\uDE31\\uDB3F\\uDEE7｡\=\\u0338𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10EA31}\x{DFEE7}。≠6", %p)},	undef,	"to_unicode\(\'\\uDBFA\\uDE31\\uDB3F\\uDEE7\。\≠6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10EA31}\x{DFEE7}。=\x{0338}6", %p)},	undef,	"to_unicode\(\'\\uDBFA\\uDE31\\uDB3F\\uDEE7\。\=\\u03386\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A94B}ᢤ\x{200D}.\x{10F3B}", %p)},	undef,	"to_unicode\(\'\\uA94Bᢤ\\u200D\.\\uD803\\uDF3B\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:4243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A94B}ᢤ\x{200D}.\x{10F3B}", %p)},	undef,	"to_unicode\(\'\\uA94Bᢤ\\u200D\.\\uD803\\uDF3B\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:4244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("↕ᡴ\x{10F4B}\x{ABED}．\x{D8323}", %p)},	undef,	"to_unicode\(\'\↕ᡴ\\uD803\\uDF4B\\uABED．\\uDB20\\uDF23\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("↕ᡴ\x{10F4B}\x{ABED}.\x{D8323}", %p)},	undef,	"to_unicode\(\'\↕ᡴ\\uD803\\uDF4B\\uABED\.\\uDB20\\uDF23\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}。\x{108D}\x{200C}≯㇘", %p)},	undef,	"to_unicode\(\'\\u063D\。\\u108D\\u200C\≯㇘\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}。\x{108D}\x{200C}≯㇘", %p)},	undef,	"to_unicode\(\'\\u063D\。\\u108D\\u200C\≯㇘\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063D}。\x{108D}\x{200C}>\x{0338}㇘", %p)},	undef,	"to_unicode\(\'\\u063D\。\\u108D\\u200C\>\\u0338㇘\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4249\]") or ($@ a