# Generated by default/object.tt
package Paws::EKS::LaunchTemplateSpecification;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Version => (is => 'ro', isa => 'Str', request_name => 'version', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::LaunchTemplateSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::LaunchTemplateSpecification object:

  $service_obj->Method(Att1 => { Id => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::LaunchTemplateSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

An object representing a node group launch template specification. The
launch template cannot include C<SubnetId>
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html),
C<IamInstanceProfile>
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html),
C<RequestSpotInstances>
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html),
C<HibernationOptions>
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html),
or C<TerminateInstances>
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html),
or the node group deployment or update will fail. For more information
about launch templates, see C<CreateLaunchTemplate>
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
in the Amazon EC2 API Reference. For more information about using
launch templates with Amazon EKS, see Launch template support
(https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
in the Amazon EKS User Guide.

Specify either C<name> or C<id>, but not both.

=head1 ATTRIBUTES


=head2 Id => Str

The ID of the launch template.


=head2 Name => Str

The name of the launch template.


=head2 Version => Str

The version of the launch template to use. If no version is specified,
then the template's default version is used.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

