package Locales::DB::Territory::naq;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::naq::VERSION = '0.09';

$Locales::DB::Territory::naq::cldr_version = '2.0';

%Locales::DB::Territory::naq::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andorrab',
    'ae'  => "United\ Arab\ Emirates",
    'af'  => 'Afghanistanni',
    'ag'  => "Antiguab\ tsî\ Barbudab",
    'ai'  => 'Anguillab',
    'al'  => 'Albaniab',
    'am'  => 'Armeniab',
    'an'  => "Netherlands\ Antilles",
    'ao'  => 'Angolab',
    'aq'  => 'Antarctica',
    'ar'  => 'Argentinab',
    'as'  => "Americab\ Samoab",
    'at'  => 'Austriab',
    'au'  => 'Australieb',
    'aw'  => 'Arubab',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Azerbaijanni',
    'ba'  => "Bosniab\ tsî\ Herzegovinab",
    'bb'  => 'Barbados',
    'bd'  => 'Banglades',
    'be'  => 'Belgiummi',
    'bf'  => "Burkina\ Fasob",
    'bg'  => 'Bulgariab',
    'bh'  => 'Bahrain',
    'bi'  => 'Burundib',
    'bj'  => 'Benins',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermudas',
    'bn'  => 'Brunei',
    'bo'  => 'Boliviab',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Braziliab',
    'bs'  => 'Bahamas',
    'bt'  => 'Bhutans',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswanab',
    'by'  => 'Belarus',
    'bz'  => 'Belize',
    'ca'  => 'Kanadab',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Democratic\ Republic\ of\ the\ Congo",
    'cf'  => "Central\ African\ Republiki",
    'cg'  => 'Congob',
    'ch'  => 'Switzerlandi',
    'ci'  => 'Ivoorkusi',
    'ck'  => "Cook\ Islands",
    'cl'  => 'Chilib',
    'cm'  => 'Cameroonni',
    'cn'  => 'Chinab',
    'co'  => 'Colombiab',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbiab\ tsî\ Montenegrob",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Cubab',
    'cv'  => "Cape\ Verde\ Islands",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Cyprus',
    'cz'  => "Czech\ Republiki",
    'dd'  => "East\ Germany",
    'de'  => 'Duitslandi',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'Denmarki',
    'dm'  => 'Dominicab',
    'do'  => "Dominican\ Republic",
    'dz'  => 'Algeriab',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ecuadori',
    'ee'  => 'Estoniab',
    'eg'  => 'Egipteb',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eritreab',
    'es'  => 'Spanieb',
    'et'  => 'Ethiopiab',
    'eu'  => "European\ Union",
    'fi'  => 'Finlandi',
    'fj'  => 'Fijib',
    'fk'  => "Falkland\ Islands",
    'fm'  => 'Micronesia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Frankreiki',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gaboni',
    'gb'  => "United\ Kingdom",
    'gd'  => 'Grenada',
    'ge'  => 'Georgiab',
    'gf'  => "French\ Guiana",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghanab',
    'gi'  => 'Gibraltar',
    'gl'  => 'Greenland',
    'gm'  => 'Gambiab',
    'gn'  => 'Guineab',
    'gp'  => 'Guadeloupe',
    'gq'  => "Equatorial\ Guineab",
    'gr'  => 'Xrikelandi',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guinea\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Honduras',
    'hr'  => 'Croatiab',
    'ht'  => 'Haiti',
    'hu'  => 'Hongareieb',
    'ic'  => "Canary\ Islands",
    'id'  => 'Indonesiab',
    'ie'  => 'Irlandi',
    'il'  => 'Israeli',
    'im'  => "Isle\ of\ Man",
    'in'  => 'Indiab',
    'io'  => "British\ Indian\ Ocean\ Territory",
    'iq'  => 'Iraqi',
    'ir'  => 'Iranni',
    'is'  => 'Iceland',
    'it'  => 'Italiab',
    'je'  => 'Jersey',
    'jm'  => 'Jamaicab',
    'jo'  => 'Jordanni',
    'jp'  => 'Japanni',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenyab',
    'kg'  => 'Kyrgyzstanni',
    'kh'  => 'Cambodiab',
    'ki'  => 'Kiribati',
    'km'  => 'Comoros',
    'kn'  => "Saint\ Kitts\ and\ Nevis",
    'kp'  => "Koreab\,\ Noord",
    'kr'  => "Koreab\,\ Suid",
    'kw'  => 'Kuwaiti',
    'ky'  => "Cayman\ Islands",
    'kz'  => 'Kazakhstanni',
    'la'  => 'Laos',
    'lb'  => 'Lebanonni',
    'lc'  => "Saint\ Lucia",
    'li'  => 'Liechtensteinni',
    'lk'  => "Sri\ Lankab",
    'lr'  => 'Liberiab',
    'ls'  => 'Lesothob',
    'lt'  => 'Lithuaniab',
    'lu'  => 'Luxembourgi',
    'lv'  => 'Latvia',
    'ly'  => 'Libyab',
    'ma'  => 'Morocco',
    'mc'  => 'Monaco',
    'md'  => 'Moldova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagascari',
    'mh'  => "Marshall\ Islands",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Macedoniab',
    'ml'  => 'Malib',
    'mm'  => 'Myanmar',
    'mn'  => 'Mongolia',
    'mo'  => 'Macau',
    'mp'  => "Northern\ Mariana\ Islands",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritania',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Maldives',
    'mw'  => 'Malawib',
    'mx'  => 'Mexicob',
    'my'  => 'Malaysiab',
    'mz'  => 'Mozambiki',
    'na'  => 'Namibiab',
    'nc'  => "New\ Caledonia",
    'ne'  => 'Nigeri',
    'nf'  => "Norfolk\ Island",
    'ng'  => 'Nigerieb',
    'ni'  => 'Nicaraguab',
    'nl'  => 'Netherlands',
    'no'  => 'Noorweeb',
    'np'  => 'Nepali',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "New\ Zealandi",
    'om'  => 'Oman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Perub',
    'pf'  => "French\ Polynesia",
    'pg'  => "Papua\ New\ Guineab",
    'ph'  => 'Philippinni',
    'pk'  => 'Pakistanni',
    'pl'  => 'Polandi',
    'pm'  => "Saint\ Pierre\ and\ Miquelon",
    'pn'  => 'Pitcairn',
    'pr'  => "Puerto\ Rico",
    'ps'  => "Palestinian\ West\ Bank\ and\ Gaza",
    'pt'  => 'Portugali',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguaib',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Qatar',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Réunion',
    'ro'  => 'Romania',
    'rs'  => 'Serbia',
    'ru'  => 'Rasiab',
    'rw'  => 'Rwandab',
    'sa'  => "Saudi\ Arabiab",
    'sb'  => "Solomon\ Islands",
    'sc'  => 'Seychelles',
    'sd'  => 'Sudanni',
    'se'  => 'Swedeb',
    'sg'  => 'Singapore',
    'sh'  => "Saint\ Helena",
    'si'  => 'Slovenia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Slovakia',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegali',
    'so'  => 'Somaliab',
    'sr'  => 'Suriname',
    'st'  => "São\ Tomé\ and\ Príncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvadori",
    'sy'  => 'Syriab',
    'sz'  => 'Swazilandi',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ and\ Caicos\ Islands",
    'td'  => 'Chadi',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togob',
    'th'  => 'Thailandi',
    'tj'  => 'Tajikistan',
    'tk'  => 'Tokelau',
    'tl'  => "East\ Timor",
    'tm'  => 'Turkmenistan',
    'tn'  => 'Tunisiab',
    'to'  => 'Tonga',
    'tr'  => 'Turkeieb',
    'tt'  => "Trinidad\ and\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwan',
    'tz'  => 'Tanzaniab',
    'ua'  => 'Ukraine',
    'ug'  => 'Ugandab',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'Amerikab',
    'uy'  => 'Uruguaib',
    'uz'  => 'Uzbekistan',
    'va'  => "Vatican\ State",
    'vc'  => "Saint\ Vincent\ and\ the\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuelab',
    'vg'  => "British\ Virgin\ Islands",
    'vi'  => "U\.S\.\ Virgin\ Islands",
    'vn'  => 'Vietnammi',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ and\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayotte',
    'za'  => "Suid\ Afrikab",
    'zm'  => 'Zambiab',
    'zw'  => 'Zimbabweb',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::naq::name_to_code = (
    'afghanistanni'                             => 'af',
    'africa'                                    => '002',
    'albaniab'                                  => 'al',
    'algeriab'                                  => 'dz',
    'americabsamoab'                            => 'as',
    'americas'                                  => '019',
    'amerikab'                                  => 'us',
    'andorrab'                                  => 'ad',
    'angolab'                                   => 'ao',
    'anguillab'                                 => 'ai',
    'antarctica'                                => 'aq',
    'antiguabtsîbarbudab'                      => 'ag',
    'argentinab'                                => 'ar',
    'armeniab'                                  => 'am',
    'arubab'                                    => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australiaandnewzealand'                    => '053',
    'australieb'                                => 'au',
    'austriab'                                  => 'at',
    'azerbaijanni'                              => 'az',
    'bahamas'                                   => 'bs',
    'bahrain'                                   => 'bh',
    'banglades'                                 => 'bd',
    'barbados'                                  => 'bb',
    'belarus'                                   => 'by',
    'belgiummi'                                 => 'be',
    'belize'                                    => 'bz',
    'benins'                                    => 'bj',
    'bermudas'                                  => 'bm',
    'bhutans'                                   => 'bt',
    'boliviab'                                  => 'bo',
    'bosniabtsîherzegovinab'                   => 'ba',
    'botswanab'                                 => 'bw',
    'bouvetisland'                              => 'bv',
    'braziliab'                                 => 'br',
    'britishantarcticterritory'                 => 'bq',
    'britishindianoceanterritory'               => 'io',
    'britishvirginislands'                      => 'vg',
    'brunei'                                    => 'bn',
    'bulgariab'                                 => 'bg',
    'burkinafasob'                              => 'bf',
    'burundib'                                  => 'bi',
    'cambodiab'                                 => 'kh',
    'cameroonni'                                => 'cm',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'capeverdeislands'                          => 'cv',
    'caribbean'                                 => '029',
    'caymanislands'                             => 'ky',
    'centralafricanrepubliki'                   => 'cf',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'chadi'                                     => 'td',
    'channelislands'                            => 830,
    'chilib'                                    => 'cl',
    'chinab'                                    => 'cn',
    'christmasisland'                           => 'cx',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'colombiab'                                 => 'co',
    'commonwealthofindependentstates'           => 172,
    'comoros'                                   => 'km',
    'congob'                                    => 'cg',
    'cookislands'                               => 'ck',
    'costarica'                                 => 'cr',
    'croatiab'                                  => 'hr',
    'cubab'                                     => 'cu',
    'cyprus'                                    => 'cy',
    'czechoslovakia'                            => 200,
    'czechrepubliki'                            => 'cz',
    'democraticrepublicofthecongo'              => 'cd',
    'denmarki'                                  => 'dk',
    'diegogarcia'                               => 'dg',
    'djibouti'                                  => 'dj',
    'dominicab'                                 => 'dm',
    'dominicanrepublic'                         => 'do',
    'dronningmaudland'                          => 'nq',
    'duitslandi'                                => 'de',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'easttimor'                                 => 'tl',
    'ecuadori'                                  => 'ec',
    'egipteb'                                   => 'eg',
    'elsalvadori'                               => 'sv',
    'equatorialguineab'                         => 'gq',
    'eritreab'                                  => 'er',
    'estoniab'                                  => 'ee',
    'ethiopiab'                                 => 'et',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'falklandislands'                           => 'fk',
    'faroeislands'                              => 'fo',
    'fijib'                                     => 'fj',
    'finlandi'                                  => 'fi',
    'frankreiki'                                => 'fr',
    'frenchguiana'                              => 'gf',
    'frenchpolynesia'                           => 'pf',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'gaboni'                                    => 'ga',
    'gambiab'                                   => 'gm',
    'georgiab'                                  => 'ge',
    'ghanab'                                    => 'gh',
    'gibraltar'                                 => 'gi',
    'greenland'                                 => 'gl',
    'grenada'                                   => 'gd',
    'guadeloupe'                                => 'gp',
    'guam'                                      => 'gu',
    'guatemala'                                 => 'gt',
    'guernsey'                                  => 'gg',
    'guineab'                                   => 'gn',
    'guineabissau'                              => 'gw',
    'guyana'                                    => 'gy',
    'haiti'                                     => 'ht',
    'heardislandandmcdonaldislands'             => 'hm',
    'honduras'                                  => 'hn',
    'hongareieb'                                => 'hu',
    'hongkong'                                  => 'hk',
    'iceland'                                   => 'is',
    'indiab'                                    => 'in',
    'indonesiab'                                => 'id',
    'iranni'                                    => 'ir',
    'iraqi'                                     => 'iq',
    'irlandi'                                   => 'ie',
    'isleofman'                                 => 'im',
    'israeli'                                   => 'il',
    'italiab'                                   => 'it',
    'ivoorkusi'                                 => 'ci',
    'jamaicab'                                  => 'jm',
    'japanni'                                   => 'jp',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'jordanni'                                  => 'jo',
    'kanadab'                                   => 'ca',
    'kazakhstanni'                              => 'kz',
    'kenyab'                                    => 'ke',
    'kiribati'                                  => 'ki',
    "koreab\,noord"                             => 'kp',
    "koreab\,suid"                              => 'kr',
    'kuwaiti'                                   => 'kw',
    'kyrgyzstanni'                              => 'kg',
    'laos'                                      => 'la',
    'latinamerica'                              => 419,
    'latvia'                                    => 'lv',
    'lebanonni'                                 => 'lb',
    'lesothob'                                  => 'ls',
    'liberiab'                                  => 'lr',
    'libyab'                                    => 'ly',
    'liechtensteinni'                           => 'li',
    'lithuaniab'                                => 'lt',
    'luxembourgi'                               => 'lu',
    'macau'                                     => 'mo',
    'macedoniab'                                => 'mk',
    'madagascari'                               => 'mg',
    'malawib'                                   => 'mw',
    'malaysiab'                                 => 'my',
    'maldives'                                  => 'mv',
    'malib'                                     => 'ml',
    'malta'                                     => 'mt',
    'marshallislands'                           => 'mh',
    'martinique'                                => 'mq',
    'mauritania'                                => 'mr',
    'mauritius'                                 => 'mu',
    'mayotte'                                   => 'yt',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'mexicob'                                   => 'mx',
    'micronesia'                                => 'fm',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'moldova'                                   => 'md',
    'monaco'                                    => 'mc',
    'mongolia'                                  => 'mn',
    'montenegro'                                => 'me',
    'montserrat'                                => 'ms',
    'morocco'                                   => 'ma',
    'mozambiki'                                 => 'mz',
    'myanmar'                                   => 'mm',
    'namibiab'                                  => 'na',
    'nauru'                                     => 'nr',
    'nepali'                                    => 'np',
    'netherlands'                               => 'nl',
    'netherlandsantilles'                       => 'an',
    'neutralzone'                               => 'nt',
    'newcaledonia'                              => 'nc',
    'newzealandi'                               => 'nz',
    'nicaraguab'                                => 'ni',
    'nigeri'                                    => 'ne',
    'nigerieb'                                  => 'ng',
    'niue'                                      => 'nu',
    'noorweeb'                                  => 'no',
    'norfolkisland'                             => 'nf',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northernmarianaislands'                    => 'mp',
    'northvietnam'                              => 'vd',
    'oceania'                                   => '009',
    'oman'                                      => 'om',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakistanni'                                => 'pk',
    'palau'                                     => 'pw',
    'palestinianwestbankandgaza'                => 'ps',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papuanewguineab'                           => 'pg',
    'paraguaib'                                 => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'perub'                                     => 'pe',
    'philippinni'                               => 'ph',
    'pitcairn'                                  => 'pn',
    'polandi'                                   => 'pl',
    'polynesia'                                 => '061',
    'portugali'                                 => 'pt',
    'puertorico'                                => 'pr',
    'qatar'                                     => 'qa',
    'rasiab'                                    => 'ru',
    'romania'                                   => 'ro',
    'rwandab'                                   => 'rw',
    'réunion'                                  => 're',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'sainthelena'                               => 'sh',
    'saintkittsandnevis'                        => 'kn',
    'saintlucia'                                => 'lc',
    'saintmartin'                               => 'mf',
    'saintpierreandmiquelon'                    => 'pm',
    'saintvincentandthegrenadines'              => 'vc',
    'samoa'                                     => 'ws',
    'sanmarino'                                 => 'sm',
    'saudiarabiab'                              => 'sa',
    'senegali'                                  => 'sn',
    'serbia'                                    => 'rs',
    'serbiabtsîmontenegrob'                    => 'cs',
    'seychelles'                                => 'sc',
    'sierraleone'                               => 'sl',
    'singapore'                                 => 'sg',
    'slovakia'                                  => 'sk',
    'slovenia'                                  => 'si',
    'solomonislands'                            => 'sb',
    'somaliab'                                  => 'so',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'spanieb'                                   => 'es',
    'srilankab'                                 => 'lk',
    'sudanni'                                   => 'sd',
    'suidafrikab'                               => 'za',
    'suriname'                                  => 'sr',
    'svalbardandjanmayen'                       => 'sj',
    'swazilandi'                                => 'sz',
    'swedeb'                                    => 'se',
    'switzerlandi'                              => 'ch',
    'syriab'                                    => 'sy',
    'sãotoméandpríncipe'                     => 'st',
    'taiwan'                                    => 'tw',
    'tajikistan'                                => 'tj',
    'tanzaniab'                                 => 'tz',
    'thailandi'                                 => 'th',
    'togob'                                     => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinidadandtobago'                         => 'tt',
    'tristandacunha'                            => 'ta',
    'tunisiab'                                  => 'tn',
    'turkeieb'                                  => 'tr',
    'turkmenistan'                              => 'tm',
    'turksandcaicosislands'                     => 'tc',
    'tuvalu'                                    => 'tv',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    "u\.s\.virginislands"                       => 'vi',
    'ugandab'                                   => 'ug',
    'ukraine'                                   => 'ua',
    'unionofsovietsocialistrepublics'           => 'su',
    'unitedarabemirates'                        => 'ae',
    'unitedkingdom'                             => 'gb',
    'unknownregion'                             => 'zz',
    'uruguaib'                                  => 'uy',
    'uzbekistan'                                => 'uz',
    'vanuatu'                                   => 'vu',
    'vaticanstate'                              => 'va',
    'venezuelab'                                => 've',
    'vietnammi'                                 => 'vn',
    'wakeisland'                                => 'wk',
    'wallisandfutuna'                           => 'wf',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'world'                                     => '001',
    'xrikelandi'                                => 'gr',
    'yemen'                                     => 'ye',
    'zambiab'                                   => 'zm',
    'zimbabweb'                                 => 'zw',
    "\Ã\landislands"                         => 'ax',
);

1;

