# Security Policy

## Supported Versions

Please report any vulnerabilities in the latest version of this module, or any version which is
still listed for download on CPAN.  Any version not listed on CPAN is no longer supported.  You
can generally expect the API of new versions to be backward-compatible, so please upgrade if
you find yourself on a vulnerable unsupported version.

Reporting of vulnerabilities in upstream dependencies of this module or downstream dependendents
of this module are appreciated, for discussion purposes, though may or may not warrant a change
to this module.

## Reporting a Vulnerability

Please use the [Security Advisories](https://github.com/nrdvana/perl-Crypt-SecretBuffer/security/advisories)
feature on the GitHub repository.

The author should respond within a few days.

Please include as many details as possible, including code samples or test cases, so that we
can reproduce the issue. Check that your report does not expose any sensitive data, such as
passwords, tokens, or personal information.

Project maintainers will normally credit the reporter when a vulnerability is disclosed or
fixed. If you do not want to be credited publicly, please indicate that in your report.

If you would like any help with triaging the issue, or if the issue is being actively exploited,
or the author hasn't responsed within a few days, please copy the report to the CPAN Security
Group (CPANSec) at cpan-security@security.metacpan.org.

For more information, see Report a Security Issue https://security.metacpan.org/docs/report.html
on the CPANSec website.
