package main;

use 5.006002;

use strict;
use warnings;

use Test::More 0.47;	# The best we can do with Perl 5.6.2.

eval {
    require ExtUtils::Manifest;
    1;
} or plan skip_all => 'Unable to load ExtUtils::Manifest';

eval {
    require Perl::MinimumVersion;
    1;
} or plan skip_all => 'Unable to load Perl::MinimumVersion';

eval {
    require version;
    1;
} or plan skip_all => 'Unable to load version';

use lib qw{ inc };
use My::Module::Meta;

my $min_perl = My::Module::Meta->requires_perl();
my $min_perl_vers = version->parse( $min_perl );

my $manifest = ExtUtils::Manifest::maniread();

my @test;

foreach my $fn ( sort keys %{ $manifest } ) {
    $fn =~ m{ \A xt/ }smx
	and next;
    is_perl( $fn )
	or next;
    my $doc = Perl::MinimumVersion->new( $fn );
    push @test, [ $doc->minimum_version(), 'le', $min_perl,
	"$fn works under Perl $min_perl" ];
    my $ppi_doc = $doc->Document();
    foreach my $inc (
	@{ $ppi_doc->find( 'PPI::Statement::Include' ) || [] } ) {
	my $vers = $inc->version()
	    or next;
	push @test, [ version->parse( $vers ), '==', $min_perl_vers,
	    "$fn has use $min_perl, rather than some other version" ];
	last;
    }
}

plan tests => scalar @test;

foreach ( @test ) {
    my ( $got, $op, $want, $title ) = @{ $_ };
    cmp_ok( $got, $op, $want, $title );
}

sub is_perl {
    my ( $fn ) = @_;
    $fn =~ m/ [.] (?: pm | t | pod | (?i: pl ) ) \z /smx
	and return 1;
    -f $fn
	and -T _
	or return 0;
    open my $fh, '<', $fn
	or return 0;
    local $_ = <$fh>;
    close $fh;
    return m/ perl /smx;
}

1;

# ex: set textwidth=72 :
