package Net::Async::Spotify::API::Generated::Albums;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Albums - Package representing Spotify Albums API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

sub mapping { shift->{mapping} }

=head2 get_an_album

get_an_album - Get an Album

Get Spotify catalog information for a single album.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 path_parameter

=over 4

=item id

Type: string | Required: required
The Spotify ID of the album.

=back

=head3 query_parameter

=over 4

=item market

Type: string | Required: optional
The market you’d like to request. Synonym for country.

=back

and Response Objects being:

- album object


On success, the HTTP status code in the response header is 200 OK and the response body contains an album object in JSON format. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_an_album {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_an_album}{method} // 'GET';
    $request->{uri}    = $mapping->{get_an_album}{uri} // 'https://api.spotify.com/v1/albums/{id}';
    $request->{param}  = $mapping->{get_an_album}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'id' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'market' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_an_album}{response} // [
        'album object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_an_albums_tracks

get_an_albums_tracks - Get an Album's Tracks

Get Spotify catalog information about an album’s tracks.
Optional parameters can be used to limit the number of tracks returned.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 path_parameter

=over 4

=item id

Type: string | Required: required
The Spotify ID of the album.

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The maximum number of tracks to return. Default: 20. Minimum: 1. Maximum: 50.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code or the string from_token.
Provide this parameter if you want to apply Track Relinking.

=item offset

Type: integer | Required: optional
The index of the first track to return. Default: 0 (the first object). Use with limit to get the next set of tracks.

=back

and Response Objects being:

- album object


On success, the HTTP status code in the response header is 200 OK and the response body contains an album object in JSON format. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_an_albums_tracks {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_an_albums_tracks}{method} // 'GET';
    $request->{uri}    = $mapping->{get_an_albums_tracks}{uri} // 'https://api.spotify.com/v1/albums/{id}/tracks';
    $request->{param}  = $mapping->{get_an_albums_tracks}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'id' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_an_albums_tracks}{response} // [
        'album object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_multiple_albums

get_multiple_albums - Get Multiple Albums

Get Spotify catalog information for multiple albums identified by their Spotify IDs.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs for the albums. Maximum: 20 IDs.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code or the string from_token.
Provide this parameter if you want to apply Track Relinking.

=back

and Response Objects being:

- an object
- an object


On success, the HTTP status code in the response header is 200 OK and the response body contains an object whose key is "albums" and whose value is an array of album objects in JSON format.Objects are returned in the order requested. If an object is not found, a null value is returned in the appropriate position. Duplicate ids in the query will result in duplicate objects in the response. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_multiple_albums {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_multiple_albums}{method} // 'GET';
    $request->{uri}    = $mapping->{get_multiple_albums}{uri} // 'https://api.spotify.com/v1/albums';
    $request->{param}  = $mapping->{get_multiple_albums}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_multiple_albums}{response} // [
        'an object',
        'an object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
