use warnings;
use strict;
use InlineX::C2XS qw(c2xs);

print "1..1\n";

my $code = "void include() {}\nvoid __include() {}\nvoid inc_lude() {}\nvoid inc__lude_() {}\n" .
           "void _notinclude() {}\nvoid _not_include() {}\nvoid _not__include() {}\nvoid _notinclude_() {}\n";

c2xs('exports','exports','.',
    {VERSION => 0.1, WRITE_PM => 1, CODE => $code, USE => ['strict'],
     EXPORT_ALL => 1, EXPORT_OK_ALL => 1, EXPORT_TAGS_ALL => 'all'});

if(!unlink('exports.xs')) {
  warn "Unable to remove exports.xs";
}

open RD, '<', 'exports.pm' or warn "Can't open exports.pm for reading: $!";

my $ok;
my @c = <RD>;

if(scalar(@c) == 27)                                                                       {$ok .= 'a'}
else {warn "Wrong number of lines written to exports.pm\n"}

if($c[0]  =~                                    /## This file generated by InlineX::C2XS/) {$ok .= 'b'}
else {warn "0:*$c[0]*\n"}
if($c[1]  eq                                                         "package exports;\n") {$ok .= 'c'}
else {warn "1:*$c[1]*\n"}
if($c[2]  eq                                                              "use strict;\n") {$ok .= 'd'}
else {warn "2:*$c[2]*\n"}
if($c[3]  eq                                                                         "\n") {$ok .= 'e'}
else {warn "3:*$c[3]*\n"}
if($c[4]  eq                                                        "require Exporter;\n") {$ok .= 'f'}
else {warn "4:*$c[4]*\n"}
if($c[5]  eq                                           "*import = \\&Exporter::import;\n") {$ok .= 'g'}
else {warn "5:*$c[5]*\n"}
if($c[6]  eq                                                      "require DynaLoader;\n") {$ok .= 'h'}
else {warn "6:*$c[6]*\n"}
if($c[7]  eq                                                                         "\n") {$ok .= 'i'}
else {warn "7:*$c[7]*\n"}
if($c[8]  eq                                                   "our \$VERSION = '0.1';\n") {$ok .= 'j'}
else {warn "8:*$c[8]*\n"}
if($c[9]  eq                                              "\$VERSION = eval \$VERSION;\n") {$ok .= 'k'}
else {warn "9:*$c[9]*\n"}
if($c[10] eq                               "DynaLoader::bootstrap exports \$VERSION;\n") {$ok .= 'l'}
else {warn "10:*$c[10]*\n"}
if($c[11] eq                                                                         "\n") {$ok .= 'm'}
else {warn "11:*$c[11]*\n"}
if($c[12] eq                                                  "\@exports::EXPORT = qw(\n") {$ok .= 'n'}
else {warn "12:*$c[12]*\n"}
if($c[13] eq                               "    include __include inc_lude inc__lude_ \n") {$ok .= 'o'}
else {warn "13:*$c[13]*\n"}
if($c[14] eq                                                                   "    );\n") {$ok .= 'p'}
else {warn "14:*$c[14]*\n"}
if($c[15] eq                                                                         "\n") {$ok .= 'q'}
else {warn "15:*$c[15]*\n"}
if($c[16] eq                                               "\@exports::EXPORT_OK = qw(\n") {$ok .= 'r'}
else {warn "16:*$c[16]*\n"}
if($c[17] eq                               "    include __include inc_lude inc__lude_ \n") {$ok .= 's'}
else {warn "17:*$c[17]*\n"}
if($c[18] eq                                                                   "    );\n") {$ok .= 't'}
else {warn "18:*$c[18]*\n"}
if($c[19] eq                                                                         "\n") {$ok .= 'u'}
else {warn "19:*$c[19]*\n"}
if($c[20] eq                                    "\%exports::EXPORT_TAGS = (all => [qw(\n") {$ok .= 'v'}
else {warn "20:*$c[20]*\n"}
if($c[21] eq                               "    include __include inc_lude inc__lude_ \n") {$ok .= 'w'}
else {warn "21:*$c[21]*\n"}
if($c[22] eq                                                                 "    )]);\n") {$ok .= 'x'}
else {warn "22:*$c[22]*\n"}
if($c[23] eq                                                                         "\n") {$ok .= 'y'}
else {warn "23:*$c[23]*\n"}
if($c[24] eq "sub dl_load_flags {0} # Prevent DynaLoader from complaining and croaking\n") {$ok .= 'z'}
else {warn "24:*$c[24]*\n"}
if($c[25] eq                                                                         "\n") {$ok .= 'A'}
else {warn "25:*$c[25]*\n"}
if($c[26] eq                                                                       "1;\n") {$ok .= 'B'}
else {warn "26:*$c[26]*\n"}

close RD or warn "Can't close exports.pm after reading: $!";

if(!unlink('exports.pm')) {warn "Unable to remove exports.pm\n"}

if($ok eq 'abcdefghijklmnopqrstuvwxyzAB') {print "ok 1\n"}
else {
  warn "\$ok: $ok\n";
  print "not ok 1\n";
}

