# Generated by default/object.tt
package Paws::NetworkFirewall::RuleDefinition;
  use Moose;
  has Actions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has MatchAttributes => (is => 'ro', isa => 'Paws::NetworkFirewall::MatchAttributes', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RuleDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RuleDefinition object:

  $service_obj->Method(Att1 => { Actions => $value, ..., MatchAttributes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RuleDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->Actions

=head1 DESCRIPTION

The inspection criteria and action for a single stateless rule. AWS
Network Firewall inspects each packet for the specified matching
criteria. When a packet matches the criteria, Network Firewall performs
the rule's actions on the packet.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Actions => ArrayRef[Str|Undef]

The actions to take on a packet that matches one of the stateless rule
definition's match attributes. You must specify a standard action and
you can add custom actions.

Network Firewall only forwards a packet for stateful rule inspection if
you specify C<aws:forward_to_sfe> for a rule that the packet matches,
or if the packet doesn't match any stateless rule and you specify
C<aws:forward_to_sfe> for the C<StatelessDefaultActions> setting for
the FirewallPolicy.

For every rule, you must specify exactly one of the following standard
actions.

=over

=item *

B<aws:pass> - Discontinues all inspection of the packet and permits it
to go to its intended destination.

=item *

B<aws:drop> - Discontinues all inspection of the packet and blocks it
from going to its intended destination.

=item *

B<aws:forward_to_sfe> - Discontinues stateless inspection of the packet
and forwards it to the stateful rule engine for inspection.

=back

Additionally, you can specify a custom action. To do this, you define a
custom action by name and type, then provide the name you've assigned
to the action in this C<Actions> setting. For information about the
options, see CustomAction.

To provide more than one action in this setting, separate the settings
with a comma. For example, if you have a custom C<PublishMetrics>
action that you've named C<MyMetricsAction>, then you could specify the
standard action C<aws:pass> and the custom action with
C<[E<ldquo>aws:passE<rdquo>, E<ldquo>MyMetricsActionE<rdquo>]>.


=head2 B<REQUIRED> MatchAttributes => L<Paws::NetworkFirewall::MatchAttributes>

Criteria for Network Firewall to use to inspect an individual packet in
stateless rule inspection. Each match attributes set can include one or
more items such as IP address, CIDR range, port number, protocol, and
TCP flags.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

