# Generated by default/object.tt
package Paws::IoTWireless::SidewalkListDevice;
  use Moose;
  has AmazonId => (is => 'ro', isa => 'Str');
  has DeviceCertificates => (is => 'ro', isa => 'ArrayRef[Paws::IoTWireless::CertificateList]');
  has SidewalkId => (is => 'ro', isa => 'Str');
  has SidewalkManufacturingSn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::SidewalkListDevice

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::SidewalkListDevice object:

  $service_obj->Method(Att1 => { AmazonId => $value, ..., SidewalkManufacturingSn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::SidewalkListDevice object:

  $result = $service_obj->Method(...);
  $result->Att1->AmazonId

=head1 DESCRIPTION

Sidewalk object used by list functions.

=head1 ATTRIBUTES


=head2 AmazonId => Str

The Sidewalk Amazon ID.


=head2 DeviceCertificates => ArrayRef[L<Paws::IoTWireless::CertificateList>]

The sidewalk device certificates for Ed25519 and P256r1.


=head2 SidewalkId => Str

The sidewalk device identification.


=head2 SidewalkManufacturingSn => Str

The Sidewalk manufacturing series number.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

