## Checks for large file support ##
include(CheckIncludeFile)
include(CheckSymbolExists)
include(CheckTypeSize)

macro(check_lfs _isenable)
  set(LFS_OFF_T "")
  set(LFS_FOPEN "")
  set(LFS_FSEEK "")
  set(LFS_FTELL "")
  set(LFS_PRID "")

  if(${_isenable})
    set(SAFE_CMAKE_REQUIRED_DEFINITIONS "${CMAKE_REQUIRED_DEFINITIONS}")
    set(CMAKE_REQUIRED_DEFINITIONS ${CMAKE_REQUIRED_DEFINITIONS}
        -D_LARGEFILE_SOURCE -D_LARGE_FILES -D_FILE_OFFSET_BITS=64
        -D__STDC_LIMIT_MACROS -D__STDC_CONSTANT_MACROS -D__STDC_FORMAT_MACROS)

    check_include_file("sys/types.h" HAVE_SYS_TYPES_H)
    check_include_file("inttypes.h" HAVE_INTTYPES_H)
    check_include_file("stddef.h" HAVE_STDDEF_H)
    check_include_file("stdint.h" HAVE_STDINT_H)

    # LFS type1: 8 <= sizeof(off_t), fseeko, ftello
    check_type_size("off_t" SIZEOF_OFF_T)
    if(SIZEOF_OFF_T GREATER 7)
      check_symbol_exists("fseeko" "stdio.h" HAVE_FSEEKO)
      check_symbol_exists("ftello" "stdio.h" HAVE_FTELLO)
      if(HAVE_FSEEKO AND HAVE_FTELLO)
        set(LFS_OFF_T "off_t")
        set(LFS_FOPEN "fopen")
        set(LFS_FSEEK "fseeko")
        set(LFS_FTELL "ftello")
        check_symbol_exists("PRIdMAX" "inttypes.h" HAVE_PRIDMAX)
        if(HAVE_PRIDMAX)
          set(LFS_PRID "PRIdMAX")
        else(HAVE_PRIDMAX)
          check_type_size("long" SIZEOF_LONG)
          check_type_size("int" SIZEOF_INT)
          if(SIZEOF_OFF_T GREATER SIZEOF_LONG)
            set(LFS_PRID "\"lld\"")
          elseif(SIZEOF_LONG GREATER SIZEOF_INT)
            set(LFS_PRID "\"ld\"")
          else(SIZEOF_OFF_T GREATER SIZEOF_LONG)
            set(LFS_PRID "\"d\"")
          endif(SIZEOF_OFF_T GREATER SIZEOF_LONG)
        endif(HAVE_PRIDMAX)
      endif(HAVE_FSEEKO AND HAVE_FTELLO)
    endif(SIZEOF_OFF_T GREATER 7)

    # LFS type2: 8 <= sizeof(off64_t), fopen64, fseeko64, ftello64
    if(NOT LFS_OFF_T)
      check_type_size("off64_t" SIZEOF_OFF64_T)
      if(SIZEOF_OFF64_T GREATER 7)
        check_symbol_exists("fopen64" "stdio.h" HAVE_FOPEN64)
        check_symbol_exists("fseeko64" "stdio.h" HAVE_FSEEKO64)
        check_symbol_exists("ftello64" "stdio.h" HAVE_FTELLO64)
        if(HAVE_FOPEN64 AND HAVE_FSEEKO64 AND HAVE_FTELLO64)
          set(LFS_OFF_T "off64_t")
          set(LFS_FOPEN "fopen64")
          set(LFS_FSEEK "fseeko64")
          set(LFS_FTELL "ftello64")
          check_symbol_exists("PRIdMAX" "inttypes.h" HAVE_PRIDMAX)
          if(HAVE_PRIDMAX)
            set(LFS_PRID "PRIdMAX")
          else(HAVE_PRIDMAX)
            check_type_size("long" SIZEOF_LONG)
            check_type_size("int" SIZEOF_INT)
            if(SIZEOF_OFF64_T GREATER SIZEOF_LONG)
              set(LFS_PRID "\"lld\"")
            elseif(SIZEOF_LONG GREATER SIZEOF_INT)
              set(LFS_PRID "\"ld\"")
            else(SIZEOF_OFF64_T GREATER SIZEOF_LONG)
              set(LFS_PRID "\"d\"")
            endif(SIZEOF_OFF64_T GREATER SIZEOF_LONG)
          endif(HAVE_PRIDMAX)
        endif(HAVE_FOPEN64 AND HAVE_FSEEKO64 AND HAVE_FTELLO64)
      endif(SIZEOF_OFF64_T GREATER 7)
    endif(NOT LFS_OFF_T)

    # LFS type3: 8 <= sizeof(__int64), _fseeki64, _ftelli64
    if(NOT LFS_OFF_T)
      check_type_size("__int64" SIZEOF___INT64)
      if(SIZEOF___INT64 GREATER 7)
        check_symbol_exists("_fseeki64" "stdio.h" HAVE__FSEEKI64)
        check_symbol_exists("_ftelli64" "stdio.h" HAVE__FTELLI64)
        if(HAVE__FSEEKI64 AND HAVE__FTELLI64)
          set(LFS_OFF_T "__int64")
          set(LFS_FOPEN "fopen")
          set(LFS_FSEEK "_fseeki64")
          set(LFS_FTELL "_ftelli64")
          set(LFS_PRID  "\"I64d\"")
        endif(HAVE__FSEEKI64 AND HAVE__FTELLI64)
      endif(SIZEOF___INT64 GREATER 7)
    endif(NOT LFS_OFF_T)

    set(CMAKE_REQUIRED_DEFINITIONS "${SAFE_CMAKE_REQUIRED_DEFINITIONS}")
  endif(${_isenable})

  if(NOT LFS_OFF_T)
    ## not found
    set(LFS_OFF_T "long")
    set(LFS_FOPEN "fopen")
    set(LFS_FSEEK "fseek")
    set(LFS_FTELL "ftell")
    set(LFS_PRID  "\"ld\"")
  endif(NOT LFS_OFF_T)

endmacro(check_lfs)
