package Net::Stripe::Charge;
use Moose;
use methods;
extends 'Net::Stripe::Resource';

has 'id'          => (is => 'ro', isa => 'Maybe[Str]');
has 'created'     => (is => 'ro', isa => 'Maybe[Int]');
has 'fee'         => (is => 'ro', isa => 'Maybe[Int]');
has 'amount'      => (is => 'ro', isa => 'Maybe[Int]', required => 1);
has 'currency'    => (is => 'ro', isa => 'Maybe[Str]', required => 1);
has 'customer'    => (is => 'ro', isa => 'Maybe[Str]');
has 'card'        => (is => 'ro', isa => 'Maybe[StripeCard]');
has 'description' => (is => 'ro', isa => 'Maybe[Str]');
has 'livemode'    => (is => 'ro', isa => 'Maybe[Bool]');
has 'paid'        => (is => 'ro', isa => 'Maybe[Bool]');
has 'refunded'    => (is => 'ro', isa => 'Maybe[Bool]');
has 'amount_refunded' => (is => 'ro', isa => 'Maybe[Int]');

method form_fields {
    return (
        $self->fields_for('card'),
        map { $_ => $self->$_ }
            grep { defined $self->$_ }
                qw/amount currency customer description/
    );
}

=head1 NAME

Net::Stripe::Charge

=head1 SEE ALSO

L<https://stripe.com>, L<https://stripe.com/docs/api>

=head1 AUTHORS

Luke Closs

=head1 LICENSE

Net-Stripe is Copyright 2011 Prime Radiant, Inc.
Net-Stripe is distributed under the same terms as Perl itself.

=cut


__PACKAGE__->meta->make_immutable;
1;
