package Google::Ads::AdWords::v201109::ServicedAccountSelector;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %customerIds_of :ATTR(:get<customerIds>);
my %enablePaging_of :ATTR(:get<enablePaging>);
my %submanagersOnly_of :ATTR(:get<submanagersOnly>);

__PACKAGE__->_factory(
    [ qw(        customerIds
        enablePaging
        submanagersOnly

    ) ],
    {
        'customerIds' => \%customerIds_of,
        'enablePaging' => \%enablePaging_of,
        'submanagersOnly' => \%submanagersOnly_of,
    },
    {
        'customerIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'enablePaging' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'submanagersOnly' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'customerIds' => 'customerIds',
        'enablePaging' => 'enablePaging',
        'submanagersOnly' => 'submanagersOnly',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::ServicedAccountSelector

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ServicedAccountSelector from the namespace https://adwords.google.com/api/adwords/mcm/v201109.

Selector for querying the ServicedAccount graph. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * customerIds


=item * enablePaging


=item * submanagersOnly




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::ServicedAccountSelector
   customerIds =>  $some_value, # long
   enablePaging =>  $some_value, # boolean
   submanagersOnly =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

