/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.json.Types;

public class EnumCoercer<T extends Enum>
extends TypeCoercer<T> {
    @Override
    public boolean test(Class<?> aClass) {
        return aClass.isEnum();
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type type) {
        Class<?> aClass = Types.narrow(type);
        if (!aClass.isEnum()) {
            throw new JsonException("Type was not an enum: " + type);
        }
        return (jsonInput, setting) -> {
            String value = jsonInput.nextString();
            for (Object constant : aClass.getEnumConstants()) {
                if (!constant.toString().equalsIgnoreCase(value)) continue;
                return (Enum)constant;
            }
            throw new JsonException(String.format("Unable to find matching enum value for %s in %s", value, aClass));
        };
    }
}

