/*                                                                
**  Copyright (C) 1996,2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* plist.c
**/


#include <unistd.h>
#include <stdlib.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

int
main(int argc, char *argv[])
{
  paramfile pfile;

  if ( argc == 1 ) {
    fprintf(stderr, "plist: no paramfiles to list\n");
    exit(1);
  }

  for ( argv++; argc-- >= 2; argv++ ) {
    if ( (pfile = paramopen(*argv, NULL, 0, "rH")) == NULL ) {
      fprintf(stderr, "plist: can't open parameter file: %s\n", *argv);
      exit(1);
    }
    
    paramlist(pfile);
    paramclose(pfile);
  }

  return 0;
}

