#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ListingDurationCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingDurationCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ListingDurationCodeType

=head1 DESCRIPTION

Applications should not depend on the completeness of ListingDurationCodeType.
GetCategoryFeatures will return the complete list of listing durations.
Each code in this code list specifies a number of days that a listing can be
active (i.e., available for bidding/buying). The validity of a code
depends on the listing type.
Call GetCategoryFeatures to determine which listing formats
support each duration for the site you are using.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Days_1

1 Day - A seller must have a positive feedback rating of 10 or
more or must be ID Verified to use the 1-day listing duration on the US
site. Typically applicable for Chinese and Dutch auction formats (including Real
Estate) and Personal Offer (Second Chance Offer).
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_1 => scalar('Days_1');


=head2 Days_3

3 Days - Typically applicable to Chinese, Dutch, and Live auction formats
(including Real Estate); Personal Offer (Second Chance Offer); and Basic
Fixed-Price format.
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_3 => scalar('Days_3');


=head2 Days_5

5 Days - Typically applicable to Chinese, Dutch, and Live auction formats
(including Real Estate); Personal Offer (Second Chance Offer); and Basic
Fixed-Price format.
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_5 => scalar('Days_5');


=head2 Days_7

7 Days - Typically applicable to Chinese, Dutch, and Live auction formats
(including Real Estate); Personal Offer (Second Chance Offer); and Basic
Fixed-Price format.
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_7 => scalar('Days_7');


=head2 Days_10

10 Days - Subject to an additional listing upgrade fee.
Typically applicable to Chinese, Dutch, and Live auction formats
(including Real Estate) and Basic Fixed-Price format.
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_10 => scalar('Days_10');


=head2 Days_14

14 Days - Subject to an additional listing upgrade fee.
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_14 => scalar('Days_14');


=head2 Days_21

=cut


use constant Days_21 => scalar('Days_21');


=head2 Days_30

30 Days - Typically applicable to Real Estate Ad format and Store Inventory
format. Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_30 => scalar('Days_30');


=head2 Days_60

Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_60 => scalar('Days_60');


=head2 Days_90

90 Days - Typically applicable to Real Estate Ad format.
Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_90 => scalar('Days_90');


=head2 Days_120

(in/out)	Call GetCategoryFeatures to determine which listing formats
support this duration for the site you are using.



=cut


use constant Days_120 => scalar('Days_120');


=head2 GTC

GTC  - Relist automatically every 30 days until all the items sell
or the seller ends the listing. Typically applicable to Store Inventory format
and Half.com listings. This duration is not applicable to AdFormat listing type.					Call GetCategoryFeatures to determine which listing formats support this duration for the site you are using.



=cut


use constant GTC => scalar('GTC');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
