/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grokkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import opennlp.common.Pipeline;
import opennlp.common.PipelineException;
import opennlp.common.parse.LexException;
import opennlp.common.parse.ParseException;
import opennlp.common.parse.RuleGroup;
import opennlp.grok.io.RuleReader;
import opennlp.grok.lexicon.LMRLexicon;
import opennlp.grok.parse.CKY;
import opennlp.grokkit.grokkit;

class grokkit_inputText_ActionAdapter
implements ActionListener {
    grokkit adaptee;

    grokkit_inputText_ActionAdapter(grokkit adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        this.adaptee.status.setText("Status: Parsing");
        String[] ppLinks = new String[]{};
        ppLinks = this.adaptee.PPLinks.toArray(ppLinks);
        if (this.adaptee.grammar_file.equals("")) {
            this.adaptee.grammar_file = this.adaptee.grokHome + "/samples/grammar/simple.gram";
        }
        File f = new File(this.adaptee.grammar_file);
        try {
            this.adaptee.loadGrammar(f.toURL());
        }
        catch (MalformedURLException w) {
            this.adaptee.display(w);
        }
        catch (IOException i) {
            this.adaptee.display(i);
        }
        this.adaptee._lexicon = new LMRLexicon(this.adaptee._grammarInfo);
        RuleGroup rules = RuleReader.getRules(this.adaptee._grammarInfo.getProperty("rules"));
        this.adaptee._parser = new CKY(this.adaptee._lexicon, rules);
        try {
            this.adaptee._pipeline = new Pipeline(ppLinks);
            String[] sa = this.adaptee.grokAndReturnStrings(this.adaptee.inputText.getText());
            ArrayList st = this.adaptee.grokAndReturnSigns(this.adaptee.inputText.getText());
            this.adaptee.NLPText.setContent(st);
            int resLength = sa.length;
            switch (resLength) {
                case 0: {
                    break;
                }
                case 1: {
                    this.adaptee.plainText.setText(resLength + " parse found.");
                    break;
                }
                default: {
                    this.adaptee.plainText.setText(resLength + " parses found.");
                }
            }
            String flat = new String();
            int i = 0;
            while (i < resLength) {
                flat = flat + sa[i] + " ";
                ++i;
            }
            this.adaptee.plainText.setText(flat);
        }
        catch (PipelineException n) {
            this.adaptee.display((Exception)((Object)n));
        }
        catch (IOException i) {
            this.adaptee.display(i);
        }
        catch (ParseException o) {
            this.adaptee.display((Exception)((Object)o));
        }
        catch (LexException p) {
            this.adaptee.display((Exception)((Object)p));
        }
        this.adaptee.status.setText("Status: Finished Parsing");
    }
}

