#!/bin/bash

tooldir=`dirname "$0"`
PDT20_DATA=/home/thc/data/pdt25
VALLEX_DATA=/home/thc/data/vallex

if [ ! -d "$PDT20_DATA/" ] || [ ! -d "$VALLEX_DATA/" ]; then
    (    echo "One of the following directories was not found, aborting!"
	echo "PDT20_DATA=$PDT20_DATA"
	echo "VALLEX_DATA=$VALLEX_DATA"
    ) >&2
    exit 1
fi

resource_dir="$tooldir/resources/pdt2base:$PDT20_DATA/resources:$tooldir/../resources:"
#resource_dir="$PDT20_DATA/resources"
pdt_data_dir="$PDT20_DATA/data"

vallex_pml="$VALLEX_DATA"/vallex_*.pml
start=''


$start btred -qI "$tooldir/pml2base.btred" \
    --resource-dir "$resource_dir": \
    -o "$@" \
    --data-dir "$pdt_data_dir" \
    -- -l "$PDT20_DATA/adata.fl"

