#!/usr/bin/perl

use strict;
use warnings;

use FindBin;
use File::Spec;
use File::Path qw(make_path);
use lib (glob(File::Spec->catfile(${FindBin::RealBin},'..','..','libs','*','')));
use Tree_Query::Common;

use Getopt::Long;
Getopt::Long::Configure ("bundling");
my %opts;
GetOptions(\%opts,
   'file|f=s',
   'output-dir|D=s',
   'stdout',
);

BEGIN {
  Treex::PML::AddResourcePath( File::Spec->catfile(${FindBin::RealBin},'..','..','resources') );
}

$opts{file}||=shift; 

die "Input file not specified or doesn't exists\n" unless ($opts{file} and -r $opts{file});

my $doc = Treex::PML::Factory->createDocumentFromFile($opts{file}); 

die "Can't open '$opts{file}'\n" unless $doc;

if ($opts{'output-dir'})
{
  $opts{'output-dir'} = File::Spec->rel2abs($opts{'output-dir'});
  make_path($opts{'output-dir'}) or die "Can't create output dir!\n"
    unless (-d $opts{'output-dir'});
}

$opts{stdout}=1 unless $opts{'output-dir'};

binmode STDOUT, ":utf8";
$\ = "\n";

for my $tree ($doc->trees) {
  my $id = $tree->attr('id');

  next unless $id;

  my $query = Tree_Query::Common::as_text($tree);
  if ($opts{'output-dir'})
  {
    open (FILE, '>:utf8', File::Spec->catfile($opts{'output-dir'}, $id . '.tq' )) or die $!;
    print FILE $query;
    close FILE;
  }
  
  print $query if ($opts{stdout});
}

__END__

=head1 NAME

pml2query.pl

=head1 SYNOPSIS



=head1 DESCRIPTION

Stub documentation for pml2query.pl, 
created by Padre::Tepmlate.

It looks like the author of this script was negligent 
enough to leave the stub unedited.

=head1 AUTHOR

Michal Sedlák

=head1 COPYRIGHT AND LICENSE

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.2 or,
at your option, any later version of Perl 5 you may have available.

=cut