# Generated by default/object.tt
package Paws::ImageBuilder::AdditionalInstanceConfiguration;
  use Moose;
  has SystemsManagerAgent => (is => 'ro', isa => 'Paws::ImageBuilder::SystemsManagerAgent', request_name => 'systemsManagerAgent', traits => ['NameInRequest']);
  has UserDataOverride => (is => 'ro', isa => 'Str', request_name => 'userDataOverride', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::AdditionalInstanceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::AdditionalInstanceConfiguration object:

  $service_obj->Method(Att1 => { SystemsManagerAgent => $value, ..., UserDataOverride => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::AdditionalInstanceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->SystemsManagerAgent

=head1 DESCRIPTION

In addition to your infrastruction configuration, these settings
provide an extra layer of control over your build instances. For
instances where Image Builder installs the SSM agent, you can choose
whether to keep it for the AMI that you create. You can also specify
commands to run on launch for all of your build instances.

=head1 ATTRIBUTES


=head2 SystemsManagerAgent => L<Paws::ImageBuilder::SystemsManagerAgent>

Contains settings for the SSM agent on your build instance.


=head2 UserDataOverride => Str

Use this property to provide commands or a command script to run when
you launch your build instance.

The userDataOverride property replaces any commands that Image Builder
might have added to ensure that SSM is installed on your Linux build
instance. If you override the user data, make sure that you add
commands to install SSM, if it is not pre-installed on your source
image.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

